/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.language;

import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.StringEncoderAbstractTest;
import org.apache.commons.codec.language.Caverphone1;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class Caverphone1Test
extends StringEncoderAbstractTest<Caverphone1> {
    @Override
    protected Caverphone1 createStringEncoder() {
        return new Caverphone1();
    }

    @Test
    public void testCaverphoneRevisitedCommonCodeAT1111() throws EncoderException {
        this.checkEncodingVariations("AT1111", new String[]{"add", "aid", "at", "art", "eat", "earth", "head", "hit", "hot", "hold", "hard", "heart", "it", "out", "old"});
    }

    @Test
    public void testEndMb() throws EncoderException {
        String[][] data = new String[][]{{"mb", "M11111"}, {"mbmb", "MPM111"}};
        this.checkEncodings(data);
    }

    @Test
    public void testIsCaverphoneEquals() throws EncoderException {
        Caverphone1 caverphone = new Caverphone1();
        Assertions.assertFalse((boolean)caverphone.isEncodeEqual("Peter", "Stevenson"), (String)"Caverphone encodings should not be equal");
        Assertions.assertTrue((boolean)caverphone.isEncodeEqual("Peter", "Peady"), (String)"Caverphone encodings should be equal");
    }

    @Test
    public void testSpecificationV1Examples() throws EncoderException {
        String[][] data = new String[][]{{"David", "TFT111"}, {"Whittle", "WTL111"}};
        this.checkEncodings(data);
    }

    @Test
    public void testWikipediaExamples() throws EncoderException {
        String[][] data = new String[][]{{"Lee", "L11111"}, {"Thompson", "TMPSN1"}};
        this.checkEncodings(data);
    }
}

