/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.digest;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.stream.Stream;
import org.apache.commons.codec.digest.XXHash32;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class XXHash32Test {
    private File file;
    private String expectedChecksum;

    public void initData(String path, String c) throws IOException {
        URL url = XXHash32Test.class.getClassLoader().getResource(path);
        if (url == null) {
            throw new FileNotFoundException("couldn't find " + path);
        }
        URI uri = null;
        try {
            uri = url.toURI();
        }
        catch (URISyntaxException ex) {
            throw new IOException(ex);
        }
        this.file = new File(uri);
        this.expectedChecksum = c;
    }

    public static Stream<Arguments> data() {
        return Stream.of(Arguments.of((Object[])new Object[]{"org/apache/commons/codec/bla.tar", "fbb5c8d1"}), Arguments.of((Object[])new Object[]{"org/apache/commons/codec/bla.tar.xz", "4106a208"}), Arguments.of((Object[])new Object[]{"org/apache/commons/codec/small.bin", "f66c26f8"}));
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void verifyChecksum(String path, String c) throws IOException {
        this.initData(path, c);
        XXHash32 h = new XXHash32();
        try (FileInputStream s = new FileInputStream(this.file);){
            byte[] b = XXHash32Test.toByteArray(s);
            h.update(b, 0, b.length);
        }
        Assertions.assertEquals((Object)this.expectedChecksum, (Object)Long.toHexString(h.getValue()), (String)("checksum for " + this.file.getName()));
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void verifyIncrementalChecksum(String path, String c) throws IOException {
        this.initData(path, c);
        XXHash32 h = new XXHash32();
        try (FileInputStream s = new FileInputStream(this.file);){
            byte[] b = XXHash32Test.toByteArray(s);
            h.update((int)b[0]);
            h.reset();
            h.update((int)b[0]);
            h.update(b, 1, b.length - 2);
            h.update(b, b.length - 1, 1);
            h.update(b, 0, -1);
        }
        Assertions.assertEquals((Object)this.expectedChecksum, (Object)Long.toHexString(h.getValue()), (String)("checksum for " + this.file.getName()));
    }

    private static byte[] toByteArray(InputStream input) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        XXHash32Test.copy(input, output, 10240);
        return output.toByteArray();
    }

    private static long copy(InputStream input, OutputStream output, int bufferSize) throws IOException {
        byte[] buffer = new byte[bufferSize];
        int n = 0;
        long count = 0L;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }
}

