/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.net;

import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.net.URLCodec;
import org.junit.Assert;
import org.junit.Test;

public class URLCodecTest {
    static final int[] SWISS_GERMAN_STUFF_UNICODE = new int[]{71, 114, 252, 101, 122, 105, 95, 122, 228, 109, 228};
    static final int[] RUSSIAN_STUFF_UNICODE = new int[]{1042, 1089, 1077, 1084, 95, 1087, 1088, 1080, 1074, 1077, 1090};

    private void validateState(URLCodec urlCodec) {
    }

    private String constructString(int[] unicodeChars) {
        StringBuilder buffer = new StringBuilder();
        if (unicodeChars != null) {
            for (int unicodeChar : unicodeChars) {
                buffer.append((char)unicodeChar);
            }
        }
        return buffer.toString();
    }

    @Test
    public void testUTF8RoundTrip() throws Exception {
        String ru_msg = this.constructString(RUSSIAN_STUFF_UNICODE);
        String ch_msg = this.constructString(SWISS_GERMAN_STUFF_UNICODE);
        URLCodec urlCodec = new URLCodec();
        this.validateState(urlCodec);
        Assert.assertEquals((Object)"%D0%92%D1%81%D0%B5%D0%BC_%D0%BF%D1%80%D0%B8%D0%B2%D0%B5%D1%82", (Object)urlCodec.encode(ru_msg, "UTF-8"));
        Assert.assertEquals((Object)"Gr%C3%BCezi_z%C3%A4m%C3%A4", (Object)urlCodec.encode(ch_msg, "UTF-8"));
        Assert.assertEquals((Object)ru_msg, (Object)urlCodec.decode(urlCodec.encode(ru_msg, "UTF-8"), "UTF-8"));
        Assert.assertEquals((Object)ch_msg, (Object)urlCodec.decode(urlCodec.encode(ch_msg, "UTF-8"), "UTF-8"));
        this.validateState(urlCodec);
    }

    @Test
    public void testBasicEncodeDecode() throws Exception {
        URLCodec urlCodec = new URLCodec();
        String plain = "Hello there!";
        String encoded = urlCodec.encode("Hello there!");
        Assert.assertEquals((String)"Basic URL encoding test", (Object)"Hello+there%21", (Object)encoded);
        Assert.assertEquals((String)"Basic URL decoding test", (Object)"Hello there!", (Object)urlCodec.decode(encoded));
        this.validateState(urlCodec);
    }

    @Test
    public void testSafeCharEncodeDecode() throws Exception {
        URLCodec urlCodec = new URLCodec();
        String plain = "abc123_-.*";
        String encoded = urlCodec.encode("abc123_-.*");
        Assert.assertEquals((String)"Safe chars URL encoding test", (Object)"abc123_-.*", (Object)encoded);
        Assert.assertEquals((String)"Safe chars URL decoding test", (Object)"abc123_-.*", (Object)urlCodec.decode(encoded));
        this.validateState(urlCodec);
    }

    @Test
    public void testUnsafeEncodeDecode() throws Exception {
        URLCodec urlCodec = new URLCodec();
        String plain = "~!@#$%^&()+{}\"\\;:`,/[]";
        String encoded = urlCodec.encode("~!@#$%^&()+{}\"\\;:`,/[]");
        Assert.assertEquals((String)"Unsafe chars URL encoding test", (Object)"%7E%21%40%23%24%25%5E%26%28%29%2B%7B%7D%22%5C%3B%3A%60%2C%2F%5B%5D", (Object)encoded);
        Assert.assertEquals((String)"Unsafe chars URL decoding test", (Object)"~!@#$%^&()+{}\"\\;:`,/[]", (Object)urlCodec.decode(encoded));
        this.validateState(urlCodec);
    }

    @Test
    public void testEncodeDecodeNull() throws Exception {
        URLCodec urlCodec = new URLCodec();
        Assert.assertNull((String)"Null string URL encoding test", (Object)urlCodec.encode((String)null));
        Assert.assertNull((String)"Null string URL decoding test", (Object)urlCodec.decode((String)null));
        this.validateState(urlCodec);
    }

    @Test
    public void testDecodeInvalid() throws Exception {
        URLCodec urlCodec = new URLCodec();
        try {
            urlCodec.decode("%");
            Assert.fail((String)"DecoderException should have been thrown");
        }
        catch (DecoderException decoderException) {
            // empty catch block
        }
        try {
            urlCodec.decode("%A");
            Assert.fail((String)"DecoderException should have been thrown");
        }
        catch (DecoderException decoderException) {
            // empty catch block
        }
        try {
            urlCodec.decode("%WW");
            Assert.fail((String)"DecoderException should have been thrown");
        }
        catch (DecoderException decoderException) {
            // empty catch block
        }
        try {
            urlCodec.decode("%0W");
            Assert.fail((String)"DecoderException should have been thrown");
        }
        catch (DecoderException decoderException) {
            // empty catch block
        }
        this.validateState(urlCodec);
    }

    @Test
    public void testDecodeInvalidContent() throws UnsupportedEncodingException, DecoderException {
        String ch_msg = this.constructString(SWISS_GERMAN_STUFF_UNICODE);
        URLCodec urlCodec = new URLCodec();
        byte[] input = ch_msg.getBytes("ISO-8859-1");
        byte[] output = urlCodec.decode(input);
        Assert.assertEquals((long)input.length, (long)output.length);
        for (int i = 0; i < input.length; ++i) {
            Assert.assertEquals((long)input[i], (long)output[i]);
        }
        this.validateState(urlCodec);
    }

    @Test
    public void testEncodeNull() throws Exception {
        URLCodec urlCodec = new URLCodec();
        byte[] plain = null;
        byte[] encoded = urlCodec.encode(plain);
        Assert.assertEquals((String)"Encoding a null string should return null", null, (Object)encoded);
        this.validateState(urlCodec);
    }

    @Test
    public void testEncodeUrlWithNullBitSet() throws Exception {
        URLCodec urlCodec = new URLCodec();
        String plain = "Hello there!";
        String encoded = new String(URLCodec.encodeUrl(null, (byte[])"Hello there!".getBytes(StandardCharsets.UTF_8)));
        Assert.assertEquals((String)"Basic URL encoding test", (Object)"Hello+there%21", (Object)encoded);
        Assert.assertEquals((String)"Basic URL decoding test", (Object)"Hello there!", (Object)urlCodec.decode(encoded));
        this.validateState(urlCodec);
    }

    @Test
    public void testDecodeWithNullArray() throws Exception {
        byte[] plain = null;
        byte[] result = URLCodec.decodeUrl(plain);
        Assert.assertEquals((String)"Result should be null", null, (Object)result);
    }

    @Test
    public void testEncodeStringWithNull() throws Exception {
        URLCodec urlCodec = new URLCodec();
        String test = null;
        String result = urlCodec.encode(test, "charset");
        Assert.assertEquals((String)"Result should be null", null, (Object)result);
    }

    @Test
    public void testDecodeStringWithNull() throws Exception {
        URLCodec urlCodec = new URLCodec();
        String test = null;
        String result = urlCodec.decode(test, "charset");
        Assert.assertEquals((String)"Result should be null", null, (Object)result);
    }

    @Test
    public void testEncodeObjects() throws Exception {
        URLCodec urlCodec = new URLCodec();
        String plain = "Hello there!";
        String encoded = (String)urlCodec.encode((Object)"Hello there!");
        Assert.assertEquals((String)"Basic URL encoding test", (Object)"Hello+there%21", (Object)encoded);
        byte[] plainBA = "Hello there!".getBytes(StandardCharsets.UTF_8);
        byte[] encodedBA = (byte[])urlCodec.encode((Object)plainBA);
        encoded = new String(encodedBA);
        Assert.assertEquals((String)"Basic URL encoding test", (Object)"Hello+there%21", (Object)encoded);
        Object result = urlCodec.encode(null);
        Assert.assertEquals((String)"Encoding a null Object should return null", null, (Object)result);
        try {
            Double dObj = 3.0;
            urlCodec.encode((Object)dObj);
            Assert.fail((String)"Trying to url encode a Double object should cause an exception.");
        }
        catch (EncoderException encoderException) {
            // empty catch block
        }
        this.validateState(urlCodec);
    }

    @Test
    public void testInvalidEncoding() {
        URLCodec urlCodec = new URLCodec("NONSENSE");
        String plain = "Hello there!";
        try {
            urlCodec.encode("Hello there!");
            Assert.fail((String)"We set the encoding to a bogus NONSENSE vlaue, this shouldn't have worked.");
        }
        catch (EncoderException encoderException) {
            // empty catch block
        }
        try {
            urlCodec.decode("Hello there!");
            Assert.fail((String)"We set the encoding to a bogus NONSENSE vlaue, this shouldn't have worked.");
        }
        catch (DecoderException decoderException) {
            // empty catch block
        }
        this.validateState(urlCodec);
    }

    @Test
    public void testDecodeObjects() throws Exception {
        URLCodec urlCodec = new URLCodec();
        String plain = "Hello+there%21";
        String decoded = (String)urlCodec.decode((Object)"Hello+there%21");
        Assert.assertEquals((String)"Basic URL decoding test", (Object)"Hello there!", (Object)decoded);
        byte[] plainBA = "Hello+there%21".getBytes(StandardCharsets.UTF_8);
        byte[] decodedBA = (byte[])urlCodec.decode((Object)plainBA);
        decoded = new String(decodedBA);
        Assert.assertEquals((String)"Basic URL decoding test", (Object)"Hello there!", (Object)decoded);
        Object result = urlCodec.decode(null);
        Assert.assertEquals((String)"Decoding a null Object should return null", null, (Object)result);
        try {
            Double dObj = 3.0;
            urlCodec.decode((Object)dObj);
            Assert.fail((String)"Trying to url encode a Double object should cause an exception.");
        }
        catch (DecoderException decoderException) {
            // empty catch block
        }
        this.validateState(urlCodec);
    }

    @Test
    public void testDefaultEncoding() throws Exception {
        String plain = "Hello there!";
        URLCodec urlCodec = new URLCodec("UnicodeBig");
        urlCodec.encode("Hello there!");
        String encoded1 = urlCodec.encode("Hello there!", "UnicodeBig");
        String encoded2 = urlCodec.encode("Hello there!");
        Assert.assertEquals((Object)encoded1, (Object)encoded2);
        this.validateState(urlCodec);
    }
}

