/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.binary;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.commons.codec.binary.StringUtils;
import org.junit.Assert;
import org.junit.Test;

public class StringUtilsTest {
    private static final byte[] BYTES_FIXTURE = new byte[]{97, 98, 99};
    private static final byte[] BYTES_FIXTURE_16BE = new byte[]{0, 97, 0, 98, 0, 99};
    private static final byte[] BYTES_FIXTURE_16LE = new byte[]{97, 0, 98, 0, 99, 0};
    private static final String STRING_FIXTURE = "ABC";

    @Test
    public void testConstructor() {
        new StringUtils();
    }

    @Test
    public void testGetBytesIso8859_1() throws UnsupportedEncodingException {
        String charsetName = "ISO-8859-1";
        this.testGetBytesUnchecked("ISO-8859-1");
        byte[] expected = STRING_FIXTURE.getBytes("ISO-8859-1");
        byte[] actual = StringUtils.getBytesIso8859_1((String)STRING_FIXTURE);
        Assert.assertTrue((boolean)Arrays.equals(expected, actual));
    }

    private void testGetBytesUnchecked(String charsetName) throws UnsupportedEncodingException {
        byte[] expected = STRING_FIXTURE.getBytes(charsetName);
        byte[] actual = StringUtils.getBytesUnchecked((String)STRING_FIXTURE, (String)charsetName);
        Assert.assertTrue((boolean)Arrays.equals(expected, actual));
    }

    @Test
    public void testGetBytesUsAscii() throws UnsupportedEncodingException {
        String charsetName = "US-ASCII";
        this.testGetBytesUnchecked("US-ASCII");
        byte[] expected = STRING_FIXTURE.getBytes("US-ASCII");
        byte[] actual = StringUtils.getBytesUsAscii((String)STRING_FIXTURE);
        Assert.assertTrue((boolean)Arrays.equals(expected, actual));
    }

    @Test
    public void testGetBytesUtf16() throws UnsupportedEncodingException {
        String charsetName = "UTF-16";
        this.testGetBytesUnchecked("UTF-16");
        byte[] expected = STRING_FIXTURE.getBytes("UTF-16");
        byte[] actual = StringUtils.getBytesUtf16((String)STRING_FIXTURE);
        Assert.assertTrue((boolean)Arrays.equals(expected, actual));
    }

    @Test
    public void testGetBytesUtf16Be() throws UnsupportedEncodingException {
        String charsetName = "UTF-16BE";
        this.testGetBytesUnchecked("UTF-16BE");
        byte[] expected = STRING_FIXTURE.getBytes("UTF-16BE");
        byte[] actual = StringUtils.getBytesUtf16Be((String)STRING_FIXTURE);
        Assert.assertTrue((boolean)Arrays.equals(expected, actual));
    }

    @Test
    public void testGetBytesUtf16Le() throws UnsupportedEncodingException {
        String charsetName = "UTF-16LE";
        this.testGetBytesUnchecked("UTF-16LE");
        byte[] expected = STRING_FIXTURE.getBytes("UTF-16LE");
        byte[] actual = StringUtils.getBytesUtf16Le((String)STRING_FIXTURE);
        Assert.assertTrue((boolean)Arrays.equals(expected, actual));
    }

    @Test
    public void testGetBytesUtf8() throws UnsupportedEncodingException {
        String charsetName = "UTF-8";
        this.testGetBytesUnchecked("UTF-8");
        byte[] expected = STRING_FIXTURE.getBytes("UTF-8");
        byte[] actual = StringUtils.getBytesUtf8((String)STRING_FIXTURE);
        Assert.assertTrue((boolean)Arrays.equals(expected, actual));
    }

    @Test
    public void testGetBytesUncheckedBadName() {
        try {
            StringUtils.getBytesUnchecked((String)STRING_FIXTURE, (String)"UNKNOWN");
            Assert.fail((String)("Expected " + IllegalStateException.class.getName()));
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testGetBytesUncheckedNullInput() {
        Assert.assertNull((Object)StringUtils.getBytesUnchecked(null, (String)"UNKNOWN"));
    }

    private void testNewString(String charsetName) throws UnsupportedEncodingException {
        String expected = new String(BYTES_FIXTURE, charsetName);
        String actual = StringUtils.newString((byte[])BYTES_FIXTURE, (String)charsetName);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testNewStringBadEnc() {
        try {
            StringUtils.newString((byte[])BYTES_FIXTURE, (String)"UNKNOWN");
            Assert.fail((String)("Expected " + IllegalStateException.class.getName()));
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testNewStringNullInput() {
        Assert.assertNull((Object)StringUtils.newString(null, (String)"UNKNOWN"));
    }

    @Test
    public void testNewStringNullInput_CODEC229() {
        Assert.assertNull((Object)StringUtils.newStringUtf8(null));
        Assert.assertNull((Object)StringUtils.newStringIso8859_1(null));
        Assert.assertNull((Object)StringUtils.newStringUsAscii(null));
        Assert.assertNull((Object)StringUtils.newStringUtf16(null));
        Assert.assertNull((Object)StringUtils.newStringUtf16Be(null));
        Assert.assertNull((Object)StringUtils.newStringUtf16Le(null));
    }

    @Test
    public void testNewStringIso8859_1() throws UnsupportedEncodingException {
        String charsetName = "ISO-8859-1";
        this.testNewString("ISO-8859-1");
        String expected = new String(BYTES_FIXTURE, "ISO-8859-1");
        String actual = StringUtils.newStringIso8859_1((byte[])BYTES_FIXTURE);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testNewStringUsAscii() throws UnsupportedEncodingException {
        String charsetName = "US-ASCII";
        this.testNewString("US-ASCII");
        String expected = new String(BYTES_FIXTURE, "US-ASCII");
        String actual = StringUtils.newStringUsAscii((byte[])BYTES_FIXTURE);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testNewStringUtf16() throws UnsupportedEncodingException {
        String charsetName = "UTF-16";
        this.testNewString("UTF-16");
        String expected = new String(BYTES_FIXTURE, "UTF-16");
        String actual = StringUtils.newStringUtf16((byte[])BYTES_FIXTURE);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testNewStringUtf16Be() throws UnsupportedEncodingException {
        String charsetName = "UTF-16BE";
        this.testNewString("UTF-16BE");
        String expected = new String(BYTES_FIXTURE_16BE, "UTF-16BE");
        String actual = StringUtils.newStringUtf16Be((byte[])BYTES_FIXTURE_16BE);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testNewStringUtf16Le() throws UnsupportedEncodingException {
        String charsetName = "UTF-16LE";
        this.testNewString("UTF-16LE");
        String expected = new String(BYTES_FIXTURE_16LE, "UTF-16LE");
        String actual = StringUtils.newStringUtf16Le((byte[])BYTES_FIXTURE_16LE);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testNewStringUtf8() throws UnsupportedEncodingException {
        String charsetName = "UTF-8";
        this.testNewString("UTF-8");
        String expected = new String(BYTES_FIXTURE, "UTF-8");
        String actual = StringUtils.newStringUtf8((byte[])BYTES_FIXTURE);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testEqualsString() {
        Assert.assertTrue((boolean)StringUtils.equals(null, null));
        Assert.assertFalse((boolean)StringUtils.equals((CharSequence)"abc", null));
        Assert.assertFalse((boolean)StringUtils.equals(null, (CharSequence)"abc"));
        Assert.assertTrue((boolean)StringUtils.equals((CharSequence)"abc", (CharSequence)"abc"));
        Assert.assertFalse((boolean)StringUtils.equals((CharSequence)"abc", (CharSequence)"abcd"));
        Assert.assertFalse((boolean)StringUtils.equals((CharSequence)"abcd", (CharSequence)"abc"));
        Assert.assertFalse((boolean)StringUtils.equals((CharSequence)"abc", (CharSequence)STRING_FIXTURE));
    }

    @Test
    public void testEqualsCS1() {
        Assert.assertFalse((boolean)StringUtils.equals((CharSequence)new StringBuilder("abc"), null));
        Assert.assertFalse((boolean)StringUtils.equals(null, (CharSequence)new StringBuilder("abc")));
        Assert.assertTrue((boolean)StringUtils.equals((CharSequence)new StringBuilder("abc"), (CharSequence)new StringBuilder("abc")));
        Assert.assertFalse((boolean)StringUtils.equals((CharSequence)new StringBuilder("abc"), (CharSequence)new StringBuilder("abcd")));
        Assert.assertFalse((boolean)StringUtils.equals((CharSequence)new StringBuilder("abcd"), (CharSequence)new StringBuilder("abc")));
        Assert.assertFalse((boolean)StringUtils.equals((CharSequence)new StringBuilder("abc"), (CharSequence)new StringBuilder(STRING_FIXTURE)));
    }

    @Test
    public void testEqualsCS2() {
        Assert.assertTrue((boolean)StringUtils.equals((CharSequence)"abc", (CharSequence)new StringBuilder("abc")));
        Assert.assertFalse((boolean)StringUtils.equals((CharSequence)new StringBuilder("abc"), (CharSequence)"abcd"));
        Assert.assertFalse((boolean)StringUtils.equals((CharSequence)"abcd", (CharSequence)new StringBuilder("abc")));
        Assert.assertFalse((boolean)StringUtils.equals((CharSequence)new StringBuilder("abc"), (CharSequence)STRING_FIXTURE));
    }

    @Test
    public void testByteBufferUtf8() {
        Assert.assertNull((String)"Should be null safe", (Object)StringUtils.getByteBufferUtf8(null));
        String text = "asdhjfhsadiogasdjhagsdygfjasfgsdaksjdhfk";
        ByteBuffer bb = StringUtils.getByteBufferUtf8((String)"asdhjfhsadiogasdjhagsdygfjasfgsdaksjdhfk");
        Assert.assertArrayEquals((byte[])"asdhjfhsadiogasdjhagsdygfjasfgsdaksjdhfk".getBytes(StandardCharsets.UTF_8), (byte[])bb.array());
    }
}

