/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli.bug;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class BugCLI265Test {
    private DefaultParser parser;
    private Options options;

    @BeforeEach
    public void setUp() {
        this.parser = new DefaultParser();
        Option optionT1 = Option.builder((String)"t1").hasArg().numberOfArgs(1).optionalArg(true).argName("t1_path").build();
        Option optionA = Option.builder((String)"a").hasArg(false).build();
        Option optionB = Option.builder((String)"b").hasArg(false).build();
        Option optionLast = Option.builder((String)"last").hasArg(false).build();
        this.options = new Options().addOption(optionT1).addOption(optionA).addOption(optionB).addOption(optionLast);
    }

    @Test
    public void testShouldParseConcatenatedShortOptions() throws Exception {
        String[] concatenatedShortOptions = new String[]{"-t1", "-ab"};
        CommandLine commandLine = this.parser.parse(this.options, concatenatedShortOptions);
        Assertions.assertTrue((boolean)commandLine.hasOption("t1"));
        Assertions.assertNull((Object)commandLine.getOptionValue("t1"));
        Assertions.assertTrue((boolean)commandLine.hasOption("a"));
        Assertions.assertTrue((boolean)commandLine.hasOption("b"));
        Assertions.assertFalse((boolean)commandLine.hasOption("last"));
    }

    @Test
    public void testShouldParseShortOptionWithoutValue() throws Exception {
        String[] twoShortOptions = new String[]{"-t1", "-last"};
        CommandLine commandLine = this.parser.parse(this.options, twoShortOptions);
        Assertions.assertTrue((boolean)commandLine.hasOption("t1"));
        Assertions.assertNotEquals((Object)commandLine.getOptionValue("t1"), (Object)"Second option has been used as value for first option", (String)"-last");
        Assertions.assertTrue((boolean)commandLine.hasOption("last"), (String)"Second option has not been detected");
    }

    @Test
    public void testShouldParseShortOptionWithValue() throws Exception {
        String[] shortOptionWithValue = new String[]{"-t1", "path/to/my/db"};
        CommandLine commandLine = this.parser.parse(this.options, shortOptionWithValue);
        Assertions.assertEquals((Object)"path/to/my/db", (Object)commandLine.getOptionValue("t1"));
        Assertions.assertFalse((boolean)commandLine.hasOption("last"));
    }
}

