/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli;

import java.io.File;
import java.io.FileInputStream;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Vector;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PatternOptionBuilder;
import org.apache.commons.cli.PosixParser;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PatternOptionBuilderTest {
    @Test
    public void testClassPattern() throws Exception {
        Options options = PatternOptionBuilder.parsePattern((String)"c+d+");
        PosixParser parser = new PosixParser();
        CommandLine line = parser.parse(options, new String[]{"-c", "java.util.Calendar", "-d", "System.DateTime"});
        Assertions.assertEquals(Calendar.class, (Object)line.getOptionObject("c"), (String)"c value");
        Assertions.assertNull((Object)line.getOptionObject("d"), (String)"d value");
    }

    @Test
    public void testEmptyPattern() {
        Options options = PatternOptionBuilder.parsePattern((String)"");
        Assertions.assertTrue((boolean)options.getOptions().isEmpty());
    }

    @Test
    public void testExistingFilePattern() throws Exception {
        Options options = PatternOptionBuilder.parsePattern((String)"g<");
        PosixParser parser = new PosixParser();
        CommandLine line = parser.parse(options, new String[]{"-g", "src/test/resources/org/apache/commons/cli/existing-readable.file"});
        Object parsedReadableFileStream = line.getOptionObject("g");
        Assertions.assertNotNull((Object)parsedReadableFileStream, (String)"option g not parsed");
        Assertions.assertTrue((boolean)(parsedReadableFileStream instanceof FileInputStream), (String)"option g not FileInputStream");
    }

    @Test
    public void testExistingFilePatternFileNotExist() throws Exception {
        Options options = PatternOptionBuilder.parsePattern((String)"f<");
        PosixParser parser = new PosixParser();
        CommandLine line = parser.parse(options, new String[]{"-f", "non-existing.file"});
        Assertions.assertNull((Object)line.getOptionObject("f"), (String)"option f parsed");
    }

    @Test
    public void testNumberPattern() throws Exception {
        Options options = PatternOptionBuilder.parsePattern((String)"n%d%x%");
        PosixParser parser = new PosixParser();
        CommandLine line = parser.parse(options, new String[]{"-n", "1", "-d", "2.1", "-x", "3,5"});
        Assertions.assertEquals(Long.class, line.getOptionObject("n").getClass(), (String)"n object class");
        Assertions.assertEquals((Object)1L, (Object)line.getOptionObject("n"), (String)"n value");
        Assertions.assertEquals(Double.class, line.getOptionObject("d").getClass(), (String)"d object class");
        Assertions.assertEquals((Object)2.1, (Object)line.getOptionObject("d"), (String)"d value");
        Assertions.assertNull((Object)line.getOptionObject("x"), (String)"x object");
    }

    @Test
    public void testObjectPattern() throws Exception {
        Options options = PatternOptionBuilder.parsePattern((String)"o@i@n@");
        PosixParser parser = new PosixParser();
        CommandLine line = parser.parse(options, new String[]{"-o", "java.lang.String", "-i", "java.util.Calendar", "-n", "System.DateTime"});
        Assertions.assertEquals((Object)"", (Object)line.getOptionObject("o"), (String)"o value");
        Assertions.assertNull((Object)line.getOptionObject("i"), (String)"i value");
        Assertions.assertNull((Object)line.getOptionObject("n"), (String)"n value");
    }

    @Test
    public void testRequiredOption() throws Exception {
        Options options = PatternOptionBuilder.parsePattern((String)"!n%m%");
        PosixParser parser = new PosixParser();
        try {
            parser.parse(options, new String[]{""});
            Assertions.fail((String)"MissingOptionException wasn't thrown");
        }
        catch (MissingOptionException e) {
            Assertions.assertEquals((int)1, (int)e.getMissingOptions().size());
            Assertions.assertTrue((boolean)e.getMissingOptions().contains("n"));
        }
    }

    @Test
    public void testSimplePattern() throws Exception {
        Options options = PatternOptionBuilder.parsePattern((String)"a:b@cde>f+n%t/m*z#");
        Date expectedDate = new Date(1023400137000L);
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy");
        String[] args = new String[]{"-c", "-a", "foo", "-b", "java.util.Vector", "-e", "build.xml", "-f", "java.util.Calendar", "-n", "4.5", "-t", "https://commons.apache.org", "-z", dateFormat.format(expectedDate), "-m", "test*"};
        PosixParser parser = new PosixParser();
        CommandLine line = parser.parse(options, args);
        Assertions.assertEquals((Object)"foo", (Object)line.getOptionValue("a"), (String)"flag a");
        Assertions.assertEquals((Object)"foo", (Object)line.getOptionObject("a"), (String)"string flag a");
        Assertions.assertEquals(new Vector(), (Object)line.getOptionObject("b"), (String)"object flag b");
        Assertions.assertTrue((boolean)line.hasOption("c"), (String)"boolean true flag c");
        Assertions.assertFalse((boolean)line.hasOption("d"), (String)"boolean false flag d");
        Assertions.assertEquals((Object)new File("build.xml"), (Object)line.getOptionObject("e"), (String)"file flag e");
        Assertions.assertEquals(Calendar.class, (Object)line.getOptionObject("f"), (String)"class flag f");
        Assertions.assertEquals((Object)4.5, (Object)line.getOptionObject("n"), (String)"number flag n");
        Assertions.assertEquals((Object)new URL("https://commons.apache.org"), (Object)line.getOptionObject("t"), (String)"url flag t");
        Assertions.assertEquals((Object)"foo", (Object)line.getOptionValue('a'), (String)"flag a");
        Assertions.assertEquals((Object)"foo", (Object)line.getOptionObject('a'), (String)"string flag a");
        Assertions.assertEquals(new Vector(), (Object)line.getOptionObject('b'), (String)"object flag b");
        Assertions.assertTrue((boolean)line.hasOption('c'), (String)"boolean true flag c");
        Assertions.assertFalse((boolean)line.hasOption('d'), (String)"boolean false flag d");
        Assertions.assertEquals((Object)new File("build.xml"), (Object)line.getOptionObject('e'), (String)"file flag e");
        Assertions.assertEquals(Calendar.class, (Object)line.getOptionObject('f'), (String)"class flag f");
        Assertions.assertEquals((Object)4.5, (Object)line.getOptionObject('n'), (String)"number flag n");
        Assertions.assertEquals((Object)new URL("https://commons.apache.org"), (Object)line.getOptionObject('t'), (String)"url flag t");
        Assertions.assertThrows(UnsupportedOperationException.class, () -> line.getOptionObject('m'));
        Assertions.assertEquals((Object)expectedDate, (Object)line.getOptionObject('z'), (String)"date flag z");
    }

    @Test
    public void testUntypedPattern() throws Exception {
        Options options = PatternOptionBuilder.parsePattern((String)"abc");
        PosixParser parser = new PosixParser();
        CommandLine line = parser.parse(options, new String[]{"-abc"});
        Assertions.assertTrue((boolean)line.hasOption('a'));
        Assertions.assertNull((Object)line.getOptionObject('a'), (String)"value a");
        Assertions.assertTrue((boolean)line.hasOption('b'));
        Assertions.assertNull((Object)line.getOptionObject('b'), (String)"value b");
        Assertions.assertTrue((boolean)line.hasOption('c'));
        Assertions.assertNull((Object)line.getOptionObject('c'), (String)"value c");
    }

    @Test
    public void testURLPattern() throws Exception {
        Options options = PatternOptionBuilder.parsePattern((String)"u/v/");
        PosixParser parser = new PosixParser();
        CommandLine line = parser.parse(options, new String[]{"-u", "https://commons.apache.org", "-v", "foo://commons.apache.org"});
        Assertions.assertEquals((Object)new URL("https://commons.apache.org"), (Object)line.getOptionObject("u"), (String)"u value");
        Assertions.assertNull((Object)line.getOptionObject("v"), (String)"v value");
    }
}

