/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ValuesTest {
    private CommandLine cmd;

    @BeforeEach
    public void setUp() throws Exception {
        Options options = new Options();
        options.addOption("a", false, "toggle -a");
        options.addOption("b", true, "set -b");
        options.addOption("c", "c", false, "toggle -c");
        options.addOption("d", "d", true, "set -d");
        OptionBuilder.withLongOpt((String)"e");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)"set -e ");
        options.addOption(OptionBuilder.create((char)'e'));
        options.addOption("f", "f", false, "jk");
        OptionBuilder.withLongOpt((String)"g");
        OptionBuilder.hasArgs((int)2);
        OptionBuilder.withDescription((String)"set -g");
        options.addOption(OptionBuilder.create((char)'g'));
        OptionBuilder.withLongOpt((String)"h");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"set -h");
        options.addOption(OptionBuilder.create((char)'h'));
        OptionBuilder.withLongOpt((String)"i");
        OptionBuilder.withDescription((String)"set -i");
        options.addOption(OptionBuilder.create((char)'i'));
        OptionBuilder.withLongOpt((String)"j");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)"set -j");
        OptionBuilder.withValueSeparator((char)'=');
        options.addOption(OptionBuilder.create((char)'j'));
        OptionBuilder.withLongOpt((String)"k");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)"set -k");
        OptionBuilder.withValueSeparator((char)'=');
        options.addOption(OptionBuilder.create((char)'k'));
        OptionBuilder.withLongOpt((String)"m");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)"set -m");
        OptionBuilder.withValueSeparator();
        options.addOption(OptionBuilder.create((char)'m'));
        String[] args = new String[]{"-a", "-b", "foo", "--c", "--d", "bar", "-e", "one", "two", "-f", "arg1", "arg2", "-g", "val1", "val2", "arg3", "-h", "val1", "-i", "-h", "val2", "-jkey=value", "-j", "key=value", "-kkey1=value1", "-kkey2=value2", "-mkey=value"};
        PosixParser parser = new PosixParser();
        this.cmd = parser.parse(options, args);
    }

    @Test
    public void testCharSeparator() {
        Assertions.assertTrue((boolean)this.cmd.hasOption("j"), (String)"Option j is not set");
        Assertions.assertTrue((boolean)this.cmd.hasOption('j'), (String)"Option j is not set");
        Assertions.assertArrayEquals((Object[])new String[]{"key", "value", "key", "value"}, (Object[])this.cmd.getOptionValues("j"));
        Assertions.assertArrayEquals((Object[])new String[]{"key", "value", "key", "value"}, (Object[])this.cmd.getOptionValues('j'));
        Assertions.assertTrue((boolean)this.cmd.hasOption("k"), (String)"Option k is not set");
        Assertions.assertTrue((boolean)this.cmd.hasOption('k'), (String)"Option k is not set");
        Assertions.assertArrayEquals((Object[])new String[]{"key1", "value1", "key2", "value2"}, (Object[])this.cmd.getOptionValues("k"));
        Assertions.assertArrayEquals((Object[])new String[]{"key1", "value1", "key2", "value2"}, (Object[])this.cmd.getOptionValues('k'));
        Assertions.assertTrue((boolean)this.cmd.hasOption("m"), (String)"Option m is not set");
        Assertions.assertTrue((boolean)this.cmd.hasOption('m'), (String)"Option m is not set");
        Assertions.assertArrayEquals((Object[])new String[]{"key", "value"}, (Object[])this.cmd.getOptionValues("m"));
        Assertions.assertArrayEquals((Object[])new String[]{"key", "value"}, (Object[])this.cmd.getOptionValues('m'));
    }

    @Test
    public void testComplexValues() {
        Assertions.assertTrue((boolean)this.cmd.hasOption("i"), (String)"Option i is not set");
        Assertions.assertTrue((boolean)this.cmd.hasOption("h"), (String)"Option h is not set");
        Assertions.assertArrayEquals((Object[])new String[]{"val1", "val2"}, (Object[])this.cmd.getOptionValues("h"));
    }

    @Test
    public void testExtraArgs() {
        Assertions.assertArrayEquals((Object[])new String[]{"arg1", "arg2", "arg3"}, (Object[])this.cmd.getArgs(), (String)"Extra args");
    }

    @Test
    public void testMultipleArgValues() {
        Assertions.assertTrue((boolean)this.cmd.hasOption("e"), (String)"Option e is not set");
        Assertions.assertArrayEquals((Object[])new String[]{"one", "two"}, (Object[])this.cmd.getOptionValues("e"));
    }

    @Test
    public void testShortArgs() {
        Assertions.assertTrue((boolean)this.cmd.hasOption("a"), (String)"Option a is not set");
        Assertions.assertTrue((boolean)this.cmd.hasOption("c"), (String)"Option c is not set");
        Assertions.assertNull((Object)this.cmd.getOptionValues("a"));
        Assertions.assertNull((Object)this.cmd.getOptionValues("c"));
    }

    @Test
    public void testShortArgsWithValue() {
        Assertions.assertTrue((boolean)this.cmd.hasOption("b"), (String)"Option b is not set");
        Assertions.assertEquals((Object)"foo", (Object)this.cmd.getOptionValue("b"));
        Assertions.assertEquals((int)1, (int)this.cmd.getOptionValues("b").length);
        Assertions.assertTrue((boolean)this.cmd.hasOption("b"), (String)"Option b is not set");
        Assertions.assertEquals((Object)"bar", (Object)this.cmd.getOptionValue("d"));
        Assertions.assertEquals((int)1, (int)this.cmd.getOptionValues("d").length);
    }

    @Test
    public void testTwoArgValues() {
        Assertions.assertTrue((boolean)this.cmd.hasOption("g"), (String)"Option g is not set");
        Assertions.assertArrayEquals((Object[])new String[]{"val1", "val2"}, (Object[])this.cmd.getOptionValues("g"));
    }
}

