/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.SolrCliTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SolrCreateToolTest {
    public List<Option> getOptions() {
        return Arrays.asList(SolrCliTest.OPTION_ZKHOST, SolrCliTest.OPTION_SOLRURL, SolrCliTest.OPTION_ZKHOST_DEPRECATED, SolrCliTest.OPTION_SOLRURL, Option.builder((String)"c").longOpt("name").argName("NAME").hasArg().required(true).desc("Name of collection or core to create.").build(), Option.builder((String)"s").longOpt("shards").argName("#").hasArg().required(false).desc("Number of shards; default is 1.").build(), Option.builder((String)"rf").longOpt("replication-factor").argName("#").hasArg().required(false).desc("Number of copies of each document across the collection (replicas per shard); default is 1.").build(), Option.builder((String)"d").longOpt("confdir").argName("NAME").hasArg().required(false).desc("Configuration directory to copy when creating the new collection; default is _default.").build(), Option.builder((String)"n").longOpt("confname").argName("NAME").hasArg().required(false).desc("Configuration name; default is the collection name.").build(), SolrCliTest.OPTION_CREDENTIALS);
    }

    private String printHelp(HelpFormatter formatter) {
        Options options = new Options();
        this.getOptions().forEach(arg_0 -> ((Options)options).addOption(arg_0));
        String cmdLineSyntax = this.getClass().getName();
        StringWriter out = new StringWriter();
        PrintWriter pw = new PrintWriter(out);
        formatter.printHelp(pw, formatter.getWidth(), cmdLineSyntax, null, options, formatter.getLeftPadding(), formatter.getDescPadding(), null, false);
        pw.flush();
        String actual = out.toString();
        Assertions.assertTrue((boolean)actual.contains("-z,--zk-host <HOST>              Zookeeper connection string; unnecessary"));
        return actual;
    }

    @Test
    public void testHelpFormatter() {
        HelpFormatter formatter = new HelpFormatter();
        String actual = this.printHelp(formatter);
        Assertions.assertFalse((boolean)actual.contains("Deprecated"));
    }

    @Test
    public void testHelpFormatterDeprecated() {
        HelpFormatter formatter = HelpFormatter.builder().setShowDeprecated(true).get();
        String actual = this.printHelp(formatter);
        Assertions.assertTrue((boolean)actual.contains("-zkHost,--zkHost <HOST>          [Deprecated] Zookeeper connection"));
    }
}

