/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli;

import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class OptionBuilderTest {
    @Test
    public void testBaseOptionCharOpt() {
        OptionBuilder.withDescription((String)"option description");
        Option base = OptionBuilder.create((char)'o');
        Assertions.assertEquals((Object)"o", (Object)base.getOpt());
        Assertions.assertEquals((Object)"option description", (Object)base.getDescription());
        Assertions.assertFalse((boolean)base.hasArg());
    }

    @Test
    public void testBaseOptionStringOpt() {
        OptionBuilder.withDescription((String)"option description");
        Option base = OptionBuilder.create((String)"o");
        Assertions.assertEquals((Object)"o", (Object)base.getOpt());
        Assertions.assertEquals((Object)"option description", (Object)base.getDescription());
        Assertions.assertFalse((boolean)base.hasArg());
    }

    @Test
    public void testBuilderIsResettedAlways() {
        try {
            OptionBuilder.withDescription((String)"JUnit");
            OptionBuilder.create((char)'\"');
            Assertions.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assertions.assertNull((Object)OptionBuilder.create((char)'x').getDescription(), (String)"we inherited a description");
        try {
            OptionBuilder.withDescription((String)"JUnit");
            OptionBuilder.create();
            Assertions.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assertions.assertNull((Object)OptionBuilder.create((char)'x').getDescription(), (String)"we inherited a description");
    }

    @Test
    public void testCompleteOption() {
        OptionBuilder.withLongOpt((String)"simple option");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired();
        OptionBuilder.hasArgs();
        OptionBuilder.withType(Float.class);
        OptionBuilder.withDescription((String)"this is a simple option");
        Option simple = OptionBuilder.create((char)'s');
        Assertions.assertEquals((Object)"s", (Object)simple.getOpt());
        Assertions.assertEquals((Object)"simple option", (Object)simple.getLongOpt());
        Assertions.assertEquals((Object)"this is a simple option", (Object)simple.getDescription());
        Assertions.assertEquals((Object)simple.getType(), Float.class);
        Assertions.assertTrue((boolean)simple.hasArg());
        Assertions.assertTrue((boolean)simple.isRequired());
        Assertions.assertTrue((boolean)simple.hasArgs());
    }

    @Test
    public void testCreateIncompleteOption() {
        try {
            OptionBuilder.hasArg();
            OptionBuilder.create();
            Assertions.fail((String)"Incomplete option should be rejected");
        }
        catch (IllegalArgumentException e) {
            OptionBuilder.create((String)"opt");
        }
    }

    @Test
    public void testIllegalOptions() {
        try {
            OptionBuilder.withDescription((String)"option description");
            OptionBuilder.create((char)'\"');
            Assertions.fail((String)"IllegalArgumentException not caught");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            OptionBuilder.create((String)"opt`");
            Assertions.fail((String)"IllegalArgumentException not caught");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            OptionBuilder.create((String)"opt");
        }
        catch (IllegalArgumentException exp) {
            Assertions.fail((String)"IllegalArgumentException caught");
        }
    }

    @Test
    public void testOptionArgNumbers() {
        OptionBuilder.withDescription((String)"option description");
        OptionBuilder.hasArgs((int)2);
        Option opt = OptionBuilder.create((char)'o');
        Assertions.assertEquals((int)2, (int)opt.getArgs());
    }

    @Test
    public void testSpecialOptChars() throws Exception {
        OptionBuilder.withDescription((String)"help options");
        Option opt1 = OptionBuilder.create((char)'?');
        Assertions.assertEquals((Object)"?", (Object)opt1.getOpt());
        OptionBuilder.withDescription((String)"read from stdin");
        Option opt2 = OptionBuilder.create((char)'@');
        Assertions.assertEquals((Object)"@", (Object)opt2.getOpt());
        try {
            OptionBuilder.create((char)' ');
            Assertions.fail((String)"IllegalArgumentException not caught");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testTwoCompleteOptions() {
        OptionBuilder.withLongOpt((String)"simple option");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired();
        OptionBuilder.hasArgs();
        OptionBuilder.withType(Float.class);
        OptionBuilder.withDescription((String)"this is a simple option");
        Option simple = OptionBuilder.create((char)'s');
        Assertions.assertEquals((Object)"s", (Object)simple.getOpt());
        Assertions.assertEquals((Object)"simple option", (Object)simple.getLongOpt());
        Assertions.assertEquals((Object)"this is a simple option", (Object)simple.getDescription());
        Assertions.assertEquals((Object)simple.getType(), Float.class);
        Assertions.assertTrue((boolean)simple.hasArg());
        Assertions.assertTrue((boolean)simple.isRequired());
        Assertions.assertTrue((boolean)simple.hasArgs());
        OptionBuilder.withLongOpt((String)"dimple option");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"this is a dimple option");
        simple = OptionBuilder.create((char)'d');
        Assertions.assertEquals((Object)"d", (Object)simple.getOpt());
        Assertions.assertEquals((Object)"dimple option", (Object)simple.getLongOpt());
        Assertions.assertEquals((Object)"this is a dimple option", (Object)simple.getDescription());
        Assertions.assertEquals(String.class, (Object)simple.getType());
        Assertions.assertTrue((boolean)simple.hasArg());
        Assertions.assertFalse((boolean)simple.isRequired());
        Assertions.assertFalse((boolean)simple.hasArgs());
    }
}

