/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli;

import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.stream.Stream;
import org.apache.commons.cli.Converter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class ConverterTests {
    private static Stream<Arguments> numberTestParameters() {
        ArrayList<Arguments> lst = new ArrayList<Arguments>();
        lst.add(Arguments.of((Object[])new Object[]{"123", Long.valueOf("123")}));
        lst.add(Arguments.of((Object[])new Object[]{"12.3", Double.valueOf("12.3")}));
        lst.add(Arguments.of((Object[])new Object[]{"-123", Long.valueOf("-123")}));
        lst.add(Arguments.of((Object[])new Object[]{"-12.3", Double.valueOf("-12.3")}));
        lst.add(Arguments.of((Object[])new Object[]{".3", Double.valueOf("0.3")}));
        lst.add(Arguments.of((Object[])new Object[]{"-.3", Double.valueOf("-0.3")}));
        lst.add(Arguments.of((Object[])new Object[]{"0x5F", null}));
        lst.add(Arguments.of((Object[])new Object[]{"2,3", null}));
        lst.add(Arguments.of((Object[])new Object[]{"1.2.3", null}));
        return lst.stream();
    }

    @Test
    public void classTests() throws Exception {
        Assertions.assertNotNull((Object)Converter.CLASS.apply(this.getClass().getName()), (String)this.getClass().getName());
        Assertions.assertNotNull((Object)Converter.CLASS.apply(this.getClass().getCanonicalName()), (String)this.getClass().getCanonicalName());
        Assertions.assertThrows(ClassNotFoundException.class, () -> Converter.CLASS.apply(this.getClass().getSimpleName()), (String)this.getClass().getSimpleName());
        Assertions.assertNotNull((Object)Converter.CLASS.apply(this.getClass().getTypeName()), (String)this.getClass().getTypeName());
        Assertions.assertThrows(ClassNotFoundException.class, () -> Converter.CLASS.apply("foo.bar"));
        Assertions.assertNotNull((Object)Converter.CLASS.apply(AClassWithoutADefaultConstructor.class.getName()));
    }

    @Test
    public void dateTests() throws Exception {
        Assertions.assertThrows(ParseException.class, () -> Converter.DATE.apply("whatever"));
        Date expected = new Date(1023400137000L);
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy");
        String formatted = dateFormat.format(expected);
        Assertions.assertEquals((Object)expected, (Object)Converter.DATE.apply(formatted));
        Assertions.assertThrows(ParseException.class, () -> Converter.DATE.apply("Jun 06 17:48:57 EDT 2002"));
    }

    @Test
    public void fileTests() throws Exception {
        URL url = this.getClass().getClassLoader().getResource("./org/apache/commons/cli/existing-readable.file");
        String fileName = url.toString().substring("file:".length());
        Assertions.assertNotNull((Object)Converter.FILE.apply(fileName));
    }

    @ParameterizedTest
    @MethodSource(value={"numberTestParameters"})
    public void numberTests(String str, Number expected) throws Exception {
        if (expected != null) {
            Assertions.assertEquals((Object)expected, (Object)Converter.NUMBER.apply(str));
        } else {
            Assertions.assertThrows(NumberFormatException.class, () -> Converter.NUMBER.apply(str));
        }
    }

    @Test
    public void objectTests() throws Exception {
        Assertions.assertNotNull((Object)Converter.OBJECT.apply(this.getClass().getName()), (String)this.getClass().getName());
        Assertions.assertNotNull((Object)Converter.OBJECT.apply(this.getClass().getCanonicalName()), (String)this.getClass().getCanonicalName());
        Assertions.assertThrows(ClassNotFoundException.class, () -> Converter.OBJECT.apply(this.getClass().getSimpleName()), (String)this.getClass().getSimpleName());
        Assertions.assertNotNull((Object)Converter.OBJECT.apply(this.getClass().getTypeName()), (String)this.getClass().getTypeName());
        Assertions.assertThrows(ClassNotFoundException.class, () -> Converter.OBJECT.apply("foo.bar"));
        Assertions.assertThrows(NoSuchMethodException.class, () -> Converter.OBJECT.apply(AClassWithoutADefaultConstructor.class.getName()));
    }

    @Test
    public void urlTests() throws Exception {
        Assertions.assertEquals((Object)new URL("http://apache.org"), (Object)Converter.URL.apply("http://apache.org"));
        Assertions.assertThrows(MalformedURLException.class, () -> Converter.URL.apply("foo.bar"));
    }

    public class AClassWithoutADefaultConstructor {
        public AClassWithoutADefaultConstructor(int i) {
        }
    }
}

