/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli;

import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.commons.cli.AmbiguousOptionException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.MissingArgumentException;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.Parser;
import org.apache.commons.cli.UnrecognizedOptionException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public abstract class AbstractParserTestCase {
    protected CommandLineParser parser;
    protected Options options;

    private CommandLine parse(CommandLineParser parser, Options options, String[] args, Properties properties) throws ParseException {
        if (parser instanceof Parser) {
            return ((Parser)parser).parse(options, args, properties);
        }
        if (parser instanceof DefaultParser) {
            return ((DefaultParser)parser).parse(options, args, properties);
        }
        throw new UnsupportedOperationException("Default options not supported by this parser");
    }

    @BeforeEach
    public void setUp() {
        this.options = new Options().addOption("a", "enable-a", false, "turn [a] on or off").addOption("b", "bfile", true, "set the value of [b]").addOption("c", "copt", false, "turn [c] on or off");
    }

    public void testAmbiguousArgParsing() throws Exception {
        String[] args = new String[]{"-=-"};
        Options options = new Options();
        Assertions.assertThrows(UnrecognizedOptionException.class, () -> this.parser.parse(options, args));
    }

    @Test
    public void testAmbiguousLongWithoutEqualSingleDash() throws Exception {
        String[] args = new String[]{"-b", "-foobar"};
        Options options = new Options();
        OptionBuilder.withLongOpt((String)"foo");
        OptionBuilder.hasOptionalArg();
        options.addOption(OptionBuilder.create((char)'f'));
        OptionBuilder.withLongOpt((String)"bar");
        OptionBuilder.hasOptionalArg();
        options.addOption(OptionBuilder.create((char)'b'));
        CommandLine cl = this.parser.parse(options, args);
        Assertions.assertTrue((boolean)cl.hasOption("b"));
        Assertions.assertTrue((boolean)cl.hasOption("f"));
        Assertions.assertEquals((Object)"bar", (Object)cl.getOptionValue("foo"));
    }

    @Test
    public void testAmbiguousLongWithoutEqualSingleDash2() throws Exception {
        String[] args = new String[]{"-b", "-foobar"};
        Options options = new Options();
        options.addOption(Option.builder().longOpt("foo").option("f").optionalArg(true).build());
        options.addOption(Option.builder().longOpt("bar").option("b").optionalArg(false).build());
        CommandLine cl = this.parser.parse(options, args);
        Assertions.assertTrue((boolean)cl.hasOption("b"));
        Assertions.assertTrue((boolean)cl.hasOption("f"));
        Assertions.assertEquals((Object)"bar", (Object)cl.getOptionValue("foo"));
    }

    @Test
    public void testAmbiguousPartialLongOption1() throws Exception {
        String[] args = new String[]{"--ver"};
        Options options = new Options();
        OptionBuilder.withLongOpt((String)"version");
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"verbose");
        options.addOption(OptionBuilder.create());
        boolean caught = false;
        try {
            this.parser.parse(options, args);
        }
        catch (AmbiguousOptionException e) {
            caught = true;
            Assertions.assertEquals((Object)"--ver", (Object)e.getOption(), (String)"Partial option");
            Assertions.assertNotNull((Object)e.getMatchingOptions(), (String)"Matching options null");
            Assertions.assertEquals((int)2, (int)e.getMatchingOptions().size(), (String)"Matching options size");
        }
        Assertions.assertTrue((boolean)caught, (String)"Confirm MissingArgumentException caught");
    }

    @Test
    public void testAmbiguousPartialLongOption2() throws Exception {
        String[] args = new String[]{"-ver"};
        Options options = new Options();
        OptionBuilder.withLongOpt((String)"version");
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"verbose");
        options.addOption(OptionBuilder.create());
        boolean caught = false;
        try {
            this.parser.parse(options, args);
        }
        catch (AmbiguousOptionException e) {
            caught = true;
            Assertions.assertEquals((Object)"-ver", (Object)e.getOption(), (String)"Partial option");
            Assertions.assertNotNull((Object)e.getMatchingOptions(), (String)"Matching options null");
            Assertions.assertEquals((int)2, (int)e.getMatchingOptions().size(), (String)"Matching options size");
        }
        Assertions.assertTrue((boolean)caught, (String)"Confirm MissingArgumentException caught");
    }

    @Test
    public void testAmbiguousPartialLongOption3() throws Exception {
        String[] args = new String[]{"--ver=1"};
        Options options = new Options();
        OptionBuilder.withLongOpt((String)"version");
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"verbose");
        OptionBuilder.hasOptionalArg();
        options.addOption(OptionBuilder.create());
        boolean caught = false;
        try {
            this.parser.parse(options, args);
        }
        catch (AmbiguousOptionException e) {
            caught = true;
            Assertions.assertEquals((Object)"--ver", (Object)e.getOption(), (String)"Partial option");
            Assertions.assertNotNull((Object)e.getMatchingOptions(), (String)"Matching options null");
            Assertions.assertEquals((int)2, (int)e.getMatchingOptions().size(), (String)"Matching options size");
        }
        Assertions.assertTrue((boolean)caught, (String)"Confirm MissingArgumentException caught");
    }

    @Test
    public void testAmbiguousPartialLongOption4() throws Exception {
        String[] args = new String[]{"-ver=1"};
        Options options = new Options();
        OptionBuilder.withLongOpt((String)"version");
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"verbose");
        OptionBuilder.hasOptionalArg();
        options.addOption(OptionBuilder.create());
        boolean caught = false;
        try {
            this.parser.parse(options, args);
        }
        catch (AmbiguousOptionException e) {
            caught = true;
            Assertions.assertEquals((Object)"-ver", (Object)e.getOption(), (String)"Partial option");
            Assertions.assertNotNull((Object)e.getMatchingOptions(), (String)"Matching options null");
            Assertions.assertEquals((int)2, (int)e.getMatchingOptions().size(), (String)"Matching options size");
        }
        Assertions.assertTrue((boolean)caught, (String)"Confirm MissingArgumentException caught");
    }

    @Test
    public void testArgumentStartingWithHyphen() throws Exception {
        String[] args = new String[]{"-b", "-foo"};
        CommandLine cl = this.parser.parse(this.options, args);
        Assertions.assertEquals((Object)"-foo", (Object)cl.getOptionValue("b"));
    }

    @Test
    public void testBursting() throws Exception {
        String[] args = new String[]{"-acbtoast", "foo", "bar"};
        CommandLine cl = this.parser.parse(this.options, args);
        Assertions.assertTrue((boolean)cl.hasOption("a"), (String)"Confirm -a is set");
        Assertions.assertTrue((boolean)cl.hasOption("b"), (String)"Confirm -b is set");
        Assertions.assertTrue((boolean)cl.hasOption("c"), (String)"Confirm -c is set");
        Assertions.assertEquals((Object)"toast", (Object)cl.getOptionValue("b"), (String)"Confirm arg of -b");
        Assertions.assertEquals((int)2, (int)cl.getArgList().size(), (String)"Confirm size of extra args");
    }

    @Test
    public void testDoubleDash1() throws Exception {
        String[] args = new String[]{"--copt", "--", "-b", "toast"};
        CommandLine cl = this.parser.parse(this.options, args);
        Assertions.assertTrue((boolean)cl.hasOption("c"), (String)"Confirm -c is set");
        Assertions.assertFalse((boolean)cl.hasOption("b"), (String)"Confirm -b is not set");
        Assertions.assertEquals((int)2, (int)cl.getArgList().size(), (String)("Confirm 2 extra args: " + cl.getArgList().size()));
    }

    @Test
    public void testDoubleDash2() throws Exception {
        Options options = new Options();
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((char)'n'));
        options.addOption(OptionBuilder.create((char)'m'));
        try {
            this.parser.parse(options, new String[]{"-n", "--", "-m"});
            Assertions.fail((String)"MissingArgumentException not thrown for option -n");
        }
        catch (MissingArgumentException e) {
            Assertions.assertNotNull((Object)e.getOption(), (String)"option null");
            Assertions.assertEquals((Object)"n", (Object)e.getOption().getOpt());
        }
    }

    @Test
    public void testLongOptionQuoteHandling() throws Exception {
        String[] args = new String[]{"--bfile", "\"quoted string\""};
        CommandLine cl = this.parser.parse(this.options, args);
        Assertions.assertEquals((Object)"quoted string", (Object)cl.getOptionValue("b"), (String)"Confirm --bfile \"arg\" strips quotes");
    }

    @Test
    public void testLongOptionWithEqualsQuoteHandling() throws Exception {
        String[] args = new String[]{"--bfile=\"quoted string\""};
        CommandLine cl = this.parser.parse(this.options, args);
        Assertions.assertEquals((Object)"quoted string", (Object)cl.getOptionValue("b"), (String)"Confirm --bfile=\"arg\" strips quotes");
    }

    @Test
    public void testLongWithEqualDoubleDash() throws Exception {
        String[] args = new String[]{"--foo=bar"};
        Options options = new Options();
        OptionBuilder.withLongOpt((String)"foo");
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((char)'f'));
        CommandLine cl = this.parser.parse(options, args);
        Assertions.assertEquals((Object)"bar", (Object)cl.getOptionValue("foo"));
    }

    @Test
    public void testLongWithEqualSingleDash() throws Exception {
        String[] args = new String[]{"-foo=bar"};
        Options options = new Options();
        OptionBuilder.withLongOpt((String)"foo");
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((char)'f'));
        CommandLine cl = this.parser.parse(options, args);
        Assertions.assertEquals((Object)"bar", (Object)cl.getOptionValue("foo"));
    }

    @Test
    public void testLongWithoutEqualDoubleDash() throws Exception {
        String[] args = new String[]{"--foobar"};
        Options options = new Options();
        OptionBuilder.withLongOpt((String)"foo");
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((char)'f'));
        CommandLine cl = this.parser.parse(options, args, true);
        Assertions.assertFalse((boolean)cl.hasOption("foo"));
    }

    @Test
    public void testLongWithoutEqualSingleDash() throws Exception {
        String[] args = new String[]{"-foobar"};
        Options options = new Options();
        OptionBuilder.withLongOpt((String)"foo");
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((char)'f'));
        CommandLine cl = this.parser.parse(options, args);
        Assertions.assertEquals((Object)"bar", (Object)cl.getOptionValue("foo"));
    }

    @Test
    public void testLongWithUnexpectedArgument1() throws Exception {
        String[] args = new String[]{"--foo=bar"};
        Options options = new Options();
        OptionBuilder.withLongOpt((String)"foo");
        options.addOption(OptionBuilder.create((char)'f'));
        try {
            this.parser.parse(options, args);
        }
        catch (UnrecognizedOptionException e) {
            Assertions.assertEquals((Object)"--foo=bar", (Object)e.getOption());
            return;
        }
        Assertions.fail((String)"UnrecognizedOptionException not thrown");
    }

    @Test
    public void testLongWithUnexpectedArgument2() throws Exception {
        String[] args = new String[]{"-foobar"};
        Options options = new Options();
        OptionBuilder.withLongOpt((String)"foo");
        options.addOption(OptionBuilder.create((char)'f'));
        try {
            this.parser.parse(options, args);
        }
        catch (UnrecognizedOptionException e) {
            Assertions.assertEquals((Object)"-foobar", (Object)e.getOption());
            return;
        }
        Assertions.fail((String)"UnrecognizedOptionException not thrown");
    }

    @Test
    public void testMissingArg() throws Exception {
        String[] args = new String[]{"-b"};
        boolean caught = false;
        try {
            this.parser.parse(this.options, args);
        }
        catch (MissingArgumentException e) {
            caught = true;
            Assertions.assertEquals((Object)"b", (Object)e.getOption().getOpt(), (String)"option missing an argument");
        }
        Assertions.assertTrue((boolean)caught, (String)"Confirm MissingArgumentException caught");
    }

    @Test
    public void testMissingArgWithBursting() throws Exception {
        String[] args = new String[]{"-acb"};
        boolean caught = false;
        try {
            this.parser.parse(this.options, args);
        }
        catch (MissingArgumentException e) {
            caught = true;
            Assertions.assertEquals((Object)"b", (Object)e.getOption().getOpt(), (String)"option missing an argument");
        }
        Assertions.assertTrue((boolean)caught, (String)"Confirm MissingArgumentException caught");
    }

    @Test
    public void testMissingRequiredGroup() throws Exception {
        OptionGroup group = new OptionGroup();
        group.addOption(OptionBuilder.create((String)"a"));
        group.addOption(OptionBuilder.create((String)"b"));
        group.setRequired(true);
        Options options = new Options();
        options.addOptionGroup(group);
        OptionBuilder.isRequired();
        options.addOption(OptionBuilder.create((String)"c"));
        try {
            this.parser.parse(options, new String[]{"-c"});
            Assertions.fail((String)"MissingOptionException not thrown");
        }
        catch (MissingOptionException e) {
            Assertions.assertEquals((int)1, (int)e.getMissingOptions().size());
            Assertions.assertTrue((boolean)(e.getMissingOptions().get(0) instanceof OptionGroup));
        }
        catch (ParseException e) {
            Assertions.fail((String)"Expected to catch MissingOptionException");
        }
    }

    @Test
    public void testMissingRequiredOption() {
        String[] args = new String[]{"-a"};
        Options options = new Options();
        options.addOption("a", "enable-a", false, null);
        OptionBuilder.withLongOpt((String)"bfile");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired();
        options.addOption(OptionBuilder.create((char)'b'));
        try {
            this.parser.parse(options, args);
            Assertions.fail((String)"exception should have been thrown");
        }
        catch (MissingOptionException e) {
            Assertions.assertEquals((Object)"Missing required option: b", (Object)e.getMessage(), (String)"Incorrect exception message");
            Assertions.assertTrue((boolean)e.getMissingOptions().contains("b"));
        }
        catch (ParseException e) {
            Assertions.fail((String)"expected to catch MissingOptionException");
        }
    }

    @Test
    public void testMissingRequiredOptions() {
        String[] args = new String[]{"-a"};
        Options options = new Options();
        options.addOption("a", "enable-a", false, null);
        OptionBuilder.withLongOpt((String)"bfile");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired();
        options.addOption(OptionBuilder.create((char)'b'));
        OptionBuilder.withLongOpt((String)"cfile");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired();
        options.addOption(OptionBuilder.create((char)'c'));
        try {
            this.parser.parse(options, args);
            Assertions.fail((String)"exception should have been thrown");
        }
        catch (MissingOptionException e) {
            Assertions.assertEquals((Object)"Missing required options: b, c", (Object)e.getMessage(), (String)"Incorrect exception message");
            Assertions.assertTrue((boolean)e.getMissingOptions().contains("b"));
            Assertions.assertTrue((boolean)e.getMissingOptions().contains("c"));
        }
        catch (ParseException e) {
            Assertions.fail((String)"expected to catch MissingOptionException");
        }
    }

    @Test
    public void testMultiple() throws Exception {
        String[] args = new String[]{"-c", "foobar", "-b", "toast"};
        CommandLine cl = this.parser.parse(this.options, args, true);
        Assertions.assertTrue((boolean)cl.hasOption("c"), (String)"Confirm -c is set");
        Assertions.assertEquals((int)3, (int)cl.getArgList().size(), (String)("Confirm  3 extra args: " + cl.getArgList().size()));
        cl = this.parser.parse(this.options, cl.getArgs());
        Assertions.assertFalse((boolean)cl.hasOption("c"), (String)"Confirm -c is not set");
        Assertions.assertTrue((boolean)cl.hasOption("b"), (String)"Confirm -b is set");
        Assertions.assertEquals((Object)"toast", (Object)cl.getOptionValue("b"), (String)"Confirm arg of -b");
        Assertions.assertEquals((int)1, (int)cl.getArgList().size(), (String)("Confirm  1 extra arg: " + cl.getArgList().size()));
        Assertions.assertEquals((Object)"foobar", cl.getArgList().get(0), (String)("Confirm  value of extra arg: " + (String)cl.getArgList().get(0)));
    }

    @Test
    public void testMultipleWithLong() throws Exception {
        String[] args = new String[]{"--copt", "foobar", "--bfile", "toast"};
        CommandLine cl = this.parser.parse(this.options, args, true);
        Assertions.assertTrue((boolean)cl.hasOption("c"), (String)"Confirm -c is set");
        Assertions.assertEquals((int)3, (int)cl.getArgList().size(), (String)("Confirm  3 extra args: " + cl.getArgList().size()));
        cl = this.parser.parse(this.options, cl.getArgs());
        Assertions.assertFalse((boolean)cl.hasOption("c"), (String)"Confirm -c is not set");
        Assertions.assertTrue((boolean)cl.hasOption("b"), (String)"Confirm -b is set");
        Assertions.assertEquals((Object)"toast", (Object)cl.getOptionValue("b"), (String)"Confirm arg of -b");
        Assertions.assertEquals((int)1, (int)cl.getArgList().size(), (String)("Confirm  1 extra arg: " + cl.getArgList().size()));
        Assertions.assertEquals((Object)"foobar", cl.getArgList().get(0), (String)("Confirm  value of extra arg: " + (String)cl.getArgList().get(0)));
    }

    @Test
    public void testNegativeArgument() throws Exception {
        String[] args = new String[]{"-b", "-1"};
        CommandLine cl = this.parser.parse(this.options, args);
        Assertions.assertEquals((Object)"-1", (Object)cl.getOptionValue("b"));
    }

    @Test
    public void testNegativeOption() throws Exception {
        String[] args = new String[]{"-b", "-1"};
        this.options.addOption("1", false, null);
        CommandLine cl = this.parser.parse(this.options, args);
        Assertions.assertEquals((Object)"-1", (Object)cl.getOptionValue("b"));
    }

    @Test
    public void testOptionalArgsOptionBuilder() throws Exception {
        Options options = new Options();
        OptionBuilder.hasOptionalArgs((int)2);
        options.addOption(OptionBuilder.create((char)'i'));
        Properties properties = new Properties();
        CommandLine cmd = this.parse(this.parser, options, new String[]{"-i"}, properties);
        Assertions.assertTrue((boolean)cmd.hasOption("i"));
        Assertions.assertNull((Object)cmd.getOptionValues("i"));
        cmd = this.parse(this.parser, options, new String[]{"-i", "paper"}, properties);
        Assertions.assertTrue((boolean)cmd.hasOption("i"));
        Assertions.assertArrayEquals((Object[])new String[]{"paper"}, (Object[])cmd.getOptionValues("i"));
        cmd = this.parse(this.parser, options, new String[]{"-i", "paper", "scissors"}, properties);
        Assertions.assertTrue((boolean)cmd.hasOption("i"));
        Assertions.assertArrayEquals((Object[])new String[]{"paper", "scissors"}, (Object[])cmd.getOptionValues("i"));
        cmd = this.parse(this.parser, options, new String[]{"-i", "paper", "scissors", "rock"}, properties);
        Assertions.assertTrue((boolean)cmd.hasOption("i"));
        Assertions.assertArrayEquals((Object[])new String[]{"paper", "scissors"}, (Object[])cmd.getOptionValues("i"));
        Assertions.assertArrayEquals((Object[])new String[]{"rock"}, (Object[])cmd.getArgs());
    }

    @Test
    public void testOptionalArgsOptionDotBuilder() throws Exception {
        Options options = new Options();
        options.addOption(Option.builder((String)"i").numberOfArgs(2).optionalArg(true).build());
        Properties properties = new Properties();
        CommandLine cmd = this.parse(this.parser, options, new String[]{"-i"}, properties);
        Assertions.assertTrue((boolean)cmd.hasOption("i"));
        Assertions.assertNull((Object)cmd.getOptionValues("i"));
        cmd = this.parse(this.parser, options, new String[]{"-i", "paper"}, properties);
        Assertions.assertTrue((boolean)cmd.hasOption("i"));
        Assertions.assertArrayEquals((Object[])new String[]{"paper"}, (Object[])cmd.getOptionValues("i"));
        cmd = this.parse(this.parser, options, new String[]{"-i", "paper", "scissors"}, properties);
        Assertions.assertTrue((boolean)cmd.hasOption("i"));
        Assertions.assertArrayEquals((Object[])new String[]{"paper", "scissors"}, (Object[])cmd.getOptionValues("i"));
        cmd = this.parse(this.parser, options, new String[]{"-i", "paper", "scissors", "rock"}, properties);
        Assertions.assertTrue((boolean)cmd.hasOption("i"));
        Assertions.assertArrayEquals((Object[])new String[]{"paper", "scissors"}, (Object[])cmd.getOptionValues("i"));
        Assertions.assertArrayEquals((Object[])new String[]{"rock"}, (Object[])cmd.getArgs());
        options.addOption(Option.builder((String)"j").numberOfArgs(3).optionalArg(true).build());
        cmd = this.parse(this.parser, options, new String[]{"-j"}, properties);
    }

    @Test
    public void testOptionAndRequiredOption() throws Exception {
        String[] args = new String[]{"-a", "-b", "file"};
        Options options = new Options();
        options.addOption("a", "enable-a", false, null);
        OptionBuilder.withLongOpt((String)"bfile");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired();
        options.addOption(OptionBuilder.create((char)'b'));
        CommandLine cl = this.parser.parse(options, args);
        Assertions.assertTrue((boolean)cl.hasOption("a"), (String)"Confirm -a is set");
        Assertions.assertTrue((boolean)cl.hasOption("b"), (String)"Confirm -b is set");
        Assertions.assertEquals((Object)"file", (Object)cl.getOptionValue("b"), (String)"Confirm arg of -b");
        Assertions.assertTrue((boolean)cl.getArgList().isEmpty(), (String)"Confirm NO of extra args");
    }

    @Test
    public void testOptionGroup() throws Exception {
        OptionGroup group = new OptionGroup();
        group.addOption(OptionBuilder.create((String)"a"));
        group.addOption(OptionBuilder.create((String)"b"));
        Options options = new Options();
        options.addOptionGroup(group);
        this.parser.parse(options, new String[]{"-b"});
        Assertions.assertEquals((Object)"b", (Object)group.getSelected(), (String)"selected option");
    }

    @Test
    public void testOptionGroupLong() throws Exception {
        OptionGroup group = new OptionGroup();
        OptionBuilder.withLongOpt((String)"foo");
        group.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"bar");
        group.addOption(OptionBuilder.create());
        Options options = new Options();
        options.addOptionGroup(group);
        CommandLine cl = this.parser.parse(options, new String[]{"--bar"});
        Assertions.assertTrue((boolean)cl.hasOption("bar"));
        Assertions.assertEquals((Object)"bar", (Object)group.getSelected(), (String)"selected option");
    }

    @Test
    public void testPartialLongOptionSingleDash() throws Exception {
        String[] args = new String[]{"-ver"};
        Options options = new Options();
        OptionBuilder.withLongOpt((String)"version");
        options.addOption(OptionBuilder.create());
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((char)'v'));
        CommandLine cl = this.parser.parse(options, args);
        Assertions.assertTrue((boolean)cl.hasOption("version"), (String)"Confirm --version is set");
        Assertions.assertFalse((boolean)cl.hasOption("v"), (String)"Confirm -v is not set");
    }

    @Test
    public void testPropertiesOption1() throws Exception {
        String[] args = new String[]{"-Jsource=1.5", "-J", "target", "1.5", "foo"};
        Options options = new Options();
        OptionBuilder.withValueSeparator();
        OptionBuilder.hasArgs((int)2);
        options.addOption(OptionBuilder.create((char)'J'));
        CommandLine cl = this.parser.parse(options, args);
        List<String> values = Arrays.asList(cl.getOptionValues("J"));
        Assertions.assertNotNull(values, (String)"null values");
        Assertions.assertEquals((int)4, (int)values.size(), (String)"number of values");
        Assertions.assertEquals((Object)"source", (Object)values.get(0), (String)"value 1");
        Assertions.assertEquals((Object)"1.5", (Object)values.get(1), (String)"value 2");
        Assertions.assertEquals((Object)"target", (Object)values.get(2), (String)"value 3");
        Assertions.assertEquals((Object)"1.5", (Object)values.get(3), (String)"value 4");
        List argsleft = cl.getArgList();
        Assertions.assertEquals((int)1, (int)argsleft.size(), (String)"Should be 1 arg left");
        Assertions.assertEquals((Object)"foo", argsleft.get(0), (String)"Expecting foo");
    }

    @Test
    public void testPropertiesOption2() throws Exception {
        String[] args = new String[]{"-Dparam1", "-Dparam2=value2", "-D"};
        Options options = new Options();
        OptionBuilder.withValueSeparator();
        OptionBuilder.hasOptionalArgs((int)2);
        options.addOption(OptionBuilder.create((char)'D'));
        CommandLine cl = this.parser.parse(options, args);
        Properties props = cl.getOptionProperties("D");
        Assertions.assertNotNull((Object)props, (String)"null properties");
        Assertions.assertEquals((int)2, (int)props.size(), (String)("number of properties in " + props));
        Assertions.assertEquals((Object)"true", (Object)props.getProperty("param1"), (String)"property 1");
        Assertions.assertEquals((Object)"value2", (Object)props.getProperty("param2"), (String)"property 2");
        List argsleft = cl.getArgList();
        Assertions.assertEquals((int)0, (int)argsleft.size(), (String)"Should be no arg left");
    }

    @Test
    public void testPropertyOptionFlags() throws Exception {
        Options options = new Options();
        options.addOption("a", false, "toggle -a");
        options.addOption("c", "c", false, "toggle -c");
        OptionBuilder.hasOptionalArg();
        options.addOption(OptionBuilder.create((char)'e'));
        Properties properties = new Properties();
        properties.setProperty("a", "true");
        properties.setProperty("c", "yes");
        properties.setProperty("e", "1");
        CommandLine cmd = this.parse(this.parser, options, null, properties);
        Assertions.assertTrue((boolean)cmd.hasOption("a"));
        Assertions.assertTrue((boolean)cmd.hasOption("c"));
        Assertions.assertTrue((boolean)cmd.hasOption("e"));
        properties = new Properties();
        properties.setProperty("a", "false");
        properties.setProperty("c", "no");
        properties.setProperty("e", "0");
        cmd = this.parse(this.parser, options, null, properties);
        Assertions.assertFalse((boolean)cmd.hasOption("a"));
        Assertions.assertFalse((boolean)cmd.hasOption("c"));
        Assertions.assertTrue((boolean)cmd.hasOption("e"));
        properties = new Properties();
        properties.setProperty("a", "TRUE");
        properties.setProperty("c", "nO");
        properties.setProperty("e", "TrUe");
        cmd = this.parse(this.parser, options, null, properties);
        Assertions.assertTrue((boolean)cmd.hasOption("a"));
        Assertions.assertFalse((boolean)cmd.hasOption("c"));
        Assertions.assertTrue((boolean)cmd.hasOption("e"));
        properties = new Properties();
        properties.setProperty("a", "just a string");
        properties.setProperty("e", "");
        cmd = this.parse(this.parser, options, null, properties);
        Assertions.assertFalse((boolean)cmd.hasOption("a"));
        Assertions.assertFalse((boolean)cmd.hasOption("c"));
        Assertions.assertTrue((boolean)cmd.hasOption("e"));
        properties = new Properties();
        properties.setProperty("a", "0");
        properties.setProperty("c", "1");
        cmd = this.parse(this.parser, options, null, properties);
        Assertions.assertFalse((boolean)cmd.hasOption("a"));
        Assertions.assertTrue((boolean)cmd.hasOption("c"));
    }

    @Test
    public void testPropertyOptionGroup() throws Exception {
        Options options = new Options();
        OptionGroup group1 = new OptionGroup();
        group1.addOption(new Option("a", null));
        group1.addOption(new Option("b", null));
        options.addOptionGroup(group1);
        OptionGroup group2 = new OptionGroup();
        group2.addOption(new Option("x", null));
        group2.addOption(new Option("y", null));
        options.addOptionGroup(group2);
        String[] args = new String[]{"-a"};
        Properties properties = new Properties();
        properties.put("b", "true");
        properties.put("x", "true");
        CommandLine cmd = this.parse(this.parser, options, args, properties);
        Assertions.assertTrue((boolean)cmd.hasOption("a"));
        Assertions.assertFalse((boolean)cmd.hasOption("b"));
        Assertions.assertTrue((boolean)cmd.hasOption("x"));
        Assertions.assertFalse((boolean)cmd.hasOption("y"));
    }

    @Test
    public void testPropertyOptionMultipleValues() throws Exception {
        Options options = new Options();
        OptionBuilder.hasArgs();
        OptionBuilder.withValueSeparator((char)',');
        options.addOption(OptionBuilder.create((char)'k'));
        Properties properties = new Properties();
        properties.setProperty("k", "one,two");
        CommandLine cmd = this.parse(this.parser, options, null, properties);
        Assertions.assertTrue((boolean)cmd.hasOption("k"));
        Object[] values = new String[]{"one", "two"};
        Assertions.assertArrayEquals((Object[])values, (Object[])cmd.getOptionValues('k'));
    }

    @Test
    public void testPropertyOptionRequired() throws Exception {
        Options options = new Options();
        OptionBuilder.isRequired();
        options.addOption(OptionBuilder.create((String)"f"));
        Properties properties = new Properties();
        properties.setProperty("f", "true");
        CommandLine cmd = this.parse(this.parser, options, null, properties);
        Assertions.assertTrue((boolean)cmd.hasOption("f"));
    }

    @Test
    public void testPropertyOptionSingularValue() throws Exception {
        Options options = new Options();
        OptionBuilder.hasOptionalArgs((int)2);
        OptionBuilder.withLongOpt((String)"hide");
        options.addOption(OptionBuilder.create());
        Properties properties = new Properties();
        properties.setProperty("hide", "seek");
        CommandLine cmd = this.parse(this.parser, options, null, properties);
        Assertions.assertTrue((boolean)cmd.hasOption("hide"));
        Assertions.assertEquals((Object)"seek", (Object)cmd.getOptionValue("hide"));
        Assertions.assertFalse((boolean)cmd.hasOption("fake"));
    }

    @Test
    public void testPropertyOptionUnexpected() throws Exception {
        Options options = new Options();
        Properties properties = new Properties();
        properties.setProperty("f", "true");
        try {
            this.parse(this.parser, options, null, properties);
            Assertions.fail((String)"UnrecognizedOptionException expected");
        }
        catch (UnrecognizedOptionException unrecognizedOptionException) {
            // empty catch block
        }
    }

    @Test
    public void testPropertyOverrideValues() throws Exception {
        Options options = new Options();
        OptionBuilder.hasOptionalArgs((int)2);
        options.addOption(OptionBuilder.create((char)'i'));
        OptionBuilder.hasOptionalArgs();
        options.addOption(OptionBuilder.create((char)'j'));
        String[] args = new String[]{"-j", "found", "-i", "ink"};
        Properties properties = new Properties();
        properties.setProperty("j", "seek");
        CommandLine cmd = this.parse(this.parser, options, args, properties);
        Assertions.assertTrue((boolean)cmd.hasOption("j"));
        Assertions.assertEquals((Object)"found", (Object)cmd.getOptionValue("j"));
        Assertions.assertTrue((boolean)cmd.hasOption("i"));
        Assertions.assertEquals((Object)"ink", (Object)cmd.getOptionValue("i"));
        Assertions.assertFalse((boolean)cmd.hasOption("fake"));
    }

    @Test
    public void testReuseOptionsTwice() throws Exception {
        Options options = new Options();
        OptionBuilder.isRequired();
        options.addOption(OptionBuilder.create((char)'v'));
        this.parser.parse(options, new String[]{"-v"});
        try {
            this.parser.parse(options, new String[0]);
            Assertions.fail((String)"MissingOptionException not thrown");
        }
        catch (MissingOptionException missingOptionException) {
            // empty catch block
        }
    }

    @Test
    public void testShortOptionConcatenatedQuoteHandling() throws Exception {
        CommandLine cl = this.parser.parse(this.options, new String[]{"-b\"quoted string\""});
        Assertions.assertEquals((Object)"quoted string", (Object)cl.getOptionValue("b"), (String)"Confirm -b\"arg\" strips quotes");
    }

    @Test
    public void testShortOptionQuoteHandling() throws Exception {
        CommandLine cl = this.parser.parse(this.options, new String[]{"-b", "\"quoted string\""});
        Assertions.assertEquals((Object)"quoted string", (Object)cl.getOptionValue("b"), (String)"Confirm -b \"arg\" strips quotes");
    }

    @Test
    public void testShortWithEqual() throws Exception {
        Options options = new Options();
        OptionBuilder.withLongOpt((String)"foo");
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((char)'f'));
        CommandLine cl = this.parser.parse(options, new String[]{"-f=bar"});
        Assertions.assertEquals((Object)"bar", (Object)cl.getOptionValue("foo"));
    }

    @Test
    public void testShortWithoutEqual() throws Exception {
        Options options = new Options();
        OptionBuilder.withLongOpt((String)"foo");
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((char)'f'));
        CommandLine cl = this.parser.parse(options, new String[]{"-fbar"});
        Assertions.assertEquals((Object)"bar", (Object)cl.getOptionValue("foo"));
    }

    @Test
    public void testShortWithUnexpectedArgument() throws Exception {
        Options options = new Options();
        OptionBuilder.withLongOpt((String)"foo");
        options.addOption(OptionBuilder.create((char)'f'));
        try {
            this.parser.parse(options, new String[]{"-f=bar"});
        }
        catch (UnrecognizedOptionException e) {
            Assertions.assertEquals((Object)"-f=bar", (Object)e.getOption());
            return;
        }
        Assertions.fail((String)"UnrecognizedOptionException not thrown");
    }

    @Test
    public void testSimpleLong() throws Exception {
        CommandLine cl = this.parser.parse(this.options, new String[]{"--enable-a", "--bfile", "toast", "foo", "bar"});
        Assertions.assertTrue((boolean)cl.hasOption("a"), (String)"Confirm -a is set");
        Assertions.assertTrue((boolean)cl.hasOption("b"), (String)"Confirm -b is set");
        Assertions.assertEquals((Object)"toast", (Object)cl.getOptionValue("b"), (String)"Confirm arg of -b");
        Assertions.assertEquals((Object)"toast", (Object)cl.getOptionValue("bfile"), (String)"Confirm arg of --bfile");
        Assertions.assertEquals((int)2, (int)cl.getArgList().size(), (String)"Confirm size of extra args");
    }

    @Test
    public void testSimpleShort() throws Exception {
        CommandLine cl = this.parser.parse(this.options, new String[]{"-a", "-b", "toast", "foo", "bar"});
        Assertions.assertTrue((boolean)cl.hasOption("a"), (String)"Confirm -a is set");
        Assertions.assertTrue((boolean)cl.hasOption("b"), (String)"Confirm -b is set");
        Assertions.assertEquals((Object)"toast", (Object)cl.getOptionValue("b"), (String)"Confirm arg of -b");
        Assertions.assertEquals((int)2, (int)cl.getArgList().size(), (String)"Confirm size of extra args");
    }

    @Test
    public void testSingleDash() throws Exception {
        CommandLine cl = this.parser.parse(this.options, new String[]{"--copt", "-b", "-", "-a", "-"});
        Assertions.assertTrue((boolean)cl.hasOption("a"), (String)"Confirm -a is set");
        Assertions.assertTrue((boolean)cl.hasOption("b"), (String)"Confirm -b is set");
        Assertions.assertEquals((Object)"-", (Object)cl.getOptionValue("b"), (String)"Confirm arg of -b");
        Assertions.assertEquals((int)1, (int)cl.getArgList().size(), (String)("Confirm 1 extra arg: " + cl.getArgList().size()));
        Assertions.assertEquals((Object)"-", cl.getArgList().get(0), (String)("Confirm value of extra arg: " + (String)cl.getArgList().get(0)));
    }

    @Test
    public void testStopAtExpectedArg() throws Exception {
        String[] args = new String[]{"-b", "foo"};
        CommandLine cl = this.parser.parse(this.options, args, true);
        Assertions.assertTrue((boolean)cl.hasOption('b'), (String)"Confirm -b is set");
        Assertions.assertEquals((Object)"foo", (Object)cl.getOptionValue('b'), (String)"Confirm -b is set");
        Assertions.assertTrue((boolean)cl.getArgList().isEmpty(), (String)("Confirm no extra args: " + cl.getArgList().size()));
    }

    @Test
    public void testStopAtNonOptionLong() throws Exception {
        String[] args = new String[]{"--zop==1", "-abtoast", "--b=bar"};
        CommandLine cl = this.parser.parse(this.options, args, true);
        Assertions.assertFalse((boolean)cl.hasOption("a"), (String)"Confirm -a is not set");
        Assertions.assertFalse((boolean)cl.hasOption("b"), (String)"Confirm -b is not set");
        Assertions.assertEquals((int)3, (int)cl.getArgList().size(), (String)("Confirm  3 extra args: " + cl.getArgList().size()));
    }

    @Test
    public void testStopAtNonOptionShort() throws Exception {
        CommandLine cl = this.parser.parse(this.options, new String[]{"-z", "-a", "-btoast"}, true);
        Assertions.assertFalse((boolean)cl.hasOption("a"), (String)"Confirm -a is not set");
        Assertions.assertEquals((int)3, (int)cl.getArgList().size(), (String)("Confirm  3 extra args: " + cl.getArgList().size()));
    }

    @Test
    public void testStopAtUnexpectedArg() throws Exception {
        CommandLine cl = this.parser.parse(this.options, new String[]{"-c", "foober", "-b", "toast"}, true);
        Assertions.assertTrue((boolean)cl.hasOption("c"), (String)"Confirm -c is set");
        Assertions.assertEquals((int)3, (int)cl.getArgList().size(), (String)("Confirm  3 extra args: " + cl.getArgList().size()));
    }

    @Test
    public void testStopBursting() throws Exception {
        CommandLine cl = this.parser.parse(this.options, new String[]{"-azc"}, true);
        Assertions.assertTrue((boolean)cl.hasOption("a"), (String)"Confirm -a is set");
        Assertions.assertFalse((boolean)cl.hasOption("c"), (String)"Confirm -c is not set");
        Assertions.assertEquals((int)1, (int)cl.getArgList().size(), (String)("Confirm  1 extra arg: " + cl.getArgList().size()));
        Assertions.assertTrue((boolean)cl.getArgList().contains("zc"));
    }

    @Test
    public void testStopBursting2() throws Exception {
        CommandLine cl = this.parser.parse(this.options, new String[]{"-c", "foobar", "-btoast"}, true);
        Assertions.assertTrue((boolean)cl.hasOption("c"), (String)"Confirm -c is set");
        Assertions.assertEquals((int)2, (int)cl.getArgList().size(), (String)("Confirm  2 extra args: " + cl.getArgList().size()));
        cl = this.parser.parse(this.options, cl.getArgs());
        Assertions.assertFalse((boolean)cl.hasOption("c"), (String)"Confirm -c is not set");
        Assertions.assertTrue((boolean)cl.hasOption("b"), (String)"Confirm -b is set");
        Assertions.assertEquals((Object)"toast", (Object)cl.getOptionValue("b"), (String)"Confirm arg of -b");
        Assertions.assertEquals((int)1, (int)cl.getArgList().size(), (String)("Confirm  1 extra arg: " + cl.getArgList().size()));
        Assertions.assertEquals((Object)"foobar", cl.getArgList().get(0), (String)("Confirm  value of extra arg: " + (String)cl.getArgList().get(0)));
    }

    @Test
    public void testUnambiguousPartialLongOption1() throws Exception {
        Options options = new Options();
        OptionBuilder.withLongOpt((String)"version");
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"help");
        options.addOption(OptionBuilder.create());
        CommandLine cl = this.parser.parse(options, new String[]{"--ver"});
        Assertions.assertTrue((boolean)cl.hasOption("version"), (String)"Confirm --version is set");
    }

    @Test
    public void testUnambiguousPartialLongOption2() throws Exception {
        Options options = new Options();
        OptionBuilder.withLongOpt((String)"version");
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"help");
        options.addOption(OptionBuilder.create());
        CommandLine cl = this.parser.parse(options, new String[]{"-ver"});
        Assertions.assertTrue((boolean)cl.hasOption("version"), (String)"Confirm --version is set");
    }

    @Test
    public void testUnambiguousPartialLongOption3() throws Exception {
        Options options = new Options();
        OptionBuilder.withLongOpt((String)"verbose");
        OptionBuilder.hasOptionalArg();
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"help");
        options.addOption(OptionBuilder.create());
        CommandLine cl = this.parser.parse(options, new String[]{"--ver=1"});
        Assertions.assertTrue((boolean)cl.hasOption("verbose"), (String)"Confirm --verbose is set");
        Assertions.assertEquals((Object)"1", (Object)cl.getOptionValue("verbose"));
    }

    @Test
    public void testUnambiguousPartialLongOption4() throws Exception {
        Options options = new Options();
        OptionBuilder.withLongOpt((String)"verbose");
        OptionBuilder.hasOptionalArg();
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"help");
        options.addOption(OptionBuilder.create());
        CommandLine cl = this.parser.parse(options, new String[]{"-ver=1"});
        Assertions.assertTrue((boolean)cl.hasOption("verbose"), (String)"Confirm --verbose is set");
        Assertions.assertEquals((Object)"1", (Object)cl.getOptionValue("verbose"));
    }

    @Test
    public void testUnlimitedArgs() throws Exception {
        Options options = new Options();
        OptionBuilder.hasArgs();
        options.addOption(OptionBuilder.create((String)"e"));
        OptionBuilder.hasArgs();
        options.addOption(OptionBuilder.create((String)"f"));
        CommandLine cl = this.parser.parse(options, new String[]{"-e", "one", "two", "-f", "alpha"});
        Assertions.assertTrue((boolean)cl.hasOption("e"), (String)"Confirm -e is set");
        Assertions.assertEquals((int)2, (int)cl.getOptionValues("e").length, (String)"number of arg for -e");
        Assertions.assertTrue((boolean)cl.hasOption("f"), (String)"Confirm -f is set");
        Assertions.assertEquals((int)1, (int)cl.getOptionValues("f").length, (String)"number of arg for -f");
    }

    @Test
    public void testUnrecognizedOption() throws Exception {
        try {
            this.parser.parse(this.options, new String[]{"-a", "-d", "-b", "toast", "foo", "bar"});
            Assertions.fail((String)"UnrecognizedOptionException wasn't thrown");
        }
        catch (UnrecognizedOptionException e) {
            Assertions.assertEquals((Object)"-d", (Object)e.getOption());
        }
    }

    @Test
    public void testUnrecognizedOptionWithBursting() throws Exception {
        try {
            this.parser.parse(this.options, new String[]{"-adbtoast", "foo", "bar"});
            Assertions.fail((String)"UnrecognizedOptionException wasn't thrown");
        }
        catch (UnrecognizedOptionException e) {
            Assertions.assertEquals((Object)"-adbtoast", (Object)e.getOption());
        }
    }

    @Test
    public void testWithRequiredOption() throws Exception {
        String[] args = new String[]{"-b", "file"};
        Options options = new Options();
        options.addOption("a", "enable-a", false, null);
        OptionBuilder.withLongOpt((String)"bfile");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired();
        options.addOption(OptionBuilder.create((char)'b'));
        CommandLine cl = this.parser.parse(options, args);
        Assertions.assertFalse((boolean)cl.hasOption("a"), (String)"Confirm -a is NOT set");
        Assertions.assertTrue((boolean)cl.hasOption("b"), (String)"Confirm -b is set");
        Assertions.assertEquals((Object)"file", (Object)cl.getOptionValue("b"), (String)"Confirm arg of -b");
        Assertions.assertTrue((boolean)cl.getArgList().isEmpty(), (String)"Confirm NO of extra args");
    }
}

