/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.junit.Assert;
import org.junit.Test;

public class DisablePartialMatchingTest {
    @Test
    public void testDisablePartialMatching() throws Exception {
        DefaultParser parser = new DefaultParser(false);
        Options options = new Options();
        options.addOption(new Option("d", "debug", false, "Turn on debug."));
        options.addOption(new Option("e", "extract", false, "Turn on extract."));
        options.addOption(new Option("o", "option", true, "Turn on option with argument."));
        CommandLine line = parser.parse(options, new String[]{"-de", "--option=foobar"});
        Assert.assertTrue((String)"There should be an option debug in any case...", (boolean)line.hasOption("debug"));
        Assert.assertTrue((String)"There should be an extract option because partial matching is off", (boolean)line.hasOption("extract"));
        Assert.assertTrue((String)"There should be an option option with a argument value", (boolean)line.hasOption("option"));
    }

    @Test
    public void testRegularPartialMatching() throws Exception {
        DefaultParser parser = new DefaultParser();
        Options options = new Options();
        options.addOption(new Option("d", "debug", false, "Turn on debug."));
        options.addOption(new Option("e", "extract", false, "Turn on extract."));
        options.addOption(new Option("o", "option", true, "Turn on option with argument."));
        CommandLine line = parser.parse(options, new String[]{"-de", "--option=foobar"});
        Assert.assertTrue((String)"There should be an option debug in any case...", (boolean)line.hasOption("debug"));
        Assert.assertFalse((String)"There should not be an extract option because partial matching only selects debug", (boolean)line.hasOption("extract"));
        Assert.assertTrue((String)"There should be an option option with a argument value", (boolean)line.hasOption("option"));
    }
}

