/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli;

import org.apache.commons.cli.AbstractParserTestCase;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DefaultParserTest
extends AbstractParserTestCase {
    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.parser = new DefaultParser();
    }

    @Test
    public void testBuilder() {
        this.parser = DefaultParser.builder().setStripLeadingAndTrailingQuotes(Boolean.valueOf(false)).setAllowPartialMatching(false).build();
        Assert.assertEquals(DefaultParser.class, (Object)this.parser.getClass());
    }

    @Test
    public void testLongOptionQuoteHandlingWithoutStrip() throws Exception {
        this.parser = DefaultParser.builder().setStripLeadingAndTrailingQuotes(Boolean.valueOf(false)).build();
        String[] args = new String[]{"--bfile", "\"quoted string\""};
        CommandLine cl = this.parser.parse(this.options, args);
        Assert.assertEquals((String)"Confirm --bfile \"arg\" keeps quotes", (Object)"\"quoted string\"", (Object)cl.getOptionValue("b"));
    }

    @Test
    public void testLongOptionQuoteHandlingWithStrip() throws Exception {
        this.parser = DefaultParser.builder().setStripLeadingAndTrailingQuotes(Boolean.valueOf(true)).build();
        String[] args = new String[]{"--bfile", "\"quoted string\""};
        CommandLine cl = this.parser.parse(this.options, args);
        Assert.assertEquals((String)"Confirm --bfile \"arg\" strips quotes", (Object)"quoted string", (Object)cl.getOptionValue("b"));
    }

    @Override
    @Test
    public void testLongOptionWithEqualsQuoteHandling() throws Exception {
        String[] args = new String[]{"--bfile=\"quoted string\""};
        CommandLine cl = this.parser.parse(this.options, args);
        Assert.assertEquals((String)"Confirm --bfile=\"arg\" strips quotes", (Object)"\"quoted string\"", (Object)cl.getOptionValue("b"));
    }

    @Test
    public void testLongOptionWithEqualsQuoteHandlingWithoutStrip() throws Exception {
        this.parser = DefaultParser.builder().setStripLeadingAndTrailingQuotes(Boolean.valueOf(false)).build();
        String[] args = new String[]{"--bfile=\"quoted string\""};
        CommandLine cl = this.parser.parse(this.options, args);
        Assert.assertEquals((String)"Confirm --bfile=\"arg\" keeps quotes", (Object)"\"quoted string\"", (Object)cl.getOptionValue("b"));
    }

    @Test
    public void testLongOptionWithEqualsQuoteHandlingWithStrip() throws Exception {
        this.parser = DefaultParser.builder().setStripLeadingAndTrailingQuotes(Boolean.valueOf(true)).build();
        String[] args = new String[]{"--bfile=\"quoted string\""};
        CommandLine cl = this.parser.parse(this.options, args);
        Assert.assertEquals((String)"Confirm --bfile=\"arg\" strips quotes", (Object)"quoted string", (Object)cl.getOptionValue("b"));
    }

    @Override
    @Test
    public void testShortOptionConcatenatedQuoteHandling() throws Exception {
        String[] args = new String[]{"-b\"quoted string\""};
        CommandLine cl = this.parser.parse(this.options, args);
        Assert.assertEquals((String)"Confirm -b\"arg\" keeps quotes", (Object)"\"quoted string\"", (Object)cl.getOptionValue("b"));
    }

    @Test
    public void testShortOptionQuoteHandlingWithoutStrip() throws Exception {
        this.parser = DefaultParser.builder().setStripLeadingAndTrailingQuotes(Boolean.valueOf(false)).build();
        String[] args = new String[]{"-b", "\"quoted string\""};
        CommandLine cl = this.parser.parse(this.options, args);
        Assert.assertEquals((String)"Confirm -b \"arg\" keeps quotes", (Object)"\"quoted string\"", (Object)cl.getOptionValue("b"));
    }

    @Test
    public void testShortOptionQuoteHandlingWithStrip() throws Exception {
        this.parser = DefaultParser.builder().setStripLeadingAndTrailingQuotes(Boolean.valueOf(true)).build();
        String[] args = new String[]{"-b", "\"quoted string\""};
        CommandLine cl = this.parser.parse(this.options, args);
        Assert.assertEquals((String)"Confirm -b \"arg\" strips quotes", (Object)"quoted string", (Object)cl.getOptionValue("b"));
    }
}

