/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli.bug;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Types;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BugCLI162Test {
    private static final String CR = System.lineSeparator();
    private static final String OPT = "-";
    private static final String OPT_COLUMN_NAMES = "l";
    private static final String OPT_CONNECTION = "c";
    private static final String OPT_DESCRIPTION = "e";
    private static final String OPT_DRIVER = "d";
    private static final String OPT_DRIVER_INFO = "n";
    private static final String OPT_FILE_BINDING = "b";
    private static final String OPT_FILE_JDBC = "j";
    private static final String OPT_FILE_SFMD = "f";
    private static final String OPT_HELP = "h";
    private static final String OPT_HELP_LONG = "help";
    private static final String OPT_INTERACTIVE = "i";
    private static final String OPT_JDBC_TO_SFMD = "2";
    private static final String OPT_JDBC_TO_SFMD_L = "jdbc2sfmd";
    private static final String OPT_METADATA = "m";
    private static final String OPT_PARAM_MODES_INT = "o";
    private static final String OPT_PARAM_MODES_NAME = "O";
    private static final String OPT_PARAM_NAMES = "a";
    private static final String OPT_PARAM_TYPES_INT = "y";
    private static final String OPT_PARAM_TYPES_NAME = "Y";
    private static final String OPT_PASSWORD = "p";
    private static final String OPT_PASSWORD_L = "password";
    private static final String OPT_SQL = "s";
    private static final String OPT_SQL_L = "sql";
    private static final String OPT_STACK_TRACE = "t";
    private static final String OPT_TIMING = "g";
    private static final String OPT_TRIM_L = "trim";
    private static final String OPT_USER = "u";
    private static final String OPT_WRITE_TO_FILE = "w";
    private static final String PMODE_IN = "IN";
    private static final String PMODE_INOUT = "INOUT";
    private static final String PMODE_OUT = "OUT";
    private static final String PMODE_UNK = "Unknown";
    private static final String PMODES = "IN, INOUT, OUT, Unknown";
    private HelpFormatter formatter;
    private StringWriter sw;

    @Before
    public void setUp() {
        this.formatter = new HelpFormatter();
        this.sw = new StringWriter();
    }

    @Test
    public void testInfiniteLoop() {
        Options options = new Options();
        options.addOption(OPT_HELP, OPT_HELP_LONG, false, "This is a looooong description");
        this.formatter.printHelp(new PrintWriter(this.sw), 20, "app", null, options, 1, 3, null);
        String expected = "usage: app" + CR + " -h,--help   This is" + CR + "             a" + CR + "             looooon" + CR + "             g" + CR + "             descrip" + CR + "             tion" + CR;
        Assert.assertEquals((Object)expected, (Object)this.sw.toString());
    }

    @Test
    public void testLongLineChunking() {
        Options options = new Options();
        options.addOption("x", "extralongarg", false, "This description has ReallyLongValuesThatAreLongerThanTheWidthOfTheColumns and also other ReallyLongValuesThatAreHugerAndBiggerThanTheWidthOfTheColumnsBob, yes. ");
        this.formatter.printHelp(new PrintWriter(this.sw), 35, this.getClass().getName(), "Header", options, 0, 5, "Footer");
        String expected = "usage:" + CR + "       org.apache.commons.cli.bug.B" + CR + "       ugCLI162Test" + CR + "Header" + CR + "-x,--extralongarg     This" + CR + "                      description" + CR + "                      has" + CR + "                      ReallyLongVal" + CR + "                      uesThatAreLon" + CR + "                      gerThanTheWid" + CR + "                      thOfTheColumn" + CR + "                      s and also" + CR + "                      other" + CR + "                      ReallyLongVal" + CR + "                      uesThatAreHug" + CR + "                      erAndBiggerTh" + CR + "                      anTheWidthOfT" + CR + "                      heColumnsBob," + CR + "                      yes." + CR + "Footer" + CR;
        Assert.assertEquals((String)"Long arguments did not split as expected", (Object)expected, (Object)this.sw.toString());
    }

    @Test
    public void testLongLineChunkingIndentIgnored() {
        Options options = new Options();
        options.addOption("x", "extralongarg", false, "This description is Long.");
        this.formatter.printHelp(new PrintWriter(this.sw), 22, this.getClass().getName(), "Header", options, 0, 5, "Footer");
        String expected = "usage:" + CR + "       org.apache.comm" + CR + "       ons.cli.bug.Bug" + CR + "       CLI162Test" + CR + "Header" + CR + "-x,--extralongarg" + CR + " This description is" + CR + " Long." + CR + "Footer" + CR;
        Assert.assertEquals((String)"Long arguments did not split as expected", (Object)expected, (Object)this.sw.toString());
    }

    @Test
    public void testPrintHelpLongLines() {
        Options commandLineOptions = new Options();
        commandLineOptions.addOption(OPT_HELP, OPT_HELP_LONG, false, "Prints help and quits");
        commandLineOptions.addOption(OPT_DRIVER, "driver", true, "JDBC driver class name");
        commandLineOptions.addOption(OPT_DRIVER_INFO, "info", false, "Prints driver information and properties. If -c is not specified, all drivers on the classpath are displayed.");
        commandLineOptions.addOption(OPT_CONNECTION, "url", true, "Connection URL");
        commandLineOptions.addOption(OPT_USER, "user", true, "A database user name");
        commandLineOptions.addOption(OPT_PASSWORD, OPT_PASSWORD_L, true, "The database password for the user specified with the -u option. You can obfuscate the password with org.mortbay.jetty.security.Password, see http://docs.codehaus.org/display/JETTY/Securing+Passwords");
        commandLineOptions.addOption(OPT_SQL, OPT_SQL_L, true, "Runs SQL or {call stored_procedure(?, ?)} or {?=call function(?, ?)}");
        commandLineOptions.addOption(OPT_FILE_SFMD, "sfmd", true, "Writes a SFMD file for the given SQL");
        commandLineOptions.addOption(OPT_FILE_BINDING, "jdbc", true, "Writes a JDBC binding node file for the given SQL");
        commandLineOptions.addOption(OPT_FILE_JDBC, "node", true, "Writes a JDBC node file for the given SQL (internal debugging)");
        commandLineOptions.addOption(OPT_WRITE_TO_FILE, "outfile", true, "Writes the SQL output to the given file");
        commandLineOptions.addOption(OPT_DESCRIPTION, "description", true, "SFMD description. A default description is used if omited. Example: -e \"Runs such and such\"");
        commandLineOptions.addOption(OPT_INTERACTIVE, "interactive", false, "Runs in interactive mode, reading and writing from the console, 'go' or '/' sends a statement");
        commandLineOptions.addOption(OPT_TIMING, "printTiming", false, "Prints timing information");
        commandLineOptions.addOption(OPT_METADATA, "printMetaData", false, "Prints metadata information");
        commandLineOptions.addOption(OPT_STACK_TRACE, "printStack", false, "Prints stack traces on errors");
        Option option = new Option(OPT_COLUMN_NAMES, "columnNames", true, "Column XML names; default names column labels. Example: -l \"cname1 cname2\"");
        commandLineOptions.addOption(option);
        option = new Option(OPT_PARAM_NAMES, "paramNames", true, "Parameter XML names; default names are param1, param2, etc. Example: -a \"pname1 pname2\"");
        commandLineOptions.addOption(option);
        OptionGroup pOutTypesOptionGroup = new OptionGroup();
        String pOutTypesOptionGroupDoc = "-y and -Y are mutually exclusive.";
        String typesClassName = Types.class.getName();
        option = new Option(OPT_PARAM_TYPES_INT, "paramTypes", true, "Parameter types from " + typesClassName + ". " + "-y and -Y are mutually exclusive." + " Example: " + OPT + OPT_PARAM_TYPES_INT + " \"-10 12\"");
        commandLineOptions.addOption(option);
        option = new Option(OPT_PARAM_TYPES_NAME, "paramTypeNames", true, "Parameter " + typesClassName + " names. " + "-y and -Y are mutually exclusive." + " Example: " + OPT + OPT_PARAM_TYPES_NAME + " \"CURSOR VARCHAR\"");
        commandLineOptions.addOption(option);
        commandLineOptions.addOptionGroup(pOutTypesOptionGroup);
        OptionGroup modesOptionGroup = new OptionGroup();
        String modesOptionGroupDoc = "-o and -O are mutually exclusive.";
        option = new Option(OPT_PARAM_MODES_INT, "paramModes", true, "Parameters modes (1=IN, 2=INOUT, 4=OUT, 0=Unknown). -o and -O are mutually exclusive. Example for 2 parameters, OUT and IN: -o \"4 1\"");
        modesOptionGroup.addOption(option);
        option = new Option(OPT_PARAM_MODES_NAME, "paramModeNames", true, "Parameters mode names (IN, INOUT, OUT, Unknown). -o and -O are mutually exclusive. Example for 2 parameters, OUT and IN: -O \"OUT IN\"");
        modesOptionGroup.addOption(option);
        commandLineOptions.addOptionGroup(modesOptionGroup);
        option = new Option(null, OPT_TRIM_L, true, "Trims leading and trailing spaces from all column values. Column XML names can be optionally specified to set which columns to trim.");
        option.setOptionalArg(true);
        commandLineOptions.addOption(option);
        option = new Option(OPT_JDBC_TO_SFMD, OPT_JDBC_TO_SFMD_L, true, "Converts the JDBC file in the first argument to an SMFD file specified in the second argument.");
        option.setArgs(2);
        commandLineOptions.addOption(option);
        this.formatter.printHelp(new PrintWriter(this.sw), 74, this.getClass().getName(), null, commandLineOptions, 1, 3, null);
        String expected = "usage: org.apache.commons.cli.bug.BugCLI162Test" + CR + " -2,--jdbc2sfmd <arg>        Converts the JDBC file in the first argument" + CR + "                             to an SMFD file specified in the second" + CR + "                             argument." + CR + " -a,--paramNames <arg>       Parameter XML names; default names are" + CR + "                             param1, param2, etc. Example: -a \"pname1" + CR + "                             pname2\"" + CR + " -b,--jdbc <arg>             Writes a JDBC binding node file for the given" + CR + "                             SQL" + CR + " -c,--url <arg>              Connection URL" + CR + " -d,--driver <arg>           JDBC driver class name" + CR + " -e,--description <arg>      SFMD description. A default description is" + CR + "                             used if omited. Example: -e \"Runs such and" + CR + "                             such\"" + CR + " -f,--sfmd <arg>             Writes a SFMD file for the given SQL" + CR + " -g,--printTiming            Prints timing information" + CR + " -h,--help                   Prints help and quits" + CR + " -i,--interactive            Runs in interactive mode, reading and writing" + CR + "                             from the console, 'go' or '/' sends a" + CR + "                             statement" + CR + " -j,--node <arg>             Writes a JDBC node file for the given SQL" + CR + "                             (internal debugging)" + CR + " -l,--columnNames <arg>      Column XML names; default names column" + CR + "                             labels. Example: -l \"cname1 cname2\"" + CR + " -m,--printMetaData          Prints metadata information" + CR + " -n,--info                   Prints driver information and properties. If" + CR + "                             -c is not specified, all drivers on the" + CR + "                             classpath are displayed." + CR + " -o,--paramModes <arg>       Parameters modes (1=IN, 2=INOUT, 4=OUT," + CR + "                             0=Unknown). -o and -O are mutually exclusive." + CR + "                             Example for 2 parameters, OUT and IN: -o \"4" + CR + "                             1\"" + CR + " -O,--paramModeNames <arg>   Parameters mode names (IN, INOUT, OUT," + CR + "                             Unknown). -o and -O are mutually exclusive." + CR + "                             Example for 2 parameters, OUT and IN: -O \"OUT" + CR + "                             IN\"" + CR + " -p,--password <arg>         The database password for the user specified" + CR + "                             with the -u option. You can obfuscate the" + CR + "                             password with" + CR + "                             org.mortbay.jetty.security.Password, see" + CR + "                             http://docs.codehaus.org/display/JETTY/Securi" + CR + "                             ng+Passwords" + CR + " -s,--sql <arg>              Runs SQL or {call stored_procedure(?, ?)} or" + CR + "                             {?=call function(?, ?)}" + CR + " -t,--printStack             Prints stack traces on errors" + CR + "    --trim <arg>             Trims leading and trailing spaces from all" + CR + "                             column values. Column XML names can be" + CR + "                             optionally specified to set which columns to" + CR + "                             trim." + CR + " -u,--user <arg>             A database user name" + CR + " -w,--outfile <arg>          Writes the SQL output to the given file" + CR + " -y,--paramTypes <arg>       Parameter types from java.sql.Types. -y and" + CR + "                             -Y are mutually exclusive. Example: -y \"-10" + CR + "                             12\"" + CR + " -Y,--paramTypeNames <arg>   Parameter java.sql.Types names. -y and -Y are" + CR + "                             mutually exclusive. Example: -Y \"CURSOR" + CR + "                             VARCHAR\"" + CR;
        Assert.assertEquals((Object)expected, (Object)this.sw.toString());
    }
}

