/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli;

import java.io.File;
import java.io.FileInputStream;
import java.net.URL;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PatternOptionBuilder;
import org.apache.commons.cli.TypeHandler;
import org.junit.Assert;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;

public class TypeHandlerTest {
    @Test
    public void testCreateValueClass() throws Exception {
        Object clazz = TypeHandler.createValue((String)Instantiable.class.getName(), (Class)PatternOptionBuilder.CLASS_VALUE);
        Assert.assertEquals(Instantiable.class, (Object)clazz);
    }

    @Test
    public void testCreateValueClass_notFound() {
        Assertions.assertThrows(ParseException.class, () -> TypeHandler.createValue((String)"what ever", (Class)PatternOptionBuilder.CLASS_VALUE));
    }

    @Test
    public void testCreateValueDate() {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> TypeHandler.createValue((String)"what ever", (Class)PatternOptionBuilder.DATE_VALUE));
    }

    @Test
    public void testCreateValueExistingFile() throws Exception {
        try (FileInputStream result = (FileInputStream)TypeHandler.createValue((String)"src/test/resources/org/apache/commons/cli/existing-readable.file", (Class)PatternOptionBuilder.EXISTING_FILE_VALUE);){
            Assert.assertNotNull((Object)result);
        }
    }

    @Test
    public void testCreateValueExistingFile_nonExistingFile() {
        Assertions.assertThrows(ParseException.class, () -> TypeHandler.createValue((String)"non-existing.file", (Class)PatternOptionBuilder.EXISTING_FILE_VALUE));
    }

    @Test
    public void testCreateValueFile() throws Exception {
        File result = (File)TypeHandler.createValue((String)"some-file.txt", (Class)PatternOptionBuilder.FILE_VALUE);
        Assert.assertEquals((Object)"some-file.txt", (Object)result.getName());
    }

    @Test
    public void testCreateValueFiles() {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> TypeHandler.createValue((String)"some.files", (Class)PatternOptionBuilder.FILES_VALUE));
    }

    @Test
    public void testCreateValueInteger_failure() {
        Assertions.assertThrows(ParseException.class, () -> TypeHandler.createValue((String)"just-a-string", Integer.class));
    }

    @Test
    public void testCreateValueNumber_Double() throws Exception {
        Assert.assertEquals((Object)1.5, (Object)TypeHandler.createValue((String)"1.5", (Class)PatternOptionBuilder.NUMBER_VALUE));
    }

    @Test
    public void testCreateValueNumber_Long() throws Exception {
        Assert.assertEquals((Object)15L, (Object)TypeHandler.createValue((String)"15", (Class)PatternOptionBuilder.NUMBER_VALUE));
    }

    @Test
    public void testCreateValueNumber_noNumber() {
        Assertions.assertThrows(ParseException.class, () -> TypeHandler.createValue((String)"not a number", (Class)PatternOptionBuilder.NUMBER_VALUE));
    }

    @Test
    public void testCreateValueObject_InstantiableClass() throws Exception {
        Object result = TypeHandler.createValue((String)Instantiable.class.getName(), (Class)PatternOptionBuilder.OBJECT_VALUE);
        Assert.assertTrue((boolean)(result instanceof Instantiable));
    }

    @Test
    public void testCreateValueObject_notInstantiableClass() {
        Assertions.assertThrows(ParseException.class, () -> TypeHandler.createValue((String)NotInstantiable.class.getName(), (Class)PatternOptionBuilder.OBJECT_VALUE));
    }

    @Test
    public void testCreateValueObject_unknownClass() {
        Assertions.assertThrows(ParseException.class, () -> TypeHandler.createValue((String)"unknown", (Class)PatternOptionBuilder.OBJECT_VALUE));
    }

    @Test
    public void testCreateValueString() throws Exception {
        Assert.assertEquals((Object)"String", (Object)TypeHandler.createValue((String)"String", (Class)PatternOptionBuilder.STRING_VALUE));
    }

    @Test
    public void testCreateValueURL() throws Exception {
        String urlString = "https://commons.apache.org";
        URL result = (URL)TypeHandler.createValue((String)"https://commons.apache.org", (Class)PatternOptionBuilder.URL_VALUE);
        Assert.assertEquals((Object)"https://commons.apache.org", (Object)result.toString());
    }

    @Test
    public void testCreateValueURL_malformed() {
        Assertions.assertThrows(ParseException.class, () -> TypeHandler.createValue((String)"malformed-url", (Class)PatternOptionBuilder.URL_VALUE));
    }

    public static class Instantiable {
    }

    public static final class NotInstantiable {
        private NotInstantiable() {
        }
    }
}

