/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli;

import java.io.File;
import java.io.FileInputStream;
import java.net.URL;
import java.util.Calendar;
import java.util.Date;
import java.util.Vector;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PatternOptionBuilder;
import org.apache.commons.cli.PosixParser;
import org.junit.Assert;
import org.junit.Test;

public class PatternOptionBuilderTest {
    @Test
    public void testClassPattern() throws Exception {
        Options options = PatternOptionBuilder.parsePattern((String)"c+d+");
        PosixParser parser = new PosixParser();
        CommandLine line = parser.parse(options, new String[]{"-c", "java.util.Calendar", "-d", "System.DateTime"});
        Assert.assertEquals((String)"c value", Calendar.class, (Object)line.getOptionObject("c"));
        Assert.assertNull((String)"d value", (Object)line.getOptionObject("d"));
    }

    @Test
    public void testEmptyPattern() {
        Options options = PatternOptionBuilder.parsePattern((String)"");
        Assert.assertTrue((boolean)options.getOptions().isEmpty());
    }

    @Test
    public void testExistingFilePattern() throws Exception {
        Options options = PatternOptionBuilder.parsePattern((String)"g<");
        PosixParser parser = new PosixParser();
        CommandLine line = parser.parse(options, new String[]{"-g", "src/test/resources/org/apache/commons/cli/existing-readable.file"});
        Object parsedReadableFileStream = line.getOptionObject("g");
        Assert.assertNotNull((String)"option g not parsed", (Object)parsedReadableFileStream);
        Assert.assertTrue((String)"option g not FileInputStream", (boolean)(parsedReadableFileStream instanceof FileInputStream));
    }

    @Test
    public void testExistingFilePatternFileNotExist() throws Exception {
        Options options = PatternOptionBuilder.parsePattern((String)"f<");
        PosixParser parser = new PosixParser();
        CommandLine line = parser.parse(options, new String[]{"-f", "non-existing.file"});
        Assert.assertNull((String)"option f parsed", (Object)line.getOptionObject("f"));
    }

    @Test
    public void testNumberPattern() throws Exception {
        Options options = PatternOptionBuilder.parsePattern((String)"n%d%x%");
        PosixParser parser = new PosixParser();
        CommandLine line = parser.parse(options, new String[]{"-n", "1", "-d", "2.1", "-x", "3,5"});
        Assert.assertEquals((String)"n object class", Long.class, line.getOptionObject("n").getClass());
        Assert.assertEquals((String)"n value", (Object)1L, (Object)line.getOptionObject("n"));
        Assert.assertEquals((String)"d object class", Double.class, line.getOptionObject("d").getClass());
        Assert.assertEquals((String)"d value", (Object)2.1, (Object)line.getOptionObject("d"));
        Assert.assertNull((String)"x object", (Object)line.getOptionObject("x"));
    }

    @Test
    public void testObjectPattern() throws Exception {
        Options options = PatternOptionBuilder.parsePattern((String)"o@i@n@");
        PosixParser parser = new PosixParser();
        CommandLine line = parser.parse(options, new String[]{"-o", "java.lang.String", "-i", "java.util.Calendar", "-n", "System.DateTime"});
        Assert.assertEquals((String)"o value", (Object)"", (Object)line.getOptionObject("o"));
        Assert.assertNull((String)"i value", (Object)line.getOptionObject("i"));
        Assert.assertNull((String)"n value", (Object)line.getOptionObject("n"));
    }

    @Test
    public void testRequiredOption() throws Exception {
        Options options = PatternOptionBuilder.parsePattern((String)"!n%m%");
        PosixParser parser = new PosixParser();
        try {
            parser.parse(options, new String[]{""});
            Assert.fail((String)"MissingOptionException wasn't thrown");
        }
        catch (MissingOptionException e) {
            Assert.assertEquals((long)1L, (long)e.getMissingOptions().size());
            Assert.assertTrue((boolean)e.getMissingOptions().contains("n"));
        }
    }

    @Test
    public void testSimplePattern() throws Exception {
        Options options = PatternOptionBuilder.parsePattern((String)"a:b@cde>f+n%t/m*z#");
        String[] args = new String[]{"-c", "-a", "foo", "-b", "java.util.Vector", "-e", "build.xml", "-f", "java.util.Calendar", "-n", "4.5", "-t", "https://commons.apache.org", "-z", "Thu Jun 06 17:48:57 EDT 2002", "-m", "test*"};
        PosixParser parser = new PosixParser();
        CommandLine line = parser.parse(options, args);
        Assert.assertEquals((String)"flag a", (Object)"foo", (Object)line.getOptionValue("a"));
        Assert.assertEquals((String)"string flag a", (Object)"foo", (Object)line.getOptionObject("a"));
        Assert.assertEquals((String)"object flag b", new Vector(), (Object)line.getOptionObject("b"));
        Assert.assertTrue((String)"boolean true flag c", (boolean)line.hasOption("c"));
        Assert.assertFalse((String)"boolean false flag d", (boolean)line.hasOption("d"));
        Assert.assertEquals((String)"file flag e", (Object)new File("build.xml"), (Object)line.getOptionObject("e"));
        Assert.assertEquals((String)"class flag f", Calendar.class, (Object)line.getOptionObject("f"));
        Assert.assertEquals((String)"number flag n", (Object)4.5, (Object)line.getOptionObject("n"));
        Assert.assertEquals((String)"url flag t", (Object)new URL("https://commons.apache.org"), (Object)line.getOptionObject("t"));
        Assert.assertEquals((String)"flag a", (Object)"foo", (Object)line.getOptionValue('a'));
        Assert.assertEquals((String)"string flag a", (Object)"foo", (Object)line.getOptionObject('a'));
        Assert.assertEquals((String)"object flag b", new Vector(), (Object)line.getOptionObject('b'));
        Assert.assertTrue((String)"boolean true flag c", (boolean)line.hasOption('c'));
        Assert.assertFalse((String)"boolean false flag d", (boolean)line.hasOption('d'));
        Assert.assertEquals((String)"file flag e", (Object)new File("build.xml"), (Object)line.getOptionObject('e'));
        Assert.assertEquals((String)"class flag f", Calendar.class, (Object)line.getOptionObject('f'));
        Assert.assertEquals((String)"number flag n", (Object)4.5, (Object)line.getOptionObject('n'));
        Assert.assertEquals((String)"url flag t", (Object)new URL("https://commons.apache.org"), (Object)line.getOptionObject('t'));
        try {
            Assert.assertEquals((String)"files flag m", (Object)new File[0], (Object)line.getOptionObject('m'));
            Assert.fail((String)"Multiple files are not supported yet, should have failed");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            Assert.assertEquals((String)"date flag z", (Object)new Date(1023400137276L), (Object)line.getOptionObject('z'));
            Assert.fail((String)"Date is not supported yet, should have failed");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Test
    public void testUntypedPattern() throws Exception {
        Options options = PatternOptionBuilder.parsePattern((String)"abc");
        PosixParser parser = new PosixParser();
        CommandLine line = parser.parse(options, new String[]{"-abc"});
        Assert.assertTrue((boolean)line.hasOption('a'));
        Assert.assertNull((String)"value a", (Object)line.getOptionObject('a'));
        Assert.assertTrue((boolean)line.hasOption('b'));
        Assert.assertNull((String)"value b", (Object)line.getOptionObject('b'));
        Assert.assertTrue((boolean)line.hasOption('c'));
        Assert.assertNull((String)"value c", (Object)line.getOptionObject('c'));
    }

    @Test
    public void testURLPattern() throws Exception {
        Options options = PatternOptionBuilder.parsePattern((String)"u/v/");
        PosixParser parser = new PosixParser();
        CommandLine line = parser.parse(options, new String[]{"-u", "https://commons.apache.org", "-v", "foo://commons.apache.org"});
        Assert.assertEquals((String)"u value", (Object)new URL("https://commons.apache.org"), (Object)line.getOptionObject("u"));
        Assert.assertNull((String)"v value", (Object)line.getOptionObject("v"));
    }
}

