/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli;

import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.junit.Assert;
import org.junit.Test;

public class CommandLineTest {
    @Test
    public void testBuilder() {
        CommandLine.Builder builder = new CommandLine.Builder();
        builder.addArg("foo").addArg("bar");
        builder.addOption(Option.builder((String)"T").build());
        CommandLine cmd = builder.build();
        Assert.assertEquals((Object)"foo", (Object)cmd.getArgs()[0]);
        Assert.assertEquals((Object)"bar", cmd.getArgList().get(1));
        Assert.assertEquals((Object)"T", (Object)cmd.getOptions()[0].getOpt());
    }

    @Test
    public void testBuilderNullArgs() {
        CommandLine.Builder builder = new CommandLine.Builder();
        builder.addArg(null).addArg(null);
        builder.addOption(Option.builder((String)"T").build());
        CommandLine cmd = builder.build();
        Assert.assertEquals((long)0L, (long)cmd.getArgs().length);
        Assert.assertEquals((Object)"T", (Object)cmd.getOptions()[0].getOpt());
    }

    @Test
    public void testBuilderNullOption() {
        CommandLine.Builder builder = new CommandLine.Builder();
        builder.addArg("foo").addArg("bar");
        builder.addOption(null);
        builder.addOption(null);
        builder.addOption(null);
        CommandLine cmd = builder.build();
        Assert.assertEquals((Object)"foo", (Object)cmd.getArgs()[0]);
        Assert.assertEquals((Object)"bar", cmd.getArgList().get(1));
        Assert.assertEquals((long)0L, (long)cmd.getOptions().length);
    }

    @Test
    public void testGetOptionProperties() throws Exception {
        String[] args = new String[]{"-Dparam1=value1", "-Dparam2=value2", "-Dparam3", "-Dparam4=value4", "-D", "--property", "foo=bar"};
        Options options = new Options();
        OptionBuilder.withValueSeparator();
        OptionBuilder.hasOptionalArgs((int)2);
        options.addOption(OptionBuilder.create((char)'D'));
        OptionBuilder.withValueSeparator();
        OptionBuilder.hasArgs((int)2);
        OptionBuilder.withLongOpt((String)"property");
        options.addOption(OptionBuilder.create());
        GnuParser parser = new GnuParser();
        CommandLine cl = parser.parse(options, args);
        Properties props = cl.getOptionProperties("D");
        Assert.assertNotNull((String)"null properties", (Object)props);
        Assert.assertEquals((String)("number of properties in " + props), (long)4L, (long)props.size());
        Assert.assertEquals((String)"property 1", (Object)"value1", (Object)props.getProperty("param1"));
        Assert.assertEquals((String)"property 2", (Object)"value2", (Object)props.getProperty("param2"));
        Assert.assertEquals((String)"property 3", (Object)"true", (Object)props.getProperty("param3"));
        Assert.assertEquals((String)"property 4", (Object)"value4", (Object)props.getProperty("param4"));
        Assert.assertEquals((String)"property with long format", (Object)"bar", (Object)cl.getOptionProperties("property").getProperty("foo"));
    }

    @Test
    public void testGetOptionPropertiesWithOption() throws Exception {
        String[] args = new String[]{"-Dparam1=value1", "-Dparam2=value2", "-Dparam3", "-Dparam4=value4", "-D", "--property", "foo=bar"};
        Options options = new Options();
        OptionBuilder.withValueSeparator();
        OptionBuilder.hasOptionalArgs((int)2);
        Option optionD = OptionBuilder.create((char)'D');
        OptionBuilder.withValueSeparator();
        OptionBuilder.hasArgs((int)2);
        OptionBuilder.withLongOpt((String)"property");
        Option optionProperty = OptionBuilder.create();
        options.addOption(optionD);
        options.addOption(optionProperty);
        GnuParser parser = new GnuParser();
        CommandLine cl = parser.parse(options, args);
        Properties props = cl.getOptionProperties(optionD);
        Assert.assertNotNull((String)"null properties", (Object)props);
        Assert.assertEquals((String)("number of properties in " + props), (long)4L, (long)props.size());
        Assert.assertEquals((String)"property 1", (Object)"value1", (Object)props.getProperty("param1"));
        Assert.assertEquals((String)"property 2", (Object)"value2", (Object)props.getProperty("param2"));
        Assert.assertEquals((String)"property 3", (Object)"true", (Object)props.getProperty("param3"));
        Assert.assertEquals((String)"property 4", (Object)"value4", (Object)props.getProperty("param4"));
        Assert.assertEquals((String)"property with long format", (Object)"bar", (Object)cl.getOptionProperties(optionProperty).getProperty("foo"));
    }

    @Test
    public void testGetOptions() {
        CommandLine cmd = new CommandLine();
        Assert.assertNotNull((Object)cmd.getOptions());
        Assert.assertEquals((long)0L, (long)cmd.getOptions().length);
        cmd.addOption(new Option("a", null));
        cmd.addOption(new Option("b", null));
        cmd.addOption(new Option("c", null));
        Assert.assertEquals((long)3L, (long)cmd.getOptions().length);
    }

    @Test
    public void testGetParsedOptionValue() throws Exception {
        Options options = new Options();
        OptionBuilder.hasArg();
        OptionBuilder.withType(Number.class);
        options.addOption(OptionBuilder.create((String)"i"));
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((String)"f"));
        DefaultParser parser = new DefaultParser();
        CommandLine cmd = parser.parse(options, new String[]{"-i", "123", "-f", "foo"});
        Assert.assertEquals((long)123L, (long)((Number)cmd.getParsedOptionValue("i")).intValue());
        Assert.assertEquals((Object)"foo", (Object)cmd.getParsedOptionValue("f"));
    }

    @Test
    public void testGetParsedOptionValueWithChar() throws Exception {
        Options options = new Options();
        options.addOption(Option.builder((String)"i").hasArg().type(Number.class).build());
        options.addOption(Option.builder((String)"f").hasArg().build());
        DefaultParser parser = new DefaultParser();
        CommandLine cmd = parser.parse(options, new String[]{"-i", "123", "-f", "foo"});
        Assert.assertEquals((long)123L, (long)((Number)cmd.getParsedOptionValue('i')).intValue());
        Assert.assertEquals((Object)"foo", (Object)cmd.getParsedOptionValue('f'));
    }

    @Test
    public void testGetParsedOptionValueWithOption() throws Exception {
        Options options = new Options();
        Option optI = Option.builder((String)"i").hasArg().type(Number.class).build();
        Option optF = Option.builder((String)"f").hasArg().build();
        options.addOption(optI);
        options.addOption(optF);
        DefaultParser parser = new DefaultParser();
        CommandLine cmd = parser.parse(options, new String[]{"-i", "123", "-f", "foo"});
        Assert.assertEquals((long)123L, (long)((Number)cmd.getParsedOptionValue(optI)).intValue());
        Assert.assertEquals((Object)"foo", (Object)cmd.getParsedOptionValue(optF));
    }

    @Test
    public void testNullhOption() throws Exception {
        Options options = new Options();
        Option optI = Option.builder((String)"i").hasArg().type(Number.class).build();
        Option optF = Option.builder((String)"f").hasArg().build();
        options.addOption(optI);
        options.addOption(optF);
        DefaultParser parser = new DefaultParser();
        CommandLine cmd = parser.parse(options, new String[]{"-i", "123", "-f", "foo"});
        Assert.assertNull((Object)cmd.getOptionValue((Option)null));
        Assert.assertNull((Object)cmd.getParsedOptionValue((Option)null));
    }
}

