/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.junit.Assert;
import org.junit.Test;

public class ApplicationTest {
    @Test
    public void testAnt() throws Exception {
        GnuParser parser = new GnuParser();
        Options options = new Options();
        options.addOption("help", false, "print this message");
        options.addOption("projecthelp", false, "print project help information");
        options.addOption("version", false, "print the version information and exit");
        options.addOption("quiet", false, "be extra quiet");
        options.addOption("verbose", false, "be extra verbose");
        options.addOption("debug", false, "print debug information");
        options.addOption("logfile", true, "use given file for log");
        options.addOption("logger", true, "the class which is to perform the logging");
        options.addOption("listener", true, "add an instance of a class as a project listener");
        options.addOption("buildfile", true, "use given buildfile");
        OptionBuilder.withDescription((String)"use value for given property");
        OptionBuilder.hasArgs();
        OptionBuilder.withValueSeparator();
        options.addOption(OptionBuilder.create((char)'D'));
        options.addOption("find", true, "search for buildfile towards the root of the filesystem and use it");
        String[] args = new String[]{"-buildfile", "mybuild.xml", "-Dproperty=value", "-Dproperty1=value1", "-projecthelp"};
        CommandLine line = parser.parse(options, args);
        String[] opts = line.getOptionValues("D");
        Assert.assertEquals((Object)"property", (Object)opts[0]);
        Assert.assertEquals((Object)"value", (Object)opts[1]);
        Assert.assertEquals((Object)"property1", (Object)opts[2]);
        Assert.assertEquals((Object)"value1", (Object)opts[3]);
        Assert.assertEquals((Object)line.getOptionValue("buildfile"), (Object)"mybuild.xml");
        Assert.assertTrue((boolean)line.hasOption("projecthelp"));
    }

    @Test
    public void testGroovy() throws Exception {
        Options options = new Options();
        OptionBuilder.withLongOpt((String)"define");
        OptionBuilder.withDescription((String)"define a system property");
        OptionBuilder.hasArg((boolean)true);
        OptionBuilder.withArgName((String)"name=value");
        options.addOption(OptionBuilder.create((char)'D'));
        OptionBuilder.hasArg((boolean)false);
        OptionBuilder.withDescription((String)"usage information");
        OptionBuilder.withLongOpt((String)"help");
        options.addOption(OptionBuilder.create((char)'h'));
        OptionBuilder.hasArg((boolean)false);
        OptionBuilder.withDescription((String)"debug mode will print out full stack traces");
        OptionBuilder.withLongOpt((String)"debug");
        options.addOption(OptionBuilder.create((char)'d'));
        OptionBuilder.hasArg((boolean)false);
        OptionBuilder.withDescription((String)"display the Groovy and JVM versions");
        OptionBuilder.withLongOpt((String)"version");
        options.addOption(OptionBuilder.create((char)'v'));
        OptionBuilder.withArgName((String)"charset");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"specify the encoding of the files");
        OptionBuilder.withLongOpt((String)"encoding");
        options.addOption(OptionBuilder.create((char)'c'));
        OptionBuilder.withArgName((String)"script");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"specify a command line script");
        options.addOption(OptionBuilder.create((char)'e'));
        OptionBuilder.withArgName((String)"extension");
        OptionBuilder.hasOptionalArg();
        OptionBuilder.withDescription((String)"modify files in place; create backup if extension is given (e.g. '.bak')");
        options.addOption(OptionBuilder.create((char)'i'));
        OptionBuilder.hasArg((boolean)false);
        OptionBuilder.withDescription((String)"process files line by line using implicit 'line' variable");
        options.addOption(OptionBuilder.create((char)'n'));
        OptionBuilder.hasArg((boolean)false);
        OptionBuilder.withDescription((String)"process files line by line and print result (see also -n)");
        options.addOption(OptionBuilder.create((char)'p'));
        OptionBuilder.withArgName((String)"port");
        OptionBuilder.hasOptionalArg();
        OptionBuilder.withDescription((String)"listen on a port and process inbound lines");
        options.addOption(OptionBuilder.create((char)'l'));
        OptionBuilder.withArgName((String)"splitPattern");
        OptionBuilder.hasOptionalArg();
        OptionBuilder.withDescription((String)"split lines using splitPattern (default '\\s') using implicit 'split' variable");
        OptionBuilder.withLongOpt((String)"autosplit");
        options.addOption(OptionBuilder.create((char)'a'));
        PosixParser parser = new PosixParser();
        CommandLine line = parser.parse(options, new String[]{"-e", "println 'hello'"}, true);
        Assert.assertTrue((boolean)line.hasOption('e'));
        Assert.assertEquals((Object)"println 'hello'", (Object)line.getOptionValue('e'));
    }

    @Test
    public void testLs() throws Exception {
        PosixParser parser = new PosixParser();
        Options options = new Options();
        options.addOption("a", "all", false, "do not hide entries starting with .");
        options.addOption("A", "almost-all", false, "do not list implied . and ..");
        options.addOption("b", "escape", false, "print octal escapes for nongraphic characters");
        OptionBuilder.withLongOpt((String)"block-size");
        OptionBuilder.withDescription((String)"use SIZE-byte blocks");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"SIZE");
        options.addOption(OptionBuilder.create());
        options.addOption("B", "ignore-backups", false, "do not list implied entried ending with ~");
        options.addOption("c", false, "with -lt: sort by, and show, ctime (time of last modification of file status information) with -l:show ctime and sort by name otherwise: sort by ctime");
        options.addOption("C", false, "list entries by columns");
        String[] args = new String[]{"--block-size=10"};
        CommandLine line = parser.parse(options, args);
        Assert.assertTrue((boolean)line.hasOption("block-size"));
        Assert.assertEquals((Object)line.getOptionValue("block-size"), (Object)"10");
    }

    @Test
    public void testMan() {
        String cmdLine = "man [-c|-f|-k|-w|-tZT device] [-adlhu7V] [-Mpath] [-Ppager] [-Slist] [-msystem] [-pstring] [-Llocale] [-eextension] [section] page ...";
        Options options = new Options().addOption("a", "all", false, "find all matching manual pages.").addOption("d", "debug", false, "emit debugging messages.").addOption("e", "extension", false, "limit search to extension type 'extension'.").addOption("f", "whatis", false, "equivalent to whatis.").addOption("k", "apropos", false, "equivalent to apropos.").addOption("w", "location", false, "print physical location of man page(s).").addOption("l", "local-file", false, "interpret 'page' argument(s) as local file name(s)").addOption("u", "update", false, "force a cache consistency check.").addOption("r", "prompt", true, "provide 'less' pager with prompt.").addOption("c", "catman", false, "used by catman to reformat out of date cat pages.").addOption("7", "ascii", false, "display ASCII translation or certain latin1 chars.").addOption("t", "troff", false, "use troff format pages.").addOption("T", "troff-device", true, "use groff with selected device.").addOption("Z", "ditroff", false, "use groff with selected device.").addOption("D", "default", false, "reset all options to their default values.").addOption("M", "manpath", true, "set search path for manual pages to 'path'.").addOption("P", "pager", true, "use program 'pager' to display output.").addOption("S", "sections", true, "use colon separated section list.").addOption("m", "systems", true, "search for man pages from other Unix system(s).").addOption("L", "locale", true, "define the locale for this particular man search.").addOption("p", "preprocessor", true, "string indicates which preprocessor to run.\n e - [n]eqn  p - pic     t - tbl\n g - grap    r - refer   v - vgrind").addOption("V", "version", false, "show version.").addOption("h", "help", false, "show this usage message.");
        HelpFormatter hf = new HelpFormatter();
        String eol = System.lineSeparator();
        StringWriter out = new StringWriter();
        hf.printHelp(new PrintWriter(out), 60, "man [-c|-f|-k|-w|-tZT device] [-adlhu7V] [-Mpath] [-Ppager] [-Slist] [-msystem] [-pstring] [-Llocale] [-eextension] [section] page ...", null, options, 1, 3, null, false);
        Assert.assertEquals((Object)("usage: man [-c|-f|-k|-w|-tZT device] [-adlhu7V] [-Mpath]" + eol + "           [-Ppager] [-Slist] [-msystem] [-pstring]" + eol + "           [-Llocale] [-eextension] [section] page ..." + eol + " -7,--ascii                display ASCII translation or" + eol + "                           certain latin1 chars." + eol + " -a,--all                  find all matching manual pages." + eol + " -c,--catman               used by catman to reformat out of" + eol + "                           date cat pages." + eol + " -d,--debug                emit debugging messages." + eol + " -D,--default              reset all options to their" + eol + "                           default values." + eol + " -e,--extension            limit search to extension type" + eol + "                           'extension'." + eol + " -f,--whatis               equivalent to whatis." + eol + " -h,--help                 show this usage message." + eol + " -k,--apropos              equivalent to apropos." + eol + " -l,--local-file           interpret 'page' argument(s) as" + eol + "                           local file name(s)" + eol + " -L,--locale <arg>         define the locale for this" + eol + "                           particular man search." + eol + " -M,--manpath <arg>        set search path for manual pages" + eol + "                           to 'path'." + eol + " -m,--systems <arg>        search for man pages from other" + eol + "                           Unix system(s)." + eol + " -P,--pager <arg>          use program 'pager' to display" + eol + "                           output." + eol + " -p,--preprocessor <arg>   string indicates which" + eol + "                           preprocessor to run." + eol + "                           e - [n]eqn  p - pic     t - tbl" + eol + "                           g - grap    r - refer   v -" + eol + "                           vgrind" + eol + " -r,--prompt <arg>         provide 'less' pager with prompt." + eol + " -S,--sections <arg>       use colon separated section list." + eol + " -t,--troff                use troff format pages." + eol + " -T,--troff-device <arg>   use groff with selected device." + eol + " -u,--update               force a cache consistency check." + eol + " -V,--version              show version." + eol + " -w,--location             print physical location of man" + eol + "                           page(s)." + eol + " -Z,--ditroff              use groff with selected device." + eol), (Object)out.toString());
    }

    @Test
    public void testNLT() throws Exception {
        Option help = new Option("h", "help", false, "print this message");
        Option version = new Option("v", "version", false, "print version information");
        Option newRun = new Option("n", "new", false, "Create NLT cache entries only for new items");
        Option trackerRun = new Option("t", "tracker", false, "Create NLT cache entries only for tracker items");
        OptionBuilder.withLongOpt((String)"limit");
        OptionBuilder.hasArg();
        OptionBuilder.withValueSeparator();
        OptionBuilder.withDescription((String)"Set time limit for execution, in minutes");
        Option timeLimit = OptionBuilder.create((String)"l");
        OptionBuilder.withLongOpt((String)"age");
        OptionBuilder.hasArg();
        OptionBuilder.withValueSeparator();
        OptionBuilder.withDescription((String)"Age (in days) of cache item before being recomputed");
        Option age = OptionBuilder.create((String)"a");
        OptionBuilder.withLongOpt((String)"server");
        OptionBuilder.hasArg();
        OptionBuilder.withValueSeparator();
        OptionBuilder.withDescription((String)"The NLT server address");
        Option server = OptionBuilder.create((String)"s");
        OptionBuilder.withLongOpt((String)"results");
        OptionBuilder.hasArg();
        OptionBuilder.withValueSeparator();
        OptionBuilder.withDescription((String)"Number of results per item");
        Option numResults = OptionBuilder.create((String)"r");
        OptionBuilder.withLongOpt((String)"file");
        OptionBuilder.hasArg();
        OptionBuilder.withValueSeparator();
        OptionBuilder.withDescription((String)"Use the specified configuration file");
        Option configFile = OptionBuilder.create();
        Options options = new Options();
        options.addOption(help);
        options.addOption(version);
        options.addOption(newRun);
        options.addOption(trackerRun);
        options.addOption(timeLimit);
        options.addOption(age);
        options.addOption(server);
        options.addOption(numResults);
        options.addOption(configFile);
        PosixParser parser = new PosixParser();
        String[] args = new String[]{"-v", "-l", "10", "-age", "5", "-file", "filename"};
        CommandLine line = parser.parse(options, args);
        Assert.assertTrue((boolean)line.hasOption("v"));
        Assert.assertEquals((Object)line.getOptionValue("l"), (Object)"10");
        Assert.assertEquals((Object)line.getOptionValue("limit"), (Object)"10");
        Assert.assertEquals((Object)line.getOptionValue("a"), (Object)"5");
        Assert.assertEquals((Object)line.getOptionValue("age"), (Object)"5");
        Assert.assertEquals((Object)line.getOptionValue("file"), (Object)"filename");
    }
}

