/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli.bug;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.MissingArgumentException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.junit.Assert;
import org.junit.Test;

public class BugsTest {
    @Test
    public void test11456() throws Exception {
        Options options = new Options();
        OptionBuilder.hasOptionalArg();
        options.addOption(OptionBuilder.create((char)'a'));
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((char)'b'));
        String[] args = new String[]{"-a", "-bvalue"};
        PosixParser parser = new PosixParser();
        CommandLine cmd = parser.parse(options, args);
        Assert.assertEquals((Object)cmd.getOptionValue('b'), (Object)"value");
        options = new Options();
        OptionBuilder.hasOptionalArg();
        options.addOption(OptionBuilder.create((char)'a'));
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((char)'b'));
        args = new String[]{"-a", "-b", "value"};
        parser = new GnuParser();
        cmd = parser.parse(options, args);
        Assert.assertEquals((Object)cmd.getOptionValue('b'), (Object)"value");
    }

    @Test
    public void test11457() throws Exception {
        Options options = new Options();
        OptionBuilder.withLongOpt((String)"verbose");
        options.addOption(OptionBuilder.create());
        String[] args = new String[]{"--verbose"};
        PosixParser parser = new PosixParser();
        CommandLine cmd = parser.parse(options, args);
        Assert.assertTrue((boolean)cmd.hasOption("verbose"));
    }

    @Test
    public void test11458() throws Exception {
        Options options = new Options();
        OptionBuilder.withValueSeparator((char)'=');
        OptionBuilder.hasArgs();
        options.addOption(OptionBuilder.create((char)'D'));
        OptionBuilder.withValueSeparator((char)':');
        OptionBuilder.hasArgs();
        options.addOption(OptionBuilder.create((char)'p'));
        String[] args = new String[]{"-DJAVA_HOME=/opt/java", "-pfile1:file2:file3"};
        PosixParser parser = new PosixParser();
        CommandLine cmd = parser.parse(options, args);
        String[] values = cmd.getOptionValues('D');
        Assert.assertEquals((Object)values[0], (Object)"JAVA_HOME");
        Assert.assertEquals((Object)values[1], (Object)"/opt/java");
        values = cmd.getOptionValues('p');
        Assert.assertEquals((Object)values[0], (Object)"file1");
        Assert.assertEquals((Object)values[1], (Object)"file2");
        Assert.assertEquals((Object)values[2], (Object)"file3");
        block4: for (Option opt : cmd) {
            switch (opt.getId()) {
                case 68: {
                    Assert.assertEquals((Object)opt.getValue(0), (Object)"JAVA_HOME");
                    Assert.assertEquals((Object)opt.getValue(1), (Object)"/opt/java");
                    continue block4;
                }
                case 112: {
                    Assert.assertEquals((Object)opt.getValue(0), (Object)"file1");
                    Assert.assertEquals((Object)opt.getValue(1), (Object)"file2");
                    Assert.assertEquals((Object)opt.getValue(2), (Object)"file3");
                    continue block4;
                }
            }
            Assert.fail((String)"-D option not found");
        }
    }

    @Test
    public void test11680() throws Exception {
        Options options = new Options();
        options.addOption("f", true, "foobar");
        options.addOption("m", true, "missing");
        String[] args = new String[]{"-f", "foo"};
        PosixParser parser = new PosixParser();
        CommandLine cmd = parser.parse(options, args);
        cmd.getOptionValue("f", "default f");
        cmd.getOptionValue("m", "default m");
    }

    @Test
    public void test12210() throws Exception {
        Options mainOptions = new Options();
        String[] argv = new String[]{"-exec", "-exec_opt1", "-exec_opt2"};
        OptionGroup grp = new OptionGroup();
        grp.addOption(new Option("exec", false, "description for this option"));
        grp.addOption(new Option("rep", false, "description for this option"));
        mainOptions.addOptionGroup(grp);
        Options execOptions = new Options();
        execOptions.addOption("exec_opt1", false, " desc");
        execOptions.addOption("exec_opt2", false, " desc");
        Options repOptions = new Options();
        repOptions.addOption("repopto", false, "desc");
        repOptions.addOption("repoptt", false, "desc");
        GnuParser parser = new GnuParser();
        CommandLine cmd = parser.parse(mainOptions, argv, true);
        argv = cmd.getArgs();
        if (cmd.hasOption("exec")) {
            cmd = parser.parse(execOptions, argv, false);
            Assert.assertTrue((boolean)cmd.hasOption("exec_opt1"));
            Assert.assertTrue((boolean)cmd.hasOption("exec_opt2"));
        } else if (cmd.hasOption("rep")) {
            cmd = parser.parse(repOptions, argv, false);
        } else {
            Assert.fail((String)"exec option not found");
        }
    }

    @Test
    public void test13425() throws Exception {
        Options options = new Options();
        OptionBuilder.withLongOpt((String)"old-password");
        OptionBuilder.withDescription((String)"Use this option to specify the old password");
        OptionBuilder.hasArg();
        Option oldpass = OptionBuilder.create((char)'o');
        OptionBuilder.withLongOpt((String)"new-password");
        OptionBuilder.withDescription((String)"Use this option to specify the new password");
        OptionBuilder.hasArg();
        Option newpass = OptionBuilder.create((char)'n');
        String[] args = new String[]{"-o", "-n", "newpassword"};
        options.addOption(oldpass);
        options.addOption(newpass);
        PosixParser parser = new PosixParser();
        try {
            parser.parse(options, args);
            Assert.fail((String)"MissingArgumentException not caught.");
        }
        catch (MissingArgumentException missingArgumentException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test13666() throws Exception {
        Options options = new Options();
        OptionBuilder.withDescription((String)"dir");
        OptionBuilder.hasArg();
        Option dir = OptionBuilder.create((char)'d');
        options.addOption(dir);
        PrintStream oldSystemOut = System.out;
        try {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            PrintStream print = new PrintStream(bytes);
            print.println();
            String eol = bytes.toString();
            bytes.reset();
            System.setOut(new PrintStream(bytes));
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("dir", options);
            Assert.assertEquals((Object)("usage: dir" + eol + " -d <arg>   dir" + eol), (Object)bytes.toString());
        }
        finally {
            System.setOut(oldSystemOut);
        }
    }

    @Test
    public void test13935() throws Exception {
        OptionGroup directions = new OptionGroup();
        Option left = new Option("l", "left", false, "go left");
        Option right = new Option("r", "right", false, "go right");
        Option straight = new Option("s", "straight", false, "go straight");
        Option forward = new Option("f", "forward", false, "go forward");
        forward.setRequired(true);
        directions.addOption(left);
        directions.addOption(right);
        directions.setRequired(true);
        Options opts = new Options();
        opts.addOptionGroup(directions);
        opts.addOption(straight);
        PosixParser parser = new PosixParser();
        String[] args = new String[]{};
        try {
            parser.parse(opts, args);
            Assert.fail((String)"Expected ParseException");
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        args = new String[]{"-s"};
        try {
            parser.parse(opts, args);
            Assert.fail((String)"Expected ParseException");
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        args = new String[]{"-s", "-l"};
        CommandLine line = parser.parse(opts, args);
        Assert.assertNotNull((Object)line);
        opts.addOption(forward);
        args = new String[]{"-s", "-l", "-f"};
        line = parser.parse(opts, args);
        Assert.assertNotNull((Object)line);
    }

    @Test
    public void test14786() throws Exception {
        OptionBuilder.isRequired();
        OptionBuilder.withDescription((String)"test");
        Option o = OptionBuilder.create((String)"test");
        Options opts = new Options();
        opts.addOption(o);
        opts.addOption(o);
        GnuParser parser = new GnuParser();
        String[] args = new String[]{"-test"};
        CommandLine line = parser.parse(opts, args);
        Assert.assertTrue((boolean)line.hasOption("test"));
    }

    @Test
    public void test15046() throws Exception {
        PosixParser parser = new PosixParser();
        String[] cliArgs = new String[]{"-z", "c"};
        Options options = new Options();
        options.addOption(new Option("z", "timezone", true, "affected option"));
        parser.parse(options, cliArgs);
        options.addOption("c", "conflict", true, "conflict option");
        CommandLine line = parser.parse(options, cliArgs);
        Assert.assertEquals((Object)line.getOptionValue('z'), (Object)"c");
        Assert.assertFalse((boolean)line.hasOption("c"));
    }

    @Test
    public void test15648() throws Exception {
        PosixParser parser = new PosixParser();
        String[] args = new String[]{"-m", "\"Two Words\""};
        OptionBuilder.hasArgs();
        Option m = OptionBuilder.create((String)"m");
        Options options = new Options();
        options.addOption(m);
        CommandLine line = parser.parse(options, args);
        Assert.assertEquals((Object)"Two Words", (Object)line.getOptionValue("m"));
    }

    @Test
    public void test31148() throws ParseException {
        Option multiArgOption = new Option("o", "option with multiple args");
        multiArgOption.setArgs(1);
        Options options = new Options();
        options.addOption(multiArgOption);
        PosixParser parser = new PosixParser();
        String[] args = new String[]{};
        Properties props = new Properties();
        props.setProperty("o", "ovalue");
        CommandLine cl = parser.parse(options, args, props);
        Assert.assertTrue((boolean)cl.hasOption('o'));
        Assert.assertEquals((Object)"ovalue", (Object)cl.getOptionValue('o'));
    }
}

