/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Comparator;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.junit.Assert;
import org.junit.Test;

public class HelpFormatterTest {
    private static final String EOL = System.getProperty("line.separator");

    @Test
    public void testAccessors() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.setArgName("argname");
        Assert.assertEquals((String)"arg name", (Object)"argname", (Object)formatter.getArgName());
        formatter.setDescPadding(3);
        Assert.assertEquals((String)"desc padding", (long)3L, (long)formatter.getDescPadding());
        formatter.setLeftPadding(7);
        Assert.assertEquals((String)"left padding", (long)7L, (long)formatter.getLeftPadding());
        formatter.setLongOptPrefix("~~");
        Assert.assertEquals((String)"long opt prefix", (Object)"~~", (Object)formatter.getLongOptPrefix());
        formatter.setNewLine("\n");
        Assert.assertEquals((String)"new line", (Object)"\n", (Object)formatter.getNewLine());
        formatter.setOptPrefix("~");
        Assert.assertEquals((String)"opt prefix", (Object)"~", (Object)formatter.getOptPrefix());
        formatter.setSyntaxPrefix("-> ");
        Assert.assertEquals((String)"syntax prefix", (Object)"-> ", (Object)formatter.getSyntaxPrefix());
        formatter.setWidth(80);
        Assert.assertEquals((String)"width", (long)80L, (long)formatter.getWidth());
    }

    @Test
    public void testAutomaticUsage() {
        HelpFormatter hf = new HelpFormatter();
        String expected = "usage: app [-a]";
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(out);
        Options options = new Options().addOption("a", false, "aaaa aaaa aaaa aaaa aaaa");
        hf.printUsage(pw, 60, "app", options);
        pw.flush();
        Assert.assertEquals((String)"simple auto usage", (Object)expected, (Object)out.toString().trim());
        out.reset();
        expected = "usage: app [-a] [-b]";
        options = new Options().addOption("a", false, "aaaa aaaa aaaa aaaa aaaa").addOption("b", false, "bbb");
        hf.printUsage(pw, 60, "app", options);
        pw.flush();
        Assert.assertEquals((String)"simple auto usage", (Object)expected, (Object)out.toString().trim());
        out.reset();
    }

    @Test
    public void testDefaultArgName() {
        Option option = Option.builder((String)"f").hasArg().required(true).build();
        Options options = new Options();
        options.addOption(option);
        StringWriter out = new StringWriter();
        HelpFormatter formatter = new HelpFormatter();
        formatter.setArgName("argument");
        formatter.printUsage(new PrintWriter(out), 80, "app", options);
        Assert.assertEquals((Object)("usage: app -f <argument>" + EOL), (Object)out.toString());
    }

    @Test
    public void testFindWrapPos() {
        HelpFormatter hf = new HelpFormatter();
        String text = "This is a test.";
        Assert.assertEquals((String)"wrap position", (long)7L, (long)hf.findWrapPos(text, 8, 0));
        Assert.assertEquals((String)"wrap position 2", (long)-1L, (long)hf.findWrapPos(text, 8, 8));
        text = "aaaa aa";
        Assert.assertEquals((String)"wrap position 3", (long)3L, (long)hf.findWrapPos(text, 3, 0));
        text = "aaaaaa aaaaaa";
        Assert.assertEquals((String)"wrap position 4", (long)6L, (long)hf.findWrapPos(text, 6, 0));
        Assert.assertEquals((String)"wrap position 4", (long)-1L, (long)hf.findWrapPos(text, 6, 7));
        text = "aaaaaa\n aaaaaa";
        Assert.assertEquals((String)"wrap position 5", (long)7L, (long)hf.findWrapPos(text, 6, 0));
        text = "aaaaaa\t aaaaaa";
        Assert.assertEquals((String)"wrap position 6", (long)7L, (long)hf.findWrapPos(text, 6, 0));
    }

    @Test
    public void testHeaderStartingWithLineSeparator() {
        Options options = new Options();
        HelpFormatter formatter = new HelpFormatter();
        String header = EOL + "Header";
        String footer = "Footer";
        StringWriter out = new StringWriter();
        formatter.printHelp(new PrintWriter(out), 80, "foobar", header, options, 2, 2, "Footer", true);
        Assert.assertEquals((Object)("usage: foobar" + EOL + "" + EOL + "Header" + EOL + "" + EOL + "Footer" + EOL), (Object)out.toString());
    }

    @Test
    public void testHelpWithLongOptSeparator() {
        Options options = new Options();
        options.addOption("f", true, "the file");
        options.addOption(Option.builder((String)"s").longOpt("size").desc("the size").hasArg().argName("SIZE").build());
        options.addOption(Option.builder().longOpt("age").desc("the age").hasArg().build());
        HelpFormatter formatter = new HelpFormatter();
        Assert.assertEquals((Object)" ", (Object)formatter.getLongOptSeparator());
        formatter.setLongOptSeparator("=");
        Assert.assertEquals((Object)"=", (Object)formatter.getLongOptSeparator());
        StringWriter out = new StringWriter();
        formatter.printHelp(new PrintWriter(out), 80, "create", "header", options, 2, 2, "footer");
        Assert.assertEquals((Object)("usage: create" + EOL + "header" + EOL + "     --age=<arg>    the age" + EOL + "  -f <arg>          the file" + EOL + "  -s,--size=<SIZE>  the size" + EOL + "footer" + EOL), (Object)out.toString());
    }

    @Test
    public void testIndentedHeaderAndFooter() {
        Options options = new Options();
        HelpFormatter formatter = new HelpFormatter();
        String header = "  Header1\n  Header2";
        String footer = "  Footer1\n  Footer2";
        StringWriter out = new StringWriter();
        formatter.printHelp(new PrintWriter(out), 80, "foobar", "  Header1\n  Header2", options, 2, 2, "  Footer1\n  Footer2", true);
        Assert.assertEquals((Object)("usage: foobar" + EOL + "  Header1" + EOL + "  Header2" + EOL + "" + EOL + "  Footer1" + EOL + "  Footer2" + EOL), (Object)out.toString());
    }

    @Test
    public void testOptionWithoutShortFormat() {
        Options options = new Options();
        options.addOption(new Option("a", "aaa", false, "aaaaaaa"));
        options.addOption(new Option(null, "bbb", false, "bbbbbbb"));
        options.addOption(new Option("c", null, false, "ccccccc"));
        HelpFormatter formatter = new HelpFormatter();
        StringWriter out = new StringWriter();
        formatter.printHelp(new PrintWriter(out), 80, "foobar", "", options, 2, 2, "", true);
        Assert.assertEquals((Object)("usage: foobar [-a] [--bbb] [-c]" + EOL + "  -a,--aaa  aaaaaaa" + EOL + "     --bbb  bbbbbbb" + EOL + "  -c        ccccccc" + EOL), (Object)out.toString());
    }

    @Test
    public void testOptionWithoutShortFormat2() {
        Option help = new Option("h", "help", false, "print this message");
        Option version = new Option("v", "version", false, "print version information");
        Option newRun = new Option("n", "new", false, "Create NLT cache entries only for new items");
        Option trackerRun = new Option("t", "tracker", false, "Create NLT cache entries only for tracker items");
        Option timeLimit = Option.builder((String)"l").longOpt("limit").hasArg().valueSeparator().desc("Set time limit for execution, in mintues").build();
        Option age = Option.builder((String)"a").longOpt("age").hasArg().valueSeparator().desc("Age (in days) of cache item before being recomputed").build();
        Option server = Option.builder((String)"s").longOpt("server").hasArg().valueSeparator().desc("The NLT server address").build();
        Option numResults = Option.builder((String)"r").longOpt("results").hasArg().valueSeparator().desc("Number of results per item").build();
        Option configFile = Option.builder().longOpt("config").hasArg().valueSeparator().desc("Use the specified configuration file").build();
        Options mOptions = new Options();
        mOptions.addOption(help);
        mOptions.addOption(version);
        mOptions.addOption(newRun);
        mOptions.addOption(trackerRun);
        mOptions.addOption(timeLimit);
        mOptions.addOption(age);
        mOptions.addOption(server);
        mOptions.addOption(numResults);
        mOptions.addOption(configFile);
        HelpFormatter formatter = new HelpFormatter();
        String eol = System.getProperty("line.separator");
        StringWriter out = new StringWriter();
        formatter.printHelp(new PrintWriter(out), 80, "commandline", "header", mOptions, 2, 2, "footer", true);
        Assert.assertEquals((Object)("usage: commandline [-a <arg>] [--config <arg>] [-h] [-l <arg>] [-n] [-r <arg>]" + eol + "       [-s <arg>] [-t] [-v]" + eol + "header" + eol + "  -a,--age <arg>      Age (in days) of cache item before being recomputed" + eol + "     --config <arg>   Use the specified configuration file" + eol + "  -h,--help           print this message" + eol + "  -l,--limit <arg>    Set time limit for execution, in mintues" + eol + "  -n,--new            Create NLT cache entries only for new items" + eol + "  -r,--results <arg>  Number of results per item" + eol + "  -s,--server <arg>   The NLT server address" + eol + "  -t,--tracker        Create NLT cache entries only for tracker items" + eol + "  -v,--version        print version information" + eol + "footer" + eol), (Object)out.toString());
    }

    @Test
    public void testPrintHelpNewlineFooter() {
        HelpFormatter formatter = new HelpFormatter();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(out);
        Options options = new Options();
        options.addOption("a", "b");
        formatter.printHelp(pw, 80, "test" + EOL, "header" + EOL, options, 0, 0, EOL);
        String expected = "usage: test" + EOL + "header" + EOL + "-ab" + EOL + EOL;
        pw.flush();
        Assert.assertEquals((String)"footer newline", (Object)expected, (Object)out.toString());
    }

    @Test
    public void testPrintHelpNewlineHeader() {
        HelpFormatter formatter = new HelpFormatter();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(out);
        Options options = new Options();
        options.addOption("a", "b");
        formatter.printHelp(pw, 80, "test" + EOL, EOL, options, 0, 0, "footer" + EOL);
        String expected = "usage: test" + EOL + EOL + "-ab" + EOL + "footer" + EOL;
        pw.flush();
        Assert.assertEquals((String)"header newline", (Object)expected, (Object)out.toString());
    }

    @Test
    public void testPrintHelpWithEmptySyntax() {
        HelpFormatter formatter = new HelpFormatter();
        try {
            formatter.printHelp(null, new Options());
            Assert.fail((String)"null command line syntax should be rejected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            formatter.printHelp("", new Options());
            Assert.fail((String)"empty command line syntax should be rejected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testPrintOptionGroupUsage() {
        OptionGroup group = new OptionGroup();
        group.addOption(Option.builder((String)"a").build());
        group.addOption(Option.builder((String)"b").build());
        group.addOption(Option.builder((String)"c").build());
        Options options = new Options();
        options.addOptionGroup(group);
        StringWriter out = new StringWriter();
        HelpFormatter formatter = new HelpFormatter();
        formatter.printUsage(new PrintWriter(out), 80, "app", options);
        Assert.assertEquals((Object)("usage: app [-a | -b | -c]" + EOL), (Object)out.toString());
    }

    @Test
    public void testPrintOptions() {
        StringBuffer sb = new StringBuffer();
        HelpFormatter hf = new HelpFormatter();
        boolean leftPad = true;
        int descPad = 3;
        String lpad = hf.createPadding(1);
        String dpad = hf.createPadding(3);
        Options options = new Options().addOption("a", false, "aaaa aaaa aaaa aaaa aaaa");
        String expected = lpad + "-a" + dpad + "aaaa aaaa aaaa aaaa aaaa";
        hf.renderOptions(sb, 60, options, 1, 3);
        Assert.assertEquals((String)"simple non-wrapped option", (Object)expected, (Object)sb.toString());
        int nextLineTabStop = 4 + "-a".length();
        expected = lpad + "-a" + dpad + "aaaa aaaa aaaa" + EOL + hf.createPadding(nextLineTabStop) + "aaaa aaaa";
        sb.setLength(0);
        hf.renderOptions(sb, nextLineTabStop + 17, options, 1, 3);
        Assert.assertEquals((String)"simple wrapped option", (Object)expected, (Object)sb.toString());
        options = new Options().addOption("a", "aaa", false, "dddd dddd dddd dddd");
        expected = lpad + "-a,--aaa" + dpad + "dddd dddd dddd dddd";
        sb.setLength(0);
        hf.renderOptions(sb, 60, options, 1, 3);
        Assert.assertEquals((String)"long non-wrapped option", (Object)expected, (Object)sb.toString());
        nextLineTabStop = 4 + "-a,--aaa".length();
        expected = lpad + "-a,--aaa" + dpad + "dddd dddd" + EOL + hf.createPadding(nextLineTabStop) + "dddd dddd";
        sb.setLength(0);
        hf.renderOptions(sb, 25, options, 1, 3);
        Assert.assertEquals((String)"long wrapped option", (Object)expected, (Object)sb.toString());
        options = new Options().addOption("a", "aaa", false, "dddd dddd dddd dddd").addOption("b", false, "feeee eeee eeee eeee");
        expected = lpad + "-a,--aaa" + dpad + "dddd dddd" + EOL + hf.createPadding(nextLineTabStop) + "dddd dddd" + EOL + lpad + "-b      " + dpad + "feeee eeee" + EOL + hf.createPadding(nextLineTabStop) + "eeee eeee";
        sb.setLength(0);
        hf.renderOptions(sb, 25, options, 1, 3);
        Assert.assertEquals((String)"multiple wrapped options", (Object)expected, (Object)sb.toString());
    }

    @Test
    public void testPrintOptionWithEmptyArgNameUsage() {
        Option option = new Option("f", true, null);
        option.setArgName("");
        option.setRequired(true);
        Options options = new Options();
        options.addOption(option);
        StringWriter out = new StringWriter();
        HelpFormatter formatter = new HelpFormatter();
        formatter.printUsage(new PrintWriter(out), 80, "app", options);
        Assert.assertEquals((Object)("usage: app -f" + EOL), (Object)out.toString());
    }

    @Test
    public void testPrintRequiredOptionGroupUsage() {
        OptionGroup group = new OptionGroup();
        group.addOption(Option.builder((String)"a").build());
        group.addOption(Option.builder((String)"b").build());
        group.addOption(Option.builder((String)"c").build());
        group.setRequired(true);
        Options options = new Options();
        options.addOptionGroup(group);
        StringWriter out = new StringWriter();
        HelpFormatter formatter = new HelpFormatter();
        formatter.printUsage(new PrintWriter(out), 80, "app", options);
        Assert.assertEquals((Object)("usage: app -a | -b | -c" + EOL), (Object)out.toString());
    }

    @Test
    public void testPrintSortedUsage() {
        Options opts = new Options();
        opts.addOption(new Option("a", "first"));
        opts.addOption(new Option("b", "second"));
        opts.addOption(new Option("c", "third"));
        HelpFormatter helpFormatter = new HelpFormatter();
        helpFormatter.setOptionComparator((Comparator)new Comparator<Option>(){

            @Override
            public int compare(Option opt1, Option opt2) {
                return opt2.getKey().compareToIgnoreCase(opt1.getKey());
            }
        });
        StringWriter out = new StringWriter();
        helpFormatter.printUsage(new PrintWriter(out), 80, "app", opts);
        Assert.assertEquals((Object)("usage: app [-c] [-b] [-a]" + EOL), (Object)out.toString());
    }

    @Test
    public void testPrintSortedUsageWithNullComparator() {
        Options opts = new Options();
        opts.addOption(new Option("c", "first"));
        opts.addOption(new Option("b", "second"));
        opts.addOption(new Option("a", "third"));
        HelpFormatter helpFormatter = new HelpFormatter();
        helpFormatter.setOptionComparator(null);
        StringWriter out = new StringWriter();
        helpFormatter.printUsage(new PrintWriter(out), 80, "app", opts);
        Assert.assertEquals((Object)("usage: app [-c] [-b] [-a]" + EOL), (Object)out.toString());
    }

    @Test
    public void testPrintUsage() {
        Option optionA = new Option("a", "first");
        Option optionB = new Option("b", "second");
        Option optionC = new Option("c", "third");
        Options opts = new Options();
        opts.addOption(optionA);
        opts.addOption(optionB);
        opts.addOption(optionC);
        HelpFormatter helpFormatter = new HelpFormatter();
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        try (PrintWriter printWriter = new PrintWriter(bytesOut);){
            helpFormatter.printUsage(printWriter, 80, "app", opts);
        }
        Assert.assertEquals((Object)("usage: app [-a] [-b] [-c]" + EOL), (Object)bytesOut.toString());
    }

    @Test
    public void testRenderWrappedTextMultiLine() {
        int width = 16;
        boolean padding = false;
        String expected = "aaaa aaaa aaaa" + EOL + "aaaaaa" + EOL + "aaaaa";
        StringBuffer sb = new StringBuffer();
        new HelpFormatter().renderWrappedText(sb, 16, 0, expected);
        Assert.assertEquals((String)"multi line text", (Object)expected, (Object)sb.toString());
    }

    @Test
    public void testRenderWrappedTextMultiLinePadded() {
        int width = 16;
        int padding = 4;
        String text = "aaaa aaaa aaaa" + EOL + "aaaaaa" + EOL + "aaaaa";
        String expected = "aaaa aaaa aaaa" + EOL + "    aaaaaa" + EOL + "    aaaaa";
        StringBuffer sb = new StringBuffer();
        new HelpFormatter().renderWrappedText(sb, 16, 4, text);
        Assert.assertEquals((String)"multi-line padded text", (Object)expected, (Object)sb.toString());
    }

    @Test
    public void testRenderWrappedTextSingleLine() {
        int width = 12;
        boolean padding = false;
        String text = "This is a test.";
        String expected = "This is a" + EOL + "test.";
        StringBuffer sb = new StringBuffer();
        new HelpFormatter().renderWrappedText(sb, 12, 0, "This is a test.");
        Assert.assertEquals((String)"single line text", (Object)expected, (Object)sb.toString());
    }

    @Test
    public void testRenderWrappedTextSingleLinePadded() {
        int width = 12;
        int padding = 4;
        String text = "This is a test.";
        String expected = "This is a" + EOL + "    test.";
        StringBuffer sb = new StringBuffer();
        new HelpFormatter().renderWrappedText(sb, 12, 4, "This is a test.");
        Assert.assertEquals((String)"single line padded text", (Object)expected, (Object)sb.toString());
    }

    @Test
    public void testRenderWrappedTextSingleLinePadded2() {
        int width = 53;
        int padding = 24;
        String text = "  -p,--period <PERIOD>  PERIOD is time duration of form DATE[-DATE] where DATE has form YYYY[MM[DD]]";
        String expected = "  -p,--period <PERIOD>  PERIOD is time duration of" + EOL + "                        form DATE[-DATE] where DATE" + EOL + "                        has form YYYY[MM[DD]]";
        StringBuffer sb = new StringBuffer();
        new HelpFormatter().renderWrappedText(sb, 53, 24, "  -p,--period <PERIOD>  PERIOD is time duration of form DATE[-DATE] where DATE has form YYYY[MM[DD]]");
        Assert.assertEquals((String)"single line padded text 2", (Object)expected, (Object)sb.toString());
    }

    @Test
    public void testRenderWrappedTextWordCut() {
        int width = 7;
        boolean padding = false;
        String text = "Thisisatest.";
        String expected = "Thisisa" + EOL + "test.";
        StringBuffer sb = new StringBuffer();
        new HelpFormatter().renderWrappedText(sb, 7, 0, "Thisisatest.");
        Assert.assertEquals((String)"cut and wrap", (Object)expected, (Object)sb.toString());
    }

    @Test
    public void testRtrim() {
        HelpFormatter formatter = new HelpFormatter();
        Assert.assertNull((Object)formatter.rtrim(null));
        Assert.assertEquals((Object)"", (Object)formatter.rtrim(""));
        Assert.assertEquals((Object)"  foo", (Object)formatter.rtrim("  foo  "));
    }

    @Test
    public void testUsageWithLongOptSeparator() {
        Options options = new Options();
        options.addOption("f", true, "the file");
        options.addOption(Option.builder((String)"s").longOpt("size").desc("the size").hasArg().argName("SIZE").build());
        options.addOption(Option.builder().longOpt("age").desc("the age").hasArg().build());
        HelpFormatter formatter = new HelpFormatter();
        formatter.setLongOptSeparator("=");
        StringWriter out = new StringWriter();
        formatter.printUsage(new PrintWriter(out), 80, "create", options);
        Assert.assertEquals((Object)"usage: create [--age=<arg>] [-f <arg>] [-s <SIZE>]", (Object)out.toString().trim());
    }
}

