/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli;

import java.io.File;
import java.io.FileInputStream;
import java.net.URL;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PatternOptionBuilder;
import org.apache.commons.cli.TypeHandler;
import org.junit.Assert;
import org.junit.Test;

public class TypeHandlerTest {
    @Test
    public void testCreateValueClass() throws Exception {
        Object clazz = TypeHandler.createValue((String)Instantiable.class.getName(), (Class)PatternOptionBuilder.CLASS_VALUE);
        Assert.assertEquals(Instantiable.class, (Object)clazz);
    }

    @Test(expected=ParseException.class)
    public void testCreateValueClass_notFound() throws Exception {
        TypeHandler.createValue((String)"what ever", (Class)PatternOptionBuilder.CLASS_VALUE);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testCreateValueDate() throws Exception {
        TypeHandler.createValue((String)"what ever", (Class)PatternOptionBuilder.DATE_VALUE);
    }

    @Test
    public void testCreateValueExistingFile() throws Exception {
        try (FileInputStream result = (FileInputStream)TypeHandler.createValue((String)"src/test/resources/org/apache/commons/cli/existing-readable.file", (Class)PatternOptionBuilder.EXISTING_FILE_VALUE);){
            Assert.assertNotNull((Object)result);
        }
    }

    @Test(expected=ParseException.class)
    public void testCreateValueExistingFile_nonExistingFile() throws Exception {
        TypeHandler.createValue((String)"non-existing.file", (Class)PatternOptionBuilder.EXISTING_FILE_VALUE);
    }

    @Test
    public void testCreateValueFile() throws Exception {
        File result = (File)TypeHandler.createValue((String)"some-file.txt", (Class)PatternOptionBuilder.FILE_VALUE);
        Assert.assertEquals((Object)"some-file.txt", (Object)result.getName());
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testCreateValueFiles() throws Exception {
        TypeHandler.createValue((String)"some.files", (Class)PatternOptionBuilder.FILES_VALUE);
    }

    @Test(expected=ParseException.class)
    public void testCreateValueInteger_failure() throws Exception {
        TypeHandler.createValue((String)"just-a-string", Integer.class);
    }

    @Test
    public void testCreateValueNumber_Double() throws Exception {
        Assert.assertEquals((Object)1.5, (Object)TypeHandler.createValue((String)"1.5", (Class)PatternOptionBuilder.NUMBER_VALUE));
    }

    @Test
    public void testCreateValueNumber_Long() throws Exception {
        Assert.assertEquals((Object)15L, (Object)TypeHandler.createValue((String)"15", (Class)PatternOptionBuilder.NUMBER_VALUE));
    }

    @Test(expected=ParseException.class)
    public void testCreateValueNumber_noNumber() throws Exception {
        TypeHandler.createValue((String)"not a number", (Class)PatternOptionBuilder.NUMBER_VALUE);
    }

    @Test
    public void testCreateValueObject_InstantiableClass() throws Exception {
        Object result = TypeHandler.createValue((String)Instantiable.class.getName(), (Class)PatternOptionBuilder.OBJECT_VALUE);
        Assert.assertTrue((boolean)(result instanceof Instantiable));
    }

    @Test(expected=ParseException.class)
    public void testCreateValueObject_notInstantiableClass() throws Exception {
        TypeHandler.createValue((String)NotInstantiable.class.getName(), (Class)PatternOptionBuilder.OBJECT_VALUE);
    }

    @Test(expected=ParseException.class)
    public void testCreateValueObject_unknownClass() throws Exception {
        TypeHandler.createValue((String)"unknown", (Class)PatternOptionBuilder.OBJECT_VALUE);
    }

    @Test
    public void testCreateValueString() throws Exception {
        Assert.assertEquals((Object)"String", (Object)TypeHandler.createValue((String)"String", (Class)PatternOptionBuilder.STRING_VALUE));
    }

    @Test
    public void testCreateValueURL() throws Exception {
        String urlString = "https://commons.apache.org";
        URL result = (URL)TypeHandler.createValue((String)"https://commons.apache.org", (Class)PatternOptionBuilder.URL_VALUE);
        Assert.assertEquals((Object)"https://commons.apache.org", (Object)result.toString());
    }

    @Test(expected=ParseException.class)
    public void testCreateValueURL_malformed() throws Exception {
        TypeHandler.createValue((String)"malformed-url", (Class)PatternOptionBuilder.URL_VALUE);
    }

    public static final class NotInstantiable {
        private NotInstantiable() {
        }
    }

    public static class Instantiable {
    }
}

