/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli;

import java.util.Properties;
import org.apache.commons.cli.AlreadySelectedException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.Parser;
import org.apache.commons.cli.PosixParser;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class OptionGroupTest {
    private Options options;
    private final Parser parser = new PosixParser();

    @Before
    public void setUp() {
        Option file = new Option("f", "file", false, "file to process");
        Option dir = new Option("d", "directory", false, "directory to process");
        OptionGroup group = new OptionGroup();
        group.addOption(file);
        group.addOption(dir);
        this.options = new Options().addOptionGroup(group);
        Option section = new Option("s", "section", false, "section to process");
        Option chapter = new Option("c", "chapter", false, "chapter to process");
        OptionGroup group2 = new OptionGroup();
        group2.addOption(section);
        group2.addOption(chapter);
        this.options.addOptionGroup(group2);
        Option importOpt = new Option(null, "import", false, "section to process");
        Option exportOpt = new Option(null, "export", false, "chapter to process");
        OptionGroup group3 = new OptionGroup();
        group3.addOption(importOpt);
        group3.addOption(exportOpt);
        this.options.addOptionGroup(group3);
        this.options.addOption("r", "revision", false, "revision number");
    }

    @Test
    public void testGetNames() {
        OptionGroup group = new OptionGroup();
        group.addOption(OptionBuilder.create((char)'a'));
        group.addOption(OptionBuilder.create((char)'b'));
        Assert.assertNotNull((String)"null names", (Object)group.getNames());
        Assert.assertEquals((long)2L, (long)group.getNames().size());
        Assert.assertTrue((boolean)group.getNames().contains("a"));
        Assert.assertTrue((boolean)group.getNames().contains("b"));
    }

    @Test
    public void testNoOptionsExtraArgs() throws Exception {
        String[] args = new String[]{"arg1", "arg2"};
        CommandLine cl = this.parser.parse(this.options, args);
        Assert.assertFalse((String)"Confirm -r is NOT set", (boolean)cl.hasOption("r"));
        Assert.assertFalse((String)"Confirm -f is NOT set", (boolean)cl.hasOption("f"));
        Assert.assertFalse((String)"Confirm -d is NOT set", (boolean)cl.hasOption("d"));
        Assert.assertFalse((String)"Confirm -s is NOT set", (boolean)cl.hasOption("s"));
        Assert.assertFalse((String)"Confirm -c is NOT set", (boolean)cl.hasOption("c"));
        Assert.assertEquals((String)"Confirm TWO extra args", (long)2L, (long)cl.getArgList().size());
    }

    @Test
    public void testSingleLongOption() throws Exception {
        String[] args = new String[]{"--file"};
        CommandLine cl = this.parser.parse(this.options, args);
        Assert.assertFalse((String)"Confirm -r is NOT set", (boolean)cl.hasOption("r"));
        Assert.assertTrue((String)"Confirm -f is set", (boolean)cl.hasOption("f"));
        Assert.assertFalse((String)"Confirm -d is NOT set", (boolean)cl.hasOption("d"));
        Assert.assertFalse((String)"Confirm -s is NOT set", (boolean)cl.hasOption("s"));
        Assert.assertFalse((String)"Confirm -c is NOT set", (boolean)cl.hasOption("c"));
        Assert.assertTrue((String)"Confirm no extra args", (boolean)cl.getArgList().isEmpty());
    }

    @Test
    public void testSingleOption() throws Exception {
        String[] args = new String[]{"-r"};
        CommandLine cl = this.parser.parse(this.options, args);
        Assert.assertTrue((String)"Confirm -r is set", (boolean)cl.hasOption("r"));
        Assert.assertFalse((String)"Confirm -f is NOT set", (boolean)cl.hasOption("f"));
        Assert.assertFalse((String)"Confirm -d is NOT set", (boolean)cl.hasOption("d"));
        Assert.assertFalse((String)"Confirm -s is NOT set", (boolean)cl.hasOption("s"));
        Assert.assertFalse((String)"Confirm -c is NOT set", (boolean)cl.hasOption("c"));
        Assert.assertTrue((String)"Confirm no extra args", (boolean)cl.getArgList().isEmpty());
    }

    @Test
    public void testSingleOptionFromGroup() throws Exception {
        String[] args = new String[]{"-f"};
        CommandLine cl = this.parser.parse(this.options, args);
        Assert.assertFalse((String)"Confirm -r is NOT set", (boolean)cl.hasOption("r"));
        Assert.assertTrue((String)"Confirm -f is set", (boolean)cl.hasOption("f"));
        Assert.assertFalse((String)"Confirm -d is NOT set", (boolean)cl.hasOption("d"));
        Assert.assertFalse((String)"Confirm -s is NOT set", (boolean)cl.hasOption("s"));
        Assert.assertFalse((String)"Confirm -c is NOT set", (boolean)cl.hasOption("c"));
        Assert.assertTrue((String)"Confirm no extra args", (boolean)cl.getArgList().isEmpty());
    }

    @Test
    public void testToString() {
        OptionGroup group1 = new OptionGroup();
        group1.addOption(new Option(null, "foo", false, "Foo"));
        group1.addOption(new Option(null, "bar", false, "Bar"));
        if (!"[--bar Bar, --foo Foo]".equals(group1.toString())) {
            Assert.assertEquals((Object)"[--foo Foo, --bar Bar]", (Object)group1.toString());
        }
        OptionGroup group2 = new OptionGroup();
        group2.addOption(new Option("f", "foo", false, "Foo"));
        group2.addOption(new Option("b", "bar", false, "Bar"));
        if (!"[-b Bar, -f Foo]".equals(group2.toString())) {
            Assert.assertEquals((Object)"[-f Foo, -b Bar]", (Object)group2.toString());
        }
    }

    @Test
    public void testTwoLongOptionsFromGroup() throws Exception {
        String[] args = new String[]{"--file", "--directory"};
        try {
            this.parser.parse(this.options, args);
            Assert.fail((String)"two arguments from group not allowed");
        }
        catch (AlreadySelectedException e) {
            Assert.assertNotNull((String)"null option group", (Object)e.getOptionGroup());
            Assert.assertEquals((String)"selected option", (Object)"f", (Object)e.getOptionGroup().getSelected());
            Assert.assertEquals((String)"option", (Object)"d", (Object)e.getOption().getOpt());
        }
    }

    @Test
    public void testTwoOptionsFromDifferentGroup() throws Exception {
        String[] args = new String[]{"-f", "-s"};
        CommandLine cl = this.parser.parse(this.options, args);
        Assert.assertFalse((String)"Confirm -r is NOT set", (boolean)cl.hasOption("r"));
        Assert.assertTrue((String)"Confirm -f is set", (boolean)cl.hasOption("f"));
        Assert.assertFalse((String)"Confirm -d is NOT set", (boolean)cl.hasOption("d"));
        Assert.assertTrue((String)"Confirm -s is set", (boolean)cl.hasOption("s"));
        Assert.assertFalse((String)"Confirm -c is NOT set", (boolean)cl.hasOption("c"));
        Assert.assertTrue((String)"Confirm NO extra args", (boolean)cl.getArgList().isEmpty());
    }

    @Test
    public void testTwoOptionsFromGroup() throws Exception {
        String[] args = new String[]{"-f", "-d"};
        try {
            this.parser.parse(this.options, args);
            Assert.fail((String)"two arguments from group not allowed");
        }
        catch (AlreadySelectedException e) {
            Assert.assertNotNull((String)"null option group", (Object)e.getOptionGroup());
            Assert.assertEquals((String)"selected option", (Object)"f", (Object)e.getOptionGroup().getSelected());
            Assert.assertEquals((String)"option", (Object)"d", (Object)e.getOption().getOpt());
        }
    }

    @Test
    public void testTwoOptionsFromGroupWithProperties() throws Exception {
        String[] args = new String[]{"-f"};
        Properties properties = new Properties();
        properties.put("d", "true");
        CommandLine cl = this.parser.parse(this.options, args, properties);
        Assert.assertTrue((boolean)cl.hasOption("f"));
        Assert.assertFalse((boolean)cl.hasOption("d"));
    }

    @Test
    public void testTwoValidLongOptions() throws Exception {
        String[] args = new String[]{"--revision", "--file"};
        CommandLine cl = this.parser.parse(this.options, args);
        Assert.assertTrue((String)"Confirm -r is set", (boolean)cl.hasOption("r"));
        Assert.assertTrue((String)"Confirm -f is set", (boolean)cl.hasOption("f"));
        Assert.assertFalse((String)"Confirm -d is NOT set", (boolean)cl.hasOption("d"));
        Assert.assertFalse((String)"Confirm -s is NOT set", (boolean)cl.hasOption("s"));
        Assert.assertFalse((String)"Confirm -c is NOT set", (boolean)cl.hasOption("c"));
        Assert.assertTrue((String)"Confirm no extra args", (boolean)cl.getArgList().isEmpty());
    }

    @Test
    public void testTwoValidOptions() throws Exception {
        String[] args = new String[]{"-r", "-f"};
        CommandLine cl = this.parser.parse(this.options, args);
        Assert.assertTrue((String)"Confirm -r is set", (boolean)cl.hasOption("r"));
        Assert.assertTrue((String)"Confirm -f is set", (boolean)cl.hasOption("f"));
        Assert.assertFalse((String)"Confirm -d is NOT set", (boolean)cl.hasOption("d"));
        Assert.assertFalse((String)"Confirm -s is NOT set", (boolean)cl.hasOption("s"));
        Assert.assertFalse((String)"Confirm -c is NOT set", (boolean)cl.hasOption("c"));
        Assert.assertTrue((String)"Confirm no extra args", (boolean)cl.getArgList().isEmpty());
    }

    @Test
    public void testValidLongOnlyOptions() throws Exception {
        CommandLine cl1 = this.parser.parse(this.options, new String[]{"--export"});
        Assert.assertTrue((String)"Confirm --export is set", (boolean)cl1.hasOption("export"));
        CommandLine cl2 = this.parser.parse(this.options, new String[]{"--import"});
        Assert.assertTrue((String)"Confirm --import is set", (boolean)cl2.hasOption("import"));
    }
}

