/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli.help;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.example.XhtmlHelpAppendable;
import org.apache.commons.cli.help.AbstractHelpFormatter;
import org.apache.commons.cli.help.HelpAppendable;
import org.apache.commons.cli.help.HelpFormatter;
import org.apache.commons.cli.help.OptionFormatter;
import org.apache.commons.cli.help.TextHelpAppendable;
import org.apache.commons.io.IOUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class HelpFormatterTest {
    HelpFormatterTest() {
    }

    private Options getTestGroups() {
        return new Options().addOptionGroup(new OptionGroup().addOption(Option.builder((String)"1").longOpt("one").hasArg().desc("English one").get()).addOption(Option.builder().longOpt("aon").hasArg().desc("Irish one").get()).addOption(Option.builder().longOpt("uno").hasArg().desc("Spanish one").get())).addOptionGroup(new OptionGroup().addOption(Option.builder().longOpt("two").hasArg().desc("English two").get()).addOption(Option.builder().longOpt("d\u00f3").hasArg().desc("Irish twp").get()).addOption(Option.builder().longOpt("dos").hasArg().desc("Spanish two").get())).addOptionGroup(new OptionGroup().addOption(Option.builder().longOpt("three").hasArg().desc("English three").get()).addOption(Option.builder().longOpt("tr\u00ed").hasArg().desc("Irish three").get()).addOption(Option.builder().longOpt("tres").hasArg().desc("Spanish three").get()));
    }

    @Test
    void testDefault() {
        StringBuilder sb = new StringBuilder();
        TextHelpAppendable serializer = new TextHelpAppendable((Appendable)sb);
        HelpFormatter formatter = ((HelpFormatter.Builder)HelpFormatter.builder().setHelpAppendable((HelpAppendable)serializer)).get();
        Assertions.assertEquals((Object)serializer, (Object)formatter.getSerializer(), (String)"Unexpected helpAppendable tests may fail unexpectedly");
        Assertions.assertEquals((Object)AbstractHelpFormatter.DEFAULT_COMPARATOR, (Object)formatter.getComparator(), (String)"Unexpected comparator tests may fail unexpectedly");
        Assertions.assertEquals((Object)"usage: ", (Object)formatter.getSyntaxPrefix(), (String)"Unexpected syntax prefix tests may fail unexpectedly");
    }

    @Test
    void testPrintHelp() throws IOException {
        StringBuilder sb = new StringBuilder();
        TextHelpAppendable serializer = new TextHelpAppendable((Appendable)sb);
        HelpFormatter formatter = ((HelpFormatter.Builder)HelpFormatter.builder().setHelpAppendable((HelpAppendable)serializer)).get();
        Options options = new Options().addOption(Option.builder((String)"a").since("1853").hasArg().desc("aaaa aaaa aaaa aaaa aaaa").get());
        ArrayList<String> expected = new ArrayList<String>();
        expected.add(" usage:  commandSyntax [-a <arg>]");
        expected.add("");
        expected.add(" header");
        expected.add("");
        expected.add(" Options      Since           Description       ");
        expected.add(" -a <arg>     1853      aaaa aaaa aaaa aaaa aaaa");
        expected.add("");
        expected.add(" footer");
        expected.add("");
        formatter.printHelp("commandSyntax", "header", options, "footer", true);
        List actual = IOUtils.readLines((Reader)new StringReader(sb.toString()));
        Assertions.assertEquals(expected, (Object)actual);
        formatter = ((HelpFormatter.Builder)HelpFormatter.builder().setShowSince(false).setHelpAppendable((HelpAppendable)serializer)).get();
        expected = new ArrayList();
        expected.add(" usage:  commandSyntax [-a <arg>]");
        expected.add("");
        expected.add(" header");
        expected.add("");
        expected.add(" Options            Description       ");
        expected.add(" -a <arg>     aaaa aaaa aaaa aaaa aaaa");
        expected.add("");
        expected.add(" footer");
        expected.add("");
        sb.setLength(0);
        formatter.printHelp("commandSyntax", "header", options, "footer", true);
        actual = IOUtils.readLines((Reader)new StringReader(sb.toString()));
        Assertions.assertEquals(expected, (Object)actual);
        sb.setLength(0);
        formatter.printHelp("commandSyntax", "header", options, "footer", false);
        expected.set(0, " usage:  commandSyntax");
        actual = IOUtils.readLines((Reader)new StringReader(sb.toString()));
        Assertions.assertEquals(expected, (Object)actual);
        sb.setLength(0);
        formatter.printHelp("commandSyntax", "", options, "footer", false);
        expected.remove(3);
        expected.remove(2);
        actual = IOUtils.readLines((Reader)new StringReader(sb.toString()));
        Assertions.assertEquals(expected, (Object)actual);
        sb.setLength(0);
        formatter.printHelp("commandSyntax", null, options, "footer", false);
        actual = IOUtils.readLines((Reader)new StringReader(sb.toString()));
        Assertions.assertEquals(expected, (Object)actual);
        sb.setLength(0);
        formatter.printHelp("commandSyntax", null, options, "", false);
        expected.remove(6);
        expected.remove(5);
        actual = IOUtils.readLines((Reader)new StringReader(sb.toString()));
        Assertions.assertEquals(expected, (Object)actual);
        sb.setLength(0);
        formatter.printHelp("commandSyntax", null, options, null, false);
        actual = IOUtils.readLines((Reader)new StringReader(sb.toString()));
        Assertions.assertEquals(expected, (Object)actual);
        sb.setLength(0);
        HelpFormatter fHelp = formatter;
        Assertions.assertThrows(IllegalArgumentException.class, () -> fHelp.printHelp("", "header", options, "footer", true));
        Assertions.assertEquals((int)0, (int)sb.length(), (String)"Should not write to output");
        Assertions.assertThrows(IllegalArgumentException.class, () -> fHelp.printHelp(null, "header", options, "footer", true));
        Assertions.assertEquals((int)0, (int)sb.length(), (String)"Should not write to output");
    }

    @Test
    void testPrintHelpXML() throws IOException {
        StringBuilder sb = new StringBuilder();
        XhtmlHelpAppendable serializer = new XhtmlHelpAppendable(sb);
        HelpFormatter formatter = ((HelpFormatter.Builder)HelpFormatter.builder().setHelpAppendable((HelpAppendable)serializer)).get();
        Options options = new Options().addOption("a", false, "aaaa aaaa aaaa aaaa aaaa");
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("<p>usage:  commandSyntax [-a]</p>");
        expected.add("<p>header</p>");
        expected.add("<table class='commons_cli_table'>");
        expected.add("  <tr>");
        expected.add("    <th>Options</th>");
        expected.add("    <th>Since</th>");
        expected.add("    <th>Description</th>");
        expected.add("  </tr>");
        expected.add("  <tr>");
        expected.add("    <td>-a</td>");
        expected.add("    <td>--</td>");
        expected.add("    <td>aaaa aaaa aaaa aaaa aaaa</td>");
        expected.add("  </tr>");
        expected.add("</table>");
        expected.add("<p>footer</p>");
        formatter.printHelp("commandSyntax", "header", options, "footer", true);
        List actual = IOUtils.readLines((Reader)new StringReader(sb.toString()));
        Assertions.assertEquals(expected, (Object)actual);
    }

    @Test
    void testPrintOptions() throws IOException {
        StringBuilder sb = new StringBuilder();
        TextHelpAppendable serializer = new TextHelpAppendable((Appendable)sb);
        HelpFormatter formatter = ((HelpFormatter.Builder)HelpFormatter.builder().setHelpAppendable((HelpAppendable)serializer)).setShowSince(false).get();
        ArrayList<String> expected = new ArrayList<String>();
        expected.add(" Options           Description       ");
        expected.add(" -a          aaaa aaaa aaaa aaaa aaaa");
        expected.add("");
        Options options = new Options().addOption("a", false, "aaaa aaaa aaaa aaaa aaaa");
        formatter.printOptions(options);
        List actual = IOUtils.readLines((Reader)new StringReader(sb.toString()));
        Assertions.assertEquals(expected, (Object)actual);
        sb.setLength(0);
        serializer.setMaxWidth(30);
        expected = new ArrayList();
        expected.add(" Options        Description    ");
        expected.add(" -a          aaaa aaaa aaaa    ");
        expected.add("              aaaa aaaa        ");
        expected.add("");
        formatter.printOptions(options);
        actual = IOUtils.readLines((Reader)new StringReader(sb.toString()));
        Assertions.assertEquals((int)31, (int)((String)actual.get(0)).length());
        Assertions.assertEquals(expected, (Object)actual);
        sb.setLength(0);
        serializer.setLeftPad(5);
        expected = new ArrayList();
        expected.add("     Options        Description    ");
        expected.add("     -a          aaaa aaaa aaaa    ");
        expected.add("                  aaaa aaaa        ");
        expected.add("");
        formatter.printOptions(options);
        actual = IOUtils.readLines((Reader)new StringReader(sb.toString()));
        Assertions.assertEquals(expected, (Object)actual);
    }

    @Test
    void testSetOptionFormatBuilderTest() {
        HelpFormatter.Builder underTest = HelpFormatter.builder();
        OptionFormatter.Builder ofBuilder = OptionFormatter.builder().setOptPrefix("Just Another ");
        underTest.setOptionFormatBuilder(ofBuilder);
        HelpFormatter formatter = underTest.get();
        OptionFormatter oFormatter = formatter.getOptionFormatter(Option.builder((String)"thing").get());
        Assertions.assertEquals((Object)"Just Another thing", (Object)oFormatter.getOpt());
    }

    @Test
    void testSetOptionGroupSeparatorTest() {
        HelpFormatter.Builder underTest = (HelpFormatter.Builder)HelpFormatter.builder().setOptionGroupSeparator(" and ");
        HelpFormatter formatter = underTest.get();
        String result = formatter.toSyntaxOptions(new OptionGroup().addOption(Option.builder((String)"this").get()).addOption(Option.builder((String)"that").get()));
        Assertions.assertTrue((boolean)result.contains("-that and -this"));
    }

    @Test
    void testSortOptionGroupsTest() {
        Options options = this.getTestGroups();
        ArrayList optList = new ArrayList(options.getOptions());
        HelpFormatter underTest = HelpFormatter.builder().get();
        ArrayList<Option> expected = new ArrayList<Option>();
        expected.add((Option)optList.get(0));
        expected.add((Option)optList.get(1));
        expected.add((Option)optList.get(5));
        expected.add((Option)optList.get(4));
        expected.add((Option)optList.get(6));
        expected.add((Option)optList.get(8));
        expected.add((Option)optList.get(7));
        expected.add((Option)optList.get(3));
        expected.add((Option)optList.get(2));
        Assertions.assertEquals(expected, (Object)underTest.sort(options));
    }

    @Test
    void testSortOptionsTest() {
        Options options = new Options().addOption(Option.builder((String)"a").longOpt("optA").hasArg().desc("The description of A").get()).addOption(Option.builder((String)"b").longOpt("BOpt").hasArg().desc("B description").get()).addOption(Option.builder().longOpt("COpt").hasArg().desc("A COpt description").get());
        HelpFormatter underTest = HelpFormatter.builder().get();
        ArrayList<Option> expected = new ArrayList<Option>();
        expected.add(options.getOption("a"));
        expected.add(options.getOption("b"));
        expected.add(options.getOption("COpt"));
        Assertions.assertEquals(expected, (Object)underTest.sort(options));
        expected.set(0, (Option)expected.get(2));
        expected.set(2, options.getOption("a"));
        underTest = ((HelpFormatter.Builder)HelpFormatter.builder().setComparator(AbstractHelpFormatter.DEFAULT_COMPARATOR.reversed())).get();
        Assertions.assertEquals(expected, (Object)underTest.sort(options));
        Assertions.assertEquals((int)0, (int)underTest.sort(Collections.emptyList()).size(), (String)"empty colleciton should return empty list");
        Assertions.assertEquals((int)0, (int)underTest.sort((Iterable)null).size(), (String)"null iterable should return empty list");
        Assertions.assertEquals((int)0, (int)underTest.sort((Options)null).size(), (String)"null Options should return empty list");
    }

    @Test
    void testSyntaxPrefix() {
        StringBuilder sb = new StringBuilder();
        TextHelpAppendable serializer = new TextHelpAppendable((Appendable)sb);
        HelpFormatter formatter = ((HelpFormatter.Builder)HelpFormatter.builder().setHelpAppendable((HelpAppendable)serializer)).get();
        formatter.setSyntaxPrefix("Something new");
        Assertions.assertEquals((Object)"Something new", (Object)formatter.getSyntaxPrefix());
        Assertions.assertEquals((int)0, (int)sb.length(), (String)"Should not write to output");
    }

    @Test
    void testToArgNameTest() {
        StringBuilder sb = new StringBuilder();
        TextHelpAppendable serializer = new TextHelpAppendable((Appendable)sb);
        HelpFormatter formatter = ((HelpFormatter.Builder)HelpFormatter.builder().setHelpAppendable((HelpAppendable)serializer)).get();
        Assertions.assertEquals((Object)"<some Arg>", (Object)formatter.toArgName("some Arg"));
        Assertions.assertEquals((Object)"<>", (Object)formatter.toArgName(""));
        Assertions.assertEquals((Object)"<>", (Object)formatter.toArgName(null));
    }

    @Test
    void testToSyntaxOptionGroupTest() {
        HelpFormatter underTest = HelpFormatter.builder().get();
        OptionGroup optionGroup = new OptionGroup().addOption(Option.builder().option("o").longOpt("one").hasArg().get()).addOption(Option.builder().option("t").longOpt("two").hasArg().required().argName("other").get()).addOption(Option.builder().option("th").longOpt("three").required().argName("other").get()).addOption(Option.builder().option("f").argName("other").get()).addOption(Option.builder().longOpt("five").hasArg().argName("other").get()).addOption(Option.builder().longOpt("six").required().hasArg().argName("other").get()).addOption(Option.builder().option("s").longOpt("sevem").hasArg().get());
        Assertions.assertEquals((Object)"[-f | --five <other> | -o <arg> | -s <arg> | --six <other> | -t <other> | -th]", (Object)underTest.toSyntaxOptions(optionGroup));
        optionGroup.setRequired(true);
        Assertions.assertEquals((Object)"-f | --five <other> | -o <arg> | -s <arg> | --six <other> | -t <other> | -th", (Object)underTest.toSyntaxOptions(optionGroup));
        Assertions.assertEquals((Object)"", (Object)underTest.toSyntaxOptions(new OptionGroup()), (String)"empty group should return empty string");
    }

    @Test
    void testToSyntaxOptionIterableTest() {
        HelpFormatter underTest = HelpFormatter.builder().get();
        ArrayList<Option> options = new ArrayList<Option>();
        options.add(Option.builder().option("o").longOpt("one").hasArg().get());
        options.add(Option.builder().option("t").longOpt("two").hasArg().required().argName("other").get());
        options.add(Option.builder().option("th").longOpt("three").required().argName("other").get());
        options.add(Option.builder().option("f").argName("other").get());
        options.add(Option.builder().longOpt("five").hasArg().argName("other").get());
        options.add(Option.builder().longOpt("six").required().hasArg().argName("other").get());
        options.add(Option.builder().option("s").longOpt("sevem").hasArg().get());
        Assertions.assertEquals((Object)"[-f] [--five <other>] [-o <arg>] [-s <arg>] --six <other> -t <other> -th", (Object)underTest.toSyntaxOptions(options));
    }

    @Test
    void testToSyntaxOptionOptionsTest() {
        HelpFormatter underTest = HelpFormatter.builder().get();
        Options options = this.getTestGroups();
        Assertions.assertEquals((Object)"[-1 <arg> | --aon <arg> | --uno <arg>] [--dos <arg> | --d\u00f3 <arg> | --two <arg>] [--three <arg> | --tres <arg> | --tr\u00ed <arg>]", (Object)underTest.toSyntaxOptions(options), (String)"getTestGroup options failed");
        options = new Options().addOption(Option.builder().option("o").longOpt("one").hasArg().get()).addOption(Option.builder().option("t").longOpt("two").hasArg().required().argName("other").get()).addOption(Option.builder().option("th").longOpt("three").required().argName("other").get()).addOption(Option.builder().option("f").argName("other").get()).addOption(Option.builder().longOpt("five").hasArg().argName("other").get()).addOption(Option.builder().longOpt("six").required().hasArg().argName("other").get()).addOption(Option.builder().option("s").longOpt("seven").hasArg().get());
        Assertions.assertEquals((Object)"[-f] [--five <other>] [-o <arg>] [-s <arg>] --six <other> -t <other> -th", (Object)underTest.toSyntaxOptions(options), (String)"assorted options failed");
        options = new Options().addOption(Option.builder().option("o").longOpt("one").hasArg().get()).addOptionGroup(new OptionGroup().addOption(Option.builder().option("t").longOpt("two").hasArg().required().argName("other").get()).addOption(Option.builder().option("th").longOpt("three").required().argName("other").get())).addOption(Option.builder().option("f").argName("other").get()).addOption(Option.builder().longOpt("five").hasArg().argName("other").get()).addOption(Option.builder().longOpt("six").required().hasArg().argName("other").get()).addOption(Option.builder().option("s").longOpt("seven").hasArg().get());
        Assertions.assertEquals((Object)"[-f] [--five <other>] [-o <arg>] [-s <arg>] --six <other> [-t <other> | -th]", (Object)underTest.toSyntaxOptions(options), (String)"option with group failed");
        OptionGroup group1 = new OptionGroup().addOption(Option.builder().option("t").longOpt("two").hasArg().required().argName("other").get()).addOption(Option.builder().option("th").longOpt("three").required().argName("other").get());
        group1.setRequired(true);
        options = new Options().addOption(Option.builder().option("o").longOpt("one").hasArg().get()).addOptionGroup(group1).addOption(Option.builder().option("f").argName("other").get()).addOption(Option.builder().longOpt("five").hasArg().argName("other").get()).addOption(Option.builder().longOpt("six").required().hasArg().argName("other").get()).addOption(Option.builder().option("s").longOpt("seven").hasArg().get());
        Assertions.assertEquals((Object)"[-f] [--five <other>] [-o <arg>] [-s <arg>] --six <other> -t <other> | -th", (Object)underTest.toSyntaxOptions(options), (String)"options with required group failed");
    }
}

