/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils2;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import org.apache.commons.beanutils2.ConstructorUtils;
import org.apache.commons.beanutils2.TestBean;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ConstructorUtilsTest {
    @BeforeEach
    public void setUp() throws Exception {
    }

    @AfterEach
    public void tearDown() throws Exception {
    }

    @Test
    public void testGetAccessibleConstructor() throws Exception {
        Constructor ctor = ConstructorUtils.getAccessibleConstructor(TestBean.class, String.class);
        Assertions.assertNotNull((Object)ctor);
        Assertions.assertTrue((boolean)Modifier.isPublic(ctor.getModifiers()));
        ctor = ConstructorUtils.getAccessibleConstructor(TestBean.class, Integer.class);
        Assertions.assertNotNull((Object)ctor);
        Assertions.assertTrue((boolean)Modifier.isPublic(ctor.getModifiers()));
        ctor = ConstructorUtils.getAccessibleConstructor(TestBean.class, Integer.TYPE);
        Assertions.assertNull((Object)ctor);
    }

    @Test
    public void testGetAccessibleConstructorWithConstructorArg() throws Exception {
        Class[] types = new Class[]{Integer.class};
        Constructor c1 = TestBean.class.getConstructor(types);
        Constructor ctor = ConstructorUtils.getAccessibleConstructor(c1);
        Assertions.assertNotNull((Object)ctor);
        Assertions.assertTrue((boolean)Modifier.isPublic(ctor.getModifiers()));
        types = new Class[]{Integer.class};
        c1 = TestBean.class.getDeclaredConstructor(types);
        ctor = ConstructorUtils.getAccessibleConstructor(c1);
        Assertions.assertNotNull((Object)ctor);
        Assertions.assertTrue((boolean)Modifier.isPublic(ctor.getModifiers()));
        types = new Class[]{Integer.TYPE};
        c1 = TestBean.class.getDeclaredConstructor(types);
        ctor = ConstructorUtils.getAccessibleConstructor(c1);
        Assertions.assertNull((Object)ctor);
    }

    @Test
    public void testGetAccessibleConstructorWithTypeArray() throws Exception {
        Class[] types = new Class[]{Boolean.TYPE, String.class};
        Constructor ctor = ConstructorUtils.getAccessibleConstructor(TestBean.class, (Class[])types);
        Assertions.assertNotNull((Object)ctor);
        Assertions.assertTrue((boolean)Modifier.isPublic(ctor.getModifiers()));
        types = new Class[]{Boolean.TYPE, Boolean.TYPE, String.class};
        ctor = ConstructorUtils.getAccessibleConstructor(TestBean.class, (Class[])types);
        Assertions.assertNull((Object)ctor);
    }

    @Test
    public void testInvokeConstructor() throws Exception {
        Object obj = ConstructorUtils.invokeConstructor(TestBean.class, (Object)"TEST");
        Assertions.assertNotNull((Object)obj);
        Assertions.assertInstanceOf(TestBean.class, (Object)obj);
        Assertions.assertEquals((Object)"TEST", (Object)((TestBean)obj).getStringProperty());
        obj = ConstructorUtils.invokeConstructor(TestBean.class, (Object)Float.valueOf(17.3f));
        Assertions.assertNotNull((Object)obj);
        Assertions.assertInstanceOf(TestBean.class, (Object)obj);
        Assertions.assertEquals((float)17.3f, (float)((TestBean)obj).getFloatProperty(), (float)0.0f);
    }

    @Test
    public void testInvokeConstructorNull() throws Exception {
        Object obj = ConstructorUtils.invokeConstructor(TestBean.class, null);
        Assertions.assertNotNull((Object)obj);
        Assertions.assertInstanceOf(TestBean.class, (Object)obj);
    }

    @Test
    public void testInvokeConstructorWithArgArray() throws Exception {
        Object[] args = new Object[]{Float.valueOf(17.3f), "TEST"};
        Object obj = ConstructorUtils.invokeConstructor(TestBean.class, (Object[])args);
        Assertions.assertNotNull((Object)obj);
        Assertions.assertInstanceOf(TestBean.class, (Object)obj);
        Assertions.assertEquals((float)17.3f, (float)((TestBean)obj).getFloatProperty(), (float)0.0f);
        Assertions.assertEquals((Object)"TEST", (Object)((TestBean)obj).getStringProperty());
    }

    @Test
    public void testInvokeConstructorWithTypeArray() throws Exception {
        Object[] args = new Object[]{Boolean.TRUE, "TEST"};
        Class[] types = new Class[]{Boolean.TYPE, String.class};
        Object obj = ConstructorUtils.invokeConstructor(TestBean.class, (Object[])args, (Class[])types);
        Assertions.assertNotNull((Object)obj);
        Assertions.assertInstanceOf(TestBean.class, (Object)obj);
        Assertions.assertTrue((boolean)((TestBean)obj).getBooleanProperty());
        Assertions.assertEquals((Object)"TEST", (Object)((TestBean)obj).getStringProperty());
        args = new Object[]{Boolean.TRUE, "TEST"};
        types = new Class[]{Boolean.class, String.class};
        obj = ConstructorUtils.invokeConstructor(TestBean.class, (Object[])args, (Class[])types);
        Assertions.assertNotNull((Object)obj);
        Assertions.assertInstanceOf(TestBean.class, (Object)obj);
        Assertions.assertTrue((boolean)((TestBean)obj).isBooleanSecond());
        Assertions.assertEquals((Object)"TEST", (Object)((TestBean)obj).getStringProperty());
    }

    @Test
    public void testInvokeExactConstructor() throws Exception {
        Object obj = ConstructorUtils.invokeExactConstructor(TestBean.class, (Object)"TEST");
        Assertions.assertNotNull((Object)obj);
        Assertions.assertInstanceOf(TestBean.class, (Object)obj);
        Assertions.assertEquals((Object)"TEST", (Object)((TestBean)obj).getStringProperty());
        Assertions.assertThrows(NoSuchMethodException.class, () -> ConstructorUtils.invokeExactConstructor(TestBean.class, (Object)Float.valueOf(17.3f)));
        obj = ConstructorUtils.invokeExactConstructor(TestBean.class, (Object)Boolean.TRUE);
        Assertions.assertNotNull((Object)obj);
        Assertions.assertInstanceOf(TestBean.class, (Object)obj);
        Assertions.assertTrue((boolean)((TestBean)obj).isBooleanSecond());
    }

    @Test
    public void testInvokeExactConstructorWithArgArray() throws Exception {
        Object[] args = new Object[]{Float.valueOf(17.3f), "TEST"};
        Assertions.assertThrows(NoSuchMethodException.class, () -> ConstructorUtils.invokeExactConstructor(TestBean.class, (Object[])args));
        args = new Object[]{Boolean.TRUE, "TEST"};
        Object obj = ConstructorUtils.invokeExactConstructor(TestBean.class, (Object[])args);
        Assertions.assertNotNull((Object)obj);
        Assertions.assertInstanceOf(TestBean.class, (Object)obj);
        Assertions.assertTrue((boolean)((TestBean)obj).isBooleanSecond());
        Assertions.assertEquals((Object)"TEST", (Object)((TestBean)obj).getStringProperty());
    }

    @Test
    public void testInvokeExactConstructorWithNull() throws Exception {
        Object obj = ConstructorUtils.invokeExactConstructor(TestBean.class, null);
        Assertions.assertNotNull((Object)obj);
        Assertions.assertInstanceOf(TestBean.class, (Object)obj);
    }

    @Test
    public void testInvokeExactConstructorWithTypeArray() throws Exception {
        Object[] args = new Object[]{Boolean.TRUE, "TEST"};
        Class[] types = new Class[]{Boolean.TYPE, String.class};
        Object obj = ConstructorUtils.invokeExactConstructor(TestBean.class, (Object[])args, (Class[])types);
        Assertions.assertNotNull((Object)obj);
        Assertions.assertInstanceOf(TestBean.class, (Object)obj);
        Assertions.assertTrue((boolean)((TestBean)obj).getBooleanProperty());
        Assertions.assertEquals((Object)"TEST", (Object)((TestBean)obj).getStringProperty());
        args = new Object[]{Boolean.TRUE, "TEST"};
        types = new Class[]{Boolean.class, String.class};
        obj = ConstructorUtils.invokeExactConstructor(TestBean.class, (Object[])args, (Class[])types);
        Assertions.assertNotNull((Object)obj);
        Assertions.assertInstanceOf(TestBean.class, (Object)obj);
        Assertions.assertTrue((boolean)((TestBean)obj).isBooleanSecond());
        Assertions.assertEquals((Object)"TEST", (Object)((TestBean)obj).getStringProperty());
        args = new Object[]{Float.valueOf(17.3f), "TEST"};
        types = new Class[]{Float.TYPE, String.class};
        obj = ConstructorUtils.invokeExactConstructor(TestBean.class, (Object[])args, (Class[])types);
        Assertions.assertNotNull((Object)obj);
        Assertions.assertInstanceOf(TestBean.class, (Object)obj);
        Assertions.assertEquals((float)17.3f, (float)((TestBean)obj).getFloatProperty(), (float)0.0f);
        Assertions.assertEquals((Object)"TEST", (Object)((TestBean)obj).getStringProperty());
        args = new Object[]{Float.valueOf(17.3f), "TEST"};
        types = new Class[]{Float.class, String.class};
        Assertions.assertThrows(NoSuchMethodException.class, () -> ConstructorUtils.invokeExactConstructor(TestBean.class, (Object[])args, (Class[])types));
    }
}

