/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils2.bugs;

import java.util.HashMap;
import org.apache.commons.beanutils2.BeanUtils;
import org.apache.commons.beanutils2.PropertyUtils;
import org.apache.commons.beanutils2.WrapDynaBean;
import org.apache.commons.beanutils2.bugs.other.Jira61BeanFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;

public class Jira61Test {
    private static Jira61BeanFactory.TestBean testBean;
    private static WrapDynaBean wrapDynaBean;

    @BeforeAll
    public static void beforeAll() throws Exception {
        testBean = Jira61BeanFactory.createBean();
        PropertyUtils.getPropertyDescriptor((Object)testBean, (String)"mappedReadOnly");
        PropertyUtils.getPropertyDescriptor((Object)testBean, (String)"mappedWriteOnly");
        wrapDynaBean = new WrapDynaBean((Object)testBean);
    }

    @Test
    public void testIssue_BEANUTILS_61_BeanUtils_copyProperties_from_WrapDynaBean() throws Exception {
        String value = "ORIG TARGET VALUE";
        Jira61BeanFactory.TestBean targetBean = Jira61BeanFactory.createBean();
        targetBean.setSimpleWriteOnly("ORIG TARGET VALUE");
        BeanUtils.copyProperties((Object)targetBean, (Object)wrapDynaBean);
        Assertions.assertEquals((Object)"ORIG TARGET VALUE", (Object)targetBean.getSimpleReadOnly());
    }

    @Test
    public void testIssue_BEANUTILS_61_BeanUtils_copyProperties_to_WrapDynaBean() throws Exception {
        String value = "copied simpleReadOnly";
        HashMap<String, String> source = new HashMap<String, String>();
        source.put("simpleReadOnly", "copied simpleReadOnly");
        BeanUtils.copyProperties((Object)wrapDynaBean, source);
        Assertions.assertNotEquals((Object)"copied simpleReadOnly", (Object)testBean.getSimpleReadOnly());
    }

    @Test
    public void testIssue_BEANUTILS_61_PropertyUtils_copyProperties_from_WrapDynaBean() throws Exception {
        String value = "ORIG TARGET VALUE";
        Jira61BeanFactory.TestBean targetBean = Jira61BeanFactory.createBean();
        targetBean.setSimpleWriteOnly("ORIG TARGET VALUE");
        PropertyUtils.copyProperties((Object)targetBean, (Object)wrapDynaBean);
        Assertions.assertEquals((Object)"ORIG TARGET VALUE", (Object)targetBean.getSimpleReadOnly());
    }

    @Test
    public void testIssue_BEANUTILS_61_PropertyUtils_copyProperties_to_WrapDynaBean() throws Exception {
        String expected = "copied simpleReadOnly";
        HashMap<String, String> source = new HashMap<String, String>();
        source.put("simpleReadOnly", "copied simpleReadOnly");
        PropertyUtils.copyProperties((Object)wrapDynaBean, source);
        Assertions.assertNotEquals((Object)"copied simpleReadOnly", (Object)testBean.getSimpleReadOnly());
    }

    @Test
    public void testIssue_BEANUTILS_61_PropertyUtils_getProperty() {
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertEquals((Object)testBean.getSimpleReadOnly(), (Object)PropertyUtils.getProperty((Object)wrapDynaBean, (String)"simpleReadOnly")), () -> Assertions.assertThrows(IllegalArgumentException.class, () -> PropertyUtils.getProperty((Object)wrapDynaBean, (String)"simpleWriteOnly"))});
    }

    @Test
    public void testIssue_BEANUTILS_61_PropertyUtils_getProperty_Indexed() {
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertEquals((Object)testBean.getIndexedReadOnly(0), (Object)PropertyUtils.getProperty((Object)wrapDynaBean, (String)"indexedReadOnly[0]")), () -> Assertions.assertThrows(IllegalArgumentException.class, () -> PropertyUtils.getProperty((Object)wrapDynaBean, (String)"indexedWriteOnly[0]"))});
    }

    @Test
    public void testIssue_BEANUTILS_61_PropertyUtils_getProperty_Mapped() {
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertEquals((Object)testBean.getMappedReadOnly("foo-key"), (Object)PropertyUtils.getProperty((Object)wrapDynaBean, (String)"mappedReadOnly(foo-key)")), () -> Assertions.assertThrows(IllegalArgumentException.class, () -> PropertyUtils.getProperty((Object)wrapDynaBean, (String)"mappedWriteOnly(foo-key)"))});
    }

    @Test
    public void testIssue_BEANUTILS_61_PropertyUtils_isReadable() {
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertTrue((boolean)PropertyUtils.isReadable((Object)wrapDynaBean, (String)"simpleReadOnly")), () -> Assertions.assertFalse((boolean)PropertyUtils.isReadable((Object)wrapDynaBean, (String)"simpleWriteOnly"))});
    }

    @Test
    public void testIssue_BEANUTILS_61_PropertyUtils_isReadable_Indexed() {
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertTrue((boolean)PropertyUtils.isReadable((Object)wrapDynaBean, (String)"indexedReadOnly")), () -> Assertions.assertFalse((boolean)PropertyUtils.isReadable((Object)wrapDynaBean, (String)"indexedWriteOnly"))});
    }

    @Test
    public void testIssue_BEANUTILS_61_PropertyUtils_isReadable_Mapped() {
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertTrue((boolean)PropertyUtils.isReadable((Object)wrapDynaBean, (String)"mappedReadOnly")), () -> Assertions.assertFalse((boolean)PropertyUtils.isReadable((Object)wrapDynaBean, (String)"mappedWriteOnly"))});
    }

    @Test
    public void testIssue_BEANUTILS_61_PropertyUtils_isWriteable() {
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertFalse((boolean)PropertyUtils.isWriteable((Object)wrapDynaBean, (String)"simpleReadOnly")), () -> Assertions.assertTrue((boolean)PropertyUtils.isWriteable((Object)wrapDynaBean, (String)"simpleWriteOnly"))});
    }

    @Test
    public void testIssue_BEANUTILS_61_PropertyUtils_isWriteable_Indexed() {
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertFalse((boolean)PropertyUtils.isWriteable((Object)wrapDynaBean, (String)"indexedReadOnly")), () -> Assertions.assertTrue((boolean)PropertyUtils.isWriteable((Object)wrapDynaBean, (String)"indexedWriteOnly"))});
    }

    @Test
    public void testIssue_BEANUTILS_61_PropertyUtils_isWriteable_Mapped() {
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertFalse((boolean)PropertyUtils.isWriteable((Object)wrapDynaBean, (String)"mappedReadOnly")), () -> Assertions.assertTrue((boolean)PropertyUtils.isWriteable((Object)wrapDynaBean, (String)"mappedWriteOnly"))});
    }

    @Test
    public void testIssue_BEANUTILS_61_PropertyUtils_setProperty() {
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertThrows(IllegalArgumentException.class, () -> PropertyUtils.setProperty((Object)wrapDynaBean, (String)"simpleReadOnly", (Object)"READONLY-SIMPLE-BAR")), () -> {
            PropertyUtils.setProperty((Object)wrapDynaBean, (String)"simpleWriteOnly", (Object)"SIMPLE-BAR");
            Assertions.assertEquals((Object)"SIMPLE-BAR", (Object)testBean.getSimpleReadOnly());
        }});
    }

    @Test
    public void testIssue_BEANUTILS_61_PropertyUtils_setProperty_Indexed() {
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertThrows(IllegalArgumentException.class, () -> PropertyUtils.setProperty((Object)wrapDynaBean, (String)"indexedReadOnly[0]", (Object)"READONLY-INDEXED-BAR")), () -> {
            PropertyUtils.setProperty((Object)wrapDynaBean, (String)"indexedWriteOnly[0]", (Object)"INDEXED-BAR");
            Assertions.assertEquals((Object)"INDEXED-BAR", (Object)testBean.getIndexedReadOnly(0));
        }});
    }

    @Test
    public void testIssue_BEANUTILS_61_PropertyUtils_setProperty_Mapped() {
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertThrows(IllegalArgumentException.class, () -> PropertyUtils.setProperty((Object)wrapDynaBean, (String)"mappedReadOnly(foo-key)", (Object)"READONLY-MAPPED-BAR")), () -> {
            PropertyUtils.setProperty((Object)wrapDynaBean, (String)"mappedWriteOnly(foo-key)", (Object)"MAPPED-BAR");
            Assertions.assertEquals((Object)"MAPPED-BAR", (Object)testBean.getMappedReadOnly("foo-key"));
        }});
    }
}

