/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils2.bugs;

import org.apache.commons.beanutils2.BeanUtils;
import org.apache.commons.beanutils2.BeanUtilsBean;
import org.apache.commons.beanutils2.Converter;
import org.apache.commons.beanutils2.converters.ArrayConverter;
import org.apache.commons.beanutils2.converters.StringConverter;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Jira359Test {
    @BeforeEach
    protected void setUp() throws Exception {
    }

    private void showArray(String text, String[] array) {
        if (array == null) {
            System.out.println(text + " array is null");
        } else {
            System.out.println(text + " array length=" + array.length);
            for (int i = 0; i < array.length; ++i) {
                System.out.println(text + " array[" + i + "]=" + array[i]);
            }
        }
    }

    @AfterEach
    protected void tearDown() throws Exception {
    }

    @Test
    public void testBeanUtilsSetProperty_CustomConvertStringToArray_WithColonValue() throws Exception {
        ArrayConverter converter = new ArrayConverter(String[].class, (Converter)new StringConverter());
        converter.setAllowedChars(new char[]{'.', '-', ':'});
        BeanUtilsBean utils = new BeanUtilsBean();
        utils.getConvertUtils().register((Converter)converter, String[].class);
        SimplePojoData simplePojo = new SimplePojoData();
        utils.setProperty((Object)simplePojo, "jcrMixinTypes", (Object)"mix:rereferencible,mix:simple");
        this.showArray("Custom WithColonValue", simplePojo.getJcrMixinTypes());
        Assertions.assertEquals((int)2, (int)simplePojo.getJcrMixinTypes().length, (String)"array size");
        Assertions.assertEquals((Object)"mix:rereferencible", (Object)simplePojo.getJcrMixinTypes()[0]);
        Assertions.assertEquals((Object)"mix:simple", (Object)simplePojo.getJcrMixinTypes()[1]);
    }

    @Test
    public void testBeanUtilsSetProperty_DefaultConvertStringToArray_WithColonValue() throws Exception {
        SimplePojoData simplePojo = new SimplePojoData();
        BeanUtils.setProperty((Object)simplePojo, (String)"jcrMixinTypes", (Object)"mix:rereferencible,mix:simple");
        this.showArray("Default WithColonValue", simplePojo.getJcrMixinTypes());
        Assertions.assertEquals((int)4, (int)simplePojo.getJcrMixinTypes().length, (String)"array size");
        Assertions.assertEquals((Object)"mix", (Object)simplePojo.getJcrMixinTypes()[0]);
        Assertions.assertEquals((Object)"rereferencible", (Object)simplePojo.getJcrMixinTypes()[1]);
        Assertions.assertEquals((Object)"mix", (Object)simplePojo.getJcrMixinTypes()[2]);
        Assertions.assertEquals((Object)"simple", (Object)simplePojo.getJcrMixinTypes()[3]);
    }

    @Test
    public void testBeanUtilsSetProperty_DefaultConvertStringToArray_WithoutColonValue() throws Exception {
        SimplePojoData simplePojo = new SimplePojoData();
        BeanUtils.setProperty((Object)simplePojo, (String)"jcrMixinTypes", (Object)"mixrereferencible,mixsimple");
        this.showArray("Default WithoutColonValue", simplePojo.getJcrMixinTypes());
        Assertions.assertEquals((int)2, (int)simplePojo.getJcrMixinTypes().length, (String)"array size");
        Assertions.assertEquals((Object)"mixrereferencible", (Object)simplePojo.getJcrMixinTypes()[0]);
        Assertions.assertEquals((Object)"mixsimple", (Object)simplePojo.getJcrMixinTypes()[1]);
    }

    @Test
    public void testBeanUtilsSetProperty_DefaultConvertStringToArray_WithoutColonValueAndNocoma() throws Exception {
        SimplePojoData simplePojo = new SimplePojoData();
        BeanUtils.setProperty((Object)simplePojo, (String)"jcrMixinTypes", (Object)"mixrereferencible");
        this.showArray("Default WithoutColonAndNocoma", simplePojo.getJcrMixinTypes());
        Assertions.assertEquals((int)1, (int)simplePojo.getJcrMixinTypes().length, (String)"array size");
        Assertions.assertEquals((Object)"mixrereferencible", (Object)simplePojo.getJcrMixinTypes()[0]);
    }

    public static class SimplePojoData {
        private String[] jcrMixinTypes = new String[1];

        public String[] getJcrMixinTypes() {
            return this.jcrMixinTypes;
        }

        public void setJcrMixinTypes(String[] mixinTypes) {
            this.jcrMixinTypes = mixinTypes;
        }
    }
}

