/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils.converters;

import java.sql.Time;
import java.util.Calendar;
import java.util.Locale;
import junit.framework.TestSuite;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.converters.DateConverterTestBase;
import org.apache.commons.beanutils.converters.DateTimeConverter;
import org.apache.commons.beanutils.converters.SqlTimeConverter;

public class SqlTimeConverterTestCase
extends DateConverterTestBase {
    public SqlTimeConverterTestCase(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(SqlTimeConverterTestCase.class);
    }

    @Override
    public void testLocale() {
        Locale defaultLocale = Locale.getDefault();
        Locale.setDefault(Locale.US);
        String pattern = "h:mm a";
        DateTimeConverter converter = this.makeConverter();
        converter.setUseLocaleFormat(true);
        String testString = "3:06 pm";
        Object expected = this.toType("3:06 pm", "h:mm a", null);
        this.validConversion((Converter)converter, expected, "3:06 pm");
        this.invalidConversion((Converter)converter, null);
        this.invalidConversion((Converter)converter, "");
        this.invalidConversion((Converter)converter, "13:05");
        this.invalidConversion((Converter)converter, "11:05 p");
        this.invalidConversion((Converter)converter, "11.05 pm");
        this.invalidConversion((Converter)converter, new Integer(2));
        converter.setLocale(Locale.UK);
        this.invalidConversion((Converter)converter, "3:06 pm");
        this.validConversion((Converter)converter, expected, "15:06");
        Locale.setDefault(defaultLocale);
    }

    @Override
    public void testDefaultStringToTypeConvert() {
        DateTimeConverter converter = this.makeConverter();
        converter.setUseLocaleFormat(false);
        String testString = "15:36:21";
        Object expected = this.toType("15:36:21", "HH:mm:ss", null);
        this.validConversion((Converter)converter, expected, "15:36:21");
        this.invalidConversion((Converter)converter, "15:36");
    }

    @Override
    protected DateTimeConverter makeConverter() {
        return new SqlTimeConverter();
    }

    @Override
    protected DateTimeConverter makeConverter(Object defaultValue) {
        return new SqlTimeConverter(defaultValue);
    }

    @Override
    protected Class<?> getExpectedType() {
        return Time.class;
    }

    @Override
    protected Object toType(Calendar value) {
        return new Time(this.getTimeInMillis(value));
    }
}

