/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import java.math.BigDecimal;
import java.util.Iterator;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaProperty;
import org.apache.commons.beanutils.ResultSetDynaClass;
import org.apache.commons.beanutils.TestResultSet;

public class DynaResultSetTestCase
extends TestCase {
    protected ResultSetDynaClass dynaClass = null;
    protected String[] columns = new String[]{"bigdecimalproperty", "booleanproperty", "byteproperty", "dateproperty", "doubleproperty", "floatproperty", "intproperty", "longproperty", "nullproperty", "shortproperty", "stringproperty", "timeproperty", "timestampproperty"};

    public DynaResultSetTestCase(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        this.dynaClass = new ResultSetDynaClass(TestResultSet.createProxy());
    }

    public static Test suite() {
        return new TestSuite(DynaResultSetTestCase.class);
    }

    public void tearDown() {
        this.dynaClass = null;
    }

    public void testGetName() {
        DynaResultSetTestCase.assertEquals((String)"DynaClass name", (String)"org.apache.commons.beanutils.ResultSetDynaClass", (String)this.dynaClass.getName());
    }

    public void testGetDynaProperty() {
        try {
            this.dynaClass.getDynaProperty(null);
            DynaResultSetTestCase.fail((String)"Did not throw IllegaArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        DynaProperty dynaProp = this.dynaClass.getDynaProperty("unknownProperty");
        DynaResultSetTestCase.assertTrue((String)"unknown property returns null", (dynaProp == null ? 1 : 0) != 0);
        dynaProp = this.dynaClass.getDynaProperty("stringproperty");
        DynaResultSetTestCase.assertNotNull((String)"string property exists", (Object)dynaProp);
        DynaResultSetTestCase.assertEquals((String)"string property name", (String)"stringproperty", (String)dynaProp.getName());
        DynaResultSetTestCase.assertEquals((String)"string property class", String.class, (Object)dynaProp.getType());
    }

    public void testGetDynaProperties() {
        DynaProperty[] dynaProps = this.dynaClass.getDynaProperties();
        DynaResultSetTestCase.assertNotNull((String)"dynaProps exists", (Object)dynaProps);
        DynaResultSetTestCase.assertEquals((String)"dynaProps length", (int)this.columns.length, (int)dynaProps.length);
        for (int i = 0; i < this.columns.length; ++i) {
            DynaResultSetTestCase.assertEquals((String)("Property " + this.columns[i]), (String)this.columns[i], (String)dynaProps[i].getName());
        }
    }

    public void testNewInstance() {
        try {
            this.dynaClass.newInstance();
            DynaResultSetTestCase.fail((String)"Did not throw UnsupportedOperationException()");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
        }
        catch (Exception e) {
            DynaResultSetTestCase.fail((String)("Threw exception " + e));
        }
    }

    public void testIteratorCount() {
        Iterator rows = this.dynaClass.iterator();
        DynaResultSetTestCase.assertNotNull((String)"iterator exists", (Object)rows);
        int n = 0;
        while (rows.hasNext()) {
            rows.next();
            if (++n <= 10) continue;
            DynaResultSetTestCase.fail((String)"Returned too many rows");
        }
        DynaResultSetTestCase.assertEquals((String)"iterator rows", (int)5, (int)n);
    }

    public void testIteratorResults() {
        Iterator rows = this.dynaClass.iterator();
        rows.next();
        rows.next();
        DynaBean row = (DynaBean)rows.next();
        try {
            row.get("unknownProperty");
            DynaResultSetTestCase.fail((String)"Did not throw IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Object bigDecimalProperty = row.get("bigdecimalproperty");
        DynaResultSetTestCase.assertNotNull((String)"bigDecimalProperty exists", (Object)bigDecimalProperty);
        DynaResultSetTestCase.assertTrue((String)"bigDecimalProperty type", (boolean)(bigDecimalProperty instanceof BigDecimal));
        DynaResultSetTestCase.assertEquals((String)"bigDecimalProperty value", (double)123.45, (double)((BigDecimal)bigDecimalProperty).doubleValue(), (double)0.005);
        Object intProperty = row.get("intproperty");
        DynaResultSetTestCase.assertNotNull((String)"intProperty exists", (Object)intProperty);
        DynaResultSetTestCase.assertTrue((String)"intProperty type", (boolean)(intProperty instanceof Integer));
        DynaResultSetTestCase.assertEquals((String)"intProperty value", (int)103, (int)((Integer)intProperty));
        Object nullProperty = row.get("nullproperty");
        DynaResultSetTestCase.assertNull((String)"nullProperty null", (Object)nullProperty);
        Object stringProperty = row.get("stringproperty");
        DynaResultSetTestCase.assertNotNull((String)"stringProperty exists", (Object)stringProperty);
        DynaResultSetTestCase.assertTrue((String)"stringProperty type", (boolean)(stringProperty instanceof String));
        DynaResultSetTestCase.assertEquals((String)"stringProperty value", (String)"This is a string", (String)((String)stringProperty));
    }

    public void testIteratorResultsNormalCase() {
        ResultSetDynaClass dynaClass = null;
        try {
            dynaClass = new ResultSetDynaClass(TestResultSet.createProxy(), false);
        }
        catch (Exception e) {
            DynaResultSetTestCase.fail((String)("Error creating ResultSetDynaClass: " + e));
        }
        Iterator rows = dynaClass.iterator();
        rows.next();
        rows.next();
        DynaBean row = (DynaBean)rows.next();
        try {
            row.get("unknownProperty");
            DynaResultSetTestCase.fail((String)"Did not throw IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Object bigDecimalProperty = row.get("bigDecimalProperty");
        DynaResultSetTestCase.assertNotNull((String)"bigDecimalProperty exists", (Object)bigDecimalProperty);
        DynaResultSetTestCase.assertTrue((String)"bigDecimalProperty type", (boolean)(bigDecimalProperty instanceof BigDecimal));
        DynaResultSetTestCase.assertEquals((String)"bigDecimalProperty value", (double)123.45, (double)((BigDecimal)bigDecimalProperty).doubleValue(), (double)0.005);
        Object intProperty = row.get("intProperty");
        DynaResultSetTestCase.assertNotNull((String)"intProperty exists", (Object)intProperty);
        DynaResultSetTestCase.assertTrue((String)"intProperty type", (boolean)(intProperty instanceof Integer));
        DynaResultSetTestCase.assertEquals((String)"intProperty value", (int)103, (int)((Integer)intProperty));
        Object nullProperty = row.get("nullProperty");
        DynaResultSetTestCase.assertNull((String)"nullProperty null", (Object)nullProperty);
        Object stringProperty = row.get("stringProperty");
        DynaResultSetTestCase.assertNotNull((String)"stringProperty exists", (Object)stringProperty);
        DynaResultSetTestCase.assertTrue((String)"stringProperty type", (boolean)(stringProperty instanceof String));
        DynaResultSetTestCase.assertEquals((String)"stringProperty value", (String)"This is a string", (String)((String)stringProperty));
    }
}

