/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils.converters;

import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.converters.CharacterConverter;

public class CharacterConverterTestCase
extends TestCase {
    public static TestSuite suite() {
        return new TestSuite(CharacterConverterTestCase.class);
    }

    public CharacterConverterTestCase(String name) {
        super(name);
    }

    public void setUp() throws Exception {
    }

    public void tearDown() throws Exception {
    }

    public void testConvertToChar() {
        CharacterConverter converter = new CharacterConverter();
        CharacterConverterTestCase.assertEquals((String)"Wrong result", (Object)Character.valueOf('F'), (Object)converter.convert(Character.TYPE, (Object)"FOO"));
    }

    public void testConvertToCharacter() {
        CharacterConverter converter = new CharacterConverter();
        CharacterConverterTestCase.assertEquals((String)"Character Test", (Object)Character.valueOf('N'), (Object)converter.convert(Character.class, (Object)Character.valueOf('N')));
        CharacterConverterTestCase.assertEquals((String)"String Test", (Object)Character.valueOf('F'), (Object)converter.convert(Character.class, (Object)"FOO"));
        CharacterConverterTestCase.assertEquals((String)"Integer Test", (Object)Character.valueOf('3'), (Object)converter.convert(Character.class, (Object)321));
    }

    public void testConvertToCharacterNullNoDefault() {
        CharacterConverter converter = new CharacterConverter();
        try {
            converter.convert(Character.class, null);
            CharacterConverterTestCase.fail((String)"Expected a ConversionException for null value");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testConvertToString() {
        CharacterConverter converter = new CharacterConverter();
        CharacterConverterTestCase.assertEquals((String)"Character Test", (String)"N", (String)((String)converter.convert(String.class, (Object)Character.valueOf('N'))));
        CharacterConverterTestCase.assertEquals((String)"String Test", (String)"F", (String)((String)converter.convert(String.class, (Object)"FOO")));
        CharacterConverterTestCase.assertEquals((String)"Integer Test", (String)"3", (String)((String)converter.convert(String.class, (Object)321)));
        CharacterConverterTestCase.assertEquals((String)"Null Test", null, (String)((String)converter.convert(String.class, null)));
    }

    public void testConvertToUnsupportedType() {
        CharacterConverter converter = new CharacterConverter();
        try {
            converter.convert(Integer.class, (Object)"Test");
            CharacterConverterTestCase.fail((String)"Could convert to unsupported type!");
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
    }

    public void testDefault() {
        CharacterConverter converter = new CharacterConverter((Object)"C");
        CharacterConverterTestCase.assertEquals((String)"Default Test", (Object)Character.valueOf('C'), (Object)converter.convert(Character.class, null));
    }
}

