// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.
package org.apache.cloudstack.api;

public class ApiConstants {
    public static final String ACCOUNT = "account";
    public static final String ACCOUNTS = "accounts";
    public static final String ACCOUNT_TYPE = "accounttype";
    public static final String ACCOUNT_ID = "accountid";
    public static final String ACCOUNT_IDS = "accountids";
    public static final String ACCUMULATE = "accumulate";
    public static final String ACTIVATION_RULE = "activationrule";
    public static final String ACTIVITY = "activity";
    public static final String ADAPTER_TYPE = "adaptertype";
    public static final String ADDRESS = "address";
    public static final String ALGORITHM = "algorithm";
    public static final String ALIAS = "alias";
    public static final String ALLOCATED_ONLY = "allocatedonly";
    public static final String ANNOTATION = "annotation";
    public static final String API_KEY = "apikey";
    public static final String ARCHIVED = "archived";
    public static final String ASYNC_BACKUP = "asyncbackup";
    public static final String AUTO_SELECT = "autoselect";
    public static final String USER_API_KEY = "userapikey";
    public static final String APPLIED = "applied";
    public static final String LIST_LB_VMIPS = "lbvmips";
    public static final String LIVE_PATCH = "livepatch";
    public static final String AVAILABLE = "available";
    public static final String AVAILABLE_SUBNETS = "availablesubnets";
    public static final String AVAILABLE_VIRTUAL_MACHINE_COUNT = "availablevirtualmachinecount";
    public static final String BACKUP_ID = "backupid";
    public static final String BACKUP_OFFERING_NAME = "backupofferingname";
    public static final String BACKUP_OFFERING_ID = "backupofferingid";
    public static final String BASE64_IMAGE = "base64image";
    public static final String BITS = "bits";
    public static final String BOOTABLE = "bootable";
    public static final String BIND_DN = "binddn";
    public static final String BIND_PASSWORD = "bindpass";
    public static final String BYTES_READ_RATE = "bytesreadrate";
    public static final String BYTES_READ_RATE_MAX = "bytesreadratemax";
    public static final String BYTES_READ_RATE_MAX_LENGTH = "bytesreadratemaxlength";
    public static final String BYTES_WRITE_RATE = "byteswriterate";
    public static final String BYTES_WRITE_RATE_MAX = "byteswriteratemax";
    public static final String BYTES_WRITE_RATE_MAX_LENGTH = "byteswriteratemaxlength";
    public static final String BYPASS_VLAN_OVERLAP_CHECK = "bypassvlanoverlapcheck";
    public static final String CAPACITY = "capacity";
    public static final String CATEGORY = "category";
    public static final String CAN_REVERT = "canrevert";
    public static final String CA_CERTIFICATES = "cacertificates";
    public static final String CERTIFICATE = "certificate";
    public static final String CERTIFICATE_CHAIN = "certchain";
    public static final String CERTIFICATE_FINGERPRINT = "fingerprint";
    public static final String CERTIFICATE_ID = "certid";
    public static final String CERTIFICATE_ISSUER = "issuer";
    public static final String CERTIFICATE_SERIALNUM = "serialnum";
    public static final String CERTIFICATE_SUBJECT = "subject";
    public static final String CERTIFICATE_VALIDITY = "validity";
    public static final String CONVERT_INSTANCE_HOST_ID = "convertinstancehostid";
    public static final String CONVERT_INSTANCE_STORAGE_POOL_ID = "convertinstancepoolid";
    public static final String ENABLED_REVOCATION_CHECK = "enabledrevocationcheck";
    public static final String CONTROLLER = "controller";
    public static final String CONTROLLER_UNIT = "controllerunit";
    public static final String COPY_IMAGE_TAGS = "copyimagetags";
    public static final String CSR = "csr";
    public static final String PRIVATE_KEY = "privatekey";
    public static final String DATASTORE_HOST = "datastorehost";
    public static final String DATASTORE_ID = "datastoreid";
    public static final String DATASTORE_NAME = "datastorename";
    public static final String DATASTORE_PATH = "datastorepath";
    public static final String DATASTORE_STATE = "datastorestate";
    public static final String DATASTORE_TYPE = "datastoretype";
    public static final String DOMAIN_SUFFIX = "domainsuffix";
    public static final String DNS_SEARCH_ORDER = "dnssearchorder";
    public static final String CHAIN_INFO = "chaininfo";
    public static final String CIDR = "cidr";
    public static final String IP6_CIDR = "ip6cidr";
    public static final String CIDR_LIST = "cidrlist";
    public static final String DEST_CIDR_LIST = "destcidrlist";
    public static final String CLEANUP = "cleanup";
    public static final String MAKEREDUNDANT = "makeredundant";
    public static final String CLUSTER_ID = "clusterid";
    public static final String CLUSTER_IDS = "clusterids";
    public static final String CLUSTER_NAME = "clustername";
    public static final String CLUSTER_TYPE = "clustertype";
    public static final String CN = "cn";
    public static final String COMMAND = "command";
    public static final String CMD_EVENT_TYPE = "cmdeventtype";
    public static final String COMPONENT = "component";
    public static final String CPU_CORE_PER_SOCKET = "cpucorepersocket";
    public static final String CPU_NUMBER = "cpunumber";
    public static final String CPU_SPEED = "cpuspeed";
    public static final String CPU_LOAD_AVERAGE = "cpuloadaverage";
    public static final String CREATED = "created";
    public static final String CTX_ACCOUNT_ID = "ctxaccountid";
    public static final String CTX_DETAILS = "ctxDetails";
    public static final String CTX_USER_ID = "ctxuserid";
    public static final String CTXSTARTEVENTID = "ctxstarteventid";
    public static final String CTX_START_EVENT_ID = "ctxStartEventId";
    public static final String CUSTOMIZED = "customized";
    public static final String CUSTOMIZED_IOPS = "customizediops";
    public static final String CUSTOM_ID = "customid";
    public static final String CUSTOM_JOB_ID = "customjobid";
    public static final String CURRENT_START_IP = "currentstartip";
    public static final String CURRENT_END_IP = "currentendip";
    public static final String ENCRYPT = "encrypt";
    public static final String ENCRYPT_ROOT = "encryptroot";
    public static final String ENCRYPTION_SUPPORTED = "encryptionsupported";
    public static final String MIN_IOPS = "miniops";
    public static final String MAX_IOPS = "maxiops";
    public static final String HYPERVISOR_SNAPSHOT_RESERVE = "hypervisorsnapshotreserve";
    public static final String DATACENTER_NAME = "datacentername";
    public static final String DATADISK_OFFERING_LIST = "datadiskofferinglist";
    public static final String DEFAULT_VALUE = "defaultvalue";
    public static final String DESCRIPTION = "description";
    public static final String DESTINATION = "destination";
    public static final String DESTINATION_ZONE_ID = "destzoneid";
    public static final String DETAILS = "details";
    public static final String DEVICE_ID = "deviceid";
    public static final String DIRECT_DOWNLOAD = "directdownload";
    public static final String DISK = "disk";
    public static final String DISK_OFFERING_ID = "diskofferingid";
    public static final String NEW_DISK_OFFERING_ID = "newdiskofferingid";
    public static final String OVERRIDE_DISK_OFFERING_ID = "overridediskofferingid";
    public static final String DISK_KBS_READ = "diskkbsread";
    public static final String DISK_KBS_WRITE = "diskkbswrite";
    public static final String DISK_IO_READ = "diskioread";
    public static final String DISK_IO_WRITE = "diskiowrite";
    public static final String DISK_IO_PSTOTAL = "diskiopstotal";
    public static final String DISK_SIZE = "disksize";
    public static final String DISK_SIZE_STRICTNESS = "disksizestrictness";
    public static final String DISK_OFFERING_STRICTNESS = "diskofferingstrictness";
    public static final String DOWNLOAD_DETAILS = "downloaddetails";
    public static final String UTILIZATION = "utilization";
    public static final String DRIVER = "driver";
    public static final String ROOT_DISK_SIZE = "rootdisksize";
    public static final String DHCP_OPTIONS_NETWORK_LIST = "dhcpoptionsnetworklist";
    public static final String DHCP_OPTIONS = "dhcpoptions";
    public static final String DHCP_PREFIX = "dhcp:";
    public static final String DISPLAY_NAME = "displayname";
    public static final String DISPLAY_NETWORK = "displaynetwork";
    public static final String DISPLAY_NIC = "displaynic";
    public static final String DISPLAY_TEXT = "displaytext";
    public static final String DISPLAY_VM = "displayvm";
    public static final String DISPLAY_OFFERING = "displayoffering";
    public static final String DISPLAY_VOLUME = "displayvolume";
    public static final String DNS1 = "dns1";
    public static final String DNS2 = "dns2";
    public static final String IP6_DNS1 = "ip6dns1";
    public static final String IP6_DNS2 = "ip6dns2";
    public static final String DOMAIN = "domain";
    public static final String DOMAIN_DETAILS = "domaindetails";
    public static final String DOMAIN_PATH = "domainpath";
    public static final String DOMAIN_ID = "domainid";
    public static final String DOMAIN__ID = "domainId";
    public static final String DURATION = "duration";
    public static final String ELIGIBLE = "eligible";
    public static final String EMAIL = "email";
    public static final String END_DATE = "enddate";
    public static final String END_IP = "endip";
    public static final String END_IPV6 = "endipv6";
    public static final String END_PORT = "endport";
    public static final String ENTRY_TIME = "entrytime";
    public static final String EXPIRES = "expires";
    public static final String EXTRA_CONFIG = "extraconfig";
    public static final String EXTRA_DHCP_OPTION = "extradhcpoption";
    public static final String EXTRA_DHCP_OPTION_NAME = "extradhcpoptionname";
    public static final String EXTRA_DHCP_OPTION_CODE = "extradhcpoptioncode";
    public static final String EXTRA_DHCP_OPTION_VALUE = "extradhcpvalue";
    public static final String EXTERNAL = "external";
    public static final String EXTERNAL_UUID = "externaluuid";
    public static final String FENCE = "fence";
    public static final String FETCH_LATEST = "fetchlatest";
    public static final String FIRSTNAME = "firstname";
    public static final String FORCED = "forced";
    public static final String FORCED_DESTROY_LOCAL_STORAGE = "forcedestroylocalstorage";
    public static final String FORCE_DELETE_HOST = "forcedeletehost";
    public static final String FORMAT = "format";
    public static final String FOR_VIRTUAL_NETWORK = "forvirtualnetwork";
    public static final String FOR_SYSTEM_VMS = "forsystemvms";
    public static final String GATEWAY = "gateway";
    public static final String IP6_GATEWAY = "ip6gateway";
    public static final String GROUP = "group";
    public static final String SUBGROUP = "subgroup";
    public static final String GROUP_ID = "groupid";
    public static final String GSLB_LB_METHOD = "gslblbmethod";
    public static final String GSLB_SERVICE_DOMAIN_NAME = "gslbdomainname";
    public static final String GSLB_SERVICE_TYPE = "gslbservicetype";
    public static final String GSLB_STICKY_SESSION_METHOD = "gslbstickysessionmethodname";
    public static final String GSLB_LBRULE_WEIGHT_MAP = "gslblbruleweightsmap";
    public static final String GUEST_CIDR_ADDRESS = "guestcidraddress";
    public static final String GUEST_VLAN_RANGE = "guestvlanrange";
    public static final String HA_ENABLE = "haenable";
    public static final String HA_PROVIDER = "haprovider";
    public static final String HA_STATE = "hastate";
    public static final String HEALTH = "health";
    public static final String HIDE_IP_ADDRESS_USAGE = "hideipaddressusage";
    public static final String HOST_ID = "hostid";
    public static final String HOST_IDS = "hostids";
    public static final String HOST_IP = "hostip";
    public static final String HOST_NAME = "hostname";
    public static final String HOST = "host";
    public static final String HOST_CONTROL_STATE = "hostcontrolstate";
    public static final String HOSTS_MAP = "hostsmap";
    public static final String HYPERVISOR = "hypervisor";
    public static final String INLINE = "inline";
    public static final String INSTANCE = "instance";
    public static final String ICMP_CODE = "icmpcode";
    public static final String ICMP_TYPE = "icmptype";
    public static final String ID = "id";
    public static final String IDS = "ids";
    public static final String INDEX = "index";
    public static final String INSTANCES_DISKS_STATS_RETENTION_ENABLED = "instancesdisksstatsretentionenabled";
    public static final String INSTANCES_DISKS_STATS_RETENTION_TIME = "instancesdisksstatsretentiontime";
    public static final String INSTANCES_STATS_RETENTION_TIME = "instancesstatsretentiontime";
    public static final String INSTANCES_STATS_USER_ONLY = "instancesstatsuseronly";
    public static final String PREFIX = "prefix";
    public static final String PREVIOUS_ACL_RULE_ID = "previousaclruleid";
    public static final String PREVIOUS_OWNER_ID = "previousownerid";
    public static final String PREVIOUS_OWNER_NAME = "previousownername";
    public static final String NEXT_ACL_RULE_ID = "nextaclruleid";
    public static final String MOVE_ACL_CONSISTENCY_HASH = "aclconsistencyhash";
    public static final String IMAGE_PATH = "imagepath";
    public static final String INTERNAL_DNS1 = "internaldns1";
    public static final String INTERNAL_DNS2 = "internaldns2";
    public static final String INTERNET_PROTOCOL = "internetprotocol";
    public static final String INTERVAL_TYPE = "intervaltype";
    public static final String LOCATION_TYPE = "locationtype";
    public static final String IOPS_READ_RATE = "iopsreadrate";
    public static final String IOPS_READ_RATE_MAX = "iopsreadratemax";
    public static final String IOPS_READ_RATE_MAX_LENGTH = "iopsreadratemaxlength";
    public static final String IOPS_WRITE_RATE = "iopswriterate";
    public static final String IOPS_WRITE_RATE_MAX = "iopswriteratemax";
    public static final String IOPS_WRITE_RATE_MAX_LENGTH = "iopswriteratemaxlength";
    public static final String IP_ADDRESS = "ipaddress";
    public static final String IP_ADDRESSES = "ipaddresses";
    public static final String IP6_ADDRESS = "ip6address";
    public static final String IP_ADDRESS_ID = "ipaddressid";
    public static final String IS_2FA_ENABLED = "is2faenabled";
    public static final String IS_2FA_VERIFIED = "is2faverified";

    public static final String IS_2FA_MANDATED = "is2famandated";
    public static final String IS_ASYNC = "isasync";
    public static final String IP_AVAILABLE = "ipavailable";
    public static final String IP_LIMIT = "iplimit";
    public static final String IP_TOTAL = "iptotal";
    public static final String IS_CONTROL_NODE = "iscontrolnode";
    public static final String IS_CLEANUP_REQUIRED = "iscleanuprequired";
    public static final String IS_DYNAMIC = "isdynamic";
    public static final String IS_EDGE = "isedge";
    public static final String IS_EXTRACTABLE = "isextractable";
    public static final String IS_FEATURED = "isfeatured";
    public static final String IS_PORTABLE = "isportable";
    public static final String IS_PUBLIC = "ispublic";
    public static final String IS_PERSISTENT = "ispersistent";
    public static final String EGRESS_DEFAULT_POLICY = "egressdefaultpolicy";
    public static final String IS_READY = "isready";
    public static final String IS_RECURSIVE = "isrecursive";
    public static final String ISO_FILTER = "isofilter";
    public static final String ISO_ID = "isoid";
    public static final String ISO_GUEST_OS_NONE = "None";
    public static final String JAVA_DISTRIBUTION = "javadistribution";
    public static final String JAVA_VERSION = "javaversion";
    public static final String JOB_ID = "jobid";
    public static final String JOB_STATUS = "jobstatus";
    public static final String KEEPALIVE_ENABLED = "keepaliveenabled";
    public static final String KERNEL_VERSION = "kernelversion";
    public static final String LABEL = "label";
    public static final String LASTNAME = "lastname";
    public static final String LAST_BOOT = "lastboottime";
    public static final String LAST_SERVER_START = "lastserverstart";
    public static final String LAST_SERVER_STOP = "lastserverstop";
    public static final String LEVEL = "level";
    public static final String LENGTH = "length";
    public static final String LIMIT_CPU_USE = "limitcpuuse";
    public static final String LIST_HOSTS = "listhosts";
    public static final String LOCK = "lock";
    public static final String LUN = "lun";
    public static final String LBID = "lbruleid";
    public static final String LB_PROVIDER = "lbprovider";
    public static final String MAC_ADDRESS = "macaddress";
    public static final String MAX = "max";
    public static final String MAX_SNAPS = "maxsnaps";
    public static final String MAX_CPU_NUMBER = "maxcpunumber";
    public static final String MAX_MEMORY = "maxmemory";
    public static final String MIN_CPU_NUMBER = "mincpunumber";
    public static final String MIN_MEMORY = "minmemory";
    public static final String MIGRATION_TYPE = "migrationtype";
    public static final String MIGRATIONS = "migrations";
    public static final String MEMORY = "memory";
    public static final String MODE = "mode";
    public static final String NAME = "name";
    public static final String METHOD_NAME = "methodname";
    public static final String NETWORK_DOMAIN = "networkdomain";
    public static final String NETMASK = "netmask";
    public static final String NEW_NAME = "newname";
    public static final String NIC = "nic";
    public static final String NIC_NETWORK_LIST = "nicnetworklist";
    public static final String NIC_IP_ADDRESS_LIST = "nicipaddresslist";
    public static final String NIC_MULTIQUEUE_NUMBER = "nicmultiqueuenumber";
    public static final String NIC_PACKED_VIRTQUEUES_ENABLED = "nicpackedvirtqueuesenabled";
    public static final String NEW_START_IP = "newstartip";
    public static final String NEW_END_IP = "newendip";
    public static final String NUM_RETRIES = "numretries";
    public static final String OFFER_HA = "offerha";
    public static final String OS_DISTRIBUTION = "osdistribution";
    public static final String IS_SYSTEM_OFFERING = "issystem";
    public static final String IS_DEFAULT_USE = "defaultuse";
    public static final String OLD_FORMAT = "oldformat";
    public static final String OP = "op";
    public static final String OPTIONS = "options";
    public static final String OS_CATEGORY_ID = "oscategoryid";
    public static final String OS_CATEGORY_NAME = "oscategoryname";
    public static final String OS_NAME = "osname";
    public static final String OS_ID = "osid";
    public static final String OS_TYPE_ID = "ostypeid";
    public static final String OS_DISPLAY_NAME = "osdisplayname";
    public static final String OS_NAME_FOR_HYPERVISOR = "osnameforhypervisor";
    public static final String GUEST_OS_LIST = "guestoslist";
    public static final String GUEST_OS_COUNT = "guestoscount";
    public static final String OS_MAPPING_CHECK_ENABLED = "osmappingcheckenabled";
    public static final String OUTOFBANDMANAGEMENT_POWERSTATE = "outofbandmanagementpowerstate";
    public static final String OUTOFBANDMANAGEMENT_ENABLED = "outofbandmanagementenabled";
    public static final String OUTPUT = "output";
    public static final String PROPERTIES = "properties";
    public static final String PARAMS = "params";
    public static final String PARENT = "parent";
    public static final String PARENT_ID = "parentid";
    public static final String PARENT_DOMAIN_ID = "parentdomainid";
    public static final String PARENT_TEMPLATE_ID = "parenttemplateid";
    public static final String PASSWORD = "password";
    public static final String CURRENT_PASSWORD = "currentpassword";
    public static final String SHOULD_UPDATE_PASSWORD = "update_passwd_on_host";
    public static final String PASSWORD_ENABLED = "passwordenabled";
    public static final String SSHKEY_ENABLED = "sshkeyenabled";
    public static final String PATH = "path";
    public static final String PAYLOAD = "payload";
    public static final String POD_ID = "podid";
    public static final String POD_NAME = "podname";
    public static final String POD_IDS = "podids";
    public static final String POLICY_ID = "policyid";
    public static final String PORT = "port";
    public static final String PORTAL = "portal";
    public static final String PORTABLE_IP_ADDRESS = "portableipaddress";
    public static final String PORT_FORWARDING_SERVICE_ID = "portforwardingserviceid";
    public static final String POSITION = "position";
    public static final String POST_URL = "postURL";
    public static final String POWER_STATE = "powerstate";
    public static final String PRECEDENCE = "precedence";
    public static final String PRIVATE_INTERFACE = "privateinterface";
    public static final String PRIVATE_IP = "privateip";
    public static final String PRIVATE_PORT = "privateport";
    public static final String PRIVATE_START_PORT = "privateport";
    public static final String PRIVATE_END_PORT = "privateendport";
    public static final String PRIVATE_ZONE = "privatezone";
    public static final String PROTOCOL = "protocol";
    public static final String PROVISIONINGTYPE = "provisioningtype";
    public static final String PUBLIC_INTERFACE = "publicinterface";
    public static final String PUBLIC_IP_ID = "publicipid";
    public static final String PUBLIC_IP = "publicip";
    public static final String PUBLIC_PORT = "publicport";
    public static final String PUBLIC_START_PORT = "publicport";
    public static final String PUBLIC_END_PORT = "publicendport";
    public static final String PUBLIC_ZONE = "publiczone";
    public static final String RECEIVED_BYTES = "receivedbytes";
    public static final String RECONNECT = "reconnect";
    public static final String RECOVER = "recover";
    public static final String REQUIRES_HVM = "requireshvm";
    public static final String RESOURCE_NAME = "resourcename";
    public static final String RESOURCE_TYPE = "resourcetype";
    public static final String RESOURCE_TYPE_NAME = "resourcetypename";
    public static final String RESPONSE = "response";
    public static final String RETRIEVE_ONLY_RESOURCE_COUNT = "retrieveonlyresourcecount";
    public static final String REVERTABLE = "revertable";
    public static final String REVOKED = "revoked";
    public static final String REGISTERED = "registered";
    public static final String QUALIFIERS = "qualifiers";
    public static final String QUERY_FILTER = "queryfilter";
    public static final String SCHEDULE = "schedule";
    public static final String SCOPE = "scope";
    public static final String SECRET_KEY = "usersecretkey";
    public static final String SECONDARY_IP = "secondaryip";
    public static final String SINCE = "since";
    public static final String KEY = "key";
    public static final String SEARCH_BASE = "searchbase";
    public static final String SECURITY_GROUP_IDS = "securitygroupids";
    public static final String SECURITY_GROUP_NAMES = "securitygroupnames";
    public static final String SECURITY_GROUP_NAME = "securitygroupname";
    public static final String SECURITY_GROUP_ID = "securitygroupid";
    public static final String SENT = "sent";
    public static final String SENT_BYTES = "sentbytes";
    public static final String SERIAL = "serial";
    public static final String SERVICE_IP = "serviceip";
    public static final String SERVICE_OFFERING_ID = "serviceofferingid";
    public static final String SESSIONKEY = "sessionkey";
    public static final String SHOW_CAPACITIES = "showcapacities";
    public static final String SHOW_REMOVED = "showremoved";
    public static final String SHOW_RESOURCE_ICON = "showicon";
    public static final String SHOW_INACTIVE = "showinactive";
    public static final String SHOW_UNIQUE = "showunique";
    public static final String SIGNATURE = "signature";
    public static final String SIGNATURE_VERSION = "signatureversion";
    public static final String SIZE = "size";
    public static final String SNAPSHOT = "snapshot";
    public static final String SNAPSHOT_ID = "snapshotid";
    public static final String SNAPSHOT_POLICY_ID = "snapshotpolicyid";
    public static final String SNAPSHOT_TYPE = "snapshottype";
    public static final String SNAPSHOT_QUIESCEVM = "quiescevm";
    public static final String SUPPORTS_STORAGE_SNAPSHOT = "supportsstoragesnapshot";
    public static final String SOURCE_ZONE_ID = "sourcezoneid";
    public static final String START_DATE = "startdate";
    public static final String START_ID = "startid";
    public static final String START_IP = "startip";
    public static final String START_IPV6 = "startipv6";
    public static final String START_PORT = "startport";
    public static final String STATE = "state";
    public static final String STATS = "stats";
    public static final String STATUS = "status";
    public static final String STORAGE_TYPE = "storagetype";
    public static final String STORAGE_POLICY = "storagepolicy";
    public static final String STORAGE_MOTION_ENABLED = "storagemotionenabled";
    public static final String STORAGE_CAPABILITIES = "storagecapabilities";
    public static final String SUBNET = "subnet";
    public static final String OWNER = "owner";
    public static final String SWAP_OWNER = "swapowner";
    public static final String SYSTEM_VM_TYPE = "systemvmtype";
    public static final String TAGS = "tags";
    public static final String STORAGE_TAGS = "storagetags";
    public static final String TARGET_IQN = "targetiqn";
    public static final String TEMPLATE_FILTER = "templatefilter";
    public static final String TEMPLATE_ID = "templateid";
    public static final String TEMPLATE_IDS = "templateids";
    public static final String TEMPLATE_NAME = "templatename";
    public static final String TEMPLATE_TYPE = "templatetype";
    public static final String TIMEOUT = "timeout";
    public static final String TIMEZONE = "timezone";
    public static final String TIMEZONEOFFSET = "timezoneoffset";
    public static final String TOTAL_SUBNETS = "totalsubnets";
    public static final String TYPE = "type";
    public static final String TRUST_STORE = "truststore";
    public static final String TRUST_STORE_PASSWORD = "truststorepass";
    public static final String URL = "url";
    public static final String USAGE_INTERFACE = "usageinterface";
    public static final String USED_SUBNETS = "usedsubnets";
    public static final String USER_DATA = "userdata";

    public static final String USER_DATA_NAME = "userdataname";
    public static final String USER_DATA_ID = "userdataid";
    public static final String USER_DATA_POLICY = "userdatapolicy";
    public static final String USER_DATA_DETAILS = "userdatadetails";
    public static final String USER_DATA_PARAMS = "userdataparams";
    public static final String USER_FILTER = "userfilter";
    public static final String USER_ID = "userid";
    public static final String USER_SOURCE = "usersource";
    public static final String USER_CONFLICT_SOURCE = "conflictingusersource";
    public static final String USE_SSL = "ssl";
    public static final String USERNAME = "username";
    public static final String USER_CONFIGURABLE = "userconfigurable";
    public static final String USER_SECURITY_GROUP_LIST = "usersecuritygrouplist";
    public static final String USE_VIRTUAL_NETWORK = "usevirtualnetwork";
    public static final String UPDATE_IN_SEQUENCE = "updateinsequence";
    public static final String VALUE = "value";
    public static final String VIRTUAL_MACHINE_ID = "virtualmachineid";
    public static final String VIRTUAL_MACHINE_IDS = "virtualmachineids";
    public static final String VIRTUAL_MACHINE_NAME = "virtualmachinename";
    public static final String VIRTUAL_MACHINE_ID_IP = "vmidipmap";
    public static final String VIRTUAL_MACHINE_COUNT = "virtualmachinecount";
    public static final String VIRTUAL_MACHINE_TYPE = "virtualmachinetype";
    public static final String VIRTUAL_MACHINES = "virtualmachines";
    public static final String USAGE_ID = "usageid";
    public static final String USAGE_TYPE = "usagetype";
    public static final String INCLUDE_TAGS = "includetags";

    public static final String VLAN = "vlan";
    public static final String VLAN_RANGE = "vlanrange";
    public static final String REMOVE_VLAN = "removevlan";
    public static final String VLAN_ID = "vlanid";
    public static final String ISOLATED_PVLAN = "isolatedpvlan";
    public static final String ISOLATED_PVLAN_TYPE = "isolatedpvlantype";
    public static final String ISOLATION_URI = "isolationuri";
    public static final String IS_DEDICATED = "isdedicated";
    public static final String TAKEN = "taken";
    public static final String VM_AVAILABLE = "vmavailable";
    public static final String VM_LIMIT = "vmlimit";
    public static final String VM_TOTAL = "vmtotal";
    public static final String VM_TYPE = "vmtype";
    public static final String VNET = "vnet";
    public static final String IS_VOLATILE = "isvolatile";
    public static final String VOLUME_ID = "volumeid";
    public static final String VOLUMES = "volumes";
    public static final String ZONE = "zone";
    public static final String ZONE_ID = "zoneid";
    public static final String ZONE_NAME = "zonename";
    public static final String ZONE_WISE = "zonewise";
    public static final String NETWORK_TYPE = "networktype";
    public static final String PAGE = "page";
    public static final String PAGE_SIZE = "pagesize";
    public static final String COUNT = "count";
    public static final String TRAFFIC_TYPE = "traffictype";
    public static final String NETWORK_OFFERING_ID = "networkofferingid";
    public static final String TIER_NETWORK_OFFERINGS = "tiernetworkofferings";
    public static final String NETWORK_IDS = "networkids";
    public static final String NETWORK_ID = "networkid";
    public static final String NETWORK_FILTER = "networkfilter";
    public static final String NIC_ID = "nicid";
    public static final String SPECIFY_VLAN = "specifyvlan";
    public static final String IS_DEFAULT = "isdefault";
    public static final String IS_SYSTEM = "issystem";
    public static final String IS_USER_DEFINED = "isuserdefined";
    public static final String AVAILABILITY = "availability";
    public static final String NETWORKRATE = "networkrate";
    public static final String HOST_TAGS = "hosttags";
    public static final String SSH_KEYPAIR = "keypair";
    public static final String SSH_KEYPAIRS = "keypairs";
    public static final String HTTPMETHOD = "httpmethod";
    public static final String HOST_CPU_CAPACITY = "hostcpucapacity";
    public static final String HOST_CPU_NUM = "hostcpunum";
    public static final String HOST_MEM_CAPACITY = "hostmemcapacity";
    public static final String HOST_MAC = "hostmac";
    public static final String HOST_TAG = "hosttag";
    public static final String PXE_SERVER_TYPE = "pxeservertype";
    public static final String LINMIN_USERNAME = "linminusername";
    public static final String LINMIN_PASSWORD = "linminpassword";
    public static final String LINMIN_APID = "linminapid";
    public static final String DHCP_SERVER_TYPE = "dhcpservertype";
    public static final String LINK_LOCAL_IP = "linklocalip";
    public static final String LINK_LOCAL_MAC_ADDRESS = "linklocalmacaddress";
    public static final String LINK_LOCAL_MAC_NETMASK = "linklocalnetmask";
    public static final String LINK_LOCAL_NETWORK_ID = "linklocalnetworkid";
    public static final String PRIVATE_MAC_ADDRESS = "privatemacaddress";
    public static final String PRIVATE_NETMASK = "privatenetmask";
    public static final String PRIVATE_NETWORK_ID = "privatenetworkid";
    public static final String ALLOCATION_STATE = "allocationstate";
    public static final String MANAGED_STATE = "managedstate";
    public static final String MANAGEMENT_SERVER_ID = "managementserverid";
    public static final String STORAGE_ID = "storageid";
    public static final String PING_STORAGE_SERVER_IP = "pingstorageserverip";
    public static final String PING_DIR = "pingdir";
    public static final String TFTP_DIR = "tftpdir";
    public static final String PING_CIFS_USERNAME = "pingcifsusername";
    public static final String PING_CIFS_PASSWORD = "pingcifspassword";
    public static final String CHECKSUM = "checksum";
    public static final String NETWORK_DEVICE_TYPE = "networkdevicetype";
    public static final String NETWORK_DEVICE_PARAMETER_LIST = "networkdeviceparameterlist";
    public static final String ZONE_TOKEN = "zonetoken";
    public static final String DHCP_PROVIDER = "dhcpprovider";
    public static final String RESULT = "success";
    public static final String RESUME = "resume";
    public static final String LUN_ID = "lunId";
    public static final String IQN = "iqn";
    public static final String AGGREGATE_NAME = "aggregatename";
    public static final String POOL_NAME = "poolname";
    public static final String VOLUME_NAME = "volumename";
    public static final String SNAPSHOT_POLICY = "snapshotpolicy";
    public static final String SNAPSHOT_RESERVATION = "snapshotreservation";
    public static final String IP_NETWORK_LIST = "iptonetworklist";
    public static final String PARAM_LIST = "param";
    public static final String FOR_LOAD_BALANCING = "forloadbalancing";
    public static final String KEYBOARD = "keyboard";
    public static final String OPEN_FIREWALL = "openfirewall";
    public static final String TEMPLATE_TAG = "templatetag";
    public static final String HYPERVISOR_VERSION = "hypervisorversion";
    public static final String MAX_GUESTS_LIMIT = "maxguestslimit";
    public static final String MAX_DATA_VOLUMES_LIMIT = "maxdatavolumeslimit";
    public static final String MAX_HOSTS_PER_CLUSTER = "maxhostspercluster";
    public static final String PROJECT_ID = "projectid";
    public static final String PROJECT_IDS = "projectids";
    public static final String PROJECT = "project";
    public static final String ROLE = "role";
    public static final String ROLE_ID = "roleid";
    public static final String PROJECT_ROLE_ID = "projectroleid";
    public static final String PROJECT_ROLE_NAME = "projectrolename";
    public static final String ROLE_TYPE = "roletype";
    public static final String ROLE_NAME = "rolename";
    public static final String PERMISSION = "permission";
    public static final String RULE = "rule";
    public static final String RULES = "rules";
    public static final String RULE_ID = "ruleid";
    public static final String PROJECT_ROLE_PERMISSION_ID = "projectrolepermissionid";
    public static final String RULE_ORDER = "ruleorder";
    public static final String USER = "user";
    public static final String ACTIVE_ONLY = "activeonly";
    public static final String TOKEN = "token";
    public static final String ACCEPT = "accept";
    public static final String SORT_KEY = "sortkey";
    public static final String ACCOUNT_DETAILS = "accountdetails";
    public static final String SERVICE_OFFERING_DETAILS = "serviceofferingdetails";
    public static final String SERVICE_PROVIDER_LIST = "serviceproviderlist";
    public static final String SERVICE_CAPABILITY_LIST = "servicecapabilitylist";
    public static final String CAN_CHOOSE_SERVICE_CAPABILITY = "canchooseservicecapability";
    public static final String PROVIDER = "provider";
    public static final String OAUTH_PROVIDER = "oauthprovider";
    public static final String OAUTH_SECRET_KEY = "secretkey";
    public static final String MANAGED = "managed";
    public static final String CAPACITY_BYTES = "capacitybytes";
    public static final String CAPACITY_IOPS = "capacityiops";
    public static final String NETWORK_SPEED = "networkspeed";
    public static final String BROADCAST_DOMAIN_RANGE = "broadcastdomainrange";
    public static final String BROADCAST_URI = "broadcasturi";
    public static final String ISOLATION_METHOD = "isolationmethod";
    public static final String ISOLATION_METHODS = "isolationmethods";
    public static final String PHYSICAL_NETWORK_ID = "physicalnetworkid";
    public static final String PHYSICAL_NETWORK_NAME = "physicalnetworkname";
    public static final String DEST_PHYSICAL_NETWORK_ID = "destinationphysicalnetworkid";
    public static final String ENABLE = "enable";
    public static final String ENABLED = "enabled";
    public static final String SERVICE_NAME = "servicename";
    public static final String DHCP_RANGE = "dhcprange";
    public static final String UUID = "uuid";
    public static final String SECURITY_GROUP_EANBLED = "securitygroupenabled";
    public static final String LOCAL_STORAGE_ENABLED = "localstorageenabled";
    public static final String GUEST_IP_TYPE = "guestiptype";
    public static final String GUEST_IP6_PREFIX = "guestip6prefix";
    public static final String XENSERVER_NETWORK_LABEL = "xennetworklabel";
    public static final String KVM_NETWORK_LABEL = "kvmnetworklabel";
    public static final String VMWARE_NETWORK_LABEL = "vmwarenetworklabel";
    public static final String HYPERV_NETWORK_LABEL = "hypervnetworklabel";
    public static final String OVM3_NETWORK_LABEL = "ovm3networklabel";
    public static final String NETWORK_SERVICE_PROVIDER_ID = "nspid";
    public static final String SERVICE_LIST = "servicelist";
    public static final String CAN_ENABLE_INDIVIDUAL_SERVICE = "canenableindividualservice";
    public static final String SUPPORTED_SERVICES = "supportedservices";
    public static final String NSP_ID = "nspid";
    public static final String ACL_TYPE = "acltype";
    public static final String ACL_REASON = "reason";
    public static final String ACL_RULE_PARTIAL_UPGRADE = "partialupgrade";
    public static final String SUBDOMAIN_ACCESS = "subdomainaccess";
    public static final String LOAD_BALANCER_DEVICE_ID = "lbdeviceid";
    public static final String LOAD_BALANCER_DEVICE_NAME = "lbdevicename";
    public static final String LOAD_BALANCER_DEVICE_STATE = "lbdevicestate";
    public static final String LOAD_BALANCER_DEVICE_CAPACITY = "lbdevicecapacity";
    public static final String LOAD_BALANCER_DEVICE_DEDICATED = "lbdevicededicated";
    public static final String LOAD_BALANCER_RULE = "loadbalancerrule";
    public static final String LOAD_BALANCER_RULE_LIST = "loadbalancerrulelist";
    public static final String FIREWALL_DEVICE_ID = "fwdeviceid";
    public static final String FIREWALL_DEVICE_NAME = "fwdevicename";
    public static final String FIREWALL_DEVICE_STATE = "fwdevicestate";
    public static final String FIREWALL_DEVICE_CAPACITY = "fwdevicecapacity";
    public static final String FIREWALL_DEVICE_DEDICATED = "fwdevicededicated";
    public static final String SERVICE = "service";
    public static final String ASSOCIATED_NETWORK = "associatednetwork";
    public static final String ASSOCIATED_NETWORK_ID = "associatednetworkid";
    public static final String ASSOCIATED_NETWORK_NAME = "associatednetworkname";
    public static final String SOURCE_NAT_SUPPORTED = "sourcenatsupported";
    public static final String RESOURCE_STATE = "resourcestate";
    public static final String PROJECT_INVITE_REQUIRED = "projectinviterequired";
    public static final String REQUIRED = "required";
    public static final String RESTART_REQUIRED = "restartrequired";
    public static final String ALLOW_USER_CREATE_PROJECTS = "allowusercreateprojects";
    public static final String ALLOW_USER_DRIVEN_BACKUPS = "allowuserdrivenbackups";
    public static final String ALLOW_USER_SPECIFY_VR_MTU = "allowuserspecifyvrmtu";
    public static final String CONSERVE_MODE = "conservemode";
    public static final String TRAFFIC_TYPE_IMPLEMENTOR = "traffictypeimplementor";
    public static final String KEYWORD = "keyword";
    public static final String LIST_ALL = "listall";
    public static final String LIST_SYSTEM_VMS = "listsystemvms";
    public static final String IP_RANGES = "ipranges";
    public static final String IPV6_ROUTING = "ip6routing";
    public static final String IPV6_ROUTES = "ip6routes";
    public static final String SPECIFY_IP_RANGES = "specifyipranges";
    public static final String IS_SOURCE_NAT = "issourcenat";
    public static final String IS_STATIC_NAT = "isstaticnat";
    public static final String ITERATIONS = "iterations";
    public static final String SORT_BY = "sortby";
    public static final String CHANGE_CIDR = "changecidr";
    public static final String PURPOSE = "purpose";
    public static final String IS_TAGGED = "istagged";
    public static final String INSTANCE_NAME = "instancename";
    public static final String CONSIDER_LAST_HOST = "considerlasthost";
    public static final String START_VM = "startvm";
    public static final String HA_HOST = "hahost";
    public static final String CUSTOM_DISK_OFF_MIN_SIZE = "customdiskofferingminsize";
    public static final String CUSTOM_DISK_OFF_MAX_SIZE = "customdiskofferingmaxsize";
    public static final String DEFAULT_ZONE_ID = "defaultzoneid";
    public static final String LIVE_MIGRATE = "livemigrate";
    public static final String MIGRATE_ALLOWED = "migrateallowed";
    public static final String MIGRATE_TO = "migrateto";
    public static final String AUTO_MIGRATE = "automigrate";
    public static final String GUID = "guid";
    public static final String VM_SNAPSHOT_ENABELD = "vmsnapshotenabled";
    public static final String VSWITCH_TYPE_GUEST_TRAFFIC = "guestvswitchtype";
    public static final String VSWITCH_TYPE_PUBLIC_TRAFFIC = "publicvswitchtype";
    public static final String VSWITCH_NAME_GUEST_TRAFFIC = "guestvswitchname";
    public static final String VSWITCH_NAME_PUBLIC_TRAFFIC = "publicvswitchname";
    // Tungsten-Fabric
    public static final String TUNGSTEN_VIRTUAL_ROUTER_UUID = "tungstenvirtualrouteruuid";
    public static final String TUNGSTEN_PROVIDER_HOSTNAME = "tungstenproviderhostname";
    public static final String TUNGSTEN_PROVIDER_PORT = "tungstenproviderport";
    public static final String TUNGSTEN_PROVIDER_UUID = "tungstenprovideruuid";
    public static final String TUNGSTEN_GATEWAY = "tungstengateway";
    public static final String TUNGSTEN_PROVIDER_VROUTER_PORT = "tungstenprovidervrouterport";
    public static final String TUNGSTEN_PROVIDER_INTROSPECT_PORT = "tungstenproviderintrospectport";
    public static final String SRC_NETWORK = "srcnetwork";
    public static final String SRC_IP_PREFIX = "srcipprefix";
    public static final String SRC_IP_PREFIX_LEN = "srcipprefixlen";
    public static final String SRC_START_PORT = "srcstartport";
    public static final String SRC_END_PORT = "srcendport";
    public static final String DEST_NETWORK = "destnetwork";
    public static final String DEST_IP_PREFIX = "destipprefix";
    public static final String DEST_IP_PREFIX_LEN = "destipprefixlen";
    public static final String DEST_START_PORT = "deststartport";
    public static final String DEST_END_PORT = "destendport";
    public static final String MAJOR_SEQUENCE = "majorsequence";
    public static final String MINOR_SEQUENCE = "minorsequence";
    public static final String POLICY_UUID = "policyuuid";
    public static final String RULE_UUID = "ruleuuid";
    public static final String DIRECTION = "direction";
    public static final String TAG_UUID = "taguuid";
    public static final String TAG_TYPE = "tagtype";
    public static final String TAG_VALUE = "tagvalue";
    public static final String TAG_TYPE_UUID = "tagtypeuuid";
    public static final String NETWORK_UUID = "networkuuid";
    public static final String NIC_UUID = "nicuuid";
    public static final String VM_UUID = "vmuuid";
    public static final String ONE_WAY = "oneway";
    public static final String POLICY = "policy";
    public static final String VM = "vm";
    public static final String FIREWALL_POLICY = "firewallpolicy";
    public static final String FIREWALL_RULE = "firewallrule";
    public static final String TAG = "tag";
    public static final String APPLICATION_POLICY_SET_UUID = "applicationpolicysetuuid";
    public static final String FIREWALL_POLICY_UUID = "firewallpolicyuuid";
    public static final String FIREWALL_RULE_UUID = "firewallruleuuid";
    public static final String ADDRESS_GROUP_UUID = "addressgroupuuid";
    public static final String SERVICE_GROUP_UUID = "servicegroupuuid";
    public static final String SEQUENCE = "sequence";
    public static final String SERVICE_GROUP = "servicegroup";
    public static final String SRC_ADDRESS_GROUP = "srcaddressgroup";
    public static final String DEST_ADDRESS_GROUP = "destaddressgroup";
    public static final String SRC_TAG = "srctag";
    public static final String DEST_TAG = "desttag";
    public static final String IP_PREFIX = "ipprefix";
    public static final String IP_PREFIX_LEN = "ipprefixlen";
    public static final String SRC_ADDRESS_GROUP_UUID = "srcaddressgroupuuid";
    public static final String DEST_ADDRESS_GROUP_UUID = "destaddressgroupuuid";
    public static final String SRC_TAG_UUID = "srctaguuid";
    public static final String DEST_TAG_UUID = "desttaguuid";
    public static final String SRC_NETWORK_UUID = "srcnetworkuuid";
    public static final String DEST_NETWORK_UUID = "destnetworkuuid";
    public static final String LOGICAL_ROUTER_UUID = "logicalrouteruuid";
    public static final String RETRY = "retry";
    public static final String HTTP_METHOD = "httpmethodtype";
    public static final String EXPECTED_CODE = "expectedcode";
    public static final String URL_PATH = "urlpath";

    // Ovs controller
    public static final String OVS_DEVICE_ID = "ovsdeviceid";
    public static final String OVS_DEVICE_NAME = "ovsdevicename";
    // OpenDaylight controller
    public static final String ODL_DEVICE_ID = "odldeviceid";
    public static final String ODL_DEVICE_NAME = "odldevicename";
    public static final String ODL_TRANSPORT_ZONE_UUID = "transportzoneuuid";
    public static final String ODL_GATEWAYSERVICE_UUID = "l3gatewayserviceuuid";

    public static final String EXTERNAL_SWITCH_MGMT_DEVICE_ID = "vsmdeviceid";
    public static final String EXTERNAL_SWITCH_MGMT_DEVICE_NAME = "vsmdevicename";
    public static final String EXTERNAL_SWITCH_MGMT_DEVICE_STATE = "vsmdevicestate";
    // Would we need to have a capacity field for Cisco N1KV VSM? Max hosts managed by it perhaps? May remove this
    // later.
    public static final String EXTERNAL_SWITCH_MGMT_DEVICE_CAPACITY = "vsmdevicecapacity";
    public static final String CISCO_NEXUS_VSM_NAME = "vsmname";
    public static final String VSM_USERNAME = "vsmusername";
    public static final String VSM_PASSWORD = "vsmpassword";
    public static final String VSM_IPADDRESS = "vsmipaddress";
    public static final String VSM_MGMT_VLAN_ID = "vsmmgmtvlanid";
    public static final String VSM_PKT_VLAN_ID = "vsmpktvlanid";
    public static final String VSM_CTRL_VLAN_ID = "vsmctrlvlanid";
    public static final String VSM_STORAGE_VLAN_ID = "vsmstoragevlanid";
    public static final String VSM_DOMAIN_ID = "vsmdomainid";
    public static final String VSM_CONFIG_MODE = "vsmconfigmode";
    public static final String VSM_CONFIG_STATE = "vsmconfigstate";
    public static final String VSM_DEVICE_STATE = "vsmdevicestate";
    public static final String VCENTER = "vcenter";
    public static final String EXISTING_VCENTER_ID = "existingvcenterid";
    public static final String ADD_VSM_FLAG = "addvsmflag";
    public static final String END_POINT = "endpoint";
    public static final String REGION_ID = "regionid";
    public static final String VPC_OFF_ID = "vpcofferingid";
    public static final String VPC_OFF_NAME = "vpcofferingname";
    public static final String NETWORK = "network";
    public static final String VPC_ID = "vpcid";
    public static final String VPC_NAME = "vpcname";
    public static final String GATEWAY_ID = "gatewayid";
    public static final String CAN_USE_FOR_DEPLOY = "canusefordeploy";
    public static final String RESOURCE_IDS = "resourceids";
    public static final String RESOURCE_ID = "resourceid";
    public static final String CUSTOMER = "customer";
    public static final String S2S_VPN_GATEWAY_ID = "s2svpngatewayid";
    public static final String S2S_CUSTOMER_GATEWAY_ID = "s2scustomergatewayid";
    public static final String IPSEC_PSK = "ipsecpsk";
    public static final String GUEST_IP = "guestip";
    public static final String REMOVED = "removed";
    public static final String REMOVER_ACCOUNT_ID = "removeraccountid";
    public static final String REMOVAL_REASON = "removalreason";
    public static final String COMPLETED = "completed";
    public static final String IKE_VERSION = "ikeversion";
    public static final String IKE_POLICY = "ikepolicy";
    public static final String ESP_POLICY = "esppolicy";
    public static final String IKE_LIFETIME = "ikelifetime";
    public static final String ESP_LIFETIME = "esplifetime";
    public static final String DPD = "dpd";
    public static final String FORCE_ENCAP = "forceencap";
    public static final String SPLIT_CONNECTIONS = "splitconnections";
    public static final String FOR_VPC = "forvpc";
    public static final String FOR_TUNGSTEN = "fortungsten";
    public static final String SHRINK_OK = "shrinkok";
    public static final String NICIRA_NVP_DEVICE_ID = "nvpdeviceid";
    public static final String NICIRA_NVP_TRANSPORT_ZONE_UUID = "transportzoneuuid";
    public static final String NICIRA_NVP_DEVICE_NAME = "niciradevicename";
    public static final String NICIRA_NVP_GATEWAYSERVICE_UUID = "l3gatewayserviceuuid";
    public static final String NICIRA_NVP_L2_GATEWAYSERVICE_UUID = "l2gatewayserviceuuid";
    public static final String NSX_LOGICAL_SWITCH = "nsxlogicalswitch";
    public static final String NSX_LOGICAL_SWITCH_PORT = "nsxlogicalswitchport";
    public static final String S3_ACCESS_KEY = "accesskey";
    public static final String S3_SECRET_KEY = "secretkey";
    public static final String S3_END_POINT = "endpoint";
    public static final String S3_BUCKET_NAME = "bucket";
    public static final String S3_SIGNER = "s3signer";
    public static final String S3_V3_SIGNER = "S3SignerType";
    public static final String S3_V4_SIGNER = "AWSS3V4SignerType";
    public static final String S3_HTTPS_FLAG = "usehttps";
    public static final String S3_CONNECTION_TIMEOUT = "connectiontimeout";
    public static final String S3_CONNECTION_TTL = "connectionttl";
    public static final String S3_MAX_ERROR_RETRY = "maxerrorretry";
    public static final String S3_SOCKET_TIMEOUT = "sockettimeout";
    public static final String S3_USE_TCP_KEEPALIVE = "usetcpkeepalive";
    public static final String INCL_ZONES = "includezones";
    public static final String EXCL_ZONES = "excludezones";
    public static final String SOURCE = "source";
    public static final String COUNTER_ID = "counterid";
    public static final String AGGR_OPERATOR = "aggroperator";
    public static final String AGGR_FUNCTION = "aggrfunction";
    public static final String AGGR_VALUE = "aggrvalue";
    public static final String THRESHOLD = "threshold";
    public static final String RELATIONAL_OPERATOR = "relationaloperator";
    public static final String OTHER_DEPLOY_PARAMS = "otherdeployparams";
    public static final String MIN_MEMBERS = "minmembers";
    public static final String MAX_MEMBERS = "maxmembers";
    public static final String AUTOSCALE_EXPUNGE_VM_GRACE_PERIOD = "expungevmgraceperiod";
    public static final String VMPROFILE_ID = "vmprofileid";
    public static final String VMGROUP_ID = "vmgroupid";
    public static final String CS_URL = "csurl";
    public static final String IDP_ID = "idpid";
    public static final String SCALEUP_POLICY_IDS = "scaleuppolicyids";
    public static final String SCALEDOWN_POLICY_IDS = "scaledownpolicyids";
    public static final String SCALEUP_POLICIES = "scaleuppolicies";
    public static final String SCALEDOWN_POLICIES = "scaledownpolicies";
    public static final String INTERVAL = "interval";
    public static final String QUIETTIME = "quiettime";
    public static final String ACTION = "action";
    public static final String CONDITION_ID = "conditionid";
    public static final String CONDITION_IDS = "conditionids";
    public static final String COUNTERPARAM_LIST = "counterparam";
    public static final String AUTOSCALE_USER_ID = "autoscaleuserid";
    public static final String AUTOSCALE_VMGROUP_ID = "autoscalevmgroupid";
    public static final String AUTOSCALE_VMGROUP_NAME = "autoscalevmgroupname";
    public static final String BAREMETAL_DISCOVER_NAME = "baremetaldiscovername";
    public static final String BAREMETAL_RCT_URL = "baremetalrcturl";
    public static final String UCS_DN = "ucsdn";
    public static final String GSLB_PROVIDER = "gslbprovider";
    public static final String EXCLUSIVE_GSLB_PROVIDER = "isexclusivegslbprovider";
    public static final String GSLB_PROVIDER_PUBLIC_IP = "gslbproviderpublicip";
    public static final String GSLB_PROVIDER_PRIVATE_IP = "gslbproviderprivateip";
    public static final String VM_SNAPSHOT_DESCRIPTION = "description";
    public static final String VM_SNAPSHOT_DISPLAYNAME = "name";
    public static final String VM_SNAPSHOT_ID = "vmsnapshotid";
    public static final String VM_SNAPSHOT_IDS = "vmsnapshotids";
    public static final String VM_SNAPSHOT_DISK_IDS = "vmsnapshotdiskids";
    public static final String VM_SNAPSHOT_MEMORY = "snapshotmemory";
    public static final String VM_SNAPSHOT_QUIESCEVM = "quiescevm";
    public static final String IMAGE_STORE_UUID = "imagestoreuuid";
    public static final String IMAGE_STORE_ID = "imagestoreid";
    public static final String GUEST_VM_CIDR = "guestvmcidr";
    public static final String NETWORK_CIDR = "networkcidr";
    public static final String RESERVED_IP_RANGE = "reservediprange";
    public static final String UCS_MANAGER_ID = "ucsmanagerid";
    public static final String UCS_PROFILE_DN = "profiledn";
    public static final String UCS_BLADE_DN = "bladedn";
    public static final String UCS_BLADE_ID = "bladeid";
    public static final String VM_GUEST_IP = "vmguestip";
    public static final String HEALTHCHECK_FAILED = "healthchecksfailed";
    public static final String HEALTHCHECK_RESPONSE_TIMEOUT = "responsetimeout";
    public static final String HEALTHCHECK_INTERVAL_TIME = "intervaltime";
    public static final String HEALTHCHECK_HEALTHY_THRESHOLD = "healthythreshold";
    public static final String HEALTHCHECK_UNHEALTHY_THRESHOLD = "unhealthythreshold";
    public static final String HEALTHCHECK_PINGPATH = "pingpath";
    public static final String SOURCE_PORT = "sourceport";
    public static final String INSTANCE_PORT = "instanceport";
    public static final String SOURCE_IP = "sourceipaddress";
    public static final String SOURCE_IP_NETWORK_ID = "sourceipaddressnetworkid";
    public static final String SCHEME = "scheme";
    public static final String PROVIDER_TYPE = "providertype";
    public static final String AFFINITY_GROUP_IDS = "affinitygroupids";
    public static final String AFFINITY_GROUP_NAMES = "affinitygroupnames";
    public static final String ASA_INSIDE_PORT_PROFILE = "insideportprofile";
    public static final String AFFINITY_GROUP_ID = "affinitygroupid";
    public static final String DEPLOYMENT_PLANNER = "deploymentplanner";
    public static final String ACL_ID = "aclid";
    public static final String ACL_NAME = "aclname";
    public static final String NUMBER = "number";
    public static final String IS_DYNAMICALLY_SCALABLE = "isdynamicallyscalable";
    public static final String ROUTING = "isrouting";
    public static final String MAX_CONNECTIONS = "maxconnections";
    public static final String SERVICE_STATE = "servicestate";

    public static final String IAM_GROUPS = "groups";
    public static final String ENTITY_TYPE = "entitytype";
    public static final String ENTITY_ID = "entityid";
    public static final String ENTITY_NAME = "entityname";
    public static final String EXTERNAL_ID = "externalid";
    public static final String ACCESS_TYPE = "accesstype";

    public static final String RESOURCE_DETAILS = "resourcedetails";
    public static final String RESOURCE_ICON = "icon";
    public static final String EXPUNGE = "expunge";
    public static final String FOR_DISPLAY = "fordisplay";
    public static final String PASSIVE = "passive";
    public static final String VERSION = "version";
    public static final String START = "start";
    public static final String GPUGROUP = "gpugroup";
    public static final String GPUGROUPNAME = "gpugroupname";
    public static final String VGPU = "vgpu";
    public static final String VGPUTYPE = "vgputype";
    public static final String VIDEORAM = "videoram";
    public static final String MAXHEADS = "maxheads";
    public static final String MAXRESOLUTIONX = "maxresolutionx";
    public static final String MAXRESOLUTIONY = "maxresolutiony";
    public static final String MAXVGPUPERPGPU = "maxvgpuperpgpu";
    public static final String REMAININGCAPACITY = "remainingcapacity";
    public static final String MAXCAPACITY = "maxcapacity";
    public static final String DISTRIBUTED_VPC_ROUTER = "distributedvpcrouter";
    public static final String REDUNDANT_ROUTER = "redundantrouter";
    public static final String REDUNDANT_VPC_ROUTER = "redundantvpcrouter";
    public static final String READ_ONLY = "readonly";
    public static final String SUPPORTS_REGION_LEVEL_VPC = "supportsregionLevelvpc";
    public static final String SUPPORTS_STRECHED_L2_SUBNET = "supportsstrechedl2subnet";
    public static final String SUPPORTS_PUBLIC_ACCESS = "supportspublicaccess";
    public static final String SUPPORTS_VM_AUTOSCALING = "supportsvmautoscaling";
    public static final String REGION_LEVEL_VPC = "regionlevelvpc";
    public static final String STRECHED_L2_SUBNET = "strechedl2subnet";
    public static final String NETWORK_NAME = "networkname";
    public static final String NETWORK_SPANNED_ZONES = "zonesnetworkspans";
    public static final String METADATA = "metadata";
    public static final String PHYSICAL_SIZE = "physicalsize";
    public static final String OVM3_POOL = "ovm3pool";
    public static final String OVM3_CLUSTER = "ovm3cluster";
    public static final String OVM3_VIP = "ovm3vip";
    public static final String CLEAN_UP_DETAILS = "cleanupdetails";
    public static final String VIRTUAL_SIZE = "virtualsize";
    public static final String NETSCALER_CONTROLCENTER_ID = "netscalercontrolcenterid";
    public static final String NETSCALER_SERVICEPACKAGE_ID = "netscalerservicepackageid";
    public static final String FETCH_ROUTER_HEALTH_CHECK_RESULTS = "fetchhealthcheckresults";

    public static final String ZONE_ID_LIST = "zoneids";
    public static final String DESTINATION_ZONE_ID_LIST = "destzoneids";
    public static final String ADMIN = "admin";
    public static final String CHECKSUM_PARAMETER_PREFIX_DESCRIPTION = "The parameter containing the checksum will be considered a MD5sum if it is not prefixed\n"
            + " and just a plain ascii/utf8 representation of a hexadecimal string. If it is required to\n"
            + " use another algorithm the hexadecimal string is to be prefixed with a string of the form,\n"
            + " \"{<algorithm>}\", not including the double quotes. In this <algorithm> is the exact string\n"
            + " representing the java supported algorithm, i.e. MD5 or SHA-256. Note that java does not\n" + " contain an algorithm called SHA256 or one called sha-256, only SHA-256.";

    public static final String HAS_ANNOTATIONS = "hasannotations";
    public static final String LAST_ANNOTATED = "lastannotated";
    public static final String LDAP_DOMAIN = "ldapdomain";

    public static final String STDOUT = "stdout";
    public static final String STDERR = "stderr";
    public static final String EXITCODE = "exitcode";
    public static final String TARGET_ID = "targetid";
    public static final String FILES = "files";
    public static final String SRC_POOL = "srcpool";
    public static final String DEST_POOL = "destpool";
    public static final String DEST_POOLS = "destpools";
    public static final String VOLUME_IDS = "volumeids";

    public static final String ROUTER_ID = "routerid";
    public static final String ROUTER_HEALTH_CHECKS = "healthchecks";
    public static final String ROUTER_CHECK_NAME = "checkname";
    public static final String ROUTER_CHECK_TYPE = "checktype";
    public static final String ROUTER_IP = "routerip";
    public static final String ROUTER_IPV6 = "routeripv6";
    public static final String ROUTER_PRIVATE_INTERFACE_MAX_MTU = "routerprivateinterfacemaxmtu";
    public static final String ROUTER_PUBLIC_INTERFACE_MAX_MTU = "routerpublicinterfacemaxmtu";
    public static final String LAST_UPDATED = "lastupdated";
    public static final String PERFORM_FRESH_CHECKS = "performfreshchecks";
    public static final String CACHE_MODE = "cachemode";

    public static final String CONSOLE_END_POINT = "consoleendpoint";
    public static final String EXTERNAL_LOAD_BALANCER_IP_ADDRESS = "externalloadbalanceripaddress";
    public static final String DOCKER_REGISTRY_USER_NAME = "dockerregistryusername";
    public static final String DOCKER_REGISTRY_PASSWORD = "dockerregistrypassword";
    public static final String DOCKER_REGISTRY_URL = "dockerregistryurl";
    public static final String DOCKER_REGISTRY_EMAIL = "dockerregistryemail";
    public static final String ISO_NAME = "isoname";
    public static final String ISO_STATE = "isostate";
    public static final String SEMANTIC_VERSION = "semanticversion";
    public static final String KUBERNETES_VERSION_ID = "kubernetesversionid";
    public static final String KUBERNETES_VERSION_NAME = "kubernetesversionname";
    public static final String MASTER_NODES = "masternodes";
    public static final String NODE_IDS = "nodeids";
    public static final String CONTROL_NODES = "controlnodes";
    public static final String MIN_SEMANTIC_VERSION = "minimumsemanticversion";
    public static final String MIN_KUBERNETES_VERSION_ID = "minimumkubernetesversionid";
    public static final String NODE_ROOT_DISK_SIZE = "noderootdisksize";
    public static final String SUPPORTS_HA = "supportsha";
    public static final String SUPPORTS_AUTOSCALING = "supportsautoscaling";
    public static final String AUTOSCALING_ENABLED = "autoscalingenabled";
    public static final String MIN_SIZE = "minsize";
    public static final String MAX_SIZE = "maxsize";

    public static final String BOOT_TYPE = "boottype";
    public static final String BOOT_MODE = "bootmode";
    public static final String BOOT_INTO_SETUP = "bootintosetup";
    public static final String DEPLOY_AS_IS = "deployasis";
    public static final String DEPLOY_AS_IS_DETAILS = "deployasisdetails";
    public static final String CROSS_ZONES = "crossZones";
    public static final String SOURCETEMPLATEID = "sourcetemplateid";
    public static final String DYNAMIC_SCALING_ENABLED = "dynamicscalingenabled";
    public static final String IOTHREADS_ENABLED = "iothreadsenabled";
    public static final String IO_DRIVER_POLICY = "iodriverpolicy";

    public static final String POOL_TYPE = "pooltype";
    public static final String REDUNDANT_STATE = "redundantstate";

    public static final String ADMINS_ONLY = "adminsonly";
    public static final String ANNOTATION_FILTER = "annotationfilter";
    public static final String CODE_FOR_2FA = "codefor2fa";
    public static final String PROVIDER_FOR_2FA = "providerfor2fa";
    public static final String ISSUER_FOR_2FA = "issuerfor2fa";
    public static final String MANDATE_2FA = "mandate2fa";
    public static final String SECRET_CODE = "secretcode";
    public static final String LOGIN = "login";
    public static final String LOGOUT = "logout";
    public static final String LIST_IDPS = "listIdps";

    public static final String READY_FOR_SHUTDOWN = "readyforshutdown";
    public static final String SHUTDOWN_TRIGGERED = "shutdowntriggered";
    public static final String PENDING_JOBS_COUNT = "pendingjobscount";

    public static final String PUBLIC_MTU = "publicmtu";
    public static final String PRIVATE_MTU = "privatemtu";
    public static final String MTU = "mtu";
    public static final String AUTO_ENABLE_KVM_HOST = "autoenablekvmhost";
    public static final String LIST_APIS = "listApis";
    public static final String OBJECT_STORAGE_ID = "objectstorageid";
    public static final String VERSIONING = "versioning";
    public static final String OBJECT_LOCKING = "objectlocking";
    public static final String ENCRYPTION = "encryption";
    public static final String QUOTA = "quota";
    public static final String ACCESS_KEY = "accesskey";

    public static final String SOURCE_NAT_IP = "sourcenatipaddress";
    public static final String SOURCE_NAT_IP_ID = "sourcenatipaddressid";
    public static final String HAS_RULES = "hasrules";
    public static final String DISK_PATH = "diskpath";
    public static final String IMPORT_SOURCE = "importsource";
    public static final String TEMP_PATH = "temppath";
    public static final String OBJECT_STORAGE = "objectstore";

    public static final String HEURISTIC_RULE = "heuristicrule";
    public static final String HEURISTIC_TYPE_VALID_OPTIONS = "Valid options are: ISO, SNAPSHOT, TEMPLATE and VOLUME.";

    public static final String MANAGEMENT = "management";
    public static final String IS_VNF = "isvnf";
    public static final String VNF_NICS = "vnfnics";
    public static final String VNF_DETAILS = "vnfdetails";
    public static final String CLEAN_UP_VNF_DETAILS = "cleanupvnfdetails";
    public static final String CLEAN_UP_VNF_NICS = "cleanupvnfnics";
    public static final String VNF_CONFIGURE_MANAGEMENT = "vnfconfiguremanagement";
    public static final String VNF_CIDR_LIST = "vnfcidrlist";

    public static final String CLIENT_ID = "clientid";
    public static final String REDIRECT_URI = "redirecturi";

    public static final String IS_TAG_A_RULE = "istagarule";

    public static final String PARAMETER_DESCRIPTION_IS_TAG_A_RULE = "Whether the informed tag is a JS interpretable rule or not.";

    /**
     * This enum specifies IO Drivers, each option controls specific policies on I/O.
     * Qemu guests support "threads" and "native" options Since 0.8.8 ; "io_uring" is supported Since 6.3.0 (QEMU 5.0).
     */
    public enum IoDriverPolicy {
        NATIVE("native"),
        THREADS("threads"),
        IO_URING("io_uring"),
        STORAGE_SPECIFIC("storage_specific");

        String ioDriver;

        IoDriverPolicy(String driver) {
            ioDriver = driver;
        }

        @Override
        public String toString() {
            return ioDriver;
        }
    }

    public enum BootType {
        UEFI, BIOS;

        @Override
        public String toString() {
            return this.name();
        }
    }

    public enum BootMode {
        LEGACY, SECURE;

        @Override
        public String toString() {
            return this.name();
        }
    }

    public enum HostDetails {
        all, capacity, events, stats, min;
    }

    public enum VMDetails {
        all, group, nics, stats, secgrp, tmpl, servoff, diskoff, backoff, iso, volume, min, affgrp, vnfnics;
    }

    public enum DomainDetails {
        all, resource, min;
    }
}
