// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.
package com.cloud.snapshot;

import java.util.List;

import javax.inject.Inject;

import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

import com.cloud.storage.Snapshot;
import com.cloud.storage.SnapshotVO;
import com.cloud.storage.dao.SnapshotDaoImpl;
import com.cloud.utils.component.ComponentContext;

import junit.framework.Assert;
import junit.framework.TestCase;

@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations = "classpath:/SnapshotDaoTestContext.xml")
public class SnapshotDaoTest extends TestCase {
    @Inject
    SnapshotDaoImpl dao;

    @Before
    public void setup() throws Exception {
        ComponentContext.initComponentsLifeCycle();
    }

    @Test
    public void testListBy() {
        List<SnapshotVO> snapshots = dao.listByInstanceId(3, Snapshot.State.BackedUp);
        for (SnapshotVO snapshot : snapshots) {
            Assert.assertTrue(snapshot.getState() == Snapshot.State.BackedUp);
        }
    }
}
