#!/usr/bin/python
# Copyright 2012 Citrix Systems, Inc. Licensed under the
# Apache License, Version 2.0 (the "License"); you may not use this
# file except in compliance with the License.  Citrix Systems, Inc.
# reserves all rights not expressly granted by the License.
# You may obtain a copy of the License at http://www.apache.org/licenses/LICENSE-2.0
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
# 
# Automatically generated by addcopyright.py at 04/03/2012



 

# Usage: prepare_tftp_bootfile.py tftp_dir mac cifs_server share directory image_to_restore cifs_username cifs_password
import os, sys
from sys import exit
from os import makedirs
from os.path import exists, join

fmt1 = '''DEFAULT default
PROMPT 1
TIMEOUT 26
DISPLAY boot.msg
LABEL default
KERNEL %s
APPEND ramdisk_size=66000 initrd=%s ksdevice=%s ks=%s 
'''
fmt2 = '''DEFAULT default
PROMPT 1
TIMEOUT 26
DISPLAY boot.msg
LABEL default
KERNEL %s
APPEND ramdisk_size=66000 initrd=%s ks=%s
'''

tftp_dir = ''
mac = ''
kernel = ''
initrd = ''
ks_file = ''
ks_device = ''

def prepare():
    try:
        pxelinux = join(tftp_dir, "pxelinux.cfg")
        if exists(pxelinux) == False:
            makedirs(pxelinux)

        cfg_name = "01-" + mac.replace(':','-').lower()
        cfg_path = join(pxelinux, cfg_name)
        f = open(cfg_path, "w")
        if ks_device == '':
            stuff = fmt2 % (kernel, initrd, ks_file)
        else:
            stuff = fmt1 % (kernel, initrd, ks_device, ks_file)
        f.write(stuff)
        f.close()
        return 0
    except Exception, e:
        print e
        return 1


if __name__ == "__main__":
    if len(sys.argv) < 7:
        print "Usage: prepare_kickstart_bootfile.py tftp_dir mac kernel initrd ks_file ks_device"
        exit(1)

    (tftp_dir, mac, kernel, initrd, ks_file, ks_device) = sys.argv[1:]
    
    ret = prepare()
    exit(ret)
