# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
# 
#   http://www.apache.org/licenses/LICENSE-2.0
# 
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.
'''
Created on May 19, 2011

'''
import logging

class OvmLogger(object):
    '''
    classdocs
    '''


    def __init__(self, className):
        '''
        Constructor
        '''
        self.className = className
        self.logger = logging.getLogger(className)
    
    def info(self, func, msg=None):
        assert callable(func), "%s is not a function"%func
        fmt = "[%s.%s]: "%(self.className, func.__name__)
        self.logger.info("%s%s"%(fmt,msg))
    
    def debug(self, func, msg=None):
        assert callable(func), "%s is not a function"%func
        fmt = "[%s.%s]: "%(self.className, func.__name__)
        self.logger.debug("%s%s"%(fmt,msg))
    
    def error(self, func, msg=None):
        assert callable(func), "%s is not a function"%func
        fmt = "[%s.%s]: "%(self.className, func.__name__)
        self.logger.error("%s%s"%(fmt,msg))
    
    def warning(self, func, msg=None):
        assert callable(func), "%s is not a function"%func
        fmt = "[%s.%s]: "%(self.className, func.__name__)
        self.logger.warning("%s%s"%(fmt,msg))