// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

(function ($, cloudStack) {

    var zoneObjs, podObjs, clusterObjs, domainObjs, networkOfferingObjs, physicalNetworkObjs;
    var selectedClusterObj, selectedZoneObj, selectedPublicNetworkObj, selectedManagementNetworkObj, selectedPhysicalNetworkObj, selectedGuestNetworkObj;
    var nspMap = {
    };
    //from listNetworkServiceProviders API
    var nspHardcodingArray =[]; //for service providers listView (hardcoding, not from listNetworkServiceProviders API)

    // Add router type to virtual router
    // -- can be either Project, VPC, or System (standard)
    var mapRouterType = function (index, router) {
        var routerType = _l('label.menu.system');

        if (router.projectid) {
            routerType = _l('label.project');
            router.account = router.project;
        }

        if (router.vpcid) {
            routerType = _l('label.vpc');
            router.guestnetworkname = router.vpcname;
        }

        if (router.isredundantrouter) {
            router.guestnetworkname = router.guestnetworkname + " (" + router.redundantstate + ")";
        }

        return $.extend(router, {
            routerType: routerType
        });
    };

    cloudStack.publicIpRangeAccount = {
        dialog: function (args) {
            return function (args) {
                var data = args.data ? args.data: {
                };
                var fields = {
                    systemvms: {
                        label: 'label.system.vms',
                        isBoolean: true,
                        docID: 'helpSetReservationSystemVms',
                        defaultValue: data.systemvms
                    },
                    account: {
                        label: 'label.account',
                        defaultValue: data.account
                    },
                    domainid: {
                        label: 'label.domain',
                        defaultValue: data.domainid,
                        select: function (args) {
                            $.ajax({
                                url: createURL('listDomains'),
                                data: {
                                    details: 'min',
                                    listAll: true
                                },
                                success: function (json) {
                                    args.response.success({
                                        data: $.map(json.listdomainsresponse.domain, function (domain) {
                                            return {
                                                id: domain.id,
                                                description: domain.path
                                            };
                                        })
                                    });
                                }
                            });
                        }
                    }
                };
                var success = args.response.success;

                if (args.$item) {
                    // Account data is read-only after creation
                    $.ajax({
                        url: createURL('listDomains'),
                        data: {
                            id: data.domainid,
                            details: 'min',
                            listAll: true
                        },
                        success: function (json) {
                            var domain = json.listdomainsresponse.domain[0];

                            if (data.forSystemVms != null) {
                                systemvms = '<li>' + _l('label.system.vms') + ': ' + data.forSystemVms + '</li>'
                            }
                            if (data.account != null)
                                cloudStack.dialog.notice({
                                    message: '<ul><li>' + _l('label.account') + ': ' + data.account + '</li>' + '<li>' + _l('label.domain') + ': ' + domain.path + '</li>' + systemvms + '</ul>'
                                });
                            else
                                cloudStack.dialog.notice({
                                    message: '<ul><li>' + _l('label.domain') + ': ' + domain.path + '</li>' + systemvms + '</ul>'
                                });
                        }
                    });
                } else {
                    cloudStack.dialog.createForm({
                        form: {
                            title: 'label.set.reservation',
                            desc: 'label.set.reservation.desc',
                            fields: fields,
                            preFilter: function(args) {
                                var $systemvms = args.$form.find('.form-item[rel=systemvms]');
                                var $systemvmsCb = $systemvms.find('input[type=checkbox]');
                                var $account = args.$form.find('.form-item[rel=account]');
                                var $accountTxt = args.$form.find('input[name=account]');
                                var $domainid = args.$form.find('select[name=domainid]');
                                $systemvmsCb.change(function() {
                                    if ($systemvmsCb.is(':checked')) {
                                        $accountTxt.val('');
                                        $accountTxt.attr('disabled', true);
                                        $domainid.attr('disabled', true);
                                    }
                                    else {
                                        $accountTxt.attr('disabled', false);
                                        $domainid.attr('disabled', false);
                                    }
                                });
                            }
                        },
                        after: function (args) {
                            var data = cloudStack.serializeForm(args.$form);

                            success({
                                data: data
                            });
                        }
                    });
                }
            };
        }
    };

    var getTrafficType = function (physicalNetwork, typeID) {
        var trafficType = {
        };

        $.ajax({
            url: createURL('listTrafficTypes'),
            data: {
                physicalnetworkid: physicalNetwork.id
            },
            async: false,
            success: function (json) {
                trafficType = $.grep(
                json.listtraffictypesresponse.traffictype,
                function (trafficType) {
                    return trafficType.traffictype == typeID;
                })[0];
            }
        });

        if (trafficType.xennetworklabel == null || trafficType.xennetworklabel == 0)
        trafficType.xennetworklabel = _l( 'label.network.label.display.for.blank.value');
        if (trafficType.kvmnetworklabel == null || trafficType.kvmnetworklabel == 0)
        trafficType.kvmnetworklabel = _l( 'label.network.label.display.for.blank.value');
        if (trafficType.vmwarenetworklabel == null || trafficType.vmwarenetworklabel == 0)
        trafficType.vmwarenetworklabel = _l( 'label.network.label.display.for.blank.value');
        if (trafficType.ovmnetworklabel == null || trafficType.ovmnetworklabel == 0)
        trafficType.ovmnetworklabel = _l( 'label.network.label.display.for.blank.value');
        if (trafficType.lxcnetworklabel == null || trafficType.lxcnetworklabel == 0)
        trafficType.lxcnetworklabel = _l( 'label.network.label.display.for.blank.value');
        if (trafficType.hypervnetworklabel == null || trafficType.hypervnetworklabel == 0)
        trafficType.hypervnetworklabel = _l( 'label.network.label.display.for.blank.value');
        if (trafficType.ovm3networklabel == null || trafficType.ovm3networklabel == 0)
        trafficType.ovm3networklabel = _l( 'label.network.label.display.for.blank.value');

        return trafficType;
    };

    var updateTrafficLabels = function (trafficType, labels, complete) {
        var array1 =[];
        if (labels.xennetworklabel != _l( 'label.network.label.display.for.blank.value'))
        array1.push("&xennetworklabel=" + labels.xennetworklabel);
        if (labels.kvmnetworklabel != _l( 'label.network.label.display.for.blank.value'))
        array1.push("&kvmnetworklabel=" + labels.kvmnetworklabel);
        if (labels.vmwarenetworklabel != _l( 'label.network.label.display.for.blank.value'))
        array1.push("&vmwarenetworklabel=" + labels.vmwarenetworklabel);
        if (labels.ovmnetworklabel != _l( 'label.network.label.display.for.blank.value'))
        array1.push("&ovmnetworklabel=" + labels.ovmnetworklabel);
        if (labels.lxcnetworklabel != _l( 'label.network.label.display.for.blank.value'))
        array1.push("&lxcnetworklabel=" + labels.lxcnetworklabel);
        if (labels.hypervnetworklabel != _l( 'label.network.label.display.for.blank.value'))
        array1.push("&hypervnetworklabel=" + labels.hypervnetworklabel);
        if (labels.ovm3networklabel != _l( 'label.network.label.display.for.blank.value'))
        array1.push("&ovm3networklabel=" + labels.ovm3networklabel);

        $.ajax({
            url: createURL('updateTrafficType' + array1.join("")),
            data: {
                id: trafficType.id
            },
            success: function (json) {
                var jobID = json.updatetraffictyperesponse.jobid;

                cloudStack.ui.notifications.add({
                    desc: 'Update traffic labels',
                    poll: pollAsyncJobResult,
                    section: 'System',
                    _custom: {
                        jobId: jobID
                    }
                },
                complete ? complete: function () {
                },
                {
                },
                function (data) {
                    // Error
                    cloudStack.dialog.notice({
                        message: parseXMLHttpResponse(data)
                    });
                },
                {
                });
            }
        })
    };

    function virtualRouterProviderActionFilter(args) {
        var allowedActions =[];
        var jsonObj = args.context.item; //args.context.item == nspMap["virtualRouter"]
        if (jsonObj.state == "Enabled")
        allowedActions.push("disable"); else if (jsonObj.state == "Disabled")
        allowedActions.push("enable");
        return allowedActions;
    };

    function ovsProviderActionFilter(args) {
        var allowedActions = [];
        var jsonObj = args.context.item; //args.context.item == nspMap["virtualRouter"]
        if (jsonObj.state == "Enabled")
            allowedActions.push("disable");
        else if (jsonObj.state == "Disabled")
            allowedActions.push("enable");
        return allowedActions;
    };

    var rollingMaintenanceAction = function(args) {
        var isCluster = args.entity === 'clusters';
        var isZone = args.entity === 'zones';
        var isPod = args.entity === 'pods';
        var isHost = args.entity === 'hosts';
        var action = {
            messages: {
                notification: function(args) {
                    return 'label.start.rolling.maintenance';
                }
            },
            label: 'label.start.rolling.maintenance',
            addRow: 'false',
            createForm: {
                title: 'label.start.rolling.maintenance',
                fields: {
                    timeout: {
                        label: 'label.timeout',
                    },
                    force: {
                        isBoolean: true,
                        label: 'label.start.rolling.maintenance.force'
                    },
                    payload: {
                        label: 'label.start.rolling.maintenance.payload'
                    }
                }
            },
            action: function(args) {
                var selectedIds;
                if (isCluster) {
                    selectedIds = args.context.clusters.map(x => x.id);
                } else if (isZone) {
                    selectedIds = args.context.physicalResources.map(x => x.id);
                } else if (isPod) {
                    selectedIds = args.context.pods.map(x => x.id);
                } else if (isHost) {
                    selectedIds = args.context.hosts.map(x => x.id);
                }
                var ids = selectedIds.join(',');
                var data = {
                    force: args.data.force,
                    timeout: args.data.timeout,
                    payload: args.data.payload
                };
                if (isCluster) {
                    $.extend(data, {
                        clusterids : ids
                    });
                } else if (isZone) {
                    $.extend(data, {
                        zoneids : ids
                    });
                } else if (isPod) {
                    $.extend(data, {
                        podids : ids
                    });
                } else if (isHost) {
                    $.extend(data, {
                        hostids : ids
                    });
                }

                $.ajax({
                    url: createURL("startRollingMaintenance"),
                    dataType: "json",
                    data: data,
                    async: true,
                    success: function (json) {
                        var item = json.startrollingmaintenanceresponse;
                        var jid = item.jobid;
                        args.response.success({
                            _custom: {
                                jobId: jid
                            }
                        });
                    }
                });
            },
            notification: {
                poll: pollAsyncJobResult
            }
        };

        if (args && args.listView) {
            $.extend(action, {
                isHeader: true,
                isMultiSelectAction: true
            });
        }

        return action;
    };

    cloudStack.sections.system = {
        title: 'label.menu.infrastructure',
        id: 'system',

        // System dashboard
        dashboard: {
            dataProvider: function (args) {
                $.ajax({
                    url: createURL('listInfrastructure'),
                    success: function (json) {
                        var response = json.listinfrastructureresponse.infrastructure;
                        var data = {};
                        data.zoneCount = response.zones;
                        data.podCount = response.pods;
                        data.clusterCount = response.clusters;
                        data.hostCount = response.hosts;
                        data.primaryStorageCount = response.storagepools;
                        data.secondaryStorageCount = response.imagestores;
                        data.systemVmCount = response.systemvms;
                        data.virtualRouterCount = response.routers;
                        data.socketCount = response.cpusockets;
                        data.managementServerCount = response.managementservers;
                        args.response.success({
                            data: data
                        });
                    }
                });
            }
        },

        zoneDashboard: function (args) {
            $.ajax({
                url: createURL('listCapacity'),
                data: {
                    zoneid: args.context.zones[0].id
                },
                success: function (json) {
                    var capacities = json.listcapacityresponse.capacity;
                    var data = {
                    };

                    $(capacities).each(function () {
                        var capacity = this;

                        data[capacity.type] = {
                            used: cloudStack.converters.convertByType(capacity.type, capacity.capacityused),
                            total: cloudStack.converters.convertByType(capacity.type, capacity.capacitytotal),
                            percent: parseInt(capacity.percentused)
                        };
                    });

                    args.response.success({
                        data: data
                    });
                }
            });
        },

        // Network-as-a-service configuration
        naas: {
            providerListView: {
                id: 'networkProviders',
                fields: {
                    name: {
                        label: 'label.name'
                    },
                    state: {
                        label: 'label.state',
                        converter: function (str) {
                            // For localization
                            return str;
                        },
                        indicator: {
                            'Enabled': 'on',
                            'Disabled': 'off'
                        }
                    }
                },
                disableInfiniteScrolling: true,
                dataProvider: function (args) {
                    refreshNspData();
                    args.response.success({
                        data: nspHardcodingArray
                    })
                },

                detailView: function (args) {
                    return cloudStack.sections.system.naas.networkProviders.types[
                    args.context.networkProviders[0].id];
                }
            },
            mainNetworks: {
                'public': {
                    detailView: {
                        actions: {
                            edit: {
                                label: 'label.edit',
                                action: function (args) {
                                    var trafficType = getTrafficType(selectedPhysicalNetworkObj, 'Public');

                                    updateTrafficLabels(trafficType, args.data, function () {
                                        args.response.success();
                                    });
                                }
                            }
                        },
                        tabs: {
                            details: {
                                title: 'label.details',
                                fields:[ {
                                    traffictype: {
                                        label: 'label.traffic.type'
                                    },
                                    broadcastdomaintype: {
                                        label: 'label.broadcast.domain.type'
                                    }
                                },
                                {
                                    xennetworklabel: {
                                        label: 'label.xenserver.traffic.label',
                                        isEditable: true
                                    },
                                    kvmnetworklabel: {
                                        label: 'label.kvm.traffic.label',
                                        isEditable: true
                                    },
                                    vmwarenetworklabel: {
                                        label: 'label.vmware.traffic.label',
                                        isEditable: true
                                    },
                                    ovmnetworklabel: {
                                        label: 'label.ovm.traffic.label',
                                        isEditable: true
                                    },
                                    lxcnetworklabel: {
                                        label: 'label.lxc.traffic.label',
                                        isEditable: true
                                    },
                                    hypervnetworklabel: {
                                        label: 'label.hyperv.traffic.label',
                                        isEditable: true
                                    },
                                    ovm3networklabel: {
                                        label: 'label.ovm3.traffic.label',
                                        isEditable: true
                                    }
                                }],

                                dataProvider: function (args) {
                                    $.ajax({
                                        url: createURL("listNetworks&listAll=true&trafficType=Public&isSystem=true&zoneId=" + selectedZoneObj.id, {
                                            ignoreProject: true
                                        }),
                                        dataType: "json",
                                        async: false,
                                        success: function (json) {
                                            var trafficType = getTrafficType(selectedPhysicalNetworkObj, 'Public');
                                            var items = json.listnetworksresponse.network;

                                            selectedPublicNetworkObj = items[0];

                                            // Include traffic labels
                                            selectedPublicNetworkObj.xennetworklabel = trafficType.xennetworklabel;
                                            selectedPublicNetworkObj.kvmnetworklabel = trafficType.kvmnetworklabel;
                                            selectedPublicNetworkObj.vmwarenetworklabel = trafficType.vmwarenetworklabel;
                                            selectedPublicNetworkObj.ovmnetworklabel = trafficType.ovmnetworklabel;
                                            selectedPublicNetworkObj.lxcnetworklabel = trafficType.lxcnetworklabel;
                                            selectedPublicNetworkObj.hypervnetworklabel = trafficType.hypervnetworklabel;
                                            selectedPublicNetworkObj.ovm3networklabel = trafficType.ovm3networklabel;
                                            args.response.success({
                                                data: selectedPublicNetworkObj
                                            });
                                        }
                                    });
                                }
                            },

                            ipAddresses: {
                                title: 'label.ip.ranges',
                                custom: function (args) {
                                    return $('<div></div>').multiEdit({
                                        context: args.context,
                                        noSelect: true,
                                        fields: {
                                            'gateway': {
                                                edit: true,
                                                label: 'label.gateway'
                                            },
                                            'netmask': {
                                                edit: true,
                                                label: 'label.netmask'
                                            },
                                            'vlan': {
                                                edit: true,
                                                label: 'label.vlan',
                                                isOptional: true
                                            },
                                            'startip': {
                                                edit: true,
                                                label: 'label.start.IP'
                                            },
                                            'endip': {
                                                edit: true,
                                                label: 'label.end.IP'
                                            },
                                            'account': {
                                                label: 'label.account',
                                                custom: {
                                                    buttonLabel: 'label.set.reservation',
                                                    action: cloudStack.publicIpRangeAccount.dialog()
                                                }
                                            },
                                            'add-rule': {
                                                label: 'label.add',
                                                addButton: true
                                            }
                                        },
                                        add: {
                                            label: 'label.add',
                                            action: function (args) {
                                                var array1 =[];
                                                array1.push("&zoneId=" + args.context.zones[0].id);

                                                var vlan = "untagged";
                                                if (args.data.vlan != null && args.data.vlan.length > 0){
                                                    vlan = args.data.vlan;
                                                }
                                                cloudStack.addVlanToCommandUrlParameterArrayIfItIsNotNullAndNotEmpty(array1, vlan);

                                                array1.push("&gateway=" + args.data.gateway);
                                                array1.push("&netmask=" + args.data.netmask);
                                                array1.push("&startip=" + args.data.startip);
                                                if (args.data.endip != null && args.data.endip.length > 0)
                                                array1.push("&endip=" + args.data.endip);

                                                if (args.data.account) {
                                                    if (args.data.account.account)
                                                        array1.push("&account=" + args.data.account.account);
                                                        if (args.data.account.domainid) {
                                                            array1.push("&domainid=" + args.data.account.domainid);
                                                        }
                                                    if (args.data.account.systemvms) {
                                                        systvmsval = args.data.account.systemvms == "on" ? "true" : "false"
                                                        array1.push("&forsystemvms=" + systvmsval);
                                                    }
                                                }

                                                array1.push("&forVirtualNetwork=true");
                                                //indicates this new IP range is for public network, not guest network

                                                $.ajax({
                                                    url: createURL("createVlanIpRange" + array1.join("")),
                                                    dataType: "json",
                                                    success: function (json) {
                                                        var item = json.createvlaniprangeresponse.vlan;
                                                        args.response.success({
                                                            data: item,
                                                            notification: {
                                                                label: 'label.add.ip.range',
                                                                poll: function (args) {
                                                                    args.complete();
                                                                }
                                                            }
                                                        });
                                                    },
                                                    error: function (XMLHttpResponse) {
                                                        var errorMsg = parseXMLHttpResponse(XMLHttpResponse);
                                                        args.response.error(errorMsg);
                                                    }
                                                });
                                            }
                                        },
                                        actionPreFilter: function (args) {
                                            var actionsToShow =[ 'destroy'];
                                            if (args.context.multiRule[0].domain == 'ROOT' && args.context.multiRule[0].account != null &&
                                                args.context.multiRule[0].account.account == 'system' && !args.context.multiRule[0].forsystemvms)
                                            actionsToShow.push('addAccount'); else
                                            actionsToShow.push('releaseFromAccount');
                                            return actionsToShow;
                                        },
                                        actions: {
                                            destroy: {
                                                label: 'label.remove.ip.range',
                                                action: function (args) {
                                                    $.ajax({
                                                        url: createURL('deleteVlanIpRange&id=' + args.context.multiRule[0].id),
                                                        dataType: 'json',
                                                        async: true,
                                                        success: function (json) {
                                                            args.response.success({
                                                                notification: {
                                                                    label: 'label.remove.ip.range',
                                                                    poll: function (args) {
                                                                        args.complete();
                                                                    }
                                                                }
                                                            });
                                                        },
                                                        error: function (json) {
                                                            args.response.error(parseXMLHttpResponse(json));
                                                        }
                                                    });
                                                }
                                            },

                                            releaseFromAccount: {
                                                label: 'label.release.account',
                                                action: function (args) {
                                                    $.ajax({
                                                        url: createURL('releasePublicIpRange'),
                                                        data: {
                                                            id: args.context.multiRule[0].id
                                                        },
                                                        success: function (json) {
                                                            args.response.success({
                                                                notification: {
                                                                    label: 'label.release.account.lowercase',
                                                                    poll: function (args) {
                                                                        args.complete();
                                                                    }
                                                                }
                                                            });
                                                        },
                                                        error: function (json) {
                                                            args.response.error(parseXMLHttpResponse(json));
                                                        }
                                                    });
                                                }
                                            },

                                            addAccount: {
                                                label: 'label.add.account',
                                                createForm: {
                                                    title: 'label.add.account',
                                                    fields: {
                                                        account: {
                                                            label: 'label.account'
                                                        },
                                                        domainid: {
                                                            label: 'label.domain',
                                                            select: function (args) {
                                                                $.ajax({
                                                                    url: createURL('listDomains'),
                                                                    data: {
                                                                        details: 'min',
                                                                        listAll: true
                                                                    },
                                                                    success: function (json) {
                                                                        args.response.success({
                                                                            data: $.map(json.listdomainsresponse.domain, function (domain) {
                                                                                return {
                                                                                    id: domain.id,
                                                                                    description: domain.path
                                                                                };
                                                                            })
                                                                        });
                                                                    }
                                                                });
                                                            }
                                                        }
                                                    }
                                                },
                                                action: function (args) {
                                                    var data = {
                                                        id: args.context.multiRule[0].id,
                                                        zoneid: args.context.multiRule[0].zoneid,
                                                        domainid: args.data.domainid
                                                    };
                                                    if (args.data.account) {
                                                        $.extend(data, {
                                                            account: args.data.account
                                                        });
                                                    }
                                                    $.ajax({
                                                        url: createURL('dedicatePublicIpRange'),
                                                        data: data,
                                                        success: function (json) {
                                                            args.response.success({
                                                                notification: {
                                                                    label: 'label.add.account',
                                                                    poll: function (args) {
                                                                        args.complete();
                                                                    }
                                                                }
                                                            });
                                                        },
                                                        error: function (json) {
                                                            args.response.error(parseXMLHttpResponse(json));
                                                        }
                                                    });
                                                }
                                            }
                                        },
                                        dataProvider: function (args) {
                                            $.ajax({
                                                url: createURL("listVlanIpRanges&zoneid=" + args.context.zones[0].id + "&networkId=" + selectedPublicNetworkObj.id),
                                                dataType: "json",
                                                success: function (json) {
                                                    var items = json.listvlaniprangesresponse.vlaniprange;

                                                    args.response.success({
                                                        data: $.map(items, function (item) {
                                                            return $.extend(item, {
                                                                account: {
                                                                    _buttonLabel: item.account ? '[' + item.domain + '] ' + item.account: item.domain,
                                                                    account: item.account,
                                                                    domainid: item.domainid,
                                                                    forSystemVms: item.forsystemvms
                                                                }
                                                            });
                                                        })
                                                    });
                                                }
                                            });
                                        }
                                    });
                                }
                            }
                        }
                    }
                },

                'storage': {
                    detailView: {
                        actions: {
                            edit: {
                                label: 'label.edit',
                                action: function (args) {
                                    var trafficType = getTrafficType(selectedPhysicalNetworkObj, 'Storage');

                                    updateTrafficLabels(trafficType, args.data, function () {
                                        args.response.success();
                                    });
                                }
                            }
                        },
                        tabs: {
                            details: {
                                title: 'label.details',
                                fields:[ {
                                    traffictype: {
                                        label: 'label.traffic.type'
                                    },
                                    broadcastdomaintype: {
                                        label: 'label.broadcast.domain.type'
                                    }
                                },
                                {
                                    xennetworklabel: {
                                        label: 'label.xenserver.traffic.label',
                                        isEditable: true
                                    },
                                    kvmnetworklabel: {
                                        label: 'label.kvm.traffic.label',
                                        isEditable: true
                                    },
                                    vmwarenetworklabel: {
                                        label: 'label.vmware.traffic.label',
                                        isEditable: true
                                    },
                                    ovmnetworklabel: {
                                        label: 'label.ovm.traffic.label',
                                        isEditable: true
                                    },
                                    lxcnetworklabel: {
                                        label: 'label.lxc.traffic.label',
                                        isEditable: true
                                    },
                                    hypervnetworklabel: {
                                        label: 'label.hyperv.traffic.label',
                                        isEditable: true
                                    },
                                    ovm3networklabel: {
                                        label: 'label.ovm3.traffic.label',
                                        isEditable: true
                                    }
                                }],

                                dataProvider: function (args) {
                                    $.ajax({
                                        url: createURL("listNetworks&listAll=true&trafficType=Storage&isSystem=true&zoneId=" + selectedZoneObj.id),
                                        dataType: "json",
                                        async: false,
                                        success: function (json) {
                                            var items = json.listnetworksresponse.network;
                                            var trafficType = getTrafficType(selectedPhysicalNetworkObj, 'Storage');
                                            selectedPublicNetworkObj = items[0];

                                            selectedPublicNetworkObj.xennetworklabel = trafficType.xennetworklabel;
                                            selectedPublicNetworkObj.kvmnetworklabel = trafficType.kvmnetworklabel;
                                            selectedPublicNetworkObj.vmwarenetworklabel = trafficType.vmwarenetworklabel;
                                            selectedPublicNetworkObj.ovmnetworklabel = trafficType.ovmnetworklabel;
                                            selectedPublicNetworkObj.lxcnetworklabel = trafficType.lxcnetworklabel;
                                            selectedPublicNetworkObj.hypervnetworklabel = trafficType.hypervnetworklabel;
                                            selectedPublicNetworkObj.ovm3networklabel = trafficType.ovm3networklabel;
                                            args.response.success({
                                                data: selectedPublicNetworkObj
                                            });
                                        }
                                    });
                                }
                            },

                            ipAddresses: {
                                title: 'label.ip.ranges',
                                custom: function (args) {
                                    return $('<div></div>').multiEdit({
                                        context: args.context,
                                        noSelect: true,
                                        fields: {
                                            'podid': {
                                                label: 'label.pod',
                                                select: function (args) {
                                                    $.ajax({
                                                        url: createURL("listPods&zoneid=" + selectedZoneObj.id),
                                                        dataType: "json",
                                                        success: function (json) {
                                                            var items =[];
                                                            var pods = json.listpodsresponse.pod;
                                                            $(pods).each(function () {
                                                                items.push({
                                                                    name: this.id,
                                                                    description: this.name
                                                                });
                                                                //should be "{id: this.id, description: this.name}" (to be consistent with dropdown in createFrom and edit mode) (Brian will fix widget later)
                                                            });
                                                            args.response.success({
                                                                data: items
                                                            });
                                                        }
                                                    });
                                                }
                                            },
                                            'gateway': {
                                                edit: true,
                                                label: 'label.gateway'
                                            },
                                            'netmask': {
                                                edit: true,
                                                label: 'label.netmask'
                                            },
                                            'vlan': {
                                                edit: true,
                                                label: 'label.vlan',
                                                isOptional: true
                                            },
                                            'startip': {
                                                edit: true,
                                                label: 'label.start.IP'
                                            },
                                            'endip': {
                                                edit: true,
                                                label: 'label.end.IP'
                                            },
                                            'add-rule': {
                                                label: 'label.add',
                                                addButton: true
                                            }
                                        },
                                        add: {
                                            label: 'label.add',
                                            action: function (args) {
                                                var array1 =[];
                                                array1.push("&zoneId=" + args.context.zones[0].id);
                                                array1.push("&podid=" + args.data.podid);
                                                array1.push("&gateway=" + args.data.gateway);

                                                cloudStack.addVlanToCommandUrlParameterArrayIfItIsNotNullAndNotEmpty(array1, args.data.vlan);

                                                array1.push("&netmask=" + args.data.netmask);
                                                array1.push("&startip=" + args.data.startip);
                                                if (args.data.endip != null && args.data.endip.length > 0)
                                                array1.push("&endip=" + args.data.endip);

                                                $.ajax({
                                                    url: createURL("createStorageNetworkIpRange" + array1.join("")),
                                                    dataType: "json",
                                                    success: function (json) {
                                                        args.response.success({
                                                            _custom: {
                                                                jobId: json.createstoragenetworkiprangeresponse.jobid
                                                            },
                                                            notification: {
                                                                label: 'label.add.ip.range',
                                                                poll: pollAsyncJobResult
                                                            }
                                                        });
                                                    },
                                                    error: function (XMLHttpResponse) {
                                                        var errorMsg = parseXMLHttpResponse(XMLHttpResponse);
                                                        args.response.error(errorMsg);
                                                    }
                                                });
                                            }
                                        },
                                        actions: {
                                            destroy: {
                                                label: 'label.delete',
                                                action: function (args) {
                                                    $.ajax({
                                                        url: createURL('deleteStorageNetworkIpRange&id=' + args.context.multiRule[0].id),
                                                        dataType: 'json',
                                                        async: true,
                                                        success: function (json) {
                                                            args.response.success({
                                                                notification: {
                                                                    label: 'label.remove.ip.range',
                                                                    poll: function (args) {
                                                                        args.complete();
                                                                    }
                                                                }
                                                            });
                                                        }
                                                    });
                                                }
                                            }
                                        },
                                        dataProvider: function (args) {
                                            $.ajax({
                                                url: createURL("listStorageNetworkIpRange&zoneid=" + args.context.zones[0].id),
                                                dataType: "json",
                                                success: function (json) {
                                                    var items = json.liststoragenetworkiprangeresponse.storagenetworkiprange;
                                                    args.response.success({
                                                        data: items
                                                    });
                                                }
                                            });
                                        }
                                    });
                                }
                            }
                        }
                    }
                },

                'management': {
                    detailView: {
                        actions: {
                            edit: {
                                label: 'label.edit',
                                action: function (args) {
                                    var trafficType = getTrafficType(selectedPhysicalNetworkObj, 'Management');

                                    updateTrafficLabels(trafficType, args.data, function () {
                                        args.response.success();
                                    });
                                }
                            }
                        },
                        tabs: {
                            details: {
                                title: 'label.details',
                                fields:[ {
                                    traffictype: {
                                        label: 'label.traffic.type'
                                    },
                                    broadcastdomaintype: {
                                        label: 'label.broadcast.domain.type'
                                    }
                                },
                                {
                                    xennetworklabel: {
                                        label: 'label.xenserver.traffic.label',
                                        isEditable: true
                                    },
                                    kvmnetworklabel: {
                                        label: 'label.kvm.traffic.label',
                                        isEditable: true
                                    },
                                    vmwarenetworklabel: {
                                        label: 'label.vmware.traffic.label',
                                        isEditable: true
                                    },
                                    ovmnetworklabel: {
                                        label: 'label.ovm.traffic.label',
                                        isEditable: true
                                    },
                                    lxcnetworklabel: {
                                        label: 'label.lxc.traffic.label',
                                        isEditable: true
                                    },
                                    hypervnetworklabel: {
                                        label: 'label.hyperv.traffic.label',
                                        isEditable: true
                                    },
                                    ovm3networklabel: {
                                        label: 'label.ovm3.traffic.label',
                                        isEditable: true
                                    }
                                }],
                                dataProvider: function (args) {
                                    $.ajax({
                                        url: createURL("listNetworks&listAll=true&issystem=true&trafficType=Management&zoneId=" + selectedZoneObj.id),
                                        dataType: "json",
                                        success: function (json) {
                                            selectedManagementNetworkObj = json.listnetworksresponse.network[0];

                                            var trafficType = getTrafficType(selectedPhysicalNetworkObj, 'Management');

                                            selectedManagementNetworkObj.xennetworklabel = trafficType.xennetworklabel;
                                            selectedManagementNetworkObj.kvmnetworklabel = trafficType.kvmnetworklabel;
                                            selectedManagementNetworkObj.vmwarenetworklabel = trafficType.vmwarenetworklabel;
                                            selectedManagementNetworkObj.ovmnetworklabel = trafficType.ovmnetworklabel;
                                            selectedManagementNetworkObj.lxcnetworklabel = trafficType.lxcnetworklabel;
                                            selectedManagementNetworkObj.hypervnetworklabel = trafficType.hypervnetworklabel;
                                            selectedManagementNetworkObj.ovm3networklabel = trafficType.ovm3networklabel;
                                            args.response.success({
                                                data: selectedManagementNetworkObj
                                            });
                                        }
                                    });
                                }
                            },

                            ipAddresses: {
                                title: 'label.ip.ranges',
                                custom: function (args) {
                                    return $('<div></div>').multiEdit({
                                        context: args.context,
                                        noSelect: true,
                                        fields: {
                                            'podid': {
                                                label: 'label.pod',
                                                select: function (args) {
                                                    $.ajax({
                                                        url: createURL("listPods&zoneid=" + selectedZoneObj.id),
                                                        dataType: "json",
                                                        success: function (json) {
                                                            var items =[];
                                                            var pods = json.listpodsresponse.pod;
                                                            $(pods).each(function () {
                                                                items.push({
                                                                    name: this.id,
                                                                    description: this.name
                                                                });
                                                            });
                                                            args.response.success({
                                                                data: items
                                                            });
                                                        }
                                                    });
                                                }
                                            },
                                            'gateway': {
                                                edit: true,
                                                label: 'label.gateway'
                                            },
                                            'netmask': {
                                                edit: true,
                                                label: 'label.netmask'
                                            },
                                            'vlan': {
                                                edit: true,
                                                label: 'label.vlan',
                                                validation: {
                                                    required: false
                                                }
                                            },
                                            'startip': {
                                                edit: true,
                                                label: 'label.start.IP'
                                            },
                                            'endip': {
                                                edit: true,
                                                label: 'label.end.IP',
                                                validation: {
                                                    required: false
                                                }
                                            },
                                            'systemvms' : {
                                                isBoolean: true,
                                                label: 'label.system.vms'
                                            },
                                            'add-rule': {
                                                label: 'label.add',
                                                addButton: true
                                            }
                                        },
                                        add: {
                                            label: 'label.add',
                                            action: function (args) {
                                                var array1 =[];

                                                array1.push("&podid=" + args.data.podid);
                                                array1.push("&gateway=" + args.data.gateway);
                                                array1.push("&netmask=" + args.data.netmask);
                                                array1.push("&startip=" + args.data.startip);

                                                if (args.data.endip != null && args.data.endip.length > 0)
                                                    array1.push("&endip=" + args.data.endip);

                                                if (args.data.systemvms) {
                                                    array1.push("&forsystemvms=" + (args.data.systemvms == "on" ? "true" : "false"));
                                                }
                                                cloudStack.addVlanToCommandUrlParameterArrayIfItIsNotNullAndNotEmpty(array1, args.data.vlan);

                                                $.ajax({
                                                    url: createURL("createManagementNetworkIpRange" + array1.join("")),
                                                    dataType: "json",
                                                    success: function (json) {
                                                        args.response.success({
                                                            _custom: {
                                                                jobId: json.createmanagementnetworkiprangeresponse.jobid
                                                            },
                                                            notification: {
                                                                label: 'label.add.management.ip.range',
                                                                poll: pollAsyncJobResult
                                                            }
                                                        });
                                                    },
                                                    error: function (XMLHttpResponse) {
                                                        var errorMsg = parseXMLHttpResponse(XMLHttpResponse);
                                                        args.response.error(errorMsg);
                                                    }
                                                });
                                            }
                                        },
                                        actions: {
                                            destroy: {
                                                label: 'label.delete',
                                                action: function (args) {
                                                    var array1 =[];
                                                    array1.push("&podid=" + args.context.multiRule[0].podid);
                                                    array1.push("&startip=" + args.context.multiRule[0].startip);
                                                    array1.push("&endip=" + args.context.multiRule[0].endip);
                                                    array1.push("&vlan=" + args.context.multiRule[0].vlan);

                                                    $.ajax({
                                                        url: createURL('deleteManagementNetworkIpRange' + array1.join("")),
                                                        dataType: 'json',
                                                        async: true,
                                                        success: function (json) {
                                                            args.response.success({
                                                                _custom: {
                                                                    jobId: json.deletemanagementnetworkiprangeresponse.jobid
                                                                },
                                                                notification: {
                                                                    label: 'label.remove.management.ip.range',
                                                                    poll: pollAsyncJobResult
                                                                }
                                                            });
                                                        },
                                                        error: function (XMLHttpResponse) {
                                                            var errorMsg = parseXMLHttpResponse(XMLHttpResponse);
                                                            args.response.error(errorMsg);
                                                        }
                                                    });
                                                }
                                            }
                                        },
                                        dataProvider: function (args) {
                                            $.ajax({
                                                url: createURL("listPods&zoneid=" + selectedZoneObj.id),
                                                dataType: "json",
                                                async: true,
                                                success: function (json) {
                                                    var items =[];

                                                    var pods = json.listpodsresponse.pod;
                                                    $(pods).each(function () {
                                                        for (var i = 0; i < this.startip.length; i++) {
                                                            var systemvmsValue = this.forsystemvms[i] == "1" ? true : false;
                                                            items.push({
                                                                podid: this.id,
                                                                gateway: this.gateway,
                                                                netmask: this.netmask,
                                                                startip: this.startip[i],
                                                                endip: this.endip[i],
                                                                systemvms: systemvmsValue,
                                                                vlan: this.vlanid[i]
                                                            });
                                                        }
                                                    });

                                                    args.response.success({
                                                        data: items
                                                    });
                                                }
                                            });
                                        }
                                    });
                                }
                            }
                        }
                    }
                },

                'guest': {
                    //physical network + Guest traffic type
                    detailView: {
                        actions: {
                            edit: {
                                label: 'label.edit',
                                action: function (args) {
                                    var data = {
                                        id: selectedPhysicalNetworkObj.id
                                    };

                                    $.extend(data, {
                                        vlan: args.data.vlan
                                    });

                                    $.extend(data, {
                                        tags: args.data.tags
                                    });

                                    $.ajax({
                                        url: createURL('updatePhysicalNetwork'),
                                        data: data,
                                        success: function (json) {
                                            var jobId = json.updatephysicalnetworkresponse.jobid;

                                            var trafficType = getTrafficType(selectedPhysicalNetworkObj, 'Guest');

                                            updateTrafficLabels(trafficType, args.data, function () {
                                                args.response.success({
                                                    _custom: {
                                                        jobId: jobId
                                                    }
                                                });
                                            });
                                        }
                                    });
                                },
                                notification: {
                                    poll: pollAsyncJobResult
                                }
                            }
                        },

                        tabFilter: function (args) {
                            var hiddenTabs =[];
                            if (selectedZoneObj.networktype == 'Basic') {
                                hiddenTabs.push("network");
                                hiddenTabs.push("dedicatedGuestVlanRanges");
                            } else {
                                //selectedZoneObj.networktype == 'Advanced'
                                hiddenTabs.push("ipAddresses");
                            }
                            return hiddenTabs;
                        },

                        tabs: {
                            details: {
                                title: 'label.details',
                                preFilter: function (args) {
                                    var hiddenFields =[];
                                    if (selectedZoneObj.networktype == "Basic") {
                                        hiddenFields.push("vlan");
                                        // hiddenFields.push("endVlan");
                                    }
                                    return hiddenFields;
                                },
                                fields:[ {
                                    //updatePhysicalNetwork API
                                    state: {
                                        label: 'label.state'
                                    },
                                    vlan: {
                                        label: 'label.vlan.vni.ranges',
                                        isEditable: true
                                    },
                                    tags: {
                                        label: 'label.tags',
                                        isEditable: true
                                    },
                                    broadcastdomainrange: {
                                        label: 'label.broadcast.domain.range'
                                    }
                                },
                                {
                                    //updateTrafficType API
                                    xennetworklabel: {
                                        label: 'label.xenserver.traffic.label',
                                        isEditable: true
                                    },
                                    kvmnetworklabel: {
                                        label: 'label.kvm.traffic.label',
                                        isEditable: true
                                    },
                                    vmwarenetworklabel: {
                                        label: 'label.vmware.traffic.label',
                                        isEditable: true
                                    },
                                    ovmnetworklabel: {
                                        label: 'label.ovm.traffic.label',
                                        isEditable: true
                                    },
                                    lxcnetworklabel: {
                                        label: 'label.lxc.traffic.label',
                                        isEditable: true
                                    },
                                    hypervnetworklabel: {
                                        label: 'label.hyperv.traffic.label',
                                        isEditable: true
                                    },
                                    ovm3networklabel: {
                                        label: 'label.ovm3.traffic.label',
                                        isEditable: true
                                    }
                                }],
                                dataProvider: function (args) {
                                    //physical network + Guest traffic type
                                    //refresh physical network
                                    $.ajax({
                                        url: createURL('listPhysicalNetworks'),
                                        data: {
                                            id: args.context.physicalNetworks[0].id
                                        },
                                        async: true,
                                        success: function (json) {
                                            selectedPhysicalNetworkObj = json.listphysicalnetworksresponse.physicalnetwork[0];

                                            //    var startVlan, endVlan;
                                            var vlan = selectedPhysicalNetworkObj.vlan;
                                            /*    if(vlan != null && vlan.length > 0) {
                                            if(vlan.indexOf("-") != -1) {
                                            var vlanArray = vlan.split("-");
                                            startVlan = vlanArray[0];
                                            endVlan = vlanArray[1];
                                            }
                                            else {
                                            startVlan = vlan;
                                            }
                                            selectedPhysicalNetworkObj["startVlan"] = startVlan;
                                            selectedPhysicalNetworkObj["endVlan"] = endVlan;
                                            }*/

                                            //traffic type
                                            var xenservertrafficlabel, kvmtrafficlabel, vmwaretrafficlabel;
                                            var trafficType = getTrafficType(selectedPhysicalNetworkObj, 'Guest');
                                            //refresh Guest traffic type
                                            selectedPhysicalNetworkObj[ "xennetworklabel"] = trafficType.xennetworklabel;
                                            selectedPhysicalNetworkObj[ "kvmnetworklabel"] = trafficType.kvmnetworklabel;
                                            selectedPhysicalNetworkObj[ "vmwarenetworklabel"] = trafficType.vmwarenetworklabel;
                                            selectedPhysicalNetworkObj[ "ovmnetworklabel"] = trafficType.ovmnetworklabel;
                                            selectedPhysicalNetworkObj[ "lxcnetworklabel"] = trafficType.lxcnetworklabel;
                                            selectedPhysicalNetworkObj[ "hypervnetworklabel"] = trafficType.hypervnetworklabel;
                                            selectedPhysicalNetworkObj[ "ovm3networklabel"] = trafficType.ovm3networklabel;
                                            args.response.success({
                                                actionFilter: function () {
                                                    var allowedActions =[ 'edit', 'addVlanRange', 'removeVlanRange'];
                                                    return allowedActions;
                                                },
                                                data: selectedPhysicalNetworkObj
                                            });
                                        }
                                    });
                                }
                            },

                            ipAddresses: {
                                title: 'label.ip.ranges',
                                custom: function (args) {
                                    return $('<div></div>').multiEdit({
                                        context: args.context,
                                        noSelect: true,
                                        fields: {
                                            'podid': {
                                                label: 'label.pod',
                                                select: function (args) {
                                                    $.ajax({
                                                        url: createURL("listPods&zoneid=" + selectedZoneObj.id),
                                                        dataType: "json",
                                                        success: function (json) {
                                                            var items =[];
                                                            var pods = json.listpodsresponse.pod;
                                                            $(pods).each(function () {
                                                                items.push({
                                                                    name: this.id,
                                                                    description: this.name
                                                                });
                                                                //should be "{id: this.id, description: this.name}" (to be consistent with dropdown in createFrom and edit mode) (Brian will fix widget later)
                                                            });
                                                            args.response.success({
                                                                data: items
                                                            });
                                                        }
                                                    });
                                                }
                                            },
                                            'gateway': {
                                                edit: true,
                                                label: 'label.gateway'
                                            },
                                            'netmask': {
                                                edit: true,
                                                label: 'label.netmask'
                                            },
                                            'startip': {
                                                edit: true,
                                                label: 'label.start.IP'
                                            },
                                            'endip': {
                                                edit: true,
                                                label: 'label.end.IP'
                                            },
                                            'add-rule': {
                                                label: 'label.add',
                                                addButton: true
                                            }
                                        },
                                        add: {
                                            label: 'label.add',
                                            action: function (args) {
                                                var array1 =[];
                                                array1.push("&podid=" + args.data.podid);
                                                array1.push("&networkid=" + selectedGuestNetworkObj.id);
                                                array1.push("&gateway=" + args.data.gateway);
                                                array1.push("&netmask=" + args.data.netmask);
                                                array1.push("&startip=" + args.data.startip);
                                                if (args.data.endip != null && args.data.endip.length > 0)
                                                array1.push("&endip=" + args.data.endip);
                                                array1.push("&forVirtualNetwork=false");
                                                //indicates this new IP range is for guest network, not public network

                                                $.ajax({
                                                    url: createURL("createVlanIpRange" + array1.join("")),
                                                    dataType: "json",
                                                    success: function (json) {
                                                        var item = json.createvlaniprangeresponse.vlan;
                                                        args.response.success({
                                                            data: item,
                                                            notification: {
                                                                label: 'label.add.ip.range',
                                                                poll: function (args) {
                                                                    args.complete();
                                                                }
                                                            }
                                                        });
                                                    },
                                                    error: function (XMLHttpResponse) {
                                                        var errorMsg = parseXMLHttpResponse(XMLHttpResponse);
                                                        args.response.error(errorMsg);
                                                    }
                                                });
                                            }
                                        },
                                        actions: {
                                            destroy: {
                                                label: 'label.remove.ip.range',
                                                action: function (args) {
                                                    $.ajax({
                                                        url: createURL('deleteVlanIpRange&id=' + args.context.multiRule[0].id),
                                                        dataType: 'json',
                                                        async: true,
                                                        success: function (json) {
                                                            args.response.success({
                                                                notification: {
                                                                    label: 'label.remove.ip.range',
                                                                    poll: function (args) {
                                                                        args.complete();
                                                                    }
                                                                }
                                                            });
                                                        },
                                                        error: function (json) {
                                                            args.response.error(parseXMLHttpResponse(json));
                                                        }
                                                    });
                                                }
                                            }
                                        },
                                        dataProvider: function (args) {
                                            //only basic zone has IP Range tab
                                            selectedGuestNetworkObj = null;
                                            $.ajax({
                                                url: createURL("listNetworks&listAll=true&trafficType=Guest&zoneid=" + selectedZoneObj.id),
                                                dataType: "json",
                                                async: false,
                                                success: function (json) {
                                                    var items = json.listnetworksresponse.network;
                                                    if (items != null && items.length > 0)
                                                    selectedGuestNetworkObj = json.listnetworksresponse.network[0];
                                                }
                                            });
                                            if (selectedGuestNetworkObj == null)
                                            return;

                                            $.ajax({
                                                url: createURL("listVlanIpRanges&zoneid=" + selectedZoneObj.id + "&networkId=" + selectedGuestNetworkObj.id),
                                                dataType: "json",
                                                success: function (json) {
                                                    var items = json.listvlaniprangesresponse.vlaniprange;
                                                    args.response.success({
                                                        data: items
                                                    });
                                                }
                                            });
                                        }
                                    });
                                }
                            },

                            network: {
                                title: 'label.network',
                                listView: {
                                    section: 'networks',
                                    id: 'networks',
                                    fields: {
                                        name: {
                                            label: 'label.name'
                                        },
                                        type: {
                                            label: 'label.type'
                                        },
                                        vlan: {
                                            label: 'label.vnet.id'
                                        },
                                        broadcasturi: {
                                            label: 'label.broadcat.uri'
                                        },
                                        cidr: {
                                            label: 'label.ipv4.cidr'
                                        },
                                        ip6cidr: {
                                            label: 'label.ipv6.CIDR'
                                        }
                                        //scope: { label: 'label.scope' }
                                    },
                                    actions: {
                                        add: addGuestNetworkDialog.def
                                    },

                                    dataProvider: function (args) {
                                        var array1 =[];
                                        if (args.filterBy != null) {
                                            if (args.filterBy.search != null && args.filterBy.search.by != null && args.filterBy.search.value != null) {
                                                switch (args.filterBy.search.by) {
                                                    case "name":
                                                    if (args.filterBy.search.value.length > 0)
                                                    array1.push("&keyword=" + args.filterBy.search.value);
                                                    break;
                                                }
                                            }
                                        }

                                        //need to make 2 listNetworks API call to get all guest networks from one physical network in Advanced zone
                                        var items =[];
                                        //"listNetworks&projectid=-1": list guest networks under all projects (no matter who the owner is)
                                        $.ajax({
                                            url: createURL("listNetworks&projectid=-1&trafficType=Guest&zoneId=" + selectedZoneObj.id + "&physicalnetworkid=" + selectedPhysicalNetworkObj.id + "&page=" + args.page + "&pagesize=" + pageSize + array1.join("")),
                                            dataType: "json",
                                            async: false,
                                            success: function (json) {
                                                if (json.listnetworksresponse.network != null && json.listnetworksresponse.network.length > 0)
                                                items = json.listnetworksresponse.network;
                                            }
                                        });

                                        var networkCollectionMap = {
                                        };
                                        $(items).each(function () {
                                            networkCollectionMap[ this.id] = this.name;
                                        });

                                        //"listNetworks&listAll=true: list guest networks that are not under any project (no matter who the owner is)
                                        $.ajax({
                                            url: createURL("listNetworks&listAll=true&trafficType=Guest&zoneId=" + selectedZoneObj.id + "&physicalnetworkid=" + selectedPhysicalNetworkObj.id + "&page=" + args.page + "&pagesize=" + pageSize + array1.join("")),
                                            dataType: "json",
                                            async: false,
                                            success: function (json) {
                                                $(json.listnetworksresponse.network).each(function () {
                                                    if ((this.id in networkCollectionMap) == false)
                                                    items.push(this);
                                                });
                                            }
                                        });

                                        $(items).each(function () {
                                            addExtraPropertiesToGuestNetworkObject(this);
                                        });

                                        args.response.success({
                                            data: items
                                        });
                                    },

                                    detailView: {
                                        name: 'label.guest.network.details',
                                        noCompact: true,
                                        viewAll: {
                                            path: '_zone.guestIpRanges',
                                            label: 'label.ip.ranges',
                                            preFilter: function (args) {
                                                if (selectedGuestNetworkObj.type == "Isolated") {
                                                    var services = selectedGuestNetworkObj.service;
                                                    if (services != null) {
                                                        for (var i = 0; i < services.length; i++) {
                                                            var service = services[i];
                                                            if (service.name == "SourceNat")
                                                            return false;
                                                        }
                                                    }
                                                }
                                                return true;
                                            }
                                        },
                                        actions: {
                                            edit: {
                                                label: 'label.edit',
                                                action: function (args) {
                                                    var array1 =[];
                                                    array1.push("&name=" + encodeURIComponent(args.data.name));
                                                    array1.push("&displaytext=" + encodeURIComponent(args.data.displaytext));

                                                    //args.data.networkdomain is null when networkdomain field is hidden
                                                    if (args.data.networkdomain != null && args.data.networkdomain != selectedGuestNetworkObj.networkdomain)
                                                    array1.push("&networkdomain=" + encodeURIComponent(args.data.networkdomain));

                                                    //args.data.networkofferingid is null when networkofferingid field is hidden
                                                    if (args.data.networkofferingid != null && args.data.networkofferingid != args.context.networks[0].networkofferingid) {
                                                        array1.push("&networkofferingid=" + encodeURIComponent(args.data.networkofferingid));

                                                        if (args.context.networks[0].type == "Isolated") {
                                                            //Isolated network
                                                            cloudStack.dialog.confirm({
                                                                message: 'message.confirm.current.guest.CIDR.unchanged',
                                                                action: function () {
                                                                    //"Yes"    button is clicked
                                                                    array1.push("&changecidr=false");
                                                                    $.ajax({
                                                                        url: createURL("updateNetwork&id=" + args.context.networks[0].id + array1.join("")),
                                                                        dataType: "json",
                                                                        success: function (json) {
                                                                            var jid = json.updatenetworkresponse.jobid;
                                                                            args.response.success({
                                                                                _custom: {
                                                                                    jobId: jid,
                                                                                    getUpdatedItem: function (json) {
                                                                                        var item = json.queryasyncjobresultresponse.jobresult.network;
                                                                                        return {
                                                                                            data: item
                                                                                        };
                                                                                    }
                                                                                }
                                                                            });
                                                                        }
                                                                    });
                                                                },
                                                                cancelAction: function () {
                                                                    //"Cancel" button is clicked
                                                                    array1.push("&changecidr=true");
                                                                    $.ajax({
                                                                        url: createURL("updateNetwork&id=" + args.context.networks[0].id + array1.join("")),
                                                                        dataType: "json",
                                                                        success: function (json) {
                                                                            var jid = json.updatenetworkresponse.jobid;
                                                                            args.response.success({
                                                                                _custom: {
                                                                                    jobId: jid,
                                                                                    getUpdatedItem: function (json) {
                                                                                        var item = json.queryasyncjobresultresponse.jobresult.network;
                                                                                        return {
                                                                                            data: item
                                                                                        };
                                                                                    }
                                                                                }
                                                                            });
                                                                        }
                                                                    });
                                                                }
                                                            });
                                                            return;
                                                        }
                                                    }

                                                    $.ajax({
                                                        url: createURL("updateNetwork&id=" + args.context.networks[0].id + array1.join("")),
                                                        dataType: "json",
                                                        success: function (json) {
                                                            var jid = json.updatenetworkresponse.jobid;
                                                            args.response.success({
                                                                _custom: {
                                                                    jobId: jid,
                                                                    getUpdatedItem: function (json) {
                                                                        var item = json.queryasyncjobresultresponse.jobresult.network;
                                                                        return {
                                                                            data: item
                                                                        };
                                                                    }
                                                                }
                                                            });
                                                        }
                                                    });
                                                },
                                                notification: {
                                                    poll: pollAsyncJobResult
                                                }
                                            },

                                            'restart': {
                                                label: 'label.restart.network',
                                                createForm: {
                                                    title: 'label.restart.network',
                                                    desc: 'message.restart.network',
                                                    preFilter: function (args) {
                                                        if (selectedZoneObj.networktype == "Basic") {
                                                            args.$form.find('.form-item[rel=cleanup]').find('input').prop('checked', false);
                                                            //unchecked
                                                            args.$form.find('.form-item[rel=cleanup]').hide();
                                                            //hidden
                                                        } else {
                                                            args.$form.find('.form-item[rel=cleanup]').find('input').attr('checked', 'checked');
                                                            //checked
                                                            args.$form.find('.form-item[rel=cleanup]').css('display', 'inline-block');
                                                            //shown
                                                        }
                                                    },
                                                    fields: {
                                                        cleanup: {
                                                            label: 'label.clean.up',
                                                            isBoolean: true
                                                        }
                                                    }
                                                },
                                                action: function (args) {
                                                    var array1 =[];
                                                    array1.push("&cleanup=" + (args.data.cleanup == "on"));
                                                    $.ajax({
                                                        url: createURL("restartNetwork&cleanup=true&id=" + args.context.networks[0].id + array1.join("")),
                                                        dataType: "json",
                                                        async: true,
                                                        success: function (json) {
                                                            var jid = json.restartnetworkresponse.jobid;
                                                            args.response.success({
                                                                _custom: {
                                                                    jobId: jid,
                                                                    getUpdatedItem: function (json) {
                                                                        return json.queryasyncjobresultresponse.jobresult.network;
                                                                    }
                                                                }
                                                            });
                                                        }
                                                    });
                                                },
                                                messages: {
                                                    notification: function (args) {
                                                        return 'label.restart.network';
                                                    }
                                                },
                                                notification: {
                                                    poll: pollAsyncJobResult
                                                }
                                            },

                                            'remove': {
                                                label: 'label.action.delete.network',
                                                messages: {
                                                    confirm: function (args) {
                                                        return 'message.action.delete.network';
                                                    },
                                                    notification: function (args) {
                                                        return 'label.action.delete.network';
                                                    }
                                                },
                                                action: function (args) {
                                                    $.ajax({
                                                        url: createURL("deleteNetwork&id=" + args.context.networks[0].id),
                                                        dataType: "json",
                                                        async: true,
                                                        success: function (json) {
                                                            var jid = json.deletenetworkresponse.jobid;
                                                            args.response.success({
                                                                _custom: {
                                                                    jobId: jid,
                                                                    getUpdatedItem: function (json) {
                                                                        return {
                                                                        };
                                                                        //nothing in this network needs to be updated, in fact, this whole template has being deleted
                                                                    }
                                                                }
                                                            });
                                                        }
                                                    });
                                                },
                                                notification: {
                                                    poll: pollAsyncJobResult
                                                }
                                            }
                                        },
                                        tabs: {
                                            details: {
                                                title: 'label.details',
                                                preFilter: function (args) {
                                                    var hiddenFields =[];
                                                    if (selectedZoneObj.networktype == "Basic") {
                                                        hiddenFields.push("account");
                                                        hiddenFields.push("gateway");
                                                        //hiddenFields.push("netmask");
                                                    }

                                                    if (selectedGuestNetworkObj.type == "Isolated") {
                                                        hiddenFields.push("networkofferingdisplaytext");
                                                        hiddenFields.push("networkdomaintext");
                                                        hiddenFields.push("gateway");
                                                        //hiddenFields.push("netmask");
                                                    } else {
                                                        //selectedGuestNetworkObj.type == "Shared"
                                                        hiddenFields.push("networkofferingid");
                                                        hiddenFields.push("networkdomain");
                                                    }
                                                    return hiddenFields;
                                                },
                                                fields:[ {
                                                    name: {
                                                        label: 'label.name',
                                                        isEditable: true
                                                    }
                                                },
                                                {
                                                    id: {
                                                        label: 'label.id'
                                                    },
                                                    displaytext: {
                                                        label: 'label.description',
                                                        isEditable: true
                                                    },
                                                    type: {
                                                        label: 'label.type'
                                                    },
                                                    state: {
                                                        label: 'label.state'
                                                    },
                                                    restartrequired: {
                                                        label: 'label.restart.required',
                                                        converter: function (booleanValue) {
                                                            if (booleanValue == true)
                                                            return "<font color='red'>Yes</font>"; else if (booleanValue == false)
                                                            return "No";
                                                        }
                                                    },
                                                    vlan: {
                                                        label: 'label.vlan.id'
                                                    },
                                                    broadcasturi: {
                                                        label: 'label.broadcat.uri'
                                                    },
                                                    scope: {
                                                        label: 'label.scope'
                                                    },
                                                    networkofferingdisplaytext: {
                                                        label: 'label.network.offering'
                                                    },
                                                    networkofferingid: {
                                                        label: 'label.network.offering',
                                                        isEditable: true,
                                                        select: function (args) {
                                                            var items =[];
                                                            $.ajax({
                                                                url: createURL("listNetworkOfferings&state=Enabled&networkid=" + selectedGuestNetworkObj.id + "&zoneid=" + selectedGuestNetworkObj.zoneid),
                                                                dataType: "json",
                                                                async: false,
                                                                success: function (json) {
                                                                    var networkOfferingObjs = json.listnetworkofferingsresponse.networkoffering;
                                                                    $(networkOfferingObjs).each(function () {
                                                                        items.push({
                                                                            id: this.id,
                                                                            description: this.displaytext
                                                                        });
                                                                    });
                                                                }
                                                            });

                                                            //include currently selected network offeirng to dropdown
                                                            items.push({
                                                                id: selectedGuestNetworkObj.networkofferingid,
                                                                description: selectedGuestNetworkObj.networkofferingdisplaytext
                                                            });

                                                            args.response.success({
                                                                data: items
                                                            });
                                                        }
                                                    },

                                                    networkofferingidText: {
                                                        label: 'label.network.offering.id'
                                                    },

                                                    gateway: {
                                                        label: 'label.ipv4.gateway'
                                                    },
                                                    //netmask: { label: 'label.netmask' },
                                                    cidr: {
                                                        label: 'label.ipv4.cidr'
                                                    },

                                                    ip6gateway: {
                                                        label: 'label.ipv6.gateway'
                                                    },
                                                    ip6cidr: {
                                                        label: 'label.ipv6.CIDR'
                                                    },

                                                    networkdomaintext: {
                                                        label: 'label.network.domain'
                                                    },
                                                    networkdomain: {
                                                        label: 'label.network.domain',
                                                        isEditable: true
                                                    },

                                                    domain: {
                                                        label: 'label.domain'
                                                    },
                                                    subdomainaccess: {
                                                        label: 'label.subdomain.access',
                                                        converter: function (data) {
                                                            return data ? 'Yes': 'No';
                                                        }
                                                    },
                                                    account: {
                                                        label: 'label.account'
                                                    },
                                                    project: {
                                                        label: 'label.project'
                                                    }
                                                }],
                                                dataProvider: function (args) {
                                                    var data = {
                                                        id: args.context.networks[0].id
                                                    };
                                                    if (args.context.networks[0].projectid != null) {
                                                        $.extend(data, {
                                                            projectid: -1
                                                        });
                                                    } else {
                                                        $.extend(data, {
                                                            listAll: true //pass "&listAll=true" to "listNetworks&id=xxxxxxxx" for now before API gets fixed.
                                                        });
                                                    }

                                                    $.ajax({
                                                        url: createURL("listNetworks"),
                                                        data: data,
                                                        async: false,
                                                        success: function (json) {
                                                            selectedGuestNetworkObj = json.listnetworksresponse.network[0];
                                                            addExtraPropertiesToGuestNetworkObject(selectedGuestNetworkObj);

                                                            $(window).trigger('cloudStack.module.sharedFunctions.addExtraProperties', {
                                                                obj: selectedGuestNetworkObj,
                                                                objType: "Network"
                                                            });

                                                            args.response.success({
                                                                actionFilter: cloudStack.actionFilter.guestNetwork,
                                                                data: selectedGuestNetworkObj
                                                            });
                                                        }
                                                    });
                                                }
                                            }
                                        }
                                    }
                                }
                            },

                            dedicatedGuestVlanRanges: {
                                title: 'label.dedicated.vlan.vni.ranges',
                                listView: {
                                    section: 'dedicatedGuestVlanRanges',
                                    id: 'dedicatedGuestVlanRanges',
                                    fields: {
                                        guestvlanrange: {
                                            label: 'label.vlan.vni.ranges'
                                        },
                                        domain: {
                                            label: 'label.domain'
                                        },
                                        account: {
                                            label: 'label.account'
                                        }
                                    },
                                    dataProvider: function (args) {
                                        $.ajax({
                                            url: createURL('listDedicatedGuestVlanRanges'),
                                            data: {
                                                physicalnetworkid: args.context.physicalNetworks[0].id
                                            },
                                            success: function (json) {
                                                var items = json.listdedicatedguestvlanrangesresponse.dedicatedguestvlanrange;
                                                args.response.success({
                                                    data: items
                                                })
                                            }
                                        });
                                    },
                                    actions: {
                                        add: {
                                            label: 'label.dedicate.vlan.vni.range',
                                            messages: {
                                                notification: function (args) {
                                                    return 'label.dedicate.vlan.vni.range';
                                                }
                                            },
                                            createForm: {
                                                title: 'label.dedicate.vlan.vni.range',
                                                fields: {
                                                    vlanrange: {
                                                        label: 'label.vlan.vni.range',
                                                        validation: {
                                                            required: true
                                                        }
                                                    },
                                                    scope: {
                                                        label: 'label.scope',
                                                        docID: 'helpGuestNetworkZoneScope',
                                                        select: function(args) {
                                                            var array1 = [];

                                                            array1.push({
                                                                id: 'account-specific',
                                                                description: 'label.account'
                                                            });
                                                            array1.push({
                                                                id: 'project-specific',
                                                                description: 'label.project'
                                                            });

                                                            args.response.success({
                                                                data: array1
                                                            });

                                                            args.$select.change(function() {
                                                                var $form = $(this).closest('form');

                                                                if ($(this).val() == "account-specific") {
                                                                    $form.find('.form-item[rel=domainId]').css('display', 'inline-block');
                                                                    $form.find('.form-item[rel=account]').css('display', 'inline-block');
                                                                    $form.find('.form-item[rel=projectId]').hide();
                                                                } else if ($(this).val() == "project-specific") {
                                                                    $form.find('.form-item[rel=domainId]').css('display', 'inline-block');
                                                                    $form.find('.form-item[rel=account]').hide();
                                                                    $form.find('.form-item[rel=projectId]').css('display', 'inline-block');
                                                                }

                                                                if (args.context.projects != null && args.context.projects.length > 0) {
                                                                    $form.find('.form-item[rel=domainId]').hide();
                                                                    $form.find('.form-item[rel=account]').hide();
                                                                    $form.find('.form-item[rel=projectId]').hide();
                                                                }
                                                            });
                                                        },
                                                        isHidden: function(args) {
                                                            if(args.context.projects != null && args.context.projects.length > 0)
                                                                return true;
                                                            else
                                                                return false;
                                                        }
                                                    },
                                                    domainId: {
                                                        label: 'label.domain',
                                                        validation: {
                                                            required: true
                                                        },
                                                        select: function (args) {
                                                            $.ajax({
                                                                url: createURL('listDomains'),
                                                                data: {
                                                                    details: 'min',
                                                                    listAll: true
                                                                },
                                                                success: function (json) {
                                                                    args.response.success({
                                                                        data: $.map(json.listdomainsresponse.domain, function (domain) {
                                                                            return {
                                                                                id: domain.id,
                                                                                description: domain.path
                                                                            };
                                                                        })
                                                                    });
                                                                }
                                                            });
                                                        }
                                                    },
                                                    account: {
                                                        label: 'label.account',
                                                        validation: {
                                                            required: true
                                                        },
                                                        dependsOn: 'domainId',
                                                        select: function (args) {
                                                            $.ajax({
                                                                url: createURL('listAccounts&domainid=' + args.domainId),
                                                                data: {
                                                                    details: 'min',
                                                                    listAll: true
                                                                },
                                                                success: function (json) {
                                                                    args.response.success({
                                                                        data: $.map(json.listaccountsresponse.account, function (account) {
                                                                            return {
                                                                                id: account.name,
                                                                                description: account.name
                                                                            };
                                                                        })
                                                                    });
                                                                }
                                                            });
                                                        }
                                                    },
                                                    projectId: {
                                                        label: 'label.project',
                                                        validation: {
                                                            required: true
                                                        },
                                                        dependsOn: 'domainId',
                                                        select: function(args) {
                                                            var items = [];
                                                            $.ajax({
                                                                url: createURL("listProjects&details=min&domainid=" + args.domainId),
                                                                dataType: "json",
                                                                async: false,
                                                                success: function(json) {
                                                                    projectObjs = json.listprojectsresponse.project;
                                                                    $(projectObjs).each(function() {
                                                                        items.push({
                                                                            id: this.id,
                                                                            description: this.name
                                                                        });
                                                                    });
                                                                }
                                                            });
                                                            args.response.success({
                                                                data: items
                                                            });
                                                        }
                                                    }
                                                }
                                            },
                                            action: function (args) {
                                                var data = {
                                                    physicalnetworkid: args.context.physicalNetworks[0].id,
                                                    vlanrange: args.data.vlanrange
                                                };

                                                var $form = args.$form;

                                                if (($form.find('.form-item[rel=domainId]').css("display") != "none") && (args.data.domainId != null && args.data.domainId.length > 0)) {
                                                    $.extend(data, {
                                                        domainid: args.data.domainId
                                                    })
                                                }

                                                if (($form.find('.form-item[rel=account]').css("display") != "none") && (args.data.account != null && args.data.account.length > 0)) {
                                                    $.extend(data, {
                                                        account: args.data.account
                                                    })
                                                }

                                                if (($form.find('.form-item[rel=projectId]').css("display") != "none") && (args.data.projectId != null && args.data.projectId.length > 0)) {
                                                    $.extend(data, {
                                                        projectid: args.data.projectId
                                                    })
                                                }

                                                $.ajax({
                                                    url: createURL('dedicateGuestVlanRange'),
                                                    data: data,
                                                    success: function (json) {
                                                        var item = json.dedicateguestvlanrangeresponse.dedicatedguestvlanrange;
                                                        args.response.success({
                                                            data: item
                                                        });
                                                    }
                                                });
                                            },
                                            notification: {
                                                poll: function (args) {
                                                    args.complete();
                                                }
                                            }
                                        }
                                    },

                                    detailView: {
                                        name: 'label.vlan.range.details',
                                        actions: {
                                            remove: {
                                                label: 'label.release.dedicated.vlan.range',
                                                messages: {
                                                    confirm: function (args) {
                                                        return 'message.confirm.release.dedicate.vlan.range';
                                                    },
                                                    notification: function (args) {
                                                        return 'label.release.dedicated.vlan.range';
                                                    }
                                                },
                                                action: function (args) {
                                                    var data = {
                                                        id: args.context.dedicatedGuestVlanRanges[0].id
                                                    };
                                                    $.ajax({
                                                        url: createURL('releaseDedicatedGuestVlanRange'),
                                                        data: data,
                                                        async: true,
                                                        success: function (json) {
                                                            var jid = json.releasededicatedguestvlanrangeresponse.jobid;
                                                            args.response.success({
                                                                _custom: {
                                                                    jobId: jid
                                                                }
                                                            });
                                                        }
                                                    });
                                                },
                                                notification: {
                                                    poll: pollAsyncJobResult
                                                }
                                            }
                                        },

                                        tabs: {
                                            details: {
                                                title: 'label.details',
                                                fields:[ {
                                                    guestvlanrange: {
                                                        label: 'label.vlan.ranges'
                                                    }
                                                },
                                                {
                                                    domain: {
                                                        label: 'label.domain'
                                                    },
                                                    account: {
                                                        label: 'label.account'
                                                    },
                                                    id: {
                                                        label: 'label.id'
                                                    }
                                                }],
                                                dataProvider: function (args) {
                                                    $.ajax({
                                                        url: createURL('listDedicatedGuestVlanRanges'),
                                                        data: {
                                                            id: args.context.dedicatedGuestVlanRanges[0].id
                                                        },
                                                        success: function (json) {
                                                            var item = json.listdedicatedguestvlanrangesresponse.dedicatedguestvlanrange[0];
                                                            args.response.success({
                                                                data: item
                                                            });
                                                        }
                                                    });
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            },

            networks: {
                listView: {
                    id: 'physicalNetworks',
                    hideToolbar: true,
                    fields: {
                        name: {
                            label: 'label.name'
                        },
                        state: {
                            converter: function (str) {
                                // For localization
                                return str;
                            },
                            label: 'label.state',
                            indicator: {
                                'Enabled': 'on',
                                'Disabled': 'off'
                            }
                        },
                        isolationmethods: {
                            label: 'label.isolation.method'
                        },
                        vlan: {
                            label: 'label.vlan'
                        },
                        broadcastdomainrange: {
                            label: 'label.broadcast.domain.range'
                        }
                    },

                    actions: {
                        remove: {
                            label: 'label.action.delete.physical.network',
                            messages: {
                                confirm: function (args) {
                                    return 'message.action.delete.physical.network';
                                },
                                notification: function (args) {
                                    return 'label.action.delete.physical.network';
                                }
                            },
                            action: function (args) {
                                $.ajax({
                                    url: createURL("deletePhysicalNetwork&id=" + args.context.physicalNetworks[0].id),
                                    dataType: "json",
                                    async: true,
                                    success: function (json) {
                                        var jid = json.deletephysicalnetworkresponse.jobid;
                                        args.response.success({
                                            _custom: {
                                                jobId: jid
                                            }
                                        });
                                    }
                                });
                            },
                            notification: {
                                poll: pollAsyncJobResult
                            }
                        }
                    }
                },
                dataProvider: function (args) {
                    $.ajax({
                        url: createURL('listPhysicalNetworks'),
                        data: {
                            zoneid: args.context.zones[0].id
                        },
                        success: function (json) {
                            physicalNetworkObjs = json.listphysicalnetworksresponse.physicalnetwork;
                            args.response.success({
                                actionFilter: cloudStack.actionFilter.physicalNetwork,
                                data: json.listphysicalnetworksresponse.physicalnetwork
                            });
                        }
                    });
                }
            },

            trafficTypes: {
                dataProvider: function (args) {
                    selectedPhysicalNetworkObj = args.context.physicalNetworks[0];

                    $.ajax({
                        url: createURL('listTrafficTypes'),
                        data: {
                            physicalnetworkid: selectedPhysicalNetworkObj.id
                        },
                        success: function (json) {
                            args.response.success({
                                data: $.map(json.listtraffictypesresponse.traffictype, function (trafficType) {
                                    return {
                                        id: trafficType.id,
                                        name: trafficType.traffictype
                                    };
                                })
                            });
                        }
                    });
                }
            },

            networkProviders: {
                statusLabels: {
                    enabled: 'Enabled', //having device, network service provider is enabled
                    'not-configured': 'Not setup', //no device
                    disabled: 'Disabled' //having device, network service provider is disabled
                },

                // Actions performed on entire net. provider type
                actions: {
                    enable: function (args) {
                        args.response.success();
                    },

                    disable: function (args) {
                        args.response.success();
                    }
                },

                types: {
                    virtualRouter: {
                        id: 'virtualRouterProviders',
                        label: 'label.virtual.router',
                        isMaximized: true,
                        type: 'detailView',
                        fields: {
                            name: {
                                label: 'label.name'
                            },
                            ipaddress: {
                                label: 'label.ip.address'
                            },
                            state: {
                                label: 'label.status',
                                indicator: {
                                    'Enabled': 'on'
                                }
                            }
                        },
                        tabs: {
                            network: {
                                title: 'label.network',
                                fields:[ {
                                    name: {
                                        label: 'label.name'
                                    }
                                },
                                {
                                    id: {
                                        label: 'label.id'
                                    },
                                    state: {
                                        label: 'label.state'
                                    },
                                    physicalnetworkid: {
                                        label: 'label.physical.network.ID'
                                    },
                                    destinationphysicalnetworkid: {
                                        label: 'label.destination.physical.network.id'
                                    },
                                    supportedServices: {
                                        label: 'label.supported.services'
                                    }
                                }],
                                dataProvider: function (args) {
                                    refreshNspData("VirtualRouter");
                                    args.response.success({
                                        actionFilter: virtualRouterProviderActionFilter,
                                        data: $.extend(nspMap[ "virtualRouter"], {
                                            supportedServices: nspMap[ "virtualRouter"].servicelist.join(', ')
                                        })
                                    });
                                }
                            },

                            instances: {
                                title: 'label.instances',
                                listView: {
                                    label: 'label.virtual.appliances',
                                    id: 'routers',
                                    fields: {
                                        name: {
                                            label: 'label.name'
                                        },
                                        zonename: {
                                            label: 'label.zone'
                                        },
                                        routerType: {
                                            label: 'label.type'
                                        },
                                        state: {
                                            converter: function (str) {
                                                // For localization
                                                return str;
                                            },
                                            label: 'label.status',
                                            indicator: {
                                                'Running': 'on',
                                                'Stopped': 'off',
                                                'Error': 'off'
                                            }
                                        }
                                    },
                                    dataProvider: function (args) {
                                        var array1 =[];
                                        if (args.filterBy != null) {
                                            if (args.filterBy.search != null && args.filterBy.search.by != null && args.filterBy.search.value != null) {
                                                switch (args.filterBy.search.by) {
                                                    case "name":
                                                    if (args.filterBy.search.value.length > 0)
                                                    array1.push("&keyword=" + args.filterBy.search.value);
                                                    break;
                                                }
                                            }
                                        }

                                        var data2 = {
                                            forvpc: false
                                        };
                                        var routers =[];
                                        $.ajax({
                                            url: createURL("listRouters&zoneid=" + selectedZoneObj.id + "&listAll=true&page=" + args.page + "&pagesize=" + pageSize + array1.join("")),
                                            data: data2,
                                            success: function (json) {
                                                var items = json.listroutersresponse.router ?
                                                json.listroutersresponse.router:[];

                                                $(items).map(function (index, item) {
                                                    routers.push(item);
                                                });

                                                /*
                                                 * In project view, the first listRotuers API(without projectid=-1) will return the same objects as the second listRouters API(with projectid=-1),
                                                 * because in project view, all API calls are appended with projectid=[projectID].
                                                 * Therefore, we only call the second listRouters API(with projectid=-1) in non-project view.
                                                 */
                                                if (cloudStack.context && cloudStack.context.projects == null) { //non-project view
                                                $.ajax({
                                                    url: createURL("listRouters&zoneid=" + selectedZoneObj.id + "&page=" + args.page + "&pagesize=" + pageSize + array1.join("") + "&projectid=-1"),
                                                    data: data2,
                                                        async: false,
                                                    success: function (json) {
                                                        var items = json.listroutersresponse.router ?
                                                        json.listroutersresponse.router:[];

                                                        $(items).map(function (index, item) {
                                                            routers.push(item);
                                                        });
                                                        }
                                                    });
                                                }

                                                        args.response.success({
                                                            actionFilter: routerActionfilter,
                                                            data: $(routers).map(mapRouterType)
                                                        });
                                                    }
                                                });
                                    },
                                    detailView: {
                                        name: 'label.virtual.appliance.details',
                                        actions: {
                                            start: {
                                                label: 'label.action.start.router',
                                                messages: {
                                                    confirm: function (args) {
                                                        return 'message.action.start.router';
                                                    },
                                                    notification: function (args) {
                                                        return 'label.action.start.router';
                                                    }
                                                },
                                                action: function (args) {
                                                    $.ajax({
                                                        url: createURL('startRouter&id=' + args.context.routers[0].id),
                                                        dataType: 'json',
                                                        async: true,
                                                        success: function (json) {
                                                            var jid = json.startrouterresponse.jobid;
                                                            args.response.success({
                                                                _custom: {
                                                                    jobId: jid,
                                                                    getUpdatedItem: function (json) {
                                                                        return json.queryasyncjobresultresponse.jobresult.router;
                                                                    },
                                                                    getActionFilter: function () {
                                                                        return routerActionfilter;
                                                                    }
                                                                }
                                                            });
                                                        }
                                                    });
                                                },
                                                notification: {
                                                    poll: pollAsyncJobResult
                                                }
                                            },

                                            stop: {
                                                label: 'label.action.stop.router',
                                                createForm: {
                                                    title: 'label.action.stop.router',
                                                    desc: 'message.action.stop.router',
                                                    fields: {
                                                        forced: {
                                                            label: 'force.stop',
                                                            isBoolean: true,
                                                            isChecked: false
                                                        }
                                                    }
                                                },
                                                messages: {
                                                    notification: function (args) {
                                                        return 'label.action.stop.router';
                                                    }
                                                },
                                                action: function (args) {
                                                    var array1 =[];
                                                    array1.push("&forced=" + (args.data.forced == "on"));
                                                    $.ajax({
                                                        url: createURL('stopRouter&id=' + args.context.routers[0].id + array1.join("")),
                                                        dataType: 'json',
                                                        async: true,
                                                        success: function (json) {
                                                            var jid = json.stoprouterresponse.jobid;
                                                            args.response.success({
                                                                _custom: {
                                                                    jobId: jid,
                                                                    getUpdatedItem: function (json) {
                                                                        return json.queryasyncjobresultresponse.jobresult.router;
                                                                    },
                                                                    getActionFilter: function () {
                                                                        return routerActionfilter;
                                                                    }
                                                                }
                                                            });
                                                        }
                                                    });
                                                },
                                                notification: {
                                                    poll: pollAsyncJobResult
                                                }
                                            },

                                            'remove': {
                                                label: 'label.destroy.router',
                                                messages: {
                                                    confirm: function (args) {
                                                        if (args && args.context && args.context.routers[0]) {
                                                            if (args.context.routers[0].state == 'Running') {
                                                                return dictionary['message.action.stop.router'] + ' ' + dictionary['message.confirm.destroy.router'];
                                                            }
                                                        }
                                                        return 'message.confirm.destroy.router';
                                                    },
                                                    notification: function (args) {
                                                        return 'label.destroy.router';
                                                    }
                                                },
                                                action: function (args) {
                                                    $.ajax({
                                                        url: createURL("destroyRouter&id=" + args.context.routers[0].id),
                                                        dataType: "json",
                                                        async: true,
                                                        success: function (json) {
                                                            var jid = json.destroyrouterresponse.jobid;
                                                            args.response.success({
                                                                _custom: {
                                                                    jobId: jid
                                                                }
                                                            });
                                                        }
                                                    });
                                                },
                                                notification: {
                                                    poll: pollAsyncJobResult
                                                }
                                            },

                                            migrate: {
                                                label: 'label.action.migrate.router',
                                                createForm: {
                                                    title: 'label.action.migrate.router',
                                                    desc: '',
                                                    fields: {
                                                        hostId: {
                                                            label: 'label.host',
                                                            validation: {
                                                                required: true
                                                            },
                                                            select: function (args) {
                                                                $.ajax({
                                                                    url: createURL("findHostsForMigration&VirtualMachineId=" + args.context.routers[0].id),
                                                                    dataType: "json",
                                                                    async: true,
                                                                    success: function (json) {
                                                                        var hostObjs = json.findhostsformigrationresponse.host;
                                                                        var items =[];
                                                                        $(hostObjs).each(function () {
                                                                            items.push({
                                                                                id: this.id,
                                                                                description: (this.name + " (" + (this.suitableformigration ? "Suitable": "Not Suitable") + ")")
                                                                            });
                                                                        });
                                                                        args.response.success({
                                                                            data: items
                                                                        });
                                                                    }
                                                                });
                                                            },
                                                            error: function (XMLHttpResponse) {
                                                                var errorMsg = parseXMLHttpResponse(XMLHttpResponse);
                                                                args.response.error(errorMsg);
                                                            }
                                                        }
                                                    }
                                                },
                                                messages: {
                                                    notification: function (args) {
                                                        return 'label.action.migrate.router';
                                                    }
                                                },
                                                action: function (args) {
                                                    $.ajax({
                                                        url: createURL("migrateSystemVm&hostid=" + args.data.hostId + "&virtualmachineid=" + args.context.routers[0].id),
                                                        dataType: "json",
                                                        async: true,
                                                        success: function (json) {
                                                            var jid = json.migratesystemvmresponse.jobid;
                                                            args.response.success({
                                                                _custom: {
                                                                    jobId: jid,
                                                                    getUpdatedItem: function (json) {
                                                                        //return json.queryasyncjobresultresponse.jobresult.systemvminstance;    //not all properties returned in systemvminstance
                                                                        $.ajax({
                                                                            url: createURL("listRouters&id=" + json.queryasyncjobresultresponse.jobresult.systemvm.id),
                                                                            dataType: "json",
                                                                            async: false,
                                                                            success: function (json) {
                                                                                var items = json.listroutersresponse.router;
                                                                                if (items != null && items.length > 0) {
                                                                                    return items[0];
                                                                                }
                                                                            }
                                                                        });
                                                                    },
                                                                    getActionFilter: function () {
                                                                        return routerActionfilter;
                                                                    }
                                                                }
                                                            });
                                                        }
                                                    });
                                                },
                                                notification: {
                                                    poll: pollAsyncJobResult
                                                }
                                            },

                                            viewConsole: {
                                                label: 'label.view.console',
                                                action: {
                                                    externalLink: {
                                                        url: function (args) {
                                                            return clientConsoleUrl + '?cmd=access&vm=' + args.context.routers[0].id;
                                                        },
                                                        title: function (args) {
                                                            return args.context.routers[0].id.substr(0, 8);
                                                            //title in window.open() can't have space nor longer than 8 characters. Otherwise, IE browser will have error.
                                                        },
                                                        width: 820,
                                                        height: 640
                                                    }
                                                }
                                            }
                                        },
                                        tabs: {
                                            details: {
                                                title: 'label.details',
                                                preFilter: function (args) {
                                                    var hiddenFields =[];
                                                    if (! args.context.routers[0].project) {
                                                        hiddenFields.push('project');
                                                        hiddenFields.push('projectid');
                                                    }
                                                    if (selectedZoneObj.networktype == 'Basic') {
                                                        hiddenFields.push('publicip');
                                                        //In Basic zone, guest IP is public IP. So, publicip is not returned by listRouters API. Only guestipaddress is returned by listRouters API.
                                                    }

                                                    if ('routers' in args.context && args.context.routers[0].vpcid != undefined) {
                                                        hiddenFields.push('guestnetworkid');
                                                        hiddenFields.push('guestnetworkname');
                                                    } else if ('routers' in args.context && args.context.routers[0].guestnetworkid != undefined) {
                                                        hiddenFields.push('vpcid');
                                                        hiddenFields.push('vpcname');
                                                    }

                                                    return hiddenFields;
                                                },
                                                fields:[ {
                                                    name: {
                                                        label: 'label.name'
                                                    },
                                                    project: {
                                                        label: 'label.project'
                                                    }
                                                },
                                                {
                                                    id: {
                                                        label: 'label.id'
                                                    },
                                                    projectid: {
                                                        label: 'label.project.id'
                                                    },
                                                    state: {
                                                        label: 'label.state'
                                                    },
                                                    guestnetworkid: {
                                                        label: 'label.network.id'
                                                    },
                                                    guestnetworkname: {
                                                        label: 'label.network.name'
                                                    },
                                                    vpcid: {
                                                        label: 'label.vpc.id'
                                                    },
                                                    vpcname: {
                                                        label: 'label.vpc'
                                                    },
                                                    publicip: {
                                                        label: 'label.public.ip'
                                                    },
                                                    guestipaddress: {
                                                        label: 'label.guest.ip'
                                                    },
                                                    linklocalip: {
                                                        label: 'label.linklocal.ip'
                                                    },
                                                    hostname: {
                                                        label: 'label.host'
                                                    },
                                                    serviceofferingname: {
                                                        label: 'label.compute.offering'
                                                    },
                                                    networkdomain: {
                                                        label: 'label.network.domain'
                                                    },
                                                    domain: {
                                                        label: 'label.domain'
                                                    },
                                                    account: {
                                                        label: 'label.account'
                                                    },
                                                    created: {
                                                        label: 'label.created',
                                                        converter: cloudStack.converters.toLocalDate
                                                    },
                                                    isredundantrouter: {
                                                        label: 'label.redundant.router',
                                                        converter: cloudStack.converters.toBooleanText
                                                    },
                                                    redundantRouterState: {
                                                        label: 'label.redundant.state'
                                                    }
                                                }],
                                                dataProvider: function (args) {
                                                    $.ajax({
                                                        url: createURL("listRouters&id=" + args.context.routers[0].id),
                                                        dataType: 'json',
                                                        async: true,
                                                        success: function (json) {
                                                            var jsonObj = json.listroutersresponse.router[0];
                                                            addExtraPropertiesToRouterInstanceObject(jsonObj);
                                                            args.response.success({
                                                                actionFilter: routerActionfilter,
                                                                data: jsonObj
                                                            });
                                                        }
                                                    });
                                                }
                                            },
                                            nics: {
                                                title: 'label.nics',
                                                multiple: true,
                                                fields:[ {
                                                    name: {
                                                        label: 'label.name',
                                                        header: true
                                                    },
                                                    type: {
                                                        label: 'label.type'
                                                    },
                                                    traffictype: {
                                                        label: 'label.traffic.type'
                                                    },
                                                    networkname: {
                                                        label: 'label.network.name'
                                                    },
                                                    netmask: {
                                                        label: 'label.netmask'
                                                    },
                                                    ipaddress: {
                                                        label: 'label.ip.address'
                                                    },
                                                    id: {
                                                        label: 'label.id'
                                                    },
                                                    networkid: {
                                                        label: 'label.network.id'
                                                    },
                                                    isolationuri: {
                                                        label: 'label.isolation.uri'
                                                    },
                                                    broadcasturi: {
                                                        label: 'label.broadcast.uri'
                                                    }
                                                }],
                                                dataProvider: function (args) {
                                                    $.ajax({
                                                        url: createURL("listRouters&id=" + args.context.routers[0].id),
                                                        dataType: 'json',
                                                        async: true,
                                                        success: function (json) {
                                                            var jsonObj = json.listroutersresponse.router[0].nic;

                                                            args.response.success({
                                                                actionFilter: routerActionfilter,
                                                                data: $.map(jsonObj, function (nic, index) {
                                                                    var name = 'NIC ' + (index + 1);
                                                                    if (nic.isdefault) {
                                                                        name += ' (' + _l('label.default') + ')';
                                                                    }
                                                                    return $.extend(nic, {
                                                                        name: name
                                                                    });
                                                                })
                                                            });
                                                        }
                                                    });
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        },
                        actions: {
                            enable: {
                                label: 'label.enable.provider',
                                action: function (args) {
                                    $.ajax({
                                        url: createURL("updateNetworkServiceProvider&id=" + nspMap[ "virtualRouter"].id + "&state=Enabled"),
                                        dataType: "json",
                                        success: function (json) {
                                            var jid = json.updatenetworkserviceproviderresponse.jobid;
                                            args.response.success({
                                                _custom: {
                                                    jobId: jid,
                                                    getUpdatedItem: function (json) {
                                                        $(window).trigger('cloudStack.fullRefresh');
                                                    }
                                                }
                                            });
                                        }
                                    });
                                },
                                messages: {
                                    confirm: function (args) {
                                        return 'message.confirm.enable.provider';
                                    },
                                    notification: function () {
                                        return 'label.enable.provider';
                                    }
                                },
                                notification: {
                                    poll: pollAsyncJobResult
                                }
                            },
                            disable: {
                                label: 'label.disable.provider',
                                action: function (args) {
                                    $.ajax({
                                        url: createURL("updateNetworkServiceProvider&id=" + nspMap[ "virtualRouter"].id + "&state=Disabled"),
                                        dataType: "json",
                                        success: function (json) {
                                            var jid = json.updatenetworkserviceproviderresponse.jobid;
                                            args.response.success({
                                                _custom: {
                                                    jobId: jid,
                                                    getUpdatedItem: function (json) {
                                                        $(window).trigger('cloudStack.fullRefresh');
                                                    }
                                                }
                                            });
                                        }
                                    });
                                },
                                messages: {
                                    confirm: function (args) {
                                        return 'message.confirm.disable.provider';
                                    },
                                    notification: function () {
                                        return 'label.disable.provider';
                                    }
                                },
                                notification: {
                                    poll: pollAsyncJobResult
                                }
                            }
                        }
                    },

                    InternalLbVm: {
                        id: 'InternalLbVm',
                        label: 'label.internallbvm',
                        isMaximized: true,
                        type: 'detailView',
                        fields: {
                            name: {
                                label: 'label.name'
                            },
                            ipaddress: {
                                label: 'label.ip.address'
                            },
                            state: {
                                label: 'label.status',
                                indicator: {
                                    'Enabled': 'on'
                                }
                            }
                        },
                        tabs: {
                            network: {
                                title: 'label.network',
                                fields:[ {
                                    name: {
                                        label: 'label.name'
                                    }
                                },
                                {
                                    id: {
                                        label: 'label.id'
                                    },
                                    state: {
                                        label: 'label.state'
                                    },
                                    physicalnetworkid: {
                                        label: 'label.physical.network.ID'
                                    },
                                    destinationphysicalnetworkid: {
                                        label: 'label.destination.physical.network.id'
                                    },
                                    supportedServices: {
                                        label: 'label.supported.services'
                                    }
                                }],
                                dataProvider: function (args) {
                                    refreshNspData("InternalLbVm");
                                    args.response.success({
                                        actionFilter: virtualRouterProviderActionFilter,
                                        data: $.extend(nspMap[ "InternalLbVm"], {
                                            supportedServices: nspMap[ "InternalLbVm"].servicelist.join(', ')
                                        })
                                    });
                                }
                            },

                            instances: {
                                title: 'label.instances',
                                listView: {
                                    label: 'label.virtual.appliances',
                                    id: 'internallbinstances',
                                    fields: {
                                        name: {
                                            label: 'label.name'
                                        },
                                        zonename: {
                                            label: 'label.zone'
                                        },
                                        routerType: {
                                            label: 'label.type'
                                        },
                                        state: {
                                            converter: function (str) {
                                                // For localization
                                                return str;
                                            },
                                            label: 'label.status',
                                            indicator: {
                                                'Running': 'on',
                                                'Stopped': 'off',
                                                'Error': 'off'
                                            }
                                        }
                                    },
                                    dataProvider: function (args) {
                                        var array1 =[];
                                        if (args.filterBy != null) {
                                            if (args.filterBy.search != null && args.filterBy.search.by != null && args.filterBy.search.value != null) {
                                                switch (args.filterBy.search.by) {
                                                    case "name":
                                                    if (args.filterBy.search.value.length > 0)
                                                    array1.push("&keyword=" + args.filterBy.search.value);
                                                    break;
                                                }
                                            }
                                        }

                                        var routers =[];
                                        $.ajax({
                                            url: createURL("listInternalLoadBalancerVMs&zoneid=" + selectedZoneObj.id + "&listAll=true&page=" + args.page + "&pagesize=" + pageSize + array1.join("")),
                                            success: function (json) {
                                                var items = json.listinternallbvmsresponse.internalloadbalancervm ?
                                                json.listinternallbvmsresponse.internalloadbalancervm:[];

                                                $(items).map(function (index, item) {
                                                    routers.push(item);
                                                });

                                                // Get project routers
                                                $.ajax({
                                                    url: createURL("listInternalLoadBalancerVMs&zoneid=" + selectedZoneObj.id + "&page=" + args.page + "&pagesize=" + pageSize + array1.join("") + "&projectid=-1"),
                                                    success: function (json) {
                                                        var items = json.listinternallbvmsresponse.internalloadbalancervm ?
                                                        json.listinternallbvmsresponse.internalloadbalancervm:[];

                                                        $(items).map(function (index, item) {
                                                            routers.push(item);
                                                        });
                                                        args.response.success({
                                                            actionFilter: internallbinstanceActionfilter,
                                                            data: $(routers).map(mapRouterType)
                                                        });
                                                    }
                                                });
                                            }
                                        });
                                    },
                                    detailView: {
                                        name: 'label.virtual.appliance.details',
                                        actions: {
                                            start: {
                                                label: 'label.start.lb.vm',
                                                messages: {
                                                    confirm: function (args) {
                                                        return 'message.confirm.start.lb.vm';
                                                    },
                                                    notification: function (args) {
                                                        return 'label.start.lb.vm';
                                                    }
                                                },
                                                action: function (args) {
                                                    $.ajax({
                                                        url: createURL('startInternalLoadBalancerVM&id=' + args.context.internallbinstances[0].id),
                                                        dataType: 'json',
                                                        async: true,
                                                        success: function (json) {
                                                            var jid = json.startinternallbvmresponse.jobid;
                                                            args.response.success({
                                                                _custom: {
                                                                    jobId: jid,
                                                                    getUpdatedItem: function (json) {
                                                                        return json.queryasyncjobresultresponse.jobresult.internalloadbalancervm;
                                                                    },
                                                                    getActionFilter: function () {
                                                                        return internallbinstanceActionfilter;
                                                                    }
                                                                }
                                                            });
                                                        }
                                                    });
                                                },
                                                notification: {
                                                    poll: pollAsyncJobResult
                                                }
                                            },

                                            stop: {
                                                label: 'label.stop.lb.vm',
                                                createForm: {
                                                    title: 'message.confirm.stop.lb.vm',
                                                    desc: 'label.stop.lb.vm',
                                                    fields: {
                                                        forced: {
                                                            label: 'force.stop',
                                                            isBoolean: true,
                                                            isChecked: false
                                                        }
                                                    }
                                                },
                                                messages: {
                                                    notification: function (args) {
                                                        return 'label.stop.lb.vm';
                                                    }
                                                },
                                                action: function (args) {
                                                    var array1 =[];
                                                    array1.push("&forced=" + (args.data.forced == "on"));
                                                    $.ajax({
                                                        url: createURL('stopInternalLoadBalancerVM&id=' + args.context.internallbinstances[0].id + array1.join("")),
                                                        dataType: 'json',
                                                        async: true,
                                                        success: function (json) {
                                                            var jid = json.stopinternallbvmresponse.jobid;
                                                            args.response.success({
                                                                _custom: {
                                                                    jobId: jid,
                                                                    getUpdatedItem: function (json) {
                                                                        return json.queryasyncjobresultresponse.jobresult.internalloadbalancervm;
                                                                    },
                                                                    getActionFilter: function () {
                                                                        return internallbinstanceActionfilter;
                                                                    }
                                                                }
                                                            });
                                                        }
                                                    });
                                                },
                                                notification: {
                                                    poll: pollAsyncJobResult
                                                }
                                            },

                                            migrate: {
                                                label: 'label.migrate.lb.vm',
                                                createForm: {
                                                    title: 'label.migrate.lb.vm',
                                                    fields: {
                                                        hostId: {
                                                            label: 'label.host',
                                                            validation: {
                                                                required: true
                                                            },
                                                            select: function (args) {
                                                                $.ajax({
                                                                    url: createURL("findHostsForMigration&VirtualMachineId=" + args.context.internallbinstances[0].id),
                                                                    dataType: "json",
                                                                    async: true,
                                                                    success: function (json) {
                                                                        var hostObjs = json.findhostsformigrationresponse.host;
                                                                        var items =[];
                                                                        $(hostObjs).each(function () {
                                                                            items.push({
                                                                                id: this.id,
                                                                                description: (this.name + " (" + (this.suitableformigration ? "Suitable": "Not Suitable") + ")")
                                                                            });
                                                                        });
                                                                        args.response.success({
                                                                            data: items
                                                                        });
                                                                    }
                                                                });
                                                            },
                                                            error: function (XMLHttpResponse) {
                                                                var errorMsg = parseXMLHttpResponse(XMLHttpResponse);
                                                                args.response.error(errorMsg);
                                                            }
                                                        }
                                                    }
                                                },
                                                messages: {
                                                    notification: function (args) {
                                                        return 'label.migrate.lb.vm';
                                                    }
                                                },
                                                action: function (args) {
                                                    $.ajax({
                                                        url: createURL("migrateSystemVm&hostid=" + args.data.hostId + "&virtualmachineid=" + args.context.internallbinstances[0].id),
                                                        dataType: "json",
                                                        async: true,
                                                        success: function (json) {
                                                            var jid = json.migratesystemvmresponse.jobid;
                                                            args.response.success({
                                                                _custom: {
                                                                    jobId: jid,
                                                                    getUpdatedItem: function (json) {
                                                                        //return json.queryasyncjobresultresponse.jobresult.systemvminstance;    //not all properties returned in systemvminstance
                                                                        $.ajax({
                                                                            url: createURL("listInternalLoadBalancerVMs&id=" + json.queryasyncjobresultresponse.jobresult.systemvm.id),
                                                                            dataType: "json",
                                                                            async: false,
                                                                            success: function (json) {
                                                                                var items = json.listinternallbvmsresponse.internalloadbalancervm;
                                                                                if (items != null && items.length > 0) {
                                                                                    return items[0];
                                                                                }
                                                                            }
                                                                        });
                                                                    },
                                                                    getActionFilter: function () {
                                                                        return internallbinstanceActionfilter;
                                                                    }
                                                                }
                                                            });
                                                        }
                                                    });
                                                },
                                                notification: {
                                                    poll: pollAsyncJobResult
                                                }
                                            },

                                            viewConsole: {
                                                label: 'label.view.console',
                                                action: {
                                                    externalLink: {
                                                        url: function (args) {
                                                            return clientConsoleUrl + '?cmd=access&vm=' + args.context.internallbinstances[0].id;
                                                        },
                                                        title: function (args) {
                                                            return args.context.internallbinstances[0].id.substr(0, 8);
                                                            //title in window.open() can't have space nor longer than 8 characters. Otherwise, IE browser will have error.
                                                        },
                                                        width: 820,
                                                        height: 640
                                                    }
                                                }
                                            }
                                        },
                                        tabs: {
                                            details: {
                                                title: 'label.details',
                                                preFilter: function (args) {
                                                    var hiddenFields =[];
                                                    if (! args.context.internallbinstances[0].project) {
                                                        hiddenFields.push('project');
                                                        hiddenFields.push('projectid');
                                                    }
                                                    if (selectedZoneObj.networktype == 'Basic') {
                                                        hiddenFields.push('publicip');
                                                        //In Basic zone, guest IP is public IP. So, publicip is not returned by listRouters API. Only guestipaddress is returned by listRouters API.
                                                    }

                                                    if ('routers' in args.context && args.context.routers[0].vpcid != undefined) {
                                                        hiddenFields.push('guestnetworkid');
                                                        hiddenFields.push('guestnetworkname');
                                                    } else if ('routers' in args.context && args.context.routers[0].guestnetworkid != undefined) {
                                                        hiddenFields.push('vpcid');
                                                        hiddenFields.push('vpcname');
                                                    }

                                                    return hiddenFields;
                                                },
                                                fields:[ {
                                                    name: {
                                                        label: 'label.name'
                                                    },
                                                    project: {
                                                        label: 'label.project'
                                                    }
                                                },
                                                {
                                                    id: {
                                                        label: 'label.id'
                                                    },
                                                    projectid: {
                                                        label: 'label.project.id'
                                                    },
                                                    state: {
                                                        label: 'label.state'
                                                    },
                                                    guestnetworkid: {
                                                        label: 'label.network.id'
                                                    },
                                                    guestnetworkname: {
                                                        label: 'label.network.name'
                                                    },
                                                    vpcid: {
                                                        label: 'label.vpc.id'
                                                    },
                                                    vpcname: {
                                                        label: 'label.vpc'
                                                    },
                                                    publicip: {
                                                        label: 'label.public.ip'
                                                    },
                                                    guestipaddress: {
                                                        label: 'label.guest.ip'
                                                    },
                                                    linklocalip: {
                                                        label: 'label.linklocal.ip'
                                                    },
                                                    hostname: {
                                                        label: 'label.host'
                                                    },
                                                    serviceofferingname: {
                                                        label: 'label.compute.offering'
                                                    },
                                                    networkdomain: {
                                                        label: 'label.network.domain'
                                                    },
                                                    domain: {
                                                        label: 'label.domain'
                                                    },
                                                    account: {
                                                        label: 'label.account'
                                                    },
                                                    created: {
                                                        label: 'label.created',
                                                        converter: cloudStack.converters.toLocalDate
                                                    },
                                                    isredundantrouter: {
                                                        label: 'label.redundant.router',
                                                        converter: cloudStack.converters.toBooleanText
                                                    },
                                                    redundantRouterState: {
                                                        label: 'label.redundant.state'
                                                    }
                                                }],
                                                dataProvider: function (args) {
                                                    $.ajax({
                                                        url: createURL("listInternalLoadBalancerVMs&id=" + args.context.internallbinstances[0].id),
                                                        dataType: 'json',
                                                        async: true,
                                                        success: function (json) {
                                                            var jsonObj = json.listinternallbvmsresponse.internalloadbalancervm[0];
                                                            addExtraPropertiesToRouterInstanceObject(jsonObj);
                                                            args.response.success({
                                                                actionFilter: internallbinstanceActionfilter,
                                                                data: jsonObj
                                                            });
                                                        }
                                                    });
                                                }
                                            },
                                            nics: {
                                                title: 'label.nics',
                                                multiple: true,
                                                fields:[ {
                                                    name: {
                                                        label: 'label.name',
                                                        header: true
                                                    },
                                                    type: {
                                                        label: 'label.type'
                                                    },
                                                    traffictype: {
                                                        label: 'label.traffic.type'
                                                    },
                                                    networkname: {
                                                        label: 'label.network.name'
                                                    },
                                                    netmask: {
                                                        label: 'label.netmask'
                                                    },
                                                    ipaddress: {
                                                        label: 'label.ip.address'
                                                    },
                                                    id: {
                                                        label: 'label.id'
                                                    },
                                                    networkid: {
                                                        label: 'label.network.id'
                                                    },
                                                    isolationuri: {
                                                        label: 'label.isolation.uri'
                                                    },
                                                    broadcasturi: {
                                                        label: 'label.broadcast.uri'
                                                    }
                                                }],
                                                dataProvider: function (args) {
                                                    $.ajax({
                                                        url: createURL("listInternalLoadBalancerVMs&id=" + args.context.internallbinstances[0].id),
                                                        dataType: 'json',
                                                        async: true,
                                                        success: function (json) {
                                                            var jsonObj = json.listinternallbvmsresponse.internalloadbalancervm[0].nic;

                                                            args.response.success({
                                                                actionFilter: internallbinstanceActionfilter,
                                                                data: $.map(jsonObj, function (nic, index) {
                                                                    var name = 'NIC ' + (index + 1);
                                                                    if (nic.isdefault) {
                                                                        name += ' (' + _l('label.default') + ')';
                                                                    }
                                                                    return $.extend(nic, {
                                                                        name: name
                                                                    });
                                                                })
                                                            });
                                                        }
                                                    });
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        },
                        actions: {
                            enable: {
                                label: 'label.enable.provider',
                                action: function (args) {
                                    $.ajax({
                                        url: createURL("updateNetworkServiceProvider&id=" + nspMap[ "InternalLbVm"].id + "&state=Enabled"),
                                        dataType: "json",
                                        success: function (json) {
                                            var jid = json.updatenetworkserviceproviderresponse.jobid;
                                            args.response.success({
                                                _custom: {
                                                    jobId: jid,
                                                    getUpdatedItem: function (json) {
                                                        $(window).trigger('cloudStack.fullRefresh');
                                                    }
                                                }
                                            });
                                        }
                                    });
                                },
                                messages: {
                                    confirm: function (args) {
                                        return 'message.confirm.enable.provider';
                                    },
                                    notification: function () {
                                        return 'label.enable.provider';
                                    }
                                },
                                notification: {
                                    poll: pollAsyncJobResult
                                }
                            },
                            disable: {
                                label: 'label.disable.provider',
                                action: function (args) {
                                    $.ajax({
                                        url: createURL("updateNetworkServiceProvider&id=" + nspMap[ "InternalLbVm"].id + "&state=Disabled"),
                                        dataType: "json",
                                        success: function (json) {
                                            var jid = json.updatenetworkserviceproviderresponse.jobid;
                                            args.response.success({
                                                _custom: {
                                                    jobId: jid,
                                                    getUpdatedItem: function (json) {
                                                        $(window).trigger('cloudStack.fullRefresh');
                                                    }
                                                }
                                            });
                                        }
                                    });
                                },
                                messages: {
                                    confirm: function (args) {
                                        return 'message.confirm.disable.provider';
                                    },
                                    notification: function () {
                                        return 'label.disable.provider';
                                    }
                                },
                                notification: {
                                    poll: pollAsyncJobResult
                                }
                            }
                        }
                    },

                    vpcVirtualRouter: {
                        id: 'vpcVirtualRouterProviders',
                        label: 'label.vpc.virtual.router',
                        isMaximized: true,
                        type: 'detailView',
                        fields: {
                            name: {
                                label: 'label.name'
                            },
                            ipaddress: {
                                label: 'label.ip.address'
                            },
                            state: {
                                label: 'label.status',
                                indicator: {
                                    'Enabled': 'on'
                                }
                            }
                        },
                        tabs: {
                            network: {
                                title: 'label.network',
                                fields:[ {
                                    name: {
                                        label: 'label.name'
                                    }
                                },
                                {
                                    id: {
                                        label: 'label.id'
                                    },
                                    state: {
                                        label: 'label.state'
                                    },
                                    physicalnetworkid: {
                                        label: 'label.physical.network.ID'
                                    },
                                    destinationphysicalnetworkid: {
                                        label: 'label.destination.physical.network.id'
                                    },
                                    supportedServices: {
                                        label: 'label.supported.services'
                                    }
                                }],
                                dataProvider: function (args) {
                                    refreshNspData("VpcVirtualRouter");
                                    args.response.success({
                                        actionFilter: virtualRouterProviderActionFilter,
                                        data: $.extend(nspMap[ "vpcVirtualRouter"], {
                                            supportedServices: nspMap[ "vpcVirtualRouter"].servicelist.join(', ')
                                        })
                                    });
                                }
                            },

                            instances: {
                                title: 'label.instances',
                                listView: {
                                    label: 'label.virtual.appliances',
                                    id: 'routers',
                                    fields: {
                                        name: {
                                            label: 'label.name'
                                        },
                                        zonename: {
                                            label: 'label.zone'
                                        },
                                        routerType: {
                                            label: 'label.type'
                                        },
                                        state: {
                                            converter: function (str) {
                                                // For localization
                                                return str;
                                            },
                                            label: 'label.status',
                                            indicator: {
                                                'Running': 'on',
                                                'Stopped': 'off',
                                                'Error': 'off'
                                            }
                                        }
                                    },
                                    dataProvider: function (args) {
                                        var array1 =[];
                                        if (args.filterBy != null) {
                                            if (args.filterBy.search != null && args.filterBy.search.by != null && args.filterBy.search.value != null) {
                                                switch (args.filterBy.search.by) {
                                                    case "name":
                                                    if (args.filterBy.search.value.length > 0)
                                                    array1.push("&keyword=" + args.filterBy.search.value);
                                                    break;
                                                }
                                            }
                                        }

                                        var data2 = {
                                            forvpc: true
                                        };
                                        var routers =[];
                                        $.ajax({
                                            url: createURL("listRouters&zoneid=" + selectedZoneObj.id + "&listAll=true&page=" + args.page + "&pagesize=" + pageSize + array1.join("")),
                                            dataType: 'json',
                                            data: data2,
                                            async: true,
                                            success: function (json) {
                                                var items = json.listroutersresponse.router;
                                                $(items).map(function (index, item) {
                                                    routers.push(item);
                                                });

                                                /*
                                                 * In project view, the first listRotuers API(without projectid=-1) will return the same objects as the second listRouters API(with projectid=-1),
                                                 * because in project view, all API calls are appended with projectid=[projectID].
                                                 * Therefore, we only call the second listRouters API(with projectid=-1) in non-project view.
                                                 */
                                                if (cloudStack.context && cloudStack.context.projects == null) { //non-project view
                                                $.ajax({
                                                    url: createURL("listRouters&zoneid=" + selectedZoneObj.id + "&page=" + args.page + "&pagesize=" + pageSize + array1.join("") + "&projectid=-1"),
                                                    dataType: 'json',
                                                    data: data2,
                                                        async: false,
                                                    success: function (json) {
                                                        var items = json.listroutersresponse.router;
                                                        $(items).map(function (index, item) {
                                                            routers.push(item);
                                                        });
                                                        }
                                                    });
                                                }

                                                        args.response.success({
                                                            actionFilter: routerActionfilter,
                                                            data: $(routers).map(mapRouterType)
                                                        });
                                                    }
                                                });
                                    },
                                    detailView: {
                                        name: 'label.virtual.appliance.details',
                                        actions: {
                                            start: {
                                                label: 'label.action.start.router',
                                                messages: {
                                                    confirm: function (args) {
                                                        return 'message.action.start.router';
                                                    },
                                                    notification: function (args) {
                                                        return 'label.action.start.router';
                                                    }
                                                },
                                                action: function (args) {
                                                    $.ajax({
                                                        url: createURL('startRouter&id=' + args.context.routers[0].id),
                                                        dataType: 'json',
                                                        async: true,
                                                        success: function (json) {
                                                            var jid = json.startrouterresponse.jobid;
                                                            args.response.success({
                                                                _custom: {
                                                                    jobId: jid,
                                                                    getUpdatedItem: function (json) {
                                                                        return json.queryasyncjobresultresponse.jobresult.router;
                                                                    },
                                                                    getActionFilter: function () {
                                                                        return routerActionfilter;
                                                                    }
                                                                }
                                                            });
                                                        }
                                                    });
                                                },
                                                notification: {
                                                    poll: pollAsyncJobResult
                                                }
                                            },

                                            stop: {
                                                label: 'label.action.stop.router',
                                                createForm: {
                                                    title: 'label.action.stop.router',
                                                    desc: 'message.action.stop.router',
                                                    fields: {
                                                        forced: {
                                                            label: 'force.stop',
                                                            isBoolean: true,
                                                            isChecked: false
                                                        }
                                                    }
                                                },
                                                messages: {
                                                    notification: function (args) {
                                                        return 'label.action.stop.router';
                                                    }
                                                },
                                                action: function (args) {
                                                    var array1 =[];
                                                    array1.push("&forced=" + (args.data.forced == "on"));
                                                    $.ajax({
                                                        url: createURL('stopRouter&id=' + args.context.routers[0].id + array1.join("")),
                                                        dataType: 'json',
                                                        async: true,
                                                        success: function (json) {
                                                            var jid = json.stoprouterresponse.jobid;
                                                            args.response.success({
                                                                _custom: {
                                                                    jobId: jid,
                                                                    getUpdatedItem: function (json) {
                                                                        return json.queryasyncjobresultresponse.jobresult.router;
                                                                    },
                                                                    getActionFilter: function () {
                                                                        return routerActionfilter;
                                                                    }
                                                                }
                                                            });
                                                        }
                                                    });
                                                },
                                                notification: {
                                                    poll: pollAsyncJobResult
                                                }
                                            },

                                            restart: {
                                                label: 'label.action.reboot.router',
                                                messages: {
                                                    confirm: function (args) {
                                                        return 'message.action.reboot.router';
                                                    },
                                                    notification: function (args) {
                                                        return 'label.action.reboot.router';
                                                    }
                                                },
                                                action: function (args) {
                                                    $.ajax({
                                                        url: createURL('rebootRouter&id=' + args.context.routers[0].id),
                                                        dataType: 'json',
                                                        async: true,
                                                        success: function (json) {
                                                            var jid = json.rebootrouterresponse.jobid;
                                                            args.response.success({
                                                                _custom: {
                                                                    jobId: jid,
                                                                    getUpdatedItem: function (json) {
                                                                        return json.queryasyncjobresultresponse.jobresult.router;
                                                                    },
                                                                    getActionFilter: function () {
                                                                        return routerActionfilter;
                                                                    }
                                                                }
                                                            });
                                                        }
                                                    });
                                                },
                                                notification: {
                                                    poll: pollAsyncJobResult
                                                }
                                            },

                                            'remove': {
                                                label: 'label.destroy.router',
                                                messages: {
                                                    confirm: function (args) {
                                                        if (args && args.context && args.context.routers[0]) {
                                                            if (args.context.routers[0].state == 'Running') {
                                                                return dictionary['message.action.stop.router'] + ' ' + dictionary['message.confirm.destroy.router'];
                                                            }
                                                        }
                                                        return 'message.confirm.destroy.router';
                                                    },
                                                    notification: function (args) {
                                                        return 'label.destroy.router';
                                                    }
                                                },
                                                action: function (args) {
                                                    $.ajax({
                                                        url: createURL("destroyRouter&id=" + args.context.routers[0].id),
                                                        dataType: "json",
                                                        async: true,
                                                        success: function (json) {
                                                            var jid = json.destroyrouterresponse.jobid;
                                                            args.response.success({
                                                                _custom: {
                                                                    jobId: jid
                                                                }
                                                            });
                                                        }
                                                    });
                                                },
                                                notification: {
                                                    poll: pollAsyncJobResult
                                                }
                                            },

                                            migrate: {
                                                label: 'label.action.migrate.router',
                                                createForm: {
                                                    title: 'label.action.migrate.router',
                                                    desc: '',
                                                    fields: {
                                                        hostId: {
                                                            label: 'label.host',
                                                            validation: {
                                                                required: true
                                                            },
                                                            select: function (args) {
                                                                $.ajax({
                                                                    url: createURL("findHostsForMigration&VirtualMachineId=" + args.context.routers[0].id),
                                                                    dataType: "json",
                                                                    async: true,
                                                                    success: function (json) {
                                                                        var hostObjs = json.findhostsformigrationresponse.host;
                                                                        var items =[];
                                                                        $(hostObjs).each(function () {
                                                                            items.push({
                                                                                id: this.id,
                                                                                description: (this.name + " (" + (this.suitableformigration ? "Suitable": "Not Suitable") + ")")
                                                                            });
                                                                        });
                                                                        args.response.success({
                                                                            data: items
                                                                        });
                                                                    }
                                                                });
                                                            },
                                                            error: function (XMLHttpResponse) {
                                                                var errorMsg = parseXMLHttpResponse(XMLHttpResponse);
                                                                args.response.error(errorMsg);
                                                            }
                                                        }
                                                    }
                                                },
                                                messages: {
                                                    notification: function (args) {
                                                        return 'label.action.migrate.router';
                                                    }
                                                },
                                                action: function (args) {
                                                    $.ajax({
                                                        url: createURL("migrateSystemVm&hostid=" + args.data.hostId + "&virtualmachineid=" + args.context.routers[0].id),
                                                        dataType: "json",
                                                        async: true,
                                                        success: function (json) {
                                                            var jid = json.migratesystemvmresponse.jobid;
                                                            args.response.success({
                                                                _custom: {
                                                                    jobId: jid,
                                                                    getUpdatedItem: function (json) {
                                                                        //return json.queryasyncjobresultresponse.jobresult.systemvminstance;    //not all properties returned in systemvminstance
                                                                        $.ajax({
                                                                            url: createURL("listRouters&id=" + json.queryasyncjobresultresponse.jobresult.systemvm.id),
                                                                            dataType: "json",
                                                                            async: false,
                                                                            success: function (json) {
                                                                                var items = json.listroutersresponse.router;
                                                                                if (items != null && items.length > 0) {
                                                                                    return items[0];
                                                                                }
                                                                            }
                                                                        });
                                                                    },
                                                                    getActionFilter: function () {
                                                                        return routerActionfilter;
                                                                    }
                                                                }
                                                            });
                                                        }
                                                    });
                                                },
                                                notification: {
                                                    poll: pollAsyncJobResult
                                                }
                                            },

                                            diagnostics: {
                                                label: 'label.action.run.diagnostics',
                                                messages: {
                                                    notification: function (args) {
                                                        return 'label.action.run.diagnostics';
                                                    },
                                                    complete: function(args) {
                                                        var exitcode = _l('message.diagnostics.exitcode');
                                                        exitcode = exitcode.replace('var', args.exitcode);
                                                        var stderr = _l('message.diagnostics.stderr');
                                                        stderr = stderr.replace('var', args.stderr);
                                                        var stdout = _l('message.diagnostics.stdout');
                                                        stdout = stdout.replace('var', args.stdout);
                                                        var msg = "<div style='text-align: left; overflow-y: auto'>" + exitcode + "<br><br>" + stderr + "<br><br>" + stdout + "</div>";
                                                        return msg;
                                                    }
                                                },
                                                createForm: {
                                                    title: 'label.action.run.diagnostics',
                                                    desc: '',
                                                    fields: {
                                                        type: {
                                                            label: 'label.run.diagnostics.type',
                                                            validation: {
                                                                required: true
                                                            },
                                                            select: function (args) {
                                                                var items = [];
                                                                items.push({
                                                                    id: "ping",
                                                                    description: "Ping"
                                                                });
                                                                items.push({
                                                                    id: "traceroute",
                                                                    description: "Traceroute"
                                                                });
                                                                items.push({
                                                                    id: "arping",
                                                                    description: "Arping"
                                                                });
                                                                args.response.success({
                                                                    data: items
                                                                });
                                                            }
                                                        },
                                                        destination: {
                                                            label: 'label.run.diagnostics.destination',
                                                            validation: {
                                                                required: true
                                                            }
                                                        },
                                                        extra: {
                                                            label: 'label.run.diagnostics.extra'
                                                        }

                                                    }
                                                },
                                                action: function (args) {
                                                    $.ajax({
                                                        url: createURL("runDiagnostics&targetid=" + args.context.systemVMs[0].id + "&ipaddress=" + args.data.destination + "&type=" + args.data.type + "&params=" + args.data.extra),
                                                        dataType: "json",
                                                        async: true,
                                                        success: function(json) {
                                                            var jid = json.rundiagnosticsresponse.jobid;
                                                            args.response.success({
                                                                _custom: {
                                                                    jobId : jid,
                                                                    getUpdatedItem: function (json) {
                                                                        return json.queryasyncjobresultresponse.jobresult.diagnostics;

                                                                    },
                                                                    getActionFilter: function(){
                                                                        return systemvmActionfilter;
                                                                   }
                                                                }

                                                            });
                                                        }
                                                    }); //end ajax
                                                },
                                                notification: {
                                                    poll: pollAsyncJobResult
                                                }
                                            },

                                            retrieveDiagnostics: {
                                                label: 'label.action.get.diagnostics',
                                                messages: {
                                                    notification: function (args) {
                                                        return 'label.action.get.diagnostics';
                                                    },
                                                    complete: function(args) {
                                                        var url = args.url;
                                                        var htmlMsg = _l('message.download.diagnostics');
                                                        var htmlMsg2 = htmlMsg.replace(/#/, url).replace(/00000/, url);
                                                        return htmlMsg2;
                                                    }
                                                },
                                                createForm: {
                                                    title: 'label.action.get.diagnostics',
                                                    desc: 'label.get.diagnostics.desc',
                                                    fields: {
                                                        files: {
                                                            label: 'label.get.diagnostics.files'
                                                        }
                                                    }
                                                },
                                                action: function (args) {
                                                    $.ajax({
                                                        url: createURL("getDiagnosticsData&targetid=" + args.context.routers[0].id + "&files=" + args.data.files),
                                                        dataType: "json",
                                                        async: true,
                                                        success: function(json) {
                                                            var jid = json.getdiagnosticsdataresponse.jobid;
                                                            args.response.success({
                                                                _custom: {
                                                                    jobId : jid,
                                                                    getUpdatedItem: function (json) {
                                                                        return json.queryasyncjobresultresponse.jobresult.diagnostics;

                                                                    },
                                                                    getActionFilter: function(){
                                                                        return systemvmActionfilter;
                                                                   }
                                                                }

                                                            });
                                                        }
                                                    }); //end ajax
                                                },
                                                notification: {
                                                    poll: pollAsyncJobResult
                                                }
                                            },

                                            viewConsole: {
                                                label: 'label.view.console',
                                                action: {
                                                    externalLink: {
                                                        url: function (args) {
                                                            return clientConsoleUrl + '?cmd=access&vm=' + args.context.routers[0].id;
                                                        },
                                                        title: function (args) {
                                                            return args.context.routers[0].id.substr(0, 8);
                                                            //title in window.open() can't have space nor longer than 8 characters. Otherwise, IE browser will have error.
                                                        },
                                                        width: 820,
                                                        height: 640
                                                    }
                                                }
                                            }
                                        },
                                        tabs: {
                                            details: {
                                                title: 'label.details',
                                                preFilter: function (args) {
                                                    var hiddenFields =[];
                                                    if (! args.context.routers[0].project) {
                                                        hiddenFields.push('project');
                                                        hiddenFields.push('projectid');
                                                    }
                                                    if (selectedZoneObj.networktype == 'Basic') {
                                                        hiddenFields.push('publicip');
                                                        //In Basic zone, guest IP is public IP. So, publicip is not returned by listRouters API. Only guestipaddress is returned by listRouters API.
                                                    }
                                                    return hiddenFields;
                                                },
                                                fields:[ {
                                                    name: {
                                                        label: 'label.name'
                                                    },
                                                    project: {
                                                        label: 'label.project'
                                                    }
                                                },
                                                {
                                                    id: {
                                                        label: 'label.id'
                                                    },
                                                    projectid: {
                                                        label: 'label.project.id'
                                                    },
                                                    state: {
                                                        label: 'label.state'
                                                    },
                                                    publicip: {
                                                        label: 'label.public.ip'
                                                    },
                                                    guestipaddress: {
                                                        label: 'label.guest.ip'
                                                    },
                                                    linklocalip: {
                                                        label: 'label.linklocal.ip'
                                                    },
                                                    hostname: {
                                                        label: 'label.host'
                                                    },
                                                    serviceofferingname: {
                                                        label: 'label.compute.offering'
                                                    },
                                                    networkdomain: {
                                                        label: 'label.network.domain'
                                                    },
                                                    domain: {
                                                        label: 'label.domain'
                                                    },
                                                    account: {
                                                        label: 'label.account'
                                                    },
                                                    created: {
                                                        label: 'label.created',
                                                        converter: cloudStack.converters.toLocalDate
                                                    },
                                                    isredundantrouter: {
                                                        label: 'label.redundant.router',
                                                        converter: cloudStack.converters.toBooleanText
                                                    },
                                                    redundantRouterState: {
                                                        label: 'label.redundant.state'
                                                    },
                                                    vpcid: {
                                                        label: 'label.vpc.id'
                                                    }
                                                }],
                                                dataProvider: function (args) {
                                                    $.ajax({
                                                        url: createURL("listRouters&id=" + args.context.routers[0].id),
                                                        dataType: 'json',
                                                        async: true,
                                                        success: function (json) {
                                                            var jsonObj = json.listroutersresponse.router[0];
                                                            addExtraPropertiesToRouterInstanceObject(jsonObj);
                                                            args.response.success({
                                                                actionFilter: routerActionfilter,
                                                                data: jsonObj
                                                            });
                                                        }
                                                    });
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        },
                        actions: {
                            enable: {
                                label: 'label.enable.provider',
                                action: function (args) {
                                    $.ajax({
                                        url: createURL("updateNetworkServiceProvider&id=" + nspMap[ "vpcVirtualRouter"].id + "&state=Enabled"),
                                        dataType: "json",
                                        success: function (json) {
                                            var jid = json.updatenetworkserviceproviderresponse.jobid;
                                            args.response.success({
                                                _custom: {
                                                    jobId: jid,
                                                    getUpdatedItem: function (json) {
                                                        $(window).trigger('cloudStack.fullRefresh');
                                                    }
                                                }
                                            });
                                        }
                                    });
                                },
                                messages: {
                                    confirm: function (args) {
                                        return 'message.confirm.enable.provider';
                                    },
                                    notification: function () {
                                        return 'label.enable.provider';
                                    }
                                },
                                notification: {
                                    poll: pollAsyncJobResult
                                }
                            },
                            disable: {
                                label: 'label.disable.provider',
                                action: function (args) {
                                    $.ajax({
                                        url: createURL("updateNetworkServiceProvider&id=" + nspMap[ "vpcVirtualRouter"].id + "&state=Disabled"),
                                        dataType: "json",
                                        success: function (json) {
                                            var jid = json.updatenetworkserviceproviderresponse.jobid;
                                            args.response.success({
                                                _custom: {
                                                    jobId: jid,
                                                    getUpdatedItem: function (json) {
                                                        $(window).trigger('cloudStack.fullRefresh');
                                                    }
                                                }
                                            });
                                        }
                                    });
                                },
                                messages: {
                                    confirm: function (args) {
                                        return 'message.confirm.disable.provider';
                                    },
                                    notification: function () {
                                        return 'label.disable.provider';
                                    }
                                },
                                notification: {
                                    poll: pollAsyncJobResult
                                }
                            }
                        }
                    },

                    Ovs: {
                        id: "Ovs",
                        label: "label.ovs",
                        isMaximized: true,
                        type: 'detailView',
                        fields: {
                            name: {
                                label: 'label.name'
                            },
                            state: {
                                label: 'label.status',
                                indicator: {
                                    'Enabled': 'on'
                                }
                            }
                        },
                        tabs: {
                            network: {
                                title: 'label.network',
                                fields: [{
                                    name: {
                                        label: 'label.name'
                                    }
                                }, {
                                    state: {
                                        label: 'label.state'
                                    },
                                    supportedServices: {
                                        label: 'label.supported.services'
                                    },
                                    id: {
                                        label: 'label.id'
                                    },
                                    physicalnetworkid: {
                                        label: 'label.physical.network.ID'
                                    }
                                }],
                                dataProvider: function(args) {
                                    refreshNspData("Ovs");
                                    args.response.success({
                                        actionFilter: ovsProviderActionFilter,
                                        data: $.extend(nspMap["Ovs"], {
                                            supportedServices: nspMap["Ovs"] == undefined? "": nspMap["Ovs"].servicelist.join(', ')
                                        })
                                    });
                                }
                            }
                        },
                        actions: {
                            enable: {
                                label: 'label.enable.provider',
                                action: function(args) {
                                    $.ajax({
                                        url: createURL("updateNetworkServiceProvider&id=" + nspMap["Ovs"].id + "&state=Enabled"),
                                        dataType: "json",
                                        success: function(json) {
                                            var jid = json.updatenetworkserviceproviderresponse.jobid;
                                            args.response.success({
                                                _custom: {
                                                    jobId: jid,
                                                    getUpdatedItem: function(json) {
                                                        $(window).trigger('cloudStack.fullRefresh');
                                                    }
                                                }
                                            });
                                        }
                                    });
                                },
                                messages: {
                                    confirm: function(args) {
                                        return 'message.confirm.enable.provider';
                                    },
                                    notification: function() {
                                        return 'label.enable.provider';
                                    }
                                },
                                notification: {
                                    poll: pollAsyncJobResult
                                }
                            },
                            disable: {
                                label: 'label.disable.provider',
                                action: function(args) {
                                    $.ajax({
                                        url: createURL("updateNetworkServiceProvider&id=" + nspMap["Ovs"].id + "&state=Disabled"),
                                        dataType: "json",
                                        success: function(json) {
                                            var jid = json.updatenetworkserviceproviderresponse.jobid;
                                            args.response.success({
                                                _custom: {
                                                    jobId: jid,
                                                    getUpdatedItem: function(json) {
                                                        $(window).trigger('cloudStack.fullRefresh');
                                                    }
                                                }
                                            });
                                        }
                                    });
                                },
                                messages: {
                                    confirm: function(args) {
                                        return 'message.confirm.disable.provider';
                                    },
                                    notification: function() {
                                        return 'label.disable.provider';
                                    }
                                },
                                notification: {
                                    poll: pollAsyncJobResult
                                }
                            }
                        }
                    },

                    // NetScaler provider detail view
                    netscaler: {
                        type: 'detailView',
                        id: 'netscalerProvider',
                        label: 'label.netScaler',
                        viewAll: {
                            label: 'label.devices',
                            path: '_zone.netscalerDevices'
                        },
                        tabs: {
                            details: {
                                title: 'label.details',
                                fields:[ {
                                    name: {
                                        label: 'label.name'
                                    }
                                },
                                {
                                    state: {
                                        label: 'label.state'
                                    }
                                }],
                                dataProvider: function (args) {
                                    refreshNspData("Netscaler");
                                    var providerObj;
                                    $(nspHardcodingArray).each(function () {
                                        if (this.id == "netscaler") {
                                            providerObj = this;
                                            return false; //break each loop
                                        }
                                    });
                                    args.response.success({
                                        data: providerObj,
                                        actionFilter: networkProviderActionFilter('netscaler')
                                    });
                                }
                            }
                        },
                        actions: {
                            add: {
                                label: 'label.add.netScaler.device',
                                createForm: {
                                    title: 'label.add.netScaler.device',
                                    preFilter: cloudStack.preFilter.addLoadBalancerDevice,
                                    fields: {
                                        ip: {
                                            label: 'label.ip.address',
                                            docID: 'helpNetScalerIPAddress'
                                        },
                                        username: {
                                            label: 'label.username',
                                            docID: 'helpNetScalerUsername'
                                        },
                                        password: {
                                            label: 'label.password',
                                            isPassword: true,
                                            docID: 'helpNetScalerPassword'
                                        },
                                        networkdevicetype: {
                                            label: 'label.type',
                                            docID: 'helpNetScalerType',
                                            select: function (args) {
                                                var items =[];
                                                items.push({
                                                    id: "NetscalerMPXLoadBalancer",
                                                    description: "NetScaler MPX LoadBalancer"
                                                });
                                                items.push({
                                                    id: "NetscalerVPXLoadBalancer",
                                                    description: "NetScaler VPX LoadBalancer"
                                                });
                                                items.push({
                                                    id: "NetscalerSDXLoadBalancer",
                                                    description: "NetScaler SDX LoadBalancer"
                                                });
                                                args.response.success({
                                                    data: items
                                                });
                                            }
                                        },
                                        publicinterface: {
                                            label: 'label.public.interface',
                                            docID: 'helpNetScalerPublicInterface'
                                        },
                                        privateinterface: {
                                            label: 'label.private.interface',
                                            docID: 'helpNetScalerPrivateInterface'
                                        },

                                        gslbprovider: {
                                            label: 'label.gslb.service',
                                            isBoolean: true,
                                            isChecked: false
                                        },
                                        gslbproviderpublicip: {
                                            label: 'label.gslb.service.public.ip'
                                        },
                                        gslbproviderprivateip: {
                                            label: 'label.gslb.service.private.ip'
                                        },

                                        numretries: {
                                            label: 'label.numretries',
                                            defaultValue: '2',
                                            docID: 'helpNetScalerRetries'
                                        },
                                        // inline: {
                                        //   label: 'Mode',
                                        //   select: function(args) {
                                        //     var items = [];
                                        //     items.push({id: "false", description: "side by side"});
                                        //     items.push({id: "true", description: "inline"});
                                        //     args.response.success({data: items});
                                        //   }
                                        // },
                                        dedicated: {
                                            label: 'label.dedicated',
                                            isBoolean: true,
                                            isChecked: false,
                                            docID: 'helpNetScalerDedicated'
                                        },
                                        capacity: {
                                            label: 'label.capacity',
                                            validation: {
                                                required: false,
                                                number: true
                                            },
                                            docID: 'helpNetScalerCapacity'
                                        }
                                    }
                                },
                                messages: {
                                    notification: function (args) {
                                        return 'label.add.netScaler.device';
                                    }
                                },
                                action: function (args) {
                                    if (nspMap[ "netscaler"] == null) {
                                        $.ajax({
                                            url: createURL("addNetworkServiceProvider&name=Netscaler&physicalnetworkid=" + selectedPhysicalNetworkObj.id),
                                            dataType: "json",
                                            async: true,
                                            success: function (json) {
                                                var jobId = json.addnetworkserviceproviderresponse.jobid;
                                                var addNetscalerProviderIntervalID = setInterval(function () {
                                                    $.ajax({
                                                        url: createURL("queryAsyncJobResult&jobId=" + jobId),
                                                        dataType: "json",
                                                        success: function (json) {
                                                            var result = json.queryasyncjobresultresponse;
                                                            if (result.jobstatus == 0) {
                                                                return; //Job has not completed
                                                            } else {
                                                                clearInterval(addNetscalerProviderIntervalID);
                                                                if (result.jobstatus == 1) {
                                                                    nspMap[ "netscaler"] = result.jobresult.networkserviceprovider;
                                                                    addExternalLoadBalancer(args, selectedPhysicalNetworkObj, "addNetscalerLoadBalancer", "addnetscalerloadbalancerresponse", "netscalerloadbalancer");
                                                                } else if (result.jobstatus == 2) {
                                                                    alert("addNetworkServiceProvider&name=Netscaler failed. Error: " + _s(result.jobresult.errortext));
                                                                }
                                                            }
                                                        },
                                                        error: function (XMLHttpResponse) {
                                                            var errorMsg = parseXMLHttpResponse(XMLHttpResponse);
                                                            alert("addNetworkServiceProvider&name=Netscaler failed. Error: " + errorMsg);
                                                        }
                                                    });
                                                },
                                                g_queryAsyncJobResultInterval);
                                            }
                                        });
                                    } else {
                                        addExternalLoadBalancer(args, selectedPhysicalNetworkObj, "addNetscalerLoadBalancer", "addnetscalerloadbalancerresponse", "netscalerloadbalancer");
                                    }
                                },
                                notification: {
                                    poll: pollAsyncJobResult
                                }
                            },
                            enable: {
                                label: 'label.enable.provider',
                                action: function (args) {
                                    $.ajax({
                                        url: createURL("updateNetworkServiceProvider&id=" + nspMap[ "netscaler"].id + "&state=Enabled"),
                                        dataType: "json",
                                        success: function (json) {
                                            var jid = json.updatenetworkserviceproviderresponse.jobid;
                                            args.response.success({
                                                _custom: {
                                                    jobId: jid,
                                                    getUpdatedItem: function (json) {
                                                        $(window).trigger('cloudStack.fullRefresh');
                                                    }
                                                }
                                            });
                                        }
                                    });
                                },
                                messages: {
                                    confirm: function (args) {
                                        return 'message.confirm.enable.provider';
                                    },
                                    notification: function () {
                                        return 'label.enable.provider';
                                    }
                                },
                                notification: {
                                    poll: pollAsyncJobResult
                                }
                            },
                            disable: {
                                label: 'label.disable.provider',
                                action: function (args) {
                                    $.ajax({
                                        url: createURL("updateNetworkServiceProvider&id=" + nspMap[ "netscaler"].id + "&state=Disabled"),
                                        dataType: "json",
                                        success: function (json) {
                                            var jid = json.updatenetworkserviceproviderresponse.jobid;
                                            args.response.success({
                                                _custom: {
                                                    jobId: jid,
                                                    getUpdatedItem: function (json) {
                                                        $(window).trigger('cloudStack.fullRefresh');
                                                    }
                                                }
                                            });
                                        }
                                    });
                                },
                                messages: {
                                    confirm: function (args) {
                                        return 'message.confirm.disable.provider';
                                    },
                                    notification: function () {
                                        return 'label.disable.provider';
                                    }
                                },
                                notification: {
                                    poll: pollAsyncJobResult
                                }
                            },
                            destroy: {
                                label: 'label.shutdown.provider',
                                action: function (args) {
                                    $.ajax({
                                        url: createURL("deleteNetworkServiceProvider&id=" + nspMap[ "netscaler"].id),
                                        dataType: "json",
                                        success: function (json) {
                                            var jid = json.deletenetworkserviceproviderresponse.jobid;
                                            args.response.success({
                                                _custom: {
                                                    jobId: jid
                                                }
                                            });

                                            $(window).trigger('cloudStack.fullRefresh');
                                        }
                                    });
                                },
                                messages: {
                                    confirm: function (args) {
                                        return 'message.confirm.shutdown.provider';
                                    },
                                    notification: function (args) {
                                        return 'label.shutdown.provider';
                                    }
                                },
                                notification: {
                                    poll: pollAsyncJobResult
                                }
                            }
                        }
                    },

                    //Baremetal DHCP provider detail view
                    BaremetalDhcpProvider: {
                        type: 'detailView',
                        id: 'BaremetalDhcpProvider',
                        label: 'label.baremetal.dhcp.provider',
                        viewAll: {
                            label: 'label.devices',
                            path: '_zone.BaremetalDhcpDevices'
                        },
                        tabs: {
                            details: {
                                title: 'label.details',
                                fields:[ {
                                    name: {
                                        label: 'label.name'
                                    }
                                },
                                {
                                    state: {
                                        label: 'label.state'
                                    }
                                }],
                                dataProvider: function (args) {
                                    refreshNspData("BaremetalDhcpProvider");
                                    var providerObj;
                                    $(nspHardcodingArray).each(function () {
                                        if (this.id == "BaremetalDhcpProvider") {
                                            providerObj = this;
                                            return false; //break each loop
                                        }
                                    });
                                    args.response.success({
                                        data: providerObj,
                                        actionFilter: networkProviderActionFilter('BaremetalDhcpProvider')
                                    });
                                }
                            }
                        },
                        actions: {
                            add: {
                                label: 'label.add.baremetal.dhcp.device',
                                createForm: {
                                    title: 'label.add.baremetal.dhcp.device',
                                    fields: {
                                        url: {
                                            label: 'label.url',
                                            validation: {
                                                required: true
                                            }
                                        },
                                        username: {
                                            label: 'label.username',
                                            validation: {
                                                required: true
                                            }
                                        },
                                        password: {
                                            label: 'label.password',
                                            isPassword: true,
                                            validation: {
                                                required: true
                                            }
                                        }
                                    }
                                },
                                action: function (args) {
                                    addBaremetalDhcpDeviceFn(args);
                                },
                                messages: {
                                    notification: function (args) {
                                        return 'label.add.baremetal.dhcp.device';
                                    }
                                },
                                notification: {
                                    poll: pollAsyncJobResult
                                }
                            },
                            enable: {
                                label: 'label.enable.provider',
                                action: function (args) {
                                    $.ajax({
                                        url: createURL("updateNetworkServiceProvider&id=" + nspMap[ "BaremetalDhcpProvider"].id + "&state=Enabled"),
                                        dataType: "json",
                                        success: function (json) {
                                            var jid = json.updatenetworkserviceproviderresponse.jobid;
                                            args.response.success({
                                                _custom: {
                                                    jobId: jid,
                                                    getUpdatedItem: function (json) {
                                                        $(window).trigger('cloudStack.fullRefresh');
                                                    }
                                                }
                                            });
                                        }
                                    });
                                },
                                messages: {
                                    confirm: function (args) {
                                        return 'message.confirm.enable.provider';
                                    },
                                    notification: function () {
                                        return 'label.enable.provider';
                                    }
                                },
                                notification: {
                                    poll: pollAsyncJobResult
                                }
                            },
                            disable: {
                                label: 'label.disable.provider',
                                action: function (args) {
                                    $.ajax({
                                        url: createURL("updateNetworkServiceProvider&id=" + nspMap[ "BaremetalDhcpProvider"].id + "&state=Disabled"),
                                        dataType: "json",
                                        success: function (json) {
                                            var jid = json.updatenetworkserviceproviderresponse.jobid;
                                            args.response.success({
                                                _custom: {
                                                    jobId: jid,
                                                    getUpdatedItem: function (json) {
                                                        $(window).trigger('cloudStack.fullRefresh');
                                                    }
                                                }
                                            });
                                        }
                                    });
                                },
                                messages: {
                                    confirm: function (args) {
                                        return 'message.confirm.disable.provider';
                                    },
                                    notification: function () {
                                        return 'label.disable.provider';
                                    }
                                },
                                notification: {
                                    poll: pollAsyncJobResult
                                }
                            },
                            destroy: {
                                label: 'label.shutdown.provider',
                                action: function (args) {
                                    $.ajax({
                                        url: createURL("deleteNetworkServiceProvider&id=" + nspMap[ "BaremetalDhcpProvider"].id),
                                        dataType: "json",
                                        success: function (json) {
                                            var jid = json.deletenetworkserviceproviderresponse.jobid;
                                            args.response.success({
                                                _custom: {
                                                    jobId: jid
                                                }
                                            });

                                            $(window).trigger('cloudStack.fullRefresh');
                                        }
                                    });
                                },
                                messages: {
                                    confirm: function (args) {
                                        return 'message.confirm.shutdown.provider';
                                    },
                                    notification: function (args) {
                                        return 'label.shutdown.provider';
                                    }
                                },
                                notification: {
                                    poll: pollAsyncJobResult
                                }
                            }
                        }
                    },

                    //Baremetal PXE provider detail view
                    BaremetalPxeProvider: {
                        type: 'detailView',
                        id: 'BaremetalPxeProvider',
                        label: 'label.baremetal.pxe.provider',
                        viewAll: {
                            label: 'label.devices',
                            path: '_zone.BaremetalPxeDevices'
                        },
                        tabs: {
                            details: {
                                title: 'label.details',
                                fields:[ {
                                    name: {
                                        label: 'label.name'
                                    }
                                },
                                {
                                    state: {
                                        label: 'label.state'
                                    }
                                }],
                                dataProvider: function (args) {
                                    refreshNspData("BaremetalPxeProvider");
                                    var providerObj;
                                    $(nspHardcodingArray).each(function () {
                                        if (this.id == "BaremetalPxeProvider") {
                                            providerObj = this;
                                            return false; //break each loop
                                        }
                                    });
                                    args.response.success({
                                        data: providerObj,
                                        actionFilter: networkProviderActionFilter('BaremetalPxeProvider')
                                    });
                                }
                            }
                        },
                        actions: {
                            add: {
                                label: 'label.baremetal.pxe.device',
                                createForm: {
                                    title: 'label.baremetal.pxe.device',
                                    fields: {
                                        url: {
                                            label: 'label.url',
                                            validation: {
                                                required: true
                                            }
                                        },
                                        username: {
                                            label: 'label.username',
                                            validation: {
                                                required: true
                                            }
                                        },
                                        password: {
                                            label: 'label.password',
                                            isPassword: true,
                                            validation: {
                                                required: true
                                            }
                                        },
                                        tftpdir: {
                                            label: 'label.tftp.root.directory',
                                            validation: {
                                                required: true
                                            }
                                        }
                                    }
                                },
                                action: function (args) {
                                    addBaremetalPxeDeviceFn(args);
                                },
                                messages: {
                                    notification: function (args) {
                                        return 'label.baremetal.pxe.device';
                                    }
                                },
                                notification: {
                                    poll: pollAsyncJobResult
                                }
                            },
                            enable: {
                                label: 'label.enable.provider',
                                action: function (args) {
                                    $.ajax({
                                        url: createURL("updateNetworkServiceProvider&id=" + nspMap[ "BaremetalPxeProvider"].id + "&state=Enabled"),
                                        dataType: "json",
                                        success: function (json) {
                                            var jid = json.updatenetworkserviceproviderresponse.jobid;
                                            args.response.success({
                                                _custom: {
                                                    jobId: jid,
                                                    getUpdatedItem: function (json) {
                                                        $(window).trigger('cloudStack.fullRefresh');
                                                    }
                                                }
                                            });
                                        }
                                    });
                                },
                                messages: {
                                    confirm: function (args) {
                                        return 'message.confirm.enable.provider';
                                    },
                                    notification: function () {
                                        return 'label.enable.provider';
                                    }
                                },
                                notification: {
                                    poll: pollAsyncJobResult
                                }
                            },
                            disable: {
                                label: 'label.disable.provider',
                                action: function (args) {
                                    $.ajax({
                                        url: createURL("updateNetworkServiceProvider&id=" + nspMap[ "BaremetalPxeProvider"].id + "&state=Disabled"),
                                        dataType: "json",
                                        success: function (json) {
                                            var jid = json.updatenetworkserviceproviderresponse.jobid;
                                            args.response.success({
                                                _custom: {
                                                    jobId: jid,
                                                    getUpdatedItem: function (json) {
                                                        $(window).trigger('cloudStack.fullRefresh');
                                                    }
                                                }
                                            });
                                        }
                                    });
                                },
                                messages: {
                                    confirm: function (args) {
                                        return 'message.confirm.disable.provider';
                                    },
                                    notification: function () {
                                        return 'label.disable.provider';
                                    }
                                },
                                notification: {
                                    poll: pollAsyncJobResult
                                }
                            },
                            destroy: {
                                label: 'label.shutdown.provider',
                                action: function (args) {
                                    $.ajax({
                                        url: createURL("deleteNetworkServiceProvider&id=" + nspMap[ "BaremetalPxeProvider"].id),
                                        dataType: "json",
                                        success: function (json) {
                                            var jid = json.deletenetworkserviceproviderresponse.jobid;
                                            args.response.success({
                                                _custom: {
                                                    jobId: jid
                                                }
                                            });

                                            $(window).trigger('cloudStack.fullRefresh');
                                        }
                                    });
                                },
                                messages: {
                                    confirm: function (args) {
                                        return 'message.confirm.shutdown.provider';
                                    },
                                    notification: function (args) {
                                        return 'label.shutdown.provider';
                                    }
                                },
                                notification: {
                                    poll: pollAsyncJobResult
                                }
                            }
                        }
                    },

                    //f5 provider detail view
                    f5: {
                        type: 'detailView',
                        id: 'f5Provider',
                        label: 'label.f5',
                        viewAll: {
                            label: 'label.devices',
                            path: '_zone.f5Devices'
                        },
                        tabs: {
                            details: {
                                title: 'label.details',
                                fields:[ {
                                    name: {
                                        label: 'label.name'
                                    }
                                },
                                {
                                    state: {
                                        label: 'label.state'
                                    }
                                }],
                                dataProvider: function (args) {
                                    refreshNspData("F5BigIp");
                                    var providerObj;
                                    $(nspHardcodingArray).each(function () {
                                        if (this.id == "f5") {
                                            providerObj = this;
                                            return false; //break each loop
                                        }
                                    });
                                    args.response.success({
                                        data: providerObj,
                                        actionFilter: networkProviderActionFilter('f5')
                                    });
                                }
                            }
                        },
                        actions: {
                            add: {
                                label: 'label.add.F5.device',
                                createForm: {
                                    title: 'label.add.F5.device',
                                    preFilter: cloudStack.preFilter.addLoadBalancerDevice,
                                    fields: {
                                        ip: {
                                            label: 'label.ip.address',
                                            docID: 'helpF5IPAddress'
                                        },
                                        username: {
                                            label: 'label.username',
                                            docID: 'helpF5Username'
                                        },
                                        password: {
                                            label: 'label.password',
                                            docID: 'helpF5Password',
                                            isPassword: true
                                        },
                                        networkdevicetype: {
                                            label: 'label.type',
                                            docID: 'helpF5Type',
                                            select: function (args) {
                                                var items =[];
                                                items.push({
                                                    id: "F5BigIpLoadBalancer",
                                                    description: "F5 Big Ip Load Balancer"
                                                });
                                                args.response.success({
                                                    data: items
                                                });
                                            }
                                        },
                                        publicinterface: {
                                            label: 'label.public.interface',
                                            docID: 'helpF5PublicInterface'
                                        },
                                        privateinterface: {
                                            label: 'label.private.interface',
                                            docID: 'helpF5PrivateInterface'
                                        },
                                        numretries: {
                                            label: 'label.numretries',
                                            docID: 'helpF5Retries',
                                            defaultValue: '2'
                                        },
                                        //Inline Mode has been moved from Add F5 Device to Create Network Offering (both backend and UI)
                                        /*
                                        inline: {
                                        label: 'Mode',
                                        docID: 'helpF5Mode',
                                        select: function(args) {
                                        var items = [];
                                        items.push({id: "false", description: "side by side"});
                                        items.push({id: "true", description: "inline"});
                                        args.response.success({data: items});
                                        }
                                        },
                                         */
                                        dedicated: {
                                            label: 'label.dedicated',
                                            docID: 'helpF5Dedicated',
                                            isBoolean: true,
                                            isChecked: false
                                        },
                                        capacity: {
                                            label: 'label.capacity',
                                            docID: 'helpF5Capacity',
                                            validation: {
                                                required: false,
                                                number: true
                                            }
                                        }
                                    }
                                },
                                action: function (args) {
                                    if (nspMap[ "f5"] == null) {
                                        $.ajax({
                                            url: createURL("addNetworkServiceProvider&name=F5BigIp&physicalnetworkid=" + selectedPhysicalNetworkObj.id),
                                            dataType: "json",
                                            async: true,
                                            success: function (json) {
                                                var jobId = json.addnetworkserviceproviderresponse.jobid;
                                                var addF5ProviderIntervalID = setInterval(function () {
                                                    $.ajax({
                                                        url: createURL("queryAsyncJobResult&jobId=" + jobId),
                                                        dataType: "json",
                                                        success: function (json) {
                                                            var result = json.queryasyncjobresultresponse;
                                                            if (result.jobstatus == 0) {
                                                                return; //Job has not completed
                                                            } else {
                                                                clearInterval(addF5ProviderIntervalID);
                                                                if (result.jobstatus == 1) {
                                                                    nspMap[ "f5"] = json.queryasyncjobresultresponse.jobresult.networkserviceprovider;
                                                                    addExternalLoadBalancer(args, selectedPhysicalNetworkObj, "addF5LoadBalancer", "addf5bigiploadbalancerresponse");
                                                                } else if (result.jobstatus == 2) {
                                                                    alert("addNetworkServiceProvider&name=F5BigIp failed. Error: " + _s(result.jobresult.errortext));
                                                                }
                                                            }
                                                        },
                                                        error: function (XMLHttpResponse) {
                                                            var errorMsg = parseXMLHttpResponse(XMLHttpResponse);
                                                            alert("addNetworkServiceProvider&name=F5BigIpfailed. Error: " + errorMsg);
                                                        }
                                                    });
                                                },
                                                g_queryAsyncJobResultInterval);
                                            }
                                        });
                                    } else {
                                        addExternalLoadBalancer(args, selectedPhysicalNetworkObj, "addF5LoadBalancer", "addf5bigiploadbalancerresponse");
                                    }
                                },
                                messages: {
                                    notification: function (args) {
                                        return 'label.add.F5.device';
                                    }
                                },
                                notification: {
                                    poll: pollAsyncJobResult
                                }
                            },
                            enable: {
                                label: 'label.enable.provider',
                                action: function (args) {
                                    $.ajax({
                                        url: createURL("updateNetworkServiceProvider&id=" + nspMap[ "f5"].id + "&state=Enabled"),
                                        dataType: "json",
                                        success: function (json) {
                                            var jid = json.updatenetworkserviceproviderresponse.jobid;
                                            args.response.success({
                                                _custom: {
                                                    jobId: jid,
                                                    getUpdatedItem: function (json) {
                                                        $(window).trigger('cloudStack.fullRefresh');
                                                    }
                                                }
                                            });
                                        }
                                    });
                                },
                                messages: {
                                    confirm: function (args) {
                                        return 'message.confirm.enable.provider';
                                    },
                                    notification: function () {
                                        return 'label.enable.provider';
                                    }
                                },
                                notification: {
                                    poll: pollAsyncJobResult
                                }
                            },
                            disable: {
                                label: 'label.disable.provider',
                                action: function (args) {
                                    $.ajax({
                                        url: createURL("updateNetworkServiceProvider&id=" + nspMap[ "f5"].id + "&state=Disabled"),
                                        dataType: "json",
                                        success: function (json) {
                                            var jid = json.updatenetworkserviceproviderresponse.jobid;
                                            args.response.success({
                                                _custom: {
                                                    jobId: jid,
                                                    getUpdatedItem: function (json) {
                                                        $(window).trigger('cloudStack.fullRefresh');
                                                    }
                                                }
                                            });
                                        }
                                    });
                                },
                                messages: {
                                    confirm: function (args) {
                                        return 'message.confirm.disable.provider';
                                    },
                                    notification: function () {
                                        return 'label.disable.provider';
                                    }
                                },
                                notification: {
                                    poll: pollAsyncJobResult
                                }
                            },
                            destroy: {
                                label: 'label.shutdown.provider',
                                action: function (args) {
                                    $.ajax({
                                        url: createURL("deleteNetworkServiceProvider&id=" + nspMap[ "f5"].id),
                                        dataType: "json",
                                        success: function (json) {
                                            var jid = json.deletenetworkserviceproviderresponse.jobid;
                                            args.response.success({
                                                _custom: {
                                                    jobId: jid
                                                }
                                            });

                                            $(window).trigger('cloudStack.fullRefresh');
                                        }
                                    });
                                },
                                messages: {
                                    confirm: function (args) {
                                        return 'message.confirm.shutdown.provider';
                                    },
                                    notification: function (args) {
                                        return 'label.shutdown.provider';
                                    }
                                },
                                notification: {
                                    poll: pollAsyncJobResult
                                }
                            }
                        }
                    },

                    // SRX provider detailView
                    srx: {
                        type: 'detailView',
                        id: 'srxProvider',
                        label: 'label.srx',
                        viewAll: {
                            label: 'label.devices',
                            path: '_zone.srxDevices'
                        },
                        tabs: {
                            details: {
                                title: 'label.details',
                                fields:[ {
                                    name: {
                                        label: 'label.name'
                                    }
                                },
                                {
                                    state: {
                                        label: 'label.state'
                                    }
                                }],
                                dataProvider: function (args) {
                                    refreshNspData("JuniperSRX");
                                    var providerObj;
                                    $(nspHardcodingArray).each(function () {
                                        if (this.id == "srx") {
                                            providerObj = this;
                                            return false; //break each loop
                                        }
                                    });
                                    args.response.success({
                                        data: providerObj,
                                        actionFilter: networkProviderActionFilter('srx')
                                    });
                                }
                            }
                        },
                        actions: {
                            add: {
                                label: 'label.add.SRX.device',
                                createForm: {
                                    title: 'label.add.SRX.device',
                                    fields: {
                                        ip: {
                                            label: 'label.ip.address',
                                            docID: 'helpSRXIPAddress'
                                        },
                                        username: {
                                            label: 'label.username',
                                            docID: 'helpSRXUsername'
                                        },
                                        password: {
                                            label: 'label.password',
                                            isPassword: true,
                                            docID: 'helpSRXPassword'
                                        },
                                        networkdevicetype: {
                                            label: 'label.type',
                                            docID: 'helpSRXType',
                                            select: function (args) {
                                                var items =[];
                                                items.push({
                                                    id: "JuniperSRXFirewall",
                                                    description: "Juniper SRX Firewall"
                                                });
                                                args.response.success({
                                                    data: items
                                                });
                                            }
                                        },
                                        publicinterface: {
                                            label: 'label.public.interface',
                                            docID: 'helpSRXPublicInterface'
                                        },
                                        privateinterface: {
                                            label: 'label.private.interface',
                                            docID: 'helpSRXPrivateInterface'
                                        },
                                        usageinterface: {
                                            label: 'label.usage.interface',
                                            docID: 'helpSRXUsageInterface'
                                        },
                                        numretries: {
                                            label: 'label.numretries',
                                            defaultValue: '2',
                                            docID: 'helpSRXRetries'
                                        },
                                        timeout: {
                                            label: 'label.timeout',
                                            defaultValue: '300',
                                            docID: 'helpSRXTimeout'
                                        },
                                        // inline: {
                                        //   label: 'Mode',
                                        //   docID: 'helpSRXMode',
                                        //   select: function(args) {
                                        //     var items = [];
                                        //     items.push({id: "false", description: "side by side"});
                                        //     items.push({id: "true", description: "inline"});
                                        //     args.response.success({data: items});
                                        //   }
                                        // },
                                        publicnetwork: {
                                            label: 'label.public.network',
                                            defaultValue: 'untrusted',
                                            docID: 'helpSRXPublicNetwork',
                                            isDisabled: true
                                        },
                                        privatenetwork: {
                                            label: 'label.private.network',
                                            defaultValue: 'trusted',
                                            docID: 'helpSRXPrivateNetwork',
                                            isDisabled: true
                                        },
                                        capacity: {
                                            label: 'label.capacity',
                                            validation: {
                                                required: false,
                                                number: true
                                            },
                                            docID: 'helpSRXCapacity'
                                        },
                                        dedicated: {
                                            label: 'label.dedicated',
                                            isBoolean: true,
                                            isChecked: false,
                                            docID: 'helpSRXDedicated'
                                        }
                                    }
                                },
                                action: function (args) {
                                    if (nspMap[ "srx"] == null) {
                                        $.ajax({
                                            url: createURL("addNetworkServiceProvider&name=JuniperSRX&physicalnetworkid=" + selectedPhysicalNetworkObj.id),
                                            dataType: "json",
                                            async: true,
                                            success: function (json) {
                                                var jobId = json.addnetworkserviceproviderresponse.jobid;
                                                var addJuniperSRXProviderIntervalID = setInterval(function () {
                                                    $.ajax({
                                                        url: createURL("queryAsyncJobResult&jobId=" + jobId),
                                                        dataType: "json",
                                                        success: function (json) {
                                                            var result = json.queryasyncjobresultresponse;
                                                            if (result.jobstatus == 0) {
                                                                return; //Job has not completed
                                                            } else {
                                                                clearInterval(addJuniperSRXProviderIntervalID);
                                                                if (result.jobstatus == 1) {
                                                                    nspMap[ "srx"] = json.queryasyncjobresultresponse.jobresult.networkserviceprovider;
                                                                    addExternalFirewall(args, selectedPhysicalNetworkObj, "addSrxFirewall", "addsrxfirewallresponse", "srxfirewall");
                                                                } else if (result.jobstatus == 2) {
                                                                    alert("addNetworkServiceProvider&name=JuniperSRX failed. Error: " + _s(result.jobresult.errortext));
                                                                }
                                                            }
                                                        },
                                                        error: function (XMLHttpResponse) {
                                                            var errorMsg = parseXMLHttpResponse(XMLHttpResponse);
                                                            alert("addNetworkServiceProvider&name=JuniperSRX failed. Error: " + errorMsg);
                                                        }
                                                    });
                                                },
                                                g_queryAsyncJobResultInterval);
                                            }
                                        });
                                    } else {
                                        addExternalFirewall(args, selectedPhysicalNetworkObj, "addSrxFirewall", "addsrxfirewallresponse", "srxfirewall");
                                    }
                                },
                                messages: {
                                    notification: function (args) {
                                        return 'label.add.SRX.device';
                                    }
                                },
                                notification: {
                                    poll: pollAsyncJobResult
                                }
                            },
                            enable: {
                                label: 'label.enable.provider',
                                action: function (args) {
                                    $.ajax({
                                        url: createURL("updateNetworkServiceProvider&id=" + nspMap[ "srx"].id + "&state=Enabled"),
                                        dataType: "json",
                                        success: function (json) {
                                            var jid = json.updatenetworkserviceproviderresponse.jobid;
                                            args.response.success({
                                                _custom: {
                                                    jobId: jid,
                                                    getUpdatedItem: function (json) {
                                                        $(window).trigger('cloudStack.fullRefresh');
                                                    }
                                                }
                                            });
                                        }
                                    });
                                },
                                messages: {
                                    confirm: function (args) {
                                        return 'message.confirm.enable.provider';
                                    },
                                    notification: function () {
                                        return 'label.enable.provider';
                                    }
                                },
                                notification: {
                                    poll: pollAsyncJobResult
                                }
                            },
                            disable: {
                                label: 'label.disable.provider',
                                action: function (args) {
                                    $.ajax({
                                        url: createURL("updateNetworkServiceProvider&id=" + nspMap[ "srx"].id + "&state=Disabled"),
                                        dataType: "json",
                                        success: function (json) {
                                            var jid = json.updatenetworkserviceproviderresponse.jobid;
                                            args.response.success({
                                                _custom: {
                                                    jobId: jid,
                                                    getUpdatedItem: function (json) {
                                                        $(window).trigger('cloudStack.fullRefresh');
                                                    }
                                                }
                                            });
                                        }
                                    });
                                },
                                messages: {
                                    confirm: function (args) {
                                        return 'message.confirm.disable.provider';
                                    },
                                    notification: function () {
                                        return 'label.disable.provider';
                                    }
                                },
                                notification: {
                                    poll: pollAsyncJobResult
                                }
                            },
                            destroy: {
                                label: 'label.shutdown.provider',
                                action: function (args) {
                                    $.ajax({
                                        url: createURL("deleteNetworkServiceProvider&id=" + nspMap[ "srx"].id),
                                        dataType: "json",
                                        success: function (json) {
                                            var jid = json.deletenetworkserviceproviderresponse.jobid;
                                            args.response.success({
                                                _custom: {
                                                    jobId: jid
                                                }
                                            });

                                            $(window).trigger('cloudStack.fullRefresh');
                                        }
                                    });
                                },
                                messages: {
                                    confirm: function (args) {
                                        return 'message.confirm.shutdown.provider';
                                    },
                                    notification: function (args) {
                                        return 'label.shutdown.provider';
                                    }
                                },
                                notification: {
                                    poll: pollAsyncJobResult
                                }
                            }
                        }
                    },

                    // Palo Alto provider detailView
                    pa: {
                        type: 'detailView',
                        id: 'paProvider',
                        label: 'label.PA',
                        viewAll: {
                            label: 'label.devices',
                            path: '_zone.paDevices'
                        },
                        tabs: {
                            details: {
                                title: 'label.details',
                                fields:[ {
                                    name: {
                                        label: 'label.name'
                                    }
                                },
                                {
                                    state: {
                                        label: 'label.state'
                                    }
                                }],
                                dataProvider: function (args) {
                                    refreshNspData("PaloAlto");
                                    var providerObj;
                                    $(nspHardcodingArray).each(function () {
                                        if (this.id == "pa") {
                                            providerObj = this;
                                            return false; //break each loop
                                        }
                                    });
                                    args.response.success({
                                        data: providerObj,
                                        actionFilter: networkProviderActionFilter('pa')
                                    });
                                }
                            }
                        },
                        actions: {
                            add: {
                                label: 'label.add.PA.device',
                                createForm: {
                                    title: 'label.add.PA.device',
                                    fields: {
                                        ip: {
                                            label: 'label.ip.address',
                                            docID: 'helpPaloAltoIPAddress'
                                        },
                                        username: {
                                            label: 'label.username',
                                            docID: 'helpPaloAltoUsername'
                                        },
                                        password: {
                                            label: 'label.password',
                                            isPassword: true,
                                            docID: 'helpPaloAltoPassword'
                                        },
                                        networkdevicetype: {
                                            label: 'label.type',
                                            docID: 'helpPaloAltoType',
                                            select: function (args) {
                                                var items =[];
                                                items.push({
                                                    id: "PaloAltoFirewall",
                                                    description: "Palo Alto Firewall"
                                                });
                                                args.response.success({
                                                    data: items
                                                });
                                            }
                                        },
                                        publicinterface: {
                                            label: 'label.public.interface',
                                            docID: 'helpPaloAltoPublicInterface'
                                        },
                                        privateinterface: {
                                            label: 'label.private.interface',
                                            docID: 'helpPaloAltoPrivateInterface'
                                        },
                                        //usageinterface: {
                                        //  label: 'Usage interface',
                                        //  docID: 'helpPaloAltoUsageInterface'
                                        //},
                                        numretries: {
                                            label: 'label.numretries',
                                            defaultValue: '2',
                                            docID: 'helpPaloAltoRetries'
                                        },
                                        timeout: {
                                            label: 'label.timeout',
                                            defaultValue: '300',
                                            docID: 'helpPaloAltoTimeout'
                                        },
                                        // inline: {
                                        //   label: 'Mode',
                                        //   docID: 'helpPaloAltoMode',
                                        //   select: function(args) {
                                        //     var items = [];
                                        //     items.push({id: "false", description: "side by side"});
                                        //     items.push({id: "true", description: "inline"});
                                        //     args.response.success({data: items});
                                        //   }
                                        // },
                                        publicnetwork: {
                                            label: 'label.public.network',
                                            defaultValue: 'untrust',
                                            docID: 'helpPaloAltoPublicNetwork'
                                        },
                                        privatenetwork: {
                                            label: 'label.private.network',
                                            defaultValue: 'trust',
                                            docID: 'helpPaloAltoPrivateNetwork'
                                        },
                                        pavr: {
                                            label: 'label.virtual.router',
                                            docID: 'helpPaloAltoVirtualRouter'
                                        },
                                        patp: {
                                            label: 'label.PA.threat.profile',
                                            docID: 'helpPaloAltoThreatProfile'
                                        },
                                        palp: {
                                            label: 'label.PA.log.profile',
                                            docID: 'helpPaloAltoLogProfile'
                                        },
                                        capacity: {
                                            label: 'label.capacity',
                                            validation: {
                                                required: false,
                                                number: true
                                            },
                                            docID: 'helpPaloAltoCapacity'
                                        },
                                        dedicated: {
                                            label: 'label.dedicated',
                                            isBoolean: true,
                                            isChecked: false,
                                            docID: 'helpPaloAltoDedicated'
                                        }
                                    }
                                },
                                action: function (args) {
                                    if (nspMap[ "pa"] == null) {
                                        $.ajax({
                                            url: createURL("addNetworkServiceProvider&name=PaloAlto&physicalnetworkid=" + selectedPhysicalNetworkObj.id),
                                            dataType: "json",
                                            async: true,
                                            success: function (json) {
                                                var jobId = json.addnetworkserviceproviderresponse.jobid;
                                                var addPaloAltoProviderIntervalID = setInterval(function () {
                                                    $.ajax({
                                                        url: createURL("queryAsyncJobResult&jobId=" + jobId),
                                                        dataType: "json",
                                                        success: function (json) {
                                                            var result = json.queryasyncjobresultresponse;
                                                            if (result.jobstatus == 0) {
                                                                return; //Job has not completed
                                                            } else {
                                                                clearInterval(addPaloAltoProviderIntervalID);
                                                                if (result.jobstatus == 1) {
                                                                    nspMap[ "pa"] = json.queryasyncjobresultresponse.jobresult.networkserviceprovider;
                                                                    addExternalFirewall(args, selectedPhysicalNetworkObj, "addPaloAltoFirewall", "addpaloaltofirewallresponse", "pafirewall");
                                                                } else if (result.jobstatus == 2) {
                                                                    alert("addNetworkServiceProvider&name=Palo Alto failed. Error: " + _s(result.jobresult.errortext));
                                                                }
                                                            }
                                                        },
                                                        error: function (XMLHttpResponse) {
                                                            var errorMsg = parseXMLHttpResponse(XMLHttpResponse);
                                                            alert("addNetworkServiceProvider&name=Palo Alto failed. Error: " + errorMsg);
                                                        }
                                                    });
                                                },
                                                3000);
                                            }
                                        });
                                    } else {
                                        addExternalFirewall(args, selectedPhysicalNetworkObj, "addPaloAltoFirewall", "addpaloaltofirewallresponse", "pafirewall");
                                    }
                                },
                                messages: {
                                    notification: function (args) {
                                        return 'label.add.PA.device';
                                    }
                                },
                                notification: {
                                    poll: pollAsyncJobResult
                                }
                            },
                            enable: {
                                label: 'label.enable.provider',
                                action: function (args) {
                                    $.ajax({
                                        url: createURL("updateNetworkServiceProvider&id=" + nspMap[ "pa"].id + "&state=Enabled"),
                                        dataType: "json",
                                        success: function (json) {
                                            var jid = json.updatenetworkserviceproviderresponse.jobid;
                                            args.response.success({
                                                _custom: {
                                                    jobId: jid,
                                                    getUpdatedItem: function (json) {
                                                        $(window).trigger('cloudStack.fullRefresh');
                                                    }
                                                }
                                            });
                                        }
                                    });
                                },
                                messages: {
                                    confirm: function (args) {
                                        return 'message.confirm.enable.provider';
                                    },
                                    notification: function () {
                                        return 'label.enable.provider';
                                    }
                                },
                                notification: {
                                    poll: pollAsyncJobResult
                                }
                            },
                            disable: {
                                label: 'label.disable.provider',
                                action: function (args) {
                                    $.ajax({
                                        url: createURL("updateNetworkServiceProvider&id=" + nspMap[ "pa"].id + "&state=Disabled"),
                                        dataType: "json",
                                        success: function (json) {
                                            var jid = json.updatenetworkserviceproviderresponse.jobid;
                                            args.response.success({
                                                _custom: {
                                                    jobId: jid,
                                                    getUpdatedItem: function (json) {
                                                        $(window).trigger('cloudStack.fullRefresh');
                                                    }
                                                }
                                            });
                                        }
                                    });
                                },
                                messages: {
                                    confirm: function (args) {
                                        return 'message.confirm.disable.provider';
                                    },
                                    notification: function () {
                                        return 'label.disable.provider';
                                    }
                                },
                                notification: {
                                    poll: pollAsyncJobResult
                                }
                            },
                            destroy: {
                                label: 'label.shutdown.provider',
                                action: function (args) {
                                    $.ajax({
                                        url: createURL("deleteNetworkServiceProvider&id=" + nspMap[ "pa"].id),
                                        dataType: "json",
                                        success: function (json) {
                                            var jid = json.deletenetworkserviceproviderresponse.jobid;
                                            args.response.success({
                                                _custom: {
                                                    jobId: jid
                                                }
                                            });

                                            $(window).trigger('cloudStack.fullRefresh');
                                        }
                                    });
                                },
                                messages: {
                                    confirm: function (args) {
                                        return 'message.confirm.shutdown.provider';
                                    },
                                    notification: function (args) {
                                        return 'label.shutdown.provider';
                                    }
                                },
                                notification: {
                                    poll: pollAsyncJobResult
                                }
                            }
                        }
                    },

                    // Security groups detail view
                    securityGroups: {
                        id: 'securityGroup-providers',
                        label: 'label.menu.security.groups',
                        type: 'detailView',
                        viewAll: {
                            label: 'label.rules',
                            path: 'network.securityGroups'
                        },
                        tabs: {
                            details: {
                                title: 'label.details',
                                fields:[ {
                                    name: {
                                        label: 'label.name'
                                    }
                                },
                                {
                                    state: {
                                        label: 'label.state'
                                    }
                                }],
                                dataProvider: function (args) {
                                    refreshNspData("SecurityGroupProvider");
                                    var providerObj;
                                    $(nspHardcodingArray).each(function () {
                                        if (this.id == "securityGroups") {
                                            providerObj = this;
                                            return false; //break each loop
                                        }
                                    });
                                    args.response.success({
                                        actionFilter: function (args) {
                                            var allowedActions =[];
                                            var jsonObj = providerObj;
                                            if (jsonObj.state == "Enabled")
                                            allowedActions.push("disable"); else if (jsonObj.state == "Disabled")
                                            allowedActions.push("enable");
                                            return allowedActions;
                                        },
                                        data: providerObj
                                    });
                                }
                            }
                        },
                        actions: {
                            enable: {
                                label: 'label.enable.provider',
                                action: function (args) {
                                    $.ajax({
                                        url: createURL("updateNetworkServiceProvider&id=" + nspMap[ "securityGroups"].id + "&state=Enabled"),
                                        async: true,
                                        success: function (json) {
                                            var jid = json.updatenetworkserviceproviderresponse.jobid;
                                            args.response.success({
                                                _custom: {
                                                    jobId: jid,
                                                    getUpdatedItem: function (json) {
                                                        $(window).trigger('cloudStack.fullRefresh');
                                                    }
                                                }
                                            });
                                        }
                                    });
                                },
                                messages: {
                                    confirm: function (args) {
                                        return 'message.confirm.enable.provider';
                                    },
                                    notification: function () {
                                        return 'label.enable.provider';
                                    }
                                },
                                notification: {
                                    poll: pollAsyncJobResult
                                }
                            },
                            disable: {
                                label: 'label.disable.provider',
                                action: function (args) {
                                    $.ajax({
                                        url: createURL("updateNetworkServiceProvider&id=" + nspMap[ "securityGroups"].id + "&state=Disabled"),
                                        dataType: "json",
                                        success: function (json) {
                                            var jid = json.updatenetworkserviceproviderresponse.jobid;
                                            args.response.success({
                                                _custom: {
                                                    jobId: jid,
                                                    getUpdatedItem: function (json) {
                                                        $(window).trigger('cloudStack.fullRefresh');
                                                    }
                                                }
                                            });
                                        }
                                    });
                                },
                                messages: {
                                    confirm: function (args) {
                                        return 'message.confirm.disable.provider';
                                    },
                                    notification: function () {
                                        return 'label.disable.provider';
                                    }
                                },
                                notification: {
                                    poll: pollAsyncJobResult
                                }
                            }
                        },

                        fields: {
                            id: {
                                label: 'label.id'
                            },
                            name: {
                                label: 'label.name'
                            }
                            //,
                            //state: { label: 'label.status' } //comment it for now, since dataProvider below doesn't get called by widget code after action is done
                        }
                    },
                    // Nicira Nvp provider detail view
                    niciraNvp: {
                        type: 'detailView',
                        id: 'niciraNvpProvider',
                        label: 'label.niciraNvp',
                        viewAll: {
                            label: 'label.devices',
                            path: '_zone.niciraNvpDevices'
                        },
                        tabs: {
                            details: {
                                title: 'label.details',
                                fields:[ {
                                    name: {
                                        label: 'label.name'
                                    }
                                },
                                {
                                    state: {
                                        label: 'label.state'
                                    }
                                }],
                                dataProvider: function (args) {
                                    refreshNspData("NiciraNvp");
                                    var providerObj;
                                    $(nspHardcodingArray).each(function () {
                                        if (this.id == "niciraNvp") {
                                            providerObj = this;
                                            return false; //break each loop
                                        }
                                    });
                                    args.response.success({
                                        data: providerObj,
                                        actionFilter: networkProviderActionFilter('niciraNvp')
                                    });
                                }
                            }
                        },
                        actions: {
                            add: {
                                label: 'label.add.NiciraNvp.device',
                                createForm: {
                                    title: 'label.add.NiciraNvp.device',
                                    preFilter: function (args) {
                                    },
                                    // TODO What is this?
                                    fields: {
                                        host: {
                                            label: 'label.ip.address'
                                        },
                                        username: {
                                            label: 'label.username'
                                        },
                                        password: {
                                            label: 'label.password',
                                            isPassword: true
                                        },
                                        numretries: {
                                            label: 'label.numretries',
                                            defaultValue: '2'
                                        },
                                        transportzoneuuid: {
                                            label: 'label.nicira.transportzoneuuid'
                                        },
                                        l3gatewayserviceuuid: {
                                            label: 'label.nicira.l3gatewayserviceuuid'
                                        },
										l2gatewayserviceuuid: {
                                            label: 'label.nicira.l2gatewayserviceuuid'
                                        }
                                    }
                                },
                                action: function (args) {
                                    if (nspMap[ "niciraNvp"] == null) {
                                        $.ajax({
                                            url: createURL("addNetworkServiceProvider&name=NiciraNvp&physicalnetworkid=" + selectedPhysicalNetworkObj.id),
                                            dataType: "json",
                                            async: true,
                                            success: function (json) {
                                                var jobId = json.addnetworkserviceproviderresponse.jobid;
                                                var addNiciraNvpProviderIntervalID = setInterval(function () {
                                                    $.ajax({
                                                        url: createURL("queryAsyncJobResult&jobId=" + jobId),
                                                        dataType: "json",
                                                        success: function (json) {
                                                            var result = json.queryasyncjobresultresponse;
                                                            if (result.jobstatus == 0) {
                                                                return; //Job has not completed
                                                            } else {
                                                                clearInterval(addNiciraNvpProviderIntervalID);
                                                                if (result.jobstatus == 1) {
                                                                    nspMap[ "niciraNvp"] = json.queryasyncjobresultresponse.jobresult.networkserviceprovider;
                                                                    addNiciraNvpDevice(args, selectedPhysicalNetworkObj, "addNiciraNvpDevice", "addniciranvpdeviceresponse", "niciranvpdevice")
                                                                } else if (result.jobstatus == 2) {
                                                                    alert("addNetworkServiceProvider&name=NiciraNvp failed. Error: " + _s(result.jobresult.errortext));
                                                                }
                                                            }
                                                        },
                                                        error: function (XMLHttpResponse) {
                                                            var errorMsg = parseXMLHttpResponse(XMLHttpResponse);
                                                            alert("addNetworkServiceProvider&name=NiciraNvp failed. Error: " + errorMsg);
                                                        }
                                                    });
                                                },
                                                g_queryAsyncJobResultInterval);
                                            }
                                        });
                                    } else {
                                        addNiciraNvpDevice(args, selectedPhysicalNetworkObj, "addNiciraNvpDevice", "addniciranvpdeviceresponse", "niciranvpdevice")
                                    }
                                },
                                messages: {
                                    notification: function (args) {
                                        return 'label.add.NiciraNvp.device';
                                    }
                                },
                                notification: {
                                    poll: pollAsyncJobResult
                                }
                            },
                            enable: {
                                label: 'label.enable.provider',
                                action: function (args) {
                                    $.ajax({
                                        url: createURL("updateNetworkServiceProvider&id=" + nspMap[ "niciraNvp"].id + "&state=Enabled"),
                                        dataType: "json",
                                        success: function (json) {
                                            var jid = json.updatenetworkserviceproviderresponse.jobid;
                                            args.response.success({
                                                _custom: {
                                                    jobId: jid,
                                                    getUpdatedItem: function (json) {
                                                        $(window).trigger('cloudStack.fullRefresh');
                                                    }
                                                }
                                            });
                                        }
                                    });
                                },
                                messages: {
                                    confirm: function (args) {
                                        return 'message.confirm.enable.provider';
                                    },
                                    notification: function () {
                                        return 'label.enable.provider';
                                    }
                                },
                                notification: {
                                    poll: pollAsyncJobResult
                                }
                            },
                            disable: {
                                label: 'label.disable.provider',
                                action: function (args) {
                                    $.ajax({
                                        url: createURL("updateNetworkServiceProvider&id=" + nspMap[ "niciraNvp"].id + "&state=Disabled"),
                                        dataType: "json",
                                        success: function (json) {
                                            var jid = json.updatenetworkserviceproviderresponse.jobid;
                                            args.response.success({
                                                _custom: {
                                                    jobId: jid,
                                                    getUpdatedItem: function (json) {
                                                        $(window).trigger('cloudStack.fullRefresh');
                                                    }
                                                }
                                            });
                                        }
                                    });
                                },
                                messages: {
                                    confirm: function (args) {
                                        return 'message.confirm.disable.provider';
                                    },
                                    notification: function () {
                                        return 'label.disable.provider';
                                    }
                                },
                                notification: {
                                    poll: pollAsyncJobResult
                                }
                            },
                            destroy: {
                                label: 'label.shutdown.provider',
                                action: function (args) {
                                    $.ajax({
                                        url: createURL("deleteNetworkServiceProvider&id=" + nspMap[ "niciraNvp"].id),
                                        dataType: "json",
                                        success: function (json) {
                                            var jid = json.deletenetworkserviceproviderresponse.jobid;
                                            args.response.success({
                                                _custom: {
                                                    jobId: jid
                                                }
                                            });

                                            $(window).trigger('cloudStack.fullRefresh');
                                        }
                                    });
                                },
                                messages: {
                                    confirm: function (args) {
                                        return 'message.confirm.shutdown.provider';
                                    },
                                    notification: function (args) {
                                        return 'label.shutdown.provider';
                                    }
                                },
                                notification: {
                                    poll: pollAsyncJobResult
                                }
                            }
                        }
                    },
                    // Brocade Vcs provider detail view
                    brocadeVcs: {
                        type: 'detailView',
                        id: 'brocadeVcsProvider',
                        label: 'label.brocadeVcs',
                        viewAll: {
                            label: 'label.devices',
                            path: '_zone.brocadeVcsDevices'
                        },
                        tabs: {
                            details: {
                                title: 'label.details',
                                fields:[ {
                                    name: {
                                        label: 'label.name'
                                    }
                                },
                                {
                                    state: {
                                        label: 'label.state'
                                    }
                                }],
                                dataProvider: function (args) {
                                    refreshNspData("BrocadeVcs");
                                    var providerObj;
                                    $(nspHardcodingArray).each(function () {
                                        if (this.id == "brocadeVcs") {
                                            providerObj = this;
                                            return false; //break each loop
                                        }
                                    });
                                    args.response.success({
                                        data: providerObj,
                                        actionFilter: networkProviderActionFilter('brocadeVcs')
                                    });
                                }
                            }
                        },
                        actions: {
                            add: {
                                label: 'label.add.BrocadeVcs.device',
                                createForm: {
                                    title: 'label.add.BrocadeVcs.device',
                                    preFilter: function (args) {
                                    },
                                    // TODO What is this?
                                    fields: {
                                        host: {
                                            label: 'label.ip.address'
                                        },
                                        username: {
                                            label: 'label.username'
                                        },
                                        password: {
                                            label: 'label.password',
                                            isPassword: true
                                        }
                                    }
                                },
                                action: function (args) {
                                    if (nspMap[ "brocadeVcs"] == null) {
                                        $.ajax({
                                            url: createURL("addNetworkServiceProvider&name=BrocadeVcs&physicalnetworkid=" + selectedPhysicalNetworkObj.id),
                                            dataType: "json",
                                            async: true,
                                            success: function (json) {
                                                var jobId = json.addnetworkserviceproviderresponse.jobid;
                                                var addBrocadeVcsProviderIntervalID = setInterval(function () {
                                                    $.ajax({
                                                        url: createURL("queryAsyncJobResult&jobId=" + jobId),
                                                        dataType: "json",
                                                        success: function (json) {
                                                            var result = json.queryasyncjobresultresponse;
                                                            if (result.jobstatus == 0) {
                                                                return; //Job has not completed
                                                            } else {
                                                                clearInterval(addBrocadeVcsProviderIntervalID);
                                                                if (result.jobstatus == 1) {
                                                                    nspMap[ "brocadeVcs"] = json.queryasyncjobresultresponse.jobresult.networkserviceprovider;
                                                                    addBrocadeVcsDevice(args, selectedPhysicalNetworkObj, "addBrocadeVcsDevice", "addbrocadevcsdeviceresponse", "brocadevcsdevice")
                                                                } else if (result.jobstatus == 2) {
                                                                    alert("addNetworkServiceProvider&name=BrocadeVcs failed. Error: " + _s(result.jobresult.errortext));
                                                                }
                                                            }
                                                        },
                                                        error: function (XMLHttpResponse) {
                                                            var errorMsg = parseXMLHttpResponse(XMLHttpResponse);
                                                            alert("addNetworkServiceProvider&name=BrocadeVcs failed. Error: " + errorMsg);
                                                        }
                                                    });
                                                },
                                                g_queryAsyncJobResultInterval);
                                            }
                                        });
                                    } else {
                                        addBrocadeVcsDevice(args, selectedPhysicalNetworkObj, "addBrocadeVcsDevice", "addbrocadevcsdeviceresponse", "brocadevcsdevice")
                                    }
                                },
                                messages: {
                                    notification: function (args) {
                                        return 'label.add.BrocadeVcs.device';
                                    }
                                },
                                notification: {
                                    poll: pollAsyncJobResult
                                }
                            },
                            enable: {
                                label: 'label.enable.provider',
                                action: function (args) {
                                    $.ajax({
                                        url: createURL("updateNetworkServiceProvider&id=" + nspMap[ "brocadeVcs"].id + "&state=Enabled"),
                                        dataType: "json",
                                        success: function (json) {
                                            var jid = json.updatenetworkserviceproviderresponse.jobid;
                                            args.response.success({
                                                _custom: {
                                                    jobId: jid,
                                                    getUpdatedItem: function (json) {
                                                        $(window).trigger('cloudStack.fullRefresh');
                                                    }
                                                }
                                            });
                                        }
                                    });
                                },
                                messages: {
                                    confirm: function (args) {
                                        return 'message.confirm.enable.provider';
                                    },
                                    notification: function () {
                                        return 'label.enable.provider';
                                    }
                                },
                                notification: {
                                    poll: pollAsyncJobResult
                                }
                            },
                            disable: {
                                label: 'label.disable.provider',
                                action: function (args) {
                                    $.ajax({
                                        url: createURL("updateNetworkServiceProvider&id=" + nspMap[ "brocadeVcs"].id + "&state=Disabled"),
                                        dataType: "json",
                                        success: function (json) {
                                            var jid = json.updatenetworkserviceproviderresponse.jobid;
                                            args.response.success({
                                                _custom: {
                                                    jobId: jid,
                                                    getUpdatedItem: function (json) {
                                                        $(window).trigger('cloudStack.fullRefresh');
                                                    }
                                                }
                                            });
                                        }
                                    });
                                },
                                messages: {
                                    confirm: function (args) {
                                        return 'message.confirm.disable.provider';
                                    },
                                    notification: function () {
                                        return 'label.disable.provider';
                                    }
                                },
                                notification: {
                                    poll: pollAsyncJobResult
                                }
                            },
                            destroy: {
                                label: 'label.shutdown.provider',
                                action: function (args) {
                                    $.ajax({
                                        url: createURL("deleteNetworkServiceProvider&id=" + nspMap[ "brocadeVcs"].id),
                                        dataType: "json",
                                        success: function (json) {
                                            var jid = json.deletenetworkserviceproviderresponse.jobid;
                                            args.response.success({
                                                _custom: {
                                                    jobId: jid
                                                }
                                            });
                                            $(window).trigger('cloudStack.fullRefresh');
                                        }
                                    });
                                },
                                messages: {
                                    confirm: function (args) {
                                        return 'message.confirm.shutdown.provider';
                                    },
                                    notification: function (args) {
                                        return 'label.shutdown.provider';
                                    }
                                },
                                notification: {
                                    poll: pollAsyncJobResult
                                }
                            }
                        }
                    },
                    // BigSwitch BCF provider detail view
                    bigswitchBcf: {
                        type: 'detailView',
                        id: 'bigswitchBcfProvider',
                        label: 'label.bigswitchBcf',
                        viewAll: {
                            label: 'label.devices',
                            path: '_zone.bigswitchBcfDevices'
                        },
                        tabs: {
                            details: {
                                title: 'label.details',
                                fields:[ {
                                    name: {
                                        label: 'label.name'
                                    }
                                },
                                {
                                    state: {
                                        label: 'label.state'
                                    }
                                }],
                                dataProvider: function (args) {
                                    refreshNspData("BigSwitchBcf");
                                    var providerObj;
                                    $(nspHardcodingArray).each(function () {
                                        if (this.id == "bigswitchBcf") {
                                            providerObj = this;
                                            return false;
                                        }
                                    });
                                    args.response.success({
                                        data: providerObj,
                                        actionFilter: networkProviderActionFilter('bigswitchBcf')
                                    });
                                }
                            }
                        },
                        actions: {
                            add: {
                                label: 'label.add.BigSwitchBcf.device',
                                createForm: {
                                    title: 'label.add.BigSwitchBcf.device',
                                    preFilter: function (args) {
                                    },
                                    fields: {
                                        host: {
                                            label: 'label.host.name'
                                        },
                                        username: {
                                            label: 'label.username'
                                        },
                                        password: {
                                            label: 'label.password',
                                            isPassword: true
                                        },
                                        nat: {
                                                label: 'label.bigswitch.bcf.nat',
                                                isBoolean: true,
                                                isChecked: false
                                        },
                                        numretries: {
                                            label: 'label.numretries',
                                            defaultValue: '2'
                                        }
                                    }
                                },
                                action: function (args) {
                                    if (nspMap[ "bigswitchBcf"] == null) {
                                        $.ajax({
                                            url: createURL("addNetworkServiceProvider&name=BigSwitchBcf&physicalnetworkid=" + selectedPhysicalNetworkObj.id),
                                            dataType: "json",
                                            async: true,
                                            success: function (json) {
                                                var jobId = json.addnetworkserviceproviderresponse.jobid;
                                                var addBigSwitchBcfProviderIntervalID = setInterval(function () {
                                                    $.ajax({
                                                        url: createURL("queryAsyncJobResult&jobId=" + jobId),
                                                        dataType: "json",
                                                        success: function (json) {
                                                            var result = json.queryasyncjobresultresponse;
                                                            if (result.jobstatus == 0) {
                                                                return; //Job has not completed
                                                            } else {
                                                                clearInterval(addBigSwitchBcfProviderIntervalID);
                                                                if (result.jobstatus == 1) {
                                                                    nspMap[ "bigswitchBcf"] = json.queryasyncjobresultresponse.jobresult.networkserviceprovider;
                                                                    addBigSwitchBcfDevice(args, selectedPhysicalNetworkObj, "addBigSwitchBcfDevice", "addbigswitchbcfdeviceresponse", "bigswitchbcfdevice")
                                                                } else if (result.jobstatus == 2) {
                                                                    alert("addNetworkServiceProvider&name=BigSwitchBcf failed. Error: " + _s(result.jobresult.errortext));
                                                                }
                                                            }
                                                        },
                                                        error: function (XMLHttpResponse) {
                                                            var errorMsg = parseXMLHttpResponse(XMLHttpResponse);
                                                            alert("addNetworkServiceProvider&name=BigSwitchBcf failed. Error: " + errorMsg);
                                                        }
                                                    });
                                                },
                                                3000);
                                            }
                                        });
                                    } else {
                                        addBigSwitchBcfDevice(args, selectedPhysicalNetworkObj, "addBigSwitchBcfDevice", "addbigswitchbcfdeviceresponse", "bigswitchbcfdevice")
                                    }
                                },
                                messages: {
                                    notification: function (args) {
                                        return 'label.add.BigSwitchBcf.device';
                                    }
                                },
                                notification: {
                                    poll: pollAsyncJobResult
                                }
                            },
                            enable: {
                                label: 'label.enable.provider',
                                action: function (args) {
                                    $.ajax({
                                        url: createURL("updateNetworkServiceProvider&id=" + nspMap[ "bigswitchBcf"].id + "&state=Enabled"),
                                        dataType: "json",
                                        success: function (json) {
                                            var jid = json.updatenetworkserviceproviderresponse.jobid;
                                            args.response.success({
                                                _custom: {
                                                    jobId: jid,
                                                    getUpdatedItem: function (json) {
                                                        $(window).trigger('cloudStack.fullRefresh');
                                                    }
                                                }
                                            });
                                        }
                                    });
                                },
                                messages: {
                                    confirm: function (args) {
                                        return 'message.confirm.enable.provider';
                                    },
                                    notification: function () {
                                        return 'label.enable.provider';
                                    }
                                },
                                notification: {
                                    poll: pollAsyncJobResult
                                }
                            },
                            disable: {
                                label: 'label.disable.provider',
                                action: function (args) {
                                    $.ajax({
                                        url: createURL("updateNetworkServiceProvider&id=" + nspMap[ "bigswitchBcf"].id + "&state=Disabled"),
                                        dataType: "json",
                                        success: function (json) {
                                            var jid = json.updatenetworkserviceproviderresponse.jobid;
                                            args.response.success({
                                                _custom: {
                                                    jobId: jid,
                                                    getUpdatedItem: function (json) {
                                                        $(window).trigger('cloudStack.fullRefresh');
                                                    }
                                                }
                                            });
                                        }
                                    });
                                },
                                messages: {
                                    confirm: function (args) {
                                        return 'message.confirm.disable.provider';
                                    },
                                    notification: function () {
                                        return 'label.disable.provider';
                                    }
                                },
                                notification: {
                                    poll: pollAsyncJobResult
                                }
                            },
                            destroy: {
                                label: 'label.shutdown.provider',
                                action: function (args) {
                                    $.ajax({
                                        url: createURL("deleteNetworkServiceProvider&id=" + nspMap[ "bigswitchBcf"].id),
                                        dataType: "json",
                                        success: function (json) {
                                            var jid = json.deletenetworkserviceproviderresponse.jobid;
                                            args.response.success({
                                                _custom: {
                                                    jobId: jid
                                                }
                                            });

                                            $(window).trigger('cloudStack.fullRefresh');
                                        }
                                    });
                                },
                                messages: {
                                    confirm: function (args) {
                                        return 'message.confirm.shutdown.provider';
                                    },
                                    notification: function (args) {
                                        return 'label.shutdown.provider';
                                    }
                                },
                                notification: {
                                    poll: pollAsyncJobResult
                                }
                            }
                        }
                    },

                    //ovs
                    Ovs: {
                        id: 'ovsProviders',
                        label: 'label.ovs',
                        isMaximized: true,
                        type: 'detailView',
                        fields: {
                            name: {
                                label: 'label.name'
                            },
                            ipaddress: {
                                label: 'label.ip.address'
                            },
                            state: {
                                label: 'label.status',
                                indicator: {
                                    'Enabled': 'on'
                                }
                            }
                        },
                        tabs: {
                            network: {
                                title: 'label.network',
                                fields:[ {
                                    name: {
                                        label: 'label.name'
                                    }
                                },
                                {
                                    id: {
                                        label: 'label.id'
                                    },
                                    state: {
                                        label: 'label.state'
                                    },
                                    physicalnetworkid: {
                                        label: 'label.physical.network.ID'
                                    },
                                    destinationphysicalnetworkid: {
                                        label: 'label.destination.physical.network.id'
                                    },
                                    supportedServices: {
                                        label: 'label.supported.services'
                                    }
                                }],
                                dataProvider: function (args) {
                                    refreshNspData("Ovs");
                                    args.response.success({
                                        actionFilter: virtualRouterProviderActionFilter,
                                        data: $.extend(nspMap[ "Ovs"], {
                                            supportedServices: nspMap["Ovs"] == undefined? "": nspMap["Ovs"].servicelist.join(', ')
                                        })
                                    });
                                }
                            },

                            instances: {
                                title: 'label.instances',
                                listView: {
                                    label: 'label.virtual.appliances',
                                    id: 'routers',
                                    fields: {
                                        name: {
                                            label: 'label.name'
                                        },
                                        zonename: {
                                            label: 'label.zone'
                                        },
                                        routerType: {
                                            label: 'label.type'
                                        },
                                        state: {
                                            converter: function (str) {
                                                // For localization
                                                return str;
                                            },
                                            label: 'label.status',
                                            indicator: {
                                                'Running': 'on',
                                                'Stopped': 'off',
                                                'Error': 'off'
                                            }
                                        }
                                    },
                                    dataProvider: function (args) {
                                        var array1 =[];
                                        if (args.filterBy != null) {
                                            if (args.filterBy.search != null && args.filterBy.search.by != null && args.filterBy.search.value != null) {
                                                switch (args.filterBy.search.by) {
                                                    case "name":
                                                    if (args.filterBy.search.value.length > 0)
                                                    array1.push("&keyword=" + args.filterBy.search.value);
                                                    break;
                                                }
                                            }
                                        }

                                        var data2 = {
                                            forvpc: false
                                        };
                                        var routers =[];
                                        $.ajax({
                                            url: createURL("listRouters&zoneid=" + selectedZoneObj.id + "&listAll=true&page=" + args.page + "&pagesize=" + pageSize + array1.join("")),
                                            data: data2,
                                            success: function (json) {
                                                var items = json.listroutersresponse.router ?
                                                json.listroutersresponse.router:[];

                                                $(items).map(function (index, item) {
                                                    routers.push(item);
                                                });

                                                // Get project routers
                                                $.ajax({
                                                    url: createURL("listRouters&zoneid=" + selectedZoneObj.id + "&page=" + args.page + "&pagesize=" + pageSize + array1.join("") + "&projectid=-1"),
                                                    data: data2,
                                                    success: function (json) {
                                                        var items = json.listroutersresponse.router ?
                                                        json.listroutersresponse.router:[];

                                                        $(items).map(function (index, item) {
                                                            routers.push(item);
                                                        });
                                                        args.response.success({
                                                            actionFilter: routerActionfilter,
                                                            data: $(routers).map(mapRouterType)
                                                        });
                                                    }
                                                });
                                            }
                                        });
                                    },
                                    detailView: {
                                        name: 'label.virtual.appliance.details',
                                        actions: {
                                            start: {
                                                label: 'label.action.start.router',
                                                messages: {
                                                    confirm: function (args) {
                                                        return 'message.action.start.router';
                                                    },
                                                    notification: function (args) {
                                                        return 'label.action.start.router';
                                                    }
                                                },
                                                action: function (args) {
                                                    $.ajax({
                                                        url: createURL('startRouter&id=' + args.context.routers[0].id),
                                                        dataType: 'json',
                                                        async: true,
                                                        success: function (json) {
                                                            var jid = json.startrouterresponse.jobid;
                                                            args.response.success({
                                                                _custom: {
                                                                    jobId: jid,
                                                                    getUpdatedItem: function (json) {
                                                                        return json.queryasyncjobresultresponse.jobresult.domainrouter;
                                                                    },
                                                                    getActionFilter: function () {
                                                                        return routerActionfilter;
                                                                    }
                                                                }
                                                            });
                                                        }
                                                    });
                                                },
                                                notification: {
                                                    poll: pollAsyncJobResult
                                                }
                                            },

                                            stop: {
                                                label: 'label.action.stop.router',
                                                createForm: {
                                                    title: 'label.action.stop.router',
                                                    desc: 'message.action.stop.router',
                                                    fields: {
                                                        forced: {
                                                            label: 'force.stop',
                                                            isBoolean: true,
                                                            isChecked: false
                                                        }
                                                    }
                                                },
                                                messages: {
                                                    notification: function (args) {
                                                        return 'label.action.stop.router';
                                                    }
                                                },
                                                action: function (args) {
                                                    var array1 =[];
                                                    array1.push("&forced=" + (args.data.forced == "on"));
                                                    $.ajax({
                                                        url: createURL('stopRouter&id=' + args.context.routers[0].id + array1.join("")),
                                                        dataType: 'json',
                                                        async: true,
                                                        success: function (json) {
                                                            var jid = json.stoprouterresponse.jobid;
                                                            args.response.success({
                                                                _custom: {
                                                                    jobId: jid,
                                                                    getUpdatedItem: function (json) {
                                                                        return json.queryasyncjobresultresponse.jobresult.domainrouter;
                                                                    },
                                                                    getActionFilter: function () {
                                                                        return routerActionfilter;
                                                                    }
                                                                }
                                                            });
                                                        }
                                                    });
                                                },
                                                notification: {
                                                    poll: pollAsyncJobResult
                                                }
                                            },

                                            'remove': {
                                                label: 'label.destroy.router',
                                                messages: {
                                                    confirm: function (args) {
                                                        if (args && args.context && args.context.routers[0]) {
                                                            if (args.context.routers[0].state == 'Running') {
                                                                return dictionary['message.action.stop.router'] + ' ' + dictionary['message.confirm.destroy.router'];
                                                            }
                                                        }
                                                        return 'message.confirm.destroy.router';
                                                    },
                                                    notification: function (args) {
                                                        return 'label.destroy.router';
                                                    }
                                                },
                                                action: function (args) {
                                                    $.ajax({
                                                        url: createURL("destroyRouter&id=" + args.context.routers[0].id),
                                                        dataType: "json",
                                                        async: true,
                                                        success: function (json) {
                                                            var jid = json.destroyrouterresponse.jobid;
                                                            args.response.success({
                                                                _custom: {
                                                                    jobId: jid
                                                                }
                                                            });
                                                        }
                                                    });
                                                },
                                                notification: {
                                                    poll: pollAsyncJobResult
                                                }
                                            },

                                            migrate: {
                                                label: 'label.action.migrate.router',
                                                createForm: {
                                                    title: 'label.action.migrate.router',
                                                    desc: '',
                                                    fields: {
                                                        hostId: {
                                                            label: 'label.host',
                                                            validation: {
                                                                required: true
                                                            },
                                                            select: function (args) {
                                                                $.ajax({
                                                                    url: createURL("findHostsForMigration&VirtualMachineId=" + args.context.routers[0].id),
                                                                    dataType: "json",
                                                                    async: true,
                                                                    success: function (json) {
                                                                        var hostObjs = json.findhostsformigrationresponse.host;
                                                                        var items =[];
                                                                        $(hostObjs).each(function () {
                                                                            items.push({
                                                                                id: this.id,
                                                                                description: (this.name + " (" + (this.suitableformigration ? "Suitable": "Not Suitable") + ")")
                                                                            });
                                                                        });
                                                                        args.response.success({
                                                                            data: items
                                                                        });
                                                                    }
                                                                });
                                                            },
                                                            error: function (XMLHttpResponse) {
                                                                var errorMsg = parseXMLHttpResponse(XMLHttpResponse);
                                                                args.response.error(errorMsg);
                                                            }
                                                        }
                                                    }
                                                },
                                                messages: {
                                                    notification: function (args) {
                                                        return 'label.action.migrate.router';
                                                    }
                                                },
                                                action: function (args) {
                                                    $.ajax({
                                                        url: createURL("migrateSystemVm&hostid=" + args.data.hostId + "&virtualmachineid=" + args.context.routers[0].id),
                                                        dataType: "json",
                                                        async: true,
                                                        success: function (json) {
                                                            var jid = json.migratesystemvmresponse.jobid;
                                                            args.response.success({
                                                                _custom: {
                                                                    jobId: jid,
                                                                    getUpdatedItem: function (json) {
                                                                        //return json.queryasyncjobresultresponse.jobresult.systemvminstance;    //not all properties returned in systemvminstance
                                                                        $.ajax({
                                                                            url: createURL("listRouters&id=" + json.queryasyncjobresultresponse.jobresult.systemvm.id),
                                                                            dataType: "json",
                                                                            async: false,
                                                                            success: function (json) {
                                                                                var items = json.listroutersresponse.router;
                                                                                if (items != null && items.length > 0) {
                                                                                    return items[0];
                                                                                }
                                                                            }
                                                                        });
                                                                    },
                                                                    getActionFilter: function () {
                                                                        return routerActionfilter;
                                                                    }
                                                                }
                                                            });
                                                        }
                                                    });
                                                },
                                                notification: {
                                                    poll: pollAsyncJobResult
                                                }
                                            },

                                            viewConsole: {
                                                label: 'label.view.console',
                                                action: {
                                                    externalLink: {
                                                        url: function (args) {
                                                            return clientConsoleUrl + '?cmd=access&vm=' + args.context.routers[0].id;
                                                        },
                                                        title: function (args) {
                                                            return args.context.routers[0].id.substr(0, 8);
                                                            //title in window.open() can't have space nor longer than 8 characters. Otherwise, IE browser will have error.
                                                        },
                                                        width: 820,
                                                        height: 640
                                                    }
                                                }
                                            }
                                        },
                                        tabs: {
                                            details: {
                                                title: 'label.details',
                                                preFilter: function (args) {
                                                    var hiddenFields =[];
                                                    if (! args.context.routers[0].project) {
                                                        hiddenFields.push('project');
                                                        hiddenFields.push('projectid');
                                                    }
                                                    if (selectedZoneObj.networktype == 'Basic') {
                                                        hiddenFields.push('publicip');
                                                        //In Basic zone, guest IP is public IP. So, publicip is not returned by listRouters API. Only guestipaddress is returned by listRouters API.
                                                    }

                                                    if ('routers' in args.context && args.context.routers[0].vpcid != undefined) {
                                                        hiddenFields.push('guestnetworkid');
                                                        hiddenFields.push('guestnetworkname');
                                                    } else if ('routers' in args.context && args.context.routers[0].guestnetworkid != undefined) {
                                                        hiddenFields.push('vpcid');
                                                        hiddenFields.push('vpcname');
                                                    }

                                                    return hiddenFields;
                                                },
                                                fields:[ {
                                                    name: {
                                                        label: 'label.name'
                                                    },
                                                    project: {
                                                        label: 'label.project'
                                                    }
                                                },
                                                {
                                                    id: {
                                                        label: 'label.id'
                                                    },
                                                    projectid: {
                                                        label: 'label.project.id'
                                                    },
                                                    state: {
                                                        label: 'label.state'
                                                    },
                                                    guestnetworkid: {
                                                        label: 'label.network.id'
                                                    },
                                                    guestnetworkname: {
                                                        label: 'label.network.name'
                                                    },
                                                    vpcid: {
                                                        label: 'label.vpc.id'
                                                    },
                                                    vpcname: {
                                                        label: 'label.vpc'
                                                    },
                                                    publicip: {
                                                        label: 'label.public.ip'
                                                    },
                                                    guestipaddress: {
                                                        label: 'label.guest.ip'
                                                    },
                                                    linklocalip: {
                                                        label: 'label.linklocal.ip'
                                                    },
                                                    hostname: {
                                                        label: 'label.host'
                                                    },
                                                    serviceofferingname: {
                                                        label: 'label.compute.offering'
                                                    },
                                                    networkdomain: {
                                                        label: 'label.network.domain'
                                                    },
                                                    domain: {
                                                        label: 'label.domain'
                                                    },
                                                    account: {
                                                        label: 'label.account'
                                                    },
                                                    created: {
                                                        label: 'label.created',
                                                        converter: cloudStack.converters.toLocalDate
                                                    },
                                                    isredundantrouter: {
                                                        label: 'label.redundant.router',
                                                        converter: cloudStack.converters.toBooleanText
                                                    },
                                                    redundantRouterState: {
                                                        label: 'label.redundant.state'
                                                    }
                                                }],
                                                dataProvider: function (args) {
                                                    $.ajax({
                                                        url: createURL("listRouters&id=" + args.context.routers[0].id),
                                                        dataType: 'json',
                                                        async: true,
                                                        success: function (json) {
                                                            var jsonObj = json.listroutersresponse.router[0];
                                                            addExtraPropertiesToRouterInstanceObject(jsonObj);
                                                            args.response.success({
                                                                actionFilter: routerActionfilter,
                                                                data: jsonObj
                                                            });
                                                        }
                                                    });
                                                }
                                            },
                                            nics: {
                                                title: 'label.nics',
                                                multiple: true,
                                                fields:[ {
                                                    name: {
                                                        label: 'label.name',
                                                        header: true
                                                    },
                                                    type: {
                                                        label: 'label.type'
                                                    },
                                                    traffictype: {
                                                        label: 'label.traffic.type'
                                                    },
                                                    networkname: {
                                                        label: 'label.network.name'
                                                    },
                                                    netmask: {
                                                        label: 'label.netmask'
                                                    },
                                                    ipaddress: {
                                                        label: 'label.ip.address'
                                                    },
                                                    id: {
                                                        label: 'label.id'
                                                    },
                                                    networkid: {
                                                        label: 'label.network.id'
                                                    },
                                                    isolationuri: {
                                                        label: 'label.isolation.uri'
                                                    },
                                                    broadcasturi: {
                                                        label: 'label.broadcast.uri'
                                                    }
                                                }],
                                                dataProvider: function (args) {
                                                    $.ajax({
                                                        url: createURL("listRouters&id=" + args.context.routers[0].id),
                                                        dataType: 'json',
                                                        async: true,
                                                        success: function (json) {
                                                            var jsonObj = json.listroutersresponse.router[0].nic;

                                                            args.response.success({
                                                                actionFilter: routerActionfilter,
                                                                data: $.map(jsonObj, function (nic, index) {
                                                                    var name = 'NIC ' + (index + 1);
                                                                    if (nic.isdefault) {
                                                                        name += ' (' + _l('label.default') + ')';
                                                                    }
                                                                    return $.extend(nic, {
                                                                        name: name
                                                                    });
                                                                })
                                                            });
                                                        }
                                                    });
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        },
                        actions: {
                            enable: {
                                label: 'label.enable.provider',
                                action: function (args) {
                                    $.ajax({
                                        url: createURL("updateNetworkServiceProvider&id=" + nspMap[ "Ovs"].id + "&state=Enabled"),
                                        dataType: "json",
                                        success: function (json) {
                                            var jid = json.updatenetworkserviceproviderresponse.jobid;
                                            args.response.success({
                                                _custom: {
                                                    jobId: jid,
                                                    getUpdatedItem: function (json) {
                                                        $(window).trigger('cloudStack.fullRefresh');
                                                    }
                                                }
                                            });
                                        }
                                    });
                                },
                                messages: {
                                    confirm: function (args) {
                                        return 'message.confirm.enable.provider';
                                    },
                                    notification: function () {
                                        return 'label.enable.provider';
                                    }
                                },
                                notification: {
                                    poll: pollAsyncJobResult
                                }
                            },
                            disable: {
                                label: 'label.disable.provider',
                                action: function (args) {
                                    $.ajax({
                                        url: createURL("updateNetworkServiceProvider&id=" + nspMap[ "Ovs"].id + "&state=Disabled"),
                                        dataType: "json",
                                        success: function (json) {
                                            var jid = json.updatenetworkserviceproviderresponse.jobid;
                                            args.response.success({
                                                _custom: {
                                                    jobId: jid,
                                                    getUpdatedItem: function (json) {
                                                        $(window).trigger('cloudStack.fullRefresh');
                                                    }
                                                }
                                            });
                                        }
                                    });
                                },
                                messages: {
                                    confirm: function (args) {
                                        return 'message.confirm.disable.provider';
                                    },
                                    notification: function () {
                                        return 'label.disable.provider';
                                    }
                                },
                                notification: {
                                    poll: pollAsyncJobResult
                                }
                            }
                        }
                    },

                    Opendaylight: {
                        type: 'detailView',
                        id: 'openDaylightProvider',
                        label: 'label.openDaylight',
                        tabs: {
                            details: {
                                title: 'label.details',
                                fields:[ {
                                    name: {
                                        label: 'label.name'
                                    }
                                },
                                {
                                    state: {
                                        label: 'label.state'
                                    }
                                }],
                                dataProvider: function (args) {
                                    refreshNspData("Opendaylight");
                                    var providerObj;
                                    $(nspHardcodingArray).each(function () {
                                        if (this.id == "Opendaylight") {
                                            providerObj = this;
                                            return false; //break each loop
                                        }
                                    });
                                    args.response.success({
                                        data: providerObj,
                                        actionFilter: networkProviderActionFilter('Opendaylight')
                                    });
                                }
                            },
                            controllers: {
                                title: 'label.opendaylight.controllers',
                                listView: {
                                    id: 'openDaylightControllerList',
                                    fields: {
                                        name: {
                                            label: 'label.name'
                                        },
                                        url: {
                                            label: 'label.url'
                                        },
                                        username: {
                                            label: 'label.username'
                                        }
                                    },
                                    dataProvider: function (args) {
                                        var providerObj
                                        $.ajax({
                                            url: createURL("listOpenDaylightControllers"),
                                            async: false,
                                            success: function (json) {
                                                providerObj = json.listOpenDaylightControllers.opendaylightcontroller
                                            }
                                        });
                                        args.response.success({
                                            data: providerObj
                                        });
                                    },
                                    detailView: {
                                        name: "OpenDaylight Controller",
                                        tabs: {
                                            details: {
                                                title: 'label.opendaylight.controllerdetail',
                                                fields:[ {
                                                    name: {
                                                        label: 'label.name'
                                                    },
                                                    url: {
                                                        label: 'label.url', header: true
                                                    },
                                                    username: {
                                                        label: 'label.username'
                                                    }
                                                }],
                                                dataProvider: function (args) {
                                                    var providerObj
                                                    $.ajax({
                                                        url: createURL("listOpenDaylightControllers&id=" + args.id),
                                                        async: false,
                                                        success: function (json) {
                                                            providerObj = json.listOpenDaylightControllers.opendaylightcontroller
                                                        }
                                                    });
                                                    args.response.success({
                                                        data: providerObj[0],
                                                        actionFilter: function(args) { return [ 'destroy' ] }
                                                    });
                                                }
                                            }
                                        },
                                        actions: {
                                            destroy: {
                                                label: 'label.delete.OpenDaylight.device',
                                                action: function (args) {
                                                    $.ajax({
                                                        url: createURL("deleteOpenDaylightController&id=" + args.data.id),
                                                        dataType: "json",
                                                        success: function (json) {
                                                            var jid = json.deleteOpenDaylightController.jobid;
                                                            args.response.success({
                                                                _custom: {
                                                                    jobId: jid,
                                                                    getUpdatedItem: function (json) {
                                                                        $(window).trigger('cloudStack.fullRefresh');
                                                                    }
                                                                }
                                                            });
                                                        }
                                                    });
                                                },
                                                messages: {
                                                    notification: function(args) {
                                                        return 'label.openaylight.destroycontroller'
                                                    }
                                                },
                                                notification: {
                                                    poll: pollAsyncJobResult
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        },
                        actions: {
                            add: {
                                label: 'label.add.OpenDaylight.device',
                                createForm: {
                                    title: 'label.add.OpenDaylight.device',
                                    preFilter: function (args) {
                                    },
                                    // TODO What is this?
                                    fields: {
                                        url: {
                                            label: 'label.url'
                                        },
                                        username: {
                                            label: 'label.username'
                                        },
                                        password: {
                                            label: 'label.password',
                                            isPassword: true
                                        },
                                        numretries: {
                                            label: 'label.numretries',
                                            defaultValue: '2'
                                        }
                                    }
                                },
                                action: function (args) {
                                    if (nspMap[ "Opendaylight"] == null) {
                                        $.ajax({
                                            url: createURL("addNetworkServiceProvider&name=Opendaylight&physicalnetworkid=" + selectedPhysicalNetworkObj.id),
                                            dataType: "json",
                                            async: true,
                                            success: function (json) {
                                                var jobId = json.addnetworkserviceproviderresponse.jobid;
                                                var addOpenDaylightProviderIntervalID = setInterval(function () {
                                                    $.ajax({
                                                        url: createURL("queryAsyncJobResult&jobId=" + jobId),
                                                        dataType: "json",
                                                        success: function (json) {
                                                            var result = json.queryasyncjobresultresponse;
                                                            if (result.jobstatus == 0) {
                                                                return; //Job has not completed
                                                            } else {
                                                                clearInterval(addOpenDaylightProviderIntervalID);
                                                                if (result.jobstatus == 1) {
                                                                    nspMap[ "Opendaylight"] = json.queryasyncjobresultresponse.jobresult.networkserviceprovider;
                                                                    addOpenDaylightController(args, selectedPhysicalNetworkObj, "addOpenDaylightController", "addopendaylightcontrollerresponse", "opendaylightcontroller")
                                                                } else if (result.jobstatus == 2) {
                                                                    alert("addNetworkServiceProvider&name=OpenDaylight failed. Error: " + _s(result.jobresult.errortext));
                                                                }
                                                            }
                                                        },
                                                        error: function (XMLHttpResponse) {
                                                            var errorMsg = parseXMLHttpResponse(XMLHttpResponse);
                                                            alert("addNetworkServiceProvider&name=OpenDaylight failed. Error: " + errorMsg);
                                                        }
                                                    });
                                                },
                                                g_queryAsyncJobResultInterval);
                                            }
                                        });
                                    } else {
                                        addOpenDaylightController(args, selectedPhysicalNetworkObj, "addOpenDaylightController", "addOpenDaylightController", "opendaylightcontroller")
                                    }
                                },
                                messages: {
                                    notification: function (args) {
                                        return 'label.add.OpenDaylight.device';
                                    }
                                },
                                notification: {
                                    poll: pollAsyncJobResult
                                }
                            },
                            enable: {
                                label: 'label.enable.provider',
                                action: function (args) {
                                    $.ajax({
                                        url: createURL("updateNetworkServiceProvider&id=" + nspMap[ "Opendaylight"].id + "&state=Enabled"),
                                        dataType: "json",
                                        success: function (json) {
                                            var jid = json.updatenetworkserviceproviderresponse.jobid;
                                            args.response.success({
                                                _custom: {
                                                    jobId: jid,
                                                    getUpdatedItem: function (json) {
                                                        $(window).trigger('cloudStack.fullRefresh');
                                                    }
                                                }
                                            });
                                        }
                                    });
                                },
                                messages: {
                                    confirm: function (args) {
                                        return 'message.confirm.enable.provider';
                                    },
                                    notification: function () {
                                        return 'label.enable.provider';
                                    }
                                },
                                notification: {
                                    poll: pollAsyncJobResult
                                }
                            },
                            disable: {
                                label: 'label.disable.provider',
                                action: function (args) {
                                    $.ajax({
                                        url: createURL("updateNetworkServiceProvider&id=" + nspMap[ "Opendaylight"].id + "&state=Disabled"),
                                        dataType: "json",
                                        success: function (json) {
                                            var jid = json.updatenetworkserviceproviderresponse.jobid;
                                            args.response.success({
                                                _custom: {
                                                    jobId: jid,
                                                    getUpdatedItem: function (json) {
                                                        $(window).trigger('cloudStack.fullRefresh');
                                                    }
                                                }
                                            });
                                        }
                                    });
                                },
                                messages: {
                                    confirm: function (args) {
                                        return 'message.confirm.disable.provider';
                                    },
                                    notification: function () {
                                        return 'label.disable.provider';
                                    }
                                },
                                notification: {
                                    poll: pollAsyncJobResult
                                }
                            },
                            destroy: {
                                label: 'label.shutdown.provider',
                                action: function (args) {
                                    $.ajax({
                                        url: createURL("deleteNetworkServiceProvider&id=" + nspMap[ "Opendaylight"].id),
                                        dataType: "json",
                                        success: function (json) {
                                            var jid = json.deletenetworkserviceproviderresponse.jobid;
                                            args.response.success({
                                                _custom: {
                                                    jobId: jid
                                                }
                                            });

                                            $(window).trigger('cloudStack.fullRefresh');
                                        }
                                    });
                                },
                                messages: {
                                    confirm: function (args) {
                                        return 'message.confirm.shutdown.provider';
                                    },
                                    notification: function (args) {
                                        return 'label.shutdown.provider';
                                    }
                                },
                                notification: {
                                    poll: pollAsyncJobResult
                                }
                            }
                        }
                    },

                    // GloboDns provider detail view
                    GloboDns: {
                        isMaximized: true,
                        type: 'detailView',
                        id: 'globoDnsProvider',
                        label: 'label.globo.dns',
                        tabs: {
                            details: {
                                title: 'label.details',
                                fields: [{
                                    name: {
                                        label: 'label.name'
                                    }
                                }, {
                                    state: {
                                        label: 'label.state'
                                    }
                                }],
                                dataProvider: function(args) {
                                    refreshNspData("GloboDns");
                                    var providerObj;
                                    $(nspHardcodingArray).each(function() {
                                        if (this.id == "GloboDns") {
                                            providerObj = this;
                                            return false; //break each loop
                                        }
                                    });
                                    args.response.success({
                                        data: providerObj,
                                        actionFilter: networkProviderActionFilter('GloboDns')
                                    });
                                }
                            }
                        },
                        actions: {
                            add: {
                                label: 'label.globo.dns.configuration',
                                createForm: {
                                    title: 'label.globo.dns.configuration',
                                    preFilter: function(args) {},
                                    fields: {
                                        username: {
                                            label: 'label.username',
                                            validation: {
                                                required: true
                                            }
                                        },
                                        password: {
                                            label: 'label.password',
                                            isPassword: true,
                                            validation: {
                                                required: true
                                            }
                                        },
                                        url: {
                                            label: 'label.url',
                                            validation: {
                                                required: true
                                            }
                                        }
                                    }
                                },
                                action: function(args) {
                                    if (nspMap["GloboDns"] == null) {
                                        $.ajax({
                                            url: createURL("addNetworkServiceProvider&name=GloboDns&physicalnetworkid=" + selectedPhysicalNetworkObj.id),
                                            dataType: "json",
                                            async: true,
                                            success: function(json) {
                                                var jobId = json.addnetworkserviceproviderresponse.jobid;
                                                var addGloboDnsProviderIntervalID = setInterval(function() {
                                                    $.ajax({
                                                        url: createURL("queryAsyncJobResult&jobId=" + jobId),
                                                        dataType: "json",
                                                        success: function(json) {
                                                            var result = json.queryasyncjobresultresponse;
                                                            if (result.jobstatus == 0) {
                                                                return; //Job has not completed
                                                            } else {
                                                                clearInterval(addGloboDnsProviderIntervalID);
                                                                if (result.jobstatus == 1) {
                                                                    nspMap["GloboDns"] = json.queryasyncjobresultresponse.jobresult.networkserviceprovider;
                                                                    addGloboDnsHost(args, selectedPhysicalNetworkObj, "addGloboDnsHost", "addglobodnshostresponse");
                                                                } else if (result.jobstatus == 2) {
                                                                    alert("addNetworkServiceProvider&name=GloboDns failed. Error: " + _s(result.jobresult.errortext));
                                                                }
                                                            }
                                                        },
                                                        error: function(XMLHttpResponse) {
                                                            var errorMsg = parseXMLHttpResponse(XMLHttpResponse);
                                                            alert("addNetworkServiceProvider&name=GloboDns failed. Error: " + errorMsg);
                                                        }
                                                    });
                                                }, g_queryAsyncJobResultInterval);
                                            }
                                        });
                                    } else {
                                        addGloboDnsHost(args, selectedPhysicalNetworkObj, "addGloboDnsHost", "addglobodnshostresponse");
                                    }
                                },
                                messages: {
                                    notification: function(args) {
                                        return 'label.add.globo.dns';
                                    }
                                },
                                notification: {
                                    poll: pollAsyncJobResult
                                }
                            },
                            enable: {
                                label: 'label.enable.provider',
                                action: function(args) {
                                    $.ajax({
                                        url: createURL("updateNetworkServiceProvider&id=" + nspMap["GloboDns"].id + "&state=Enabled"),
                                        dataType: "json",
                                        success: function(json) {
                                            var jid = json.updatenetworkserviceproviderresponse.jobid;
                                            args.response.success({
                                                _custom: {
                                                    jobId: jid,
                                                    getUpdatedItem: function(json) {
                                                        $(window).trigger('cloudStack.fullRefresh');
                                                    }
                                                }
                                            });
                                        }
                                    });
                                },
                                messages: {
                                    confirm: function(args) {
                                        return 'message.confirm.enable.provider';
                                    },
                                    notification: function() {
                                        return 'label.enable.provider';
                                    }
                                },
                                notification: {
                                    poll: pollAsyncJobResult
                                }
                            },
                            disable: {
                                label: 'label.disable.provider',
                                action: function(args) {
                                    $.ajax({
                                        url: createURL("updateNetworkServiceProvider&id=" + nspMap["GloboDns"].id + "&state=Disabled"),
                                        dataType: "json",
                                        success: function(json) {
                                            var jid = json.updatenetworkserviceproviderresponse.jobid;
                                            args.response.success({
                                                _custom: {
                                                    jobId: jid,
                                                    getUpdatedItem: function(json) {
                                                        $(window).trigger('cloudStack.fullRefresh');
                                                    }
                                                }
                                            });
                                        }
                                    });
                                },
                                messages: {
                                    confirm: function(args) {
                                        return 'message.confirm.disable.provider';
                                    },
                                    notification: function() {
                                        return 'label.disable.provider';
                                    }
                                },
                                notification: {
                                    poll: pollAsyncJobResult
                                }
                            },
                            destroy: {
                                label: 'label.shutdown.provider',
                                action: function(args) {
                                    $.ajax({
                                        url: createURL("deleteNetworkServiceProvider&id=" + nspMap["GloboDns"].id),
                                        dataType: "json",
                                        success: function(json) {
                                            var jid = json.deletenetworkserviceproviderresponse.jobid;
                                            args.response.success({
                                                _custom: {
                                                    jobId: jid
                                                }
                                            });

                                            $(window).trigger('cloudStack.fullRefresh');
                                        }
                                    });
                                },
                                messages: {
                                    confirm: function(args) {
                                        return 'message.confirm.shutdown.provider';
                                    },
                                    notification: function(args) {
                                        return 'label.shutdown.provider';
                                    }
                                },
                                notification: {
                                    poll: pollAsyncJobResult
                                }
                            }
                        }
                    },

                    ConfigDrive: {
                        id: "ConfigDrive",
                        label: "ConfigDrive",
                        isMaximized: true,
                        type: 'detailView',
                        fields: {
                            name: {
                                label: 'label.name'
                            },
                            state: {
                                label: 'label.status',
                                indicator: {
                                    'Enabled': 'on'
                                }
                            }
                        },
                        tabs: {
                            network: {
                                title: 'label.network',
                                fields: [{
                                    name: {
                                        label: 'label.name'
                                    }
                                }, {
                                    state: {
                                        label: 'label.state'
                                    },
                                    supportedServices: {
                                        label: 'label.supported.services'
                                    },
                                    id: {
                                        label: 'label.id'
                                    },
                                    physicalnetworkid: {
                                        label: 'label.physical.network.ID'
                                    }
                                }],
                                dataProvider: function(args) {
                                    refreshNspData("ConfigDrive");
                                    args.response.success({
                                        actionFilter: ovsProviderActionFilter,
                                        data: $.extend(nspMap["ConfigDrive"], {
                                            supportedServices: nspMap["ConfigDrive"] == undefined? "": nspMap["ConfigDrive"].servicelist.join(', ')
                                        })
                                    });
                                }
                            }
                        },
                        actions: {
                            enable: {
                                label: 'label.enable.provider',
                                action: function(args) {
                                    $.ajax({
                                        url: createURL("updateNetworkServiceProvider&id=" + nspMap["ConfigDrive"].id + "&state=Enabled"),
                                        dataType: "json",
                                        success: function(json) {
                                            var jid = json.updatenetworkserviceproviderresponse.jobid;
                                            args.response.success({
                                                _custom: {
                                                    jobId: jid,
                                                    getUpdatedItem: function(json) {
                                                        $(window).trigger('cloudStack.fullRefresh');
                                                    }
                                                }
                                            });
                                        }
                                    });
                                },
                                messages: {
                                    confirm: function(args) {
                                        return 'message.confirm.enable.provider';
                                    },
                                    notification: function() {
                                        return 'label.enable.provider';
                                    }
                                },
                                notification: {
                                    poll: pollAsyncJobResult
                                }
                            },
                            disable: {
                                label: 'label.disable.provider',
                                action: function(args) {
                                    $.ajax({
                                        url: createURL("updateNetworkServiceProvider&id=" + nspMap["ConfigDrive"].id + "&state=Disabled"),
                                        dataType: "json",
                                        success: function(json) {
                                            var jid = json.updatenetworkserviceproviderresponse.jobid;
                                            args.response.success({
                                                _custom: {
                                                    jobId: jid,
                                                    getUpdatedItem: function(json) {
                                                        $(window).trigger('cloudStack.fullRefresh');
                                                    }
                                                }
                                            });
                                        }
                                    });
                                },
                                messages: {
                                    confirm: function(args) {
                                        return 'message.confirm.disable.provider';
                                    },
                                    notification: function() {
                                        return 'label.disable.provider';
                                    }
                                },
                                notification: {
                                    poll: pollAsyncJobResult
                                }
                            }
                        }
                    }
                }
            }
        },
        physicalResourceSection: {
            sections: {
                physicalResources: {
                    type: 'select',
                    title: 'label.menu.physical.resources',
                    listView: {
                        zones: {
                            id: 'physicalResources',
                            label: 'label.menu.physical.resources',
                            multiSelect: true,
                            fields: {
                                name: {
                                    label: 'label.zone'
                                },
                                networktype: {
                                    label: 'label.network.type'
                                },
                                domainid: {
                                    label: 'label.public',
                                    converter: function (args) {
                                        if (args == null)
                                        return "Yes"; else
                                        return "No";
                                    }
                                },
                                allocationstate: {
                                    label: 'label.allocation.state',
                                    converter: function (str) {
                                        // For localization
                                        return str;
                                    },
                                    indicator: {
                                        'Enabled': 'on',
                                        'Disabled': 'off'
                                    }
                                }
                            },

                            reorder: cloudStack.api.actions.sort('updateZone', 'physicalResources'),

                            dataProvider: function (args) {
                                var array1 =[];
                                if (args.filterBy != null) {
                                    if (args.filterBy.search != null && args.filterBy.search.by != null && args.filterBy.search.value != null) {
                                        switch (args.filterBy.search.by) {
                                            case "name":
                                            if (args.filterBy.search.value.length > 0)
                                            array1.push("&keyword=" + args.filterBy.search.value);
                                            break;
                                        }
                                    }
                                }
                                $.ajax({
                                    url: createURL("listZones&page=" + args.page + "&pagesize=" + pageSize + array1.join("")),
                                    dataType: "json",
                                    async: true,
                                    success: function (json) {
                                        zoneObjs = json.listzonesresponse.zone;
                                        args.response.success({
                                            actionFilter: zoneActionfilter,
                                            data: zoneObjs
                                        });
                                    }
                                });
                            },

                            actions: {
                                add: {
                                    label: 'label.add.zone',
                                    action: {
                                        custom: cloudStack.uiCustom.zoneWizard(
                                        cloudStack.zoneWizard)
                                    },
                                    messages: {
                                        notification: function (args) {
                                            return 'label.add.zone';
                                        }
                                    },
                                    notification: {
                                        poll: function (args) {
                                            args.complete({
                                                actionFilter: zoneActionfilter,
                                                data: args._custom.zone
                                            });
                                        }
                                    }
                                },
                                viewMetrics: {
                                    label: 'label.metrics',
                                    isHeader: true,
                                    addRow: false,
                                    action: {
                                        custom: cloudStack.uiCustom.metricsView({resource: 'zones'})
                                    },
                                    messages: {
                                        notification: function (args) {
                                            return 'label.metrics';
                                        }
                                    }
                                },
                                startRollingMaintenance: rollingMaintenanceAction({ listView: true, entity: 'zones' })
                            },

                            detailView: {
                                isMaximized: true,
                                actions: {

                                    startRollingMaintenance: {
                                        label: 'label.start.rolling.maintenance',
                                        textLabel: 'label.start.rolling.maintenance',
                                        messages: {
                                            notification: function (args) {
                                                return 'label.start.rolling.maintenance';
                                            }
                                        },
                                        createForm: {
                                            title: 'label.start.rolling.maintenance',
                                            fields: {
                                                timeout: {
                                                    label: 'label.timeout',
                                                },
                                                force: {
                                                    isBoolean: true,
                                                    label: 'label.start.rolling.maintenance.force'
                                                },
                                                payload: {
                                                    label: 'label.start.rolling.maintenance.payload'
                                                }
                                            }
                                        },
                                        action: function (args) {
                                            var data = {
                                                zoneids: args.context.physicalResources[0].id,
                                                force: args.data.force,
                                                timeout: args.data.timeout,
                                                payload: args.data.payload
                                            };
                                            $.ajax({
                                                url: createURL("startRollingMaintenance"),
                                                dataType: "json",
                                                data: data,
                                                async: true,
                                                success: function (json) {
                                                    var item = json.rollingmaintenance;
                                                    args.response.success({
                                                        actionFilter: zoneActionfilter,
                                                        data: item
                                                    });
                                                }
                                            });
                                        },
                                        notification: {
                                            poll: function (args) {
                                                args.complete();
                                            }
                                        }
                                    },

                                    addVmwareDc: {
                                        label: 'label.add.vmware.datacenter',
                                        textLabel: 'label.add.vmware.datacenter',
                                        messages: {
                                            notification: function (args) {
                                                return 'label.add.vmware.datacenter';
                                            }
                                        },
                                        createForm: {
                                            title: 'label.add.vmware.datacenter',
                                            fields: {
                                                name: {
                                                    label: 'label.dc.name',
                                                    validation: {
                                                        required: true
                                                    }
                                                },
                                                vcenter: {
                                                    label: 'label.vcenter',
                                                    validation: {
                                                        required: true
                                                    }
                                                },
                                                username: {
                                                    label: 'label.username',
                                                    validation: {
                                                        required: true
                                                    }
                                                },
                                                password: {
                                                    label: 'label.password',
                                                    isPassword: true,
                                                    validation: {
                                                        required: true
                                                    }
                                                }
                                            }
                                        },
                                        action: function (args) {
                                            var data = {
                                                zoneid: args.context.physicalResources[0].id,
                                                name: args.data.name,
                                                vcenter: args.data.vcenter
                                            };

                                            if (args.data.username != null && args.data.username.length > 0) {
                                                $.extend(data, {
                                                    username: args.data.username
                                                })
                                            }
                                            if (args.data.password != null && args.data.password.length > 0) {
                                                $.extend(data, {
                                                    password: args.data.password
                                                })
                                            }

                                            $.ajax({
                                                url: createURL('addVmwareDc'),
                                                data: data,
                                                type: "POST",
                                                success: function (json) {
                                                    //var item = json.addvmwaredcresponse.vmwaredc;
                                                    args.response.success();
                                                }
                                            });
                                        },
                                        notification: {
                                            poll: function (args) {
                                                args.complete();
                                            }
                                        }
                                    },

                                    updateVmwareDc: {
                                        label: 'label.update.vmware.datacenter',
                                        messages: {
                                            confirm: function (args) {
                                                return 'label.update.vmware.datacenter';
                                            },
                                            notification: function (args) {
                                                return 'label.update.vmware.datacenter';
                                            }
                                        },
                                        createForm: {
                                            title: 'label.update.vmware.datacenter',
                                            fields: {
                                                name: {
                                                    label: 'label.vmware.datacenter.name'
                                                },
                                                vcenter: {
                                                    label: 'label.vmware.datacenter.vcenter'
                                                },
                                                username: {
                                                    label: 'label.username'
                                                },
                                                password: {
                                                    label: 'label.password',
                                                    isPassword: true
                                                }
                                            }
                                        },
                                        action: function (args) {
                                            var data = args.data;
                                            data.zoneid = args.context.physicalResources[0].id;
                                            $.ajax({
                                                url: createURL('updateVmwareDc'),
                                                data: data,
                                                success: function (json) {
                                                    args.response.success({
                                                        data: args.context.physicalResources[0]
                                                    });
                                                },
                                                error: function (XMLHttpResponse) {
                                                    var errorMsg = parseXMLHttpResponse(XMLHttpResponse);
                                                    args.response.error(errorMsg);
                                                }
                                            });
                                        },
                                        notification: {
                                            poll: function (args) {
                                                args.complete();
                                            }
                                        }
                                    },

                                    removeVmwareDc: {
                                        label: 'label.remove.vmware.datacenter',
                                        messages: {
                                            confirm: function (args) {
                                                return 'message.confirm.remove.vmware.datacenter';
                                            },
                                            notification: function (args) {
                                                return 'label.remove.vmware.datacenter';
                                            }
                                        },
                                        action: function (args) {
                                            var data = {
                                                zoneid: args.context.physicalResources[0].id
                                            };
                                            $.ajax({
                                                url: createURL('removeVmwareDc'),
                                                data: data,
                                                success: function (json) {
                                                    delete args.context.physicalResources[0].vmwaredcName;
                                                    delete args.context.physicalResources[0].vmwaredcVcenter;
                                                    delete args.context.physicalResources[0].vmwaredcId;

                                                    selectedZoneObj = args.context.physicalResources[0];

                                                    args.response.success({
                                                        data: args.context.physicalResources[0]
                                                    });
                                                },
                                                error: function (XMLHttpResponse) {
                                                    var errorMsg = parseXMLHttpResponse(XMLHttpResponse);
                                                    args.response.error(errorMsg);
                                                }
                                            });
                                        },
                                        notification: {
                                            poll: function (args) {
                                                args.complete();
                                            }
                                        }
                                    },

                                    enable: {
                                        label: 'label.action.enable.zone',
                                        messages: {
                                            confirm: function (args) {
                                                return 'message.action.enable.zone';
                                            },
                                            notification: function (args) {
                                                return 'label.action.enable.zone';
                                            }
                                        },
                                        action: function (args) {
                                            $.ajax({
                                                url: createURL("updateZone&id=" + args.context.physicalResources[0].id + "&allocationstate=Enabled"), //embedded objects in listView is called physicalResources while embedded objects in detailView is called zones
                                                dataType: "json",
                                                async: true,
                                                success: function (json) {
                                                    var item = json.updatezoneresponse.zone;
                                                    args.response.success({
                                                        actionFilter: zoneActionfilter,
                                                        data: item
                                                    });
                                                }
                                            });
                                        },
                                        notification: {
                                            poll: function (args) {
                                                args.complete();
                                            }
                                        }
                                    },

                                    disable: {
                                        label: 'label.action.disable.zone',
                                        messages: {
                                            confirm: function (args) {
                                                return 'message.action.disable.zone';
                                            },
                                            notification: function (args) {
                                                return 'label.action.disable.zone';
                                            }
                                        },
                                        action: function (args) {
                                            $.ajax({
                                                url: createURL("updateZone&id=" + args.context.physicalResources[0].id + "&allocationstate=Disabled"), //embedded objects in listView is called physicalResources while embedded objects in detailView is called zones
                                                dataType: "json",
                                                async: true,
                                                success: function (json) {
                                                    var item = json.updatezoneresponse.zone;
                                                    args.response.success({
                                                        actionFilter: zoneActionfilter,
                                                        data: item
                                                    });
                                                }
                                            });
                                        },
                                        notification: {
                                            poll: function (args) {
                                                args.complete();
                                            }
                                        }
                                    },

                                    dedicateZone: {
                                        label: 'label.dedicate.zone',
                                        messages: {
                                            confirm: function (args) {
                                                return 'message.confirm.dedicate.zone';
                                            },
                                            notification: function (args) {
                                                return 'label.zone.dedicated';
                                            }
                                        },
                                        createForm: {
                                            title: 'label.dedicate.zone',
                                            fields: {
                                                domainId: {
                                                    label: 'label.domain',
                                                    validation: {
                                                        required: true
                                                    },
                                                    select: function (args) {
                                                        $.ajax({
                                                            url: createURL('listDomains'),
                                                            data: {
                                                                listAll: true,
                                                                details: 'min'
                                                            },
                                                            dataType: "json",
                                                            async: false,
                                                            success: function (json) {
                                                                var domainObjs = json.listdomainsresponse.domain;
                                                                var items =[];

                                                                $(domainObjs).each(function () {
                                                                    items.push({
                                                                        id: this.id,
                                                                        description: this.name
                                                                    });
                                                                });
                                                                items.sort(function(a, b) {
                                                                    return a.description.localeCompare(b.description);
                                                                });

                                                                args.response.success({
                                                                    data: items
                                                                });
                                                            }
                                                        });
                                                    }
                                                },
                                                accountId: {
                                                    label: 'label.account',
                                                    docID: 'helpAccountForDedication',
                                                    validation: {
                                                        required: false
                                                    }
                                                }
                                            }
                                        },
                                        action: function (args) {
                                            //EXPLICIT DEDICATION
                                            var array2 =[];
                                            if (args.data.accountId != "")
                                            array2.push("&account=" + encodeURIComponent(args.data.accountId));

                                            $.ajax({
                                                url: createURL("dedicateZone&zoneId=" +
                                                args.context.physicalResources[0].id +
                                                "&domainId=" + args.data.domainId + array2.join("")),
                                                dataType: "json",
                                                success: function (json) {
                                                    var jid = json.dedicatezoneresponse.jobid;
                                                    args.response.success({
                                                        _custom: {
                                                            jobId: jid,
                                                            getActionFilter: function () {
                                                                return zoneActionfilter;
                                                            }
                                                        }
                                                    });
                                                }
                                            });
                                        },
                                        notification: {
                                            poll: pollAsyncJobResult
                                        }
                                    },
                                    releaseDedicatedZone: {
                                        label: 'label.release.dedicated.zone',
                                        messages: {
                                            confirm: function (args) {
                                                return 'message.confirm.release.dedicated.zone';
                                            },
                                            notification: function (args) {
                                                return 'message.dedicated.zone.released';
                                            }
                                        },
                                        action: function (args) {
                                            $.ajax({
                                                url: createURL("releaseDedicatedZone&zoneid=" +
                                                args.context.physicalResources[0].id),
                                                dataType: "json",
                                                async: true,
                                                success: function (json) {
                                                    var jid = json.releasededicatedzoneresponse.jobid;
                                                    args.response.success({
                                                        _custom: {
                                                            jobId: jid,
                                                            getActionFilter: function () {
                                                                return zoneActionfilter;
                                                            }
                                                        }
                                                    });
                                                },
                                                error: function (json) {
                                                    args.response.error(parseXMLHttpResponse(json));
                                                }
                                            });
                                        },
                                        notification: {
                                            poll: pollAsyncJobResult
                                        }
                                    },

                                    'remove': {
                                        label: 'label.action.delete.zone',
                                        messages: {
                                            confirm: function (args) {
                                                return 'message.action.delete.zone';
                                            },
                                            notification: function (args) {
                                                return 'label.action.delete.zone';
                                            }
                                        },
                                        action: function (args) {
                                            $.ajax({
                                                url: createURL("deleteZone&id=" + args.context.physicalResources[0].id), //embedded objects in listView is called physicalResources while embedded objects in detailView is called zones
                                                dataType: "json",
                                                async: true,
                                                success: function (json) {
                                                    args.response.success({
                                                        data: {
                                                        }
                                                    });
                                                },
                                                error: function (json) {
                                                    args.response.error(parseXMLHttpResponse(json));
                                                }
                                            });
                                        },
                                        notification: {
                                            poll: function (args) {
                                                args.complete();
                                            }
                                        }
                                    },
                                    edit: {
                                        label: 'label.edit',
                                        action: function (args) {
                                            var array1 =[];
                                            array1.push("&name=" + encodeURIComponent(args.data.name));
                                            array1.push("&dns1=" + encodeURIComponent(args.data.dns1));
                                            array1.push("&dns2=" + encodeURIComponent(args.data.dns2));
                                            //dns2 can be empty ("") when passed to API, so a user gets to update this field from an existing value to blank.
                                            array1.push("&ip6dns1=" + encodeURIComponent(args.data.ip6dns1));
                                            //p6dns1 can be empty ("") when passed to API, so a user gets to update this field from an existing value to blank.
                                            array1.push("&ip6dns2=" + encodeURIComponent(args.data.ip6dns2));
                                            //ip6dns2 can be empty ("") when passed to API, so a user gets to update this field from an existing value to blank.

                                            if (selectedZoneObj.networktype == "Advanced" && args.data.guestcidraddress) {
                                                array1.push("&guestcidraddress=" + encodeURIComponent(args.data.guestcidraddress));
                                            }

                                            array1.push("&internaldns1=" + encodeURIComponent(args.data.internaldns1));
                                            array1.push("&internaldns2=" + encodeURIComponent(args.data.internaldns2));
                                            //internaldns2 can be empty ("") when passed to API, so a user gets to update this field from an existing value to blank.
                                            array1.push("&domain=" + encodeURIComponent(args.data.domain));
                                            array1.push("&localstorageenabled=" + (args.data.localstorageenabled == 'on'));
                                            $.ajax({
                                                url: createURL("updateZone&id=" + args.context.physicalResources[0].id + array1.join("")),
                                                dataType: "json",
                                                async: false,
                                                success: function (json) {
                                                    selectedZoneObj = json.updatezoneresponse.zone; //override selectedZoneObj after update zone
                                                    args.response.success({
                                                        data: selectedZoneObj
                                                    });
                                                },
                                                error: function (json) {
                                                    args.response.error('Could not edit zone information; please ensure all fields are valid.');
                                                }
                                            });
                                        }
                                    },
                                    enableOutOfBandManagement: {
                                        label: 'label.outofbandmanagement.enable',
                                        action: function (args) {
                                            var data = {
                                                zoneid: args.context.physicalResources[0].id
                                            };
                                            $.ajax({
                                                url: createURL("enableOutOfBandManagementForZone"),
                                                data: data,
                                                success: function (json) {
                                                    var jid = json.enableoutofbandmanagementforzoneresponse.jobid;
                                                    args.response.success({
                                                        _custom: {
                                                            jobId: jid,
                                                            getActionFilter: function () {
                                                                return zoneActionfilter;
                                                            }
                                                        }
                                                    });
                                                },
                                                error: function (json) {
                                                    args.response.error(parseXMLHttpResponse(json));
                                                }

                                            });
                                        },
                                        messages: {
                                            confirm: function (args) {
                                                return 'message.outofbandmanagement.enable';
                                            },
                                            notification: function (args) {
                                                return 'message.outofbandmanagement.enable';
                                            }
                                        },
                                        notification: {
                                            poll: pollAsyncJobResult
                                        }
                                    },
                                    disableOutOfBandManagement: {
                                        label: 'label.outofbandmanagement.disable',
                                        action: function (args) {
                                            var data = {
                                                zoneid: args.context.physicalResources[0].id
                                            };
                                            $.ajax({
                                                url: createURL("disableOutOfBandManagementForZone"),
                                                data: data,
                                                success: function (json) {
                                                    var jid = json.disableoutofbandmanagementforzoneresponse.jobid;
                                                    args.response.success({
                                                        _custom: {
                                                            jobId: jid,
                                                            getActionFilter: function () {
                                                                return zoneActionfilter;
                                                            }
                                                        }
                                                    });
                                                },
                                                error: function (json) {
                                                    args.response.error(parseXMLHttpResponse(json));
                                                }

                                            });
                                        },
                                        messages: {
                                            confirm: function (args) {
                                                return 'message.outofbandmanagement.disable';
                                            },
                                            notification: function (args) {
                                                return 'message.outofbandmanagement.disable';
                                            }
                                        },
                                        notification: {
                                            poll: pollAsyncJobResult
                                        }
                                    },
                                    enableHA: {
                                        label: 'label.ha.enable',
                                        action: function (args) {
                                            var data = {
                                                zoneid: args.context.physicalResources[0].id
                                            };
                                            $.ajax({
                                                url: createURL("enableHAForZone"),
                                                data: data,
                                                success: function (json) {
                                                    var jid = json.enablehaforzoneresponse.jobid;
                                                    args.response.success({
                                                        _custom: {
                                                            jobId: jid,
                                                            getActionFilter: function () {
                                                                return zoneActionfilter;
                                                            }
                                                        }
                                                    });
                                                },
                                                error: function (json) {
                                                    args.response.error(parseXMLHttpResponse(json));
                                                }
                                            });
                                        },
                                        messages: {
                                            confirm: function (args) {
                                                return 'label.ha.enable';
                                            },
                                            notification: function (args) {
                                                return 'label.ha.enable';
                                            }
                                        },
                                        notification: {
                                            poll: pollAsyncJobResult
                                        }
                                    },
                                    disableHA: {
                                        label: 'label.ha.disable',
                                        action: function (args) {
                                            var data = {
                                                zoneid: args.context.physicalResources[0].id
                                            };
                                            $.ajax({
                                                url: createURL("disableHAForZone"),
                                                data: data,
                                                success: function (json) {
                                                    var jid = json.disablehaforzoneresponse.jobid;
                                                    args.response.success({
                                                        _custom: {
                                                            jobId: jid,
                                                            getActionFilter: function () {
                                                                return zoneActionfilter;
                                                            }
                                                        }
                                                    });
                                                },
                                                error: function (json) {
                                                    args.response.error(parseXMLHttpResponse(json));
                                                }
                                            });
                                        },
                                        messages: {
                                            confirm: function (args) {
                                                return 'label.ha.disable';
                                            },
                                            notification: function (args) {
                                                return 'label.ha.disable';
                                            }
                                        },
                                        notification: {
                                            poll: pollAsyncJobResult
                                        }
                                    }
                                },
                                tabs: {
                                    details: {
                                        title: 'label.details',

                                        preFilter: function (args) {
                                            var hiddenFields =[];
                                            if (selectedZoneObj.networktype == "Basic")
                                            hiddenFields.push("guestcidraddress");
                                            return hiddenFields;
                                        },

                                        fields:[ {
                                            name: {
                                                label: 'label.zone',
                                                isEditable: true,
                                                validation: {
                                                    required: true
                                                }
                                            }
                                        },
                                        {
                                            id: {
                                                label: 'label.id'
                                            },
                                            allocationstate: {
                                                label: 'label.allocation.state'
                                            },
                                            dns1: {
                                                label: 'label.dns.1',
                                                isEditable: true,
                                                validation: {
                                                    required: true
                                                }
                                            },
                                            dns2: {
                                                label: 'label.dns.2',
                                                isEditable: true
                                            },
                                            ip6dns1: {
                                                label: 'label.ipv6.dns1',
                                                isEditable: true
                                            },
                                            ip6dns2: {
                                                label: 'label.ipv6.dns2',
                                                isEditable: true
                                            },
                                            internaldns1: {
                                                label: 'label.internal.dns.1',
                                                isEditable: true,
                                                validation: {
                                                    required: true
                                                }
                                            },
                                            internaldns2: {
                                                label: 'label.internal.dns.2',
                                                isEditable: true
                                            },
                                            domainname: {
                                                label: 'label.domain'
                                            },
                                            networktype: {
                                                label: 'label.network.type'
                                            },
                                            guestcidraddress: {
                                                label: 'label.guest.cidr',
                                                isEditable: true
                                            },
                                            domain: {
                                                label: 'label.network.domain',
                                                isEditable: true
                                            },
                                            localstorageenabled: {
                                                label: 'label.local.storage.enabled',
                                                isBoolean: true,
                                                isEditable: true,
                                                converter: cloudStack.converters.toBooleanText
                                            }
                                        },
                                        {
                                            isdedicated: {
                                                label: 'label.dedicated'
                                            },
                                            domainid: {
                                                label: 'label.domain.id'
                                            }
                                        },
                                        {
                                            vmwaredcName: {
                                                label: 'label.vmware.datacenter.name'
                                            },
                                            vmwaredcVcenter: {
                                                label: 'label.vmware.datacenter.vcenter'
                                            },
                                            vmwaredcId: {
                                                label: 'label.vmware.datacenter.id'
                                            }
                                        }],
                                        dataProvider: function (args) {
                                            $.ajax({
                                                url: createURL('listZones'),
                                                data: {
                                                    id: args.context.physicalResources[0].id
                                                },
                                                success: function (json) {
                                                    selectedZoneObj = json.listzonesresponse.zone[0];

                                                    $(window).trigger('cloudStack.module.sharedFunctions.addExtraProperties', {
                                                        obj: selectedZoneObj,
                                                        objType: "Zone"
                                                    });

                                                    $.ajax({
                                                        url: createURL('listDedicatedZones'),
                                                        data: {
                                                            zoneid: args.context.physicalResources[0].id
                                                        },
                                                        async: false,
                                                        success: function (json) {
                                                            if (json.listdedicatedzonesresponse.dedicatedzone != undefined) {
                                                                var dedicatedzoneObj = json.listdedicatedzonesresponse.dedicatedzone[0];
                                                                if (dedicatedzoneObj.domainid != null) {
                                                                    $.extend(selectedZoneObj, {
                                                                        isdedicated: 'Yes',
                                                                        domainid: dedicatedzoneObj.domainid,
                                                                        accountid: dedicatedzoneObj.accountid
                                                                    });
                                                                }
                                                            } else {
                                                                $.extend(selectedZoneObj, {
                                                                    isdedicated: 'No',
                                                                    domainid: null,
                                                                    accountid: null
                                                                })
                                                            }
                                                        }
                                                    });

                                                    $.ajax({
                                                        url: createURL('listApis'), //listVmwareDcs API only exists in non-oss bild, so have to check whether it exists before calling it.
                                                        data: {
                                                            name: 'listVmwareDcs'
                                                        },
                                                        async: false,
                                                        success: function (json) {
                                                            $.ajax({
                                                                url: createURL('listVmwareDcs'),
                                                                data: {
                                                                    zoneid: args.context.physicalResources[0].id
                                                                },
                                                                async: false,
                                                                success: function (json) {
                                                                    //e.g. json == { "listvmwaredcsresponse" { "count":1 ,"VMwareDC" [ {"id":"c3c2562d-65e9-4fc7-92e2-773c2efe8f37","zoneid":1,"name":"datacenter","vcenter":"10.10.20.20"} ] } }
                                                                    var vmwaredcs = json.listvmwaredcsresponse.VMwareDC;
                                                                    if (vmwaredcs != null) {
                                                                        selectedZoneObj.vmwaredcName = vmwaredcs[0].name;
                                                                        selectedZoneObj.vmwaredcVcenter = vmwaredcs[0].vcenter;
                                                                        selectedZoneObj.vmwaredcId = vmwaredcs[0].id;
                                                                    }
                                                                }
                                                            });
                                                        },
                                                        error: function (XMLHttpResponse) {
                                                        }
                                                        //override default error handling: cloudStack.dialog.notice({ message: parseXMLHttpResponse(XMLHttpResponse)});
                                                    });

                                                    args.response.success({
                                                        actionFilter: zoneActionfilter,
                                                        data: selectedZoneObj
                                                    });
                                                }
                                            });
                                        }
                                    },

                                    compute: {
                                        title: 'label.compute.and.storage',
                                        custom: cloudStack.uiCustom.systemChart('compute')
                                    },
                                    network: {
                                        title: 'label.physical.network',
                                        custom: cloudStack.uiCustom.systemChart('network')
                                    },
                                    resources: {
                                        title: 'label.resources',
                                        custom: cloudStack.uiCustom.systemChart('resources')
                                    },

                                    systemVMs: {
                                        title: 'label.system.vms',
                                        listView: {
                                            label: 'label.system.vms',
                                            id: 'systemVMs',
                                            fields: {
                                                name: {
                                                    label: 'label.name'
                                                },
                                                systemvmtype: {
                                                    label: 'label.type',
                                                    converter: function (args) {
                                                        if (args == "consoleproxy")
                                                        return "Console Proxy VM"; else if (args == "secondarystoragevm")
                                                        return "Secondary Storage VM"; else
                                                        return args;
                                                    }
                                                },
                                                zonename: {
                                                    label: 'label.zone'
                                                },
                                                state: {
                                                    label: 'label.status',
                                                    converter: function (str) {
                                                        // For localization
                                                        return str;
                                                    },
                                                    indicator: {
                                                        'Running': 'on',
                                                        'Stopped': 'off',
                                                        'Error': 'off',
                                                        'Destroyed': 'off'
                                                    }
                                                }
                                            },
                                            dataProvider: function (args) {
                                                var array1 =[];
                                                if (args.filterBy != null) {
                                                    if (args.filterBy.search != null && args.filterBy.search.by != null && args.filterBy.search.value != null) {
                                                        switch (args.filterBy.search.by) {
                                                            case "name":
                                                            if (args.filterBy.search.value.length > 0)
                                                            array1.push("&keyword=" + args.filterBy.search.value);
                                                            break;
                                                        }
                                                    }
                                                }

                                                var selectedZoneObj = args.context.physicalResources[0];
                                                $.ajax({
                                                    url: createURL("listSystemVms&zoneid=" + selectedZoneObj.id + "&page=" + args.page + "&pagesize=" + pageSize + array1.join("")),
                                                    dataType: "json",
                                                    async: true,
                                                    success: function (json) {
                                                        var items = json.listsystemvmsresponse.systemvm;
                                                        args.response.success({
                                                            actionFilter: systemvmActionfilter,
                                                            data: items
                                                        });
                                                    }
                                                });
                                            },

                                            detailView: {
                                                noCompact: true,
                                                name: 'label.system.vm.details',
                                                actions: {
                                                    start: {
                                                        label: 'label.action.start.systemvm',
                                                        messages: {
                                                            confirm: function (args) {
                                                                return 'message.action.start.systemvm';
                                                            },
                                                            notification: function (args) {
                                                                return 'label.action.start.systemvm';
                                                            }
                                                        },
                                                        action: function (args) {
                                                            $.ajax({
                                                                url: createURL('startSystemVm&id=' + args.context.systemVMs[0].id),
                                                                dataType: 'json',
                                                                async: true,
                                                                success: function (json) {
                                                                    var jid = json.startsystemvmresponse.jobid;
                                                                    args.response.success({
                                                                        _custom: {
                                                                            jobId: jid,
                                                                            getUpdatedItem: function (json) {
                                                                                return json.queryasyncjobresultresponse.jobresult.systemvm;
                                                                            },
                                                                            getActionFilter: function () {
                                                                                return systemvmActionfilter;
                                                                            }
                                                                        }
                                                                    });
                                                                }
                                                            });
                                                        },
                                                        notification: {
                                                            poll: pollAsyncJobResult
                                                        }
                                                    },

                                                    stop: {
                                                        label: 'label.action.stop.systemvm',
                                                        messages: {
                                                            confirm: function (args) {
                                                                return 'message.action.stop.systemvm';
                                                            },
                                                            notification: function (args) {
                                                                return 'label.action.stop.systemvm';
                                                            }
                                                        },
                                                        action: function (args) {
                                                            $.ajax({
                                                                url: createURL('stopSystemVm&id=' + args.context.systemVMs[0].id),
                                                                dataType: 'json',
                                                                async: true,
                                                                success: function (json) {
                                                                    var jid = json.stopsystemvmresponse.jobid;
                                                                    args.response.success({
                                                                        _custom: {
                                                                            jobId: jid,
                                                                            getUpdatedItem: function (json) {
                                                                                return json.queryasyncjobresultresponse.jobresult.systemvm;
                                                                            },
                                                                            getActionFilter: function () {
                                                                                return systemvmActionfilter;
                                                                            }
                                                                        }
                                                                    });
                                                                }
                                                            });
                                                        },
                                                        notification: {
                                                            poll: pollAsyncJobResult
                                                        }
                                                    },

                                                    restart: {
                                                        label: 'label.action.reboot.systemvm',
                                                        messages: {
                                                            confirm: function (args) {
                                                                return 'message.action.reboot.systemvm';
                                                            },
                                                            notification: function (args) {
                                                                return 'label.action.reboot.systemvm';
                                                            }
                                                        },
                                                        action: function (args) {
                                                            $.ajax({
                                                                url: createURL('rebootSystemVm&id=' + args.context.systemVMs[0].id),
                                                                dataType: 'json',
                                                                async: true,
                                                                success: function (json) {
                                                                    var jid = json.rebootsystemvmresponse.jobid;
                                                                    args.response.success({
                                                                        _custom: {
                                                                            jobId: jid,
                                                                            getUpdatedItem: function (json) {
                                                                                return json.queryasyncjobresultresponse.jobresult.systemvm;
                                                                            },
                                                                            getActionFilter: function () {
                                                                                return systemvmActionfilter;
                                                                            }
                                                                        }
                                                                    });
                                                                }
                                                            });
                                                        },
                                                        notification: {
                                                            poll: pollAsyncJobResult
                                                        }
                                                    },

                                                    remove: {
                                                        label: 'label.action.destroy.systemvm',
                                                        messages: {
                                                            confirm: function (args) {
                                                                return 'message.action.destroy.systemvm';
                                                            },
                                                            notification: function (args) {
                                                                return 'label.action.destroy.systemvm';
                                                            }
                                                        },
                                                        action: function (args) {
                                                            $.ajax({
                                                                url: createURL('destroySystemVm&id=' + args.context.systemVMs[0].id),
                                                                dataType: 'json',
                                                                async: true,
                                                                success: function (json) {
                                                                    var jid = json.destroysystemvmresponse.jobid;
                                                                    args.response.success({
                                                                        _custom: {
                                                                            getUpdatedItem: function () {
                                                                                return {
                                                                                    state: 'Destroyed'
                                                                                };
                                                                            },
                                                                            jobId: jid
                                                                        }
                                                                    });
                                                                }
                                                            });
                                                        },
                                                        notification: {
                                                            poll: pollAsyncJobResult
                                                        }
                                                    },

                                                    migrate: {
                                                        label: 'label.action.migrate.systemvm',
                                                        messages: {
                                                            notification: function (args) {
                                                                return 'label.action.migrate.systemvm';
                                                            }
                                                        },
                                                        createForm: {
                                                            title: 'label.action.migrate.systemvm',
                                                            desc: '',
                                                            fields: {
                                                                hostId: {
                                                                    label: 'label.host',
                                                                    validation: {
                                                                        required: true
                                                                    },
                                                                    select: function (args) {
                                                                        $.ajax({
                                                                            url: createURL("findHostsForMigration&VirtualMachineId=" + args.context.systemVMs[0].id),
                                                                            dataType: "json",
                                                                            async: true,
                                                                            success: function (json) {
                                                                                var hostObjs = json.findhostsformigrationresponse.host;
                                                                                var items =[];
                                                                                $(hostObjs).each(function () {
                                                                                    if (this.requiresStorageMotion == false) {
                                                                                        items.push({
                                                                                            id: this.id,
                                                                                            description: (this.name + " (" + (this.suitableformigration ? "Suitable": "Not Suitable") + ")")
                                                                                        });
                                                                                    }
                                                                                });
                                                                                args.response.success({
                                                                                    data: items
                                                                                });
                                                                            }
                                                                        });
                                                                    },
                                                                    error: function (XMLHttpResponse) {
                                                                        var errorMsg = parseXMLHttpResponse(XMLHttpResponse);
                                                                        args.response.error(errorMsg);
                                                                    }
                                                                }
                                                            }
                                                        },
                                                        action: function (args) {
                                                            $.ajax({
                                                                url: createURL("migrateSystemVm&hostid=" + args.data.hostId + "&virtualmachineid=" + args.context.systemVMs[0].id),
                                                                dataType: "json",
                                                                async: true,
                                                                success: function (json) {
                                                                    var jid = json.migratesystemvmresponse.jobid;
                                                                    args.response.success({
                                                                        _custom: {
                                                                            jobId: jid,
                                                                            getUpdatedItem: function (json) {
                                                                                //return json.queryasyncjobresultresponse.jobresult.systemvminstance;    //not all properties returned in systemvminstance
                                                                                $.ajax({
                                                                                    url: createURL("listSystemVms&id=" + json.queryasyncjobresultresponse.jobresult.systemvm.id),
                                                                                    dataType: "json",
                                                                                    async: false,
                                                                                    success: function (json) {
                                                                                        var items = json.listsystemvmsresponse.systemvm;
                                                                                        if (items != null && items.length > 0) {
                                                                                            return items[0];
                                                                                        }
                                                                                    }
                                                                                });
                                                                            },
                                                                            getActionFilter: function () {
                                                                                return systemvmActionfilter;
                                                                            }
                                                                        }
                                                                    });
                                                                }
                                                            });
                                                        },
                                                        notification: {
                                                            poll: pollAsyncJobResult
                                                        }
                                                    },

                                                    diagnostics: {
                                                        label: 'label.action.run.diagnostics',
                                                        messages: {
                                                            notification: function (args) {
                                                                return 'label.action.run.diagnostics';
                                                            },
                                                            complete: function(args) {
                                                                var exitcode = _l('message.diagnostics.exitcode');
                                                                exitcode = exitcode.replace('var', args.exitcode);
                                                                var stderr = _l('message.diagnostics.stderr');
                                                                stderr = stderr.replace('var', args.stderr);
                                                                var stdout = _l('message.diagnostics.stdout');
                                                                stdout = stdout.replace('var', args.stdout);
                                                                var msg = "<div style='text-align: left; overflow-y: auto'>" + exitcode + "<br><br>" + stderr + "<br><br>" + stdout + "</div>";
                                                                return msg;
                                                            }
                                                        },
                                                        createForm: {
                                                            title: 'label.action.run.diagnostics',
                                                            desc: '',
                                                            fields: {
                                                                type: {
                                                                    label: 'label.run.diagnostics.type',
                                                                    validation: {
                                                                        required: true
                                                                    },
                                                                    select: function (args) {
                                                                        var items = [];
                                                                        items.push({
                                                                            id: "ping",
                                                                            description: "Ping"
                                                                        });
                                                                        items.push({
                                                                            id: "traceroute",
                                                                            description: "Traceroute"
                                                                        });
                                                                        items.push({
                                                                            id: "arping",
                                                                            description: "Arping"
                                                                        });
                                                                        args.response.success({
                                                                            data: items
                                                                        });
                                                                    }
                                                                },
                                                                destination: {
                                                                    label: 'label.run.diagnostics.destination',
                                                                    validation: {
                                                                        required: true
                                                                    }
                                                                },
                                                                extra: {
                                                                    label: 'label.run.diagnostics.extra'
                                                                }

                                                            }
                                                        },
                                                        action: function (args) {
                                                            $.ajax({
                                                                url: createURL("runDiagnostics&targetid=" + args.context.systemVMs[0].id + "&ipaddress=" + args.data.destination + "&type=" + args.data.type + "&params=" + args.data.extra),
                                                                dataType: "json",
                                                                async: true,
                                                                success: function(json) {
                                                                    var jid = json.rundiagnosticsresponse.jobid;
                                                                    args.response.success({
                                                                        _custom: {
                                                                            jobId : jid,
                                                                            getUpdatedItem: function (json) {
                                                                                return json.queryasyncjobresultresponse.jobresult.diagnostics;

                                                                            },
                                                                            getActionFilter: function(){
                                                                                return systemvmActionfilter;
                                                                           }
                                                                        }

                                                                    });
                                                                }
                                                            }); //end ajax
                                                        },
                                                        notification: {
                                                            poll: pollAsyncJobResult
                                                        }
                                                    },

                                                    retrieveDiagnostics: {
                                                        label: 'label.action.get.diagnostics',
                                                        messages: {
                                                            notification: function (args) {
                                                                return 'label.action.get.diagnostics';
                                                            },
                                                            complete: function(args) {
                                                                var url = args.url;
                                                                var htmlMsg = _l('message.download.diagnostics');
                                                                var htmlMsg2 = htmlMsg.replace(/#/, url).replace(/00000/, url);
                                                                return htmlMsg2;
                                                            }
                                                        },
                                                        createForm: {
                                                            title: 'label.action.get.diagnostics',
                                                            desc: '',
                                                            fields: {
                                                                files: {
                                                                    label: 'label.get.diagnostics.files'
                                                                }
                                                            }
                                                        },
                                                        action: function (args) {
                                                            $.ajax({
                                                                url: createURL("getDiagnosticsData&targetid=" + args.context.systemVMs[0].id + "&files=" + args.data.files),
                                                                dataType: "json",
                                                                async: true,
                                                                success: function(json) {
                                                                    var jid = json.getdiagnosticsdataresponse.jobid;
                                                                    args.response.success({
                                                                        _custom: {
                                                                            jobId : jid,
                                                                            getUpdatedItem: function (json) {
                                                                                return json.queryasyncjobresultresponse.jobresult.diagnostics;

                                                                            },
                                                                            getActionFilter: function(){
                                                                                return systemvmActionfilter;
                                                                           }
                                                                        }

                                                                    });
                                                                }
                                                            }); //end ajax
                                                        },
                                                        notification: {
                                                            poll: pollAsyncJobResult
                                                        }
                                                    },

                                                    scaleUp: {
                                                        label: 'label.change.service.offering',
                                                        createForm: {
                                                            title: 'label.change.service.offering',
                                                            desc: function (args) {
                                                                var description = '';
                                                                var vmObj = args.jsonObj;
                                                                //if (vmObj.state == 'Running' && vmObj.hypervisor == 'VMware') { //needs to wait for API fix that will return hypervisor property
                                                                if (vmObj.state == 'Running') {
                                                                    description = 'message.read.admin.guide.scaling.up';
                                                                }
                                                                return description;
                                                            },
                                                            fields: {
                                                                serviceOfferingId: {
                                                                    label: 'label.compute.offering',
                                                                    select: function (args) {
                                                                        var apiCmd = "listServiceOfferings&issystem=true";
                                                                        if (args.context.systemVMs[0].systemvmtype == "secondarystoragevm")
                                                                        apiCmd += "&systemvmtype=secondarystoragevm"; else if (args.context.systemVMs[0].systemvmtype == "consoleproxy")
                                                                        apiCmd += "&systemvmtype=consoleproxy";
                                                                        $.ajax({
                                                                            url: createURL(apiCmd),
                                                                            dataType: "json",
                                                                            async: true,
                                                                            success: function (json) {
                                                                                var serviceofferings = json.listserviceofferingsresponse.serviceoffering;
                                                                                var items =[];
                                                                                $(serviceofferings).each(function () {
                                                                                    if (this.id != args.context.systemVMs[0].serviceofferingid) {
                                                                                        items.push({
                                                                                            id: this.id,
                                                                                            description: this.name
                                                                                        });
                                                                                    }
                                                                                });
                                                                                args.response.success({
                                                                                    data: items
                                                                                });
                                                                            }
                                                                        });
                                                                    }
                                                                }
                                                            }
                                                        },

                                                        action: function (args) {
                                                            $.ajax({
                                                                url: createURL("scaleSystemVm&id=" + args.context.systemVMs[0].id + "&serviceofferingid=" + args.data.serviceOfferingId),
                                                                dataType: "json",
                                                                async: true,
                                                                success: function (json) {
                                                                    var jid = json.changeserviceforsystemvmresponse.jobid;
                                                                    args.response.success({
                                                                        _custom: {
                                                                            jobId: jid,
                                                                            getUpdatedItem: function (json) {
                                                                                return json.queryasyncjobresultresponse.jobresult.systemvm;
                                                                            },
                                                                            getActionFilter: function () {
                                                                                return systemvmActionfilter;
                                                                            }
                                                                        }
                                                                    });
                                                                },
                                                                error: function (json) {
                                                                    args.response.error(parseXMLHttpResponse(json));
                                                                }
                                                            });
                                                        },
                                                        messages: {
                                                            confirm: function (args) {
                                                                return 'message.confirm.scale.up.system.vm';
                                                            },
                                                            notification: function (args) {

                                                                return 'label.system.vm.scaled.up';
                                                            }
                                                        },
                                                        notification: {
                                                            poll: pollAsyncJobResult
                                                        }
                                                    },


                                                    viewConsole: {
                                                        label: 'label.view.console',
                                                        action: {
                                                            externalLink: {
                                                                url: function (args) {
                                                                    return clientConsoleUrl + '?cmd=access&vm=' + args.context.systemVMs[0].id;
                                                                },
                                                                title: function (args) {
                                                                    return args.context.systemVMs[0].id.substr(0, 8);
                                                                    //title in window.open() can't have space nor longer than 8 characters. Otherwise, IE browser will have error.
                                                                },
                                                                width: 820,
                                                                height: 640
                                                            }
                                                        }
                                                    }
                                                },
                                                tabs: {
                                                    details: {
                                                        title: 'label.details',
                                                        fields:[ {
                                                            name: {
                                                                label: 'label.name'
                                                            }
                                                        },
                                                        {
                                                            id: {
                                                                label: 'label.id'
                                                            },
                                                            state: {
                                                                label: 'label.state'
                                                            },
                                                            systemvmtype: {
                                                                label: 'label.type',
                                                                converter: function (args) {
                                                                    if (args == "consoleproxy")
                                                                    return 'label.console.proxy.vm'; else if (args == "secondarystoragevm")
                                                                    return 'label.secondary.storage.vm'; else
                                                                    return args;
                                                                }
                                                            },
                                                            zonename: {
                                                                label: 'label.zone'
                                                            },
                                                            publicip: {
                                                                label: 'label.public.ip'
                                                            },
                                                            privateip: {
                                                                label: 'label.private.ip'
                                                            },
                                                            linklocalip: {
                                                                label: 'label.linklocal.ip'
                                                            },
                                                            hostname: {
                                                                label: 'label.host'
                                                            },
                                                            gateway: {
                                                                label: 'label.gateway'
                                                            },
                                                            created: {
                                                                label: 'label.created',
                                                                converter: cloudStack.converters.toLocalDate
                                                            },
                                                            activeviewersessions: {
                                                                label: 'label.active.sessions'
                                                            }
                                                        }],
                                                        dataProvider: function (args) {
                                                            $.ajax({
                                                                url: createURL("listSystemVms&id=" + args.context.systemVMs[0].id),
                                                                dataType: "json",
                                                                async: true,
                                                                success: function (json) {
                                                                    args.response.success({
                                                                        actionFilter: systemvmActionfilter,
                                                                        data: json.listsystemvmsresponse.systemvm[0]
                                                                    });
                                                                }
                                                            });
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    },

                                    // Granular settings for zone
                                    settings: {
                                        title: 'label.settings',
                                        custom: cloudStack.uiCustom.granularSettings({
                                            dataProvider: function (args) {
                                                $.ajax({
                                                    url: createURL('listConfigurations&zoneid=' + args.context.physicalResources[0].id),
                                                    data: listViewDataProvider(args, {
                                                    },
                                                    {
                                                        searchBy: 'name'
                                                    }),
                                                    success: function (json) {
                                                        args.response.success({
                                                            data: json.listconfigurationsresponse.configuration
                                                        });
                                                    },

                                                    error: function (json) {
                                                        args.response.error(parseXMLHttpResponse(json));
                                                    }
                                                });
                                            },
                                            actions: {
                                                edit: function (args) {
                                                    // call updateZoneLevelParamter
                                                    var data = {
                                                        name: args.data.jsonObj.name,
                                                        value: args.data.value
                                                    };

                                                    $.ajax({
                                                        url: createURL('updateConfiguration&zoneid=' + args.context.physicalResources[0].id),
                                                        data: data,
                                                        success: function (json) {
                                                            var item = json.updateconfigurationresponse.configuration;
                                                            args.response.success({
                                                                data: item
                                                            });
                                                        },

                                                        error: function (json) {
                                                            args.response.error(parseXMLHttpResponse(json));
                                                        }
                                                    });
                                                }
                                            }
                                        })
                                    }
                                }
                            }
                        },
                        pods: function () {
                            var listView = $.extend(true, {
                            },
                            cloudStack.sections.system.subsections.pods.listView, {
                                dataProvider: function (args) {
                                    var data = {
                                    };
                                    listViewDataProvider(args, data);

                                    $.ajax({
                                        url: createURL('listPods'),
                                        data: data,
                                        success: function (json) {
                                            args.response.success({
                                                data: json.listpodsresponse.pod
                                            });
                                        },
                                        error: function (json) {
                                            args.response.error(parseXMLHttpResponse(json));
                                        }
                                    });
                                },

                                detailView: {
                                    updateContext: function (args) {
                                        var zone;

                                        $.ajax({
                                            url: createURL('listZones'),
                                            data: {
                                                id: args.context.pods[0].zoneid
                                            },
                                            async: false,
                                            success: function (json) {
                                                zone = json.listzonesresponse.zone[0];
                                            }
                                        });

                                        selectedZoneObj = zone;

                                        return {
                                            zones:[zone]
                                        };
                                    }
                                }
                            });

                            return listView;
                        },
                        clusters: function () {
                            var listView = $.extend(true, {
                            },
                            cloudStack.sections.system.subsections.clusters.listView, {
                                dataProvider: function (args) {
                                    var data = {
                                    };
                                    listViewDataProvider(args, data);

                                    $.ajax({
                                        url: createURL('listClusters'),
                                        data: data,
                                        success: function (json) {
                                            args.response.success({
                                                data: json.listclustersresponse.cluster
                                            });
                                        },
                                        error: function (json) {
                                            args.response.error(parseXMLHttpResponse(json));
                                        }
                                    });
                                },

                                detailView: {
                                    updateContext: function (args) {
                                        var zone;

                                        $.ajax({
                                            url: createURL('listZones'),
                                            data: {
                                                id: args.context.clusters[0].zoneid
                                            },
                                            async: false,
                                            success: function (json) {
                                                zone = json.listzonesresponse.zone[0];
                                            }
                                        });

                                        selectedZoneObj = zone;

                                        return {
                                            zones:[zone]
                                        };
                                    }
                                }
                            });

                            return listView;
                        },
                        hosts: function () {
                            var listView = $.extend(true, {
                            },
                            cloudStack.sections.system.subsections.hosts.listView, {
                                dataProvider: function (args) {
                                    var data = {
                                        type: 'routing'
                                    };
                                    listViewDataProvider(args, data);

                                    $.ajax({
                                        url: createURL('listHosts'),
                                        data: data,
                                        success: function (json) {
                                            var items = json.listhostsresponse.host;
                                            if (items) {
                                                $.each(items, function(idx, host) {
                                                    if (host && host.outofbandmanagement) {
                                                        items[idx].powerstate = host.outofbandmanagement.powerstate;
                                                    }

                                                    if (host && host.hypervisor == "KVM" && host.state == 'Up' && host.details && host.details["secured"] != 'true') {
                                                        items[idx].state = 'Unsecure';
                                                    }

                                                });
                                            }

                                            args.response.success({
                                                data: items
                                            });
                                        },
                                        error: function (json) {
                                            args.response.error(parseXMLHttpResponse(json));
                                        }
                                    });
                                },

                                detailView: {
                                    updateContext: function (args) {
                                        var zone;

                                        $.ajax({
                                            url: createURL('listZones'),
                                            data: {
                                                id: args.context.hosts[0].zoneid
                                            },
                                            async: false,
                                            success: function (json) {
                                                zone = json.listzonesresponse.zone[0];
                                            }
                                        });

                                        selectedZoneObj = zone;

                                        return {
                                            zones:[zone]
                                        };
                                    }
                                }
                            });

                            return listView;
                        },
                        primaryStorage: function () {
                            var listView = $.extend(true, {
                            },
                            cloudStack.sections.system.subsections[ 'primary-storage'].listView, {
                                dataProvider: function (args) {
                                    var data = {
                                    };
                                    listViewDataProvider(args, data);

                                    $.ajax({
                                        url: createURL('listStoragePools'),
                                        data: data,
                                        success: function (json) {
                                            args.response.success({
                                                data: json.liststoragepoolsresponse.storagepool
                                            });
                                        },
                                        error: function (json) {
                                            args.response.error(parseXMLHttpResponse(json));
                                        }
                                    });
                                },

                                detailView: {
                                    updateContext: function (args) {
                                        var zone;

                                        $.ajax({
                                            url: createURL('listZones'),
                                            data: {
                                                id: args.context.primarystorages[0].zoneid
                                            },
                                            async: false,
                                            success: function (json) {
                                                zone = json.listzonesresponse.zone[0];
                                            }
                                        });

                                        selectedZoneObj = zone;

                                        return {
                                            zones:[zone]
                                        };
                                    }
                                }
                            });

                            return listView;
                        },

                        secondaryStorage: function () {
                            var listView = $.extend(
                            true, {
                            },
                            cloudStack.sections.system.subsections[ 'secondary-storage'], {
                                sections: {
                                    secondaryStorage: {
                                        listView: {
                                            dataProvider: function (args) {
                                                var data = {
                                                    type: 'SecondaryStorage'
                                                };
                                                listViewDataProvider(args, data);

                                                $.ajax({
                                                    url: createURL('listImageStores'),
                                                    data: data,
                                                    success: function (json) {
                                                        var items = json.listimagestoresresponse.imagestore;
                                                        if (items != undefined) {
                                                            for (var i = 0; i < items.length; i++) {
                                                                processPropertiesInImagestoreObject(items[i]);
                                                            }
                                                        }
                                                        args.response.success({
                                                            data: items
                                                        });
                                                    },
                                                    error: function (json) {
                                                        args.response.error(parseXMLHttpResponse(json));
                                                    }
                                                });
                                            }
                                        }
                                    },
                                    cacheStorage: {
                                        listView: {
                                            dataProvider: function (args) {
                                                var data = {
                                                };
                                                listViewDataProvider(args, data);

                                                $.ajax({
                                                    url: createURL('listSecondaryStagingStores'),
                                                    data: data,
                                                    success: function (json) {
                                                        args.response.success({
                                                            data: json.listsecondarystagingstoreresponse.imagestore
                                                        });
                                                    },
                                                    error: function (json) {
                                                        args.response.error(parseXMLHttpResponse(json));
                                                    }
                                                });
                                            }

                                            /*
                                            ,
                                            detailView: {
                                            updateContext: function (args) {
                                            return {
                                            zones: [{}]
                                            };
                                            }
                                            }
                                             */
                                        }
                                    }
                                }
                            });

                            return listView;
                        },
                        systemVms: function () {
                            var listView = $.extend(true, {
                            },
                            cloudStack.sections.system.subsections.systemVms.listView, {
                                dataProvider: function (args) {
                                    var data = {
                                    };
                                    listViewDataProvider(args, data);

                                    $.ajax({
                                        url: createURL('listSystemVms'),
                                        data: data,
                                        success: function (json) {
                                            var systemvmObjs = json.listsystemvmsresponse.systemvm || [];
                                            $(systemvmObjs).each(function(idx, item) {
                                                var controlIp = item.linklocalip;
                                                if (item.hypervisor == "VMware") {
                                                    var controlIp = item.privateip;
                                                }
                                                item.controlip = controlIp;
                                            });

                                            args.response.success({
                                                data: systemvmObjs
                                            });
                                        }
                                    });
                                },

                                detailView: {
                                    updateContext: function (args) {
                                        var zone;

                                        $.ajax({
                                            url: createURL('listZones'),
                                            data: {
                                                id: args.context.systemVMs[0].zoneid
                                            },
                                            async: false,
                                            success: function (json) {
                                                zone = json.listzonesresponse.zone[0];
                                            }
                                        });

                                        selectedZoneObj = zone;

                                        return {
                                            zones:[zone]
                                        };
                                    }
                                }
                            });

                            return listView;
                        },
                        virtualRouters: function () {
                            var listView = $.extend(true, {
                            },
                            cloudStack.sections.system.subsections.virtualRouters, {
                                sections: {
                                    virtualRouterNoGrouping: {
                                        listView: {
                                            dataProvider: function (args) {
                                                var data = {
                                                };
                                                listViewDataProvider(args, data);

                                                var routers =[];

                                                //get account-owned routers
                                                $.ajax({
                                                    url: createURL('listRouters'),
                                                    data: $.extend(data, {
                                                        listAll: true
                                                    }),
                                                    async: false,
                                                    success: function (json) {
                                                        var items = json.listroutersresponse.router ? json.listroutersresponse.router:[];
                                                        $(items).map(function (index, item) {
                                                            routers.push(item);
                                                        });

                                                        //if account is specified in advanced search, don't search project-owned routers
                                                        var accountIsNotSpecifiedInAdvSearch = true;
                                                        if (args.filterBy != null) {
                                                            if (args.filterBy.advSearch != null && typeof(args.filterBy.advSearch) == "object") { //advanced search
                                                                if ('account' in args.filterBy.advSearch  && args.filterBy.advSearch.account.length > 0) {
                                                                    accountIsNotSpecifiedInAdvSearch = false;  //since account and projectid can't be specified together
                                                                }
                                                            }
                                                        }
                                                        if (accountIsNotSpecifiedInAdvSearch) {
                                                            /*
                                                             * In project view, the first listRotuers API(without projectid=-1) will return the same objects as the second listRouters API(with projectid=-1),
                                                             * because in project view, all API calls are appended with projectid=[projectID].
                                                             * Therefore, we only call the second listRouters API(with projectid=-1) in non-project view.
                                                             */
                                                            if (cloudStack.context && cloudStack.context.projects == null) { //non-project view
                                                            $.ajax({
                                                                    url: createURL("listRouters&page=" + args.page + "&pagesize=" + pageSize + "&projectid=-1"),
                                                                async: false,
                                                                success: function (json) {
                                                                    var items = json.listroutersresponse.router ? json.listroutersresponse.router:[];
                                                                    $(items).map(function (index, item) {
                                                                        routers.push(item);
                                                                    });
                                                                }
                                                            });

                                                        }
                                                    }

                                                        args.response.success({
                                                            actionFilter: routerActionfilter,
                                                            data: $(routers).map(mapRouterType)
                                                        });
                                                    }
                                                });

                                                args.response.success({
                                                    actionFilter: routerActionfilter,
                                                    data: $(routers).map(mapRouterType)
                                                });
                                            },

                                            detailView: {
                                                updateContext: function (args) {
                                                    var zone;

                                                    $.ajax({
                                                        url: createURL('listZones'),
                                                        data: {
                                                            id: args.context.routers[0].zoneid
                                                        },
                                                        async: false,
                                                        success: function (json) {
                                                            zone = json.listzonesresponse.zone[0];
                                                        }
                                                    });

                                                    selectedZoneObj = zone;

                                                    return {
                                                        zones:[zone]
                                                    };
                                                }
                                            }
                                        }
                                    }
                                }
                            });

                            return listView;
                        },

                        sockets: function () {
                            var listView = {
                                id: 'sockets',
                                fields: {
                                    hypervisor: {
                                        label: 'label.hypervisor'
                                    },
                                    hosts: {
                                        label: 'label.hosts'
                                    },
                                    sockets: {
                                        label: 'label.sockets'
                                    }
                                },
                                dataProvider: function (args) {
                                    var array1 = [];

                                    // ***** non XenServer (begin) *****
                    var hypervisors = ["Hyperv", "KVM", "VMware", "BareMetal", "LXC", "Ovm3"];

                                            var supportSocketHypervisors = {
                                                "Hyperv": 1,
                                                "KVM": 1,
                                                "VMware": 1,
                                                "Ovm3": 1
                                            };

                                    for (var h = 0; h < hypervisors.length; h++) {
                                                    var totalHostCount = 0;
                                                    var currentPage = 1;
                                                    var returnedHostCount = 0;
                                                    var returnedHostCpusocketsSum = 0;

                                        var callListHostsWithPage = function() {
                                                        $.ajax({
                                                            url: createURL('listHosts'),
                                                            async: false,
                                                            data: {
                                                                type: 'routing',
                                                    hypervisor: hypervisors[h],
                                                                page: currentPage,
                                                                pagesize: pageSize //global variable
                                                            },
                                                            success: function (json) {
                                                                if (json.listhostsresponse.count == undefined) {
                                                                    return;
                                                                }

                                                                    totalHostCount = json.listhostsresponse.count;
                                                                returnedHostCount += json.listhostsresponse.host.length;

                                                                var items = json.listhostsresponse.host;
                                                                for (var i = 0; i < items.length; i++) {
                                                                    if (items[i].cpusockets != undefined && isNaN(items[i].cpusockets) == false) {
                                                                        returnedHostCpusocketsSum += items[i].cpusockets;
                                                                    }
                                                                }

                                                                if (returnedHostCount < totalHostCount) {
                                                                    currentPage++;
                                                        callListHostsWithPage();
                                                                }
                                                            }
                                                        });
                                                    }

                                        callListHostsWithPage();

                                        if ((hypervisors[h] in supportSocketHypervisors) == false) {
                                                        returnedHostCpusocketsSum = 'N/A';
                                                    }

                                        var hypervisorName = hypervisors[h];
                                        if (hypervisorName == "Hyperv") {
                                            hypervisorName = "Hyper-V";
                                        }

                                        array1.push({
                                            hypervisor: hypervisorName,
                                                        hosts: totalHostCount,
                                                        sockets: returnedHostCpusocketsSum
                                            });
                                        }
                                    // ***** non XenServer (end) *****


                                    // ***** XenServer (begin) *****
                                    var totalHostCount = 0;
                                    var currentPage = 1;
                                    var returnedHostCount = 0;

                                    var returnedHostCountForXenServer700 = 0;  //'XenServer 7.0.0'
                                    var returnedHostCpusocketsSumForXenServer700 = 0;

                                    var returnedHostCountForXenServer650 = 0;  //'XenServer 6.5.0'
                                    var returnedHostCpusocketsSumForXenServer650 = 0;

                                    var returnedHostCountForXenServer620 = 0;  //'XenServer 6.2.0'
                                    var returnedHostCpusocketsSumForXenServer620 = 0;

                                    var returnedHostCountForXenServer61x = 0;  //'XenServer 6.1.x and before'

                                    var callListHostsWithPage = function() {
                                        $.ajax({
                                            url: createURL('listHosts'),
                                            async: false,
                                            data: {
                                                type: 'routing',
                                                hypervisor: 'XenServer',
                                                page: currentPage,
                                                pagesize: pageSize //global variable
                                            },
                                            success: function(json) {
                                                if (json.listhostsresponse.count == undefined) {
                                                    return;
                                                }

                                                totalHostCount = json.listhostsresponse.count;
                                                returnedHostCount += json.listhostsresponse.host.length;

                                                var items = json.listhostsresponse.host;
                                                for (var i = 0; i < items.length; i++) {
                                                    if (items[i].hypervisorversion == "7.0.0") {
                                                        returnedHostCountForXenServer700 ++;
                                                        if (items[i].cpusockets != undefined && isNaN(items[i].cpusockets) == false) {
                                                            returnedHostCpusocketsSumForXenServer700 += items[i].cpusockets;
                                                        }
													} else if (items[i].hypervisorversion == "6.5.0") {
                                                        returnedHostCountForXenServer650 ++;
                                                        if (items[i].cpusockets != undefined && isNaN(items[i].cpusockets) == false) {
                                                            returnedHostCpusocketsSumForXenServer650 += items[i].cpusockets;
                                                        }
                                                    } else if (items[i].hypervisorversion == "6.2.0") {
                                                        returnedHostCountForXenServer620 ++;
                                                        if (items[i].cpusockets != undefined && isNaN(items[i].cpusockets) == false) {
                                                            returnedHostCpusocketsSumForXenServer620 += items[i].cpusockets;
                                                        }
                                                    } else {
                                                        returnedHostCountForXenServer61x++;
                                                    }
                                                }

                                                if (returnedHostCount < totalHostCount) {
                                                    currentPage++;
                                                    callListHostsWithPage();
                                                }
                                            }
                                        });
                                    }

                                    callListHostsWithPage();

                                    array1.push({
                                        hypervisor: 'XenServer 7.0.0',
                                        hosts: returnedHostCountForXenServer700,
                                        sockets: returnedHostCpusocketsSumForXenServer700
                                    });

                                    array1.push({
                                        hypervisor: 'XenServer 6.5.0',
                                        hosts: returnedHostCountForXenServer650,
                                        sockets: returnedHostCpusocketsSumForXenServer650
                                    });

                                    array1.push({
                                        hypervisor: 'XenServer 6.2.0',
                                        hosts: returnedHostCountForXenServer620,
                                        sockets: returnedHostCpusocketsSumForXenServer620
                                    });

                                    array1.push({
                                        hypervisor: 'XenServer 6.1.x and before',
                                        hosts: returnedHostCountForXenServer61x,
                                        sockets: 'N/A'
                                    });

                                    // ***** XenServer (end) *****


                                    args.response.success({
                                        data: array1
                                    });

                                }
                            };

                            return listView;
                        },

                        managementServers: function () {
                            var listView = {
                                id: 'managementservers',
                                fields: {
                                    name: {
                                        label: 'label.name'
                                    },
                                    id: {
                                        label: 'label.uuid'
                                    },
                                    state: {
                                        label: 'label.state',
                                        indicator: {
                                            'Up': 'on',
                                            'Down': 'off'
                                        }
                                    },
                                    version: {
                                        label: 'label.version'
                                    }
                                },
                                dataProvider: function (args) {
                                        $.ajax({
                                            url: createURL('listManagementServers'),
                                            async: false,
                                            success: function (json) {
                                                args.response.success({ data: json.listmanagementserversresponse.managementserver });
                                            }
                                        });
                                    }
                                };
                            return listView;
                        }
                    }
                }
            }
        },
        subsections: {
            virtualRouters: {
                sectionSelect: {
                    label: 'label.select-view',
                    preFilter: function(args) {
                        //Only clicking ViewAll Link("view all Virtual Routers") in "Virtual Routers group by XXXXXXX" detailView will have "routerGroupByXXXXXXX" included in args.context
                        if ("routerGroupByZone" in args.context) {
                            return ["routerGroupByZone"]; // read-only (i.e. text "group by Zone")
                        } else if ( "routerGroupByPod" in args.context) {
                            return ["routerGroupByPod"]; // read-only (i.e. text "group by Pod")
                        } else if ("routerGroupByCluster" in args.context) {
                            return ["routerGroupByCluster"]; // read-only (i.e. text "group by Cluster")
                        } else if ("routerGroupByAccount" in args.context) {
                            return ["routerGroupByAccount"]; // read-only (i.e. text "group by Account")
                        } else {
                            return ["routerNoGroup", "routerGroupByZone", "routerGroupByPod", "routerGroupByCluster", "routerGroupByAccount"]; //editable dropdown
                        }
                    }
                },
                sections: {
                    routerNoGroup: {
                        id: 'routers',
                        type: 'select',
                        title: 'label.no.grouping',
                        listView: {
                            id: 'routers',
                            label: 'label.virtual.appliances',
                            horizontalOverflow: true,
                            fields: {
                                name: {
                                    label: 'label.name'
                                },
                                publicip: {
                                    label: 'label.ip'
                                },
                                routerType: {
                                    label: 'label.type'
                                },
                                guestnetworkname: {
                                    label: 'label.network'
                                },
                                account: {
                                    label: 'label.account'
                                },
                                hostname: {
                                    label: 'label.host'
                                },
                                state: {
                                    converter: function (str) {
                                        // For localization
                                        return str;
                                    },
                                    label: 'label.status',
                                    indicator: {
                                        'Running': 'on',
                                        'Stopped': 'off',
                                        'Error': 'off',
                                        'Alert': 'warning'
                                    }
                                },
                                healthchecksfailed: {
                                    converter: function (str) {
                                        if (str) return 'Failed'
                                        return 'Passed';
                                    },
                                    label: 'label.health.check',
                                    indicator: {
                                        false: 'on',
                                        true: 'warning'
                                    }
                                },
                                requiresupgrade: {
                                    label: 'label.requires.upgrade',
                                    converter: cloudStack.converters.toBooleanText
                                }
                            },
                            preFilter: function () {
                                if (!g_routerHealthChecksEnabled) {
                                    return ['healthchecksfailed']
                                }
                                return []
                            },
                            dataProvider: function (args) {
                                var array1 =[];
                                if (args.filterBy != null) {
                                    if (args.filterBy.search != null && args.filterBy.search.by != null && args.filterBy.search.value != null) {
                                        switch (args.filterBy.search.by) {
                                            case "name":
                                            if (args.filterBy.search.value.length > 0)
                                            array1.push("&keyword=" + args.filterBy.search.value);
                                            break;
                                        }
                                    }
                                }

                                var data2 = {
                                    // forvpc: false
                                };

                                if (args.context != undefined) {
                                    if ("routerGroupByZone" in args.context) {
                                        $.extend(data2, {
                                            zoneid: args.context.routerGroupByZone[0].id
                                        })
                                    } else if ("routerGroupByPod" in args.context) {
                                        $.extend(data2, {
                                            podid: args.context.routerGroupByPod[0].id
                                        })
                                    } else if ("routerGroupByCluster" in args.context) {
                                        $.extend(data2, {
                                            clusterid: args.context.routerGroupByCluster[0].id
                                        })
                                    } else if ("routerGroupByAccount" in args.context) {
                                        $.extend(data2, {
                                             account: args.context.routerGroupByAccount[0].name,
                                             domainid: args.context.routerGroupByAccount[0].domainid
                                        })
                                    }
                                    if ("networks" in args.context) {
                                       $.extend(data2, {
                                             networkid: args.context.networks[0].id
                                       })
                                    }
                                    if ("vpc" in args.context) {
                                       $.extend(data2, {
                                             vpcid: args.context.vpc[0].id
                                       })
                                    }
                                }

                                var routers =[];
                                $.ajax({
                                    url: createURL("listRouters&listAll=true&page=" + args.page + "&pagesize=" + pageSize + array1.join("")),
                                    data: data2,
                                    success: function (json) {
                                        var items = json.listroutersresponse.router ?
                                        json.listroutersresponse.router:[];

                                        $(items).map(function (index, item) {
                                            routers.push(item);
                                        });

                                        /*
                                         * In project view, the first listRotuers API(without projectid=-1) will return the same objects as the second listRouters API(with projectid=-1),
                                         * because in project view, all API calls are appended with projectid=[projectID].
                                         * Therefore, we only call the second listRouters API(with projectid=-1) in non-project view.
                                         */
                                        if (cloudStack.context && cloudStack.context.projects == null) { //non-project view
                                            /*
                                             * account parameter(account+domainid) and project parameter(projectid) are not allowed to be passed together to listXXXXXXX API.
                                             * So, remove account parameter(account+domainid) from data2
                                             */
                                            if ("account" in data2) {
                                                delete data2.account;
                                            }
                                            if ("domainid" in data2) {
                                                delete data2.domainid;
                                            }

                                            $.ajax({
                                                url: createURL("listRouters&page=" + args.page + "&pagesize=" + pageSize + array1.join("") + "&projectid=-1"),
                                                data: data2,
                                                async: false,
                                                success: function (json) {
                                                    var items = json.listroutersresponse.router ?
                                                    json.listroutersresponse.router:[];

                                                    var items = json.listroutersresponse.router ?
                                                    json.listroutersresponse.router:[];

                                                    $(items).map(function (index, item) {
                                                        routers.push(item);
                                                    });
                                                }
                                            });
                                        }

                                        args.response.success({
                                            actionFilter: routerActionfilter,
                                            data: $(routers).map(mapRouterType)
                                        });
                                    }
                                });
                            },
                            detailView: {
                                name: 'label.virtual.appliance.details',
                                viewAll: [{
                                    label: 'label.account',
                                    path: 'accounts',
                                    preFilter: function(args) {
                                        if (args.context.routers[0].projectid)
                                            return false;
                                        if (args.context.routers[0].account == 'system')
                                            return false;
                                        return true;
                                    }
                                }, {
                                    label: 'label.networks',
                                    path: 'network',
                                }, {
                                    label: 'label.instances',
                                    path: 'instances'
                                }],
                                actions: {
                                    start: {
                                        label: 'label.action.start.router',
                                        messages: {
                                            confirm: function (args) {
                                                return 'message.action.start.router';
                                            },
                                            notification: function (args) {
                                                return 'label.action.start.router';
                                            }
                                        },
                                        action: function (args) {
                                            $.ajax({
                                                url: createURL('startRouter&id=' + args.context.routers[0].id),
                                                dataType: 'json',
                                                async: true,
                                                success: function (json) {
                                                    var jid = json.startrouterresponse.jobid;
                                                    args.response.success({
                                                        _custom: {
                                                            jobId: jid,
                                                            getUpdatedItem: function (json) {
                                                                return json.queryasyncjobresultresponse.jobresult.router;
                                                            },
                                                            getActionFilter: function () {
                                                                return routerActionfilter;
                                                            }
                                                        }
                                                    });
                                                }
                                            });
                                        },
                                        notification: {
                                            poll: pollAsyncJobResult
                                        }
                                    },

                                    stop: {
                                        label: 'label.action.stop.router',
                                        createForm: {
                                            title: 'label.action.stop.router',
                                            desc: 'message.action.stop.router',
                                            fields: {
                                                forced: {
                                                    label: 'force.stop',
                                                    isBoolean: true,
                                                    isChecked: false
                                                }
                                            }
                                        },
                                        messages: {
                                            notification: function (args) {
                                                return 'label.action.stop.router';
                                            }
                                        },
                                        action: function (args) {
                                            var array1 =[];
                                            array1.push("&forced=" + (args.data.forced == "on"));
                                            $.ajax({
                                                url: createURL('stopRouter&id=' + args.context.routers[0].id + array1.join("")),
                                                dataType: 'json',
                                                async: true,
                                                success: function (json) {
                                                    var jid = json.stoprouterresponse.jobid;
                                                    args.response.success({
                                                        _custom: {
                                                            jobId: jid,
                                                            getUpdatedItem: function (json) {
                                                                return json.queryasyncjobresultresponse.jobresult.router;
                                                            },
                                                            getActionFilter: function () {
                                                                return routerActionfilter;
                                                            }
                                                        }
                                                    });
                                                }
                                            });
                                        },
                                        notification: {
                                            poll: pollAsyncJobResult
                                        }
                                    },

                                    upgradeRouterToUseNewerTemplate: {
                                        label: 'label.upgrade.router.newer.template',
                                        messages: {
                                            confirm: function (args) {
                                                return 'message.confirm.upgrade.router.newer.template';
                                            },
                                            notification: function (args) {
                                                return 'label.upgrade.router.newer.template';
                                            }
                                        },
                                        action: function (args) {
                                            $.ajax({
                                                url: createURL('upgradeRouterTemplate'),
                                                data: {
                                                    id: args.context.routers[0].id
                                                },
                                                success: function (json) {
                                                    var jobs = json.upgraderoutertemplateresponse.asyncjobs;
                                                    if (jobs != undefined) {
                                                        args.response.success({
                                                            _custom: {
                                                                jobId: jobs[0].jobid
                                                            }
                                                        });
                                                    }
                                                }
                                            });
                                        },
                                        notification: {
                                            poll: pollAsyncJobResult
                                        }
                                    },

                                    'remove': {
                                        label: 'label.destroy.router',
                                        messages: {
                                            confirm: function (args) {
                                                if (args && args.context && args.context.routers[0]) {
                                                    if (args.context.routers[0].state == 'Running') {
                                                        return dictionary['message.action.stop.router'] + ' ' + dictionary['message.confirm.destroy.router'];
                                                    }
                                                }
                                                return 'message.confirm.destroy.router';
                                            },
                                            notification: function (args) {
                                                return 'label.destroy.router';
                                            }
                                        },
                                        action: function (args) {
                                            $.ajax({
                                                url: createURL("destroyRouter&id=" + args.context.routers[0].id),
                                                dataType: "json",
                                                async: true,
                                                success: function (json) {
                                                    var jid = json.destroyrouterresponse.jobid;
                                                    args.response.success({
                                                        _custom: {
                                                            jobId: jid
                                                        }
                                                    });
                                                }
                                            });
                                        },
                                        notification: {
                                            poll: pollAsyncJobResult
                                        }
                                    },

                                    restart: {
                                        label: 'label.action.reboot.router',
                                        messages: {
                                            confirm: function (args) {
                                                return 'message.action.reboot.router';
                                            },
                                            notification: function (args) {
                                                return 'label.action.reboot.router';
                                            }
                                        },
                                        action: function (args) {
                                            $.ajax({
                                                url: createURL('rebootRouter&id=' + args.context.routers[0].id),
                                                dataType: 'json',
                                                async: true,
                                                success: function (json) {
                                                    var jid = json.rebootrouterresponse.jobid;
                                                    args.response.success({
                                                        _custom: {
                                                            jobId: jid,
                                                            getUpdatedItem: function (json) {
                                                                return json.queryasyncjobresultresponse.jobresult.router;
                                                            },
                                                            getActionFilter: function () {
                                                                return routerActionfilter;
                                                            }
                                                        }
                                                    });
                                                }
                                            });
                                        },
                                        notification: {
                                            poll: pollAsyncJobResult
                                        }
                                    },

                                    migrate: {
                                        label: 'label.action.migrate.router',
                                        createForm: {
                                            title: 'label.action.migrate.router',
                                            desc: '',
                                            fields: {
                                                hostId: {
                                                    label: 'label.host',
                                                    validation: {
                                                        required: true
                                                    },
                                                    select: function (args) {
                                                        $.ajax({
                                                            url: createURL("findHostsForMigration&VirtualMachineId=" + args.context.routers[0].id),
                                                            dataType: "json",
                                                            async: true,
                                                            success: function (json) {
                                                                var hostObjs = json.findhostsformigrationresponse.host;
                                                                var items =[];
                                                                $(hostObjs).each(function () {
                                                                    items.push({
                                                                        id: this.id,
                                                                        description: (this.name + " (" + (this.suitableformigration ? "Suitable": "Not Suitable") + ")")
                                                                    });
                                                                });
                                                                args.response.success({
                                                                    data: items
                                                                });
                                                            }
                                                        });
                                                    },
                                                    error: function (XMLHttpResponse) {
                                                        var errorMsg = parseXMLHttpResponse(XMLHttpResponse);
                                                        args.response.error(errorMsg);
                                                    }
                                                }
                                            }
                                        },
                                        messages: {
                                            notification: function (args) {
                                                return 'label.action.migrate.router';
                                            }
                                        },
                                        action: function (args) {
                                            $.ajax({
                                                url: createURL("migrateSystemVm&hostid=" + args.data.hostId + "&virtualmachineid=" + args.context.routers[0].id),
                                                dataType: "json",
                                                async: true,
                                                success: function (json) {
                                                    var jid = json.migratesystemvmresponse.jobid;
                                                    args.response.success({
                                                        _custom: {
                                                            jobId: jid,
                                                            getUpdatedItem: function (json) {
                                                                //return json.queryasyncjobresultresponse.jobresult.systemvminstance;    //not all properties returned in systemvminstance
                                                                $.ajax({
                                                                    url: createURL("listRouters&id=" + json.queryasyncjobresultresponse.jobresult.systemvm.id),
                                                                    dataType: "json",
                                                                    async: false,
                                                                    success: function (json) {
                                                                        var items = json.listroutersresponse.router;
                                                                        if (items != null && items.length > 0) {
                                                                            return items[0];
                                                                        }
                                                                    }
                                                                });
                                                            },
                                                            getActionFilter: function () {
                                                                return routerActionfilter;
                                                            }
                                                        }
                                                    });
                                                }
                                            });
                                        },
                                        notification: {
                                            poll: pollAsyncJobResult
                                        }
                                    },

                                    // VR Diagnostics
                                    diagnostics: {
                                        label: 'label.action.run.diagnostics',
                                        messages: {
                                            notification: function (args) {
                                                return 'label.action.run.diagnostics';
                                            },
                                            complete: function(args) {
                                                var exitcode = _l('message.diagnostics.exitcode');
                                                exitcode = exitcode.replace('var', args.exitcode);
                                                var stderr = _l('message.diagnostics.stderr');
                                                stderr = stderr.replace('var', args.stderr);
                                                var stdout = _l('message.diagnostics.stdout');
                                                stdout = stdout.replace('var', args.stdout);
                                                var msg = "<div style='text-align: left; overflow-y: auto'>" + exitcode + "<br><br>" + stderr + "<br><br>" + stdout + "</div>";
                                                return msg;
                                            }
                                        },
                                        createForm: {
                                            title: 'label.action.run.diagnostics',
                                            desc: '',
                                            fields: {
                                                type: {
                                                    label: 'label.run.diagnostics.type',
                                                    validation: {
                                                        required: true
                                                    },
                                                    select: function (args) {
                                                        var items = [];
                                                        items.push({
                                                            id: "ping",
                                                            description: "Ping"
                                                        });
                                                        items.push({
                                                            id: "traceroute",
                                                            description: "Traceroute"
                                                        });
                                                        items.push({
                                                            id: "arping",
                                                            description: "Arping"
                                                        });
                                                        args.response.success({
                                                            data: items
                                                        });
                                                    }
                                                },
                                                destination: {
                                                    label: 'label.run.diagnostics.destination',
                                                    validation: {
                                                        required: true
                                                    }
                                                },
                                                extra: {
                                                    label: 'label.run.diagnostics.extra'
                                                }

                                            }
                                        },
                                        action: function (args) {
                                            $.ajax({
                                                url: createURL("runDiagnostics&targetid=" + args.context.routers[0].id + "&ipaddress=" + args.data.destination + "&type=" + args.data.type + "&params=" + args.data.extra),
                                                dataType: "json",
                                                async: true,
                                                success: function(json) {
                                                    var jid = json.rundiagnosticsresponse.jobid;
                                                    args.response.success({
                                                        _custom: {
                                                            jobId : jid,
                                                            getUpdatedItem: function (json) {
                                                                return json.queryasyncjobresultresponse.jobresult.diagnostics;

                                                            },
                                                            getActionFilter: function(){
                                                                return routerActionfilter;
                                                           }
                                                        }

                                                    });
                                                }
                                            }); //end ajax
                                        },
                                        notification: {
                                            poll: pollAsyncJobResult
                                        }
                                    },

                                    retrieveDiagnostics: {
                                        label: 'label.action.get.diagnostics',
                                        messages: {
                                            notification: function (args) {
                                                return 'label.action.get.diagnostics';
                                            },
                                            complete: function(args) {
                                                var url = args.url;
                                                var htmlMsg = _l('message.download.diagnostics');
                                                var htmlMsg2 = htmlMsg.replace(/#/, url).replace(/00000/, url);
                                                return htmlMsg2;
                                            }
                                        },
                                        createForm: {
                                            title: 'label.action.get.diagnostics',
                                            desc: 'label.get.diagnostics.desc',
                                            fields: {
                                                files: {
                                                    label: 'label.get.diagnostics.files'
                                                }
                                            }
                                        },
                                        action: function (args) {
                                            $.ajax({
                                                url: createURL("getDiagnosticsData&targetid=" + args.context.routers[0].id + "&files=" + args.data.files),
                                                dataType: "json",
                                                async: true,
                                                success: function(json) {
                                                    var jid = json.getdiagnosticsdataresponse.jobid;
                                                    args.response.success({
                                                        _custom: {
                                                            jobId : jid,
                                                            getUpdatedItem: function (json) {
                                                                return json.queryasyncjobresultresponse.jobresult.diagnostics;

                                                            },
                                                            getActionFilter: function(){
                                                                return systemvmActionfilter;
                                                           }
                                                        }

                                                    });
                                                }
                                            }); //end ajax
                                        },
                                        notification: {
                                            poll: pollAsyncJobResult
                                        }
                                    },

                                    scaleUp: { //*** Infrastructure > Virtual Routers > change service offering ***
                                        label: 'label.change.service.offering',
                                        createForm: {
                                            title: 'label.change.service.offering',
                                            desc: function (args) {
                                                var description = '';
                                                var vmObj = args.jsonObj;
                                                //if (vmObj.state == 'Running' && vmObj.hypervisor == 'VMware') { //needs to wait for API fix that will return hypervisor property
                                                if (vmObj.state == 'Running') {
                                                    description = 'message.read.admin.guide.scaling.up';
                                                }
                                                return description;
                                            },
                                            fields: {
                                                serviceOfferingId: {
                                                    label: 'label.compute.offering',
                                                    select: function (args) {
                                                        $.ajax({
                                                            url: createURL('listServiceOfferings'),
                                                            data: {
                                                                issystem: true,
                                                                systemvmtype: 'domainrouter',
                                                                virtualmachineid: args.context.routers[0].id
                                                            },
                                                            success: function (json) {
                                                                var serviceofferings = json.listserviceofferingsresponse.serviceoffering;
                                                                var items =[];
                                                                $(serviceofferings).each(function () {
                                                                    // if(this.id != args.context.routers[0].serviceofferingid) {
                                                                    items.push({
                                                                        id: this.id,
                                                                        description: this.name
                                                                    });
                                                                    //default one (i.e. "System Offering For Software Router") doesn't have displaytext property. So, got to use name property instead.
                                                                });
                                                                args.response.success({
                                                                    data: items
                                                                });
                                                            }
                                                        });
                                                    }
                                                }
                                            }
                                        },

                                        action: function (args) {
                                            $.ajax({
                                                url: createURL("scaleSystemVm&id=" + args.context.routers[0].id + "&serviceofferingid=" + args.data.serviceOfferingId),
                                                dataType: "json",
                                                async: true,
                                                success: function (json) {
                                                    var jid = json.changeserviceforsystemvmresponse.jobid;
                                                    args.response.success({
                                                        _custom: {
                                                            jobId: jid,
                                                            getUpdatedItem: function (json) {
                                                                return json.queryasyncjobresultresponse.jobresult.systemvm;
                                                            },
                                                            getActionFilter: function () {
                                                                return routerActionfilter;
                                                            }
                                                        }
                                                    });
                                                },
                                                error: function (json) {
                                                    args.response.error(parseXMLHttpResponse(json));
                                                }
                                            });
                                        },
                                        messages: {
                                            confirm: function (args) {
                                                return 'message.confirm.scale.up.router.vm';
                                            },
                                            notification: function (args) {

                                                return 'label.router.vm.scaled.up';
                                            }
                                        },
                                        notification: {
                                            poll: pollAsyncJobResult
                                        }
                                    },


                                    viewConsole: {
                                        label: 'label.view.console',
                                        action: {
                                            externalLink: {
                                                url: function (args) {
                                                    return clientConsoleUrl + '?cmd=access&vm=' + args.context.routers[0].id;
                                                },
                                                title: function (args) {
                                                    return args.context.routers[0].id.substr(0, 8);
                                                    //title in window.open() can't have space nor longer than 8 characters. Otherwise, IE browser will have error.
                                                },
                                                width: 820,
                                                height: 640
                                            }
                                        }
                                    },

                                    healthChecks: {
                                        label: 'label.action.router.health.checks',
                                        createForm: {
                                            title: 'label.action.router.health.checks',
                                            desc: 'message.action.router.health.checks',
                                            fields: {
                                                performfreshchecks: {
                                                    label: 'label.perform.fresh.checks',
                                                    isBoolean: true
                                                }
                                            }
                                        },
                                        action: function (args) {
                                            if (!g_routerHealthChecksEnabled) {
                                                cloudStack.dialog.notice({
                                                    message: 'Router health checks are disabled. Please enable router.health.checks.enabled to execute this action'
                                                })
                                                args.response.success()
                                                return
                                            }
                                            var data = {
                                                'routerid': args.context.routers[0].id,
                                                'performfreshchecks': (args.data.performfreshchecks === 'on')
                                            };
                                            $.ajax({
                                                url: createURL('getRouterHealthCheckResults'),
                                                dataType: 'json',
                                                data: data,
                                                async: true,
                                                success: function (json) {
                                                    var healthChecks = json.getrouterhealthcheckresultsresponse.routerhealthchecks.healthchecks
                                                    var numChecks = healthChecks.length
                                                    var failedChecks = 0
                                                    $.each(healthChecks, function(idx, check) {
                                                        if (!check.success) failedChecks = failedChecks + 1
                                                    })
                                                    cloudStack.dialog.notice({
                                                        message: 'Found ' + numChecks + ' checks for router, with ' + failedChecks + ' failing checks. Please visit router > Health Checks tab to see details'
                                                    })
                                                    args.response.success();
                                                }
                                            });
                                        },
                                        messages: {
                                            notification: function(args) {
                                                return 'label.action.router.health.checks'
                                            }
                                        }
                                    }
                                },
                                tabs: {
                                    details: {
                                        title: 'label.details',
                                        preFilter: function (args) {
                                            var hiddenFields =[];
                                            if (! args.context.routers[0].project) {
                                                hiddenFields.push('project');
                                                hiddenFields.push('projectid');
                                            }
                                            $.ajax({
                                                url: createURL('listZones'),
                                                data: {
                                                    id: args.context.routers[0].zoneid
                                                },
                                                async: false,
                                                success: function (json) {
                                                    if (json.listzonesresponse.zone != undefined) {
                                                        var zoneObj = json.listzonesresponse.zone[0];
                                                        if (zoneObj.networktype == 'Basic') {
                                                            hiddenFields.push('publicip');
                                                            //In Basic zone, guest IP is public IP. So, publicip is not returned by listRouters API. Only guestipaddress is returned by listRouters API.
                                                        }
                                                    }
                                                }
                                            });

                                            if ('routers' in args.context && args.context.routers[0].vpcid != undefined) {
                                                hiddenFields.push('guestnetworkid');
                                                hiddenFields.push('guestnetworkname');
                                            } else if ('routers' in args.context && args.context.routers[0].guestnetworkid != undefined) {
                                                hiddenFields.push('vpcid');
                                                hiddenFields.push('vpcname');
                                            }

                                            return hiddenFields;
                                        },
                                        fields:[ {
                                            name: {
                                                label: 'label.name'
                                            },
                                            project: {
                                                label: 'label.project'
                                            }
                                        },
                                        {
                                            id: {
                                                label: 'label.id'
                                            },
                                            projectid: {
                                                label: 'label.project.id'
                                            },
                                            state: {
                                                label: 'label.state'
                                            },
                                            version: {
                                                label: 'label.version'
                                            },
                                            requiresupgrade: {
                                                label: 'label.requires.upgrade',
                                                converter: cloudStack.converters.toBooleanText
                                            },
                                            guestnetworkid: {
                                                label: 'label.network.id'
                                            },
                                            guestnetworkname: {
                                                label: 'label.network.name'
                                            },
                                            vpcid: {
                                                label: 'label.vpc.id'
                                            },
                                            vpcname: {
                                                label: 'label.vpc'
                                            },
                                            publicip: {
                                                label: 'label.public.ip'
                                            },
                                            guestipaddress: {
                                                label: 'label.guest.ip'
                                            },
                                            linklocalip: {
                                                label: 'label.linklocal.ip'
                                            },
                                            hostname: {
                                                label: 'label.host'
                                            },
                                            serviceofferingname: {
                                                label: 'label.compute.offering'
                                            },
                                            networkdomain: {
                                                label: 'label.network.domain'
                                            },
                                            domain: {
                                                label: 'label.domain'
                                            },
                                            account: {
                                                label: 'label.account'
                                            },
                                            created: {
                                                label: 'label.created',
                                                converter: cloudStack.converters.toLocalDate
                                            },
                                            isredundantrouter: {
                                                label: 'label.redundant.router',
                                                converter: cloudStack.converters.toBooleanText
                                            },
                                            redundantRouterState: {
                                                label: 'label.redundant.state'
                                            },
                                            vpcid: {
                                                label: 'label.vpc.id'
                                            }
                                        }],
                                        dataProvider: function (args) {
                                            $.ajax({
                                                url: createURL("listRouters&id=" + args.context.routers[0].id),
                                                dataType: 'json',
                                                async: true,
                                                success: function (json) {
                                                    var jsonObj = json.listroutersresponse.router[0];
                                                    addExtraPropertiesToRouterInstanceObject(jsonObj);
                                                    args.response.success({
                                                        actionFilter: routerActionfilter,
                                                        data: jsonObj
                                                    });
                                                }
                                            });
                                        }
                                    },
                                    nics: {
                                        title: 'label.nics',
                                        multiple: true,
                                        fields:[ {
                                            name: {
                                                label: 'label.name',
                                                header: true
                                            },
                                            type: {
                                                label: 'label.type'
                                            },
                                            traffictype: {
                                                label: 'label.traffic.type'
                                            },
                                            networkname: {
                                                label: 'label.network.name'
                                            },
                                            netmask: {
                                                label: 'label.netmask'
                                            },
                                            ipaddress: {
                                                label: 'label.ip.address'
                                            },
                                            id: {
                                                label: 'label.id'
                                            },
                                            networkid: {
                                                label: 'label.network.id'
                                            },
                                            isolationuri: {
                                                label: 'label.isolation.uri'
                                            },
                                            broadcasturi: {
                                                label: 'label.broadcast.uri'
                                            }
                                        }],
                                        dataProvider: function (args) {
                                            $.ajax({
                                                url: createURL("listRouters&id=" + args.context.routers[0].id),
                                                dataType: 'json',
                                                async: true,
                                                success: function (json) {
                                                    var jsonObj = json.listroutersresponse.router[0].nic;

                                                    args.response.success({
                                                        actionFilter: routerActionfilter,
                                                        data: $.map(jsonObj, function (nic, index) {
                                                            var name = 'NIC ' + (index + 1);
                                                            if (nic.isdefault) {
                                                                name += ' (' + _l('label.default') + ')';
                                                            }
                                                            return $.extend(nic, {
                                                                name: name
                                                            });
                                                        })
                                                    });
                                                }
                                            });
                                        }
                                    },
                                    healthCheckResults: {
                                        title: 'label.router.health.checks',
                                        listView: {
                                            id: 'routerHealthCheckResults',
                                            label: 'label.router.health.checks',
                                            hideToolbar: true,
                                            fields: {
                                                checkname: {
                                                    label: 'label.router.health.check.name'
                                                },
                                                checktype: {
                                                    label: 'label.router.health.check.type'
                                                },
                                                success: {
                                                    label: 'label.router.health.check.success',
                                                    converter: function (args) {
                                                        if (args) {
                                                            return _l('True');
                                                        } else {
                                                            return _l('False');
                                                        }
                                                    },
                                                    indicator: {
                                                        true: 'on',
                                                        false: 'off'
                                                    }
                                                },
                                                lastupdated: {
                                                    label: 'label.router.health.check.last.updated'
                                                }
                                            },
                                            actions: {
                                                details: {
                                                    label: 'label.router.health.check.details',
                                                    action: {
                                                        custom: function (args) {
                                                            cloudStack.dialog.notice({
                                                                message: args.context.routerHealthCheckResults[0].details
                                                            })
                                                        }
                                                    }
                                                }
                                            },
                                            dataProvider: function(args) {
                                                if (!g_routerHealthChecksEnabled) {
                                                    cloudStack.dialog.notice({
                                                        message: 'Router health checks are disabled. Please enable router.health.checks.enabled to get data'
                                                    })
                                                    args.response.success({})
                                                    return
                                                }
                                                if (args.page > 1) {
                                                    // Only one page is supported as it's not list command.
                                                    args.response.success({});
                                                    return
                                                }

                                                $.ajax({
                                                    url: createURL('getRouterHealthCheckResults'),
                                                    data: {
                                                        'routerid': args.context.routers[0].id
                                                    },
                                                    success: function (json) {
                                                        var hcData = json.getrouterhealthcheckresultsresponse.routerhealthchecks.healthchecks
                                                        args.response.success({
                                                            data: hcData
                                                        });
                                                    }
                                                });
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    },
                    routerGroupByZone: {
                        id: 'routerGroupByZone',
                        type: 'select',
                        title: 'label.group.by.zone',
                        listView: {
                            id: 'routerGroupByZone',
                            label: 'label.virtual.appliances',
                            fields: {
                                name: {
                                    label: 'label.zone'
                                },
                                routerCount: {
                                    label: 'label.total.virtual.routers'
                                },
                                routerRequiresUpgrade: {
                                    label: 'label.upgrade.required',
                                    converter: function (args) {
                                        if (args > 0) {
                                            return _l('label.yes');
                                        } else {
                                            return _l('label.no');
                                        }
                                    }
                                }
                            },

                            dataProvider: function (args) {
                                var array1 =[];
                                if (args.filterBy != null) {
                                    if (args.filterBy.search != null && args.filterBy.search.by != null && args.filterBy.search.value != null) {
                                        switch (args.filterBy.search.by) {
                                            case "name":
                                            if (args.filterBy.search.value.length > 0)
                                            array1.push("&keyword=" + args.filterBy.search.value);
                                            break;
                                        }
                                    }
                                }
                                $.ajax({
                                    url: createURL("listZones&page=" + args.page + "&pagesize=" + pageSize + array1.join("")),
                                    dataType: "json",
                                    async: true,
                                    success: function (json) {
                                        var groupbyObjs = json.listzonesresponse.zone;
                                        if (groupbyObjs != null) {
                                            addExtraPropertiesToGroupbyObjects(groupbyObjs, 'zoneid');
                                        }
                                        args.response.success({
                                            data: groupbyObjs
                                        });
                                    }
                                });
                            },
                            detailView: {
                                name: 'label.virtual.routers.group.zone',
                                viewAll: {
                                    path: '_zone.virtualRouters',
                                    label: 'label.virtual.appliances'
                                },
                                actions: {
                                    upgradeRouterToUseNewerTemplate: {
                                        label: 'label.upgrade.router.newer.template',
                                        messages: {
                                            confirm: function (args) {
                                                return 'message.confirm.upgrade.routers.newtemplate';
                                            },
                                            notification: function (args) {
                                                return 'label.upgrade.router.newer.template';
                                            }
                                        },
                                        action: function (args) {
                                            $.ajax({
                                                url: createURL('upgradeRouterTemplate'),
                                                data: {
                                                    zoneid: args.context.routerGroupByZone[0].id
                                                },
                                                success: function (json) {
                                                    var jobs = json.upgraderoutertemplateresponse.asyncjobs;
                                                    if (jobs != undefined) {
                                                        args.response.success({
                                                            _custom: {
                                                                jobId: jobs[0].jobid
                                                            }
                                                        });
                                                    }
                                                }
                                            });
                                        },
                                        notification: {
                                            poll: pollAsyncJobResult
                                        }
                                    }
                                },
                                tabs: {
                                    details: {
                                        title: 'label.virtual.routers.group.zone',
                                        fields:[ {
                                            name: {
                                                label: 'label.zone'
                                            }
                                        },
                                        {
                                            routerCount: {
                                                label: 'label.total.virtual.routers'
                                            },
                                            routerRequiresUpgrade: {
                                                label: 'label.upgrade.required',
                                                converter: function (args) {
                                                    if (args > 0) {
                                                        return _l('label.yes');
                                                    } else {
                                                        return _l('label.no');
                                                    }
                                                }
                                            },
                                            numberOfRouterRequiresUpgrade: {
                                                label: 'label.total.virtual.routers.upgrade'
                                            }
                                        }],
                                        dataProvider: function (args) {
                                            addExtraPropertiesToGroupbyObject(args.context.routerGroupByZone[0], 'zoneid');
                                            args.response.success({
                                                data: args.context.routerGroupByZone[0],
                                                actionFilter: routerGroupActionfilter
                                            });
                                        }
                                    }
                                }
                            }
                        }
                    },
                    routerGroupByPod: {
                        id: 'routerGroupByPod',
                        type: 'select',
                        title: 'label.group.by.pod',
                        listView: {
                            id: 'routerGroupByPod',
                            label: 'label.virtual.appliances',
                            fields: {
                                name: {
                                    label: 'label.pod'
                                },
                                routerCount: {
                                    label: 'label.total.virtual.routers'
                                },
                                routerRequiresUpgrade: {
                                    label: 'label.upgrade.required',
                                    converter: function (args) {
                                        if (args > 0) {
                                            return _l('label.yes');
                                        } else {
                                            return _l('label.no');
                                        }
                                    }
                                }
                            },

                            dataProvider: function (args) {
                                var array1 =[];
                                if (args.filterBy != null) {
                                    if (args.filterBy.search != null && args.filterBy.search.by != null && args.filterBy.search.value != null) {
                                        switch (args.filterBy.search.by) {
                                            case "name":
                                            if (args.filterBy.search.value.length > 0)
                                            array1.push("&keyword=" + args.filterBy.search.value);
                                            break;
                                        }
                                    }
                                }
                                $.ajax({
                                    url: createURL("listPods&page=" + args.page + "&pagesize=" + pageSize + array1.join("")),
                                    dataType: "json",
                                    async: true,
                                    success: function (json) {
                                        var groupbyObjs = json.listpodsresponse.pod;
                                        if (groupbyObjs != null) {
                                            addExtraPropertiesToGroupbyObjects(groupbyObjs, 'podid');
                                        }
                                        args.response.success({
                                            data: groupbyObjs
                                        });
                                    }
                                });
                            },
                            detailView: {
                                name: 'label.virtual.routers.group.pod',
                                viewAll: {
                                    path: '_zone.virtualRouters',
                                    label: 'label.virtual.appliances'
                                },
                                actions: {
                                    upgradeRouterToUseNewerTemplate: {
                                        label: 'label.upgrade.router.newer.template',
                                        messages: {
                                            confirm: function (args) {
                                                return 'message.confirm.upgrade.routers.pod.newtemplate';
                                            },
                                            notification: function (args) {
                                                return 'label.upgrade.router.newer.template';
                                            }
                                        },
                                        action: function (args) {
                                            $.ajax({
                                                url: createURL('upgradeRouterTemplate'),
                                                data: {
                                                    podid: args.context.routerGroupByPod[0].id
                                                },
                                                success: function (json) {
                                                    var jobs = json.upgraderoutertemplateresponse.asyncjobs;
                                                    if (jobs != undefined) {
                                                        args.response.success({
                                                            _custom: {
                                                                jobId: jobs[0].jobid
                                                            }
                                                        });
                                                    }
                                                }
                                            });
                                        },
                                        notification: {
                                            poll: pollAsyncJobResult
                                        }
                                    }
                                },
                                tabs: {
                                    details: {
                                        title: 'label.virtual.routers.group.pod',
                                        fields:[ {
                                            name: {
                                                label: 'label.pod'
                                            }
                                        },
                                        {
                                            routerCount: {
                                                label: 'label.total.virtual.routers'
                                            },
                                            routerRequiresUpgrade: {
                                                label: 'label.upgrade.required',
                                                converter: function (args) {
                                                    if (args > 0) {
                                                        return _l('label.yes');
                                                    } else {
                                                        return _l('label.no');
                                                    }
                                                }
                                            },
                                            numberOfRouterRequiresUpgrade: {
                                                label: 'label.total.virtual.routers.upgrade'
                                            },
                                            zonename: {
                                                label: 'label.zone'
                                            }
                                        }],
                                        dataProvider: function (args) {
                                            addExtraPropertiesToGroupbyObject(args.context.routerGroupByPod[0], 'podid');
                                            args.response.success({
                                                data: args.context.routerGroupByPod[0],
                                                actionFilter: routerGroupActionfilter
                                            });
                                        }
                                    }
                                }
                            }
                        }
                    },
                    routerGroupByCluster: {
                        id: 'routerGroupByCluster',
                        type: 'select',
                        title: 'label.group.by.cluster',
                        listView: {
                            id: 'routerGroupByCluster',
                            label: 'label.virtual.appliances',
                            fields: {
                                name: {
                                    label: 'label.cluster'
                                },
                                routerCount: {
                                    label: 'label.total.virtual.routers'
                                },
                                routerRequiresUpgrade: {
                                    label: 'label.upgrade.required',
                                    converter: function (args) {
                                        if (args > 0) {
                                            return _l('label.yes');
                                        } else {
                                            return _l('label.no');
                                        }
                                    }
                                }
                            },

                            dataProvider: function (args) {
                                var array1 =[];
                                if (args.filterBy != null) {
                                    if (args.filterBy.search != null && args.filterBy.search.by != null && args.filterBy.search.value != null) {
                                        switch (args.filterBy.search.by) {
                                            case "name":
                                            if (args.filterBy.search.value.length > 0)
                                            array1.push("&keyword=" + args.filterBy.search.value);
                                            break;
                                        }
                                    }
                                }
                                $.ajax({
                                    url: createURL("listClusters&page=" + args.page + "&pagesize=" + pageSize + array1.join("")),
                                    dataType: "json",
                                    async: true,
                                    success: function (json) {
                                        var groupbyObjs = json.listclustersresponse.cluster;
                                        if (groupbyObjs != null) {
                                            addExtraPropertiesToGroupbyObjects(groupbyObjs, 'clusterid');
                                        }
                                        args.response.success({
                                            data: groupbyObjs
                                        });
                                    }
                                });
                            },
                            detailView: {
                                name: 'label.virtual.routers.group.cluster',
                                viewAll: {
                                    path: '_zone.virtualRouters',
                                    label: 'label.virtual.appliances'
                                },
                                actions: {
                                    upgradeRouterToUseNewerTemplate: {
                                        label: 'label.upgrade.router.newer.template',
                                        messages: {
                                            confirm: function (args) {
                                                return 'message.confirm.upgrade.routers.cluster.newtemplate';
                                            },
                                            notification: function (args) {
                                                return 'label.upgrade.router.newer.template';
                                            }
                                        },
                                        action: function (args) {
                                            $.ajax({
                                                url: createURL('upgradeRouterTemplate'),
                                                data: {
                                                    clusterid: args.context.routerGroupByCluster[0].id
                                                },
                                                success: function (json) {
                                                    var jobs = json.upgraderoutertemplateresponse.asyncjobs;
                                                    if (jobs != undefined) {
                                                        args.response.success({
                                                            _custom: {
                                                                jobId: jobs[0].jobid
                                                            }
                                                        });
                                                    }
                                                }
                                            });
                                        },
                                        notification: {
                                            poll: pollAsyncJobResult
                                        }
                                    }
                                },
                                tabs: {
                                    details: {
                                        title: 'label.virtual.routers.group.cluster',
                                        fields:[ {
                                            name: {
                                                label: 'label.cluster'
                                            }
                                        },
                                        {
                                            routerCount: {
                                                label: 'label.total.virtual.routers'
                                            },
                                            routerRequiresUpgrade: {
                                                label: 'label.upgrade.required',
                                                converter: function (args) {
                                                    if (args > 0) {
                                                        return _l('label.yes');
                                                    } else {
                                                        return _l('label.no');
                                                    }
                                                }
                                            },
                                            numberOfRouterRequiresUpgrade: {
                                                label: 'label.total.virtual.routers.upgrade'
                                            },
                                            podname: {
                                                label: 'label.pod'
                                            },
                                            zonename: {
                                                label: 'label.zone.lower'
                                            }
                                        }],
                                        dataProvider: function (args) {
                                            addExtraPropertiesToGroupbyObject(args.context.routerGroupByCluster[0], 'clusterid');
                                            args.response.success({
                                                data: args.context.routerGroupByCluster[0],
                                                actionFilter: routerGroupActionfilter
                                            });
                                        }
                                    }
                                }
                            }
                        }
                    },
                    routerGroupByAccount: {
                        id: 'routerGroupByAccount',
                        type: 'select',
                        title: 'label.group.by.account',
                        listView: {
                            id: 'routerGroupByAccount',
                            label: 'label.virtual.appliances',
                            fields: {
                                name: {
                                    label: 'label.account'
                                },
                                domain: {
                                    label: 'label.domain'
                                },
                                routerCount: {
                                    label: 'label.total.virtual.routers'
                                },
                                routerRequiresUpgrade: {
                                    label: 'label.upgrade.required',
                                    converter: function (args) {
                                        if (args > 0) {
                                            return _l('label.yes');
                                        } else {
                                            return _l('label.no');
                                        }
                                    }
                                }
                            },

                            dataProvider: function (args) {
                                var array1 =[];
                                if (args.filterBy != null) {
                                    if (args.filterBy.search != null && args.filterBy.search.by != null && args.filterBy.search.value != null) {
                                        switch (args.filterBy.search.by) {
                                            case "name":
                                            if (args.filterBy.search.value.length > 0)
                                            array1.push("&keyword=" + args.filterBy.search.value);
                                            break;
                                        }
                                    }
                                }
                                $.ajax({
                                    url: createURL("listAccounts&listAll=true&details=min&page=" + args.page + "&pagesize=" + pageSize + array1.join("")),
                                    success: function (json) {
                                        var accountObjs = json.listaccountsresponse.account;
                                        if (accountObjs != null) {
                                            for (var i = 0; i < accountObjs.length; i++) {
                                                var currentPage = 1;
                                                $.ajax({
                                                    url: createURL('listRouters'),
                                                    data: {
                                                        account: accountObjs[i].name,
                                                        domainid: accountObjs[i].domainid,
                                                        listAll: true,
                                                        page: currentPage,
                                                        pagesize: pageSize //global variable
                                                    },
                                                    async: false,
                                                    success: function (json) {
                                                        if (json.listroutersresponse.count != undefined) {
                                                            accountObjs[i].routerCount = json.listroutersresponse.count;
                                                            var routerCountFromAllPages = json.listroutersresponse.count;
                                                            var routerCountFromFirstPageToCurrentPage = json.listroutersresponse.router.length;
                                                            var routerRequiresUpgrade = 0;

                                                            var items = json.listroutersresponse.router;
                                                            for (var k = 0; k < items.length; k++) {
                                                                if (items[k].requiresupgrade) {
                                                                    routerRequiresUpgrade++;
                                                                }
                                                            }

                                                            var callListApiWithPage = function () {
                                                                $.ajax({
                                                                    url: createURL('listRouters'),
                                                                    async: false,
                                                                    data: {
                                                                        account: accountObjs[i].name,
                                                                        domainid: accountObjs[i].domainid,
                                                                        listAll: true,
                                                                        page: currentPage,
                                                                        pagesize: pageSize //global variable
                                                                    },
                                                                    success: function (json) {
                                                                        routerCountFromFirstPageToCurrentPage += json.listroutersresponse.router.length;
                                                                        var items = json.listroutersresponse.router;
                                                                        for (var k = 0; k < items.length; k++) {
                                                                            if (items[k].requiresupgrade) {
                                                                                routerRequiresUpgrade++;
                                                                            }
                                                                        }
                                                                        if (routerCountFromFirstPageToCurrentPage < routerCountFromAllPages) {
                                                                            currentPage++;
                                                                            callListApiWithPage();
                                                                        }
                                                                    }
                                                                });
                                                            }
                                                            if (routerCountFromFirstPageToCurrentPage < routerCountFromAllPages) {
                                                                currentPage++;
                                                                callListApiWithPage();
                                                            }
                                                            accountObjs[i].routerRequiresUpgrade = routerRequiresUpgrade;
                                                        } else {
                                                            accountObjs[i].routerCount = 0;
                                                            accountObjs[i].routerRequiresUpgrade = 0;
                                                        }
                                                    }
                                                });
                                            }
                                        }
                                        args.response.success({
                                            data: accountObjs
                                        });
                                    }
                                });
                            },
                            detailView: {
                                name: 'label.virtual.routers.group.account',
                                viewAll: {
                                    path: '_zone.virtualRouters',
                                    label: 'label.virtual.appliances'
                                },
                                actions: {
                                    upgradeRouterToUseNewerTemplate: {
                                        label: 'label.upgrade.router.newer.template',
                                        messages: {
                                            confirm: function (args) {
                                                return 'message.confirm.upgrade.routers.account.newtemplate';
                                            },
                                            notification: function (args) {
                                                return 'label.upgrade.router.newer.template';
                                            }
                                        },
                                        action: function (args) {
                                            $.ajax({
                                                url: createURL('upgradeRouterTemplate'),
                                                data: {
                                                    account: args.context.routerGroupByAccount[0].name,
                                                    domainid: args.context.routerGroupByAccount[0].domainid
                                                },
                                                success: function (json) {
                                                    var jobs = json.upgraderoutertemplateresponse.asyncjobs;
                                                    if (jobs != undefined) {
                                                        args.response.success({
                                                            _custom: {
                                                                jobId: jobs[0].jobid
                                                            }
                                                        });
                                                    }
                                                }
                                            });
                                        },
                                        notification: {
                                            poll: pollAsyncJobResult
                                        }
                                    }
                                },
                                tabs: {
                                    details: {
                                        title: 'label.virtual.routers.group.account',
                                        fields:[ {
                                            name: {
                                                label: 'label.account'
                                            },
                                            domain: {
                                                label: 'label.domain'
                                            }
                                        },
                                        {
                                            routerCount: {
                                                label: 'label.total.virtual.routers'
                                            },
                                            routerRequiresUpgrade: {
                                                label: 'label.upgrade.required',
                                                converter: function (args) {
                                                    if (args > 0) {
                                                        return _l('label.yes');
                                                    } else {
                                                        return _l('label.no');
                                                    }
                                                }
                                            },
                                            numberOfRouterRequiresUpgrade: {
                                                label: 'label.total.virtual.routers.upgrade'
                                            }
                                        }],
                                        dataProvider: function (args) {
                                            var currentPage = 1;
                                            $.ajax({
                                                url: createURL('listRouters'),
                                                data: {
                                                    account: args.context.routerGroupByAccount[0].name,
                                                    domainid: args.context.routerGroupByAccount[0].domainid,
                                                    listAll: true,
                                                    page: currentPage,
                                                    pagesize: pageSize //global variable
                                                },
                                                async: false,
                                                success: function (json) {
                                                    if (json.listroutersresponse.count != undefined) {
                                                        args.context.routerGroupByAccount[0].routerCount = json.listroutersresponse.count;
                                                        var routerCountFromAllPages = json.listroutersresponse.count;
                                                        var routerCountFromFirstPageToCurrentPage = json.listroutersresponse.router.length;
                                                        var routerRequiresUpgrade = 0;

                                                        var items = json.listroutersresponse.router;
                                                        for (var k = 0; k < items.length; k++) {
                                                            if (items[k].requiresupgrade) {
                                                                routerRequiresUpgrade++;
                                                            }
                                                        }

                                                        var callListApiWithPage = function () {
                                                            $.ajax({
                                                                url: createURL('listRouters'),
                                                                async: false,
                                                                data: {
                                                                    account: args.context.routerGroupByAccount[0].name,
                                                                    domainid: args.context.routerGroupByAccount[0].domainid,
                                                                    listAll: true,
                                                                    page: currentPage,
                                                                    pagesize: pageSize //global variable
                                                                },
                                                                success: function (json) {
                                                                    routerCountFromFirstPageToCurrentPage += json.listroutersresponse.router.length;
                                                                    var items = json.listroutersresponse.router;
                                                                    for (var k = 0; k < items.length; k++) {
                                                                        if (items[k].requiresupgrade) {
                                                                            routerRequiresUpgrade++;
                                                                        }
                                                                    }
                                                                    if (routerCountFromFirstPageToCurrentPage < routerCountFromAllPages) {
                                                                        currentPage++;
                                                                        callListApiWithPage();
                                                                    }
                                                                }
                                                            });
                                                        }
                                                        if (routerCountFromFirstPageToCurrentPage < routerCountFromAllPages) {
                                                            currentPage++;
                                                            callListApiWithPage();
                                                        }
                                                        args.context.routerGroupByAccount[0].routerRequiresUpgrade = routerRequiresUpgrade;
                                                        args.context.routerGroupByAccount[0].numberOfRouterRequiresUpgrade = routerRequiresUpgrade;
                                                    } else {
                                                        args.context.routerGroupByAccount[0].routerCount = 0;
                                                        args.context.routerGroupByAccount[0].routerRequiresUpgrade = 0;
                                                        args.context.routerGroupByAccount[0].numberOfRouterRequiresUpgrade = 0;
                                                    }
                                                }
                                            });
                                            setTimeout(function () {
                                                args.response.success({
                                                    data: args.context.routerGroupByAccount[0],
                                                    actionFilter: routerGroupActionfilter
                                                });
                                            });
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            },
            systemVms: {
                listView: {
                    label: 'label.system.vms',
                    id: 'systemVMs',
                    fields: {
                        name: {
                            label: 'label.name'
                        },
                        systemvmtype: {
                            label: 'label.type',
                            converter: function (args) {
                                if (args == "consoleproxy")
                                return "Console Proxy VM"; else if (args == "secondarystoragevm")
                                return "Secondary Storage VM"; else
                                return args;
                            }
                        },
                        publicip: {
                            label: 'label.public.ip'
                        },
                        hostname: {
                            label: 'label.host'
                        },
                        zonename: {
                            label: 'label.zone'
                        },
                        state: {
                            label: 'label.vm.state',
                            converter: function (str) {
                                // For localization
                                return str;
                            },
                            indicator: {
                                'Running': 'on',
                                'Stopped': 'off',
                                'Error': 'off',
                                'Destroyed': 'off'
                            }
                        },

                        agentstate: {
                            label: 'label.agent.state',
                            indicator: {
                                'Up': 'on',
                                'Down': 'off'
                            }
                        }
                    },
                    dataProvider: function (args) {
                        var array1 =[];
                        if (args.filterBy != null) {
                            if (args.filterBy.search != null && args.filterBy.search.by != null && args.filterBy.search.value != null) {
                                switch (args.filterBy.search.by) {
                                    case "name":
                                    if (args.filterBy.search.value.length > 0)
                                    array1.push("&keyword=" + args.filterBy.search.value);
                                    break;
                                }
                            }
                        }

                        var selectedZoneObj = args.context.physicalResources[0];
                        $.ajax({
                            url: createURL("listSystemVms&zoneid=" + selectedZoneObj.id + "&page=" + args.page + "&pagesize=" + pageSize + array1.join("")),
                            dataType: "json",
                            async: true,
                            success: function (json) {
                                var items = json.listsystemvmsresponse.systemvm;
                                args.response.success({
                                    actionFilter: systemvmActionfilter,
                                    data: items
                                });
                            }
                        });
                    },

                    detailView: {
                        name: 'label.system.vm.details',
                        actions: {
                            start: {
                                label: 'label.action.start.systemvm',
                                messages: {
                                    confirm: function (args) {
                                        return 'message.action.start.systemvm';
                                    },
                                    notification: function (args) {
                                        return 'label.action.start.systemvm';
                                    }
                                },
                                action: function (args) {
                                    $.ajax({
                                        url: createURL('startSystemVm&id=' + args.context.systemVMs[0].id),
                                        dataType: 'json',
                                        async: true,
                                        success: function (json) {
                                            var jid = json.startsystemvmresponse.jobid;
                                            args.response.success({
                                                _custom: {
                                                    jobId: jid,
                                                    getUpdatedItem: function (json) {
                                                        return json.queryasyncjobresultresponse.jobresult.systemvm;
                                                    },
                                                    getActionFilter: function () {
                                                        return systemvmActionfilter;
                                                    }
                                                }
                                            });
                                        }
                                    });
                                },
                                notification: {
                                    poll: pollAsyncJobResult
                                }
                            },

                            stop: {
                                label: 'label.action.stop.systemvm',
                                messages: {
                                    confirm: function (args) {
                                        return 'message.action.stop.systemvm';
                                    },
                                    notification: function (args) {
                                        return 'label.action.stop.systemvm';
                                    }
                                },
                                action: function (args) {
                                    $.ajax({
                                        url: createURL('stopSystemVm&id=' + args.context.systemVMs[0].id),
                                        dataType: 'json',
                                        async: true,
                                        success: function (json) {
                                            var jid = json.stopsystemvmresponse.jobid;
                                            args.response.success({
                                                _custom: {
                                                    jobId: jid,
                                                    getUpdatedItem: function (json) {
                                                        return json.queryasyncjobresultresponse.jobresult.systemvm;
                                                    },
                                                    getActionFilter: function () {
                                                        return systemvmActionfilter;
                                                    }
                                                }
                                            });
                                        }
                                    });
                                },
                                notification: {
                                    poll: pollAsyncJobResult
                                }
                            },

                            restart: {
                                label: 'label.action.reboot.systemvm',
                                messages: {
                                    confirm: function (args) {
                                        return 'message.action.reboot.systemvm';
                                    },
                                    notification: function (args) {
                                        return 'label.action.reboot.systemvm';
                                    }
                                },
                                action: function (args) {
                                    $.ajax({
                                        url: createURL('rebootSystemVm&id=' + args.context.systemVMs[0].id),
                                        dataType: 'json',
                                        async: true,
                                        success: function (json) {
                                            var jid = json.rebootsystemvmresponse.jobid;
                                            args.response.success({
                                                _custom: {
                                                    jobId: jid,
                                                    getUpdatedItem: function (json) {
                                                        return json.queryasyncjobresultresponse.jobresult.systemvm;
                                                    },
                                                    getActionFilter: function () {
                                                        return systemvmActionfilter;
                                                    }
                                                }
                                            });
                                        }
                                    });
                                },
                                notification: {
                                    poll: pollAsyncJobResult
                                }
                            },

                            remove: {
                                label: 'label.action.destroy.systemvm',
                                messages: {
                                    confirm: function (args) {
                                        return 'message.action.destroy.systemvm';
                                    },
                                    notification: function (args) {
                                        return 'label.action.destroy.systemvm';
                                    }
                                },
                                action: function (args) {
                                    $.ajax({
                                        url: createURL('destroySystemVm&id=' + args.context.systemVMs[0].id),
                                        dataType: 'json',
                                        async: true,
                                        success: function (json) {
                                            var jid = json.destroysystemvmresponse.jobid;
                                            args.response.success({
                                                _custom: {
                                                    getUpdatedItem: function () {
                                                        return {
                                                            state: 'Destroyed'
                                                        };
                                                    },
                                                    jobId: jid
                                                }
                                            });
                                        }
                                    });
                                },
                                notification: {
                                    poll: pollAsyncJobResult
                                }
                            },

                            migrate: {
                                label: 'label.action.migrate.systemvm',
                                messages: {
                                    notification: function (args) {
                                        return 'label.action.migrate.systemvm';
                                    }
                                },
                                createForm: {
                                    title: 'label.action.migrate.systemvm',
                                    desc: '',
                                    fields: {
                                        hostId: {
                                            label: 'label.host',
                                            validation: {
                                                required: true
                                            },
                                            select: function (args) {
                                                $.ajax({
                                                    url: createURL("findHostsForMigration&VirtualMachineId=" + args.context.systemVMs[0].id),
                                                    dataType: "json",
                                                    async: true,
                                                    success: function (json) {
                                                        var hostObjs = json.findhostsformigrationresponse.host;
                                                        var items =[];
                                                        $(hostObjs).each(function () {
                                                            if (this.requiresStorageMotion == false) {
                                                                items.push({
                                                                    id: this.id,
                                                                    description: (this.name + " (" + (this.suitableformigration ? "Suitable": "Not Suitable") + ")")
                                                                });
                                                            }
                                                        });
                                                        args.response.success({
                                                            data: items
                                                        });
                                                    }
                                                });
                                            },
                                            error: function (XMLHttpResponse) {
                                                var errorMsg = parseXMLHttpResponse(XMLHttpResponse);
                                                args.response.error(errorMsg);
                                            }
                                        }
                                    }
                                },
                                action: function (args) {
                                    $.ajax({
                                        url: createURL("migrateSystemVm&hostid=" + args.data.hostId + "&virtualmachineid=" + args.context.systemVMs[0].id),
                                        dataType: "json",
                                        async: true,
                                        success: function (json) {
                                            var jid = json.migratesystemvmresponse.jobid;
                                            args.response.success({
                                                _custom: {
                                                    jobId: jid,
                                                    getUpdatedItem: function (json) {
                                                        //return json.queryasyncjobresultresponse.jobresult.systemvminstance;    //not all properties returned in systemvminstance
                                                        $.ajax({
                                                            url: createURL("listSystemVms&id=" + json.queryasyncjobresultresponse.jobresult.systemvm.id),
                                                            dataType: "json",
                                                            async: false,
                                                            success: function (json) {
                                                                var items = json.listsystemvmsresponse.systemvm;
                                                                if (items != null && items.length > 0) {
                                                                    return items[0];
                                                                }
                                                            }
                                                        });
                                                    },
                                                    getActionFilter: function () {
                                                        return systemvmActionfilter;
                                                    }
                                                }
                                            });
                                        }
                                    });
                                },
                                notification: {
                                    poll: pollAsyncJobResult
                                }
                            },

                            diagnostics: {
                                label: 'label.action.run.diagnostics',
                                messages: {
                                    notification: function (args) {
                                        return 'label.action.run.diagnostics';
                                    },
                                    complete: function(args) {
                                        var exitcode = _l('message.diagnostics.exitcode');
                                        exitcode = exitcode.replace('var', args.exitcode);
                                        var stderr = _l('message.diagnostics.stderr');
                                        stderr = stderr.replace('var', args.stderr);
                                        var stdout = _l('message.diagnostics.stdout');
                                        stdout = stdout.replace('var', args.stdout);
                                        var msg = "<div style='text-align: left; overflow-y: auto'>" + exitcode + "<br><br>" + stderr + "<br><br>" + stdout + "</div>";
                                        return msg;
                                    }
                                },
                                createForm: {
                                    title: 'label.action.run.diagnostics',
                                    desc: '',
                                    fields: {
                                        type: {
                                            label: 'label.run.diagnostics.type',
                                            validation: {
                                                required: true
                                            },
                                            select: function (args) {
                                                var items = [];
                                                items.push({
                                                    id: "ping",
                                                    description: "Ping"
                                                });
                                                items.push({
                                                    id: "traceroute",
                                                    description: "Traceroute"
                                                });
                                                items.push({
                                                    id: "arping",
                                                    description: "Arping"
                                                });
                                                args.response.success({
                                                    data: items
                                                });
                                            }
                                        },
                                        destination: {
                                            label: 'label.run.diagnostics.destination',
                                            validation: {
                                                required: true
                                            }
                                        },
                                        extra: {
                                            label: 'label.run.diagnostics.extra'
                                        }

                                    }
                                },
                                action: function (args) {
                                    $.ajax({
                                        url: createURL("runDiagnostics&targetid=" + args.context.systemVMs[0].id + "&ipaddress=" + args.data.destination + "&type=" + args.data.type + "&params=" + args.data.extra),
                                        dataType: "json",
                                        async: true,
                                        success: function(json) {
                                            var jid = json.rundiagnosticsresponse.jobid;
                                            args.response.success({
                                                _custom: {
                                                    jobId : jid,
                                                    getUpdatedItem: function (json) {
                                                        return json.queryasyncjobresultresponse.jobresult.diagnostics;

                                                    },
                                                    getActionFilter: function(){
                                                        return systemvmActionfilter;
                                                   }
                                                }

                                            });
                                        }
                                    }); //end ajax
                                },
                                notification: {
                                    poll: pollAsyncJobResult
                                }
                            },

                            retrieveDiagnostics: {
                                label: 'label.action.get.diagnostics',
                                messages: {
                                    notification: function (args) {
                                        return 'label.action.get.diagnostics';
                                    },
                                    complete: function(args) {
                                        var url = args.url;
                                        var htmlMsg = _l('message.download.diagnostics');
                                        var htmlMsg2 = htmlMsg.replace(/#/, url).replace(/00000/, url);
                                        return htmlMsg2;
                                    }
                                },
                                createForm: {
                                    title: 'label.action.get.diagnostics',
                                    desc: 'label.get.diagnostics.desc',
                                    fields: {
                                        files: {
                                            label: 'label.get.diagnostics.files'
                                        }
                                    }
                                },
                                action: function (args) {
                                    $.ajax({
                                        url: createURL("getDiagnosticsData&targetid=" + args.context.systemVMs[0].id + "&files=" + args.data.files),
                                        dataType: "json",
                                        async: true,
                                        success: function(json) {
                                            var jid = json.getdiagnosticsdataresponse.jobid;
                                            args.response.success({
                                                _custom: {
                                                    jobId : jid,
                                                    getUpdatedItem: function (json) {
                                                        return json.queryasyncjobresultresponse.jobresult.diagnostics;

                                                    },
                                                    getActionFilter: function(){
                                                        return systemvmActionfilter;
                                                   }
                                                }

                                            });
                                        }
                                    }); //end ajax
                                },
                                notification: {
                                    poll: pollAsyncJobResult
                                }
                            },

                            scaleUp: { //*** Infrastructure > System VMs (consoleProxy or SSVM) > change service offering ***
                                label: 'label.change.service.offering',
                                createForm: {
                                    title: 'label.change.service.offering',
                                    desc: function (args) {
                                        var description = '';
                                        var vmObj = args.jsonObj;
                                        //if (vmObj.state == 'Running' && vmObj.hypervisor == 'VMware') { //needs to wait for API fix that will return hypervisor property
                                        if (vmObj.state == 'Running') {
                                            description = 'message.read.admin.guide.scaling.up';
                                        }
                                        return description;
                                    },
                                    fields: {
                                        serviceOfferingId: {
                                            label: 'label.compute.offering',
                                            select: function (args) {
                                                var data1 = {
                                                    issystem: 'true',
                                                    virtualmachineid: args.context.systemVMs[0].id
                                                };
                                                if (args.context.systemVMs[0].systemvmtype == "secondarystoragevm") {
                                                    $.extend(data1, {
                                                        systemvmtype: 'secondarystoragevm'
                                                    });
                                                }
                                                else if (args.context.systemVMs[0].systemvmtype == "consoleproxy") {
                                                    $.extend(data1, {
                                                        systemvmtype: 'consoleproxy'
                                                    });
                                                }
                                                $.ajax({
                                                    url: createURL('listServiceOfferings'),
                                                    data: data1,
                                                    success: function (json) {
                                                        var serviceofferings = json.listserviceofferingsresponse.serviceoffering;
                                                        var items =[];
                                                        $(serviceofferings).each(function () {
                                                            if (this.id != args.context.systemVMs[0].serviceofferingid) {
                                                                items.push({
                                                                    id: this.id,
                                                                    description: this.name
                                                                });
                                                            }
                                                        });
                                                        args.response.success({
                                                            data: items
                                                        });
                                                    }
                                                });
                                            }
                                        }
                                    }
                                },

                                action: function (args) {
                                    $.ajax({
                                        url: createURL("scaleSystemVm&id=" + args.context.systemVMs[0].id + "&serviceofferingid=" + args.data.serviceOfferingId),
                                        dataType: "json",
                                        async: true,
                                        success: function (json) {
                                            var jid = json.changeserviceforsystemvmresponse.jobid;
                                            args.response.success({
                                                _custom: {
                                                    jobId: jid,
                                                    getUpdatedItem: function (json) {
                                                        return json.queryasyncjobresultresponse.jobresult.systemvm;
                                                    },
                                                    getActionFilter: function () {
                                                        return vmActionfilter;
                                                    }
                                                }
                                            });
                                        },
                                        error: function (json) {
                                            args.response.error(parseXMLHttpResponse(json));
                                        }
                                    });
                                },
                                messages: {
                                    confirm: function (args) {
                                        return 'message.confirm.scale.up.system.vm';
                                    },
                                    notification: function (args) {

                                        return 'label.system.vm.scaled.up';
                                    }
                                },
                                notification: {
                                    poll: pollAsyncJobResult
                                }
                            },

                            viewConsole: {
                                label: 'label.view.console',
                                action: {
                                    externalLink: {
                                        url: function (args) {
                                            return clientConsoleUrl + '?cmd=access&vm=' + args.context.systemVMs[0].id;
                                        },
                                        title: function (args) {
                                            return args.context.systemVMs[0].id.substr(0, 8);
                                            //title in window.open() can't have space nor longer than 8 characters. Otherwise, IE browser will have error.
                                        },
                                        width: 820,
                                        height: 640
                                    }
                                }
                            }
                        },
                        tabs: {
                            details: {
                                title: 'label.details',
                                fields:[ {
                                    name: {
                                        label: 'label.name'
                                    }
                                },
                                {
                                    id: {
                                        label: 'label.id'
                                    },
                                    state: {
                                        label: 'label.state'
                                    },
                                    systemvmtype: {
                                        label: 'label.type',
                                        converter: function (args) {
                                            if (args == "consoleproxy")
                                            return "Console Proxy VM"; else if (args == "secondarystoragevm")
                                            return "Secondary Storage VM"; else
                                            return args;
                                        }
                                    },
                                    zonename: {
                                        label: 'label.zone'
                                    },
                                    publicip: {
                                        label: 'label.public.ip'
                                    },
                                    privateip: {
                                        label: 'label.private.ip'
                                    },
                                    linklocalip: {
                                        label: 'label.linklocal.ip'
                                    },
                                    hostname: {
                                        label: 'label.host'
                                    },
                                    gateway: {
                                        label: 'label.gateway'
                                    },
                                    created: {
                                        label: 'label.created',
                                        converter: cloudStack.converters.toLocalDate
                                    },
                                    activeviewersessions: {
                                        label: 'label.active.sessions'
                                    }
                                }],
                                dataProvider: function (args) {
                                    $.ajax({
                                        url: createURL("listSystemVms&id=" + args.context.systemVMs[0].id),
                                        dataType: "json",
                                        async: true,
                                        success: function (json) {
                                            args.response.success({
                                                actionFilter: systemvmActionfilter,
                                                data: json.listsystemvmsresponse.systemvm[0]
                                            });
                                        }
                                    });
                                }
                            }
                        }
                    }
                }
            },
            // netscaler devices listView
            netscalerDevices: {
                id: 'netscalerDevices',
                title: 'label.devices',
                listView: {
                    id: 'netscalerDevices',
                    fields: {
                        ipaddress: {
                            label: 'label.ip.address'
                        },
                        lbdevicestate: {
                            converter: function (str) {
                                // For localization
                                return str;
                            },
                            label: 'label.status'
                        }
                    },
                    dataProvider: function (args) {
                        $.ajax({
                            url: createURL("listNetscalerLoadBalancers&physicalnetworkid=" + selectedPhysicalNetworkObj.id),
                            data: {
                                page: args.page,
                                pageSize: pageSize
                            },
                            dataType: "json",
                            async: false,
                            success: function (json) {
                                var items = json.listnetscalerloadbalancerresponse.netscalerloadbalancer;
                                args.response.success({
                                    data: items
                                });
                            }
                        });
                    },
                    actions: {
                        add: {
                            label: 'label.add.netScaler.device',
                            createForm: {
                                title: 'label.add.netScaler.device',
                                preFilter: cloudStack.preFilter.addLoadBalancerDevice,
                                fields: {
                                    ip: {
                                        label: 'label.ip.address'
                                    },
                                    username: {
                                        label: 'label.username'
                                    },
                                    password: {
                                        label: 'label.password',
                                        isPassword: true
                                    },
                                    networkdevicetype: {
                                        label: 'label.type',
                                        select: function (args) {
                                            var items =[];
                                            items.push({
                                                id: "NetscalerMPXLoadBalancer",
                                                description: "NetScaler MPX LoadBalancer"
                                            });
                                            items.push({
                                                id: "NetscalerVPXLoadBalancer",
                                                description: "NetScaler VPX LoadBalancer"
                                            });
                                            items.push({
                                                id: "NetscalerSDXLoadBalancer",
                                                description: "NetScaler SDX LoadBalancer"
                                            });
                                            args.response.success({
                                                data: items
                                            });
                                        }
                                    },
                                    publicinterface: {
                                        label: 'label.public.interface'
                                    },
                                    privateinterface: {
                                        label: 'label.private.interface'
                                    },

                                    gslbprovider: {
                                        label: 'label.gslb.service',
                                        isBoolean: true,
                                        isChecked: false
                                    },
                                    gslbproviderpublicip: {
                                        label: 'label.gslb.service.public.ip'
                                    },
                                    gslbproviderprivateip: {
                                        label: 'label.gslb.service.private.ip'
                                    },

                                    numretries: {
                                        label: 'label.numretries',
                                        defaultValue: '2'
                                    },
                                    /* inline: {
                                    label: 'Mode',
                                    select: function(args) {
                                    var items = [];
                                    items.push({id: "false", description: "side by side"});
                                    items.push({id: "true", description: "inline"});
                                    args.response.success({data: items});
                                    }
                                    },*/
                                    dedicated: {
                                        label: 'label.dedicated',
                                        isBoolean: true,
                                        isChecked: false
                                    },
                                    capacity: {
                                        label: 'label.capacity',
                                        validation: {
                                            required: false,
                                            number: true
                                        }
                                    }
                                }
                            },
                            action: function (args) {
                                if (nspMap[ "netscaler"] == null) {
                                    $.ajax({
                                        url: createURL("addNetworkServiceProvider&name=Netscaler&physicalnetworkid=" + selectedPhysicalNetworkObj.id),
                                        dataType: "json",
                                        async: true,
                                        success: function (json) {
                                            var jobId = json.addnetworkserviceproviderresponse.jobid;
                                            var addNetscalerProviderIntervalID = setInterval(function () {
                                                $.ajax({
                                                    url: createURL("queryAsyncJobResult&jobId=" + jobId),
                                                    dataType: "json",
                                                    success: function (json) {
                                                        var result = json.queryasyncjobresultresponse;
                                                        if (result.jobstatus == 0) {
                                                            return; //Job has not completed
                                                        } else {
                                                            clearInterval(addNetscalerProviderIntervalID);
                                                            if (result.jobstatus == 1) {
                                                                nspMap[ "netscaler"] = result.jobresult.networkserviceprovider;
                                                                addExternalLoadBalancer(args, selectedPhysicalNetworkObj, "addNetscalerLoadBalancer", "addnetscalerloadbalancerresponse", "netscalerloadbalancer");
                                                            } else if (result.jobstatus == 2) {
                                                                alert("addNetworkServiceProvider&name=Netscaler failed. Error: " + _s(result.jobresult.errortext));
                                                            }
                                                        }
                                                    },
                                                    error: function (XMLHttpResponse) {
                                                        var errorMsg = parseXMLHttpResponse(XMLHttpResponse);
                                                        alert("addNetworkServiceProvider&name=Netscaler failed. Error: " + errorMsg);
                                                    }
                                                });
                                            },
                                            g_queryAsyncJobResultInterval);
                                        }
                                    });
                                } else {
                                    addExternalLoadBalancer(args, selectedPhysicalNetworkObj, "addNetscalerLoadBalancer", "addnetscalerloadbalancerresponse", "netscalerloadbalancer");
                                }
                            },
                            messages: {
                                notification: function (args) {
                                    return 'label.add.netScaler.device';
                                }
                            },
                            notification: {
                                poll: pollAsyncJobResult
                            }
                        }
                    },
                    detailView: {
                        name: 'label.netscaler.details',
                        actions: {
                            'remove': {
                                label: 'label.delete.NetScaler',
                                messages: {
                                    confirm: function (args) {
                                        return 'message.confirm.delete.NetScaler';
                                    },
                                    notification: function (args) {
                                        return 'label.delete.NetScaler';
                                    }
                                },
                                action: function (args) {
                                    $.ajax({
                                        url: createURL("deleteNetscalerLoadBalancer&lbdeviceid=" + args.context.netscalerDevices[0].lbdeviceid),
                                        dataType: "json",
                                        async: true,
                                        success: function (json) {
                                            var jid = json.deletenetscalerloadbalancerresponse.jobid;
                                            args.response.success({
                                                _custom: {
                                                    jobId: jid
                                                }
                                            });
                                        },

                                        error: function (json) {
                                            args.response.error(parseXMLHttpResponse(json));
                                        }
                                    });
                                },
                                notification: {
                                    poll: pollAsyncJobResult
                                }
                            }
                        },
                        tabs: {
                            details: {
                                title: 'label.details',
                                fields:[ {
                                    lbdeviceid: {
                                        label: 'label.id'
                                    },
                                    ipaddress: {
                                        label: 'label.ip.address'
                                    },
                                    lbdevicestate: {
                                        label: 'label.status'
                                    },
                                    lbdevicename: {
                                        label: 'label.type'
                                    },
                                    lbdevicecapacity: {
                                        label: 'label.capacity'
                                    },
                                    lbdevicededicated: {
                                        label: 'label.dedicated',
                                        converter: cloudStack.converters.toBooleanText
                                    },
                                    gslbprovider: {
                                        label: 'label.gslb.service',
                                        converter: cloudStack.converters.toBooleanText
                                    },
                                    gslbproviderpublicip: {
                                        label: 'label.gslb.service.public.ip'
                                    },
                                    gslbproviderprivateip: {
                                        label: 'label.gslb.service.private.ip'
                                    }
                                }],
                                dataProvider: function (args) {
                                    $.ajax({
                                        url: createURL("listNetscalerLoadBalancers&lbdeviceid=" + args.context.netscalerDevices[0].lbdeviceid),
                                        dataType: "json",
                                        async: true,
                                        success: function (json) {
                                            var item = json.listnetscalerloadbalancerresponse.netscalerloadbalancer[0];
                                            args.response.success({
                                                data: item
                                            });
                                        }
                                    });
                                }
                            }
                        }
                    }
                }
            },

            // Baremetal DHCP devices listView
            BaremetalDhcpDevices: {
                id: 'BaremetalDhcpDevices',
                title: 'label.baremetal.dhcp.devices',
                listView: {
                    id: 'BaremetalDhcpDevices',
                    fields: {
                        url: {
                            label: 'label.url'
                        }
                    },
                    actions: {
                        add: {
                            label: 'label.add.baremetal.dhcp.device',
                            createForm: {
                                title: 'label.add.baremetal.dhcp.device',
                                fields: {
                                    url: {
                                        label: 'label.url',
                                        validation: {
                                            required: true
                                        }
                                    },
                                    username: {
                                        label: 'label.username',
                                        validation: {
                                            required: true
                                        }
                                    },
                                    password: {
                                        label: 'label.password',
                                        isPassword: true,
                                        validation: {
                                            required: true
                                        }
                                    }
                                }
                            },
                            action: function (args) {
                                addBaremetalDhcpDeviceFn(args);
                            },
                            messages: {
                                notification: function (args) {
                                    return 'label.add.baremetal.dhcp.device';
                                }
                            },
                            notification: {
                                poll: pollAsyncJobResult
                            }
                        }
                    },
                    dataProvider: function (args) {
                        $.ajax({
                            url: createURL('listBaremetalDhcp'),
                            data: {
                                physicalnetworkid: selectedPhysicalNetworkObj.id,
                                page: args.page,
                                pageSize: pageSize
                            },
                            dataType: "json",
                            async: false,
                            success: function (json) {
                                var items = json.listbaremetaldhcpresponse.baremetaldhcp;
                                args.response.success({
                                    data: items
                                });
                            }
                        });
                    }
                }
            },

            // Baremetal PXE devices listView
            BaremetalPxeDevices: {
                id: 'BaremetalPxeDevices',
                title: 'label.baremetal.pxe.devices',
                listView: {
                    id: 'BaremetalPxeDevices',
                    fields: {
                        url: {
                            label: 'label.url'
                        }
                    },
                    actions: {
                        add: {
                            label: 'label.baremetal.pxe.device',
                            createForm: {
                                title: 'label.baremetal.pxe.device',
                                fields: {
                                    url: {
                                        label: 'label.url',
                                        validation: {
                                            required: true
                                        }
                                    },
                                    username: {
                                        label: 'label.username',
                                        validation: {
                                            required: true
                                        }
                                    },
                                    password: {
                                        label: 'label.password',
                                        isPassword: true,
                                        validation: {
                                            required: true
                                        }
                                    },
                                    tftpdir: {
                                        label: 'label.tftp.root.directory',
                                        validation: {
                                            required: true
                                        }
                                    }
                                }
                            },
                            action: function (args) {
                                addBaremetalPxeDeviceFn(args);
                            },
                            messages: {
                                notification: function (args) {
                                    return 'label.baremetal.pxe.device';
                                }
                            },
                            notification: {
                                poll: pollAsyncJobResult
                            }
                        }
                    },
                    dataProvider: function (args) {
                        $.ajax({
                            url: createURL('listBaremetalPxeServers'),
                            data: {
                                physicalnetworkid: selectedPhysicalNetworkObj.id,
                                page: args.page,
                                pageSize: pageSize
                            },
                            dataType: "json",
                            async: false,
                            success: function (json) {
                                var items = json.listbaremetalpxeserversresponse.baremetalpxeserver;
                                args.response.success({
                                    data: items
                                });
                            }
                        });
                    }
                }
            },

            // F5 devices listView
            f5Devices: {
                id: 'f5Devices',
                title: 'label.devices',
                listView: {
                    id: 'f5Devices',
                    fields: {
                        ipaddress: {
                            label: 'label.ip.address'
                        },
                        lbdevicestate: {
                            converter: function (str) {
                                // For localization
                                return str;
                            },
                            label: 'label.status'
                        }
                    },
                    actions: {
                        add: {
                            label: 'label.add.F5.device',
                            createForm: {
                                title: 'label.add.F5.device',
                                preFilter: cloudStack.preFilter.addLoadBalancerDevice,
                                fields: {
                                    ip: {
                                        label: 'label.ip.address'
                                    },
                                    username: {
                                        label: 'label.username'
                                    },
                                    password: {
                                        label: 'label.password',
                                        isPassword: true
                                    },
                                    networkdevicetype: {
                                        label: 'label.type',
                                        select: function (args) {
                                            var items =[];
                                            items.push({
                                                id: "F5BigIpLoadBalancer",
                                                description: "F5 Big Ip Load Balancer"
                                            });
                                            args.response.success({
                                                data: items
                                            });
                                        }
                                    },
                                    publicinterface: {
                                        label: 'label.public.interface'
                                    },
                                    privateinterface: {
                                        label: 'label.private.interface'
                                    },
                                    numretries: {
                                        label: 'label.numretries',
                                        defaultValue: '2'
                                    },
                                    //Inline Mode has been moved from Add F5 Device to Create Network Offering (both backend and UI)
                                    /*
                                    inline: {
                                    label: 'Mode',
                                    select: function(args) {
                                    var items = [];
                                    items.push({id: "false", description: "side by side"});
                                    items.push({id: "true", description: "inline"});
                                    args.response.success({data: items});
                                    }
                                    },
                                     */
                                    dedicated: {
                                        label: 'label.dedicated',
                                        isBoolean: true,
                                        isChecked: false
                                    },
                                    capacity: {
                                        label: 'label.capacity',
                                        validation: {
                                            required: false,
                                            number: true
                                        }
                                    }
                                }
                            },
                            action: function (args) {
                                if (nspMap[ "f5"] == null) {
                                    $.ajax({
                                        url: createURL("addNetworkServiceProvider&name=F5BigIp&physicalnetworkid=" + selectedPhysicalNetworkObj.id),
                                        dataType: "json",
                                        async: true,
                                        success: function (json) {
                                            var jobId = json.addnetworkserviceproviderresponse.jobid;
                                            var addF5ProviderIntervalID = setInterval(function () {
                                                $.ajax({
                                                    url: createURL("queryAsyncJobResult&jobId=" + jobId),
                                                    dataType: "json",
                                                    success: function (json) {
                                                        var result = json.queryasyncjobresultresponse;
                                                        if (result.jobstatus == 0) {
                                                            return; //Job has not completed
                                                        } else {
                                                            clearInterval(addF5ProviderIntervalID);
                                                            if (result.jobstatus == 1) {
                                                                nspMap[ "f5"] = json.queryasyncjobresultresponse.jobresult.networkserviceprovider;
                                                                addExternalLoadBalancer(args, selectedPhysicalNetworkObj, "addF5LoadBalancer", "addf5bigiploadbalancerresponse", "f5loadbalancer");
                                                            } else if (result.jobstatus == 2) {
                                                                alert("addNetworkServiceProvider&name=F5BigIp failed. Error: " + _s(result.jobresult.errortext));
                                                            }
                                                        }
                                                    },
                                                    error: function (XMLHttpResponse) {
                                                        var errorMsg = parseXMLHttpResponse(XMLHttpResponse);
                                                        alert("addNetworkServiceProvider&name=F5BigIpfailed. Error: " + errorMsg);
                                                    }
                                                });
                                            },
                                            g_queryAsyncJobResultInterval);
                                        }
                                    });
                                } else {
                                    addExternalLoadBalancer(args, selectedPhysicalNetworkObj, "addF5LoadBalancer", "addf5bigiploadbalancerresponse", "f5loadbalancer");
                                }
                            },
                            messages: {
                                notification: function (args) {
                                    return 'label.addes.new.f5';
                                }
                            },
                            notification: {
                                poll: pollAsyncJobResult
                            }
                        }
                    },
                    dataProvider: function (args) {
                        $.ajax({
                            url: createURL("listF5LoadBalancers&physicalnetworkid=" + selectedPhysicalNetworkObj.id),
                            data: {
                                page: args.page,
                                pageSize: pageSize
                            },
                            dataType: "json",
                            async: false,
                            success: function (json) {
                                var items = json.listf5loadbalancerresponse.f5loadbalancer;
                                args.response.success({
                                    data: items
                                });
                            }
                        });
                    },
                    detailView: {
                        name: 'label.f5.details',
                        actions: {
                            'remove': {
                                label: 'label.delete.F5',
                                messages: {
                                    confirm: function (args) {
                                        return 'message.confirm.delete.F5';
                                    },
                                    notification: function (args) {
                                        return 'label.delete.F5';
                                    }
                                },
                                action: function (args) {
                                    $.ajax({
                                        url: createURL("deleteF5LoadBalancer&lbdeviceid=" + args.context.f5Devices[0].lbdeviceid),
                                        dataType: "json",
                                        async: true,
                                        success: function (json) {
                                            var jid = json.deletef5loadbalancerresponse.jobid;
                                            args.response.success({
                                                _custom: {
                                                    jobId: jid
                                                }
                                            });
                                        }
                                    });
                                },
                                notification: {
                                    poll: pollAsyncJobResult
                                }
                            }
                        },
                        tabs: {
                            details: {
                                title: 'label.details',
                                fields:[ {
                                    lbdeviceid: {
                                        label: 'label.id'
                                    },
                                    ipaddress: {
                                        label: 'label.ip.address'
                                    },
                                    lbdevicestate: {
                                        label: 'label.status'
                                    },
                                    lbdevicename: {
                                        label: 'label.type'
                                    },
                                    lbdevicecapacity: {
                                        label: 'label.capacity'
                                    },
                                    lbdevicededicated: {
                                        label: 'label.dedicated',
                                        converter: cloudStack.converters.toBooleanText
                                    }
                                }],
                                dataProvider: function (args) {
                                    $.ajax({
                                        url: createURL("listF5LoadBalancers&lbdeviceid=" + args.context.f5Devices[0].lbdeviceid),
                                        dataType: "json",
                                        async: true,
                                        success: function (json) {
                                            var item = json.listf5loadbalancerresponse.f5loadbalancer[0];
                                            args.response.success({
                                                data: item
                                            });
                                        }
                                    });
                                }
                            }
                        }
                    }
                }
            },

            //SRX devices listView
            srxDevices: {
                id: 'srxDevices',
                title: 'label.devices',
                listView: {
                    id: 'srxDevices',
                    fields: {
                        ipaddress: {
                            label: 'label.ip.address'
                        },
                        fwdevicestate: {
                            label: 'label.status'
                        },
                        fwdevicename: {
                            label: 'label.type'
                        }
                    },
                    actions: {
                        add: {
                            label: 'label.add.SRX.device',
                            createForm: {
                                title: 'label.add.SRX.device',
                                fields: {
                                    ip: {
                                        label: 'label.ip.address'
                                    },
                                    username: {
                                        label: 'label.username'
                                    },
                                    password: {
                                        label: 'label.password',
                                        isPassword: true
                                    },
                                    networkdevicetype: {
                                        label: 'label.type',
                                        select: function (args) {
                                            var items =[];
                                            items.push({
                                                id: "JuniperSRXFirewall",
                                                description: "Juniper SRX Firewall"
                                            });
                                            args.response.success({
                                                data: items
                                            });
                                        }
                                    },
                                    publicinterface: {
                                        label: 'label.public.interface'
                                    },
                                    privateinterface: {
                                        label: 'label.private.interface'
                                    },
                                    usageinterface: {
                                        label: 'label.usage.interface'
                                    },
                                    numretries: {
                                        label: 'label.numretries',
                                        defaultValue: '2'
                                    },
                                    timeout: {
                                        label: 'label.timeout',
                                        defaultValue: '300'
                                    },
                                    // inline: {
                                    //   label: 'Mode',
                                    //   select: function(args) {
                                    //     var items = [];
                                    //     items.push({id: "false", description: "side by side"});
                                    //     items.push({id: "true", description: "inline"});
                                    //     args.response.success({data: items});
                                    //   }
                                    // },
                                    publicnetwork: {
                                        label: 'label.public.network',
                                        defaultValue: 'untrusted',
                                        isDisabled: true
                                    },
                                    privatenetwork: {
                                        label: 'label.private.network',
                                        defaultValue: 'trusted',
                                        isDisabled: true
                                    },
                                    capacity: {
                                        label: 'label.capacity',
                                        validation: {
                                            required: false,
                                            number: true
                                        }
                                    },
                                    dedicated: {
                                        label: 'label.dedicated',
                                        isBoolean: true,
                                        isChecked: false
                                    }
                                }
                            },
                            action: function (args) {
                                if (nspMap[ "srx"] == null) {
                                    $.ajax({
                                        url: createURL("addNetworkServiceProvider&name=JuniperSRX&physicalnetworkid=" + selectedPhysicalNetworkObj.id),
                                        dataType: "json",
                                        async: true,
                                        success: function (json) {
                                            var jobId = json.addnetworkserviceproviderresponse.jobid;
                                            var addJuniperSRXProviderIntervalID = setInterval(function () {
                                                $.ajax({
                                                    url: createURL("queryAsyncJobResult&jobId=" + jobId),
                                                    dataType: "json",
                                                    success: function (json) {
                                                        var result = json.queryasyncjobresultresponse;
                                                        if (result.jobstatus == 0) {
                                                            return; //Job has not completed
                                                        } else {
                                                            clearInterval(addJuniperSRXProviderIntervalID);
                                                            if (result.jobstatus == 1) {
                                                                nspMap[ "srx"] = json.queryasyncjobresultresponse.jobresult.networkserviceprovider;
                                                                addExternalFirewall(args, selectedPhysicalNetworkObj, "addSrxFirewall", "addsrxfirewallresponse", "srxfirewall");
                                                            } else if (result.jobstatus == 2) {
                                                                alert("addNetworkServiceProvider&name=JuniperSRX failed. Error: " + _s(result.jobresult.errortext));
                                                            }
                                                        }
                                                    },
                                                    error: function (XMLHttpResponse) {
                                                        var errorMsg = parseXMLHttpResponse(XMLHttpResponse);
                                                        alert("addNetworkServiceProvider&name=JuniperSRX failed. Error: " + errorMsg);
                                                    }
                                                });
                                            },
                                            g_queryAsyncJobResultInterval);
                                        }
                                    });
                                } else {
                                    addExternalFirewall(args, selectedPhysicalNetworkObj, "addSrxFirewall", "addsrxfirewallresponse", "srxfirewall");
                                }
                            },
                            messages: {
                                notification: function (args) {
                                    return 'label.add.SRX.device';
                                }
                            },
                            notification: {
                                poll: pollAsyncJobResult
                            }
                        }
                    },
                    dataProvider: function (args) {
                        $.ajax({
                            url: createURL("listSrxFirewalls&physicalnetworkid=" + selectedPhysicalNetworkObj.id),
                            data: {
                                page: args.page,
                                pageSize: pageSize
                            },
                            dataType: "json",
                            async: false,
                            success: function (json) {
                                var items = json.listsrxfirewallresponse.srxfirewall;
                                args.response.success({
                                    data: items
                                });
                            }
                        });
                    },
                    detailView: {
                        name: 'label.srx.details',
                        actions: {
                            'remove': {
                                label: 'label.delete.SRX',
                                messages: {
                                    confirm: function (args) {
                                        return 'message.confirm.delete.SRX';
                                    },
                                    notification: function (args) {
                                        return 'label.delete.SRX';
                                    }
                                },
                                action: function (args) {
                                    $.ajax({
                                        url: createURL("deleteSrxFirewall&fwdeviceid=" + args.context.srxDevices[0].fwdeviceid),
                                        dataType: "json",
                                        async: true,
                                        success: function (json) {
                                            var jid = json.deletesrxfirewallresponse.jobid;
                                            args.response.success({
                                                _custom: {
                                                    jobId: jid
                                                }
                                            });
                                        }
                                    });
                                },
                                notification: {
                                    poll: pollAsyncJobResult
                                }
                            }
                        },
                        tabs: {
                            details: {
                                title: 'label.details',
                                fields:[ {
                                    fwdeviceid: {
                                        label: 'label.id'
                                    },
                                    ipaddress: {
                                        label: 'label.ip.address'
                                    },
                                    fwdevicestate: {
                                        label: 'label.status'
                                    },
                                    fwdevicename: {
                                        label: 'label.type'
                                    },
                                    fwdevicecapacity: {
                                        label: 'label.capacity'
                                    },
                                    timeout: {
                                        label: 'label.timeout'
                                    }
                                }],
                                dataProvider: function (args) {
                                    $.ajax({
                                        url: createURL("listSrxFirewalls&fwdeviceid=" + args.context.srxDevices[0].fwdeviceid),
                                        dataType: "json",
                                        async: true,
                                        success: function (json) {
                                            var item = json.listsrxfirewallresponse.srxfirewall[0];
                                            args.response.success({
                                                data: item
                                            });
                                        }
                                    });
                                }
                            }
                        }
                    }
                }
            },

            //Palo Alto devices listView
            paDevices: {
                id: 'paDevices',
                title: 'label.devices',
                listView: {
                    id: 'paDevices',
                    fields: {
                        ipaddress: {
                            label: 'label.ip.address'
                        },
                        fwdevicestate: {
                            label: 'label.status'
                        },
                        fwdevicename: {
                            label: 'label.type'
                        }
                    },
                    actions: {
                        add: {
                            label: 'label.add.PA.device',
                            createForm: {
                                title: 'label.add.PA.device',
                                fields: {
                                    ip: {
                                        label: 'label.ip.address'
                                    },
                                    username: {
                                        label: 'label.username'
                                    },
                                    password: {
                                        label: 'label.password',
                                        isPassword: true
                                    },
                                    networkdevicetype: {
                                        label: 'label.type',
                                        select: function (args) {
                                            var items =[];
                                            items.push({
                                                id: "PaloAltoFirewall",
                                                description: "Palo Alto Firewall"
                                            });
                                            args.response.success({
                                                data: items
                                            });
                                        }
                                    },
                                    publicinterface: {
                                        label: 'label.public.interface'
                                    },
                                    privateinterface: {
                                        label: 'label.private.interface'
                                    },
                                    //usageinterface: {
                                    //  label: 'label.usage.interface'
                                    //},
                                    numretries: {
                                        label: 'label.numretries',
                                        defaultValue: '2'
                                    },
                                    timeout: {
                                        label: 'label.timeout',
                                        defaultValue: '300'
                                    },
                                    // inline: {
                                    //   label: 'Mode',
                                    //   select: function(args) {
                                    //     var items = [];
                                    //     items.push({id: "false", description: "side by side"});
                                    //     items.push({id: "true", description: "inline"});
                                    //     args.response.success({data: items});
                                    //   }
                                    // },
                                    publicnetwork: {
                                        label: 'label.public.network',
                                        defaultValue: 'untrust'
                                    },
                                    privatenetwork: {
                                        label: 'label.private.network',
                                        defaultValue: 'trust'
                                    },
                                    pavr: {
                                        label: 'label.virtual.router'
                                    },
                                    patp: {
                                        label: 'label.PA.threat.profile'
                                    },
                                    palp: {
                                        label: 'label.PA.log.profile'
                                    },
                                    capacity: {
                                        label: 'label.capacity',
                                        validation: {
                                            required: false,
                                            number: true
                                        }
                                    },
                                    dedicated: {
                                        label: 'label.dedicated',
                                        isBoolean: true,
                                        isChecked: false
                                    }
                                }
                            },
                            action: function (args) {
                                if (nspMap[ "pa"] == null) {
                                    $.ajax({
                                        url: createURL("addNetworkServiceProvider&name=PaloAlto&physicalnetworkid=" + selectedPhysicalNetworkObj.id),
                                        dataType: "json",
                                        async: true,
                                        success: function (json) {
                                            var jobId = json.addnetworkserviceproviderresponse.jobid;
                                            var addPaloAltoProviderIntervalID = setInterval(function () {
                                                $.ajax({
                                                    url: createURL("queryAsyncJobResult&jobId=" + jobId),
                                                    dataType: "json",
                                                    success: function (json) {
                                                        var result = json.queryasyncjobresultresponse;
                                                        if (result.jobstatus == 0) {
                                                            return; //Job has not completed
                                                        } else {
                                                            clearInterval(addPaloAltoProviderIntervalID);
                                                            if (result.jobstatus == 1) {
                                                                nspMap[ "pa"] = json.queryasyncjobresultresponse.jobresult.networkserviceprovider;
                                                                addExternalFirewall(args, selectedPhysicalNetworkObj, "addPaloAltoFirewall", "addpaloaltofirewallresponse", "pafirewall");
                                                            } else if (result.jobstatus == 2) {
                                                                alert("addNetworkServiceProvider&name=Palo Alto failed. Error: " + _s(result.jobresult.errortext));
                                                            }
                                                        }
                                                    },
                                                    error: function (XMLHttpResponse) {
                                                        var errorMsg = parseXMLHttpResponse(XMLHttpResponse);
                                                        alert("addNetworkServiceProvider&name=Palo Alto failed. Error: " + errorMsg);
                                                    }
                                                });
                                            },
                                            3000);
                                        }
                                    });
                                } else {
                                    addExternalFirewall(args, selectedPhysicalNetworkObj, "addPaloAltoFirewall", "addpaloaltofirewallresponse", "pafirewall");
                                }
                            },
                            messages: {
                                notification: function (args) {
                                    return 'label.add.PA.device';
                                }
                            },
                            notification: {
                                poll: pollAsyncJobResult
                            }
                        }
                    },
                    dataProvider: function (args) {
                        $.ajax({
                            url: createURL("listPaloAltoFirewalls&physicalnetworkid=" + selectedPhysicalNetworkObj.id),
                            data: {
                                page: args.page,
                                pageSize: pageSize
                            },
                            dataType: "json",
                            async: false,
                            success: function (json) {
                                var items = json.listpaloaltofirewallresponse.paloaltofirewall;
                                args.response.success({
                                    data: items
                                });
                            }
                        });
                    },
                    detailView: {
                        name: 'label.palo.alto.details',
                        actions: {
                            'remove': {
                                label: 'label.delete.PA',
                                messages: {
                                    confirm: function (args) {
                                        return 'message.confirm.delete.PA';
                                    },
                                    notification: function (args) {
                                        return 'label.delete.PA';
                                    }
                                },
                                action: function (args) {
                                    $.ajax({
                                        url: createURL("deletePaloAltoFirewall&fwdeviceid=" + args.context.paDevices[0].fwdeviceid),
                                        dataType: "json",
                                        async: true,
                                        success: function (json) {
                                            var jid = json.deletepaloaltofirewallresponse.jobid;
                                            args.response.success({
                                                _custom: {
                                                    jobId: jid
                                                }
                                            });
                                        }
                                    });
                                },
                                notification: {
                                    poll: pollAsyncJobResult
                                }
                            }
                        },
                        tabs: {
                            details: {
                                title: 'label.details',
                                fields:[ {
                                    fwdeviceid: {
                                        label: 'label.id'
                                    },
                                    ipaddress: {
                                        label: 'label.ip.address'
                                    },
                                    fwdevicestate: {
                                        label: 'label.status'
                                    },
                                    fwdevicename: {
                                        label: 'label.type'
                                    },
                                    fwdevicecapacity: {
                                        label: 'label.capacity'
                                    },
                                    timeout: {
                                        label: 'label.timeout'
                                    }
                                }],
                                dataProvider: function (args) {
                                    $.ajax({
                                        url: createURL("listPaloAltoFirewalls&fwdeviceid=" + args.context.paDevices[0].fwdeviceid),
                                        dataType: "json",
                                        async: true,
                                        success: function (json) {
                                            var item = json.listpaloaltofirewallresponse.paloaltofirewall[0];
                                            args.response.success({
                                                data: item
                                            });
                                        }
                                    });
                                }
                            }
                        }
                    }
                }
            },

            // FIXME convert to nicira detailview
            // NiciraNvp devices listView
            niciraNvpDevices: {
                id: 'niciraNvpDevices',
                title: 'label.devices',
                listView: {
                    id: 'niciraNvpDevices',
                    fields: {
                        hostname: {
                            label: 'label.nicira.controller.address'
                        },
                        transportzoneuuid: {
                            label: 'label.nicira.transportzoneuuid'
                        },
                        l3gatewayserviceuuid: {
                            label: 'label.nicira.l3gatewayserviceuuid'
                        },
						l2gatewayserviceuuid: {
                            label: 'label.nicira.l2gatewayserviceuuid'
                        }
                    },
                    actions: {
                        add: {
                            label: 'label.add.NiciraNvp.device',
                            createForm: {
                                title: 'label.add.NiciraNvp.device',
                                preFilter: function (args) {
                                },
                                // TODO What is this?
                                fields: {
                                    host: {
                                        label: 'label.ip.address'
                                    },
                                    username: {
                                        label: 'label.username'
                                    },
                                    password: {
                                        label: 'label.password',
                                        isPassword: true
                                    },
                                    numretries: {
                                        label: 'label.numretries',
                                        defaultValue: '2'
                                    },
                                    transportzoneuuid: {
                                        label: 'label.nicira.transportzoneuuid'
                                    },
                                    l3gatewayserviceuuid: {
                                        label: 'label.nicira.l3gatewayserviceuuid'
                                    },
									l2gatewayserviceuuid: {
										label: 'label.nicira.l2gatewayserviceuuid'
									}
                                }
                            },
                            action: function (args) {
                                if (nspMap[ "niciraNvp"] == null) {
                                    $.ajax({
                                        url: createURL("addNetworkServiceProvider&name=NiciraNvp&physicalnetworkid=" + selectedPhysicalNetworkObj.id),
                                        dataType: "json",
                                        async: true,
                                        success: function (json) {
                                            var jobId = json.addnetworkserviceproviderresponse.jobid;
                                            var addNiciraNvpProviderIntervalID = setInterval(function () {
                                                $.ajax({
                                                    url: createURL("queryAsyncJobResult&jobId=" + jobId),
                                                    dataType: "json",
                                                    success: function (json) {
                                                        var result = json.queryasyncjobresultresponse;
                                                        if (result.jobstatus == 0) {
                                                            return; // Job has not completed
                                                        } else {
                                                            clearInterval(addNiciraNvpProviderIntervalID);
                                                            if (result.jobstatus == 1) {
                                                                nspMap[ "niciraNvp"] = json.queryasyncjobresultresponse.jobresult.networkserviceprovider;
                                                                addNiciraNvpDevice(args, selectedPhysicalNetworkObj, "addNiciraNvpDevice", "addniciranvpdeviceresponse", "niciranvpdevice")
                                                            } else if (result.jobstatus == 2) {
                                                                alert("addNetworkServiceProvider&name=NiciraNvp failed. Error: " + _s(result.jobresult.errortext));
                                                            }
                                                        }
                                                    },
                                                    error: function (XMLHttpResponse) {
                                                        var errorMsg = parseXMLHttpResponse(XMLHttpResponse);
                                                        alert("addNetworkServiceProvider&name=NiciraNvp failed. Error: " + errorMsg);
                                                    }
                                                });
                                            },
                                            g_queryAsyncJobResultInterval);
                                        }
                                    });
                                } else {
                                    addNiciraNvpDevice(args, selectedPhysicalNetworkObj, "addNiciraNvpDevice", "addniciranvpdeviceresponse", "niciranvpdevice")
                                }
                            },

                            messages: {
                                notification: function (args) {
                                    return 'label.added.nicira.nvp.controller';
                                }
                            },
                            notification: {
                                poll: pollAsyncJobResult
                            }
                        }
                    },
                    dataProvider: function (args) {
                        $.ajax({
                            url: createURL("listNiciraNvpDevices&physicalnetworkid=" + selectedPhysicalNetworkObj.id),
                            data: {
                                page: args.page,
                                pageSize: pageSize
                            },
                            dataType: "json",
                            async: false,
                            success: function (json) {
                                var items = json.listniciranvpdeviceresponse.niciranvpdevice;
                                args.response.success({
                                    data: items
                                });
                            }
                        });
                    },
                    detailView: {
                        name: 'label.nicira.nvp.details',
                        actions: {
                            'remove': {
                                label: 'label.delete.NiciaNvp',
                                messages: {
                                    confirm: function (args) {
                                        return 'message.confirm.delete.NiciraNvp';
                                    },
                                    notification: function (args) {
                                        return 'label.delete.NiciraNvp';
                                    }
                                },
                                action: function (args) {
                                    $.ajax({
                                        url: createURL("deleteNiciraNvpDevice&nvpdeviceid=" + args.context.niciraNvpDevices[0].nvpdeviceid),
                                        dataType: "json",
                                        async: true,
                                        success: function (json) {
                                            var jid = json.deleteniciranvpdeviceresponse.jobid;
                                            args.response.success({
                                                _custom: {
                                                    jobId: jid
                                                }
                                            });
                                        }
                                    });
                                },
                                notification: {
                                    poll: pollAsyncJobResult
                                }
                            }
                        },
                        tabs: {
                            details: {
                                title: 'label.details',
                                fields:[ {
                                    nvpdeviceid: {
                                        label: 'label.id'
                                    },
                                    hostname: {
                                        label: 'label.ip.address'
                                    },
                                    transportzoneuuid: {
                                        label: 'label.nicira.transportzoneuuid'
                                    },
                                    l3gatewayserviceuuid: {
                                        label: 'label.nicira.l3gatewayserviceuuid'
                                    },
									l2gatewayserviceuuid: {
										label: 'label.nicira.l2gatewayserviceuuid'
									}
                                }],
                                dataProvider: function (args) {
                                    $.ajax({
                                        url: createURL("listNiciraNvpDevices&nvpdeviceid=" + args.context.niciraNvpDevices[0].nvpdeviceid),
                                        dataType: "json",
                                        async: true,
                                        success: function (json) {
                                            var item = json.listniciranvpdeviceresponse.niciranvpdevice[0];
                                            args.response.success({
                                                data: item
                                            });
                                        }
                                    });
                                }
                            }
                        }
                    }
                }
            },
            // BrocadeVcs devices listView
            brocadeVcsDevices: {
                id: 'brocadeVcsDevices',
                title: 'label.devices',
                listView: {
                    id: 'brocadeVcsDevices',
                    fields: {
                        hostname: {
                            label: 'label.brocade.vcs.address'
                        }
                    },
                    actions: {
                        add: {
                            label: 'label.add.BrocadeVcs.device',
                            createForm: {
                                title: 'label.add.BrocadeVcs.device',
                                preFilter: function (args) {
                                },
                                // TODO What is this?
                                fields: {
                                    host: {
                                        label: 'label.ip.address'
                                    },
                                    username: {
                                        label: 'label.username'
                                    },
                                    password: {
                                        label: 'label.password',
                                        isPassword: true
                                    }
                                }
                            },
                            action: function (args) {
                                if (nspMap[ "brocadeVcs"] == null) {
                                    $.ajax({
                                        url: createURL("addNetworkServiceProvider&name=BrocadeVcs&physicalnetworkid=" + selectedPhysicalNetworkObj.id),
                                        dataType: "json",
                                        async: true,
                                        success: function (json) {
                                            var jobId = json.addnetworkserviceproviderresponse.jobid;
                                            var addBrocadeVcsProviderIntervalID = setInterval(function () {
                                                $.ajax({
                                                    url: createURL("queryAsyncJobResult&jobId=" + jobId),
                                                    dataType: "json",
                                                    success: function (json) {
                                                        var result = json.queryasyncjobresultresponse;
                                                        if (result.jobstatus == 0) {
                                                            return; // Job has not completed
                                                        } else {
                                                            clearInterval(addBrocadeVcsProviderIntervalID);
                                                            if (result.jobstatus == 1) {
                                                                nspMap[ "brocadeVcs"] = json.queryasyncjobresultresponse.jobresult.networkserviceprovider;
                                                                addBrocadeVcsDevice(args, selectedPhysicalNetworkObj, "addBrocadeVcsDevice", "addbrocadevcsdeviceresponse", "brocadevcsdevice")
                                                            } else if (result.jobstatus == 2) {
                                                                alert("addNetworkServiceProvider&name=BrocadeVcs failed. Error: " + _s(result.jobresult.errortext));
                                                            }
                                                        }
                                                    },
                                                    error: function (XMLHttpResponse) {
                                                        var errorMsg = parseXMLHttpResponse(XMLHttpResponse);
                                                        alert("addNetworkServiceProvider&name=BrocadeVcs failed. Error: " + errorMsg);
                                                    }
                                                });
                                            },
                                            g_queryAsyncJobResultInterval);
                                        }
                                    });
                                } else {
                                    addBrocadeVcsDevice(args, selectedPhysicalNetworkObj, "addBrocadeVcsDevice", "addbrocadevcsdeviceresponse", "brocadevcsdevice")
                                }
                            },
                            messages: {
                                notification: function (args) {
                                    return 'label.added.brocade.vcs.switch';
                                }
                            },
                            notification: {
                                poll: pollAsyncJobResult
                            }
                        }
                    },
                    dataProvider: function (args) {
                        $.ajax({
                            url: createURL("listBrocadeVcsDevices&physicalnetworkid=" + selectedPhysicalNetworkObj.id),
                            data: {
                                page: args.page,
                                pageSize: pageSize
                            },
                            dataType: "json",
                            async: false,
                            success: function (json) {
                                var items = json.listbrocadevcsdeviceresponse.brocadevcsdevice;
                                args.response.success({
                                    data: items
                                });
                            }
                        });
                    },
                    detailView: {
                        name: 'label.brocade.vcs.details',
                        actions: {
                            'remove': {
                                label: 'label.delete.BrocadeVcs',
                                messages: {
                                    confirm: function (args) {
                                        return 'message.confirm.delete.BrocadeVcs';
                                    },
                                    notification: function (args) {
                                        return 'label.delete.BrocadeVcs';
                                    }
                                },
                                action: function (args) {
                                    $.ajax({
                                        url: createURL("deleteBrocadeVcsDevice&vcsdeviceid=" + args.context.brocadeVcsDevices[0].vcsdeviceid),
                                        dataType: "json",
                                        async: true,
                                        success: function (json) {
                                            var jid = json.deletebrocadevcsdeviceresponse.jobid;
                                            args.response.success({
                                                _custom: {
                                                    jobId: jid
                                                }
                                            });
                                        }
                                    });
                                },
                                notification: {
                                    poll: pollAsyncJobResult
                                }
                            }
                        },
                        tabs: {
                            details: {
                                title: 'label.details',
                                fields:[ {
                                    vcsdeviceid: {
                                        label: 'label.id'
                                    },
                                    hostname: {
                                        label: 'label.ip.address'
                                    }
                                }],
                                dataProvider: function (args) {
                                    $.ajax({
                                        url: createURL("listBrocadeVcsDevices&vcsdeviceid=" + args.context.brocadeVcsDevices[0].vcsdeviceid),
                                        dataType: "json",
                                        async: true,
                                        success: function (json) {
                                            var item = json.listbrocadevcsdeviceresponse.brocadevcsdevice[0];
                                            args.response.success({
                                                data: item
                                            });
                                        }
                                    });
                                }
                            }
                        }
                    }
                }
            },
            bigswitchBcfDevices: {
                id: 'bigswitchBcfDevices',
                title: 'label.devices',
                listView: {
                    id: 'bigswitchBcfDevices',
                    fields: {
                        hostname: {
                            label: 'label.bigswitch.controller.address'
                        }
                    },
                    actions: {
                        add: {
                            label: 'label.add.BigSwitchBcf.device',
                            createForm: {
                                title: 'label.add.BigSwitchBcf.device',
                                preFilter: function (args) {
                                },
                                fields: {
                                    host: {
                                        label: 'label.ip.address',
                                        validation: {
                                                     required: true
                                                 }
                                    },
                                    username: {
                                        label: 'label.username',
                                        validation: {
                                                     required: true
                                                 }
                                    },
                                    password: {
                                        label: 'label.password',
                                        isPassword: true,
                                        validation: {
                                                     required: true
                                                 }
                                    },
                                    nat: {
                                                label: 'label.bigswitch.bcf.nat',
                                                isBoolean: true,
                                                isChecked: false
                                    },
                                    numretries: {
                                        label: 'label.numretries',
                                        defaultValue: '2'
                                    }
                                }
                            },
                            action: function (args) {
                                if (nspMap[ "bigswitchBcf"] == null) {
                                    $.ajax({
                                        url: createURL("addNetworkServiceProvider&name=BigSwitchBcf&physicalnetworkid=" + selectedPhysicalNetworkObj.id),
                                        dataType: "json",
                                        async: true,
                                        success: function (json) {
                                            var jobId = json.addnetworkserviceproviderresponse.jobid;
                                            var addBigSwitchBcfProviderIntervalID = setInterval(function () {
                                                $.ajax({
                                                    url: createURL("queryAsyncJobResult&jobId=" + jobId),
                                                    dataType: "json",
                                                    success: function (json) {
                                                        var result = json.queryasyncjobresultresponse;
                                                        if (result.jobstatus == 0) {
                                                            return;
                                                        } else {
                                                            clearInterval(addBigSwitchBcfProviderIntervalID);
                                                            if (result.jobstatus == 1) {
                                                                nspMap[ "bigswitchBcf"] = json.queryasyncjobresultresponse.jobresult.networkserviceprovider;
                                                                addBigSwitchBcfDevice(args, selectedPhysicalNetworkObj, "addBigSwitchBcfDevice", "addbigswitchbcfdeviceresponse", "bigswitchbcfdevice")
                                                            } else if (result.jobstatus == 2) {
                                                                alert("addNetworkServiceProvider&name=BigSwitchBcf failed. Error: " + _s(result.jobresult.errortext));
                                                            }
                                                        }
                                                    },
                                                    error: function (XMLHttpResponse) {
                                                        var errorMsg = parseXMLHttpResponse(XMLHttpResponse);
                                                        alert("addNetworkServiceProvider&name=BigSwitchBcf failed. Error: " + errorMsg);
                                                    }
                                                });
                                            },
                                            3000);
                                        }
                                    });
                                } else {
                                    addBigSwitchBcfDevice(args, selectedPhysicalNetworkObj, "addBigSwitchBcfDevice", "addbigswitchbcfdeviceresponse", "bigswitchbcfdevice")
                                }
                            },

                            messages: {
                                notification: function (args) {
                                    return 'label.added.new.bigswitch.bcf.controller';
                                }
                            },
                            notification: {
                                poll: pollAsyncJobResult
                            }
                        }
                    },
                    dataProvider: function (args) {
                        $.ajax({
                            url: createURL("listBigSwitchBcfDevices&physicalnetworkid=" + selectedPhysicalNetworkObj.id),
                            data: {
                                page: args.page,
                                pageSize: pageSize
                            },
                            dataType: "json",
                            async: false,
                            success: function (json) {
                                var items = json.listbigswitchbcfdeviceresponse.bigswitchbcfdevice;
                                args.response.success({
                                    data: items
                                });
                            }
                        });
                    },
                    detailView: {
                        name: 'label.bigswitch.bcf.details',
                        actions: {
                            'remove': {
                                label: 'label.delete.BigSwitchBcf',
                                messages: {
                                    confirm: function (args) {
                                        return 'message.confirm.delete.BigSwitchBcf';
                                    },
                                    notification: function (args) {
                                        return 'label.delete.BigSwitchBcf';
                                    }
                                },
                                action: function (args) {
                                    $.ajax({
                                        url: createURL("deleteBigSwitchBcfDevice&bcfdeviceid=" + args.context.bigswitchBcfDevices[0].bcfdeviceid),
                                        dataType: "json",
                                        async: true,
                                        success: function (json) {
                                            var jid = json.deletebigswitchbcfdeviceresponse.jobid;
                                            args.response.success({
                                                _custom: {
                                                    jobId: jid
                                                }
                                            });
                                        }
                                    });
                                },
                                notification: {
                                    poll: pollAsyncJobResult
                                }
                            }
                        },
                        tabs: {
                            details: {
                                title: 'label.details',
                                fields:[ {
                                    bcfdeviceid: {
                                        label: 'label.id'
                                    },
                                    hostname: {
                                        label: 'label.host.name'
                                    }
                                }],
                                dataProvider: function (args) {
                                    $.ajax({
                                        url: createURL("listBigSwitchBcfDevices&bcfdeviceid=" + args.context.bigswitchBcfDevices[0].bcfdeviceid),
                                        dataType: "json",
                                        async: true,
                                        success: function (json) {
                                            var item = json.listbigswitchbcfdeviceresponse.bigswitchbcfdevice[0];
                                            args.response.success({
                                                data: item
                                            });
                                        }
                                    });
                                }
                            }
                        }
                    }
                }
            },
            pods: {
                title: 'label.pods',
                listView: {
                    id: 'pods',
                    section: 'pods',
                    multiSelect: true,
                    fields: {
                        name: {
                            label: 'label.name'
                        },
                        gateway: {
                            label: 'label.gateway'
                        },
                        netmask: {
                            label: 'label.netmask'
                        },
                        zonename: {
                            label: 'label.zone'
                        },
                        allocationstate: {
                            converter: function (str) {
                                // For localization
                                return str;
                            },
                            label: 'label.allocation.state',
                            indicator: {
                                'Enabled': 'on',
                                'Disabled': 'off'
                            }
                        }
                    },

                    dataProvider: function (args) {
                        var array1 =[];
                        if (args.filterBy != null) {
                            if (args.filterBy.search != null && args.filterBy.search.by != null && args.filterBy.search.value != null) {
                                switch (args.filterBy.search.by) {
                                    case "name":
                                    if (args.filterBy.search.value.length > 0)
                                    array1.push("&keyword=" + args.filterBy.search.value);
                                    break;
                                }
                            }
                        }

                        $.ajax({
                            url: createURL("listPods&zoneid=" + args.context.zones[0].id + "&page=" + args.page + "&pagesize=" + pageSize + array1.join("")),
                            dataType: "json",
                            async: true,
                            success: function (json) {
                                var items = json.listpodsresponse.pod;
                                args.response.success({
                                    actionFilter: podActionfilter,
                                    data: items
                                });
                            }
                        });
                    },

                    actions: {
                        add: {
                            label: 'label.add.pod',

                            createForm: {
                                title: 'label.add.pod',
                                fields: {
                                    zoneid: {
                                        label: 'label.zone',
                                        docID: 'helpPodZone',
                                        validation: {
                                            required: true
                                        },
                                        select: function (args) {
                                            var data = args.context.zones ? {
                                                id: args.context.zones[0].id
                                            }: {};

                                            $.ajax({
                                                url: createURL('listZones'),
                                                data: data,
                                                success: function (json) {
                                                    var zones = json.listzonesresponse.zone ? json.listzonesresponse.zone:[];

                                                    args.response.success({
                                                        data: $.map(zones, function (zone) {
                                                            return {
                                                                id: zone.id,
                                                                description: zone.name
                                                            };
                                                        })
                                                    });
                                                }
                                            });
                                        }
                                    },
                                    podname: {
                                        label: 'label.pod.name',
                                        docID: 'helpPodName',
                                        validation: {
                                            required: true
                                        }
                                    },
                                    reservedSystemGateway: {
                                        label: 'label.reserved.system.gateway',
                                        docID: 'helpPodGateway',
                                        validation: {
                                            required: true
                                        }
                                    },
                                    reservedSystemNetmask: {
                                        label: 'label.reserved.system.netmask',
                                        docID: 'helpPodNetmask',
                                        validation: {
                                            required: true
                                        }
                                    },
                                    reservedSystemStartIp: {
                                        label: 'label.start.reserved.system.IP',
                                        docID: 'helpPodStartIP',
                                        validation: {
                                            required: true
                                        }
                                    },
                                    reservedSystemEndIp: {
                                        label: 'label.end.reserved.system.IP',
                                        docID: 'helpPodEndIP',
                                        validation: {
                                            required: false
                                        }
                                    },

                                    isDedicated: {
                                        label: 'label.dedicate',
                                        isBoolean: true,
                                        isChecked: false,
                                        docID: 'helpDedicateResource'
                                    },

                                    domainId: {
                                        label: 'label.domain',
                                        isHidden: true,
                                        validation: {
                                            required: true
                                        },
                                        dependsOn: 'isDedicated',
                                        select: function (args) {
                                            $.ajax({
                                                url: createURL('listDomains'),
                                                data: {
                                                    listAll: true,
                                                    details: 'min'
                                                },
                                                dataType: "json",
                                                async: false,
                                                success: function (json) {
                                                    var domainObjs = json.listdomainsresponse.domain;
                                                    var items =[];

                                                    $(domainObjs).each(function () {
                                                        items.push({
                                                            id: this.id,
                                                            description: this.name
                                                        });
                                                    });
                                                    items.sort(function(a, b) {
                                                        return a.description.localeCompare(b.description);
                                                    });

                                                    args.response.success({
                                                        data: items
                                                    });
                                                }
                                            });
                                        }
                                    },

                                    accountId: {
                                        label: 'label.account',
                                        isHidden: true,
                                        dependsOn: 'isDedicated',
                                        docID: 'helpAccountForDedication',
                                        validation: {
                                            required: false
                                        }
                                    }
                                }
                            },

                            action: function (args) {
                                var array1 =[];
                                var appendData = args.data.append ? args.data.append: {
                                };

                                array1.push("&zoneId=" + args.data.zoneid);
                                array1.push("&name=" + encodeURIComponent(args.data.podname));
                                array1.push("&gateway=" + encodeURIComponent(args.data.reservedSystemGateway));
                                array1.push("&netmask=" + encodeURIComponent(args.data.reservedSystemNetmask));
                                array1.push("&startIp=" + encodeURIComponent(args.data.reservedSystemStartIp));

                                var endip = args.data.reservedSystemEndIp; //optional
                                if (endip != null && endip.length > 0)
                                array1.push("&endIp=" + encodeURIComponent(endip));
                                var podId = null;
                                $.ajax({
                                    url: createURL("createPod" + array1.join("")),
                                    data: appendData,
                                    dataType: "json",
                                    success: function (json) {
                                        var item = json.createpodresponse.pod;
                                        podId = json.createpodresponse.pod.id;

                                        //EXPLICIT DEDICATION
                                        if (args.$form.find('.form-item[rel=isDedicated]').find('input[type=checkbox]').is(':Checked') == true) {
                                            var array2 =[];
                                            if (args.data.accountId != "")
                                            array2.push("&account=" + encodeURIComponent(args.data.accountId));

                                            if (podId != null) {
                                                $.ajax({
                                                    url: createURL("dedicatePod&podId=" + podId + "&domainId=" + args.data.domainId + array2.join("")),
                                                    dataType: "json",
                                                    success: function (json) {
                                                        var jid = json.dedicatepodresponse.jobid;
                                                        args.response.success({
                                                            _custom: {
                                                                jobId: jid
                                                            },
                                                            notification: {
                                                                poll: pollAsyncJobResult,
                                                                interval: 4500,
                                                                desc: "Dedicate Pod"
                                                            },

                                                            data: item
                                                        });
                                                    },

                                                    error: function (json) {
                                                        args.response.error(parseXMLHttpResponse(XMLHttpResponse));
                                                    }
                                                });
                                            }
                                        }
                                        args.response.success({
                                            data: item
                                        });
                                    },
                                    error: function (XMLHttpResponse) {
                                        var errorMsg = parseXMLHttpResponse(XMLHttpResponse);
                                        args.response.error(errorMsg);
                                    }
                                });
                            },

                            notification: {
                                poll: function (args) {
                                    args.complete({
                                        actionFilter: podActionfilter
                                    });
                                }
                            },

                            messages: {
                                notification: function (args) {
                                    return 'label.add.pod';
                                }
                            }
                        },
                        startRollingMaintenance: rollingMaintenanceAction({ listView: true, entity: 'pods' })
                    },

                    detailView: {
                        viewAll: {
                            path: '_zone.clusters',
                            label: 'label.clusters'
                        },
                        tabFilter: function (args) {
                            var hiddenTabs =[];
                            if (selectedZoneObj.networktype == "Basic") {
                                //basic-mode network (pod-wide VLAN)
                                //$("#tab_ipallocation, #add_iprange_button, #tab_network_device, #add_network_device_button").show();
                            } else if (selectedZoneObj.networktype == "Advanced") {
                                //advanced-mode network (zone-wide VLAN)
                                //$("#tab_ipallocation, #add_iprange_button, #tab_network_device, #add_network_device_button").hide();
                                hiddenTabs.push("ipAllocations");
                                //hiddenTabs.push("networkDevices"); //network devices tab is moved out of pod page at 3.0 UI. It will go to new network page.
                            }
                            return hiddenTabs;
                        },
                        actions: {
                            startRollingMaintenance: {
                                label: 'label.start.rolling.maintenance',
                                textLabel: 'label.start.rolling.maintenance',
                                messages: {
                                    notification: function (args) {
                                        return 'label.start.rolling.maintenance';
                                    }
                                },
                                createForm: {
                                    title: 'label.start.rolling.maintenance',
                                    fields: {
                                        timeout: {
                                            label: 'label.timeout',
                                        },
                                        force: {
                                            isBoolean: true,
                                            label: 'label.start.rolling.maintenance.force'
                                        },
                                        payload: {
                                            label: 'label.start.rolling.maintenance.payload'
                                        }
                                    }
                                },
                                action: function (args) {
                                    var data = {
                                        podids: args.context.pods[0].id,
                                        force: args.data.force,
                                        timeout: args.data.timeout,
                                        payload: args.data.payload
                                    };
                                    $.ajax({
                                        url: createURL("startRollingMaintenance"),
                                        dataType: "json",
                                        data: data,
                                        async: true,
                                        success: function (json) {
                                            var item = json.rollingmaintenance;
                                            args.response.success({
                                                actionFilter: zoneActionfilter,
                                                data: item
                                            });
                                        }
                                    });
                                },
                                notification: {
                                    poll: function (args) {
                                        args.complete();
                                    }
                                }
                            },

                            edit: {
                                label: 'label.edit',
                                action: function (args) {
                                    var array1 =[];

                                    array1.push("&name=" + encodeURIComponent(args.data.name));
                                    array1.push("&netmask=" + encodeURIComponent(args.data.netmask));

                                    if (args.data.gateway != null && args.data.gateway.length > 0)
                                    array1.push("&gateway=" + encodeURIComponent(args.data.gateway));

                                    $.ajax({
                                        url: createURL("updatePod&id=" + args.context.pods[0].id + array1.join("")),
                                        dataType: "json",
                                        success: function (json) {
                                            var item = json.updatepodresponse.pod;
                                            args.response.success({
                                                actionFilter: podActionfilter,
                                                data: item
                                            });
                                        },
                                        error: function (data) {
                                            args.response.error(parseXMLHttpResponse(data));
                                        }
                                    });
                                }
                            },

                            enable: {
                                label: 'label.action.enable.pod',
                                messages: {
                                    confirm: function (args) {
                                        return 'message.action.enable.pod';
                                    },
                                    notification: function (args) {
                                        return 'label.action.enable.pod';
                                    }
                                },
                                action: function (args) {
                                    $.ajax({
                                        url: createURL("updatePod&id=" + args.context.pods[0].id + "&allocationstate=Enabled"),
                                        dataType: "json",
                                        async: true,
                                        success: function (json) {
                                            var item = json.updatepodresponse.pod;
                                            args.response.success({
                                                actionFilter: podActionfilter,
                                                data: item
                                            });
                                        }
                                    });
                                },
                                notification: {
                                    poll: function (args) {
                                        args.complete();
                                    }
                                }
                            },

                            dedicate: {
                                label: 'label.dedicate.pod',
                                messages: {
                                    confirm: function (args) {
                                        return 'message.confirm.dedicate.pod.domain.account';
                                    },
                                    notification: function (args) {
                                        return 'label.pod.dedicated';
                                    }
                                },
                                createForm: {
                                    title: 'label.dedicate.pod',
                                    fields: {
                                        domainId: {
                                            label: 'label.domain',
                                            validation: {
                                                required: true
                                            },
                                            select: function (args) {
                                                $.ajax({
                                                    url: createURL('listDomains'),
                                                    data: {
                                                        listAll: true,
                                                        details: 'min'
                                                    },
                                                    dataType: "json",
                                                    async: false,
                                                    success: function (json) {
                                                        var domainObjs = json.listdomainsresponse.domain;
                                                        var items =[];

                                                        $(domainObjs).each(function () {
                                                            items.push({
                                                                id: this.id,
                                                                description: this.name
                                                            });
                                                        });
                                                        items.sort(function(a, b) {
                                                            return a.description.localeCompare(b.description);
                                                        });

                                                        args.response.success({
                                                            data: items
                                                        });
                                                    }
                                                });
                                            }
                                        },
                                        accountId: {
                                            label: 'label.account',
                                            docID: 'helpAccountForDedication',
                                            validation: {
                                                required: false
                                            }
                                        }
                                    }
                                },
                                action: function (args) {
                                    //EXPLICIT DEDICATION
                                    var array2 =[];
                                    if (args.data.accountId != "")
                                    array2.push("&account=" + encodeURIComponent(args.data.accountId));

                                    $.ajax({
                                        url: createURL("dedicatePod&podId=" +
                                        args.context.pods[0].id +
                                        "&domainId=" + args.data.domainId + array2.join("")),
                                        dataType: "json",
                                        success: function (json) {
                                            var jid = json.dedicatepodresponse.jobid;
                                            args.response.success({
                                                _custom: {
                                                    jobId: jid,
                                                    getActionFilter: function () {
                                                        return podActionfilter;
                                                    }
                                                }
                                            });
                                        },
                                        error: function (json) {
                                            args.response.error(parseXMLHttpResponse(XMLHttpResponse));
                                        }
                                    });
                                },
                                notification: {
                                    poll: pollAsyncJobResult
                                }
                            },
                            release: {
                                label: 'label.release.dedicated.pod',
                                messages: {
                                    confirm: function (args) {
                                        return 'message.confirm.release.dedicated.pod';
                                    },
                                    notification: function (args) {
                                        return 'message.pod.dedication.released';
                                    }
                                },
                                action: function (args) {
                                    $.ajax({
                                        url: createURL("releaseDedicatedPod&podid=" + args.context.pods[0].id),
                                        dataType: "json",
                                        async: true,
                                        success: function (json) {
                                            var jid = json.releasededicatedpodresponse.jobid;
                                            args.response.success({
                                                _custom: {
                                                    jobId: jid,
                                                    getActionFilter: function () {
                                                        return podActionfilter;
                                                    }
                                                }
                                            });
                                        },
                                        error: function (json) {
                                            args.response.error(parseXMLHttpResponse(json));
                                        }
                                    });
                                },
                                notification: {
                                    poll: pollAsyncJobResult
                                }
                            },


                            disable: {
                                label: 'label.action.disable.pod',
                                messages: {
                                    confirm: function (args) {
                                        return 'message.action.disable.pod';
                                    },
                                    notification: function (args) {
                                        return 'label.action.disable.pod';
                                    }
                                },
                                action: function (args) {
                                    $.ajax({
                                        url: createURL("updatePod&id=" + args.context.pods[0].id + "&allocationstate=Disabled"),
                                        dataType: "json",
                                        async: true,
                                        success: function (json) {
                                            var item = json.updatepodresponse.pod;
                                            args.response.success({
                                                actionFilter: podActionfilter,
                                                data: item
                                            });
                                        }
                                    });
                                },
                                notification: {
                                    poll: function (args) {
                                        args.complete();
                                    }
                                }
                            },

                            'remove': {
                                label: 'label.delete',
                                messages: {
                                    confirm: function (args) {
                                        return 'message.action.delete.pod';
                                    },
                                    notification: function (args) {
                                        return 'label.action.delete.pod';
                                    }
                                },
                                action: function (args) {
                                    $.ajax({
                                        url: createURL("deletePod&id=" + args.context.pods[0].id),
                                        dataType: "json",
                                        async: true,
                                        success: function (json) {
                                            args.response.success({
                                                data: {
                                                }
                                            });
                                        }
                                    });
                                },
                                notification: {
                                    poll: function (args) {
                                        args.complete();
                                    }
                                }
                            }
                        },
                        tabs: {
                            details: {
                                title: 'label.details',
                                fields:[ {
                                    name: {
                                        label: 'label.name',
                                        isEditable: true,
                                        validation: {
                                            required: true
                                        }
                                    }
                                },
                                {
                                    id: {
                                        label: 'label.id'
                                    },
                                    netmask: {
                                        label: 'label.netmask',
                                        isEditable: true,
                                        validation: {
                                            required: true
                                        }
                                    },
                                    gateway: {
                                        label: 'label.gateway',
                                        isEditable: true,
                                        validation: {
                                            required: true
                                        }
                                    },
                                    allocationstate: {
                                        converter: function (str) {
                                            // For localization
                                            return str;
                                        },
                                        label: 'label.allocation.state'
                                    }
                                }, {
                                    isdedicated: {
                                        label: 'label.dedicated'
                                    },
                                    domainid: {
                                        label: 'label.domain.id'
                                    }
                                }],

                                dataProvider: function (args) {
                                    $.ajax({
                                        url: createURL("listPods&id=" + args.context.pods[0].id),
                                        success: function (json) {
                                            var item = json.listpodsresponse.pod[0];
                                            $.ajax({
                                                url: createURL("listDedicatedPods&podid=" + args.context.pods[0].id),
                                                success: function (json) {
                                                    if (json.listdedicatedpodsresponse.dedicatedpod != undefined) {
                                                        var podItem = json.listdedicatedpodsresponse.dedicatedpod[0];
                                                        if (podItem.domainid != null) {
                                                            $.extend(item, podItem, {
                                                                isdedicated: _l('label.yes')
                                                            });
                                                        }
                                                    } else
                                                    $.extend(item, {
                                                        isdedicated: _l('label.no')
                                                    });

                                                    args.response.success({
                                                        actionFilter: podActionfilter,
                                                        data: item
                                                    });
                                                },
                                                error: function (json) {
                                                    args.response.error(parseXMLHttpResponse(XMLHttpResponse));
                                                }
                                            });
                                            //  args.response.success({
                                            //     actionFilter: podActionfilter,
                                            //     data: item
                                            // });
                                        }
                                    });
                                }
                            },

                            ipAllocations: {
                                title: 'label.ip.allocations',
                                multiple: true,
                                fields:[ {
                                    id: {
                                        label: 'label.id'
                                    },
                                    gateway: {
                                        label: 'label.gateway'
                                    },
                                    netmask: {
                                        label: 'label.netmask'
                                    },
                                    startip: {
                                        label: 'label.start.IP'
                                    },
                                    endip: {
                                        label: 'label.end.IP'
                                    }
                                }],
                                dataProvider: function (args) {
                                    $.ajax({
                                        url: createURL("listVlanIpRanges&zoneid=" + args.context.zones[0].id + "&podid=" + args.context.pods[0].id),
                                        dataType: "json",
                                        success: function (json) {
                                            var items = json.listvlaniprangesresponse.vlaniprange;
                                            args.response.success({
                                                data: items
                                            });
                                        }
                                    });
                                }
                            }
                        }
                    }
                }
            },
            clusters: {
                title: 'label.clusters',
                listView: {
                    id: 'clusters',
                    section: 'clusters',
                    multiSelect: true,
                    fields: {
                        name: {
                            label: 'label.name'
                        },
                        hypervisortype: {
                            label: 'label.hypervisor'
                        },
                        zonename: {
                            label: 'label.zone'
                        },
                        podname: {
                            label: 'label.pod'
                        },
                        managedstate: {
                            label: 'label.managed.state'
                        },
                        allocationstate: {
                            converter: function (str) {
                                // For localization
                                return str;
                            },
                            label: 'label.allocation.state',
                            indicator: {
                                'Enabled': 'on',
                                'Disabled': 'off'
                            }
                        }
                    },

                    dataProvider: function (args) {
                        var array1 =[];
                        if (args.filterBy != null) {
                            if (args.filterBy.search != null && args.filterBy.search.by != null && args.filterBy.search.value != null) {
                                switch (args.filterBy.search.by) {
                                    case "name":
                                    if (args.filterBy.search.value.length > 0)
                                    array1.push("&keyword=" + args.filterBy.search.value);
                                    break;
                                }
                            }
                        }
                        array1.push("&zoneid=" + args.context.zones[0].id);
                        if ("pods" in args.context)
                        array1.push("&podid=" + args.context.pods[0].id);
                        $.ajax({
                            url: createURL("listClusters" + array1.join("") + "&page=" + args.page + "&pagesize=" + pageSize),
                            dataType: "json",
                            async: true,
                            success: function (json) {
                                var items = json.listclustersresponse.cluster;
                                $(items).each(function () {
                                    addExtraPropertiesToClusterObject(this);
                                });

                                args.response.success({
                                    actionFilter: clusterActionfilter,
                                    data: items
                                });
                            }
                        });
                    },

                    actions: {
                        add: {
                            label: 'label.add.cluster',
                            messages: {
                                notification: function (args) {
                                    return 'label.add.cluster';
                                }
                            },
                            createForm: {
                                title: 'label.add.cluster',
                                preFilter: function (args) {
                                    var $form = args.$form;
                                    $form.click(function () {
                                        var $nexusDvsOptFields = $form.find('.form-item').filter(function () {
                                            var nexusDvsOptFields =[
                                            'vsmipaddress',
                                            'vsmusername',
                                            'vsmpassword'];
                                            return $.inArray($(this).attr('rel'), nexusDvsOptFields) > -1;
                                        });
                                        var $nexusDvsReqFields = $form.find('.form-item').filter(function () {
                                            var nexusDvsReqFields =[
                                            'vsmipaddress_req',
                                            'vsmusername_req',
                                            'vsmpassword_req'];
                                            return $.inArray($(this).attr('rel'), nexusDvsReqFields) > -1;
                                        });

                                        if ($form.find('.form-item[rel=hypervisor] select').val() == 'VMware') {
                                            $form.find('.form-item[rel=vCenterHost]').css('display', 'inline-block');
                                            $form.find('.form-item[rel=vCenterUsername]').css('display', 'inline-block');
                                            $form.find('.form-item[rel=vCenterPassword]').css('display', 'inline-block');
                                            $form.find('.form-item[rel=vCenterDatacenter]').css('display', 'inline-block');

                                            var $overridePublicTraffic = $form.find('.form-item[rel=overridepublictraffic] input[type=checkbox]');
                                            var $vSwitchPublicType = $form.find('.form-item[rel=vSwitchPublicType] select');
                                            var $overrideGuestTraffic = $form.find('.form-item[rel=overrideguesttraffic] input[type=checkbox]');
                                            var $vSwitchGuestType = $form.find('.form-item[rel=vSwitchGuestType] select');


                                            var useDvs = false;
                                            $.ajax({
                                                url: createURL('listConfigurations'),
                                                data: {
                                                    name: 'vmware.use.dvswitch'
                                                },
                                                async: false,
                                                success: function (json) {
                                                    if (json.listconfigurationsresponse.configuration[0].value == 'true') {
                                                        useDvs = true;
                                                    }
                                                }
                                            });
                                            if (useDvs == true) {
                                                //If using Distributed vswitch, there is OverrideTraffic option.
                                                $form.find('.form-item[rel=overridepublictraffic]').css('display', 'inline-block');
                                                $form.find('.form-item[rel=overrideguesttraffic]').css('display', 'inline-block');

                                                var useNexusDvs = false;
                                                $.ajax({
                                                    url: createURL('listConfigurations'),
                                                    data: {
                                                        name: 'vmware.use.nexus.vswitch'
                                                    },
                                                    async: false,
                                                    success: function (json) {
                                                        if (json.listconfigurationsresponse.configuration[0].value == 'true') {
                                                            useNexusDvs = true;
                                                        }
                                                    }
                                                });
                                                if (useNexusDvs == true) {
                                                    //If using Nexus Distributed vswitch, show Nexus Distributed vswitch fields (either required ones or optional ones).
                                                    if (($overridePublicTraffic.is(':checked') && $vSwitchPublicType.val() == 'nexusdvs') ||
                                                    ($overrideGuestTraffic.is(':checked') && $vSwitchGuestType.val() == 'nexusdvs')) {
                                                        $nexusDvsReqFields.css('display', 'inline-block');
                                                        $nexusDvsOptFields.hide();
                                                    } else {
                                                        $nexusDvsOptFields.css('display', 'inline-block');
                                                        $nexusDvsReqFields.hide();
                                                    }
                                                } else {
                                                    //If not using Nexus Distributed vswitch, hide Nexus Distributed vswitch fields.
                                                    $nexusDvsOptFields.hide();
                                                    $nexusDvsReqFields.hide();
                                                }
                                            } else {
                                                //useDvs == false
                                                $form.find('.form-item[rel=overridepublictraffic]').css('display', 'none');
                                                $form.find('.form-item[rel=vSwitchPublicType]').css('display', 'none');
                                                $form.find('.form-item[rel=vSwitchPublicName]').css('display', 'none');

                                                $form.find('.form-item[rel=overrideguesttraffic]').css('display', 'none');
                                                $form.find('.form-item[rel=vSwitchGuestType]').css('display', 'none');
                                                $form.find('.form-item[rel=vSwitchGuestName]').css('display', 'none');

                                                $nexusDvsOptFields.hide();
                                                $nexusDvsReqFields.hide();
                                            }
                                        } else {
                                            //XenServer, KVM, etc (non-VMware)
                                            $form.find('.form-item[rel=vCenterHost]').css('display', 'none');
                                            $form.find('.form-item[rel=vCenterUsername]').css('display', 'none');
                                            $form.find('.form-item[rel=vCenterPassword]').css('display', 'none');
                                            $form.find('.form-item[rel=vCenterDatacenter]').css('display', 'none');
                                            $form.find('.form-item[rel=enableNexusVswitch]').css('display', 'none');

                                            $form.find('.form-item[rel=overridepublictraffic]').css('display', 'none');
                                            $form.find('.form-item[rel=overrideguesttraffic]').css('display', 'none');
                                            $nexusDvsOptFields.hide();
                                            $nexusDvsReqFields.hide();
                                        }

                                        if ($form.find('.form-item[rel=overridepublictraffic]').css('display') != 'none' && $overridePublicTraffic.is(':checked')) {
                                            $form.find('.form-item[rel=vSwitchPublicType]').css('display', 'inline-block');
                                            $form.find('.form-item[rel=vSwitchPublicName]').css('display', 'inline-block');
                                        } else {
                                            $form.find('.form-item[rel=vSwitchPublicType]').css('display', 'none');
                                            $form.find('.form-item[rel=vSwitchPublicName]').css('display', 'none');
                                        }

                                        if ($form.find('.form-item[rel=overrideguesttraffic]').css('display') != 'none' && $overrideGuestTraffic.is(':checked')) {
                                            $form.find('.form-item[rel=vSwitchGuestType]').css('display', 'inline-block');
                                            $form.find('.form-item[rel=vSwitchGuestName]').css('display', 'inline-block');
                                        } else {
                                            $form.find('.form-item[rel=vSwitchGuestType]').css('display', 'none');
                                            $form.find('.form-item[rel=vSwitchGuestName]').css('display', 'none');
                                        }
                                    });

                                    $form.trigger('click');
                                },
                                fields: {
                                    zoneid: {
                                        label: 'label.zone.name',
                                        docID: 'helpClusterZone',
                                        validation: {
                                            required: true
                                        },
                                        select: function (args) {
                                            var data = args.context.zones ? {
                                                id: args.context.zones[0].id
                                            }: {};

                                            $.ajax({
                                                url: createURL('listZones'),
                                                data: data,
                                                success: function (json) {
                                                    var zones = json.listzonesresponse.zone ? json.listzonesresponse.zone:[];

                                                    args.response.success({
                                                        data: $.map(zones, function (zone) {
                                                            return {
                                                                id: zone.id,
                                                                description: zone.name
                                                            };
                                                        })
                                                    });
                                                }
                                            });
                                        }
                                    },
                                    hypervisor: {
                                        label: 'label.hypervisor',
                                        docID: 'helpClusterHypervisor',
                                        select: function (args) {
                                            $.ajax({
                                                url: createURL("listHypervisors"),
                                                dataType: "json",
                                                async: false,
                                                success: function (json) {
                                                    var hypervisors = json.listhypervisorsresponse.hypervisor;
                                                    var items =[];
                                                    $(hypervisors).each(function () {
                                                        items.push({
                                                            id: this.name,
                                                            description: this.name
                                                        });
                                                    });
                                                    args.response.success({
                                                        data: items
                                                    });
                                                }
                                            });
                                        }
                                    },
                                    podId: {
                                        label: 'label.pod.name',
                                        docID: 'helpClusterPod',
                                        dependsOn: 'zoneid',
                                        select: function (args) {
                                            $.ajax({
                                                url: createURL("listPods&zoneid=" + args.zoneid),
                                                dataType: "json",
                                                async: true,
                                                success: function (json) {
                                                    var pods = json.listpodsresponse.pod;
                                                    var items =[];
                                                    $(pods).each(function () {
                                                        if (("pods" in args.context) && (this.id == args.context.pods[0].id))
                                                        items.unshift({
                                                            id: this.id,
                                                            description: this.name
                                                        }); else
                                                        items.push({
                                                            id: this.id,
                                                            description: this.name
                                                        });
                                                    });
                                                    args.response.success({
                                                        data: items
                                                    });
                                                }
                                            });
                                        }
                                    },
                                    name: {
                                        label: 'label.cluster.name',
                                        docID: 'helpClusterName',
                                        validation: {
                                            required: true
                                        }
                                    },

                                    isDedicated: {
                                        label: 'label.dedicate',
                                        isBoolean: true,
                                        isChecked: false,
                                        docID: 'helpDedicateResource'
                                    },

                                    domainId: {
                                        label: 'label.domain',
                                        isHidden: true,
                                        validation: {
                                            required: true
                                        },
                                        dependsOn: 'isDedicated',
                                        select: function (args) {
                                            $.ajax({
                                                url: createURL('listDomains'),
                                                data: {
                                                    listAll: true,
                                                    details: 'min'
                                                },
                                                dataType: "json",
                                                async: false,
                                                success: function (json) {
                                                    var domainObjs = json.listdomainsresponse.domain;
                                                    var items =[];

                                                    $(domainObjs).each(function () {
                                                        items.push({
                                                            id: this.id,
                                                            description: this.name
                                                        });
                                                    });
                                                    items.sort(function(a, b) {
                                                        return a.description.localeCompare(b.description);
                                                    });

                                                    args.response.success({
                                                        data: items
                                                    });
                                                }
                                            });
                                        }
                                    },

                                    accountId: {
                                        label: 'label.account',
                                        isHidden: true,
                                        dependsOn: 'isDedicated',
                                        docID: 'helpAccountForDedication',
                                        validation: {
                                            required: false
                                        }
                                    },

                                    //hypervisor==Ovm3 begins here
                                    ovm3pool: {
                                        label: 'label.ovm3.pool',
                                        isHidden: true,
                                        isBoolean: true,
                                        isChecked: true,
                                        docID: 'helpOvm3pool'
                                    },
                                    ovm3cluster: {
                                        label: 'label.ovm3.cluster',
                                        isHidden: true,
                                        isBoolean: true,
                                        isChecked: false,
                                        docID: 'helpOvm3cluster'
                                    },
                                    ovm3vip: {
                                        label: 'label.ovm3.vip',
                                        isHidden: true,
                                        docID: 'helpOvm3Vip',
                                        validation: {
                                            required: false
                                        }
                                    },

                                    //hypervisor==VMWare begins here
                                    vCenterHost: {
                                        label: 'label.vcenter.host',
                                        isHidden: true,
                                        docID: 'helpClustervCenterHost',
                                        validation: {
                                            required: false
                                        }
                                        //legacy zone - validation not required for new VMware dc model
                                    },
                                    vCenterUsername: {
                                        label: 'label.vcenter.username',
                                        isHidden: true,
                                        docID: 'helpClustervCenterUsername'
                                    },
                                    vCenterPassword: {
                                        label: 'label.vcenter.password',
                                        isHidden: true,
                                        docID: 'helpClustervCenterPassword',
                                        isPassword: true
                                    },
                                    vCenterDatacenter: {
                                        label: 'label.vcenter.datacenter',
                                        isHidden: true,
                                        docID: 'helpClustervCenterDatacenter',
                                        validation: {
                                            required: false
                                        }
                                        //legacy zone - validation not required for new VMware dc model
                                    },

                                    overridepublictraffic: {
                                        label: 'label.override.public.traffic',
                                        isBoolean: true,
                                        isHidden: true,
                                        isChecked: false,
                                        docID: 'helpOverridePublicNetwork'
                                    },


                                    vSwitchPublicType: {
                                        label: 'label.public.traffic.vswitch.type',
                                        select: function (args) {
                                            var useNexusDvs = false;
                                            var items =[]
                                            $.ajax({
                                                url: createURL('listConfigurations'),
                                                data: {
                                                    name: 'vmware.use.nexus.vswitch'
                                                },
                                                async: false,
                                                success: function (json) {
                                                    if (json.listconfigurationsresponse.configuration[0].value == 'true') {
                                                        useNexusDvs = true;
                                                    }
                                                }
                                            });

                                            if (useNexusDvs) {
                                                items.push({
                                                    id: "nexusdvs",
                                                    description: "Cisco Nexus 1000v Distributed Virtual Switch"
                                                });
                                                items.push({
                                                    id: "vmwaresvs",
                                                    description: "VMware vNetwork Standard Virtual Switch"
                                                });
                                                items.push({
                                                    id: "vmwaredvs",
                                                    description: "VMware vNetwork Distributed Virtual Switch"
                                                });
                                            } else {
                                                items.push({
                                                    id: "vmwaredvs",
                                                    description: "VMware vNetwork Distributed Virtual Switch"
                                                });
                                                items.push({
                                                    id: "vmwaresvs",
                                                    description: "VMware vNetwork Standard Virtual Switch"
                                                });
                                                items.push({
                                                    id: "nexusdvs",
                                                    description: "Cisco Nexus 1000v Distributed Virtual Switch"
                                                });
                                            }

                                            args.response.success({
                                                data: items
                                            });
                                        },
                                        isHidden: true
                                    },

                                    vSwitchPublicName: {
                                        label: 'label.public.traffic.vswitch.name',
                                        isHidden: true
                                    },

                                    overrideguesttraffic: {
                                        label: 'label.override.guest.traffic',
                                        isBoolean: true,
                                        isHidden: true,
                                        isChecked: false,
                                        docID: 'helpOverrideGuestNetwork'
                                    },

                                    vSwitchGuestType: {
                                        label: 'label.guest.traffic.vswitch.type',
                                        select: function (args) {
                                            var items =[]

                                            var useNexusDvs = false;
                                            $.ajax({
                                                url: createURL('listConfigurations'),
                                                data: {
                                                    name: 'vmware.use.nexus.vswitch'
                                                },
                                                async: false,
                                                success: function (json) {
                                                    if (json.listconfigurationsresponse.configuration[0].value == 'true') {
                                                        useNexusDvs = true;
                                                    }
                                                }
                                            });


                                            if (useNexusDvs) {
                                                items.push({
                                                    id: "nexusdvs",
                                                    description: "Cisco Nexus 1000v Distributed Virtual Switch"
                                                });
                                                items.push({
                                                    id: "vmwaresvs",
                                                    description: "VMware vNetwork Standard Virtual Switch"
                                                });
                                                items.push({
                                                    id: "vmwaredvs",
                                                    description: "VMware vNetwork Distributed Virtual Switch"
                                                });
                                            } else {
                                                items.push({
                                                    id: "vmwaredvs",
                                                    description: "VMware vNetwork Distributed Virtual Switch"
                                                });
                                                items.push({
                                                    id: "vmwaresvs",
                                                    description: "VMware vNetwork Standard Virtual Switch"
                                                });
                                                items.push({
                                                    id: "nexusdvs",
                                                    description: "Cisco Nexus 1000v Distributed Virtual Switch"
                                                });
                                            }

                                            args.response.success({
                                                data: items
                                            });
                                        },
                                        isHidden: true
                                    },

                                    vSwitchGuestName: {
                                        label: 'label.guest.traffic.vswitch.name',
                                        isHidden: true
                                    },


                                    vsmipaddress: {
                                        label: 'label.cisco.nexus1000v.ip.address',
                                        validation: {
                                            required: false
                                        },
                                        isHidden: true
                                    },
                                    vsmipaddress_req: {
                                        label: 'label.cisco.nexus1000v.ip.address',
                                        validation: {
                                            required: true
                                        },
                                        isHidden: true
                                    },
                                    vsmusername: {
                                        label: 'label.cisco.nexus1000v.username',
                                        validation: {
                                            required: false
                                        },
                                        isHidden: true
                                    },
                                    vsmusername_req: {
                                        label: 'label.cisco.nexus1000v.username',
                                        validation: {
                                            required: true
                                        },
                                        isHidden: true
                                    },
                                    vsmpassword: {
                                        label: 'label.cisco.nexus1000v.password',
                                        validation: {
                                            required: false
                                        },
                                        isPassword: true,
                                        isHidden: true
                                    },
                                    vsmpassword_req: {
                                        label: 'label.cisco.nexus1000v.password',
                                        validation: {
                                            required: true
                                        },
                                        isPassword: true,
                                        isHidden: true
                                    }
                                    //hypervisor==VMWare ends here
                                }
                            },

                            action: function (args) {
                                var array1 =[];
                                array1.push("&zoneId=" + args.data.zoneid);
                                array1.push("&hypervisor=" + args.data.hypervisor);

                                var clusterType;
                                if (args.data.hypervisor == "VMware")
                                clusterType = "ExternalManaged"; else
                                clusterType = "CloudManaged";
                                array1.push("&clustertype=" + clusterType);

                                array1.push("&podId=" + args.data.podId);

                                var clusterName = args.data.name;
                                if (args.data.hypervisor == "Ovm3") {
                                     array1.push("&ovm3pool=" + encodeURIComponent(args.data.ovm3pool));
                                     array1.push("&ovm3cluster=" + encodeURIComponent(args.data.ovm3cluster));
                                     array1.push("&ovm3vip=" + encodeURIComponent(args.data.ovm3vip));
                                }
                                if (args.data.hypervisor == "VMware") {
                                    cloudStack.addUsernameAndPasswordToCommandUrlParameterArrayIfItIsNotNullAndNotEmpty(array1, args.data.vCenterUsername, args.data.vCenterPassword);

                                    //vSwitch Public Type
                                    if (args.$form.find('.form-item[rel=vSwitchPublicType]').css('display') != 'none' && args.data.vSwitchPublicType != "") {
                                        array1.push("&publicvswitchtype=" + args.data.vSwitchPublicType);
                                    }
                                    if (args.$form.find('.form-item[rel=vSwitchPublicName]').css('display') != 'none' && args.data.vSwitchPublicName != "") {
                                        array1.push("&publicvswitchname=" + args.data.vSwitchPublicName);
                                    }

                                    //vSwitch Guest Type
                                    if (args.$form.find('.form-item[rel=vSwitchGuestType]').css('display') != 'none' && args.data.vSwitchGuestType != "") {
                                        array1.push("&guestvswitchtype=" + args.data.vSwitchGuestType);
                                    }
                                    if (args.$form.find('.form-item[rel=vSwitchGuestName]').css('display') != 'none' && args.data.vSwitchGuestName != "") {
                                        array1.push("&guestvswitchname=" + args.data.vSwitchGuestName);
                                    }

                                    //Nexus VSM fields
                                    if (args.$form.find('.form-item[rel=vsmipaddress]').css('display') != 'none' && args.data.vsmipaddress != null && args.data.vsmipaddress.length > 0) {
                                        array1.push('&vsmipaddress=' + args.data.vsmipaddress);
                                    }
                                    if (args.$form.find('.form-item[rel=vsmipaddress_req]').css('display') != 'none' && args.data.vsmipaddress_req != null && args.data.vsmipaddress_req.length > 0) {
                                        array1.push('&vsmipaddress=' + args.data.vsmipaddress_req);
                                    }

                                    if (args.$form.find('.form-item[rel=vsmusername]').css('display') != 'none' && args.data.vsmusername != null && args.data.vsmusername.length > 0) {
                                        array1.push('&vsmusername=' + args.data.vsmusername);
                                    }
                                    if (args.$form.find('.form-item[rel=vsmusername_req]').css('display') != 'none' && args.data.vsmusername_req != null && args.data.vsmusername_req.length > 0) {
                                        array1.push('&vsmusername=' + args.data.vsmusername_req);
                                    }

                                    if (args.$form.find('.form-item[rel=vsmpassword]').css('display') != 'none' && args.data.vsmpassword != null && args.data.vsmpassword.length > 0) {
                                        array1.push('&vsmpassword=' + args.data.vsmpassword);
                                    }
                                    if (args.$form.find('.form-item[rel=vsmpassword_req]').css('display') != 'none' && args.data.vsmpassword_req != null && args.data.vsmpassword_req.length > 0) {
                                        array1.push('&vsmpassword=' + args.data.vsmpassword_req);
                                    }


                                    var hostname = args.data.vCenterHost;
                                    var dcName = args.data.vCenterDatacenter;

                                    if (hostname.length == 0 && dcName.length == 0) {
                                        $.ajax({
                                            url: createURL('listVmwareDcs'),
                                            data: {
                                                zoneid: args.data.zoneid
                                            },
                                            async: false,
                                            success: function (json) {
                                                //e.g. json == { "listvmwaredcsresponse" { "count":1 ,"VMwareDC" [ {"id":"c3c2562d-65e9-4fc7-92e2-773c2efe8f37","zoneid":1,"name":"datacenter","vcenter":"10.10.20.20"} ] } }
                                                var vmwaredcs = json.listvmwaredcsresponse.VMwareDC;
                                                if (vmwaredcs != null) {
                                                    hostname = vmwaredcs[0].vcenter;
                                                    dcName = vmwaredcs[0].name;
                                                }
                                            }
                                        });
                                    }

                                    var url;
                                    if (hostname.indexOf("http://") == -1)
                                    url = "http://" + hostname; else
                                    url = hostname;
                                    url += "/" + dcName + "/" + clusterName;
                                    array1.push("&url=" + encodeURIComponent(url));

                                    clusterName = hostname + "/" + dcName + "/" + clusterName; //override clusterName
                                }
                                array1.push("&clustername=" + encodeURIComponent(clusterName));
                                var clusterId = null;
                                $.ajax({
                                    url: createURL("addCluster" + array1.join("")),
                                    dataType: "json",
                                    type: "POST",
                                    success: function (json) {
                                        var item = json.addclusterresponse.cluster[0];
                                        clusterId = json.addclusterresponse.cluster[0].id;

                                        //EXPLICIT DEDICATION
                                        var array2 =[];
                                        if (args.$form.find('.form-item[rel=isDedicated]').find('input[type=checkbox]').is(':Checked') == true) {
                                            if (args.data.accountId != "")
                                            array2.push("&account=" + encodeURIComponent(args.data.accountId));

                                            if (clusterId != null) {
                                                $.ajax({
                                                    url: createURL("dedicateCluster&clusterId=" + clusterId + "&domainId=" + args.data.domainId + array2.join("")),
                                                    dataType: "json",
                                                    success: function (json) {
                                                        var jid = json.dedicateclusterresponse.jobid;
                                                        args.response.success({
                                                            _custom: {
                                                                jobId: jid
                                                            },
                                                            notification: {
                                                                poll: pollAsyncJobResult,
                                                                interval: 4500,
                                                                desc: "Dedicate Cluster"
                                                            },

                                                            data: $.extend(item, {
                                                                state: 'Enabled'
                                                            })
                                                        });
                                                    },
                                                    error: function (json) {
                                                        args.response.error(parseXMLHttpResponse(XMLHttpResponse));
                                                    }
                                                });
                                            }
                                        }
                                        args.response.success({
                                            data: item,
                                            actionFilter: clusterActionfilter
                                        });
                                    },
                                    error: function (XMLHttpResponse) {
                                        var errorMsg = parseXMLHttpResponse(XMLHttpResponse);
                                        args.response.error(errorMsg);
                                    }
                                });
                            }
                        },
                        viewMetrics: {
                            label: 'label.metrics',
                            isHeader: true,
                            addRow: false,
                            action: {
                                custom: cloudStack.uiCustom.metricsView({resource: 'clusters'})
                            },
                            messages: {
                                notification: function (args) {
                                    return 'label.metrics';
                                }
                            }
                        },
                        startRollingMaintenance: rollingMaintenanceAction({ listView: true, entity: 'clusters' })
                    },

                    detailView: {
                        viewAll: {
                            path: '_zone.hosts',
                            label: 'label.hosts'
                        },
                        isMaximized: true,
                        tabFilter: function (args) {
                            var vSwichConfigEnabled, vSwitchPresentOnCluster;
                            $.ajax({
                                url: createURL('listConfigurations'),
                                data: {
                                    name: 'vmware.use.nexus.vswitch'
                                },
                                async: false,
                                success: function (json) {
                                    vSwichConfigEnabled = json.listconfigurationsresponse.configuration[0].value;
                                }
                            });

                            var hypervisorType = args.context.clusters[0].hypervisortype;
                            if (vSwichConfigEnabled != "true" || hypervisorType != 'VMware') {
                                return[ 'nexusVswitch'];
                            }
                            return[];
                        },

                        actions: {

                            startRollingMaintenance: {
                                label: 'label.start.rolling.maintenance',
                                textLabel: 'label.start.rolling.maintenance',
                                messages: {
                                    notification: function (args) {
                                        return 'label.start.rolling.maintenance';
                                    }
                                },
                                createForm: {
                                    title: 'label.start.rolling.maintenance',
                                    fields: {
                                        timeout: {
                                            label: 'label.timeout',
                                        },
                                        force: {
                                            isBoolean: true,
                                            label: 'label.start.rolling.maintenance.force'
                                        },
                                        payload: {
                                            label: 'label.start.rolling.maintenance.payload'
                                        }
                                    }
                                },
                                action: function (args) {
                                    var data = {
                                        clusterids: args.context.clusters[0].id,
                                        force: args.data.force,
                                        timeout: args.data.timeout,
                                        payload: args.data.payload
                                    };
                                    $.ajax({
                                        url: createURL("startRollingMaintenance"),
                                        dataType: "json",
                                        data: data,
                                        async: true,
                                        success: function (json) {
                                            var item = json.rollingmaintenance;
                                            args.response.success({
                                                actionFilter: zoneActionfilter,
                                                data: item
                                            });
                                        }
                                    });
                                },
                                notification: {
                                    poll: function (args) {
                                        args.complete();
                                    }
                                }
                            },
                            edit: {
                                label: 'label.edit',
                                action: function (args) {
                                    var array1 =[];

                                    $.ajax({
                                        url: createURL("updateCluster&id=" + args.context.clusters[0].id + array1.join("")),
                                        dataType: "json",
                                        async: true,
                                        success: function (json) {
                                            var item = json.updateclusterresponse.cluster;
                                            addExtraPropertiesToClusterObject(item);
                                            args.response.success({
                                                actionFilter: clusterActionfilter,
                                                data: item
                                            });
                                        }
                                    });
                                }
                            },

                            enable: {
                                label: 'label.action.enable.cluster',
                                messages: {
                                    confirm: function (args) {
                                        return 'message.action.enable.cluster';
                                    },
                                    notification: function (args) {
                                        return 'label.action.enable.cluster';
                                    }
                                },
                                action: function (args) {
                                    $.ajax({
                                        url: createURL("updateCluster&id=" + args.context.clusters[0].id + "&allocationstate=Enabled"),
                                        dataType: "json",
                                        async: true,
                                        success: function (json) {
                                            var item = json.updateclusterresponse.cluster;
                                            args.context.clusters[0].state = item.allocationstate;
                                            addExtraPropertiesToClusterObject(item);
                                            args.response.success({
                                                actionFilter: clusterActionfilter,
                                                data: item
                                            });
                                        }
                                    });
                                },
                                notification: {
                                    poll: function (args) {
                                        args.complete();
                                    }
                                }
                            },

                            disable: {
                                label: 'label.action.disable.cluster',
                                messages: {
                                    confirm: function (args) {
                                        return 'message.action.disable.cluster';
                                    },
                                    notification: function (args) {
                                        return 'label.action.disable.cluster';
                                    }
                                },
                                action: function (args) {
                                    $.ajax({
                                        url: createURL("updateCluster&id=" + args.context.clusters[0].id + "&allocationstate=Disabled"),
                                        dataType: "json",
                                        async: true,
                                        success: function (json) {
                                            var item = json.updateclusterresponse.cluster;
                                            args.context.clusters[0].state = item.allocationstate;
                                            addExtraPropertiesToClusterObject(item);
                                            args.response.success({
                                                actionFilter: clusterActionfilter,
                                                data: item
                                            });
                                        }
                                    });
                                },
                                notification: {
                                    poll: function (args) {
                                        args.complete();
                                    }
                                }
                            },

                            dedicate: {
                                label: 'label.dedicate.cluster',
                                messages: {
                                    confirm: function (args) {
                                        return 'message.confirm.dedicate.cluster.domain.account';
                                    },
                                    notification: function (args) {
                                        return 'message.cluster.dedicated';
                                    }
                                },
                                createForm: {
                                    title: 'label.dedicate.cluster',
                                    fields: {
                                        domainId: {
                                            label: 'label.domain',
                                            validation: {
                                                required: true
                                            },
                                            select: function (args) {
                                                $.ajax({
                                                    url: createURL('listDomains'),
                                                    data: {
                                                        listAll: true,
                                                        details: 'min'
                                                    },
                                                    dataType: "json",
                                                    async: false,
                                                    success: function (json) {
                                                        var domainObjs = json.listdomainsresponse.domain;
                                                        var items =[];

                                                        $(domainObjs).each(function () {
                                                            items.push({
                                                                id: this.id,
                                                                description: this.name
                                                            });
                                                        });
                                                        items.sort(function(a, b) {
                                                            return a.description.localeCompare(b.description);
                                                        });

                                                        args.response.success({
                                                            data: items
                                                        });
                                                    }
                                                });
                                            }
                                        },
                                        accountId: {
                                            label: 'label.account',
                                            docID: 'helpAccountForDedication',
                                            validation: {
                                                required: false
                                            }
                                        }
                                    }
                                },
                                action: function (args) {
                                    //EXPLICIT DEDICATION
                                    var array2 =[];
                                    if (args.data.accountId != "")
                                    array2.push("&account=" + encodeURIComponent(args.data.accountId));
                                    $.ajax({
                                        url: createURL("dedicateCluster&clusterId=" +
                                        args.context.clusters[0].id +
                                        "&domainId=" + args.data.domainId + array2.join("")),
                                        dataType: "json",
                                        success: function (json) {
                                            var jid = json.dedicateclusterresponse.jobid;
                                            args.response.success({
                                                _custom: {
                                                    jobId: jid,
                                                    getActionFilter: function () {
                                                        return clusterActionfilter;
                                                    }
                                                }
                                            });
                                        }
                                    });
                                },
                                notification: {
                                    poll: pollAsyncJobResult
                                }
                            },
                            release: {
                                label: 'label.release.dedicated.cluster',
                                messages: {
                                    confirm: function (args) {
                                        return 'message.confirm.release.dedicated.cluster';
                                    },
                                    notification: function (args) {
                                        return 'message.cluster.dedication.released';
                                    }
                                },
                                action: function (args) {
                                    $.ajax({
                                        url: createURL("releaseDedicatedCluster&clusterid=" + args.context.clusters[0].id),
                                        dataType: "json",
                                        async: true,
                                        success: function (json) {
                                            var jid = json.releasededicatedclusterresponse.jobid;
                                            args.response.success({
                                                _custom: {
                                                    jobId: jid,
                                                    getActionFilter: function () {
                                                        return clusterActionfilter;
                                                    }
                                                }
                                            });
                                        },
                                        error: function (json) {
                                            args.response.error(parseXMLHttpResponse(json));
                                        }
                                    });
                                },
                                notification: {
                                    poll: pollAsyncJobResult
                                }
                            },


                            manage: {
                                label: 'label.action.manage.cluster',
                                messages: {
                                    confirm: function (args) {
                                        return 'message.action.manage.cluster';
                                    },
                                    notification: function (args) {
                                        return 'label.action.manage.cluster';
                                    }
                                },
                                action: function (args) {
                                    $.ajax({
                                        url: createURL("updateCluster&id=" + args.context.clusters[0].id + "&managedstate=Managed"),
                                        dataType: "json",
                                        async: true,
                                        success: function (json) {
                                            var item = json.updateclusterresponse.cluster;
                                            addExtraPropertiesToClusterObject(item);
                                            args.response.success({
                                                actionFilter: clusterActionfilter,
                                                data: item
                                            });
                                        }
                                    });
                                },
                                notification: {
                                    poll: function (args) {
                                        args.complete();
                                    }
                                }
                            },

                            unmanage: {
                                label: 'label.action.unmanage.cluster',
                                messages: {
                                    confirm: function (args) {
                                        return 'message.action.unmanage.cluster';
                                    },
                                    notification: function (args) {
                                        return 'label.action.unmanage.cluster';
                                    }
                                },
                                action: function (args) {
                                    $.ajax({
                                        url: createURL("updateCluster&id=" + args.context.clusters[0].id + "&managedstate=Unmanaged"),
                                        dataType: "json",
                                        async: true,
                                        success: function (json) {
                                            var item = json.updateclusterresponse.cluster;
                                            addExtraPropertiesToClusterObject(item);
                                            args.response.success({
                                                actionFilter: clusterActionfilter,
                                                data: item
                                            });
                                        }
                                    });
                                },
                                notification: {
                                    poll: function (args) {
                                        args.complete();
                                    }
                                }
                            },

                            'remove': {
                                label: 'label.action.delete.cluster',
                                messages: {
                                    confirm: function (args) {
                                        return 'message.action.delete.cluster';
                                    },
                                    notification: function (args) {
                                        return 'label.action.delete.cluster';
                                    }
                                },
                                action: function (args) {
                                    $.ajax({
                                        url: createURL("deleteCluster&id=" + args.context.clusters[0].id),
                                        dataType: "json",
                                        async: true,
                                        success: function (json) {
                                            args.response.success({
                                                data: {
                                                }
                                            });
                                        }
                                    });
                                },
                                notification: {
                                    poll: function (args) {
                                        args.complete();
                                    }
                                }
                            },

                            enableOutOfBandManagement: {
                                label: 'label.outofbandmanagement.enable',
                                action: function (args) {
                                    var data = {
                                        clusterid: args.context.clusters[0].id,
                                    };
                                    $.ajax({
                                        url: createURL("enableOutOfBandManagementForCluster"),
                                        data: data,
                                        success: function (json) {
                                            var jid = json.enableoutofbandmanagementforclusterresponse.jobid;
                                            args.response.success({
                                                _custom: {
                                                    jobId: jid,
                                                    getActionFilter: function () {
                                                        return clusterActionfilter;
                                                    }
                                                }
                                            });
                                        },
                                        error: function (json) {
                                            args.response.error(parseXMLHttpResponse(json));
                                        }
                                    });
                                },
                                messages: {
                                    confirm: function (args) {
                                        return 'message.outofbandmanagement.enable';
                                    },
                                    notification: function (args) {
                                        return 'message.outofbandmanagement.enable';
                                    }
                                },
                                notification: {
                                    poll: pollAsyncJobResult
                                }
                            },

                            disableOutOfBandManagement: {
                                label: 'label.outofbandmanagement.disable',
                                action: function (args) {
                                    var data = {
                                        clusterid: args.context.clusters[0].id,
                                    };
                                    $.ajax({
                                        url: createURL("disableOutOfBandManagementForCluster"),
                                        data: data,
                                        success: function (json) {
                                            var jid = json.disableoutofbandmanagementforclusterresponse.jobid;
                                            args.response.success({
                                                _custom: {
                                                    jobId: jid,
                                                    getActionFilter: function () {
                                                        return clusterActionfilter;
                                                    }
                                                }
                                            });
                                        },
                                        error: function (json) {
                                            args.response.error(parseXMLHttpResponse(json));
                                        }

                                    });
                                },
                                messages: {
                                    confirm: function (args) {
                                        return 'message.outofbandmanagement.disable';
                                    },
                                    notification: function (args) {
                                        return 'message.outofbandmanagement.disable';
                                    }
                                },
                                notification: {
                                    poll: pollAsyncJobResult
                                }
                            },
                            enableHA: {
                                label: 'label.ha.enable',
                                action: function (args) {
                                    var data = {
                                        clusterid: args.context.clusters[0].id
                                    };
                                    $.ajax({
                                        url: createURL("enableHAForCluster"),
                                        data: data,
                                        success: function (json) {
                                            var jid = json.enablehaforclusterresponse.jobid;
                                            args.response.success({
                                                _custom: {
                                                    jobId: jid,
                                                    getActionFilter: function () {
                                                        return clusterActionfilter;
                                                    }
                                                }
                                            });
                                        },
                                        error: function (json) {
                                            args.response.error(parseXMLHttpResponse(json));
                                        }
                                    });
                                },
                                messages: {
                                    confirm: function (args) {
                                        return 'label.ha.enable';
                                    },
                                    notification: function (args) {
                                        return 'label.ha.enable';
                                    }
                                },
                                notification: {
                                    poll: pollAsyncJobResult
                                }
                            },
                            disableHA: {
                                label: 'label.ha.disable',
                                action: function (args) {
                                    var data = {
                                        clusterid: args.context.clusters[0].id
                                    };
                                    $.ajax({
                                        url: createURL("disableHAForCluster"),
                                        data: data,
                                        success: function (json) {
                                            var jid = json.disablehaforclusterresponse.jobid;
                                            args.response.success({
                                                _custom: {
                                                    jobId: jid,
                                                    getActionFilter: function () {
                                                        return clusterActionfilter;
                                                    }
                                                }
                                            });
                                        },
                                        error: function (json) {
                                            args.response.error(parseXMLHttpResponse(json));
                                        }
                                    });
                                },
                                messages: {
                                    confirm: function (args) {
                                        return 'label.ha.disable';
                                    },
                                    notification: function (args) {
                                        return 'label.ha.disable';
                                    }
                                },
                                notification: {
                                    poll: pollAsyncJobResult
                                }
                            }
                        },

                        tabs: {
                            details: {
                                title: 'label.details',
                                fields:[ {
                                    name: {
                                        label: 'label.name'
                                    }
                                },
                                {
                                    id: {
                                        label: 'label.id'
                                    },
                                    zonename: {
                                        label: 'label.zone'
                                    },
                                    podname: {
                                        label: 'label.pod'
                                    },
                                    hypervisortype: {
                                        label: 'label.hypervisor'
                                    },
                                    clustertype: {
                                        label: 'label.cluster.type'
                                    },
                                    //allocationstate: { label: 'label.allocation.state' },
                                    //managedstate: { label: 'Managed State' },
                                    state: {
                                        label: 'label.state'
                                    }
                                }, {
                                    isdedicated: {
                                        label: 'label.dedicated'
                                    },
                                    domainid: {
                                        label: 'label.domain.id'
                                    }
                                }],
                                dataProvider: function (args) {
                                    $.ajax({
                                        url: createURL("listClusters&id=" + args.context.clusters[0].id),
                                        dataType: "json",
                                        success: function (json) {
                                            var item = json.listclustersresponse.cluster[0];
                                            addExtraPropertiesToClusterObject(item);
                                            $.ajax({
                                                url: createURL("listDedicatedClusters&clusterid=" + args.context.clusters[0].id),
                                                dataType: "json",
                                                async: false,
                                                success: function (json) {
                                                    if (json.listdedicatedclustersresponse.dedicatedcluster != undefined) {
                                                        var clusterItem = json.listdedicatedclustersresponse.dedicatedcluster[0];
                                                        if (clusterItem.domainid != null) {
                                                            $.extend(item, clusterItem, {
                                                                isdedicated: _l('label.yes')
                                                            });
                                                        }
                                                    } else
                                                    $.extend(item, {
                                                        isdedicated: _l('label.no')
                                                    })
                                                },
                                                error: function (json) {
                                                    args.response.error(parseXMLHttpResponse(XMLHttpResponse));
                                                }
                                            });
                                            args.response.success({
                                                actionFilter: clusterActionfilter,
                                                data: item
                                            });
                                        },

                                        error: function (json) {
                                            args.response.error(parseXMLHttpResponse(XMLHttpResponse));
                                        }
                                    });
                                }
                            },
                            nexusVswitch: {
                                title: 'label.nexusVswitch',
                                listView: {
                                    id: 'vSwitches',
                                    fields: {
                                        vsmdeviceid: {
                                            label: 'label.name'
                                        },
                                        vsmdevicestate: {
                                            label: 'label.state',
                                            indicator: {
                                                'Enabled': 'on'
                                            }
                                        }
                                    },
                                    detailView: {
                                        actions: {
                                            enable: {
                                                label: 'label.action.enable.nexusVswitch',
                                                messages: {
                                                    confirm: function (args) {
                                                        return 'message.action.enable.nexusVswitch';
                                                    },
                                                    notification: function (args) {
                                                        return 'label.action.enable.nexusVswitch';
                                                    }
                                                },
                                                action: function (args) {
                                                    $.ajax({
                                                        url: createURL("enableCiscoNexusVSM&id=" + args.context.vSwitches[0].vsmdeviceid),
                                                        dataType: "json",
                                                        async: true,
                                                        success: function (json) {
                                                            var jid = json.enablecisconexusvsmresponse.jobid;
                                                            args.response.success({
                                                                _custom: {
                                                                    jobId: jid
                                                                }
                                                            });
                                                            //args.context.vSwitches[0].vsmdevicestate = item.allocationstate;
                                                            //addExtraPropertiesToClusterObject(item);
                                                            args.response.success({
                                                                actionFilter: nexusActionfilter,
                                                                data: item
                                                            });
                                                        }
                                                    });
                                                },
                                                notification: {
                                                    poll: function (args) {
                                                        args.complete();
                                                    }
                                                }
                                            },

                                            disable: {
                                                label: 'label.action.disable.nexusVswitch',
 