/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.network.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageEncoder;
import java.util.List;
import org.apache.celeborn.common.network.protocol.Message;
import org.apache.celeborn.common.network.protocol.MessageWithHeader;
import org.apache.celeborn.common.network.protocol.ResponseMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public final class MessageEncoder
extends MessageToMessageEncoder<Message> {
    private static final Logger logger = LoggerFactory.getLogger(MessageEncoder.class);
    public static final MessageEncoder INSTANCE = new MessageEncoder();

    private MessageEncoder() {
    }

    public void encode(ChannelHandlerContext ctx, Message in, List<Object> out) throws Exception {
        Object body = null;
        int bodyLength = 0;
        if (in.body() != null) {
            try {
                bodyLength = (int)in.body().size();
                body = in.body().convertToNetty();
            }
            catch (Exception e) {
                in.body().release();
                if (!(in instanceof ResponseMessage)) {
                    throw e;
                }
                ResponseMessage resp = (ResponseMessage)in;
                String error = e.getMessage() != null ? e.getMessage() : "null";
                logger.error(String.format("Error processing %s for client %s", in, ctx.channel().remoteAddress()), (Throwable)e);
                this.encode(ctx, resp.createFailureResponse(error), out);
                return;
            }
        }
        Message.Type msgType = in.type();
        int headerLength = 4 + msgType.encodedLength() + 4 + in.encodedLength();
        ByteBuf header = ctx.alloc().heapBuffer(headerLength);
        header.writeInt(in.encodedLength());
        msgType.encode(header);
        header.writeInt(bodyLength);
        in.encode(header);
        assert (header.writableBytes() == 0);
        if (body != null) {
            out.add((Object)new MessageWithHeader(in.body(), header, body, bodyLength));
        } else {
            out.add(header);
        }
    }
}

