/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.client.write;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.LongAdder;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import org.apache.celeborn.client.ShuffleClient;
import org.apache.celeborn.client.write.DataPushQueue;
import org.apache.celeborn.client.write.PushTask;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.exception.CelebornIOException;
import org.apache.celeborn.common.util.ThreadExceptionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataPusher {
    private static final Logger logger = LoggerFactory.getLogger(DataPusher.class);
    private final long WAIT_TIME_NANOS = TimeUnit.MILLISECONDS.toNanos(500L);
    private final LinkedBlockingQueue<PushTask> idleQueue;
    private final DataPushQueue dataPushQueue;
    private final ReentrantLock idleLock = new ReentrantLock();
    private final Condition idleFull = this.idleLock.newCondition();
    private final AtomicReference<IOException> exceptionRef = new AtomicReference();
    private final int shuffleId;
    private final int mapId;
    private final int attemptId;
    private final int numMappers;
    private final int numPartitions;
    private final ShuffleClient client;
    private final Consumer<Integer> afterPush;
    private volatile boolean terminated;
    private final LongAdder[] mapStatusLengths;
    private Thread pushThread;

    public DataPusher(int shuffleId, int mapId, int attemptId, long taskId, int numMappers, int numPartitions, CelebornConf conf, ShuffleClient client, LinkedBlockingQueue<PushTask> pushTasks, Consumer<Integer> afterPush, LongAdder[] mapStatusLengths) throws InterruptedException {
        int pushQueueCapacity = conf.clientPushQueueCapacity();
        int pushBufferMaxSize = conf.clientPushBufferMaxSize();
        this.idleQueue = pushTasks == null ? new LinkedBlockingQueue(pushQueueCapacity) : pushTasks;
        this.dataPushQueue = new DataPushQueue(conf, this, client, shuffleId, mapId, attemptId, numMappers, numPartitions);
        for (int i = this.idleQueue.size(); i < pushQueueCapacity; ++i) {
            this.idleQueue.put(new PushTask(pushBufferMaxSize));
        }
        this.shuffleId = shuffleId;
        this.mapId = mapId;
        this.attemptId = attemptId;
        this.numMappers = numMappers;
        this.numPartitions = numPartitions;
        this.client = client;
        this.afterPush = afterPush;
        this.mapStatusLengths = mapStatusLengths;
        this.pushThread = new Thread("celeborn-client-data-pusher-" + taskId){

            private void reclaimTask(PushTask task) throws InterruptedException {
                DataPusher.this.idleLock.lockInterruptibly();
                try {
                    DataPusher.this.idleQueue.put(task);
                    if (DataPusher.this.idleQueue.remainingCapacity() == 0) {
                        DataPusher.this.idleFull.signal();
                    }
                }
                catch (InterruptedException e) {
                    logger.error("DataPusher thread interrupted while reclaiming data.");
                    throw e;
                }
                finally {
                    DataPusher.this.idleLock.unlock();
                }
            }

            @Override
            public void run() {
                while (DataPusher.this.stillRunning()) {
                    try {
                        ArrayList<PushTask> tasks = DataPusher.this.dataPushQueue.takePushTasks();
                        for (int i = 0; i < tasks.size(); ++i) {
                            PushTask task = tasks.get(i);
                            DataPusher.this.pushData(task);
                            this.reclaimTask(task);
                        }
                    }
                    catch (CelebornIOException e) {
                        DataPusher.this.exceptionRef.set(e);
                    }
                    catch (IOException e) {
                        DataPusher.this.exceptionRef.set(new CelebornIOException(e));
                    }
                    catch (InterruptedException e) {
                        logger.error("DataPusher push thread interrupted while pushing data.");
                        break;
                    }
                }
            }
        };
        this.pushThread.setDaemon(true);
        this.pushThread.setUncaughtExceptionHandler(new ThreadExceptionHandler("DataPusher-" + taskId));
        this.pushThread.start();
    }

    public void addTask(int partitionId, byte[] buffer, int size) throws IOException, InterruptedException {
        try {
            PushTask task = null;
            while (task == null) {
                this.checkException();
                task = this.idleQueue.poll(this.WAIT_TIME_NANOS, TimeUnit.NANOSECONDS);
            }
            task.setSize(size);
            task.setPartitionId(partitionId);
            System.arraycopy(buffer, 0, task.getBuffer(), 0, size);
            while (!this.dataPushQueue.addPushTask(task)) {
                this.checkException();
            }
        }
        catch (InterruptedException e) {
            logger.error("DataPusher thread interrupted while adding push task.");
            this.pushThread.interrupt();
            throw e;
        }
    }

    public void waitOnTermination() throws IOException, InterruptedException {
        try {
            this.idleLock.lockInterruptibly();
            this.waitIdleQueueFullWithLock();
        }
        catch (InterruptedException e) {
            logger.error("DataPusher thread interrupted while waitOnTermination.");
            this.pushThread.interrupt();
            throw e;
        }
        this.terminated = true;
        try {
            this.pushThread.join();
        }
        catch (InterruptedException e) {
            logger.info("Thread interrupted while joining pushThread");
            Thread.currentThread().interrupt();
            throw e;
        }
        this.dataPushQueue.clear();
        this.checkException();
    }

    public void setException(IOException ie) {
        this.exceptionRef.compareAndSet(null, ie);
    }

    public void checkException() throws IOException {
        if (this.exceptionRef.get() != null) {
            throw this.exceptionRef.get();
        }
    }

    protected void pushData(PushTask task) throws IOException {
        int bytesWritten = this.client.pushData(this.shuffleId, this.mapId, this.attemptId, task.getPartitionId(), task.getBuffer(), 0, task.getSize(), this.numMappers, this.numPartitions);
        this.afterPush.accept(bytesWritten);
        this.mapStatusLengths[task.getPartitionId()].add(bytesWritten);
    }

    private void waitIdleQueueFullWithLock() throws InterruptedException {
        try {
            while (this.idleQueue.remainingCapacity() > 0 && this.exceptionRef.get() == null) {
                this.idleFull.await(this.WAIT_TIME_NANOS, TimeUnit.NANOSECONDS);
            }
        }
        catch (InterruptedException e) {
            logger.error("Thread interrupted while waitIdleQueueFullWithLock.", (Throwable)e);
            throw e;
        }
        finally {
            this.idleLock.unlock();
        }
    }

    protected boolean stillRunning() {
        return !this.terminated && !Objects.nonNull(this.exceptionRef.get());
    }

    public DataPushQueue getDataPushQueue() {
        return this.dataPushQueue;
    }

    public LinkedBlockingQueue<PushTask> getIdleQueue() {
        return this.idleQueue;
    }
}

