/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.service.deploy.worker.storage;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Map;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.internal.Logging;
import org.apache.celeborn.common.meta.DeviceInfo;
import org.apache.celeborn.common.meta.DiskInfo;
import org.apache.celeborn.common.metrics.source.AbstractSource;
import org.apache.celeborn.common.util.DiskUtils$;
import org.apache.celeborn.common.util.ThreadUtils$;
import org.apache.celeborn.common.util.Utils$;
import org.apache.celeborn.service.deploy.worker.storage.DeviceMonitor;
import org.apache.celeborn.service.deploy.worker.storage.DeviceObserver;
import org.apache.celeborn.service.deploy.worker.storage.EmptyDeviceMonitor$;
import org.apache.celeborn.service.deploy.worker.storage.LocalDeviceMonitor;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class DeviceMonitor$
implements Logging {
    public static DeviceMonitor$ MODULE$;
    private ThreadPoolExecutor deviceCheckThreadPool;
    private transient Logger log;
    private volatile transient boolean bitmap$trans$0;

    static {
        new DeviceMonitor$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    private Logger log$lzycompute() {
        DeviceMonitor$ deviceMonitor$ = this;
        synchronized (deviceMonitor$) {
            if (!this.bitmap$trans$0) {
                this.log = Logging.log$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.log;
    }

    public Logger log() {
        return !this.bitmap$trans$0 ? this.log$lzycompute() : this.log;
    }

    public ThreadPoolExecutor deviceCheckThreadPool() {
        return this.deviceCheckThreadPool;
    }

    public void deviceCheckThreadPool_$eq(ThreadPoolExecutor x$1) {
        this.deviceCheckThreadPool = x$1;
    }

    public DeviceMonitor createDeviceMonitor(CelebornConf conf, DeviceObserver deviceObserver, Map<String, DeviceInfo> deviceInfos, Map<String, DiskInfo> diskInfos, AbstractSource workerSource) {
        DeviceMonitor deviceMonitor;
        try {
            if (conf.workerDiskMonitorEnabled()) {
                this.deviceCheckThreadPool_$eq(ThreadUtils$.MODULE$.newDaemonCachedThreadPool("worker-device-checker", 5, ThreadUtils$.MODULE$.newDaemonCachedThreadPool$default$3()));
                LocalDeviceMonitor monitor = new LocalDeviceMonitor(conf, deviceObserver, deviceInfos, diskInfos, workerSource);
                monitor.init();
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Device monitor init success");
                deviceMonitor = monitor;
            } else {
                deviceMonitor = EmptyDeviceMonitor$.MODULE$;
            }
        }
        catch (Throwable t) {
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Device monitor init failed.", t);
            throw t;
        }
        return deviceMonitor;
    }

    public DeviceMonitor.DiskUsageInfo getDiskUsageInfos(DiskInfo diskInfo) {
        FileStore dirFile = Files.getFileStore(Paths.get(diskInfo.mountPoint(), new String[0]));
        long totalSpace = dirFile.getTotalSpace();
        long freeSpace = dirFile.getUsableSpace();
        long usedSpace = totalSpace - freeSpace;
        int usedPercent = (int)((double)usedSpace * 100.0 / (double)totalSpace);
        return new DeviceMonitor.DiskUsageInfo(totalSpace, freeSpace, usedSpace, usedPercent);
    }

    public boolean highDiskUsage(CelebornConf conf, DiskInfo diskInfo) {
        return BoxesRunTime.unboxToBoolean((Object)Utils$.MODULE$.tryWithTimeoutAndCallback((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            boolean highDiskUsage;
            block0: {
                DeviceMonitor.DiskUsageInfo usage = MODULE$.getDiskUsageInfos(diskInfo);
                long minimumUsableSize = DiskUtils$.MODULE$.getMinimumUsableSize(diskInfo, conf.workerDiskReserveSize(), conf.workerDiskReserveRatio());
                boolean bl = highDiskUsage = usage.freeSpace() < minimumUsableSize || diskInfo.actualUsableSpace() <= 0L;
                if (!highDiskUsage) break block0;
                MODULE$.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(124).append(diskInfo.mountPoint()).append(" usage is above threshold.").append(" Disk usage(Report by OS):{total:").append(Utils$.MODULE$.bytesToString(usage.totalSpace())).append(",").append(" free:").append(Utils$.MODULE$.bytesToString(usage.freeSpace())).append(", used_percent:").append(usage.usedPercent()).append("} ").append("usage(Report by Celeborn):{").append("total:").append(Utils$.MODULE$.bytesToString(diskInfo.configuredUsableSpace())).append(" free:").append(Utils$.MODULE$.bytesToString(diskInfo.actualUsableSpace())).append(" }").toString());
            }
            return highDiskUsage;
        }, (Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false, this.deviceCheckThreadPool(), conf.workerDiskMonitorStatusCheckTimeout(), new StringBuilder(26).append("Disk: ").append(diskInfo.mountPoint()).append(" Usage Check Timeout").toString()));
    }

    public boolean readWriteError(CelebornConf conf, File dataDir) {
        if (dataDir == null) {
            return false;
        }
        return BoxesRunTime.unboxToBoolean((Object)Utils$.MODULE$.tryWithTimeoutAndCallback((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            boolean bl;
            block5: {
                try {
                    Object object = !dataDir.exists() ? BoxesRunTime.boxToBoolean((boolean)dataDir.mkdirs()) : BoxedUnit.UNIT;
                    File file = new File(dataDir, new StringBuilder(9).append("_SUCCESS_").append(System.currentTimeMillis()).toString());
                    if (!file.exists() && !file.createNewFile()) {
                        bl = true;
                        break block5;
                    }
                    FileUtils.write((File)file, (CharSequence)"test", (Charset)Charset.defaultCharset());
                    FileInputStream fileInputStream = null;
                    InputStreamReader inputStreamReader = null;
                    BufferedReader bufferReader = null;
                    try {
                        fileInputStream = FileUtils.openInputStream((File)file);
                        inputStreamReader = new InputStreamReader((InputStream)fileInputStream, Charset.defaultCharset());
                        bufferReader = new BufferedReader(inputStreamReader);
                        bufferReader.readLine();
                    }
                    catch (Throwable throwable) {
                        Option$.MODULE$.apply(bufferReader).foreach((Function1 & Serializable & scala.Serializable)x$7 -> {
                            x$7.close();
                            return BoxedUnit.UNIT;
                        });
                        Option$.MODULE$.apply((Object)inputStreamReader).foreach((Function1 & Serializable & scala.Serializable)x$8 -> {
                            x$8.close();
                            return BoxedUnit.UNIT;
                        });
                        Option$.MODULE$.apply((Object)fileInputStream).foreach((Function1 & Serializable & scala.Serializable)x$9 -> {
                            x$9.close();
                            return BoxedUnit.UNIT;
                        });
                        throw throwable;
                    }
                    Option$.MODULE$.apply((Object)bufferReader).foreach((Function1 & Serializable & scala.Serializable)x$7 -> {
                        x$7.close();
                        return BoxedUnit.UNIT;
                    });
                    Option$.MODULE$.apply((Object)inputStreamReader).foreach((Function1 & Serializable & scala.Serializable)x$8 -> {
                        x$8.close();
                        return BoxedUnit.UNIT;
                    });
                    Option$.MODULE$.apply((Object)fileInputStream).foreach((Function1 & Serializable & scala.Serializable)x$9 -> {
                        x$9.close();
                        return BoxedUnit.UNIT;
                    });
                    FileUtils.forceDelete((File)file);
                    bl = false;
                }
                catch (Throwable t) {
                    MODULE$.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Disk dir ").append(dataDir).append(" cannot read or write").toString(), t);
                    bl = true;
                }
            }
            return bl;
        }, (Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false, this.deviceCheckThreadPool(), conf.workerDiskMonitorStatusCheckTimeout(), new StringBuilder(31).append("Disk: ").append(dataDir).append(" Read_Write Check Timeout").toString()));
    }

    public DeviceMonitor EmptyMonitor() {
        return EmptyDeviceMonitor$.MODULE$;
    }

    private DeviceMonitor$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

