/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.server.common.http;

import java.io.Serializable;
import java.net.URL;
import java.util.Locale;
import org.apache.celeborn.server.common.HttpService;
import org.apache.celeborn.server.common.Service$;
import org.apache.celeborn.server.common.http.Applications$;
import org.apache.celeborn.server.common.http.Conf$;
import org.apache.celeborn.server.common.http.Exclude$;
import org.apache.celeborn.server.common.http.ExcludedWorkers$;
import org.apache.celeborn.server.common.http.Exit$;
import org.apache.celeborn.server.common.http.Help$;
import org.apache.celeborn.server.common.http.Hostnames$;
import org.apache.celeborn.server.common.http.HttpEndpoint;
import org.apache.celeborn.server.common.http.Invalid$;
import org.apache.celeborn.server.common.http.IsRegistered$;
import org.apache.celeborn.server.common.http.IsShutdown$;
import org.apache.celeborn.server.common.http.ListPartitionLocationInfo$;
import org.apache.celeborn.server.common.http.ListTopDiskUsedApps$;
import org.apache.celeborn.server.common.http.LostWorkers$;
import org.apache.celeborn.server.common.http.MasterGroupInfo$;
import org.apache.celeborn.server.common.http.Shuffles$;
import org.apache.celeborn.server.common.http.ShutdownWorkers$;
import org.apache.celeborn.server.common.http.ThreadDump$;
import org.apache.celeborn.server.common.http.UnavailablePeers$;
import org.apache.celeborn.server.common.http.WorkerInfo$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class HttpUtils$ {
    public static HttpUtils$ MODULE$;
    private final List<HttpEndpoint> baseEndpoints;
    private final List<HttpEndpoint> masterEndpoints;
    private final List<HttpEndpoint> workerEndpoints;

    static {
        new HttpUtils$();
    }

    private List<HttpEndpoint> baseEndpoints() {
        return this.baseEndpoints;
    }

    private List<HttpEndpoint> masterEndpoints() {
        return this.masterEndpoints;
    }

    private List<HttpEndpoint> workerEndpoints() {
        return this.workerEndpoints;
    }

    public Tuple2<String, Map<String, String>> parseUri(String uri) {
        URL url = new URL(new java.lang.StringBuilder(22).append("https://127.0.0.1:9000").append(uri).toString());
        Map parameter = url.getQuery() == null ? Predef$.MODULE$.Map().empty() : new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])url.getQuery().split("&"))).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.split("="), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)))))).map((Function1 & Serializable & scala.Serializable)arr -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)arr[0].toUpperCase(Locale.ROOT)), (Object)arr[1]), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
        return new Tuple2((Object)url.getPath(), (Object)parameter);
    }

    public String handleRequest(HttpService service, String path, Map<String, String> parameters) {
        return ((HttpEndpoint)this.endpoints(service.serviceName()).find((Function1 & Serializable & scala.Serializable)endpoint -> BoxesRunTime.boxToBoolean((boolean)HttpUtils$.$anonfun$handleRequest$1(path, endpoint))).orElse((Function0 & Serializable & scala.Serializable)() -> new Some((Object)Invalid$.MODULE$)).get()).handle(service, parameters);
    }

    public String help(String service) {
        StringBuilder sb = new StringBuilder();
        sb.append("Available API providers include:\n");
        List<HttpEndpoint> httpEndpoints = this.endpoints(service);
        int maxLength = BoxesRunTime.unboxToInt((Object)((TraversableOnce)httpEndpoints.map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)HttpUtils$.$anonfun$help$1(x$2)), List$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Int$.MODULE$));
        ((List)httpEndpoints.sortBy((Function1 & Serializable & scala.Serializable)x$3 -> x$3.path(), (Ordering)Ordering.String$.MODULE$)).foreach((Function1 & Serializable & scala.Serializable)endpoint -> sb.append(new java.lang.StringBuilder(2).append(((TraversableOnce)new StringOps(Predef$.MODULE$.augmentString(endpoint.path())).padTo(maxLength, (Object)" ", Predef$.MODULE$.fallbackStringCanBuildFrom())).mkString()).append(" ").append(endpoint.description(service)).append("\n").toString()));
        return sb.toString();
    }

    private List<HttpEndpoint> endpoints(String service) {
        String string = service;
        String string2 = Service$.MODULE$.MASTER();
        return !(string != null ? !string.equals(string2) : string2 != null) ? this.masterEndpoints() : this.workerEndpoints();
    }

    public static final /* synthetic */ boolean $anonfun$handleRequest$1(String path$1, HttpEndpoint endpoint) {
        String string = endpoint.path();
        String string2 = path$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ int $anonfun$help$1(HttpEndpoint x$2) {
        return x$2.path().length();
    }

    private HttpUtils$() {
        MODULE$ = this;
        this.baseEndpoints = new .colon.colon((Object)Conf$.MODULE$, (List)new .colon.colon((Object)WorkerInfo$.MODULE$, (List)new .colon.colon((Object)ThreadDump$.MODULE$, (List)new .colon.colon((Object)Shuffles$.MODULE$, (List)new .colon.colon((Object)Applications$.MODULE$, (List)new .colon.colon((Object)ListTopDiskUsedApps$.MODULE$, (List)new .colon.colon((Object)Help$.MODULE$, (List)Nil$.MODULE$)))))));
        this.masterEndpoints = (List)new .colon.colon((Object)MasterGroupInfo$.MODULE$, (List)new .colon.colon((Object)LostWorkers$.MODULE$, (List)new .colon.colon((Object)ExcludedWorkers$.MODULE$, (List)new .colon.colon((Object)ShutdownWorkers$.MODULE$, (List)new .colon.colon((Object)Hostnames$.MODULE$, (List)new .colon.colon((Object)Exclude$.MODULE$, (List)Nil$.MODULE$)))))).$plus$plus(this.baseEndpoints(), List$.MODULE$.canBuildFrom());
        this.workerEndpoints = (List)new .colon.colon((Object)ListPartitionLocationInfo$.MODULE$, (List)new .colon.colon((Object)UnavailablePeers$.MODULE$, (List)new .colon.colon((Object)IsShutdown$.MODULE$, (List)new .colon.colon((Object)IsRegistered$.MODULE$, (List)new .colon.colon((Object)Exit$.MODULE$, (List)Nil$.MODULE$))))).$plus$plus(this.baseEndpoints(), List$.MODULE$.canBuildFrom());
    }
}

