/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.shuffle.celeborn;

import org.apache.celeborn.client.LifecycleManager;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.CelebornConf$;
import org.apache.celeborn.common.internal.Logging;
import org.apache.celeborn.common.internal.Logging$class;
import org.apache.celeborn.common.internal.config.ConfigEntry;
import org.apache.celeborn.common.protocol.PbCheckWorkersAvailableResponse;
import org.apache.celeborn.common.protocol.message.ControlMessages;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001-3A!\u0001\u0002\u0001\u001b\t\u00193)\u001a7fE>\u0014hn\u00155vM\u001adWMR1mY\n\f7m\u001b)pY&\u001c\u0017PU;o]\u0016\u0014(BA\u0002\u0005\u0003!\u0019W\r\\3c_Jt'BA\u0003\u0007\u0003\u001d\u0019\b.\u001e4gY\u0016T!a\u0002\u0005\u0002\u000bM\u0004\u0018M]6\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\u0002\u0001'\r\u0001a\u0002\u0006\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0002#\u0005)1oY1mC&\u00111\u0003\u0005\u0002\u0007\u0003:L(+\u001a4\u0011\u0005UYR\"\u0001\f\u000b\u0005]A\u0012\u0001C5oi\u0016\u0014h.\u00197\u000b\u0005eQ\u0012AB2p[6|gN\u0003\u0002\u0004\u0011%\u0011AD\u0006\u0002\b\u0019><w-\u001b8h\u0011!q\u0002A!A!\u0002\u0013y\u0012\u0001B2p]\u001a\u0004\"\u0001I\u0011\u000e\u0003aI!A\t\r\u0003\u0019\r+G.\u001a2pe:\u001cuN\u001c4\t\u000b\u0011\u0002A\u0011A\u0013\u0002\rqJg.\u001b;?)\t1\u0003\u0006\u0005\u0002(\u00015\t!\u0001C\u0003\u001fG\u0001\u0007q\u0004C\u0003+\u0001\u0011\u00051&\u0001\fbaBd\u00170\u00117m\r\u0006dGNY1dWB{G.[2z)\rasf\u000e\t\u0003\u001f5J!A\f\t\u0003\u000f\t{w\u000e\\3b]\")\u0001'\u000ba\u0001c\u0005\u0001B.\u001b4fGf\u001cG.Z'b]\u0006<WM\u001d\t\u0003eUj\u0011a\r\u0006\u0003ii\taa\u00197jK:$\u0018B\u0001\u001c4\u0005Aa\u0015NZ3ds\u000edW-T1oC\u001e,'\u000fC\u00039S\u0001\u0007\u0011(A\u0007ok6\u0004\u0016M\u001d;ji&|gn\u001d\t\u0003\u001fiJ!a\u000f\t\u0003\u0007%sG\u000fC\u0003>\u0001\u0011\u0005a(\u0001\rbaBd\u0017PR8sG\u00164\u0015\r\u001c7cC\u000e\\\u0007k\u001c7jGf$\u0012\u0001\f\u0005\u0006\u0001\u0002!\t!Q\u0001%CB\u0004H._*ik\u001a4G.\u001a)beRLG/[8og\u001a\u000bG\u000e\u001c2bG.\u0004v\u000e\\5dsR\u0011AF\u0011\u0005\u0006q}\u0002\r!\u000f\u0005\u0006\t\u0002!\t!R\u0001\u000bG\",7m[)v_R\fGC\u0001\u0017G\u0011\u0015\u00014\t1\u00012\u0011\u0015A\u0005\u0001\"\u0001J\u0003U\u0019\u0007.Z2l/>\u00148.\u001a:t\u0003Z\f\u0017\u000e\\1cY\u0016$\"\u0001\f&\t\u000bA:\u0005\u0019A\u0019")
public class CelebornShuffleFallbackPolicyRunner
implements Logging {
    private final CelebornConf conf;
    private final transient Logger log;
    private volatile transient boolean bitmap$trans$0;

    private Logger log$lzycompute() {
        CelebornShuffleFallbackPolicyRunner celebornShuffleFallbackPolicyRunner = this;
        synchronized (celebornShuffleFallbackPolicyRunner) {
            if (!this.bitmap$trans$0) {
                this.log = Logging$class.log(this);
                this.bitmap$trans$0 = true;
            }
            return this.log;
        }
    }

    @Override
    public Logger log() {
        return this.bitmap$trans$0 ? this.log : this.log$lzycompute();
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    public boolean applyAllFallbackPolicy(LifecycleManager lifecycleManager, int numPartitions) {
        return this.applyForceFallbackPolicy() || this.applyShufflePartitionsFallbackPolicy(numPartitions) || !this.checkQuota(lifecycleManager) || !this.checkWorkersAvailable(lifecycleManager);
    }

    public boolean applyForceFallbackPolicy() {
        if (this.conf.shuffleForceFallbackEnabled()) {
            ConfigEntry<Object> conf = CelebornConf$.MODULE$.SPARK_SHUFFLE_FORCE_FALLBACK_ENABLED();
            this.logWarning((Function0<String>)new Serializable(this, conf){
                public static final long serialVersionUID = 0L;
                private final ConfigEntry conf$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is enabled, which will force fallback."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.conf$1.alternatives().foldLeft((Object)this.conf$1.key(), (Function2)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(String x, Tuple2<String, Function1<String, String>> y) {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " or ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{x, y}));
                        }
                    })}));
                }
                {
                    this.conf$1 = conf$1;
                }
            });
        }
        return this.conf.shuffleForceFallbackEnabled();
    }

    public boolean applyShufflePartitionsFallbackPolicy(int numPartitions) {
        boolean needFallback;
        long confNumPartitions = this.conf.shuffleForceFallbackPartitionThreshold();
        boolean bl = needFallback = (long)numPartitions >= confNumPartitions;
        if (needFallback) {
            this.logWarning((Function0<String>)new Serializable(this, numPartitions, confNumPartitions){
                public static final long serialVersionUID = 0L;
                private final int numPartitions$1;
                private final long confNumPartitions$1;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Shuffle num of partitions: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.numPartitions$1)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" is bigger than the limit: ", ","})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.confNumPartitions$1)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" need fallback to spark shuffle"})).s((Seq)Nil$.MODULE$)).toString();
                }
                {
                    this.numPartitions$1 = numPartitions$1;
                    this.confNumPartitions$1 = confNumPartitions$1;
                }
            });
        }
        return needFallback;
    }

    public boolean checkQuota(LifecycleManager lifecycleManager) {
        if (this.conf.quotaEnabled()) {
            ControlMessages.CheckQuotaResponse resp = lifecycleManager.checkQuota();
            if (!resp.isAvailable()) {
                this.logWarning((Function0<String>)new Serializable(this, lifecycleManager, resp){
                    public static final long serialVersionUID = 0L;
                    private final LifecycleManager lifecycleManager$1;
                    private final ControlMessages.CheckQuotaResponse resp$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Quota exceed for current user ", ". Because: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.lifecycleManager$1.getUserIdentifier(), this.resp$1.reason()}));
                    }
                    {
                        this.lifecycleManager$1 = lifecycleManager$1;
                        this.resp$1 = resp$1;
                    }
                });
            }
            return resp.isAvailable();
        }
        return true;
    }

    public boolean checkWorkersAvailable(LifecycleManager lifecycleManager) {
        PbCheckWorkersAvailableResponse resp = lifecycleManager.checkWorkersAvailable();
        if (!resp.getAvailable()) {
            this.logWarning((Function0<String>)new Serializable(this, lifecycleManager){
                public static final long serialVersionUID = 0L;
                private final LifecycleManager lifecycleManager$2;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"No workers available for current user ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.lifecycleManager$2.getUserIdentifier()}));
                }
                {
                    this.lifecycleManager$2 = lifecycleManager$2;
                }
            });
        }
        return resp.getAvailable();
    }

    public CelebornShuffleFallbackPolicyRunner(CelebornConf conf) {
        this.conf = conf;
        Logging$class.$init$(this);
    }
}

