/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.logaggregation.filecontroller;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.shaded.com.google.common.base.Predicate;
import org.apache.hadoop.shaded.com.google.common.collect.Iterables;
import org.apache.hadoop.shaded.com.google.common.collect.Sets;
import org.apache.hadoop.shaded.org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.logaggregation.AggregatedLogFormat;
import org.apache.hadoop.yarn.logaggregation.ContainerLogMeta;
import org.apache.hadoop.yarn.logaggregation.ContainerLogsRequest;
import org.apache.hadoop.yarn.logaggregation.LogAggregationUtils;
import org.apache.hadoop.yarn.logaggregation.filecontroller.LogAggregationDFSException;
import org.apache.hadoop.yarn.logaggregation.filecontroller.LogAggregationFileControllerContext;
import org.apache.hadoop.yarn.webapp.View;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public abstract class LogAggregationFileController {
    private static final Logger LOG = LoggerFactory.getLogger(LogAggregationFileController.class);
    protected static final FsPermission TLDIR_PERMISSIONS = FsPermission.createImmutable((short)1023);
    protected static final FsPermission APP_DIR_PERMISSIONS = FsPermission.createImmutable((short)504);
    protected static final FsPermission APP_LOG_FILE_UMASK = FsPermission.createImmutable((short)95);
    public static final String LOG_AGGREGATION_FS_SUPPORT_APPEND = "yarn.log-aggregation.fs-support-append";
    protected Configuration conf;
    protected Path remoteRootLogDir;
    protected String remoteRootLogDirSuffix;
    protected int retentionSize;
    protected String fileControllerName;
    protected boolean fsSupportsChmod = true;

    public void initialize(Configuration conf, String controllerName) {
        this.conf = conf;
        int configuredRetentionSize = conf.getInt("yarn.nodemanager.log-aggregation.num-log-files-per-app", 30);
        this.retentionSize = configuredRetentionSize <= 0 ? 30 : configuredRetentionSize;
        this.fileControllerName = controllerName;
        this.extractRemoteRootLogDir();
        this.extractRemoteRootLogDirSuffix();
        this.initInternal(conf);
    }

    protected abstract void initInternal(Configuration var1);

    public Path getRemoteRootLogDir() {
        return this.remoteRootLogDir;
    }

    public String getRemoteRootLogDirSuffix() {
        return this.remoteRootLogDirSuffix;
    }

    public abstract void initializeWriter(LogAggregationFileControllerContext var1) throws IOException;

    public abstract void closeWriter() throws LogAggregationDFSException;

    public abstract void write(AggregatedLogFormat.LogKey var1, AggregatedLogFormat.LogValue var2) throws IOException;

    public abstract void postWrite(LogAggregationFileControllerContext var1) throws Exception;

    protected void closePrintStream(OutputStream out) {
        if (out != System.out) {
            IOUtils.cleanupWithLogger(LOG, out);
        }
    }

    public abstract boolean readAggregatedLogs(ContainerLogsRequest var1, OutputStream var2) throws IOException;

    public abstract List<ContainerLogMeta> readAggregatedLogsMeta(ContainerLogsRequest var1) throws IOException;

    public abstract void renderAggregatedLogsBlock(HtmlBlock.Block var1, View.ViewContext var2);

    public abstract String getApplicationOwner(Path var1, ApplicationId var2) throws IOException;

    public abstract Map<ApplicationAccessType, String> getApplicationAcls(Path var1, ApplicationId var2) throws IOException;

    private void extractRemoteRootLogDirSuffix() {
        String suffix = String.format("yarn.log-aggregation.%s.remote-app-log-dir-suffix", this.fileControllerName);
        this.remoteRootLogDirSuffix = this.conf.get(suffix);
        if (this.remoteRootLogDirSuffix == null || this.remoteRootLogDirSuffix.isEmpty()) {
            this.remoteRootLogDirSuffix = this.conf.get("yarn.nodemanager.remote-app-log-dir-suffix", "logs") + "-" + this.fileControllerName.toLowerCase();
        }
    }

    private void extractRemoteRootLogDir() {
        String remoteDirStr = String.format("yarn.log-aggregation.%s.remote-app-log-dir", this.fileControllerName);
        String remoteDir = this.conf.get(remoteDirStr);
        if (remoteDir == null || remoteDir.isEmpty()) {
            remoteDir = this.conf.get("yarn.nodemanager.remote-app-log-dir", "/tmp/logs");
        }
        this.remoteRootLogDir = new Path(remoteDir);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void verifyAndCreateRemoteLogDir() {
        FileSystem remoteFS = null;
        try {
            remoteFS = this.getFileSystem(this.conf);
        }
        catch (IOException e) {
            throw new YarnRuntimeException("Unable to get Remote FileSystem instance", e);
        }
        boolean remoteExists = true;
        Path remoteRootLogDir = this.getRemoteRootLogDir();
        try {
            FsPermission perms = remoteFS.getFileStatus(remoteRootLogDir).getPermission();
            if (!perms.equals(TLDIR_PERMISSIONS)) {
                LOG.warn("Remote Root Log Dir [" + remoteRootLogDir + "] already exist, but with incorrect permissions. Expected: [" + TLDIR_PERMISSIONS + "], Found: [" + perms + "]. The cluster may have problems with multiple users.");
            }
        }
        catch (FileNotFoundException e) {
            remoteExists = false;
        }
        catch (IOException e) {
            throw new YarnRuntimeException("Failed to check permissions for dir [" + remoteRootLogDir + "]", e);
        }
        Path qualified = remoteRootLogDir.makeQualified(remoteFS.getUri(), remoteFS.getWorkingDirectory());
        if (!remoteExists) {
            LOG.warn("Remote Root Log Dir [" + remoteRootLogDir + "] does not exist. Attempting to create it.");
            try {
                remoteFS.mkdirs(qualified, new FsPermission(TLDIR_PERMISSIONS));
                try {
                    remoteFS.setPermission(qualified, new FsPermission(TLDIR_PERMISSIONS));
                }
                catch (UnsupportedOperationException use) {
                    LOG.info("Unable to set permissions for configured filesystem since it does not support this", (Object)remoteFS.getScheme());
                    this.fsSupportsChmod = false;
                }
                UserGroupInformation loginUser = UserGroupInformation.getLoginUser();
                String primaryGroupName = null;
                try {
                    primaryGroupName = loginUser.getPrimaryGroupName();
                }
                catch (IOException e) {
                    LOG.warn("No primary group found. The remote root log directory will be created with the HDFS superuser being its group owner. JobHistoryServer may be unable to read the directory.");
                }
                if (primaryGroupName == null) return;
                try {
                    remoteFS.setOwner(qualified, loginUser.getShortUserName(), primaryGroupName);
                    return;
                }
                catch (UnsupportedOperationException use) {
                    LOG.info("File System does not support setting user/group" + remoteFS.getScheme(), (Throwable)use);
                }
                return;
            }
            catch (IOException e) {
                throw new YarnRuntimeException("Failed to create remoteLogDir [" + remoteRootLogDir + "]", e);
            }
        }
        try {
            remoteFS.setPermission(qualified, new FsPermission(TLDIR_PERMISSIONS));
            return;
        }
        catch (UnsupportedOperationException use) {
            LOG.info("Unable to set permissions for configured filesystem since it does not support this", (Object)remoteFS.getScheme());
            this.fsSupportsChmod = false;
            return;
        }
        catch (IOException e) {
            LOG.warn("Failed to check if FileSystem suppports permissions on remoteLogDir [" + remoteRootLogDir + "]", (Throwable)e);
        }
    }

    public void createAppDir(final String user, final ApplicationId appId, UserGroupInformation userUgi) {
        final Path remoteRootLogDir = this.getRemoteRootLogDir();
        final String remoteRootLogDirSuffix = this.getRemoteRootLogDirSuffix();
        try {
            userUgi.doAs(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    try {
                        FileSystem remoteFS = LogAggregationFileController.this.getFileSystem(LogAggregationFileController.this.conf);
                        Path appDir = LogAggregationUtils.getRemoteAppLogDir(remoteRootLogDir, appId, user, remoteRootLogDirSuffix);
                        appDir = appDir.makeQualified(remoteFS.getUri(), remoteFS.getWorkingDirectory());
                        if (!LogAggregationFileController.this.checkExists(remoteFS, appDir, APP_DIR_PERMISSIONS)) {
                            Path suffixDir = LogAggregationUtils.getRemoteLogSuffixedDir(remoteRootLogDir, user, remoteRootLogDirSuffix);
                            if (!LogAggregationFileController.this.checkExists(remoteFS, suffixDir = suffixDir.makeQualified(remoteFS.getUri(), remoteFS.getWorkingDirectory()), APP_DIR_PERMISSIONS)) {
                                Path userDir = LogAggregationUtils.getRemoteLogUserDir(remoteRootLogDir, user);
                                if (!LogAggregationFileController.this.checkExists(remoteFS, userDir = userDir.makeQualified(remoteFS.getUri(), remoteFS.getWorkingDirectory()), APP_DIR_PERMISSIONS)) {
                                    LogAggregationFileController.this.createDir(remoteFS, userDir, APP_DIR_PERMISSIONS);
                                }
                                LogAggregationFileController.this.createDir(remoteFS, suffixDir, APP_DIR_PERMISSIONS);
                            }
                            LogAggregationFileController.this.createDir(remoteFS, appDir, APP_DIR_PERMISSIONS);
                        }
                    }
                    catch (IOException e) {
                        LOG.error("Failed to setup application log directory for " + appId, (Throwable)e);
                        throw e;
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            if (e instanceof RemoteException) {
                throw new YarnRuntimeException(((RemoteException)e).unwrapRemoteException(SecretManager.InvalidToken.class));
            }
            throw new YarnRuntimeException(e);
        }
    }

    @VisibleForTesting
    protected FileSystem getFileSystem(Configuration conf) throws IOException {
        return this.getRemoteRootLogDir().getFileSystem(conf);
    }

    protected void createDir(FileSystem fs, Path path, FsPermission fsPerm) throws IOException {
        if (this.fsSupportsChmod) {
            FsPermission dirPerm = new FsPermission(fsPerm);
            fs.mkdirs(path, dirPerm);
            FsPermission umask = FsPermission.getUMask(fs.getConf());
            if (!dirPerm.equals(dirPerm.applyUMask(umask))) {
                fs.setPermission(path, new FsPermission(fsPerm));
            }
        } else {
            fs.mkdirs(path);
        }
    }

    protected boolean checkExists(FileSystem fs, Path path, FsPermission fsPerm) throws IOException {
        boolean exists = true;
        try {
            FileStatus appDirStatus = fs.getFileStatus(path);
            if (this.fsSupportsChmod && !APP_DIR_PERMISSIONS.equals(appDirStatus.getPermission())) {
                fs.setPermission(path, APP_DIR_PERMISSIONS);
            }
        }
        catch (FileNotFoundException fnfe) {
            exists = false;
        }
        return exists;
    }

    public Path getRemoteNodeLogFileForApp(ApplicationId appId, String user, NodeId nodeId) {
        return LogAggregationUtils.getRemoteNodeLogFileForApp(this.getRemoteRootLogDir(), appId, user, nodeId, this.getRemoteRootLogDirSuffix());
    }

    public Path getRemoteAppLogDir(ApplicationId appId, String appOwner) throws IOException {
        return LogAggregationUtils.getRemoteAppLogDir(this.conf, appId, appOwner, this.remoteRootLogDir, this.remoteRootLogDirSuffix);
    }

    protected void cleanOldLogs(Path remoteNodeLogFileForApp, final NodeId nodeId, UserGroupInformation userUgi) {
        try {
            final FileSystem remoteFS = remoteNodeLogFileForApp.getFileSystem(this.conf);
            Path appDir = remoteNodeLogFileForApp.getParent().makeQualified(remoteFS.getUri(), remoteFS.getWorkingDirectory());
            HashSet status = new HashSet(Arrays.asList(remoteFS.listStatus(appDir)));
            Iterable mask = Iterables.filter(status, (Predicate)new Predicate<FileStatus>(){

                public boolean apply(FileStatus next) {
                    return next.getPath().getName().contains(LogAggregationUtils.getNodeString(nodeId)) && !next.getPath().getName().endsWith(".tmp");
                }
            });
            status = Sets.newHashSet((Iterable)mask);
            if (status.size() >= this.retentionSize) {
                ArrayList statusList = new ArrayList(status);
                Collections.sort(statusList, new Comparator<FileStatus>(){

                    @Override
                    public int compare(FileStatus s1, FileStatus s2) {
                        return s1.getModificationTime() < s2.getModificationTime() ? -1 : (s1.getModificationTime() > s2.getModificationTime() ? 1 : 0);
                    }
                });
                for (int i = 0; i <= statusList.size() - this.retentionSize; ++i) {
                    final FileStatus remove = (FileStatus)statusList.get(i);
                    try {
                        userUgi.doAs(new PrivilegedExceptionAction<Object>(){

                            @Override
                            public Object run() throws Exception {
                                remoteFS.delete(remove.getPath(), false);
                                return null;
                            }
                        });
                        continue;
                    }
                    catch (Exception e) {
                        LOG.error("Failed to delete " + remove.getPath(), (Throwable)e);
                    }
                }
            }
        }
        catch (Exception e) {
            LOG.error("Failed to clean old logs", (Throwable)e);
        }
    }

    protected String aggregatedLogSuffix(String fileName) {
        StringBuilder sb = new StringBuilder();
        String endOfFile = "End of LogType:" + fileName;
        sb.append("\n" + endOfFile + "\n");
        sb.append(StringUtils.repeat((String)"*", (int)(endOfFile.length() + 50)) + "\n\n");
        return sb.toString();
    }

    public boolean isFsSupportsChmod() {
        return this.fsSupportsChmod;
    }
}

