/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.client;

import java.io.Serializable;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.internal.Logging;
import org.apache.celeborn.common.protocol.PartitionLocation;
import org.apache.celeborn.common.protocol.PbChangeLocationPartitionInfo;
import org.apache.celeborn.common.protocol.PbChangeLocationResponse;
import org.apache.celeborn.common.protocol.PbPartitionSplit;
import org.apache.celeborn.common.protocol.message.StatusCode;
import org.apache.celeborn.common.rpc.RpcEndpointRef;
import org.apache.celeborn.common.util.PbSerDeUtils$;
import org.apache.celeborn.common.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

public final class ShuffleClientHelper$
implements Logging {
    public static ShuffleClientHelper$ MODULE$;
    private transient Logger log;
    private volatile transient boolean bitmap$trans$0;

    static {
        new ShuffleClientHelper$();
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    private Logger log$lzycompute() {
        ShuffleClientHelper$ shuffleClientHelper$ = this;
        synchronized (shuffleClientHelper$) {
            if (!this.bitmap$trans$0) {
                this.log = Logging.log$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.log;
    }

    @Override
    public Logger log() {
        return !this.bitmap$trans$0 ? this.log$lzycompute() : this.log;
    }

    public void sendShuffleSplitAsync(RpcEndpointRef endpointRef, CelebornConf conf, PbPartitionSplit req, ExecutorService executors, Set<Integer> splittingSet, int partitionId, int shuffleId, ConcurrentHashMap<Integer, PartitionLocation> shuffleLocs) {
        endpointRef.ask(req, conf.clientRpcRequestPartitionLocationRpcAskTimeout(), ClassTag$.MODULE$.apply(PbChangeLocationResponse.class)).onComplete((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Object object;
            Try try_ = x0$1;
            if (try_ instanceof Success) {
                PartitionLocation partitionLocation;
                StatusCode respStatus;
                Success success = (Success)try_;
                PbChangeLocationResponse resp = (PbChangeLocationResponse)success.value();
                PbChangeLocationPartitionInfo partitionInfo = resp.getPartitionInfo(0);
                StatusCode statusCode = respStatus = Utils$.MODULE$.toStatusCode(partitionInfo.getStatus());
                StatusCode statusCode2 = StatusCode.SUCCESS;
                if (!(statusCode != null ? !((Object)((Object)statusCode)).equals((Object)statusCode2) : statusCode2 != null)) {
                    partitionLocation = shuffleLocs.put(Predef$.MODULE$.int2Integer(partitionId), PbSerDeUtils$.MODULE$.fromPbPartitionLocation(partitionInfo.getPartition()));
                } else {
                    StatusCode statusCode3 = respStatus;
                    StatusCode statusCode4 = StatusCode.STAGE_ENDED;
                    if (!(statusCode3 != null ? !((Object)((Object)statusCode3)).equals((Object)statusCode4) : statusCode4 != null)) {
                        MODULE$.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(16).append("Stage ended for ").append(shuffleId).toString());
                    } else {
                        MODULE$.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(76).append("split failed for ").append((Object)respStatus).append(", ").append("shuffle file can be larger than expected, try split again").toString());
                    }
                    partitionLocation = BoxedUnit.UNIT;
                }
                object = BoxesRunTime.boxToBoolean((boolean)splittingSet.remove(BoxesRunTime.boxToInteger((int)partitionId)));
            } else if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable exception = failure.exception();
                splittingSet.remove(BoxesRunTime.boxToInteger((int)partitionId));
                MODULE$.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(71).append("Shuffle file split failed for map ").append(shuffleId).append(" partitionId ").append(partitionId).append(",").append(" try again, detail : {}").toString(), exception);
                object = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)try_);
            }
            return object;
        }, (ExecutionContext)ExecutionContext$.MODULE$.fromExecutorService(executors));
    }

    private ShuffleClientHelper$() {
        MODULE$ = this;
        Logging.$init$(this);
    }
}

