/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client.api;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.service.CompositeService;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public abstract class AppAdminClient
extends CompositeService {
    public static final String YARN_APP_ADMIN_CLIENT_PREFIX = "yarn.application.admin.client.class.";
    public static final String DEFAULT_TYPE = "yarn-service";
    public static final String DEFAULT_CLASS_NAME = "org.apache.hadoop.yarn.service.client.ApiServiceClient";
    public static final String UNIT_TEST_TYPE = "unit-test";
    public static final String UNIT_TEST_CLASS_NAME = "org.apache.hadoop.yarn.service.client.ServiceClient";

    @InterfaceAudience.Private
    protected AppAdminClient() {
        super(AppAdminClient.class.getName());
    }

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public static AppAdminClient createAppAdminClient(String appType, Configuration conf) {
        Class<?> clientClass;
        Map<String, String> clientClassMap = conf.getPropsWithPrefix(YARN_APP_ADMIN_CLIENT_PREFIX);
        if (!clientClassMap.containsKey(DEFAULT_TYPE)) {
            clientClassMap.put(DEFAULT_TYPE, DEFAULT_CLASS_NAME);
        }
        if (!clientClassMap.containsKey(UNIT_TEST_TYPE)) {
            clientClassMap.put(UNIT_TEST_TYPE, UNIT_TEST_CLASS_NAME);
        }
        if (!clientClassMap.containsKey(appType)) {
            throw new IllegalArgumentException("App admin client class name not specified for type " + appType);
        }
        String clientClassName = clientClassMap.get(appType);
        try {
            clientClass = Class.forName(clientClassName);
        }
        catch (ClassNotFoundException e) {
            throw new YarnRuntimeException("Invalid app admin client class", e);
        }
        AppAdminClient appAdminClient = (AppAdminClient)ReflectionUtils.newInstance(clientClass, conf);
        appAdminClient.init(conf);
        appAdminClient.start();
        return appAdminClient;
    }

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract int actionLaunch(String var1, String var2, Long var3, String var4) throws IOException, YarnException;

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract int actionStop(String var1) throws IOException, YarnException;

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract int actionStart(String var1) throws IOException, YarnException;

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract int actionSave(String var1, String var2, Long var3, String var4) throws IOException, YarnException;

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract int actionDestroy(String var1) throws IOException, YarnException;

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract int actionFlex(String var1, Map<String, String> var2) throws IOException, YarnException;

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract int enableFastLaunch(String var1) throws IOException, YarnException;

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract String getStatusString(String var1) throws IOException, YarnException;

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract int initiateUpgrade(String var1, String var2, boolean var3) throws IOException, YarnException;

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract int actionUpgradeInstances(String var1, List<String> var2) throws IOException, YarnException;

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract int actionUpgradeComponents(String var1, List<String> var2) throws IOException, YarnException;

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract int actionCleanUp(String var1, String var2) throws IOException, YarnException;

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract String getInstances(String var1, List<String> var2, String var3, List<String> var4) throws IOException, YarnException;

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract int actionUpgradeExpress(String var1, File var2) throws IOException, YarnException;

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract int actionCancelUpgrade(String var1) throws IOException, YarnException;

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract int actionDecommissionInstances(String var1, List<String> var2) throws IOException, YarnException;
}

