/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.plugin.flink;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.apache.celeborn.client.LifecycleManager;
import org.apache.celeborn.client.listener.WorkerStatusListener;
import org.apache.celeborn.client.listener.WorkersStatus;
import org.apache.celeborn.common.meta.ShufflePartitionLocationInfo;
import org.apache.celeborn.common.meta.WorkerInfo;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.shuffle.JobShuffleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShuffleResourceTracker
implements WorkerStatusListener {
    private static final Logger LOG = LoggerFactory.getLogger(ShuffleResourceTracker.class);
    private final ExecutorService executorService;
    private final LifecycleManager lifecycleManager;
    private final Map<JobID, JobShuffleResourceListener> shuffleResourceListeners = new ConcurrentHashMap<JobID, JobShuffleResourceListener>();
    private static final int MAX_RETRY_TIMES = 3;

    public ShuffleResourceTracker(ExecutorService executorService, LifecycleManager lifecycleManager) {
        this.executorService = executorService;
        this.lifecycleManager = lifecycleManager;
        lifecycleManager.registerWorkerStatusListener(this);
    }

    public void registerJob(JobShuffleContext jobShuffleContext) {
        this.shuffleResourceListeners.put(jobShuffleContext.getJobId(), new JobShuffleResourceListener(jobShuffleContext, this.executorService));
    }

    public void addPartitionResource(JobID jobId, int shuffleId, int partitionId, ResultPartitionID partitionID) {
        JobShuffleResourceListener shuffleResourceListener = this.shuffleResourceListeners.get(jobId);
        shuffleResourceListener.addPartitionResource(shuffleId, partitionId, partitionID);
    }

    public void removePartitionResource(JobID jobID, int shuffleId, int partitionId) {
        JobShuffleResourceListener shuffleResourceListener = this.shuffleResourceListeners.get(jobID);
        if (shuffleResourceListener != null) {
            shuffleResourceListener.removePartitionResource(shuffleId, partitionId);
        }
    }

    public JobShuffleResourceListener getJobResourceListener(JobID jobID) {
        return this.shuffleResourceListeners.get(jobID);
    }

    public void unRegisterJob(JobID jobID) {
        this.shuffleResourceListeners.remove(jobID);
    }

    @Override
    public void notifyChangedWorkersStatus(WorkersStatus workersStatus) {
        try {
            List<WorkerInfo> unknownWorkers = workersStatus.unknownWorkers;
            if (unknownWorkers != null && !unknownWorkers.isEmpty()) {
                for (Map.Entry<JobID, JobShuffleResourceListener> entry : this.shuffleResourceListeners.entrySet()) {
                    HashSet partitionIds = new HashSet();
                    JobShuffleResourceListener shuffleResourceListener = entry.getValue();
                    for (Map.Entry<Integer, Map<Integer, ResultPartitionID>> mapEntry : shuffleResourceListener.getResultPartitionMap().entrySet()) {
                        int shuffleId = mapEntry.getKey();
                        if (mapEntry.getValue().isEmpty()) continue;
                        for (WorkerInfo unknownWorker : unknownWorkers) {
                            ShufflePartitionLocationInfo shufflePartitionLocationInfo;
                            Map<WorkerInfo, ShufflePartitionLocationInfo> shuffleAllocateInfo = this.lifecycleManager.workerSnapshots(shuffleId);
                            if (shuffleAllocateInfo == null || (shufflePartitionLocationInfo = shuffleAllocateInfo.get(unknownWorker)) == null) continue;
                            shufflePartitionLocationInfo.removeAndGetAllPrimaryPartitionIds().forEach(id -> {
                                ResultPartitionID resultPartitionId = shuffleResourceListener.removePartitionResource(shuffleId, (int)id);
                                if (resultPartitionId != null) {
                                    partitionIds.add(resultPartitionId);
                                }
                            });
                        }
                    }
                    shuffleResourceListener.notifyStopTrackingPartitions(partitionIds, 3);
                }
            }
        }
        catch (Throwable e) {
            LOG.error("Failed to handle unknown workers, message: {}.", (Object)e.getMessage(), (Object)e);
        }
    }

    public static class JobShuffleResourceListener {
        private final JobShuffleContext context;
        private final ExecutorService executorService;
        private Map<Integer, Map<Integer, ResultPartitionID>> resultPartitionMap = new ConcurrentHashMap<Integer, Map<Integer, ResultPartitionID>>();

        public JobShuffleResourceListener(JobShuffleContext jobShuffleContext, ExecutorService executorService) {
            this.context = jobShuffleContext;
            this.executorService = executorService;
        }

        public void addPartitionResource(int shuffleId, int partitionId, ResultPartitionID partitionID) {
            Map shufflePartitionMap = this.resultPartitionMap.computeIfAbsent(shuffleId, s -> new ConcurrentHashMap());
            shufflePartitionMap.put(partitionId, partitionID);
        }

        private void notifyStopTrackingPartitions(Set<ResultPartitionID> partitionIDS, int remainingRetries) {
            if (partitionIDS == null || partitionIDS.isEmpty()) {
                return;
            }
            LOG.info("jobId: {}, stop tracking partitions {}.", (Object)this.context.getJobId(), (Object)Arrays.toString(partitionIDS.toArray()));
            int count = remainingRetries - 1;
            try {
                CompletableFuture future = this.context.stopTrackingAndReleasePartitions(partitionIDS);
                future.whenCompleteAsync((ignored, throwable) -> {
                    if (throwable == null) {
                        return;
                    }
                    if (count == 0) {
                        LOG.error("jobId: {}, Failed to stop tracking partitions {}.", (Object)this.context.getJobId(), (Object)Arrays.toString(partitionIDS.toArray()));
                        return;
                    }
                    this.notifyStopTrackingPartitions(partitionIDS, count);
                }, (Executor)this.executorService);
            }
            catch (Throwable throwable2) {
                if (count == 0) {
                    LOG.error("jobId: {}, Failed to stop tracking partitions {}.", new Object[]{this.context.getJobId(), Arrays.toString(partitionIDS.toArray()), throwable2});
                    return;
                }
                this.notifyStopTrackingPartitions(partitionIDS, count);
            }
        }

        public Map<Integer, Map<Integer, ResultPartitionID>> getResultPartitionMap() {
            return this.resultPartitionMap;
        }

        public ResultPartitionID removePartitionResource(int shuffleId, int partitionId) {
            Map<Integer, ResultPartitionID> partitionIDMap = this.resultPartitionMap.get(shuffleId);
            if (partitionIDMap != null) {
                return partitionIDMap.remove(partitionId);
            }
            return null;
        }
    }
}

