/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.project.validator;

import org.apache.cayenne.access.DataDomain;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.conf.DriverDataSourceFactory;
import org.apache.cayenne.project.ProjectPath;
import org.apache.cayenne.project.validator.TreeNodeValidator;
import org.apache.cayenne.project.validator.Validator;
import org.apache.cayenne.util.Util;

public class DataNodeValidator
extends TreeNodeValidator {
    public void validateObject(ProjectPath path, Validator validator) {
        DataNode node = (DataNode)path.getObject();
        this.validateName(node, path, validator);
        this.validateConnection(node, path, validator);
    }

    protected void validateConnection(DataNode node, ProjectPath path, Validator validator) {
        String location;
        String factory = node.getDataSourceFactory();
        if (Util.isEmptyString(factory)) {
            validator.registerError("No DataSource factory.", path);
        } else if (!DriverDataSourceFactory.class.getName().equals(factory) && Util.isEmptyString(location = node.getDataSourceLocation())) {
            validator.registerError("DataNode has no location parameter.", path);
        }
    }

    protected void validateName(DataNode node, ProjectPath path, Validator validator) {
        String name = node.getName();
        if (Util.isEmptyString(name)) {
            validator.registerError("Unnamed DataNode.", path);
            return;
        }
        DataDomain domain = (DataDomain)path.getObjectParent();
        if (domain == null) {
            return;
        }
        for (DataNode otherNode : domain.getDataNodes()) {
            if (otherNode == node || !name.equals(otherNode.getName())) continue;
            validator.registerError("Duplicate DataNode name: " + name + ".", path);
            break;
        }
    }
}

