/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.map;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.event.EventManager;
import org.apache.cayenne.event.EventSubject;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbJoin;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.Relationship;
import org.apache.cayenne.map.event.RelationshipEvent;
import org.apache.cayenne.util.Util;
import org.apache.cayenne.util.XMLEncoder;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DbRelationship
extends Relationship {
    public static final EventSubject PROPERTY_DID_CHANGE = EventSubject.getSubject(DbRelationship.class, "PropertyDidChange");
    protected List<DbJoin> joins = new ArrayList<DbJoin>(2);
    protected boolean toDependentPK;

    public DbRelationship() {
    }

    public DbRelationship(String name) {
        super(name);
    }

    @Override
    public void encodeAsXML(XMLEncoder encoder) {
        encoder.print("<db-relationship name=\"");
        encoder.print(Util.encodeXmlAttribute(this.getName()));
        encoder.print("\" source=\"");
        encoder.print(Util.encodeXmlAttribute(this.getSourceEntity().getName()));
        if (this.getTargetEntityName() != null && this.getTargetEntity() != null) {
            encoder.print("\" target=\"");
            encoder.print(Util.encodeXmlAttribute(this.getTargetEntityName()));
        }
        if (this.isToDependentPK() && this.isValidForDepPk()) {
            encoder.print("\" toDependentPK=\"true");
        }
        encoder.print("\" toMany=\"");
        encoder.print(this.isToMany());
        encoder.println("\">");
        encoder.indent(1);
        encoder.print(this.getJoins());
        encoder.indent(-1);
        encoder.println("</db-relationship>");
    }

    @Override
    public Entity getTargetEntity() {
        String targetName = this.getTargetEntityName();
        if (targetName == null) {
            return null;
        }
        return this.getNonNullNamespace().getDbEntity(targetName);
    }

    public Collection<DbAttribute> getTargetAttributes() {
        if (this.joins.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        return CollectionUtils.collect(this.joins, (Transformer)JoinTransformers.targetExtractor);
    }

    public Collection<DbAttribute> getSourceAttributes() {
        if (this.joins.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        return CollectionUtils.collect(this.joins, (Transformer)JoinTransformers.sourceExtractor);
    }

    public DbRelationship createReverseRelationship() {
        DbEntity targetEntity = (DbEntity)this.getTargetEntity();
        DbRelationship reverse = new DbRelationship();
        reverse.setSourceEntity(targetEntity);
        reverse.setTargetEntityName(this.getSourceEntity().getName());
        if (this.isToDependentPK() && !this.toMany && this.joins.size() == targetEntity.getPrimaryKeys().size()) {
            reverse.setToMany(false);
        } else {
            reverse.setToMany(!this.toMany);
        }
        for (DbJoin join : this.joins) {
            DbJoin reverseJoin = join.createReverseJoin();
            reverseJoin.setRelationship(reverse);
            reverse.addJoin(reverseJoin);
        }
        return reverse;
    }

    public DbRelationship getReverseRelationship() {
        Entity target = this.getTargetEntity();
        if (target == null) {
            return null;
        }
        Entity src = this.getSourceEntity();
        if (target == src && this.joins.size() == 0) {
            return null;
        }
        TestJoin testJoin = new TestJoin(this);
        for (Relationship relationship : target.getRelationships()) {
            List<DbJoin> otherJoins;
            if (relationship.getTargetEntity() != src || (otherJoins = ((DbRelationship)relationship).getJoins()).size() != this.joins.size()) continue;
            boolean joinsMatch = true;
            for (DbJoin join : otherJoins) {
                testJoin.setSourceName(join.getTargetName());
                testJoin.setTargetName(join.getSourceName());
                if (this.joins.contains(testJoin)) continue;
                joinsMatch = false;
                break;
            }
            if (!joinsMatch) continue;
            return (DbRelationship)relationship;
        }
        return null;
    }

    public boolean isToPK() {
        for (DbJoin join : this.getJoins()) {
            DbAttribute target = join.getTarget();
            if (target == null) {
                return false;
            }
            if (!target.isPrimaryKey()) continue;
            return true;
        }
        return false;
    }

    public boolean isFromPK() {
        for (DbJoin join : this.getJoins()) {
            DbAttribute source = join.getSource();
            if (source == null) {
                return false;
            }
            if (!source.isPrimaryKey()) continue;
            return true;
        }
        return false;
    }

    public boolean isToMasterPK() {
        if (this.isToMany() || this.isToDependentPK()) {
            return false;
        }
        DbRelationship revRel = this.getReverseRelationship();
        return revRel != null ? revRel.isToDependentPK() : false;
    }

    public boolean isToDependentPK() {
        return this.toDependentPK;
    }

    public void setToDependentPK(boolean toDependentPK) {
        this.toDependentPK = toDependentPK;
    }

    public boolean isValidForDepPk() {
        if (this.getJoins().size() == 0) {
            return false;
        }
        for (DbJoin join : this.getJoins()) {
            DbAttribute target = join.getTarget();
            DbAttribute source = join.getSource();
            if ((target == null || target.isPrimaryKey()) && (source == null || source.isPrimaryKey())) continue;
            return false;
        }
        return true;
    }

    public List<DbJoin> getJoins() {
        return this.joins;
    }

    public void addJoin(DbJoin join) {
        if (join != null) {
            this.joins.add(join);
        }
    }

    public void removeJoin(DbJoin join) {
        this.joins.remove(join);
    }

    public void removeAllJoins() {
        this.joins.clear();
    }

    public void setJoins(Collection<DbJoin> newJoins) {
        this.removeAllJoins();
        if (newJoins != null) {
            this.joins.addAll(newJoins);
        }
    }

    public Map<String, Object> targetPkSnapshotWithSrcSnapshot(Map<String, Object> srcSnapshot) {
        Map<String, Object> idMap;
        if (this.isToMany()) {
            throw new CayenneRuntimeException("Only 'to one' relationships support this method.");
        }
        int numJoins = this.joins.size();
        int foundNulls = 0;
        if (numJoins == 1) {
            DbJoin join = this.joins.get(0);
            Object val = srcSnapshot.get(join.getSourceName());
            if (val == null) {
                ++foundNulls;
                idMap = Collections.EMPTY_MAP;
            } else {
                idMap = Collections.singletonMap(join.getTargetName(), val);
            }
        } else {
            idMap = new HashMap<String, Object>(numJoins * 2);
            for (int i = 0; i < numJoins; ++i) {
                DbJoin join = this.joins.get(i);
                DbAttribute source = join.getSource();
                Object val = srcSnapshot.get(join.getSourceName());
                if (val == null) {
                    if (!source.isMandatory()) {
                        return null;
                    }
                    ++foundNulls;
                    continue;
                }
                idMap.put(join.getTargetName(), val);
            }
        }
        if (foundNulls == 0) {
            return idMap;
        }
        if (foundNulls == numJoins) {
            return null;
        }
        throw new CayenneRuntimeException("Some parts of FK are missing in snapshot, relationship: " + this);
    }

    private Map<String, Object> srcSnapshotWithTargetSnapshot(Map<String, Object> targetSnapshot) {
        int len = this.joins.size();
        if (len == 1) {
            DbJoin join = this.joins.get(0);
            Object val = targetSnapshot.get(join.getTargetName());
            return Collections.singletonMap(join.getSourceName(), val);
        }
        HashMap<String, Object> idMap = new HashMap<String, Object>(len * 2);
        for (int i = 0; i < len; ++i) {
            DbJoin join = this.joins.get(i);
            Object val = targetSnapshot.get(join.getTargetName());
            idMap.put(join.getSourceName(), val);
        }
        return idMap;
    }

    public Map<String, Object> srcFkSnapshotWithTargetSnapshot(Map<String, Object> targetSnapshot) {
        if (this.isToMany()) {
            throw new CayenneRuntimeException("Only 'to one' relationships support this method.");
        }
        return this.srcSnapshotWithTargetSnapshot(targetSnapshot);
    }

    public Map<String, Object> srcPkSnapshotWithTargetSnapshot(Map<String, Object> targetSnapshot) {
        if (!this.isToMany()) {
            throw new CayenneRuntimeException("Only 'to many' relationships support this method.");
        }
        return this.srcSnapshotWithTargetSnapshot(targetSnapshot);
    }

    public void setToMany(boolean toMany) {
        this.toMany = toMany;
    }

    protected void firePropertyDidChange() {
        RelationshipEvent event = new RelationshipEvent((Object)this, this, this.getSourceEntity());
        EventManager.getDefaultManager().postEvent(event, PROPERTY_DID_CHANGE);
    }

    static final class TestJoin
    extends DbJoin {
        TestJoin(DbRelationship relationship) {
            super(relationship);
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (o == this) {
                return true;
            }
            if (!(o instanceof DbJoin)) {
                return false;
            }
            DbJoin j = (DbJoin)o;
            return j.relationship == this.relationship && Util.nullSafeEquals(j.sourceName, this.sourceName) && Util.nullSafeEquals(j.targetName, this.targetName);
        }
    }

    static final class JoinTransformers {
        static final Transformer targetExtractor = new Transformer(){

            public Object transform(Object input) {
                return input instanceof DbJoin ? ((DbJoin)input).getTarget() : input;
            }
        };
        static final Transformer sourceExtractor = new Transformer(){

            public Object transform(Object input) {
                return input instanceof DbJoin ? ((DbJoin)input).getSource() : input;
            }
        };

        JoinTransformers() {
        }
    }
}

