/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.select;

import java.sql.ResultSet;
import java.util.List;
import org.apache.cayenne.CayenneException;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.access.select.EntitySelectColumn;
import org.apache.cayenne.access.select.RowReader;
import org.apache.cayenne.access.types.ExtendedType;
import org.apache.cayenne.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class EntityRowReader
implements RowReader<Object> {
    private EntityRowReader superReader;
    private ExtendedType[] converters;
    private String[] dataRowKeys;
    private int[] jdbcTypes;
    private int[] columnIndexes;
    private String entityName;
    private int mapCapacity;

    EntityRowReader(String entityName, List<EntitySelectColumn> columns) {
        int len = columns.size();
        int[] columnIndexes = new int[len];
        for (int i = 0; i < len; ++i) {
            columnIndexes[i] = i + 1;
        }
        this.init(entityName, columns, columnIndexes);
    }

    EntityRowReader(String entityName, List<EntitySelectColumn> columns, int[] columnIndexes) {
        this.init(entityName, columns, columnIndexes);
    }

    private void init(String entityName, List<EntitySelectColumn> columns, int[] columnIndexes) {
        this.entityName = entityName;
        int len = columns.size();
        this.mapCapacity = (int)Math.ceil((double)len / 0.75);
        this.converters = new ExtendedType[len];
        this.dataRowKeys = new String[len];
        this.jdbcTypes = new int[len];
        this.columnIndexes = columnIndexes;
        for (int i = 0; i < len; ++i) {
            this.converters[i] = columns.get(i).getConverter();
            this.dataRowKeys[i] = columns.get(i).getDataRowKey();
            this.jdbcTypes[i] = columns.get(i).getJdbcType();
        }
    }

    void setSuperReader(EntityRowReader superReader) {
        this.superReader = superReader;
        if (superReader != null) {
            this.mapCapacity += superReader.mapCapacity;
        }
    }

    @Override
    public void setColumnOffset(int offset) {
        for (int i = 0; i < this.columnIndexes.length; ++i) {
            this.columnIndexes[i] = this.columnIndexes[i] + offset;
        }
    }

    @Override
    public Object readRow(ResultSet resultSet) throws CayenneException {
        DataRow row = new DataRow(this.mapCapacity);
        row.setEntityName(this.entityName);
        this.fillRow(resultSet, row);
        return row;
    }

    private final void fillRow(ResultSet resultSet, DataRow row) throws CayenneException {
        if (this.superReader != null) {
            this.superReader.fillRow(resultSet, row);
        }
        int len = this.converters.length;
        try {
            for (int i = 0; i < len; ++i) {
                Object value = this.converters[i].materializeObject(resultSet, this.columnIndexes[i], this.jdbcTypes[i]);
                row.put(this.dataRowKeys[i], value);
            }
        }
        catch (CayenneException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new CayenneException("Exception materializing row", Util.unwindException(ex));
        }
    }
}

