/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.oracle;

import java.io.OutputStream;
import java.io.Writer;
import java.lang.reflect.Method;
import java.sql.Blob;
import java.sql.Clob;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.dba.oracle.Oracle8Adapter;
import org.apache.cayenne.dba.oracle.OracleAdapter;
import org.apache.cayenne.dba.oracle.OracleLOBBatchAction;
import org.apache.cayenne.query.BatchQuery;
import org.apache.cayenne.util.Util;

class Oracle8LOBBatchAction
extends OracleLOBBatchAction {
    Oracle8LOBBatchAction(BatchQuery query, DbAdapter adapter) {
        super(query, adapter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeBlob(Blob blob, byte[] value) {
        Method getBinaryStreamMethod = Oracle8Adapter.getOutputStreamFromBlobMethod();
        try {
            OutputStream out = (OutputStream)getBinaryStreamMethod.invoke((Object)blob, (Object[])null);
            try {
                out.write(value);
                out.flush();
            }
            finally {
                out.close();
            }
        }
        catch (Exception e) {
            throw new CayenneRuntimeException("Error processing BLOB.", Util.unwindException(e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeClob(Clob clob, char[] value) {
        Method getWriterMethod = OracleAdapter.getWriterFromClobMethod();
        try {
            Writer out = (Writer)getWriterMethod.invoke((Object)clob, (Object[])null);
            try {
                out.write(value);
                out.flush();
            }
            finally {
                out.close();
            }
        }
        catch (Exception e) {
            throw new CayenneRuntimeException("Error processing CLOB.", Util.unwindException(e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeClob(Clob clob, String value) {
        Method getWriterMethod = OracleAdapter.getWriterFromClobMethod();
        try {
            Writer out = (Writer)getWriterMethod.invoke((Object)clob, (Object[])null);
            try {
                out.write(value);
                out.flush();
            }
            finally {
                out.close();
            }
        }
        catch (Exception e) {
            throw new CayenneRuntimeException("Error processing CLOB.", Util.unwindException(e));
        }
    }
}

