/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.types;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.apache.cayenne.access.types.ExtendedType;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.util.ToStringBuilder;
import org.apache.cayenne.validation.BeanValidationFailure;
import org.apache.cayenne.validation.ValidationResult;

public abstract class AbstractType
implements ExtendedType {
    public static boolean validateNull(Object source, String property, Object value, DbAttribute dbAttribute, ValidationResult validationResult) {
        if (dbAttribute.isMandatory() && value == null) {
            validationResult.addFailure(new BeanValidationFailure(source, property, "'" + property + "' must be not null"));
            return false;
        }
        return true;
    }

    public void setJdbcObject(PreparedStatement st, Object val, int pos, int type, int scale) throws Exception {
        if (scale != -1) {
            st.setObject(pos, val, type, scale);
        } else {
            st.setObject(pos, val, type);
        }
    }

    public abstract String getClassName();

    public abstract Object materializeObject(CallableStatement var1, int var2, int var3) throws Exception;

    public abstract Object materializeObject(ResultSet var1, int var2, int var3) throws Exception;

    public boolean validateProperty(Object source, String property, Object value, DbAttribute dbAttribute, ValidationResult validationResult) {
        return true;
    }

    public String toString() {
        return new ToStringBuilder(this).append("className", this.getClassName()).toString();
    }
}

