/*
 * Decompiled with CFR 0.152.
 */
package org.scopemvc.controller.swing;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRootPane;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.scopemvc.controller.basic.ViewContext;
import org.scopemvc.core.View;
import org.scopemvc.util.ResourceLoader;
import org.scopemvc.util.ScopeConfig;
import org.scopemvc.view.awt.AWTUtilities;
import org.scopemvc.view.swing.SMenuItem;
import org.scopemvc.view.swing.SwingUtil;
import org.scopemvc.view.swing.SwingView;

public class SwingContext
extends ViewContext {
    public static final String PROGRESS_START_DELAY_PROPERTY = "org.scopemvc.controller.swing.SwingContext.progress_start_delay";
    private static final Log LOG = LogFactory.getLog(class$org$scopemvc$controller$swing$SwingContext == null ? (class$org$scopemvc$controller$swing$SwingContext = SwingContext.class$("org.scopemvc.controller.swing.SwingContext")) : class$org$scopemvc$controller$swing$SwingContext);
    private static final long PROGRESS_START_DELAY = ScopeConfig.getInteger("org.scopemvc.controller.swing.SwingContext.progress_start_delay").longValue();
    private Frame sharedNullFrame;
    private LinkedList rootpanes = new LinkedList();
    private Timer progressStartTimer = new Timer(true);
    private TimerTask task;
    static /* synthetic */ Class class$org$scopemvc$controller$swing$SwingContext;

    protected static SMenuItem findMenuItemInMenu(JMenu jMenu, String string) {
        if (string == null) {
            throw new IllegalArgumentException("ControlID is null");
        }
        int n = 0;
        while (n < jMenu.getItemCount()) {
            JMenuItem jMenuItem = jMenu.getItem(n);
            if (jMenuItem instanceof JMenu) {
                SMenuItem sMenuItem = SwingContext.findMenuItemInMenu((JMenu)jMenuItem, string);
                if (sMenuItem != null) {
                    return sMenuItem;
                }
            } else if (jMenuItem instanceof SMenuItem && string.equals(((SMenuItem)jMenuItem).getControlID())) {
                return (SMenuItem)jMenuItem;
            }
            ++n;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JRootPane getFocussedRootPane() {
        LinkedList linkedList = this.rootpanes;
        synchronized (linkedList) {
            Iterator iterator = this.rootpanes.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                JRootPane jRootPane = (JRootPane)e;
                Container container = jRootPane.getParent();
                if (!this.isFocusOwner((Window)container)) continue;
                return jRootPane;
            }
        }
        return null;
    }

    public void showView(View view) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("showView: " + view);
        }
        if (!(view instanceof SwingView)) {
            throw new IllegalArgumentException("Can only show SwingViews: " + view);
        }
        Container container = this.getTopmostContainer((SwingView)view);
        if (!(container instanceof SwingView)) {
            throw new IllegalArgumentException("Can only show SwingViews: " + container);
        }
        SwingView swingView = (SwingView)container;
        JRootPane jRootPane = this.findRootPaneFor(swingView);
        if (jRootPane != null) {
            Container container2 = jRootPane.getParent();
            jRootPane.setDefaultButton(swingView.getDefaultButton());
            ((Window)container2).toFront();
            return;
        }
        if (swingView.getDisplayMode() == 0) {
            this.showViewInPrimaryWindow(swingView);
        } else {
            this.showViewInDialog(swingView);
        }
    }

    public void hideView(View view) {
        if (!(view instanceof SwingView)) {
            throw new IllegalArgumentException("Can only hide SwingViews: " + view);
        }
        Container container = this.getTopmostContainer((SwingView)view);
        if (!(container instanceof SwingView)) {
            throw new IllegalArgumentException("Can only hide SwingViews: " + container);
        }
        SwingView swingView = (SwingView)container;
        JRootPane jRootPane = this.findRootPaneFor(swingView);
        if (jRootPane == null) {
            LOG.warn("Found no root pane for view " + swingView + ". View has not been shown");
            return;
        }
        swingView.setViewBounds(jRootPane.getParent().getBounds());
        this.hideRootPane(jRootPane);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hideAllViews() {
        LinkedList linkedList = this.rootpanes;
        synchronized (linkedList) {
            while (!this.rootpanes.isEmpty()) {
                JRootPane jRootPane = (JRootPane)this.rootpanes.getLast();
                this.hideRootPane(jRootPane);
            }
        }
    }

    public boolean areAllViewsClosed() {
        return this.rootpanes.size() < 1;
    }

    public void showError(final String string, final String string2) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("showError: " + string + ", " + string2);
        }
        SwingUtil.runFromSwingEventThread(new Runnable(){

            public void run() {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("showError: " + string);
                }
                JOptionPane.showMessageDialog(SwingContext.this.getFocussedRootPane(), string2, string, 0);
            }
        });
    }

    public void showMessage(final String string, final String string2) {
        SwingUtil.runFromSwingEventThread(new Runnable(){

            public void run() {
                JOptionPane.showMessageDialog(SwingContext.this.getFocussedRootPane(), string2, string, 1);
            }
        });
    }

    public void exit() {
        this.hideAllViews();
        System.exit(0);
    }

    public void startProgress() {
        if (this.task != null) {
            this.task.cancel();
        }
        this.task = new TimerTask(){

            public void run() {
                SwingContext.this.getDefaultParentWindow().setCursor(Cursor.getPredefinedCursor(3));
            }
        };
        this.progressStartTimer.schedule(this.task, PROGRESS_START_DELAY);
    }

    public void stopProgress() {
        if (this.task != null) {
            this.task.cancel();
        }
        this.getDefaultParentWindow().setCursor(Cursor.getPredefinedCursor(0));
    }

    public void hookMenuItem(SwingView swingView, String string, boolean bl) {
        SMenuItem sMenuItem = this.findMenuItem(swingView, string);
        if (sMenuItem == null) {
            LOG.error("Can't find menuitem for: " + string, new Throwable());
            return;
        }
        sMenuItem.setOwner(swingView);
        sMenuItem.setEnabled(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JRootPane findRootPaneFor(View view) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("findRootPaneFor: " + view);
        }
        LinkedList linkedList = this.rootpanes;
        synchronized (linkedList) {
            Iterator iterator = this.rootpanes.iterator();
            while (iterator.hasNext()) {
                JRootPane jRootPane;
                Object e = iterator.next();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("findRootPaneFor: looking at: " + e);
                }
                if (!(jRootPane = (JRootPane)e).isAncestorOf((JComponent)((Object)view))) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("findRootPaneFor: got it");
                }
                return jRootPane;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("findRootPaneFor: not found");
        }
        return null;
    }

    protected Frame getSharedNullFrame() {
        block2: {
            if (this.sharedNullFrame != null) break block2;
            try {
                this.sharedNullFrame = new NullFrame();
                this.sharedNullFrame.setIconImage(this.getDefaultWindowIcon());
                AWTUtilities.centreOnScreen(this.sharedNullFrame);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {}
        }
        return this.sharedNullFrame;
    }

    protected Image getDefaultWindowIcon() {
        String string = ScopeConfig.getString("org.scopemvc.controller.swing.SwingContext.window_icon");
        if (string == null || string.length() < 1) {
            return null;
        }
        try {
            return ResourceLoader.getImage(string);
        }
        catch (RuntimeException runtimeException) {
            LOG.warn("getDefaultWindowIconPath: (" + string + ")", runtimeException);
            return null;
        }
    }

    protected boolean isFocusOwner(Window window) {
        if (window.getFocusOwner() != null) {
            return true;
        }
        Window[] windowArray = window.getOwnedWindows();
        if (windowArray == null) {
            return false;
        }
        int n = 0;
        while (n < windowArray.length) {
            Window window2 = windowArray[n];
            if (!(window2 instanceof Dialog) && !(window2 instanceof Frame) && this.isFocusOwner(window2)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    protected Window getDefaultParentWindow() {
        JRootPane jRootPane = this.getFocussedRootPane();
        if (jRootPane != null) {
            Container container = jRootPane.getParent();
            return (Window)container;
        }
        if (this.rootpanes.size() == 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("null frame");
            }
            return this.getSharedNullFrame();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("last shown frame: " + (Window)((JRootPane)this.rootpanes.getLast()).getParent());
        }
        return (Window)((JRootPane)this.rootpanes.getLast()).getParent();
    }

    protected Container getTopmostContainer(SwingView swingView) {
        Container container = null;
        JRootPane jRootPane = swingView.getRootPane();
        if (jRootPane != null) {
            container = jRootPane.getContentPane();
        }
        Container container2 = swingView;
        while (container2.getParent() != null && container2.getParent() != container) {
            container2 = container2.getParent();
        }
        return container2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setupWindow(JRootPane jRootPane, SwingView swingView, boolean bl) {
        Container container = jRootPane.getParent();
        final Window window = (Window)container;
        LinkedList linkedList = this.rootpanes;
        synchronized (linkedList) {
            this.rootpanes.add(jRootPane);
        }
        jRootPane.getContentPane().setLayout(new BorderLayout());
        jRootPane.getContentPane().add("Center", swingView);
        jRootPane.setJMenuBar(swingView.getMenuBar());
        jRootPane.setDefaultButton(swingView.getDefaultButton());
        Rectangle rectangle = swingView.getViewBounds();
        if (rectangle == null) {
            window.pack();
            if (bl) {
                AWTUtilities.centreOnWindow((Window)window.getParent(), window);
            }
        } else if (rectangle == SwingView.CENTRED) {
            window.pack();
            AWTUtilities.centreOnScreen(window);
        } else {
            window.setBounds(rectangle);
        }
        AWTUtilities.fitOnScreen(window);
        window.addWindowListener(new WindowCloser(swingView));
        if (window instanceof JFrame) {
            ((JFrame)window).setDefaultCloseOperation(0);
        } else if (window instanceof JDialog) {
            ((JDialog)window).setDefaultCloseOperation(0);
        }
        SwingUtil.runFromSwingEventThread(new Runnable(){

            public void run() {
                window.setVisible(true);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void hideRootPane(JRootPane jRootPane) {
        LinkedList linkedList = this.rootpanes;
        synchronized (linkedList) {
            this.rootpanes.remove(jRootPane);
        }
        Container container = jRootPane.getParent();
        if (container == this.sharedNullFrame) {
            this.sharedNullFrame = null;
        }
        this.hideWindow((Window)container);
        if (this.areAllViewsClosed() && this.sharedNullFrame != null) {
            this.hideWindow(this.sharedNullFrame);
            this.sharedNullFrame = null;
        }
    }

    protected void hideWindow(final Window window) {
        SwingUtil.runFromSwingEventThread(new Runnable(){

            public void run() {
                window.dispose();
            }
        });
    }

    protected void showViewInDialog(SwingView swingView) {
        Window window = this.getDefaultParentWindow();
        JDialog jDialog = window instanceof Dialog ? new JDialog((Dialog)window) : new JDialog((Frame)window);
        if (swingView.getTitle() != null) {
            jDialog.setTitle(swingView.getTitle());
        }
        if (swingView.getDisplayMode() == 1) {
            jDialog.setModal(true);
        } else {
            jDialog.setModal(false);
        }
        jDialog.setResizable(swingView.isResizable());
        this.setupWindow(jDialog.getRootPane(), swingView, true);
    }

    protected void showViewInPrimaryWindow(SwingView swingView) {
        Image image;
        JFrame jFrame = new JFrame();
        if (swingView.getTitle() != null) {
            jFrame.setTitle(swingView.getTitle());
        }
        if ((image = this.getDefaultWindowIcon()) != null) {
            jFrame.setIconImage(image);
        }
        jFrame.setResizable(swingView.isResizable());
        this.setupWindow(jFrame.getRootPane(), swingView, false);
    }

    protected void unhookMenuItemImpl(String string, SwingView swingView) {
        SMenuItem sMenuItem = this.findMenuItem(swingView, string);
        if (sMenuItem == null) {
            LOG.error("Can't find menuitem for: " + string, new Throwable());
            return;
        }
        sMenuItem.unsetOwner(swingView);
    }

    protected SMenuItem findMenuItem(SwingView swingView, String string) {
        JRootPane jRootPane = this.findRootPaneFor(swingView);
        if (jRootPane == null) {
            return null;
        }
        JMenuBar jMenuBar = jRootPane.getJMenuBar();
        if (jMenuBar == null) {
            return null;
        }
        int n = 0;
        while (n < jMenuBar.getMenuCount()) {
            JMenu jMenu = jMenuBar.getMenu(n);
            SMenuItem sMenuItem = SwingContext.findMenuItemInMenu(jMenu, string);
            if (sMenuItem != null) {
                return sMenuItem;
            }
            ++n;
        }
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class WindowCloser
    extends WindowAdapter {
        private SwingView view;

        WindowCloser(SwingView swingView) {
            this.view = swingView;
        }

        public void windowClosing(WindowEvent windowEvent) {
            this.view.issueControl(this.view.getCloseControl());
        }
    }

    static class NullFrame
    extends Frame {
        NullFrame() {
        }

        public void setVisible(boolean bl) {
        }
    }
}

