/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.runtime;

import java.util.Collection;
import java.util.Objects;
import javax.sql.DataSource;
import org.apache.cayenne.DataChannel;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.access.DataDomain;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.configuration.ObjectContextFactory;
import org.apache.cayenne.di.BeforeScopeEnd;
import org.apache.cayenne.di.DIBootstrap;
import org.apache.cayenne.di.Injector;
import org.apache.cayenne.di.Module;
import org.apache.cayenne.runtime.CayenneRuntimeBuilder;
import org.apache.cayenne.tx.TransactionDescriptor;
import org.apache.cayenne.tx.TransactionListener;
import org.apache.cayenne.tx.TransactionManager;
import org.apache.cayenne.tx.TransactionalOperation;

public class CayenneRuntime {
    protected static final ThreadLocal<Injector> threadInjector = new ThreadLocal();
    protected final Injector injector;
    protected final Collection<Module> modules;

    public static void bindThreadInjector(Injector injector) {
        threadInjector.set(injector);
    }

    public static Injector getThreadInjector() {
        return threadInjector.get();
    }

    public static CayenneRuntimeBuilder builder() {
        return new CayenneRuntimeBuilder(null);
    }

    public static CayenneRuntimeBuilder builder(String name) {
        return new CayenneRuntimeBuilder(name);
    }

    protected CayenneRuntime(Collection<Module> modules) {
        this.modules = Objects.requireNonNull(modules);
        this.injector = DIBootstrap.createInjector(modules);
    }

    public <T> T performInTransaction(TransactionalOperation<T> op) {
        TransactionManager tm = this.injector.getInstance(TransactionManager.class);
        return tm.performInTransaction(op);
    }

    public <T> T performInTransaction(TransactionalOperation<T> op, TransactionListener callback) {
        TransactionManager tm = this.injector.getInstance(TransactionManager.class);
        return tm.performInTransaction(op, callback);
    }

    public <T> T performInTransaction(TransactionalOperation<T> op, TransactionDescriptor descriptor) {
        TransactionManager tm = this.injector.getInstance(TransactionManager.class);
        return tm.performInTransaction(op, descriptor);
    }

    public <T> T performInTransaction(TransactionalOperation<T> op, TransactionListener callback, TransactionDescriptor descriptor) {
        TransactionManager tm = this.injector.getInstance(TransactionManager.class);
        return tm.performInTransaction(op, callback, descriptor);
    }

    public DataDomain getDataDomain() {
        return this.injector.getInstance(DataDomain.class);
    }

    public DataSource getDataSource() {
        DataDomain domain = this.getDataDomain();
        DataNode defaultNode = domain.getDefaultNode();
        if (defaultNode == null) {
            int s = domain.getDataNodes().size();
            if (s == 0) {
                throw new IllegalStateException("No DataSources configured");
            }
            throw new IllegalArgumentException("No default DataSource configured. You can get explicitly named DataSource by using 'getDataSource(String)'");
        }
        return defaultNode.getDataSource();
    }

    public DataSource getDataSource(String dataNodeName) {
        DataDomain domain = this.getDataDomain();
        if (dataNodeName == null) {
            return this.getDataSource();
        }
        DataNode node = domain.getDataNode(dataNodeName);
        if (node == null) {
            throw new IllegalArgumentException("Unknown DataNode name: " + dataNodeName);
        }
        return node.getDataSource();
    }

    public Collection<Module> getModules() {
        return this.modules;
    }

    public Injector getInjector() {
        return this.injector;
    }

    @BeforeScopeEnd
    public void shutdown() {
        this.injector.shutdown();
    }

    public DataChannel getChannel() {
        return this.injector.getInstance(DataChannel.class);
    }

    public ObjectContext newContext() {
        return this.injector.getInstance(ObjectContextFactory.class).createContext();
    }

    public ObjectContext newContext(DataChannel parentChannel) {
        return this.injector.getInstance(ObjectContextFactory.class).createContext(parentChannel);
    }
}

